/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: cluster.h
 *
 */

/* Global data exported by cluster.c */

extern uint           num_config_nodes;
extern ece_nodeid_t * config_nodes;
extern node_list_t  * config_node_names;
extern ece_event_t  * membership;

extern ece_clusterid_t clusterid;
extern ece_nodeid_t  * my_nodeid;


/* External APIs provided by cluster.c */

int evms_get_node_list(node_search_flags_t flags,
		       node_list_t     * * node_list);

int evms_set_current_node(char * new_node_name);

/* Internal functions to share with other Engine source modules */

extern const char * nodeid_to_string(const ece_nodeid_t * node);

extern int engine_get_node_list(node_search_flags_t   flags,
				const node_list_t * * node_list);

extern int connect_to_ece(void);

extern int disconnect_from_ece(void);

