/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libbsd.so
 *
 *   File: bsd_plugin.h
 */

#ifndef   _BSD_HEADERS_
#define   _BSD_HEADER_ 1

//
// BSD Disk Private Data Area
//
#define  BSD_DISK_PDATA_SIGNATURE          0x42442D4B   /* BDSK */

#define  DISK_HAS_CHANGES_PENDING          0x00000001
#define  DISK_HAS_MOVE_PENDING             0x00000002

typedef struct disk_private_data_s {

        u_int32_t          signature;           /* used to validate disk private data area           */
        
        u_int32_t          flags;               /* see DISK_HAS_xxxx flags above                     */

        u_int32_t          vsectors_per_block;  /* disk hardsector size >> EVMS_VSECTOR_SIZE         */

        copy_job_t        *copy_job;            /* ptr to valid copy job if a segment move is in */
                                                /* progress ... DISK_HAS_MOVE_PENDING should be */
                                                /* set if this is the case.                     */

} disk_private_data_t; 


//
// BSD Segment Private Data Area
//
#define  BSD_SEGMENT_PDATA_SIGNATURE       0x422D4547   /* BSEG */
#define  SEG_CFLAG_TOP_SEGMENT             0x00000001

#include "bsd_disklabel.h"

typedef struct seg_private_data_s {

        u_int32_t          signature;           /* used to validate our private data area            */

        u_int32_t          cflags;              /* common flag definitions                           */

        //----------------- end of segment manager common area  -----------------------

        storage_object_t  *logical_disk;        /* storage object we found the bsd partitions on     */

        bsd_partition_t    p_record;            /* bsd partition record we read off the disk label   */                                         

        u_int32_t          minor;               /* minor number assigned to this segment             */
    
        DISKSEG           *move_target;         /* used when moving segments on the disk                       */

} seg_private_data_t;


extern struct engine_functions_s       *EngFncs;
extern plugin_record_t                 *bsd_plugin;

#define my_plugin_record                bsd_plugin
#define EngFncs                         EngFncs

#include "disks.h"
#include "helpers.h"
#include "commit.h"
#include "options.h"
#include "discovery.h"
#include "segments.h"
#include "dm.h"

#endif

