# EVMS_SELECT_PLUGINS
#
# By default, all EVMS plugins are built. Each one can be individually
# disabled by the user with a "--disable-plugin" argument to ./configure
# This macro determines which plugins to enable, and checks any additional
# dependencies that each plugin might have. The final result of this macro
# is a $plugin_dirs variable that is used by the plugins/Makefile.am to
# decide which plugin directories to process.

AC_DEFUN([EVMS_SELECT_PLUGINS],[
AC_MSG_NOTICE([checking which EVMS plugins to build:])

# Check if the user wants to disable any plugins
AC_ARG_ENABLE([disk],
	      AC_HELP_STRING([--disable-disk],
			     [Disable the local disk manager]),
	      [build_disk="$enableval"],
	      [build_disk="yes"])
AC_ARG_ENABLE([dos],
	      AC_HELP_STRING([--disable-dos],
			     [Disable the DOS segment manager]),
	      [build_dos="$enableval"],
	      [build_dos="yes"])
AC_ARG_ENABLE([gpt],
	      AC_HELP_STRING([--disable-gpt],
			     [Disable the GPT segment manager]),
	      [build_gpt="$enableval"],
	      [build_gpt="yes"])
AC_ARG_ENABLE([s390],
	      AC_HELP_STRING([--disable-s390],
			     [Disable the S/390 segment manager]),
	      [build_s390="$enableval"],
	      [build_s390="yes"])
AC_ARG_ENABLE([bbr-seg],
	      AC_HELP_STRING([--disable-bbr-seg],
			     [Disable the BBR segment manager]),
	      [build_bbr_seg="$enableval"],
	      [build_bbr_seg="yes"])
AC_ARG_ENABLE([bsd],
	      AC_HELP_STRING([--disable-bsd],
			     [Disable the BSD segment manager]),
	      [build_bsd="$enableval"],
	      [build_bsd="yes"])
AC_ARG_ENABLE([mac],
	      AC_HELP_STRING([--disable-mac],
			     [Disable the Macintosh segment manager]),
	      [build_mac="$enableval"],
	      [build_mac="yes"])
AC_ARG_ENABLE([csm],
	      AC_HELP_STRING([--disable-csm],
			     [Disable the Cluster segment manager]),
	      [build_csm="$enableval"],
	      [build_csm="yes"])
AC_ARG_ENABLE([multipath],
	      AC_HELP_STRING([--disable-multipath],
			     [Disable the Multipath segment manager]),
	      [build_multipath="$enableval"],
	      [build_multipath="yes"])
AC_ARG_ENABLE([lvm],
	      AC_HELP_STRING([--disable-lvm],
			     [Disable the LVM plugin]),
	      [build_lvm="$enableval"],
	      [build_lvm="yes"])
AC_ARG_ENABLE([lvm2],
	      AC_HELP_STRING([--disable-lvm2],
			     [Disable the LVM2 plugin]),
	      [build_lvm2="$enableval"],
	      [build_lvm2="yes"])
AC_ARG_ENABLE([md],
	      AC_HELP_STRING([--disable-md],
			     [Disable the MD/Software-RAID plugin]),
	      [build_md="$enableval"],
	      [build_md="yes"])
AC_ARG_ENABLE([drivelink],
	      AC_HELP_STRING([--disable-drivelink],
			     [Disable the DriveLinking plugin]),
	      [build_drivelink="$enableval"],
	      [build_drivelink="yes"])
AC_ARG_ENABLE([bbr],
	      AC_HELP_STRING([--disable-bbr],
			     [Disable the BBR feature plugin]),
	      [build_bbr="$enableval"],
	      [build_bbr="yes"])
AC_ARG_ENABLE([snapshot],
	      AC_HELP_STRING([--disable-snapshot],
			     [Disable the Snapshot plugin]),
	      [build_snapshot="$enableval"],
	      [build_snapshot="yes"])
AC_ARG_ENABLE([error],
	      AC_HELP_STRING([--disable-error],
			     [Disable the Error plugin]),
	      [build_error="$enableval"],
	      [build_error="yes"])
AC_ARG_ENABLE([ext2],
	      AC_HELP_STRING([--disable-ext2],
			     [Disable the Ext2/3 FSIM]),
	      [build_ext2="$enableval"],
	      [build_ext2="yes"])
AC_ARG_ENABLE([jfs],
	      AC_HELP_STRING([--disable-jfs],
			     [Disable the JFS FSIM]),
	      [build_jfs="$enableval"],
	      [build_jfs="yes"])
AC_ARG_ENABLE([ntfs],
	      AC_HELP_STRING([--disable-ntfs],
			     [Disable the NTFS FSIM]),
	      [build_ntfs="$enableval"],
	      [build_ntfs="yes"])
AC_ARG_ENABLE([ogfs],
	      AC_HELP_STRING([--disable-ogfs],
			     [Disable the OpenGFS FSIM]),
	      [build_ogfs="$enableval"],
	      [build_ogfs="yes"])
AC_ARG_ENABLE([reiser],
	      AC_HELP_STRING([--disable-reiser],
			     [Disable the ReiserFS FSIM]),
	      [build_reiser="$enableval"],
	      [build_reiser="yes"])
AC_ARG_ENABLE([xfs],
	      AC_HELP_STRING([--disable-xfs],
			     [Disable the XFS FSIM]),
	      [build_xfs="$enableval"],
	      [build_xfs="yes"])
AC_ARG_ENABLE([swap],
	      AC_HELP_STRING([--disable-swap],
			     [Disable the Swap FSIM]),
	      [build_swap="$enableval"],
	      [build_swap="yes"])
AC_ARG_ENABLE([replace],
	      AC_HELP_STRING([--disable-replace],
			     [Disable the Replace plugin]),
	      [build_replace="$enableval"],
	      [build_replace="yes"])
AC_ARG_ENABLE([ha],
	      AC_HELP_STRING([--disable-ha],
			     [Disable the HA plugin]),
	      [build_ha="$enableval"],
	      [build_ha="yes"])
AC_ARG_ENABLE([rsct],
	      AC_HELP_STRING([--disable-rsct],
			     [Disable the RSCT plugin]),
	      [build_rsct="$enableval"],
	      [build_rsct="yes"])

# Create the list of plugin directories to build. This is where each plugin
# can specify its dependencies.
plugin_dirs=""
plugin_distdirs="bbr bbr_seg bsd csm disk dos drivelink error ext2 gpt ha jfs lvm lvm2 mac md multipath ntfs ogfs reiser replace rsct s390 snapshot swap xfs"

# BBR
if test "$build_bbr" = "no"; then
	AC_MSG_NOTICE([     not building bbr ... disabled by user])
else
	plugin_dirs="$plugin_dirs bbr"
	AC_MSG_NOTICE([     building bbr])
fi

# BSD
if test "$build_bsd" = "no"; then
	AC_MSG_NOTICE([     not building bsd ... disabled by user])
else
	plugin_dirs="$plugin_dirs bsd"
	AC_MSG_NOTICE([     building bsd])
fi

# BBR Seg.
if test "$build_bbr_seg" = "no"; then
	AC_MSG_NOTICE([     not building bbr_seg ... disabled by user])
elif test "$have_uuid" = "no"; then
	AC_MSG_NOTICE([     not building bbr_seg ... requires uuid library])
else
	plugin_dirs="$plugin_dirs bbr_seg"
	AC_MSG_NOTICE([     building bbr_seg])
fi

# CSM
if test "$build_csm" = "no"; then
	AC_MSG_NOTICE([     not building csm ... disabled by user])
elif test "$have_uuid" = "no"; then
	AC_MSG_NOTICE([     not building csm ... requires uuid library])
else
	plugin_dirs="$plugin_dirs csm"
	AC_MSG_NOTICE([     building csm])
fi

# Disk
if test "$build_disk" = "no"; then
	AC_MSG_NOTICE([     not building disk ... disabled by user])
else
	plugin_dirs="$plugin_dirs disk"
	AC_MSG_NOTICE([     building disk])
fi

# DOS
if test "$build_dos" = "no"; then
	AC_MSG_NOTICE([     not building dos ... disabled by user])
else
	plugin_dirs="$plugin_dirs dos"
	AC_MSG_NOTICE([     building dos])
fi

# DriveLink
if test "$build_drivelink" = "no"; then
	AC_MSG_NOTICE([     not building drivelink ... disabled by user])
else
	plugin_dirs="$plugin_dirs drivelink"
	AC_MSG_NOTICE([     building drivelink])
fi

# Error
if test "$build_error" = "no"; then
	AC_MSG_NOTICE([     not building error ... disabled by user])
else
	plugin_dirs="$plugin_dirs error"
	AC_MSG_NOTICE([     building error])
fi

# Ext2
if test "$build_ext2" = "no"; then
	AC_MSG_NOTICE([     not building ext2 ... disabled by user])
else
	plugin_dirs="$plugin_dirs ext2"
	AC_MSG_NOTICE([     building ext2])
fi

# GPT
if test "$build_gpt" = "no"; then
	AC_MSG_NOTICE([     not building gpt ... disabled by user])
elif test "$have_uuid" = "no"; then
	AC_MSG_NOTICE([     not building gpt ... requires uuid library])
else
	plugin_dirs="$plugin_dirs gpt"
	AC_MSG_NOTICE([     building gpt])
fi

# HA
if test "$build_ha" = "no"; then
	AC_MSG_NOTICE([     not building ha ... disabled by user])
elif test "$have_ha" = "no"; then
	AC_MSG_NOTICE([     not building ha ... requires linux-ha package])
elif test "$have_ha_glib" = "no"; then
	AC_MSG_NOTICE([     not building ha ... requires $ha_glib library])
else
	plugin_dirs="$plugin_dirs ha"
	AC_MSG_NOTICE([     building ha])
fi

# JFS
if test "$build_jfs" = "no"; then
	AC_MSG_NOTICE([     not building jfs ... disabled by user])
elif test "$have_uuid" = "no"; then
	AC_MSG_NOTICE([     not building jfs ... requires uuid library])
else
	plugin_dirs="$plugin_dirs jfs"
	AC_MSG_NOTICE([     building jfs])
fi

# LVM
if test "$build_lvm" = "no"; then
	AC_MSG_NOTICE([     not building lvm ... disabled by user])
elif test "$have_utsname_h" = "no"; then
	AC_MSG_NOTICE([     not building lvm ... requires sys/utsname.h])
else
	plugin_dirs="$plugin_dirs lvm"
	AC_MSG_NOTICE([     building lvm])
fi

# LVM2
if test "$build_lvm2" = "no"; then
	AC_MSG_NOTICE([     not building lvm2 ... disabled by user])
elif test "$have_utsname_h" = "no"; then
	AC_MSG_NOTICE([     not building lvm2 ... requires sys/utsname.h])
else
	plugin_dirs="$plugin_dirs lvm2"
	AC_MSG_NOTICE([     building lvm2])
fi

# Macintosh
if test "$build_mac" = "no"; then
	AC_MSG_NOTICE([     not building mac ... disabled by user])
else
	plugin_dirs="$plugin_dirs mac"
	AC_MSG_NOTICE([     building mac])
fi

# MD
if test "$build_md" = "no"; then
	AC_MSG_NOTICE([     not building md ... disabled by user])
else
	plugin_dirs="$plugin_dirs md"
	AC_MSG_NOTICE([     building md])
fi

# Multipath
if test "$build_multipath" = "no"; then
	AC_MSG_NOTICE([     not building multipath ... disabled by user])
else
	plugin_dirs="$plugin_dirs multipath"
	AC_MSG_NOTICE([     building multipath])
fi

# OGFS
if test "$build_ogfs" = "no"; then
	AC_MSG_NOTICE([     not building ogfs ... disabled by user])
else
	plugin_dirs="$plugin_dirs ogfs"
	AC_MSG_NOTICE([     building ogfs])
fi

# NTFS
if test "$build_ntfs" = "no"; then
	AC_MSG_NOTICE([     not building ntfs ... disabled by user])
else
	plugin_dirs="$plugin_dirs ntfs"
	AC_MSG_NOTICE([     building ntfs])
fi

# Reiser
if test "$build_reiser" = "no"; then
	AC_MSG_NOTICE([     not building reiser ... disabled by user])
else
	plugin_dirs="$plugin_dirs reiser"
	AC_MSG_NOTICE([     building reiser])
fi

# Replace
if test "$build_replace" = "no"; then
	AC_MSG_NOTICE([     not building replace ... disabled by user])
else
	plugin_dirs="$plugin_dirs replace"
	AC_MSG_NOTICE([     building replace])
fi

# RSCT
if test "$build_rsct" = "no"; then
	AC_MSG_NOTICE([     not building rsct ... disabled by user])
elif test "$have_glib" = "no"; then
	AC_MSG_NOTICE([     not building rsct ... requires glib library])
elif test "$have_ha_gs_r" = "no"; then
	AC_MSG_NOTICE([     not building rsct ... requires ha_gs_r library])
elif test "$have_ha_gs_h" = "no"; then
	AC_MSG_NOTICE([     not building rsct ... requires ha_gs.h])
else
	plugin_dirs="$plugin_dirs rsct"
	AC_MSG_NOTICE([     building rsct])
fi

# S/390
if test "$build_s390" = "no"; then
	AC_MSG_NOTICE([     not building s390 ... disabled by user])
elif test "$have_vtoc_h" = "no"; then
	AC_MSG_NOTICE([     not building s390 ... requires asm/vtoc.h])
else
	plugin_dirs="$plugin_dirs s390"
	AC_MSG_NOTICE([     building s390])
fi

# Snapshot
if test "$build_snapshot" = "no"; then
	AC_MSG_NOTICE([     not building snapshot ... disabled by user])
else
	plugin_dirs="$plugin_dirs snapshot"
	AC_MSG_NOTICE([     building snapshot])
fi

# Swap
if test "$build_swap" = "no"; then
	AC_MSG_NOTICE([     not building swap ... disabled by user])
else
	plugin_dirs="$plugin_dirs swap"
	AC_MSG_NOTICE([     building swap])
fi

# XFS
if test "$build_xfs" = "no"; then
	AC_MSG_NOTICE([     not building xfs ... disabled by user])
elif test "$have_uuid" = "no"; then
	AC_MSG_NOTICE([     not building xfs ... requires uuid library])
else
	plugin_dirs="$plugin_dirs xfs"
	AC_MSG_NOTICE([     building xfs])
fi

AC_SUBST(plugin_dirs)
AC_SUBST(plugin_distdirs)
])


# EVMS_SELECT_INTERFACES
#
# By default, all EVMS user interfaces are built. Each one can be individually
# disabled by the user with a "--disable-interface" argument to ./configure
# This macro determines which interfaces to enable, and checks any additional
# dependencies that each interface might have. The final result of this macro
# is a $ui_dirs variable that is used by the ui/Makefile.am to
# decide which ui directories to process.

AC_DEFUN([EVMS_SELECT_INTERFACES],[
AC_MSG_NOTICE([checking which EVMS user interfaces to build:])

# Check if the user wants to disable any interfaces
AC_ARG_ENABLE([cli],
	      AC_HELP_STRING([--disable-cli],
			     [Disable the Command Line User Interface]),
	      [build_cli="$enableval"],
	      [build_cli="yes"])
AC_ARG_ENABLE([gui],
	      AC_HELP_STRING([--disable-gui],
			     [Disable the Graphical User Interface]),
	      [build_gui="$enableval"],
	      [build_gui="yes"])
AC_ARG_ENABLE([text-mode],
	      AC_HELP_STRING([--disable-text-mode],
			     [Disable the Text-Mode User Interface]),
	      [build_ncurses="$enableval"],
	      [build_ncurses="yes"])
AC_ARG_ENABLE([utilsl],
	      AC_HELP_STRING([--disable-utils],
			     [Disable the command-line utilities]),
	      [build_utils="$enableval"],
	      [build_utils="yes"])

# Create the list of interface directories to build. This is where each
# interface can specify its dependencies.
ui_dirs=""
ui_distdirs="cli gtk ncurses utils"

# CLI
if test "$build_cli" = "no"; then
	AC_MSG_NOTICE([     not building cli ... disabled by user])
else
	ui_dirs="$ui_dirs cli"
	AC_MSG_NOTICE([     building cli])
fi

# GUI
if test "$build_gui" = "no"; then
	AC_MSG_NOTICE([     not building gui ... disabled by user])
elif test "$have_glib" = "no"; then
	AC_MSG_NOTICE([     not building gui ... requires glib library])
elif test "$have_gtk" = "no"; then
	AC_MSG_NOTICE([     not building gui ... requires gtk library])
else
	ui_dirs="$ui_dirs gtk"
	AC_MSG_NOTICE([     building gui])
fi

# Ncurses
if test "$build_ncurses" = "no"; then
	AC_MSG_NOTICE([     not building text-mode ... disabled by user])
elif test "$have_ncurses" = "no"; then
	AC_MSG_NOTICE([     not building text-mode ... requires ncurses library])
elif test "$have_panel" = "no"; then
	AC_MSG_NOTICE([     not building text-mode ... requires panel library])
elif test "$have_ha_glib" = "no"; then
	AC_MSG_NOTICE([     not building text-mode ... requires $ha_glib library])
elif test "$have_math" = "no"; then
	AC_MSG_NOTICE([     not building text-mode ... requires math library])
else
	ui_dirs="$ui_dirs ncurses"
	AC_MSG_NOTICE([     building text-mode])
fi

# Utilities
if test "$build_utils" = "no"; then
	AC_MSG_NOTICE([     not building utils ... disabled by user])
else
	ui_dirs="$ui_dirs utils"
	AC_MSG_NOTICE([     building utils])

	# Make sure we can build evms_mpathd.
	if test "$have_devmapper" == "yes" -a "$have_devmapper_h" == "yes"; then
		utils_evms_mpathd="evms_mpathd"
	else
		AC_MSG_NOTICE([     not building evms_mpathd ... requires libdevmapper])
	fi
fi

AC_SUBST(ui_dirs)
AC_SUBST(ui_distdirs)
AC_SUBST(utils_evms_mpathd)
])


# AC_PATH_GLIB
#
# AC_PATH_GLIB([min-version, [action-if-found], [action-if-not-found],[modules])
# Test for GLIB, and define GLIB_CPPFLAGS and GLIB_LIBS. If "gmodule" or
# "gthread" is specified in MODULES, pass to glib-config. This gets the cflags
# and libraries from the glib-config script.

AC_DEFUN([AC_PATH_GLIB], [
AC_ARG_WITH([glib-prefix],
	    AC_HELP_STRING([--with-glib-prefix=PFX],
			   [Prefix where GLIB is installed (optional)]),
	    [glib_config_prefix="$withval"],
	    [glib_config_prefix=""])
AC_ARG_WITH([glib-exec-prefix],
	    AC_HELP_STRING([--with-glib-exec-prefix=PFX],
			   [Exec prefix where GLIB is installed (optional)]),
	    [glib_config_exec_prefix="$withval"],
	    [glib_config_exec_prefix=""])
AC_ARG_ENABLE([glibtest],
	      AC_HELP_STRING([--disable-glibtest],
			     [Do not try to compile and run a test GLIB program]),
	      [ ],
	      [enable_glibtest="yes"])

for module in . $4; do
	case "$module" in
		gmodule)
			glib_config_args="$glib_config_args gmodule"
			;;
		gthread)
			glib_config_args="$glib_config_args gthread"
			;;
	esac
done

if test x$glib_config_exec_prefix != x; then
	glib_config_args="$glib_config_args --exec-prefix=$glib_config_exec_prefix"
	if test x${GLIB_CONFIG+set} != xset; then
		GLIB_CONFIG=$glib_config_exec_prefix/bin/glib-config
	fi
fi

if test x$glib_config_prefix != x; then
	glib_config_args="$glib_config_args --prefix=$glib_config_prefix"
	if x${GLIB_CONFIG+set} != xset; then
		GLIB_CONFIG=$glib_config_prefix/bin/glib-config
	fi
fi

AC_PATH_PROG([GLIB_CONFIG], [glib-config], [no])
min_glib_version=ifelse([$1], , [0.99.7], [$1])
AC_MSG_CHECKING([for GLIB - version >= $min_glib_version])
no_glib=""
if test "$GLIB_CONFIG" = "no"; then
	no_glib="yes"
else
	GLIB_CPPFLAGS=`$GLIB_CONFIG $glib_config_args --cflags`
    	GLIB_LIBS=`$GLIB_CONFIG $glib_config_args --libs`
	glib_config_major_version=`$GLIB_CONFIG $glib_config_args --version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
	glib_config_minor_version=`$GLIB_CONFIG $glib_config_args --version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
	glib_config_micro_version=`$GLIB_CONFIG $glib_config_args --version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
	if test "x$enable_glibtest" = "xyes" ; then
		ac_save_CFLAGS="$CFLAGS"
		ac_save_LIBS="$LIBS"
		CFLAGS="$CFLAGS $GLIB_CPPFLAGS"
		LIBS="$GLIB_LIBS $LIBS"

		# Now check if the installed GLIB is sufficiently new. (Also
		# sanity checks the results of glib-config to some extent)

		rm -f conf.glibtest
		AC_TRY_RUN([

#include <glib.h>
#include <stdio.h>
#include <stdlib.h>

int main()
{
	int major, minor, micro;
	char *tmp_version;

	system ("touch conf.glibtest");

	/* HP/UX 9 (%@#!) writes to sscanf strings */
	tmp_version = g_strdup("$min_glib_version");
	if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
		printf("%s, bad version string\n", "$min_glib_version");
		exit(1);
	}

	if ((glib_major_version != $glib_config_major_version) ||
	    (glib_minor_version != $glib_config_minor_version) ||
	    (glib_micro_version != $glib_config_micro_version)) {
		printf("\n*** 'glib-config --version' returned %d.%d.%d, "
		       "but GLIB (%d.%d.%d)\n", $glib_config_major_version,
		       $glib_config_minor_version, $glib_config_micro_version,
		       glib_major_version, glib_minor_version,
		       glib_micro_version);
		printf("*** was found! If glib-config was correct, then it "
		       "is best\n");
		printf("*** to remove the old version of GLIB. You may also "
		       "be able to fix the error\n");
		printf("*** by modifying your LD_LIBRARY_PATH enviroment "
		       "variable, or by editing\n");
		printf("*** /etc/ld.so.conf. Make sure you have run ldconfig "
		       "if that is\n");
		printf("*** required on your system.\n");
		printf("*** If glib-config was wrong, set the environment "
		       "variable GLIB_CONFIG\n");
		printf("*** to point to the correct copy of glib-config, and "
		       "remove the file config.cache\n");
		printf("*** before re-running configure\n");
	} else if ((glib_major_version != GLIB_MAJOR_VERSION) ||
		   (glib_minor_version != GLIB_MINOR_VERSION) ||
		   (glib_micro_version != GLIB_MICRO_VERSION)) {
		printf("*** GLIB header files (version %d.%d.%d) do not "
		       "match\n", GLIB_MAJOR_VERSION, GLIB_MINOR_VERSION,
		       GLIB_MICRO_VERSION);
		printf("*** library (version %d.%d.%d)\n", glib_major_version,
		       glib_minor_version, glib_micro_version);
	} else {
		if ((glib_major_version > major) ||
		    ((glib_major_version == major) &&
		     (glib_minor_version > minor)) ||
		    ((glib_major_version == major) &&
		     (glib_minor_version == minor) &&
		     (glib_micro_version >= micro))) {
			return 0;
		} else {
			printf("\n*** An old version of GLIB (%d.%d.%d) was "
			       "found.\n", glib_major_version,
			       glib_minor_version, glib_micro_version);
			printf("*** You need a version of GLIB newer than "
			       "%d.%d.%d. The latest version of\n",
			       major, minor, micro);
			printf("*** GLIB is always available from "
			       "ftp://ftp.gtk.org.\n");
			printf("***\n");
			printf("*** If you have already installed a "
			       "sufficiently new version, this error\n");
			printf("*** probably means that the wrong copy of the "
			       "glib-config shell script is\n");
			printf("*** being found. The easiest way to fix this "
			       "is to remove the old version\n");
			printf("*** of GLIB, but you can also set the "
			       "GLIB_CONFIG environment to point to the\n");
			printf("*** correct copy of glib-config. (In this "
			       "case, you will have to\n");
			printf("*** modify your LD_LIBRARY_PATH enviroment "
			       "variable, or edit /etc/ld.so.conf\n");
			printf("*** so that the correct libraries are found "
			       "at run-time)\n");
		}
	}
  	return 1;
}

		],,
		[no_glib="yes"],
		[echo $ac_n "cross compiling; assumed OK... $ac_c"])
		CFLAGS="$ac_save_CFLAGS"
		LIBS="$ac_save_LIBS"
	fi
fi

if test "x$no_glib" = x; then
	AC_MSG_RESULT([yes])
	ifelse([$2], , :, [$2])
else
	AC_MSG_RESULT(no)
	if test "$GLIB_CONFIG" = "no" ; then
		echo "*** The glib-config script installed by GLIB could not be"
		echo "*** found. If GLIB was installed in PREFIX, make sure"
		echo "*** PREFIX/bin is in your path, or set the GLIB_CONFIG"
		echo "*** environment variable to the full path to glib-config."
	else
		if test -f conf.glibtest; then
			:
		else
			echo "*** Could not run GLIB test program, checking why..."
			CFLAGS="$CFLAGS $GLIB_CPPFLAGS"
			LIBS="$LIBS $GLIB_LIBS"
			AC_TRY_LINK([ #include <glib.h>
				      #include <stdio.h> ],
				    [ return ((glib_major_version) ||
					      (glib_minor_version) ||
					      (glib_micro_version)); ],
	[ echo "*** The test program compiled, but did not run. This usually"
	  echo "*** means that the run-time linker is not finding GLIB or"
	  echo "*** is finding the wrong version of GLIB. If it is not finding"
	  echo "*** GLIB, you'll need to set your LD_LIBRARY_PATH environment"
	  echo "*** variable, or edit /etc/ld.so.conf to point to the installed"
	  echo "*** location  Also, make sure you have run ldconfig if that is"
	  echo "*** required on your system"
	  echo "***"
	  echo "*** If you have an old version installed, it is best to remove"
	  echo "*** it, although you may also be able to get things to work by"
	  echo "*** modifying LD_LIBRARY_PATH"
	  echo "***"
	  echo "*** If you have a RedHat 5.0 system, you should remove the GTK"
	  echo "*** package that came with the system with the command"
	  echo "***"
	  echo "***    rpm --erase --nodeps gtk gtk-devel" ],
	[ echo "*** The test program failed to compile or link. See the file"
	  echo "*** config.log for the exact error that occured. This usually"
	  echo "*** means GLIB was incorrectly installed or that you have"
	  echo "*** moved GLIB since it was installed. In the latter case, you"
	  echo "*** may want to edit the glib-config script: $GLIB_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"

		fi
	fi
	GLIB_CPPFLAGS=""
	GLIB_LIBS=""
	ifelse([$3], , :, [$3])
fi
AC_SUBST(GLIB_CPPFLAGS)
AC_SUBST(GLIB_LIBS)
rm -f conf.glibtest
])

# AC_PATH_GLIB2
#
# AC_PATH_GLIB2([min-version, [action-if-found], [action-if-not-found],[modules])
# Test for GLIB2, and define GLIB2_CPPFLAGS and GLIB2_LIBS. If "gmodule" or
# "gthread" is specified in MODULES, pass to pkg-config. This gets the cflags
# and libraries from the pkg-config script.

AC_DEFUN([AC_PATH_GLIB2], [
AC_ARG_WITH([glib2-prefix],
	    AC_HELP_STRING([--with-glib2-prefix=PFX],
			   [Prefix where GLIB2 is installed (optional)]),
	    [glib2_config_prefix="$withval"],
	    [glib2_config_prefix=""])
AC_ARG_WITH([glib2-exec-prefix],
	    AC_HELP_STRING([--with-glib2-exec-prefix=PFX],
			   [Exec prefix where GLIB2 is installed (optional)]),
	    [glib2_config_exec_prefix="$withval"],
	    [glib2_config_exec_prefix=""])
AC_ARG_ENABLE([glib2test],
	      AC_HELP_STRING([--disable-glib2test],
			     [Do not try to compile and run a test GLIB2 program]),
	      [ ],
	      [enable_glib2test="yes"])

for module in . $4; do
	case "$module" in
		gmodule)
			glib2_config_args="$glib2_config_args gmodule-2.0"
			;;
		gthread)
			glib2_config_args="$glib2_config_args gthread-2.0"
			;;
	esac
done

if test x$glib2_config_exec_prefix != x; then
	glib2_config_args="$glib2_config_args --exec-prefix=$glib2_config_exec_prefix"
	if test x${GLIB2_CONFIG+set} != xset; then
		GLIB2_CONFIG=$glib2_config_exec_prefix/bin/pkg-config
	fi
fi

if test x$glib2_config_prefix != x; then
	glib2_config_args="$glib2_config_args --prefix=$glib2_config_prefix"
	if x${GLIB2_CONFIG+set} != xset; then
		GLIB2_CONFIG=$glib2_config_prefix/bin/pkg-config
	fi
fi

AC_PATH_PROG([GLIB2_CONFIG], [pkg-config], [no])
min_glib2_version=ifelse([$1], , [2.0.0], [$1])
AC_MSG_CHECKING([for GLIB2 - version >= $min_glib2_version])
no_glib2=""
if test "$GLIB2_CONFIG" = "no"; then
	no_glib2="yes"
else
	GLIB2_CPPFLAGS=`$GLIB2_CONFIG $glib2_config_args --cflags glib-2.0`
    	GLIB2_LIBS=`$GLIB2_CONFIG $glib2_config_args --libs glib-2.0`
	glib2_config_major_version=`$GLIB2_CONFIG $glib2_config_args --modversion glib-2.0 | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
	glib2_config_minor_version=`$GLIB2_CONFIG $glib2_config_args --modversion glib-2.0 | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
	glib2_config_micro_version=`$GLIB2_CONFIG $glib2_config_args --modversion glib-2.0 | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
	if test "x$enable_glib2test" = "xyes" ; then
		ac_save_CFLAGS="$CFLAGS"
		ac_save_LIBS="$LIBS"
		CFLAGS="$CFLAGS $GLIB2_CPPFLAGS"
		LIBS="$GLIB2_LIBS $LIBS"

		# Now check if the installed GLIB2 is sufficiently new. (Also
		# sanity checks the results of pkg-config to some extent)

		rm -f conf.glib2test
		AC_TRY_RUN([

#include <glib.h>
#include <stdio.h>
#include <stdlib.h>

int main()
{
	int major, minor, micro;
	char *tmp_version;

	system ("touch conf.glib2test");

	/* HP/UX 9 (%@#!) writes to sscanf strings */
	tmp_version = g_strdup("$min_glib2_version");
	if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
		printf("%s, bad version string\n", "$min_glib2_version");
		exit(1);
	}

	if ((glib_major_version != $glib2_config_major_version) ||
	    (glib_minor_version != $glib2_config_minor_version) ||
	    (glib_micro_version != $glib2_config_micro_version)) {
		printf("\n*** 'pkg-config --modversion glib-2.0' returned %d.%d.%d, "
		       "but GLIB2 (%d.%d.%d)\n", $glib2_config_major_version,
		       $glib2_config_minor_version, $glib2_config_micro_version,
		       glib_major_version, glib_minor_version,
		       glib_micro_version);
		printf("*** was found! If pkg-config was correct, then it "
		       "is best\n");
		printf("*** to remove the old version of GLIB2. You may also "
		       "be able to fix the error\n");
		printf("*** by modifying your LD_LIBRARY_PATH enviroment "
		       "variable, or by editing\n");
		printf("*** /etc/ld.so.conf. Make sure you have run ldconfig "
		       "if that is\n");
		printf("*** required on your system.\n");
		printf("*** If pkg-config was wrong, set the environment "
		       "variable GLIB2_CONFIG\n");
		printf("*** to point to the correct copy of pkg-config, and "
		       "remove the file config.cache\n");
		printf("*** before re-running configure\n");
	} else if ((glib_major_version != GLIB_MAJOR_VERSION) ||
		   (glib_minor_version != GLIB_MINOR_VERSION) ||
		   (glib_micro_version != GLIB_MICRO_VERSION)) {
		printf("*** GLIB2 header files (version %d.%d.%d) do not "
		       "match\n", GLIB_MAJOR_VERSION, GLIB_MINOR_VERSION,
		       GLIB_MICRO_VERSION);
		printf("*** library (version %d.%d.%d)\n", glib_major_version,
		       glib_minor_version, glib_micro_version);
	} else {
		if ((glib_major_version > major) ||
		    ((glib_major_version == major) &&
		     (glib_minor_version > minor)) ||
		    ((glib_major_version == major) &&
		     (glib_minor_version == minor) &&
		     (glib_micro_version >= micro))) {
			return 0;
		} else {
			printf("\n*** An old version of GLIB2 (%d.%d.%d) was "
			       "found.\n", glib_major_version,
			       glib_minor_version, glib_micro_version);
			printf("*** You need a version of GLIB2 newer than "
			       "%d.%d.%d. The latest version of\n",
			       major, minor, micro);
			printf("*** GLIB2 is always available from "
			       "ftp://ftp.gtk.org.\n");
			printf("***\n");
			printf("*** If you have already installed a "
			       "sufficiently new version, this error\n");
			printf("*** probably means that the wrong copy of the "
			       "pkg-config shell script is\n");
			printf("*** being found. The easiest way to fix this "
			       "is to remove the old version\n");
			printf("*** of GLIB2, but you can also set the "
			       "GLIB2_CONFIG environment to point to the\n");
			printf("*** correct copy of pkg-config. (In this "
			       "case, you will have to\n");
			printf("*** modify your LD_LIBRARY_PATH enviroment "
			       "variable, or edit /etc/ld.so.conf\n");
			printf("*** so that the correct libraries are found "
			       "at run-time)\n");
		}
	}
  	return 1;
}

		],,
		[no_glib2="yes"],
		[echo $ac_n "cross compiling; assumed OK... $ac_c"])
		CFLAGS="$ac_save_CFLAGS"
		LIBS="$ac_save_LIBS"
	fi
fi

if test "x$no_glib2" = x; then
	AC_MSG_RESULT([yes])
	ifelse([$2], , :, [$2])
else
	AC_MSG_RESULT(no)
	if test "$GLIB2_CONFIG" = "no" ; then
		echo "*** The pkg-config script installed by GLIB2 could not be"
		echo "*** found. If GLIB2 was installed in PREFIX, make sure"
		echo "*** PREFIX/bin is in your path, or set the GLIB2_CONFIG"
		echo "*** environment variable to the full path to pkg-config."
	else
		if test -f conf.glib2test; then
			:
		else
			echo "*** Could not run GLIB2 test program, checking why..."
			CFLAGS="$CFLAGS $GLIB2_CPPFLAGS"
			LIBS="$LIBS $GLIB2_LIBS"
			AC_TRY_LINK([ #include <glib.h>
				      #include <stdio.h> ],
				    [ return ((glib_major_version) ||
					      (glib_minor_version) ||
					      (glib_micro_version)); ],
	[ echo "*** The test program compiled, but did not run. This usually"
	  echo "*** means that the run-time linker is not finding GLIB2 or"
	  echo "*** is finding the wrong version of GLIB2. If it is not finding"
	  echo "*** GLIB2, you'll need to set your LD_LIBRARY_PATH environment"
	  echo "*** variable, or edit /etc/ld.so.conf to point to the installed"
	  echo "*** location  Also, make sure you have run ldconfig if that is"
	  echo "*** required on your system"
	  echo "***"
	  echo "*** If you have an old version installed, it is best to remove"
	  echo "*** it, although you may also be able to get things to work by"
	  echo "*** modifying LD_LIBRARY_PATH"
	  echo "***"
	  echo "*** If you have a RedHat 5.0 system, you should remove the GTK"
	  echo "*** package that came with the system with the command"
	  echo "***"
	  echo "***    rpm --erase --nodeps gtk gtk-devel" ],
	[ echo "*** The test program failed to compile or link. See the file"
	  echo "*** config.log for the exact error that occured. This usually"
	  echo "*** means GLIB2 was incorrectly installed or that you have"
	  echo "*** moved GLIB2 since it was installed. In the latter case, you"
	  echo "*** may want to edit the pkg-config script: $GLIB2_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"

		fi
	fi
	GLIB2_CPPFLAGS=""
	GLIB2_LIBS=""
	ifelse([$3], , :, [$3])
fi
AC_SUBST(GLIB2_CPPFLAGS)
AC_SUBST(GLIB2_LIBS)
rm -f conf.glib2test
])


# AC_PATH_GTK
#
# AC_PATH_GTK([min-version, [action-if-found], [action-if-not-found],[modules])
# Test for GTK, and define GTK_CPPFLAGS and GTK_LIBS. This gets the cflags
# and libraries from the glib-config script.
AC_DEFUN([AC_PATH_GTK], [
AC_ARG_WITH([gtk-prefix],
	    AC_HELP_STRING([--with-gtk-prefix=PFX],
			   [Prefix where GTK is installed (optional)]),
	    [gtk_config_prefix="$withval"],
	    [gtk_config_prefix=""])
AC_ARG_WITH([gtk-exec-prefix],
	    AC_HELP_STRING([--with-gtk-exec-prefix=PFX],
			   [Exec prefix where GTK is installed (optional)]),
	    [gtk_config_exec_prefix="$withval"],
	    [gtk_config_exec_prefix=""])
AC_ARG_ENABLE([gtktest],
	      AC_HELP_STRING([--disable-gtktest],
			     [Do not try to compile and run a test GTK program]),
	      [ ],
	      [enable_gtktest="yes"])

for module in . $4; do
	case "$module" in
		gthread)
			gtk_config_args="$gtk_config_args gthread"
			;;
	esac
done

if test x$gtk_config_exec_prefix != x; then
	gtk_config_args="$gtk_config_args --exec-prefix=$gtk_config_exec_prefix"
	if test x${GTK_CONFIG+set} != xset; then
		GTK_CONFIG=$gtk_config_exec_prefix/bin/gtk-config
	fi
fi

if test x$gtk_config_prefix != x; then
	gtk_config_args="$gtk_config_args --prefix=$gtk_config_prefix"
	if test x${GTK_CONFIG+set} != xset; then
		GTK_CONFIG=$gtk_config_prefix/bin/gtk-config
	fi
fi

AC_PATH_PROG([GTK_CONFIG], [gtk-config], [no])
min_gtk_version=ifelse([$1], , [0.99.7], [$1])
AC_MSG_CHECKING(for GTK - version >= $min_gtk_version)
no_gtk=""
if test "$GTK_CONFIG" = "no"; then
	no_gtk="yes"
else
	GTK_CPPFLAGS=`$GTK_CONFIG $gtk_config_args --cflags`
	GTK_LIBS=`$GTK_CONFIG $gtk_config_args --libs`
	gtk_config_major_version=`$GTK_CONFIG $gtk_config_args --version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
	gtk_config_minor_version=`$GTK_CONFIG $gtk_config_args --version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
	gtk_config_micro_version=`$GTK_CONFIG $gtk_config_args --version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
	if test "x$enable_gtktest" = "xyes"; then
		ac_save_CFLAGS="$CFLAGS"
		ac_save_LIBS="$LIBS"
		CFLAGS="$CFLAGS $GTK_CPPFLAGS"
		LIBS="$GTK_LIBS $LIBS"

		# Now check if the installed GTK is sufficiently new. (Also
		# sanity checks the results of gtk-config to some extent).

		rm -f conf.gtktest
		AC_TRY_RUN([

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>

int main()
{
	int major, minor, micro;
	char *tmp_version;

	system("touch conf.gtktest");

	/* HP/UX 9 (%@#!) writes to sscanf strings */
	tmp_version = g_strdup("$min_gtk_version");
	if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
		printf("%s, bad version string\n", "$min_gtk_version");
		exit(1);
	}

	if ((gtk_major_version != $gtk_config_major_version) ||
	    (gtk_minor_version != $gtk_config_minor_version) ||
	    (gtk_micro_version != $gtk_config_micro_version)) {
		printf("\n*** 'gtk-config --version' returned %d.%d.%d, but "
		       "GTK+ (%d.%d.%d)\n", $gtk_config_major_version,
		       $gtk_config_minor_version, $gtk_config_micro_version,
		       gtk_major_version, gtk_minor_version, gtk_micro_version);
		printf("*** was found! If gtk-config was correct, then it is "
		       "best\n");
		printf("*** to remove the old version of GTK+. You may also "
		       "be able to fix the error\n");
		printf("*** by modifying your LD_LIBRARY_PATH enviroment "
		       "variable, or by editing\n");
		printf("*** /etc/ld.so.conf. Make sure you have run ldconfig "
		       "if that is\n");
		printf("*** required on your system.\n");
		printf("*** If gtk-config was wrong, set the environment "
		       "variable GTK_CONFIG\n");
		printf("*** to point to the correct copy of gtk-config, and "
		       "remove the file config.cache\n");
		printf("*** before re-running configure\n");
	}

#if defined (GTK_MAJOR_VERSION) && defined (GTK_MINOR_VERSION) && defined (GTK_MICRO_VERSION)
	else if ((gtk_major_version != GTK_MAJOR_VERSION) ||
		 (gtk_minor_version != GTK_MINOR_VERSION) ||
		 (gtk_micro_version != GTK_MICRO_VERSION)) {
		printf("*** GTK+ header files (version %d.%d.%d) do not "
		       "match\n", GTK_MAJOR_VERSION, GTK_MINOR_VERSION,
		       GTK_MICRO_VERSION);
		printf("*** library (version %d.%d.%d)\n", gtk_major_version,
		       gtk_minor_version, gtk_micro_version);
	}
#endif

	else {
		if ((gtk_major_version > major) ||
		    ((gtk_major_version == major) &&
		     (gtk_minor_version > minor)) ||
		    ((gtk_major_version == major) &&
		     (gtk_minor_version == minor) &&
		     (gtk_micro_version >= micro))) {
			return 0;
		} else {
			printf("\n*** An old version of GTK+ (%d.%d.%d) was "
			       "found.\n", gtk_major_version,
			       gtk_minor_version, gtk_micro_version);
			printf("*** You need a version of GTK+ newer than "
			       "%d.%d.%d. The latest version of\n",
			       major, minor, micro);
			printf("*** GTK+ is always available from "
			       "ftp://ftp.gtk.org.\n");
			printf("***\n");
			printf("*** If you have already installed a "
			       "sufficiently new version, this error\n");
			printf("*** probably means that the wrong copy of the "
			       "gtk-config shell script is\n");
			printf("*** being found. The easiest way to fix this "
			       "is to remove the old version\n");
			printf("*** of GTK+, but you can also set the "
			       "GTK_CONFIG environment topoint to the\n");
			printf("*** correct copy of gtk-config. (In this "
			       "case, you will have to\n");
			printf("*** modify your LD_LIBRARY_PATH enviroment "
			       "variable, or edit /etc/ld.so.conf\n");
			printf("*** so that the correct libraries are found at "
			       "run-time)\n");
		}
	}
	return 1;
}

		],,
		[no_gtk="yes"],
		[echo $ac_n "cross compiling; assumed OK... $ac_c"])
		CFLAGS="$ac_save_CFLAGS"
		LIBS="$ac_save_LIBS"
	fi
fi

if test "x$no_gtk" = x; then
	AC_MSG_RESULT(yes)
	ifelse([$2], , :, [$2])
else
	AC_MSG_RESULT(no)
	if test "$GTK_CONFIG" = "no"; then
		echo "*** The gtk-config script installed by GTK could not be"
		echo "*** found. If GTK was installed in PREFIX, make sure"
		echo "*** PREFIX/bin is in your path, or set the GTK_CONFIG"
		echo "*** environment variable to the full path to gtk-config."
	else
		if test -f conf.gtktest; then
			:
		else
			echo "*** Could not run GTK test program, checking why..."
			CFLAGS="$CFLAGS $GTK_CPPFLAGS"
			LIBS="$LIBS $GTK_LIBS"
			AC_TRY_LINK([ #include <gtk/gtk.h>
				      #include <stdio.h> ],
				    [ return ((gtk_major_version) ||
					      (gtk_minor_version) ||
					      (gtk_micro_version)); ],
	[ echo "*** The test program compiled, but did not run. This usually"
	  echo "*** means that the run-time linker is not finding GTK or"
	  echo "*** finding the wrong version of GTK. If it is not finding GTK,"
	  echo "*** you'll need to set your LD_LIBRARY_PATH environment"
	  echo "*** variable, or edit /etc/ld.so.conf to point to the installed"
	  echo "*** location  Also, make sure you have run ldconfig if that is"
	  echo "*** required on your system"
	  echo "***"
	  echo "*** If you have an old version installed, it is best to remove"
	  echo "*** it, although you may also be able to get things to work by"
	  echo "*** modifying LD_LIBRARY_PATH"
	  echo "***"
	  echo "*** If you have a RedHat 5.0 system, you should remove the GTK"
	  echo "*** package that came with the system with the command"
	  echo "***"
	  echo "***    rpm --erase --nodeps gtk gtk-devel" ],
	[ echo "*** The test program failed to compile or link. See the file"
	  echo "*** config.log for the exact error that occured. This usually"
	  echo "*** means GTK was incorrectly installed or that you have moved"
	  echo "*** GTK since it was installed. In the latter case, you may"
	  echo "*** want to edit the gtk-config script: $GTK_CONFIG" ])

			CFLAGS="$ac_save_CFLAGS"
          		LIBS="$ac_save_LIBS"
		fi
	fi
	GTK_CPPFLAGS=""
	GTK_LIBS=""
	ifelse([$3], , :, [$3])
fi
AC_SUBST(GTK_CPPFLAGS)
AC_SUBST(GTK_LIBS)
rm -f conf.gtktest
])


# AC_PATH_HA
#
# AC_PATH_HA([min-version], [action-if-found], [action-if-not-found], [modules])
# Test for the presence of the High-Availability clustering package.

AC_DEFUN([AC_PATH_HA], [

min_ha_version=ifelse([$1], , 0.4.9f, [$1])
AC_PATH_PROGS([HB], [heartbeat], ,[/usr/lib/heartbeat])
if test x"$HB" = x; then
	ifelse([$3], , :, [$3])
else
	AC_MSG_CHECKING([for HA version])
	HA_VERSION=`strings $HB | \
		    egrep '^[[0-9]]+\.[[0-9]]+\.[[0-9]]+.*$' | uniq`
	AC_MSG_RESULT([$HA_VERSION])

	HA_MAJOR=`echo $HA_VERSION | \
		sed 's/\([[0-9]]*\)\.\([[0-9]]*\)\.\([[0-9]]*\)\(.*\)/\1/'`
	HA_MINOR=`echo $HA_VERSION | \
		sed 's/\([[0-9]]*\)\.\([[0-9]]*\)\.\([[0-9]]*\)\(.*\)/\2/'`
	HA_PATCH=`echo $HA_VERSION | \
		sed 's/\([[0-9]]*\)\.\([[0-9]]*\)\.\([[0-9]]*\)\(.*\)/\3/'`
	HA_BETA=`echo $HA_VERSION | \
		sed 's/\([[0-9]]*\)\.\([[0-9]]*\)\.\([[0-9]]*\)\(.*\)/\4/'`
	if [[ -z "$HA_BETA" ]]
	then
		HA_BETA=0
	fi

	AC_TRY_RUN([

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
int main()
{
	int major, minor, patch;
	char beta;
	char *tmp_version;

	tmp_version = (char *)strdup("$min_ha_version");
	if (sscanf(tmp_version, "%d.%d.%d%c",
		   &major, &minor, &patch, &beta) != 4) {
		printf("%s, bad version string\n", "$min_ha_version");
		return 1;
	}

	if (($HA_MAJOR > major)    ||
	    (($HA_MAJOR == major) &&
	     ($HA_MINOR > minor))  ||
	    (($HA_MAJOR == major) &&
	     ($HA_MINOR == minor) &&
	     ($HA_PATCH >= patch)) ||
	    (($HA_MAJOR == major) &&
	     ($HA_MINOR == minor) &&
	     ($HA_PATCH == patch) &&
	     ('$HA_BETA' >= beta))) {
		return(0);
	} else {
		printf("\n");
		printf("*** An old version of linux-ha (%d.%d.%d%c) was "
		       "found.\n", $HA_MAJOR, $HA_MINOR, $HA_PATCH, '$HA_BETA');
		printf("*** You need at least version %d.%d.%d. of linux-ha\n",
		       major, minor, patch);
		printf("*** The latest version is available from\n");
		printf("*** http://www.linux-ha.org/download/");
                printf("***\n");
                printf("*** If you have already installed a recent version,\n");
		printf("*** this error probably means that the wrong copy\n");
		printf("*** of the heartbeat daemon is being found. The\n");
		printf("*** easiest way to fix this is to remove the old\n");
		printf("*** version of linux-ha\n");
        }
        return(1);
}
		   ],
		   [have_ha_version="yes"],
		   [ifelse([$3], , :, [$3])])
fi

ha_glib=glib
have_ha_glib=$have_glib
HA_GLIB_CPPFLAGS=$GLIB_CPPFLAGS
HA_GLIB_LIBS=$GLIB_LIBS

if test "$have_ha_version" = "yes"; then
	if test -d /usr/include/heartbeat -a	\
		-d /usr/include/clplumbing -a 	\
		-d /usr/include/ocf; then
		have_ha_headers="yes"
		if test $HA_MAJOR -ge 2; then
			ha_glib=glib2
			have_ha_glib=$have_glib2
			HA_GLIB_CPPFLAGS=$GLIB2_CPPFLAGS
			HA_GLIB_LIBS=$GLIB2_LIBS
		fi
		HA_CPPFLAGS="-I/usr/include/heartbeat"
		tmp_cppflags=$CPPFLAGS
		CPPFLAGS="$HA_CPPFLAGS $HA_GLIB_CPPFLAGS"
		AC_CHECK_HEADERS([heartbeat/heartbeat.h		\
				  heartbeat/ha_msg.h		\
				  heartbeat/hb_api.h		\
				  clplumbing/ipc.h		\
				  clplumbing/GSource.h		\
				  clplumbing/Gmain_timeout.h	\
				  clplumbing/base64.h		\
				  ocf/oc_event.h], [],
				 [have_ha_headers="no"])
		CPPFLAGS=$tmp_cppflags
		if test "$have_ha_headers" = "yes"; then
			HA_LIBS="-lhbclient -lccmclient -lplumb"
			for resourcedir in /etc/ha.d/resource.d /etc/heartbeat/resource.d; do
				if test -d "$resourcedir"; then
					HA_RESOURCEDIR="$resourcedir"
					ifelse([$2], , :, [$2])
				fi
			done
			if test -z "$HA_RESOURCEDIR"; then
				HA_CPPFLAGS=""
				ifelse([$3], , :, [$3])
			fi
		else
			HA_CPPFLAGS=""
			ifelse([$3], , :, [$3])
		fi
	else
		ifelse([$3], , :, [$3])
	fi
fi

AC_SUBST(HA_LIBS)
AC_SUBST(HA_CPPFLAGS)
AC_SUBST(HA_RESOURCEDIR)
AC_SUBST(HA_MAJOR)
AC_SUBST(HA_MINOR)
AC_SUBST(HA_PATCH)
AC_SUBST(HA_GLIB_CPPFLAGS)
AC_SUBST(HA_GLIB_LIBS)
])

# AC_WITH_EFENCE
#
# Check whether to link the EVMS user interfaces with the Electric Fence
# memory debugging library.

AC_DEFUN([AC_WITH_EFENCE],[
AC_ARG_WITH([efence],
	    AC_HELP_STRING([--with-efence],
			   [Link with Electric Fence memory debugging library]),
	    [have_efence="$withval"],
	    [have_efence="no"])

if test "$have_efence" = "yes"; then
	AC_CHECK_LIB([efence], [calloc], [EFENCE_LIBS="-lefence"])
fi

AC_SUBST(EFENCE_LIBS)
])


# AC_WITH_DEBUG
#
# Check whether to force debugging information to be added to EVMS.
AC_DEFUN([AC_WITH_DEBUG],[
AC_ARG_WITH([debug],
	    AC_HELP_STRING([--with-debug],[Add extra debugging information]),
	    [have_debug="$withval"], [have_debug="no"])
if test "$have_debug" = "yes"; then
	if test -z "$ac_test_CFLAGS"; then
		if test $ac_cv_prog_cc_g = "yes"; then
			CFLAGS=`echo $CFLAGS | sed 's/-O.//'`
			if test "$GCC" = "yes"; then
				CFLAGS=`echo $CFLAGS | sed 's/-g//'`
			fi
		fi
	fi
	if test "$GCC" = "yes"; then
		CFLAGS="$CFLAGS -g"
	fi
	EVMS_DEBUG="-DEVMS_DEBUG"
fi
AC_SUBST(EVMS_DEBUG)
])


# AC_WITH_STATIC_GLIB
#
# Check whether to force the text-mode UI to link statically to glib and panel.
# This is done to prevent linking to libraries in /usr.
AC_DEFUN([AC_WITH_STATIC_GLIB],[
AC_ARG_WITH([static-glib],
	    AC_HELP_STRING([--with-static-glib],[Link text-mode UI statically to glib]),
	    [static_glib="$withval"], [static_glib="no"])
if test "$static_glib" = "yes"; then
	STATIC_GLIB_OPEN="-Wl,-dn"
	STATIC_GLIB_CLOSE="-Wl,-dy"
fi
AC_SUBST(STATIC_GLIB_OPEN)
AC_SUBST(STATIC_GLIB_CLOSE)
])


# AC_ENABLE_NLS
#
# Check whether to enable NLS support in EVMS.
AC_DEFUN([AC_ENABLE_NLS],[
if test "$USE_NLS" = "yes"; then
	ENABLE_NLS="-DENABLE_NLS"
fi
AC_SUBST(ENABLE_NLS)
])


# The following macros have been copied in from the .m4 files in the gettext
# source.  They do all the magic setup for building with NLS support.


# codeset.m4 serial AM1 (gettext-0.10.40)
dnl Copyright (C) 2000-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible.

AC_DEFUN([AM_LANGINFO_CODESET],
[
  AC_CACHE_CHECK([for nl_langinfo and CODESET], am_cv_langinfo_codeset,
    [AC_TRY_LINK([#include <langinfo.h>],
      [char* cs = nl_langinfo(CODESET);],
      am_cv_langinfo_codeset=yes,
      am_cv_langinfo_codeset=no)
    ])
  if test $am_cv_langinfo_codeset = yes; then
    AC_DEFINE(HAVE_LANGINFO_CODESET, 1,
      [Define if you have <langinfo.h> and nl_langinfo(CODESET).])
  fi
])


gettext.m4 serial 17 (gettext-0.11.5)
dnl Copyright (C) 1995-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.
dnl
dnl This file can can be used in projects which are not available under
dnl the GNU General Public License or the GNU Library General Public
dnl License but which still want to provide support for the GNU gettext
dnl functionality.
dnl Please note that the actual code of the GNU gettext library is covered
dnl by the GNU Library General Public License, and the rest of the GNU
dnl gettext package package is covered by the GNU General Public License.
dnl They are *not* in the public domain.

dnl Authors:
dnl   Ulrich Drepper <drepper@cygnus.com>, 1995-2000.
dnl   Bruno Haible <haible@clisp.cons.org>, 2000-2002.

dnl Macro to add for using GNU gettext.

dnl Usage: AM_GNU_GETTEXT([INTLSYMBOL], [NEEDSYMBOL], [INTLDIR]).
dnl INTLSYMBOL can be one of 'external', 'no-libtool', 'use-libtool'. The
dnl    default (if it is not specified or empty) is 'no-libtool'.
dnl    INTLSYMBOL should be 'external' for packages with no intl directory,
dnl    and 'no-libtool' or 'use-libtool' for packages with an intl directory.
dnl    If INTLSYMBOL is 'use-libtool', then a libtool library
dnl    $(top_builddir)/intl/libintl.la will be created (shared and/or static,
dnl    depending on --{enable,disable}-{shared,static} and on the presence of
dnl    AM-DISABLE-SHARED). If INTLSYMBOL is 'no-libtool', a static library
dnl    $(top_builddir)/intl/libintl.a will be created.
dnl If NEEDSYMBOL is specified and is 'need-ngettext', then GNU gettext
dnl    implementations (in libc or libintl) without the ngettext() function
dnl    will be ignored.  If NEEDSYMBOL is specified and is
dnl    'need-formatstring-macros', then GNU gettext implementations that don't
dnl    support the ISO C 99 <inttypes.h> formatstring macros will be ignored.
dnl INTLDIR is used to find the intl libraries.  If empty,
dnl    the value `$(top_builddir)/intl/' is used.
dnl
dnl The result of the configuration is one of three cases:
dnl 1) GNU gettext, as included in the intl subdirectory, will be compiled
dnl    and used.
dnl    Catalog format: GNU --> install in $(datadir)
dnl    Catalog extension: .mo after installation, .gmo in source tree
dnl 2) GNU gettext has been found in the system's C library.
dnl    Catalog format: GNU --> install in $(datadir)
dnl    Catalog extension: .mo after installation, .gmo in source tree
dnl 3) No internationalization, always use English msgid.
dnl    Catalog format: none
dnl    Catalog extension: none
dnl If INTLSYMBOL is 'external', only cases 2 and 3 can occur.
dnl The use of .gmo is historical (it was needed to avoid overwriting the
dnl GNU format catalogs when building on a platform with an X/Open gettext),
dnl but we keep it in order not to force irrelevant filename changes on the
dnl maintainers.
dnl
AC_DEFUN([AM_GNU_GETTEXT],
[
  dnl Argument checking.
  ifelse([$1], [], , [ifelse([$1], [external], , [ifelse([$1], [no-libtool], , [ifelse([$1], [use-libtool], ,
    [errprint([ERROR: invalid first argument to AM_GNU_GETTEXT
])])])])])
  ifelse([$2], [], , [ifelse([$2], [need-ngettext], , [ifelse([$2], [need-formatstring-macros], ,
    [errprint([ERROR: invalid second argument to AM_GNU_GETTEXT
])])])])
  define(gt_included_intl, ifelse([$1], [external], [no], [yes]))
  define(gt_libtool_suffix_prefix, ifelse([$1], [use-libtool], [l], []))

  AC_REQUIRE([AM_PO_SUBDIRS])dnl
  ifelse(gt_included_intl, yes, [
    AC_REQUIRE([AM_INTL_SUBDIR])dnl
  ])

  dnl Prerequisites of AC_LIB_LINKFLAGS_BODY.
  AC_REQUIRE([AC_LIB_PREPARE_PREFIX])
  AC_REQUIRE([AC_LIB_RPATH])

  dnl Sometimes libintl requires libiconv, so first search for libiconv.
  dnl Ideally we would do this search only after the
  dnl      if test "$USE_NLS" = "yes"; then
  dnl        if test "$gt_cv_func_gnugettext_libc" != "yes"; then
  dnl tests. But if configure.in invokes AM_ICONV after AM_GNU_GETTEXT
  dnl the configure script would need to contain the same shell code
  dnl again, outside any 'if'. There are two solutions:
  dnl - Invoke AM_ICONV_LINKFLAGS_BODY here, outside any 'if'.
  dnl - Control the expansions in more detail using AC_PROVIDE_IFELSE.
  dnl Since AC_PROVIDE_IFELSE is only in autoconf >= 2.52 and not
  dnl documented, we avoid it.
  ifelse(gt_included_intl, yes, , [
    AC_REQUIRE([AM_ICONV_LINKFLAGS_BODY])
  ])

  AC_MSG_CHECKING([whether NLS is requested])
  dnl Default is enabled NLS
  AC_ARG_ENABLE(nls,
    [  --disable-nls           do not use Native Language Support],
    USE_NLS=$enableval, USE_NLS=yes)
  AC_MSG_RESULT($USE_NLS)
  AC_SUBST(USE_NLS)

  ifelse(gt_included_intl, yes, [
    BUILD_INCLUDED_LIBINTL=no
    USE_INCLUDED_LIBINTL=no
  ])
  LIBINTL=
  LTLIBINTL=
  POSUB=

  dnl If we use NLS figure out what method
  if test "$USE_NLS" = "yes"; then
    gt_use_preinstalled_gnugettext=no
    ifelse(gt_included_intl, yes, [
      AC_MSG_CHECKING([whether included gettext is requested])
      AC_ARG_WITH(included-gettext,
        [  --with-included-gettext use the GNU gettext library included here],
        nls_cv_force_use_gnu_gettext=$withval,
        nls_cv_force_use_gnu_gettext=no)
      AC_MSG_RESULT($nls_cv_force_use_gnu_gettext)

      nls_cv_use_gnu_gettext="$nls_cv_force_use_gnu_gettext"
      if test "$nls_cv_force_use_gnu_gettext" != "yes"; then
    ])
        dnl User does not insist on using GNU NLS library.  Figure out what
        dnl to use.  If GNU gettext is available we use this.  Else we have
        dnl to fall back to GNU NLS library.

        dnl Add a version number to the cache macros.
        define([gt_api_version], ifelse([$2], [need-formatstring-macros], 3, ifelse([$2], [need-ngettext], 2, 1)))
        define([gt_cv_func_gnugettext_libc], [gt_cv_func_gnugettext]gt_api_version[_libc])
        define([gt_cv_func_gnugettext_libintl], [gt_cv_func_gnugettext]gt_api_version[_libintl])

        AC_CACHE_CHECK([for GNU gettext in libc], gt_cv_func_gnugettext_libc,
         [AC_TRY_LINK([#include <libintl.h>
]ifelse([$2], [need-formatstring-macros],
[#ifndef __GNU_GETTEXT_SUPPORTED_REVISION
#define __GNU_GETTEXT_SUPPORTED_REVISION(major) ((major) == 0 ? 0 : -1)
#endif
changequote(,)dnl
typedef int array [2 * (__GNU_GETTEXT_SUPPORTED_REVISION(0) >= 1) - 1];
changequote([,])dnl
], [])[extern int _nl_msg_cat_cntr;
extern int *_nl_domain_bindings;],
            [bindtextdomain ("", "");
return (int) gettext ("")]ifelse([$2], [need-ngettext], [ + (int) ngettext ("", "", 0)], [])[ + _nl_msg_cat_cntr + *_nl_domain_bindings],
            gt_cv_func_gnugettext_libc=yes,
            gt_cv_func_gnugettext_libc=no)])

        if test "$gt_cv_func_gnugettext_libc" != "yes"; then
          dnl Sometimes libintl requires libiconv, so first search for libiconv.
          ifelse(gt_included_intl, yes, , [
            AM_ICONV_LINK
          ])
          dnl Search for libintl and define LIBINTL, LTLIBINTL and INCINTL
          dnl accordingly. Don't use AC_LIB_LINKFLAGS_BODY([intl],[iconv])
          dnl because that would add "-liconv" to LIBINTL and LTLIBINTL
          dnl even if libiconv doesn't exist.
          AC_LIB_LINKFLAGS_BODY([intl])
          AC_CACHE_CHECK([for GNU gettext in libintl],
            gt_cv_func_gnugettext_libintl,
           [gt_save_CPPFLAGS="$CPPFLAGS"
            CPPFLAGS="$CPPFLAGS $INCINTL"
            gt_save_LIBS="$LIBS"
            LIBS="$LIBS $LIBINTL"
            dnl Now see whether libintl exists and does not depend on libiconv.
            AC_TRY_LINK([#include <libintl.h>
]ifelse([$2], [need-formatstring-macros],
[#ifndef __GNU_GETTEXT_SUPPORTED_REVISION
#define __GNU_GETTEXT_SUPPORTED_REVISION(major) ((major) == 0 ? 0 : -1)
#endif
changequote(,)dnl
typedef int array [2 * (__GNU_GETTEXT_SUPPORTED_REVISION(0) >= 1) - 1];
changequote([,])dnl
], [])[extern int _nl_msg_cat_cntr;
extern
#ifdef __cplusplus
"C"
#endif
const char *_nl_expand_alias ();],
              [bindtextdomain ("", "");
return (int) gettext ("")]ifelse([$2], [need-ngettext], [ + (int) ngettext ("", "", 0)], [])[ + _nl_msg_cat_cntr + *_nl_expand_alias (0)],
              gt_cv_func_gnugettext_libintl=yes,
              gt_cv_func_gnugettext_libintl=no)
            dnl Now see whether libintl exists and depends on libiconv.
            if test "$gt_cv_func_gnugettext_libintl" != yes && test -n "$LIBICONV"; then
              LIBS="$LIBS $LIBICONV"
              AC_TRY_LINK([#include <libintl.h>
]ifelse([$2], [need-formatstring-macros],
[#ifndef __GNU_GETTEXT_SUPPORTED_REVISION
#define __GNU_GETTEXT_SUPPORTED_REVISION(major) ((major) == 0 ? 0 : -1)
#endif
changequote(,)dnl
typedef int array [2 * (__GNU_GETTEXT_SUPPORTED_REVISION(0) >= 1) - 1];
changequote([,])dnl
], [])[extern int _nl_msg_cat_cntr;
extern
#ifdef __cplusplus
"C"
#endif
const char *_nl_expand_alias ();],
                [bindtextdomain ("", "");
return (int) gettext ("")]ifelse([$2], [need-ngettext], [ + (int) ngettext ("", "", 0)], [])[ + _nl_msg_cat_cntr + *_nl_expand_alias (0)],
               [LIBINTL="$LIBINTL $LIBICONV"
                LTLIBINTL="$LTLIBINTL $LTLIBICONV"
                gt_cv_func_gnugettext_libintl=yes
               ])
            fi
            CPPFLAGS="$gt_save_CPPFLAGS"
            LIBS="$gt_save_LIBS"])
        fi

        dnl If an already present or preinstalled GNU gettext() is found,
        dnl use it.  But if this macro is used in GNU gettext, and GNU
        dnl gettext is already preinstalled in libintl, we update this
        dnl libintl.  (Cf. the install rule in intl/Makefile.in.)
        if test "$gt_cv_func_gnugettext_libc" = "yes" \
           || { test "$gt_cv_func_gnugettext_libintl" = "yes" \
                && test "$PACKAGE" != gettext; }; then
          gt_use_preinstalled_gnugettext=yes
        else
          dnl Reset the values set by searching for libintl.
          LIBINTL=
          LTLIBINTL=
          INCINTL=
        fi

    ifelse(gt_included_intl, yes, [
        if test "$gt_use_preinstalled_gnugettext" != "yes"; then
          dnl GNU gettext is not found in the C library.
          dnl Fall back on included GNU gettext library.
          nls_cv_use_gnu_gettext=yes
        fi
      fi

      if test "$nls_cv_use_gnu_gettext" = "yes"; then
        dnl Mark actions used to generate GNU NLS library.
        INTLOBJS="\$(GETTOBJS)"
        BUILD_INCLUDED_LIBINTL=yes
        USE_INCLUDED_LIBINTL=yes
        LIBINTL="ifelse([$3],[],\${top_builddir}/intl,[$3])/libintl.[]gt_libtool_suffix_prefix[]a $LIBICONV"
        LTLIBINTL="ifelse([$3],[],\${top_builddir}/intl,[$3])/libintl.[]gt_libtool_suffix_prefix[]a $LTLIBICONV"
        LIBS=`echo " $LIBS " | sed -e 's/ -lintl / /' -e 's/^ //' -e 's/ $//'`
      fi

      if test "$gt_use_preinstalled_gnugettext" = "yes" \
         || test "$nls_cv_use_gnu_gettext" = "yes"; then
        dnl Mark actions to use GNU gettext tools.
        CATOBJEXT=.gmo
      fi
    ])

    if test "$gt_use_preinstalled_gnugettext" = "yes" \
       || test "$nls_cv_use_gnu_gettext" = "yes"; then
      AC_DEFINE(ENABLE_NLS, 1,
        [Define to 1 if translation of program messages to the user's native language
   is requested.])
    else
      USE_NLS=no
    fi
  fi

  if test "$USE_NLS" = "yes"; then

    if test "$gt_use_preinstalled_gnugettext" = "yes"; then
      if test "$gt_cv_func_gnugettext_libintl" = "yes"; then
        AC_MSG_CHECKING([how to link with libintl])
        AC_MSG_RESULT([$LIBINTL])
        AC_LIB_APPENDTOVAR([CPPFLAGS], [$INCINTL])
      fi

      dnl For backward compatibility. Some packages may be using this.
      AC_DEFINE(HAVE_GETTEXT, 1,
       [Define if the GNU gettext() function is already present or preinstalled.])
      AC_DEFINE(HAVE_DCGETTEXT, 1,
       [Define if the GNU dcgettext() function is already present or preinstalled.])
    fi

    dnl We need to process the po/ directory.
    POSUB=po
  fi

  ifelse(gt_included_intl, yes, [
    dnl If this is used in GNU gettext we have to set BUILD_INCLUDED_LIBINTL
    dnl to 'yes' because some of the testsuite requires it.
    if test "$PACKAGE" = gettext; then
      BUILD_INCLUDED_LIBINTL=yes
    fi

    dnl Make all variables we use known to autoconf.
    AC_SUBST(BUILD_INCLUDED_LIBINTL)
    AC_SUBST(USE_INCLUDED_LIBINTL)
    AC_SUBST(CATOBJEXT)
    AC_SUBST(INTLOBJS)

    dnl For backward compatibility. Some configure.ins may be using this.
    nls_cv_header_intl=
    nls_cv_header_libgt=

    dnl For backward compatibility. Some Makefiles may be using this.
    DATADIRNAME=share
    AC_SUBST(DATADIRNAME)

    dnl For backward compatibility. Some Makefiles may be using this.
    INSTOBJEXT=.mo
    AC_SUBST(INSTOBJEXT)

    dnl For backward compatibility. Some Makefiles may be using this.
    GENCAT=gencat
    AC_SUBST(GENCAT)

    dnl Enable libtool support if the surrounding package wishes it.
    INTL_LIBTOOL_SUFFIX_PREFIX=gt_libtool_suffix_prefix
    AC_SUBST(INTL_LIBTOOL_SUFFIX_PREFIX)
  ])

  dnl For backward compatibility. Some Makefiles may be using this.
  INTLLIBS="$LIBINTL"
  AC_SUBST(INTLLIBS)

  dnl Make all documented variables known to autoconf.
  AC_SUBST(LIBINTL)
  AC_SUBST(LTLIBINTL)
  AC_SUBST(POSUB)
])


dnl Checks for all prerequisites of the po subdirectory,
dnl except for USE_NLS.
AC_DEFUN([AM_PO_SUBDIRS],
[
  AC_REQUIRE([AC_PROG_MAKE_SET])dnl
  AC_REQUIRE([AC_PROG_INSTALL])dnl
  AC_REQUIRE([AM_MKINSTALLDIRS])dnl

  dnl Perform the following tests also if --disable-nls has been given,
  dnl because they are needed for "make dist" to work.

  dnl Search for GNU msgfmt in the PATH.
  dnl The first test excludes Solaris msgfmt and early GNU msgfmt versions.
  dnl The second test excludes FreeBSD msgfmt.
  AM_PATH_PROG_WITH_TEST(MSGFMT, msgfmt,
    [$ac_dir/$ac_word --statistics /dev/null >/dev/null 2>&1 &&
     (if $ac_dir/$ac_word --statistics /dev/null 2>&1 >/dev/null | grep usage >/dev/null; then exit 1; else exit 0; fi)],
    :)
  AC_PATH_PROG(GMSGFMT, gmsgfmt, $MSGFMT)

  dnl Search for GNU xgettext 0.11 or newer in the PATH.
  dnl The first test excludes Solaris xgettext and early GNU xgettext versions.
  dnl The second test excludes FreeBSD xgettext.
  AM_PATH_PROG_WITH_TEST(XGETTEXT, xgettext,
    [$ac_dir/$ac_word --omit-header --copyright-holder= /dev/null >/dev/null 2>&1 &&
     (if $ac_dir/$ac_word --omit-header --copyright-holder= /dev/null 2>&1 >/dev/null | grep usage >/dev/null; then exit 1; else exit 0; fi)],
    :)
  dnl Remove leftover from FreeBSD xgettext call.
  rm -f messages.po

  dnl Search for GNU msgmerge 0.11 or newer in the PATH.
  AM_PATH_PROG_WITH_TEST(MSGMERGE, msgmerge,
    [$ac_dir/$ac_word --update -q /dev/null /dev/null >/dev/null 2>&1], :)

  dnl This could go away some day; the PATH_PROG_WITH_TEST already does it.
  dnl Test whether we really found GNU msgfmt.
  if test "$GMSGFMT" != ":"; then
    dnl If it is no GNU msgfmt we define it as : so that the
    dnl Makefiles still can work.
    if $GMSGFMT --statistics /dev/null >/dev/null 2>&1 &&
       (if $GMSGFMT --statistics /dev/null 2>&1 >/dev/null | grep usage >/dev/null; then exit 1; else exit 0; fi); then
      : ;
    else
      GMSGFMT=`echo "$GMSGFMT" | sed -e 's,^.*/,,'`
      AC_MSG_RESULT(
        [found $GMSGFMT program is not GNU msgfmt; ignore it])
      GMSGFMT=":"
    fi
  fi

  dnl This could go away some day; the PATH_PROG_WITH_TEST already does it.
  dnl Test whether we really found GNU xgettext.
  if test "$XGETTEXT" != ":"; then
    dnl If it is no GNU xgettext we define it as : so that the
    dnl Makefiles still can work.
    if $XGETTEXT --omit-header --copyright-holder= /dev/null >/dev/null 2>&1 &&
       (if $XGETTEXT --omit-header --copyright-holder= /dev/null 2>&1 >/dev/null | grep usage >/dev/null; then exit 1; else exit 0; fi); then
      : ;
    else
      AC_MSG_RESULT(
        [found xgettext program is not GNU xgettext; ignore it])
      XGETTEXT=":"
    fi
    dnl Remove leftover from FreeBSD xgettext call.
    rm -f messages.po
  fi

  AC_OUTPUT_COMMANDS([
    for ac_file in $CONFIG_FILES; do
      # Support "outfile[:infile[:infile...]]"
      case "$ac_file" in
        *:*) ac_file=`echo "$ac_file"|sed 's%:.*%%'` ;;
      esac
      # PO directories have a Makefile.in generated from Makefile.in.in.
      case "$ac_file" in */Makefile.in)
        # Adjust a relative srcdir.
        ac_dir=`echo "$ac_file"|sed 's%/[^/][^/]*$%%'`
        ac_dir_suffix="/`echo "$ac_dir"|sed 's%^\./%%'`"
        ac_dots=`echo "$ac_dir_suffix"|sed 's%/[^/]*%../%g'`
        # In autoconf-2.13 it is called $ac_given_srcdir.
        # In autoconf-2.50 it is called $srcdir.
        test -n "$ac_given_srcdir" || ac_given_srcdir="$srcdir"
        case "$ac_given_srcdir" in
          .)  top_srcdir=`echo $ac_dots|sed 's%/$%%'` ;;
          /*) top_srcdir="$ac_given_srcdir" ;;
          *)  top_srcdir="$ac_dots$ac_given_srcdir" ;;
        esac
        if test -f "$ac_given_srcdir/$ac_dir/POTFILES.in"; then
          rm -f "$ac_dir/POTFILES"
          test -n "$as_me" && echo "$as_me: creating $ac_dir/POTFILES" || echo "creating $ac_dir/POTFILES"
          cat "$ac_given_srcdir/$ac_dir/POTFILES.in" | sed -e "/^#/d" -e "/^[ 	]*\$/d" -e "s,.*,     $top_srcdir/& \\\\," | sed -e "\$s/\(.*\) \\\\/\1/" > "$ac_dir/POTFILES"
          # ALL_LINGUAS, POFILES, GMOFILES, UPDATEPOFILES, DUMMYPOFILES depend
          # on $ac_dir but don't depend on user-specified configuration
          # parameters.
          if test -f "$ac_given_srcdir/$ac_dir/LINGUAS"; then
            # The LINGUAS file contains the set of available languages.
            if test -n "$ALL_LINGUAS"; then
              test -n "$as_me" && echo "$as_me: setting ALL_LINGUAS in configure.in is obsolete" || echo "setting ALL_LINGUAS in configure.in is obsolete"
            fi
            ALL_LINGUAS_=`sed -e "/^#/d" "$ac_given_srcdir/$ac_dir/LINGUAS"`
            # Hide the ALL_LINGUAS assigment from automake.
            eval 'ALL_LINGUAS''=$ALL_LINGUAS_'
          fi
          case "$ac_given_srcdir" in
            .) srcdirpre= ;;
            *) srcdirpre='$(srcdir)/' ;;
          esac
          POFILES=
          GMOFILES=
          UPDATEPOFILES=
          DUMMYPOFILES=
          for lang in $ALL_LINGUAS; do
            POFILES="$POFILES $srcdirpre$lang.po"
            GMOFILES="$GMOFILES $srcdirpre$lang.gmo"
            UPDATEPOFILES="$UPDATEPOFILES $lang.po-update"
            DUMMYPOFILES="$DUMMYPOFILES $lang.nop"
          done
          # CATALOGS depends on both $ac_dir and the user's LINGUAS
          # environment variable.
          INST_LINGUAS=
          if test -n "$ALL_LINGUAS"; then
            for presentlang in $ALL_LINGUAS; do
              useit=no
              if test "%UNSET%" != "$LINGUAS"; then
                desiredlanguages="$LINGUAS"
              else
                desiredlanguages="$ALL_LINGUAS"
              fi
              for desiredlang in $desiredlanguages; do
                # Use the presentlang catalog if desiredlang is
                #   a. equal to presentlang, or
                #   b. a variant of presentlang (because in this case,
                #      presentlang can be used as a fallback for messages
                #      which are not translated in the desiredlang catalog).
                case "$desiredlang" in
                  "$presentlang"*) useit=yes;;
                esac
              done
              if test $useit = yes; then
                INST_LINGUAS="$INST_LINGUAS $presentlang"
              fi
            done
          fi
          CATALOGS=
          if test -n "$INST_LINGUAS"; then
            for lang in $INST_LINGUAS; do
              CATALOGS="$CATALOGS $lang.gmo"
            done
          fi
          test -n "$as_me" && echo "$as_me: creating $ac_dir/Makefile" || echo "creating $ac_dir/Makefile"
          sed -e "/^POTFILES =/r $ac_dir/POTFILES" -e "/^# Makevars/r $ac_given_srcdir/$ac_dir/Makevars" -e "s|@POFILES@|$POFILES|g" -e "s|@GMOFILES@|$GMOFILES|g" -e "s|@UPDATEPOFILES@|$UPDATEPOFILES|g" -e "s|@DUMMYPOFILES@|$DUMMYPOFILES|g" -e "s|@CATALOGS@|$CATALOGS|g" "$ac_dir/Makefile.in" > "$ac_dir/Makefile"
          for f in "$ac_given_srcdir/$ac_dir"/Rules-*; do
            if test -f "$f"; then
              case "$f" in
                *.orig | *.bak | *~) ;;
                *) cat "$f" >> "$ac_dir/Makefile" ;;
              esac
            fi
          done
        fi
        ;;
      esac
    done],
   [# Capture the value of obsolete ALL_LINGUAS because we need it to compute
    # POFILES, GMOFILES, UPDATEPOFILES, DUMMYPOFILES, CATALOGS. But hide it
    # from automake.
    eval 'ALL_LINGUAS''="$ALL_LINGUAS"'
    # Capture the value of LINGUAS because we need it to compute CATALOGS.
    LINGUAS="${LINGUAS-%UNSET%}"
   ])
])


dnl Checks for all prerequisites of the intl subdirectory,
dnl except for INTL_LIBTOOL_SUFFIX_PREFIX (and possibly LIBTOOL), INTLOBJS,
dnl            USE_INCLUDED_LIBINTL, BUILD_INCLUDED_LIBINTL.
AC_DEFUN([AM_INTL_SUBDIR],
[
  AC_REQUIRE([AC_PROG_INSTALL])dnl
  AC_REQUIRE([AM_MKINSTALLDIRS])dnl
  AC_REQUIRE([AC_PROG_CC])dnl
  AC_REQUIRE([AC_CANONICAL_HOST])dnl
  AC_REQUIRE([AC_PROG_RANLIB])dnl
  AC_REQUIRE([AC_ISC_POSIX])dnl
  AC_REQUIRE([AC_HEADER_STDC])dnl
  AC_REQUIRE([AC_C_CONST])dnl
  AC_REQUIRE([AC_C_INLINE])dnl
  AC_REQUIRE([AC_TYPE_OFF_T])dnl
  AC_REQUIRE([AC_TYPE_SIZE_T])dnl
  AC_REQUIRE([AC_FUNC_ALLOCA])dnl
  AC_REQUIRE([AC_FUNC_MMAP])dnl
  AC_REQUIRE([jm_GLIBC21])dnl
  AC_REQUIRE([gt_INTDIV0])dnl
  AC_REQUIRE([jm_AC_TYPE_UINTMAX_T])dnl
  AC_REQUIRE([gt_HEADER_INTTYPES_H])dnl
  AC_REQUIRE([gt_INTTYPES_PRI])dnl

  AC_CHECK_HEADERS([argz.h limits.h locale.h nl_types.h malloc.h stddef.h \
stdlib.h string.h unistd.h sys/param.h])
  AC_CHECK_FUNCS([feof_unlocked fgets_unlocked getc_unlocked getcwd getegid \
geteuid getgid getuid mempcpy munmap putenv setenv setlocale stpcpy \
strcasecmp strdup strtoul tsearch __argz_count __argz_stringify __argz_next])

  AM_ICONV
  AM_LANGINFO_CODESET
  if test $ac_cv_header_locale_h = yes; then
    AM_LC_MESSAGES
  fi

  dnl intl/plural.c is generated from intl/plural.y. It requires bison,
  dnl because plural.y uses bison specific features. It requires at least
  dnl bison-1.26 because earlier versions generate a plural.c that doesn't
  dnl compile.
  dnl bison is only needed for the maintainer (who touches plural.y). But in
  dnl order to avoid separate Makefiles or --enable-maintainer-mode, we put
  dnl the rule in general Makefile. Now, some people carelessly touch the
  dnl files or have a broken "make" program, hence the plural.c rule will
  dnl sometimes fire. To avoid an error, defines BISON to ":" if it is not
  dnl present or too old.
  AC_CHECK_PROGS([INTLBISON], [bison])
  if test -z "$INTLBISON"; then
    ac_verc_fail=yes
  else
    dnl Found it, now check the version.
    AC_MSG_CHECKING([version of bison])
changequote(<<,>>)dnl
    ac_prog_version=`$INTLBISON --version 2>&1 | sed -n 's/^.*GNU Bison.* \([0-9]*\.[0-9.]*\).*$/\1/p'`
    case $ac_prog_version in
      '') ac_prog_version="v. ?.??, bad"; ac_verc_fail=yes;;
      1.2[6-9]* | 1.[3-9][0-9]* | [2-9].*)
changequote([,])dnl
         ac_prog_version="$ac_prog_version, ok"; ac_verc_fail=no;;
      *) ac_prog_version="$ac_prog_version, bad"; ac_verc_fail=yes;;
    esac
    AC_MSG_RESULT([$ac_prog_version])
  fi
  if test $ac_verc_fail = yes; then
    INTLBISON=:
  fi
])


AC_DEFUN([AM_MKINSTALLDIRS],
[
  dnl If the AC_CONFIG_AUX_DIR macro for autoconf is used we possibly
  dnl find the mkinstalldirs script in another subdir but $(top_srcdir).
  dnl Try to locate is.
  MKINSTALLDIRS=
  if test -n "$ac_aux_dir"; then
    MKINSTALLDIRS="$ac_aux_dir/mkinstalldirs"
  fi
  if test -z "$MKINSTALLDIRS"; then
    MKINSTALLDIRS="\$(top_srcdir)/mkinstalldirs"
  fi
  AC_SUBST(MKINSTALLDIRS)
])


dnl Usage: AM_GNU_GETTEXT_VERSION([gettext-version])
AC_DEFUN([AM_GNU_GETTEXT_VERSION], [])


# glibc21.m4 serial 2 (fileutils-4.1.3, gettext-0.10.40)
dnl Copyright (C) 2000-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

# Test for the GNU C Library, version 2.1 or newer.
# From Bruno Haible.

AC_DEFUN([jm_GLIBC21],
  [
    AC_CACHE_CHECK(whether we are using the GNU C Library 2.1 or newer,
      ac_cv_gnu_library_2_1,
      [AC_EGREP_CPP([Lucky GNU user],
	[
#include <features.h>
#ifdef __GNU_LIBRARY__
 #if (__GLIBC__ == 2 && __GLIBC_MINOR__ >= 1) || (__GLIBC__ > 2)
  Lucky GNU user
 #endif
#endif
	],
	ac_cv_gnu_library_2_1=yes,
	ac_cv_gnu_library_2_1=no)
      ]
    )
    AC_SUBST(GLIBC21)
    GLIBC21="$ac_cv_gnu_library_2_1"
  ]
)


# iconv.m4 serial AM4 (gettext-0.11.3)
dnl Copyright (C) 2000-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible.

AC_DEFUN([AM_ICONV_LINKFLAGS_BODY],
[
  dnl Prerequisites of AC_LIB_LINKFLAGS_BODY.
  AC_REQUIRE([AC_LIB_PREPARE_PREFIX])
  AC_REQUIRE([AC_LIB_RPATH])

  dnl Search for libiconv and define LIBICONV, LTLIBICONV and INCICONV
  dnl accordingly.
  AC_LIB_LINKFLAGS_BODY([iconv])
])

AC_DEFUN([AM_ICONV_LINK],
[
  dnl Some systems have iconv in libc, some have it in libiconv (OSF/1 and
  dnl those with the standalone portable GNU libiconv installed).

  dnl Search for libiconv and define LIBICONV, LTLIBICONV and INCICONV
  dnl accordingly.
  AC_REQUIRE([AM_ICONV_LINKFLAGS_BODY])

  dnl Add $INCICONV to CPPFLAGS before performing the following checks,
  dnl because if the user has installed libiconv and not disabled its use
  dnl via --without-libiconv-prefix, he wants to use it. The first
  dnl AC_TRY_LINK will then fail, the second AC_TRY_LINK will succeed.
  am_save_CPPFLAGS="$CPPFLAGS"
  AC_LIB_APPENDTOVAR([CPPFLAGS], [$INCICONV])

  AC_CACHE_CHECK(for iconv, am_cv_func_iconv, [
    am_cv_func_iconv="no, consider installing GNU libiconv"
    am_cv_lib_iconv=no
    AC_TRY_LINK([#include <stdlib.h>
#include <iconv.h>],
      [iconv_t cd = iconv_open("","");
       iconv(cd,NULL,NULL,NULL,NULL);
       iconv_close(cd);],
      am_cv_func_iconv=yes)
    if test "$am_cv_func_iconv" != yes; then
      am_save_LIBS="$LIBS"
      LIBS="$LIBS $LIBICONV"
      AC_TRY_LINK([#include <stdlib.h>
#include <iconv.h>],
        [iconv_t cd = iconv_open("","");
         iconv(cd,NULL,NULL,NULL,NULL);
         iconv_close(cd);],
        am_cv_lib_iconv=yes
        am_cv_func_iconv=yes)
      LIBS="$am_save_LIBS"
    fi
  ])
  if test "$am_cv_func_iconv" = yes; then
    AC_DEFINE(HAVE_ICONV, 1, [Define if you have the iconv() function.])
  fi
  if test "$am_cv_lib_iconv" = yes; then
    AC_MSG_CHECKING([how to link with libiconv])
    AC_MSG_RESULT([$LIBICONV])
  else
    dnl If $LIBICONV didn't lead to a usable library, we don't need $INCICONV
    dnl either.
    CPPFLAGS="$am_save_CPPFLAGS"
    LIBICONV=
    LTLIBICONV=
  fi
  AC_SUBST(LIBICONV)
  AC_SUBST(LTLIBICONV)
])

AC_DEFUN([AM_ICONV],
[
  AM_ICONV_LINK
  if test "$am_cv_func_iconv" = yes; then
    AC_MSG_CHECKING([for iconv declaration])
    AC_CACHE_VAL(am_cv_proto_iconv, [
      AC_TRY_COMPILE([
#include <stdlib.h>
#include <iconv.h>
extern
#ifdef __cplusplus
"C"
#endif
#if defined(__STDC__) || defined(__cplusplus)
size_t iconv (iconv_t cd, char * *inbuf, size_t *inbytesleft, char * *outbuf, size_t *outbytesleft);
#else
size_t iconv();
#endif
], [], am_cv_proto_iconv_arg1="", am_cv_proto_iconv_arg1="const")
      am_cv_proto_iconv="extern size_t iconv (iconv_t cd, $am_cv_proto_iconv_arg1 char * *inbuf, size_t *inbytesleft, char * *outbuf, size_t *outbytesleft);"])
    am_cv_proto_iconv=`echo "[$]am_cv_proto_iconv" | tr -s ' ' | sed -e 's/( /(/'`
    AC_MSG_RESULT([$]{ac_t:-
         }[$]am_cv_proto_iconv)
    AC_DEFINE_UNQUOTED(ICONV_CONST, $am_cv_proto_iconv_arg1,
      [Define as const if the declaration of iconv() needs const.])
  fi
])


# intdiv0.m4 serial 1 (gettext-0.11.3)
dnl Copyright (C) 2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible.

AC_DEFUN([gt_INTDIV0],
[
  AC_REQUIRE([AC_PROG_CC])dnl
  AC_REQUIRE([AC_CANONICAL_HOST])dnl

  AC_CACHE_CHECK([whether integer division by zero raises SIGFPE],
    gt_cv_int_divbyzero_sigfpe,
    [
      AC_TRY_RUN([
#include <stdlib.h>
#include <signal.h>

static void
#ifdef __cplusplus
sigfpe_handler (int sig)
#else
sigfpe_handler (sig) int sig;
#endif
{
  /* Exit with code 0 if SIGFPE, with code 1 if any other signal.  */
  exit (sig != SIGFPE);
}

int x = 1;
int y = 0;
int z;
int nan;

int main ()
{
  signal (SIGFPE, sigfpe_handler);
/* IRIX and AIX (when "xlc -qcheck" is used) yield signal SIGTRAP.  */
#if (defined (__sgi) || defined (_AIX)) && defined (SIGTRAP)
  signal (SIGTRAP, sigfpe_handler);
#endif
/* Linux/SPARC yields signal SIGILL.  */
#if defined (__sparc__) && defined (__linux__)
  signal (SIGILL, sigfpe_handler);
#endif

  z = x / y;
  nan = y / y;
  exit (1);
}
], gt_cv_int_divbyzero_sigfpe=yes, gt_cv_int_divbyzero_sigfpe=no,
        [
          # Guess based on the CPU.
          case "$host_cpu" in
            alpha* | i[34567]86 | m68k | s390*)
              gt_cv_int_divbyzero_sigfpe="guessing yes";;
            *)
              gt_cv_int_divbyzero_sigfpe="guessing no";;
          esac
        ])
    ])
  case "$gt_cv_int_divbyzero_sigfpe" in
    *yes) value=1;;
    *) value=0;;
  esac
  AC_DEFINE_UNQUOTED(INTDIV0_RAISES_SIGFPE, $value,
    [Define if integer division by zero raises signal SIGFPE.])
])


# inttypes.m4 serial 1 (gettext-0.11.4)
dnl Copyright (C) 1997-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Paul Eggert.

# Define HAVE_INTTYPES_H if <inttypes.h> exists and doesn't clash with
# <sys/types.h>.

AC_DEFUN([gt_HEADER_INTTYPES_H],
[
  AC_CACHE_CHECK([for inttypes.h], gt_cv_header_inttypes_h,
  [
    AC_TRY_COMPILE(
      [#include <sys/types.h>
#include <inttypes.h>],
      [], gt_cv_header_inttypes_h=yes, gt_cv_header_inttypes_h=no)
  ])
  if test $gt_cv_header_inttypes_h = yes; then
    AC_DEFINE_UNQUOTED(HAVE_INTTYPES_H, 1,
      [Define if <inttypes.h> exists and doesn't clash with <sys/types.h>.])
  fi
])


# inttypes_h.m4 serial 4 (gettext-0.11.4)
dnl Copyright (C) 1997-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Paul Eggert.

# Define HAVE_INTTYPES_H_WITH_UINTMAX if <inttypes.h> exists,
# doesn't clash with <sys/types.h>, and declares uintmax_t.

AC_DEFUN([jm_AC_HEADER_INTTYPES_H],
[
  AC_CACHE_CHECK([for inttypes.h], jm_ac_cv_header_inttypes_h,
  [AC_TRY_COMPILE(
    [#include <sys/types.h>
#include <inttypes.h>],
    [uintmax_t i = (uintmax_t) -1;],
    jm_ac_cv_header_inttypes_h=yes,
    jm_ac_cv_header_inttypes_h=no)])
  if test $jm_ac_cv_header_inttypes_h = yes; then
    AC_DEFINE_UNQUOTED(HAVE_INTTYPES_H_WITH_UINTMAX, 1,
[Define if <inttypes.h> exists, doesn't clash with <sys/types.h>,
   and declares uintmax_t. ])
  fi
])


# inttypes-pri.m4 serial 1 (gettext-0.11.4)
dnl Copyright (C) 1997-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible.

# Define PRI_MACROS_BROKEN if <inttypes.h> exists and defines the PRI*
# macros to non-string values.  This is the case on AIX 4.3.3.

AC_DEFUN([gt_INTTYPES_PRI],
[
  AC_REQUIRE([gt_HEADER_INTTYPES_H])
  if test $gt_cv_header_inttypes_h = yes; then
    AC_CACHE_CHECK([whether the inttypes.h PRIxNN macros are broken],
      gt_cv_inttypes_pri_broken,
      [
        AC_TRY_COMPILE([#include <inttypes.h>
#ifdef PRId32
char *p = PRId32;
#endif
], [], gt_cv_inttypes_pri_broken=no, gt_cv_inttypes_pri_broken=yes)
      ])
  fi
  if test "$gt_cv_inttypes_pri_broken" = yes; then
    AC_DEFINE_UNQUOTED(PRI_MACROS_BROKEN, 1,
      [Define if <inttypes.h> exists and defines unusable PRI* macros.])
  fi
])


# isc-posix.m4 serial 2 (gettext-0.11.2)
dnl Copyright (C) 1995-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

# This file is not needed with autoconf-2.53 and newer.  Remove it in 2005.

# This test replaces the one in autoconf.
# Currently this macro should have the same name as the autoconf macro
# because gettext's gettext.m4 (distributed in the automake package)
# still uses it.  Otherwise, the use in gettext.m4 makes autoheader
# give these diagnostics:
#   configure.in:556: AC_TRY_COMPILE was called before AC_ISC_POSIX
#   configure.in:556: AC_TRY_RUN was called before AC_ISC_POSIX

undefine([AC_ISC_POSIX])

AC_DEFUN([AC_ISC_POSIX],
  [
    dnl This test replaces the obsolescent AC_ISC_POSIX kludge.
    AC_CHECK_LIB(cposix, strerror, [LIBS="$LIBS -lcposix"])
  ]
)


# lcmessage.m4 serial 3 (gettext-0.11.3)
dnl Copyright (C) 1995-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.
dnl
dnl This file can can be used in projects which are not available under
dnl the GNU General Public License or the GNU Library General Public
dnl License but which still want to provide support for the GNU gettext
dnl functionality.
dnl Please note that the actual code of the GNU gettext library is covered
dnl by the GNU Library General Public License, and the rest of the GNU
dnl gettext package package is covered by the GNU General Public License.
dnl They are *not* in the public domain.

dnl Authors:
dnl   Ulrich Drepper <drepper@cygnus.com>, 1995.

# Check whether LC_MESSAGES is available in <locale.h>.

AC_DEFUN([AM_LC_MESSAGES],
[
  AC_CACHE_CHECK([for LC_MESSAGES], am_cv_val_LC_MESSAGES,
    [AC_TRY_LINK([#include <locale.h>], [return LC_MESSAGES],
       am_cv_val_LC_MESSAGES=yes, am_cv_val_LC_MESSAGES=no)])
  if test $am_cv_val_LC_MESSAGES = yes; then
    AC_DEFINE(HAVE_LC_MESSAGES, 1,
      [Define if your <locale.h> file defines LC_MESSAGES.])
  fi
])


# lib-ld.m4 serial 1 (gettext-0.11)
dnl Copyright (C) 1996-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl Subroutines of libtool.m4,
dnl with replacements s/AC_/AC_LIB/ and s/lt_cv/acl_cv/ to avoid collision
dnl with libtool.m4.

dnl From libtool-1.4. Sets the variable with_gnu_ld to yes or no.
AC_DEFUN([AC_LIB_PROG_LD_GNU],
[AC_CACHE_CHECK([if the linker ($LD) is GNU ld], acl_cv_prog_gnu_ld,
[# I'd rather use --version here, but apparently some GNU ld's only accept -v.
if $LD -v 2>&1 </dev/null | egrep '(GNU|with BFD)' 1>&5; then
  acl_cv_prog_gnu_ld=yes
else
  acl_cv_prog_gnu_ld=no
fi])
with_gnu_ld=$acl_cv_prog_gnu_ld
])

dnl From libtool-1.4. Sets the variable LD.
AC_DEFUN([AC_LIB_PROG_LD],
[AC_ARG_WITH(gnu-ld,
[  --with-gnu-ld           assume the C compiler uses GNU ld [default=no]],
test "$withval" = no || with_gnu_ld=yes, with_gnu_ld=no)
AC_REQUIRE([AC_PROG_CC])dnl
AC_REQUIRE([AC_CANONICAL_HOST])dnl
ac_prog=ld
if test "$GCC" = yes; then
  # Check if gcc -print-prog-name=ld gives a path.
  AC_MSG_CHECKING([for ld used by GCC])
  case $host in
  *-*-mingw*)
    # gcc leaves a trailing carriage return which upsets mingw
    ac_prog=`($CC -print-prog-name=ld) 2>&5 | tr -d '\015'` ;;
  *)
    ac_prog=`($CC -print-prog-name=ld) 2>&5` ;;
  esac
  case $ac_prog in
    # Accept absolute paths.
    [[\\/]* | [A-Za-z]:[\\/]*)]
      [re_direlt='/[^/][^/]*/\.\./']
      # Canonicalize the path of ld
      ac_prog=`echo $ac_prog| sed 's%\\\\%/%g'`
      while echo $ac_prog | grep "$re_direlt" > /dev/null 2>&1; do
	ac_prog=`echo $ac_prog| sed "s%$re_direlt%/%"`
      done
      test -z "$LD" && LD="$ac_prog"
      ;;
  "")
    # If it fails, then pretend we aren't using GCC.
    ac_prog=ld
    ;;
  *)
    # If it is relative, then search for the first ld in PATH.
    with_gnu_ld=unknown
    ;;
  esac
elif test "$with_gnu_ld" = yes; then
  AC_MSG_CHECKING([for GNU ld])
else
  AC_MSG_CHECKING([for non-GNU ld])
fi
AC_CACHE_VAL(acl_cv_path_LD,
[if test -z "$LD"; then
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}${PATH_SEPARATOR-:}"
  for ac_dir in $PATH; do
    test -z "$ac_dir" && ac_dir=.
    if test -f "$ac_dir/$ac_prog" || test -f "$ac_dir/$ac_prog$ac_exeext"; then
      acl_cv_path_LD="$ac_dir/$ac_prog"
      # Check to see if the program is GNU ld.  I'd rather use --version,
      # but apparently some GNU ld's only accept -v.
      # Break only if it was the GNU/non-GNU ld that we prefer.
      if "$acl_cv_path_LD" -v 2>&1 < /dev/null | egrep '(GNU|with BFD)' > /dev/null; then
	test "$with_gnu_ld" != no && break
      else
	test "$with_gnu_ld" != yes && break
      fi
    fi
  done
  IFS="$ac_save_ifs"
else
  acl_cv_path_LD="$LD" # Let the user override the test with a path.
fi])
LD="$acl_cv_path_LD"
if test -n "$LD"; then
  AC_MSG_RESULT($LD)
else
  AC_MSG_RESULT(no)
fi
test -z "$LD" && AC_MSG_ERROR([no acceptable ld found in \$PATH])
AC_LIB_PROG_LD_GNU
])


# lib-prefix.m4 serial 1 (gettext-0.11)
dnl Copyright (C) 2001-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible.

dnl AC_LIB_PREFIX adds to the CPPFLAGS and LDFLAGS the flags that are needed
dnl to access previously installed libraries. The basic assumption is that
dnl a user will want packages to use other packages he previously installed
dnl with the same --prefix option.
dnl This macro is not needed if only AC_LIB_LINKFLAGS is used to locate
dnl libraries, but is otherwise very convenient.
AC_DEFUN([AC_LIB_PREFIX],
[
  AC_BEFORE([$0], [AC_LIB_LINKFLAGS])
  AC_REQUIRE([AC_PROG_CC])
  AC_REQUIRE([AC_CANONICAL_HOST])
  AC_REQUIRE([AC_LIB_PREPARE_PREFIX])
  dnl By default, look in $includedir and $libdir.
  use_additional=yes
  AC_LIB_WITH_FINAL_PREFIX([
    eval additional_includedir=\"$includedir\"
    eval additional_libdir=\"$libdir\"
  ])
  AC_ARG_WITH([lib-prefix],
[  --with-lib-prefix[=DIR] search for libraries in DIR/include and DIR/lib
  --without-lib-prefix    don't search for libraries in includedir and libdir],
[
    if test "X$withval" = "Xno"; then
      use_additional=no
    else
      if test "X$withval" = "X"; then
        AC_LIB_WITH_FINAL_PREFIX([
          eval additional_includedir=\"$includedir\"
          eval additional_libdir=\"$libdir\"
        ])
      else
        additional_includedir="$withval/include"
        additional_libdir="$withval/lib"
      fi
    fi
])
  if test $use_additional = yes; then
    dnl Potentially add $additional_includedir to $CPPFLAGS.
    dnl But don't add it
    dnl   1. if it's the standard /usr/include,
    dnl   2. if it's already present in $CPPFLAGS,
    dnl   3. if it's /usr/local/include and we are using GCC on Linux,
    dnl   4. if it doesn't exist as a directory.
    if test "X$additional_includedir" != "X/usr/include"; then
      haveit=
      for x in $CPPFLAGS; do
        AC_LIB_WITH_FINAL_PREFIX([eval x=\"$x\"])
        if test "X$x" = "X-I$additional_includedir"; then
          haveit=yes
          break
        fi
      done
      if test -z "$haveit"; then
        if test "X$additional_includedir" = "X/usr/local/include"; then
          if test -n "$GCC"; then
            case $host_os in
              linux*) haveit=yes;;
            esac
          fi
        fi
        if test -z "$haveit"; then
          if test -d "$additional_includedir"; then
            dnl Really add $additional_includedir to $CPPFLAGS.
            CPPFLAGS="${CPPFLAGS}${CPPFLAGS:+ }-I$additional_includedir"
          fi
        fi
      fi
    fi
    dnl Potentially add $additional_libdir to $LDFLAGS.
    dnl But don't add it
    dnl   1. if it's the standard /usr/lib,
    dnl   2. if it's already present in $LDFLAGS,
    dnl   3. if it's /usr/local/lib and we are using GCC on Linux,
    dnl   4. if it doesn't exist as a directory.
    if test "X$additional_libdir" != "X/usr/lib"; then
      haveit=
      for x in $LDFLAGS; do
        AC_LIB_WITH_FINAL_PREFIX([eval x=\"$x\"])
        if test "X$x" = "X-L$additional_libdir"; then
          haveit=yes
          break
        fi
      done
      if test -z "$haveit"; then
        if test "X$additional_libdir" = "X/usr/local/lib"; then
          if test -n "$GCC"; then
            case $host_os in
              linux*) haveit=yes;;
            esac
          fi
        fi
        if test -z "$haveit"; then
          if test -d "$additional_libdir"; then
            dnl Really add $additional_libdir to $LDFLAGS.
            LDFLAGS="${LDFLAGS}${LDFLAGS:+ }-L$additional_libdir"
          fi
        fi
      fi
    fi
  fi
])

dnl AC_LIB_PREPARE_PREFIX creates variables acl_final_prefix,
dnl acl_final_exec_prefix, containing the values to which $prefix and
dnl $exec_prefix will expand at the end of the configure script.
AC_DEFUN([AC_LIB_PREPARE_PREFIX],
[
  dnl Unfortunately, prefix and exec_prefix get only finally determined
  dnl at the end of configure.
  if test "X$prefix" = "XNONE"; then
    acl_final_prefix="$ac_default_prefix"
  else
    acl_final_prefix="$prefix"
  fi
  if test "X$exec_prefix" = "XNONE"; then
    acl_final_exec_prefix='${prefix}'
  else
    acl_final_exec_prefix="$exec_prefix"
  fi
  acl_save_prefix="$prefix"
  prefix="$acl_final_prefix"
  eval acl_final_exec_prefix=\"$acl_final_exec_prefix\"
  prefix="$acl_save_prefix"
])

dnl AC_LIB_WITH_FINAL_PREFIX([statement]) evaluates statement, with the
dnl variables prefix and exec_prefix bound to the values they will have
dnl at the end of the configure script.
AC_DEFUN([AC_LIB_WITH_FINAL_PREFIX],
[
  acl_save_prefix="$prefix"
  prefix="$acl_final_prefix"
  acl_save_exec_prefix="$exec_prefix"
  exec_prefix="$acl_final_exec_prefix"
  $1
  exec_prefix="$acl_save_exec_prefix"
  prefix="$acl_save_prefix"
])


# lib-link.m4 serial 3 (gettext-0.11.3)
dnl Copyright (C) 2001-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible.

dnl AC_LIB_LINKFLAGS(name [, dependencies]) searches for libname and
dnl the libraries corresponding to explicit and implicit dependencies.
dnl Sets and AC_SUBSTs the LIB${NAME} and LTLIB${NAME} variables and
dnl augments the CPPFLAGS variable.
AC_DEFUN([AC_LIB_LINKFLAGS],
[
  AC_REQUIRE([AC_LIB_PREPARE_PREFIX])
  AC_REQUIRE([AC_LIB_RPATH])
  define([Name],[translit([$1],[./-], [___])])
  define([NAME],[translit([$1],[abcdefghijklmnopqrstuvwxyz./-],
                               [ABCDEFGHIJKLMNOPQRSTUVWXYZ___])])
  AC_CACHE_CHECK([how to link with lib[]$1], [ac_cv_lib[]Name[]_libs], [
    AC_LIB_LINKFLAGS_BODY([$1], [$2])
    ac_cv_lib[]Name[]_libs="$LIB[]NAME"
    ac_cv_lib[]Name[]_ltlibs="$LTLIB[]NAME"
    ac_cv_lib[]Name[]_cppflags="$INC[]NAME"
  ])
  LIB[]NAME="$ac_cv_lib[]Name[]_libs"
  LTLIB[]NAME="$ac_cv_lib[]Name[]_ltlibs"
  INC[]NAME="$ac_cv_lib[]Name[]_cppflags"
  AC_LIB_APPENDTOVAR([CPPFLAGS], [$INC]NAME)
  AC_SUBST([LIB]NAME)
  AC_SUBST([LTLIB]NAME)
  dnl Also set HAVE_LIB[]NAME so that AC_LIB_HAVE_LINKFLAGS can reuse the
  dnl results of this search when this library appears as a dependency.
  HAVE_LIB[]NAME=yes
  undefine([Name])
  undefine([NAME])
])

dnl AC_LIB_HAVE_LINKFLAGS(name, dependencies, includes, testcode)
dnl searches for libname and the libraries corresponding to explicit and
dnl implicit dependencies, together with the specified include files and
dnl the ability to compile and link the specified testcode. If found, it
dnl sets and AC_SUBSTs HAVE_LIB${NAME}=yes and the LIB${NAME} and
dnl LTLIB${NAME} variables and augments the CPPFLAGS variable, and
dnl #defines HAVE_LIB${NAME} to 1. Otherwise, it sets and AC_SUBSTs
dnl HAVE_LIB${NAME}=no and LIB${NAME} and LTLIB${NAME} to empty.
AC_DEFUN([AC_LIB_HAVE_LINKFLAGS],
[
  AC_REQUIRE([AC_LIB_PREPARE_PREFIX])
  AC_REQUIRE([AC_LIB_RPATH])
  define([Name],[translit([$1],[./-], [___])])
  define([NAME],[translit([$1],[abcdefghijklmnopqrstuvwxyz./-],
                               [ABCDEFGHIJKLMNOPQRSTUVWXYZ___])])

  dnl Search for lib[]Name and define LIB[]NAME, LTLIB[]NAME and INC[]NAME
  dnl accordingly.
  AC_LIB_LINKFLAGS_BODY([$1], [$2])

  dnl Add $INC[]NAME to CPPFLAGS before performing the following checks,
  dnl because if the user has installed lib[]Name and not disabled its use
  dnl via --without-lib[]Name-prefix, he wants to use it.
  ac_save_CPPFLAGS="$CPPFLAGS"
  AC_LIB_APPENDTOVAR([CPPFLAGS], [$INC]NAME)

  AC_CACHE_CHECK([for lib[]$1], [ac_cv_lib[]Name], [
    ac_save_LIBS="$LIBS"
    LIBS="$LIBS $LIB[]NAME"
    AC_TRY_LINK([$3], [$4], [ac_cv_lib[]Name=yes], [ac_cv_lib[]Name=no])
    LIBS="$ac_save_LIBS"
  ])
  if test "$ac_cv_lib[]Name" = yes; then
    HAVE_LIB[]NAME=yes
    AC_DEFINE([HAVE_LIB]NAME, 1, [Define if you have the $1 library.])
    AC_MSG_CHECKING([how to link with lib[]$1])
    AC_MSG_RESULT([$LIB[]NAME])
  else
    HAVE_LIB[]NAME=no
    dnl If $LIB[]NAME didn't lead to a usable library, we don't need
    dnl $INC[]NAME either.
    CPPFLAGS="$ac_save_CPPFLAGS"
    LIB[]NAME=
    LTLIB[]NAME=
  fi
  AC_SUBST([HAVE_LIB]NAME)
  AC_SUBST([LIB]NAME)
  AC_SUBST([LTLIB]NAME)
  undefine([Name])
  undefine([NAME])
])

dnl Determine the platform dependent parameters needed to use rpath:
dnl libext, shlibext, hardcode_libdir_flag_spec, hardcode_libdir_separator,
dnl hardcode_direct, hardcode_minus_L,
dnl sys_lib_search_path_spec, sys_lib_dlsearch_path_spec.
AC_DEFUN([AC_LIB_RPATH],
[
  AC_REQUIRE([AC_PROG_CC])                dnl we use $CC, $GCC, $LDFLAGS
  AC_REQUIRE([AC_LIB_PROG_LD])            dnl we use $LD, $with_gnu_ld
  AC_REQUIRE([AC_CANONICAL_HOST])         dnl we use $host
  AC_REQUIRE([AC_CONFIG_AUX_DIR_DEFAULT]) dnl we use $ac_aux_dir
  AC_CACHE_CHECK([for shared library run path origin], acl_cv_rpath, [
    CC="$CC" GCC="$GCC" LDFLAGS="$LDFLAGS" LD="$LD" with_gnu_ld="$with_gnu_ld" \
    ${CONFIG_SHELL-/bin/sh} "$ac_aux_dir/config.rpath" "$host" > conftest.sh
    . ./conftest.sh
    rm -f ./conftest.sh
    acl_cv_rpath=done
  ])
  wl="$acl_cv_wl"
  libext="$acl_cv_libext"
  shlibext="$acl_cv_shlibext"
  hardcode_libdir_flag_spec="$acl_cv_hardcode_libdir_flag_spec"
  hardcode_libdir_separator="$acl_cv_hardcode_libdir_separator"
  hardcode_direct="$acl_cv_hardcode_direct"
  hardcode_minus_L="$acl_cv_hardcode_minus_L"
  sys_lib_search_path_spec="$acl_cv_sys_lib_search_path_spec"
  sys_lib_dlsearch_path_spec="$acl_cv_sys_lib_dlsearch_path_spec"
  dnl Determine whether the user wants rpath handling at all.
  AC_ARG_ENABLE(rpath,
    [  --disable-rpath         do not hardcode runtime library paths],
    :, enable_rpath=yes)
])

dnl AC_LIB_LINKFLAGS_BODY(name [, dependencies]) searches for libname and
dnl the libraries corresponding to explicit and implicit dependencies.
dnl Sets the LIB${NAME}, LTLIB${NAME} and INC${NAME} variables.
AC_DEFUN([AC_LIB_LINKFLAGS_BODY],
[
  define([NAME],[translit([$1],[abcdefghijklmnopqrstuvwxyz./-],
                               [ABCDEFGHIJKLMNOPQRSTUVWXYZ___])])
  dnl By default, look in $includedir and $libdir.
  use_additional=yes
  AC_LIB_WITH_FINAL_PREFIX([
    eval additional_includedir=\"$includedir\"
    eval additional_libdir=\"$libdir\"
  ])
  AC_ARG_WITH([lib$1-prefix],
[  --with-lib$1-prefix[=DIR]  search for lib$1 in DIR/include and DIR/lib
  --without-lib$1-prefix     don't search for lib$1 in includedir and libdir],
[
    if test "X$withval" = "Xno"; then
      use_additional=no
    else
      if test "X$withval" = "X"; then
        AC_LIB_WITH_FINAL_PREFIX([
          eval additional_includedir=\"$includedir\"
          eval additional_libdir=\"$libdir\"
        ])
      else
        additional_includedir="$withval/include"
        additional_libdir="$withval/lib"
      fi
    fi
])
  dnl Search the library and its dependencies in $additional_libdir and
  dnl $LDFLAGS. Using breadth-first-seach.
  LIB[]NAME=
  LTLIB[]NAME=
  INC[]NAME=
  rpathdirs=
  ltrpathdirs=
  names_already_handled=
  names_next_round='$1 $2'
  while test -n "$names_next_round"; do
    names_this_round="$names_next_round"
    names_next_round=
    for name in $names_this_round; do
      already_handled=
      for n in $names_already_handled; do
        if test "$n" = "$name"; then
          already_handled=yes
          break
        fi
      done
      if test -z "$already_handled"; then
        names_already_handled="$names_already_handled $name"
        dnl See if it was already located by an earlier AC_LIB_LINKFLAGS
        dnl or AC_LIB_HAVE_LINKFLAGS call.
        uppername=`echo "$name" | sed -e 'y|abcdefghijklmnopqrstuvwxyz./-|ABCDEFGHIJKLMNOPQRSTUVWXYZ___|'`
        eval value=\"\$HAVE_LIB$uppername\"
        if test -n "$value"; then
          if test "$value" = yes; then
            eval value=\"\$LIB$uppername\"
            test -z "$value" || LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }$value"
            eval value=\"\$LTLIB$uppername\"
            test -z "$value" || LTLIB[]NAME="${LTLIB[]NAME}${LTLIB[]NAME:+ }$value"
          else
            dnl An earlier call to AC_LIB_HAVE_LINKFLAGS has determined
            dnl that this library doesn't exist. So just drop it.
            :
          fi
        else
          dnl Search the library lib$name in $additional_libdir and $LDFLAGS
          dnl and the already constructed $LIBNAME/$LTLIBNAME.
          found_dir=
          found_la=
          found_so=
          found_a=
          if test $use_additional = yes; then
            if test -n "$shlibext" && test -f "$additional_libdir/lib$name.$shlibext"; then
              found_dir="$additional_libdir"
              found_so="$additional_libdir/lib$name.$shlibext"
              if test -f "$additional_libdir/lib$name.la"; then
                found_la="$additional_libdir/lib$name.la"
              fi
            else
              if test -f "$additional_libdir/lib$name.$libext"; then
                found_dir="$additional_libdir"
                found_a="$additional_libdir/lib$name.$libext"
                if test -f "$additional_libdir/lib$name.la"; then
                  found_la="$additional_libdir/lib$name.la"
                fi
              fi
            fi
          fi
          if test "X$found_dir" = "X"; then
            for x in $LDFLAGS $LTLIB[]NAME; do
              AC_LIB_WITH_FINAL_PREFIX([eval x=\"$x\"])
              case "$x" in
                -L*)
                  dir=`echo "X$x" | sed -e 's/^X-L//'`
                  if test -n "$shlibext" && test -f "$dir/lib$name.$shlibext"; then
                    found_dir="$dir"
                    found_so="$dir/lib$name.$shlibext"
                    if test -f "$dir/lib$name.la"; then
                      found_la="$dir/lib$name.la"
                    fi
                  else
                    if test -f "$dir/lib$name.$libext"; then
                      found_dir="$dir"
                      found_a="$dir/lib$name.$libext"
                      if test -f "$dir/lib$name.la"; then
                        found_la="$dir/lib$name.la"
                      fi
                    fi
                  fi
                  ;;
              esac
              if test "X$found_dir" != "X"; then
                break
              fi
            done
          fi
          if test "X$found_dir" != "X"; then
            dnl Found the library.
            LTLIB[]NAME="${LTLIB[]NAME}${LTLIB[]NAME:+ }-L$found_dir -l$name"
            if test "X$found_so" != "X"; then
              dnl Linking with a shared library. We attempt to hardcode its
              dnl directory into the executable's runpath, unless it's the
              dnl standard /usr/lib.
              if test "$enable_rpath" = no || test "X$found_dir" = "X/usr/lib"; then
                dnl No hardcoding is needed.
                LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }$found_so"
              else
                dnl Use an explicit option to hardcode DIR into the resulting
                dnl binary.
                dnl Potentially add DIR to ltrpathdirs.
                dnl The ltrpathdirs will be appended to $LTLIBNAME at the end.
                haveit=
                for x in $ltrpathdirs; do
                  if test "X$x" = "X$found_dir"; then
                    haveit=yes
                    break
                  fi
                done
                if test -z "$haveit"; then
                  ltrpathdirs="$ltrpathdirs $found_dir"
                fi
                dnl The hardcoding into $LIBNAME is system dependent.
                if test "$hardcode_direct" = yes; then
                  dnl Using DIR/libNAME.so during linking hardcodes DIR into the
                  dnl resulting binary.
                  LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }$found_so"
                else
                  if test -n "$hardcode_libdir_flag_spec" && test "$hardcode_minus_L" = no; then
                    dnl Use an explicit option to hardcode DIR into the resulting
                    dnl binary.
                    LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }$found_so"
                    dnl Potentially add DIR to rpathdirs.
                    dnl The rpathdirs will be appended to $LIBNAME at the end.
                    haveit=
                    for x in $rpathdirs; do
                      if test "X$x" = "X$found_dir"; then
                        haveit=yes
                        break
                      fi
                    done
                    if test -z "$haveit"; then
                      rpathdirs="$rpathdirs $found_dir"
                    fi
                  else
                    dnl Rely on "-L$found_dir".
                    dnl But don't add it if it's already contained in the LDFLAGS
                    dnl or the already constructed $LIBNAME
                    haveit=
                    for x in $LDFLAGS $LIB[]NAME; do
                      AC_LIB_WITH_FINAL_PREFIX([eval x=\"$x\"])
                      if test "X$x" = "X-L$found_dir"; then
                        haveit=yes
                        break
                      fi
                    done
                    if test -z "$haveit"; then
                      LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }-L$found_dir"
                    fi
                    if test "$hardcode_minus_L" != no; then
                      dnl FIXME: Not sure whether we should use
                      dnl "-L$found_dir -l$name" or "-L$found_dir $found_so"
                      dnl here.
                      LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }$found_so"
                    else
                      dnl We cannot use $hardcode_runpath_var and LD_RUN_PATH
                      dnl here, because this doesn't fit in flags passed to the
                      dnl compiler. So give up. No hardcoding. This affects only
                      dnl very old systems.
                      dnl FIXME: Not sure whether we should use
                      dnl "-L$found_dir -l$name" or "-L$found_dir $found_so"
                      dnl here.
                      LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }-l$name"
                    fi
                  fi
                fi
              fi
            else
              if test "X$found_a" != "X"; then
                dnl Linking with a static library.
                LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }$found_a"
              else
                dnl We shouldn't come here, but anyway it's good to have a
                dnl fallback.
                LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }-L$found_dir -l$name"
              fi
            fi
            dnl Assume the include files are nearby.
            additional_includedir=
            case "$found_dir" in
              */lib | */lib/)
                basedir=`echo "X$found_dir" | sed -e 's,^X,,' -e 's,/lib/*$,,'`
                additional_includedir="$basedir/include"
                ;;
            esac
            if test "X$additional_includedir" != "X"; then
              dnl Potentially add $additional_includedir to $INCNAME.
              dnl But don't add it
              dnl   1. if it's the standard /usr/include,
              dnl   2. if it's /usr/local/include and we are using GCC on Linux,
              dnl   3. if it's already present in $CPPFLAGS or the already
              dnl      constructed $INCNAME,
              dnl   4. if it doesn't exist as a directory.
              if test "X$additional_includedir" != "X/usr/include"; then
                haveit=
                if test "X$additional_includedir" = "X/usr/local/include"; then
                  if test -n "$GCC"; then
                    case $host_os in
                      linux*) haveit=yes;;
                    esac
                  fi
                fi
                if test -z "$haveit"; then
                  for x in $CPPFLAGS $INC[]NAME; do
                    AC_LIB_WITH_FINAL_PREFIX([eval x=\"$x\"])
                    if test "X$x" = "X-I$additional_includedir"; then
                      haveit=yes
                      break
                    fi
                  done
                  if test -z "$haveit"; then
                    if test -d "$additional_includedir"; then
                      dnl Really add $additional_includedir to $INCNAME.
                      INC[]NAME="${INC[]NAME}${INC[]NAME:+ }-I$additional_includedir"
                    fi
                  fi
                fi
              fi
            fi
            dnl Look for dependencies.
            if test -n "$found_la"; then
              dnl Read the .la file. It defines the variables
              dnl dlname, library_names, old_library, dependency_libs, current,
              dnl age, revision, installed, dlopen, dlpreopen, libdir.
              save_libdir="$libdir"
              case "$found_la" in
                */* | *\\*) . "$found_la" ;;
                *) . "./$found_la" ;;
              esac
              libdir="$save_libdir"
              dnl We use only dependency_libs.
              for dep in $dependency_libs; do
                case "$dep" in
                  -L*)
                    additional_libdir=`echo "X$dep" | sed -e 's/^X-L//'`
                    dnl Potentially add $additional_libdir to $LIBNAME and $LTLIBNAME.
                    dnl But don't add it
                    dnl   1. if it's the standard /usr/lib,
                    dnl   2. if it's /usr/local/lib and we are using GCC on Linux,
                    dnl   3. if it's already present in $LDFLAGS or the already
                    dnl      constructed $LIBNAME,
                    dnl   4. if it doesn't exist as a directory.
                    if test "X$additional_libdir" != "X/usr/lib"; then
                      haveit=
                      if test "X$additional_libdir" = "X/usr/local/lib"; then
                        if test -n "$GCC"; then
                          case $host_os in
                            linux*) haveit=yes;;
                          esac
                        fi
                      fi
                      if test -z "$haveit"; then
                        haveit=
                        for x in $LDFLAGS $LIB[]NAME; do
                          AC_LIB_WITH_FINAL_PREFIX([eval x=\"$x\"])
                          if test "X$x" = "X-L$additional_libdir"; then
                            haveit=yes
                            break
                          fi
                        done
                        if test -z "$haveit"; then
                          if test -d "$additional_libdir"; then
                            dnl Really add $additional_libdir to $LIBNAME.
                            LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }-L$additional_libdir"
                          fi
                        fi
                        haveit=
                        for x in $LDFLAGS $LTLIB[]NAME; do
                          AC_LIB_WITH_FINAL_PREFIX([eval x=\"$x\"])
                          if test "X$x" = "X-L$additional_libdir"; then
                            haveit=yes
                            break
                          fi
                        done
                        if test -z "$haveit"; then
                          if test -d "$additional_libdir"; then
                            dnl Really add $additional_libdir to $LTLIBNAME.
                            LTLIB[]NAME="${LTLIB[]NAME}${LTLIB[]NAME:+ }-L$additional_libdir"
                          fi
                        fi
                      fi
                    fi
                    ;;
                  -R*)
                    dir=`echo "X$dep" | sed -e 's/^X-R//'`
                    if test "$enable_rpath" != no; then
                      dnl Potentially add DIR to rpathdirs.
                      dnl The rpathdirs will be appended to $LIBNAME at the end.
                      haveit=
                      for x in $rpathdirs; do
                        if test "X$x" = "X$dir"; then
                          haveit=yes
                          break
                        fi
                      done
                      if test -z "$haveit"; then
                        rpathdirs="$rpathdirs $dir"
                      fi
                      dnl Potentially add DIR to ltrpathdirs.
                      dnl The ltrpathdirs will be appended to $LTLIBNAME at the end.
                      haveit=
                      for x in $ltrpathdirs; do
                        if test "X$x" = "X$dir"; then
                          haveit=yes
                          break
                        fi
                      done
                      if test -z "$haveit"; then
                        ltrpathdirs="$ltrpathdirs $dir"
                      fi
                    fi
                    ;;
                  -l*)
                    dnl Handle this in the next round.
                    names_next_round="$names_next_round "`echo "X$dep" | sed -e 's/^X-l//'`
                    ;;
                  *.la)
                    dnl Handle this in the next round. Throw away the .la's
                    dnl directory; it is already contained in a preceding -L
                    dnl option.
                    names_next_round="$names_next_round "`echo "X$dep" | sed -e 's,^X.*/,,' -e 's,^lib,,' -e 's,\.la$,,'`
                    ;;
                  *)
                    dnl Most likely an immediate library name.
                    LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }$dep"
                    LTLIB[]NAME="${LTLIB[]NAME}${LTLIB[]NAME:+ }$dep"
                    ;;
                esac
              done
            fi
          else
            dnl Didn't find the library; assume it is in the system directories
            dnl known to the linker and runtime loader. (All the system
            dnl directories known to the linker should also be known to the
            dnl runtime loader, otherwise the system is severely misconfigured.)
            LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }-l$name"
            LTLIB[]NAME="${LTLIB[]NAME}${LTLIB[]NAME:+ }-l$name"
          fi
        fi
      fi
    done
  done
  if test "X$rpathdirs" != "X"; then
    if test -n "$hardcode_libdir_separator"; then
      dnl Weird platform: only the last -rpath option counts, the user must
      dnl pass all path elements in one option. We can arrange that for a
      dnl single library, but not when more than one $LIBNAMEs are used.
      alldirs=
      for found_dir in $rpathdirs; do
        alldirs="${alldirs}${alldirs:+$hardcode_libdir_separator}$found_dir"
      done
      dnl Note: hardcode_libdir_flag_spec uses $libdir and $wl.
      acl_save_libdir="$libdir"
      libdir="$alldirs"
      eval flag=\"$hardcode_libdir_flag_spec\"
      libdir="$acl_save_libdir"
      LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }$flag"
    else
      dnl The -rpath options are cumulative.
      for found_dir in $rpathdirs; do
        acl_save_libdir="$libdir"
        libdir="$found_dir"
        eval flag=\"$hardcode_libdir_flag_spec\"
        libdir="$acl_save_libdir"
        LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }$flag"
      done
    fi
  fi
  if test "X$ltrpathdirs" != "X"; then
    dnl When using libtool, the option that works for both libraries and
    dnl executables is -R. The -R options are cumulative.
    for found_dir in $ltrpathdirs; do
      LTLIB[]NAME="${LTLIB[]NAME}${LTLIB[]NAME:+ }-R$found_dir"
    done
  fi
])

dnl AC_LIB_APPENDTOVAR(VAR, CONTENTS) appends the elements of CONTENTS to VAR,
dnl unless already present in VAR.
dnl Works only for CPPFLAGS, not for LIB* variables because that sometimes
dnl contains two or three consecutive elements that belong together.
AC_DEFUN([AC_LIB_APPENDTOVAR],
[
  for element in [$2]; do
    haveit=
    for x in $[$1]; do
      AC_LIB_WITH_FINAL_PREFIX([eval x=\"$x\"])
      if test "X$x" = "X$element"; then
        haveit=yes
        break
      fi
    done
    if test -z "$haveit"; then
      [$1]="${[$1]}${[$1]:+ }$element"
    fi
  done
])


# progtest.m4 serial 2 (gettext-0.10.40)
dnl Copyright (C) 1996-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.
dnl
dnl This file can can be used in projects which are not available under
dnl the GNU General Public License or the GNU Library General Public
dnl License but which still want to provide support for the GNU gettext
dnl functionality.
dnl Please note that the actual code of the GNU gettext library is covered
dnl by the GNU Library General Public License, and the rest of the GNU
dnl gettext package package is covered by the GNU General Public License.
dnl They are *not* in the public domain.

dnl Authors:
dnl   Ulrich Drepper <drepper@cygnus.com>, 1996.

# Search path for a program which passes the given test.

dnl AM_PATH_PROG_WITH_TEST(VARIABLE, PROG-TO-CHECK-FOR,
dnl   TEST-PERFORMED-ON-FOUND_PROGRAM [, VALUE-IF-NOT-FOUND [, PATH]])
AC_DEFUN([AM_PATH_PROG_WITH_TEST],
[# Extract the first word of "$2", so it can be a program name with args.
set dummy $2; ac_word=[$]2
AC_MSG_CHECKING([for $ac_word])
AC_CACHE_VAL(ac_cv_path_$1,
[case "[$]$1" in
  /*)
  ac_cv_path_$1="[$]$1" # Let the user override the test with a path.
  ;;
  *)
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:"
  for ac_dir in ifelse([$5], , $PATH, [$5]); do
    test -z "$ac_dir" && ac_dir=.
    if test -f $ac_dir/$ac_word; then
      if [$3]; then
	ac_cv_path_$1="$ac_dir/$ac_word"
	break
      fi
    fi
  done
  IFS="$ac_save_ifs"
dnl If no 4th arg is given, leave the cache variable unset,
dnl so AC_PATH_PROGS will keep looking.
ifelse([$4], , , [  test -z "[$]ac_cv_path_$1" && ac_cv_path_$1="$4"
])dnl
  ;;
esac])dnl
$1="$ac_cv_path_$1"
if test ifelse([$4], , [-n "[$]$1"], ["[$]$1" != "$4"]); then
  AC_MSG_RESULT([$]$1)
else
  AC_MSG_RESULT(no)
fi
AC_SUBST($1)dnl
])


# stdint_h.m4 serial 2 (gettext-0.11.4)
dnl Copyright (C) 1997-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Paul Eggert.

# Define HAVE_STDINT_H_WITH_UINTMAX if <stdint.h> exists,
# doesn't clash with <sys/types.h>, and declares uintmax_t.

AC_DEFUN([jm_AC_HEADER_STDINT_H],
[
  AC_CACHE_CHECK([for stdint.h], jm_ac_cv_header_stdint_h,
  [AC_TRY_COMPILE(
    [#include <sys/types.h>
#include <stdint.h>],
    [uintmax_t i = (uintmax_t) -1;],
    jm_ac_cv_header_stdint_h=yes,
    jm_ac_cv_header_stdint_h=no)])
  if test $jm_ac_cv_header_stdint_h = yes; then
    AC_DEFINE_UNQUOTED(HAVE_STDINT_H_WITH_UINTMAX, 1,
[Define if <stdint.h> exists, doesn't clash with <sys/types.h>,
   and declares uintmax_t. ])
  fi
])


# uintmax_t.m4 serial 6 (gettext-0.11)
dnl Copyright (C) 1997-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Paul Eggert.

AC_PREREQ(2.13)

# Define uintmax_t to `unsigned long' or `unsigned long long'
# if <inttypes.h> does not exist.

AC_DEFUN([jm_AC_TYPE_UINTMAX_T],
[
  AC_REQUIRE([jm_AC_HEADER_INTTYPES_H])
  AC_REQUIRE([jm_AC_HEADER_STDINT_H])
  if test $jm_ac_cv_header_inttypes_h = no && test $jm_ac_cv_header_stdint_h = no; then
    AC_REQUIRE([jm_AC_TYPE_UNSIGNED_LONG_LONG])
    test $ac_cv_type_unsigned_long_long = yes \
      && ac_type='unsigned long long' \
      || ac_type='unsigned long'
    AC_DEFINE_UNQUOTED(uintmax_t, $ac_type,
  [Define to unsigned long or unsigned long long
   if <inttypes.h> and <stdint.h> don't define.])
  fi
])


# ulonglong.m4 serial 2 (fileutils-4.0.32, gettext-0.10.40)
dnl Copyright (C) 1999-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Paul Eggert.

AC_DEFUN([jm_AC_TYPE_UNSIGNED_LONG_LONG],
[
  AC_CACHE_CHECK([for unsigned long long], ac_cv_type_unsigned_long_long,
  [AC_TRY_LINK([unsigned long long ull = 1; int i = 63;],
    [unsigned long long ullmax = (unsigned long long) -1;
     return ull << i | ull >> i | ullmax / ull | ullmax % ull;],
    ac_cv_type_unsigned_long_long=yes,
    ac_cv_type_unsigned_long_long=no)])
  if test $ac_cv_type_unsigned_long_long = yes; then
    AC_DEFINE(HAVE_UNSIGNED_LONG_LONG, 1,
      [Define if you have the unsigned long long type.])
  fi
])

