#!/bin/bash
#
# evmsd script:
#       Description: this script can start/stop/monitor the evmsd resource
#       
#  	Original Author: Guochun Shi (gshi@ncsa.uiuc.edu)
#                                                            
#       Support: evms-devel@lists.sourceforge.net
#                
# usage: evmsd  {start|stop|status}

ONLINE=1
OFFLINE=2


log() {

#   echo $1 >>/var/log/rsct_failover.log 
    echo $1 >/dev/null
}



usage() {
cat <<-EOT;
	usage: $0  {start|stop|status}
EOT
}

evms_start(){
    log "running evmsd here now !!!"
    /sbin/evmsd&>/dev/null &
    return $?
}

#stop evmsd
evms_stop(){
    killall -9 evmsd &>/dev/null &
    return $?
}


evms_report_status(){


    pss=`ps -aef |grep evmsd |wc -l`
    if [ $pss -gt "4" ]; then 
	return $ONLINE
    else
	return $OFFLINE	
    fi	
}




# Look for the 'start', 'stop' or 'status' argument
case "$1" in
start)
    evms_report_status
    if [ $? -eq $OFFLINE ];  then
	log "$0 start "
	evms_start
	if [ $? -ne "0" ]; then
	    echo "start evms daemon failed"
	fi
	ret=$?
    else
	log "$0 is already online."
	ret=0
    fi
    ;;

stop)
    evms_report_status
    if [ $? -eq $ONLINE ]; then
	log "$0 stop"
	evms_stop
	ret=$?
    else
	log "$0 is aready offline."
	ret=0;
    fi
    ;;
status)
	#  is the container owned by us?
	evms_report_status 
	if [ $? -eq $ONLINE ] ; then
		log  "$0 in `hostname` is online "
		ret=$ONLINE
	else
		log  "$0 in `hostname` is offline."
		ret=$OFFLINE
	fi
	;;


*)
   	usage
	exit 1 
esac

exit $ret
