/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libdrivelink.so
 *
 *   File: dl_options.h
 */

#ifndef   _DL_OPTIONS_HEADER_
#define   _DL_OPTIONS_HEADER_ 1


//
// Create Option Info
//
#define DL_CREATE_OPTION_COUNT           1

#define DL_CREATE_LINKNAME_INDEX         0
#define DL_CREATE_LINKNAME_NAME          "Name"


//
//  Expand Option Info
//
#define DL_EXPAND_OPTION_COUNT           0



//
//  Shrink Option Info
//
#define DL_SHRINK_OPTION_COUNT           0


//
//  Private Plugin Function
//
#define DL_REPLACE_MISSING_CHILD_OPTION_COUNT   0

#define EVMS_Replace_Missing_DL_Child  (EVMS_Task_Plugin_Function+1)

#define DL_REPLACE_MISSING_CHILD_OPTION_INDEX   0
#define DL_REPLACE_MISSING_CHILD_OPTION_NAME    "Replace Missing Child"


    
//
//  DL Info
//
#define DL_INFO_COUNT                    4

#define DL_INFO_NAME_INDEX               0
#define DL_INFO_SIZE_INDEX               1
#define DL_INFO_LINKS_INDEX              2
#define DL_INFO_PSN_INDEX                3


//
//  Plugin Info
//
#define DL_PLUGIN_INFO_COUNT                    6

#define DL_PLUGIN_INFO_SNAME_INDEX              0
#define DL_PLUGIN_INFO_LNAME_INDEX              1
#define DL_PLUGIN_INFO_TYPE_INDEX               2
#define DL_PLUGIN_INFO_VERSION_INDEX            3
#define DL_PLUGIN_INFO_REQENGSVCVERSION_INDEX   4
#define DL_PLUGIN_INFO_REQPLUGAPIVERSION_INDEX  5



int	dl_get_option_count(task_context_t * task);

int     dl_init_task(task_context_t * context);

int     dl_set_option( task_context_t * context, u_int32_t index, value_t * value, u_int32_t * info );

int     dl_get_info( storage_object_t  * object, char *name,  extended_info_array_t * * info);

int     dl_get_plugin_info( char * descriptor_name, extended_info_array_t * * info );

int     dl_set_objects( task_context_t * context, list_anchor_t declined_objects, task_effect_t  * effect );

#endif

