/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: object.h
 *
 */

/*
 * Global functions exported by object.c
 */

/* External APIs provided by object.c */

extern int evms_create(plugin_handle_t    plugin,
                       handle_array_t   * objects,
                       option_array_t   * options,
                       handle_array_t * * output_objects);

extern int evms_transfer(object_handle_t  object,
                         plugin_handle_t  plugin,
                         object_handle_t  container,
                         option_array_t * options);

extern int evms_get_object_list(object_type_t         object_type,
                                data_type_t           data_type,
                                plugin_handle_t       plugin_handle,
				object_handle_t       disk_group,
                                object_search_flags_t flags,
                                handle_array_t    * * object_handle_list);

extern int evms_assign(object_handle_t  object,
                       plugin_handle_t  plugin,
                       option_array_t * options);

extern int evms_can_unassign(object_handle_t object);

extern int evms_unassign(object_handle_t object);

extern int evms_get_plugin_functions(engine_handle_t           thing,
                                     function_info_array_t * * actions);

extern int evms_do_plugin_function(engine_handle_t  thing,
                                   task_action_t    action,
                                   handle_array_t * objects,
                                   option_array_t * options);

/* Internal functions to share with other Engine source modules */

extern int isa_valid_input_object(storage_object_t    * obj,
				  storage_container_t * disk_group);

extern void free_function_info_array_contents(void * object);
