/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libs390.so
 *
 *   File: 390segmgr.h
 */
#ifndef S390SEGMGR_HEADER
#define S390SEGMGR_HEADER

extern plugin_record_t *s390_plugin_rec;
extern struct engine_functions_s *EngFncs;

#define my_plugin_record s390_plugin_rec

typedef enum {
    ibm_ldl = 0,          // LNX1 - Linux Disk Layout
    ibm_cdl = 1,          // VOL1 - Compatibility Disk Layout
    ibm_cms = 2,          // CMS1 - Minidisk
    ibm_unformatted = 3,  // xxxx - Unformatted Disk
    ibm_none = 4          // xxxx - No disk label
} ibm_label_type_t;


#define IPL1_RECORD_BLOCK_NUMBER  0
#define IPL2_RECORD_BLOCK_NUMBER  1
#define VOLUME_LABEL_BLOCK_NUMBER 2
#define VTOC_RECORDS_BLOCK_NUMBER 3

// system code value for our format 1 DSCBs ... IBM LINUX ... padded out with blanks ... in ebcdic
//#define S390_SYSTEM_CODE (&(char []) {0xC9, 0xC2, 0xD4, 0x40, 0xE2, 0xE5, 0xE2, 0xF2, 0x40, 0x40, 0x40, 0x40, 0x40})
#define S390_SYSTEM_CODE "IBM LINUX    "
#define S390_SYSTEM_CODE_LENGTH 13   // number of characters in the dscb system code field

// max size of dataset name
#define MAX_DSNAME_LENGTH 43

// max size of dataset serial number field
#define S390_DATA_SET_SN_LENGTH  6



#define  MAX_S390_PARTITIONS               24           /* arbitrary number of partitions we can create on a disk */

#define  S390_SEG_MGR_PDATA_SIGNATURE      0x73333930   /* s390 */

#define  SEG_CFLAG_TOP_SEGMENT             0x00000001
#define  SEG_NEEDS_DM_RENAME               0x00000010

#define  DISK_HAS_FORMAT_PENDING           0x00000001
#define  DISK_HAS_MOVE_PENDING             0x00000002
#define  DISK_HAS_CHANGES_PENDING          0x00000004

#include "vtoc.h"

typedef struct disk_private_data_s {

    u_int32_t                   signature;                /* used to validate disk private data area      */

    void                       *key;                      /* search key, address of the LOGICALDISK       */

    u_int32_t                   flags;                    /* see DISK_HAS_xxxx flags above                */

    ibm_label_type_t            disk_layout;              /* disk layout:  ldl, cdl, etc                  */

    u_int32_t                   partition_count;          /* current count of data partitions on the disk */

    u_int32_t                   max_partitions_allowed;   /* maximum number of data partitions allowed on */
                                                          /* this disk ... determined by format type      */

    DISKSEG                    *md;                       /* metadata segment - quick searching           */

    struct hd_geometry          geometry;                 /* 390 drive geometry                           */

//    geometry_t                  geometry;                 /* 390 drive geometry                           */

    u_int32_t                   vsectors_per_block;       /* dasd blocksize established by format cmd     */

    volume_label_t              vlabel;                   /* volume label from this disk                  */

    format4_label_t             f4;                       /* format 4 DSCB - VTOC descriptor              */

    format5_label_t             f5;                       /* format 5 DSCB - FREESPACE descriptor         */

    lba_t                       vtoc_lba;                 /* address of vtoc ... evms vsector lba         */

    u_int32_t                   vtoc_record_count;        /* vtoc size ... number of dscbs it can hold    */

    sector_count_t              vtoc_sector_count;        /* vtoc size ... number of evms vsectors        */

    copy_job_t                 *copy_job;                 /* ptr to valid copy job if a segment move is in */
                                                          /* progress ... DISK_HAS_MOVE_PENDING should be */
                                                          /* set if this is the case.                     */


 } DISK_PRIVATE_DATA;


typedef struct seg_private_data_s {

    u_int32_t                   signature;                /* used to validate our private data area       */

    u_int32_t                   cflags;                   /* see SEG_CFLAG_xxxx flags above               */

    //----------------- end of segment manager common area  -----------------------

    LOGICALDISK                *logical_disk;             /* disk object - quick searching                */

    DISKSEG                    *move_target;              /* used when moving segments on the disk                       */
        
    format1_label_t             f1;                       /* format 1 DSCB                                */

    char                       *dm_name;                  /* used to rename dm objects, this is the old   */
                                                          /* object name                                  */
    
    u_int32_t                   minor;                    /* minor number of this partition               */

} SEG_PRIVATE_DATA;


// macro to pull the child object ptr from our private data area
#define GET_S390_CHILD( object ) ((S390_SEG_PRIVATE_DATA *)object->private_data)->child



#endif
