/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: reiserfsim.h
 *
 */

                   
/********************
 ********************
 **                **
 **  EVMS defines  **
 **                **
 ********************
 ********************/
 
extern plugin_record_t reiser_plugin_record;
extern plugin_record_t *my_plugin_record;
extern engine_functions_t *EngFncs;
                 
#define FS_TYPE_REISERFS 9
/**********************************
 **********************************
 **                              **
 **  fsck.reiserfs, mkfs.reiserfs defines  **
 **                              **
 **********************************
 **********************************/

/* fsck.reiserfs, mkfs.reiserfs option counts */
#define FSCK_OPTIONS_COUNT   1
#define MKFS_OPTIONS_COUNT   3  

/* fsck.reiserfs option array indices */
#define FSCK_MODE_INDEX    0
// MODE DEFINES
#define FSCK_READONLY "Check Read-Only"
#define FSCK_FIX "Fix"           
#define FSCK_REBUILD_TREE "Rebuild Tree"

/* mkfs.reiserfs option array indices */
#define MKFS_VERSION_INDEX      0
#define MKFS_SETVOL_INDEX       1
#define MKFS_SETLOGSIZE_INDEX   2

/* fsck exit codes */
#define FSCK_OK                    0
#define FSCK_CORRECTED             1
#define FSCK_REBOOT                2
#define FSCK_ERRORS_UNCORRECTED    4
#define FSCK_OP_ERROR              8
#define FSCK_USAGE_ERROR          16


/*******************************
 *******************************
 **                           **
 **      defines and structs  **
 **                           **
 *******************************
 *******************************/


/* generic defines */
#define GET                     0
#define PUT                     1


#define REISERFS_SUPER_MAGIC_STRING "ReIsErFs"
#define REISER2FS_SUPER_MAGIC_STRING "ReIsEr2Fs"
/* ReiserFS leaves the first 64k unused, so that partition labels have
   enough space.  If someone wants to write a fancy bootloader that
   needs more than 64k, let us know, and this will be increased in size.
   This number must be larger than than the largest block size on any
   platform, or code will break.  -Hans */
#define REISERFS_DISK_OFFSET_IN_BYTES (64 * 1024)
#define REISERFS_FIRST_BLOCK unused_define

/* the spot for the super in versions 3.5 - 3.5.10 (inclusive) */
#define REISERFS_OLD_DISK_OFFSET_IN_BYTES (8 * 1024)

#define MINREISERFS (1024*33*2) //33MB in sectors - not sure of real limit, but until
				// variable log size this is close enough.
#define MEGABYTE 1024
#define MAX_LOG_PERCENTAGE .4


/*
 * values for s_state field
 */
#define REISERFS_VALID_FS    1
#define REISERFS_ERROR_FS    2

/* struct reiserfs_super_block accessors/mutators
 * since this is a disk structure, it will always be in 
 * little endian format. */


//#define get_leXX(xx,p,field)	(le##xx##_to_cpu ((p)->field))
//#define set_leXX(xx,p,field,val) do { (p)->field = cpu_to_le##xx(val); } while (0)

//#define get_le16(p,field)	get_leXX (16, p, field)
#define get_le16(p,field)	DISK_TO_CPU16((p)->field)
#define set_le16(p,field,val)   do { (p)->field = DISK_TO_CPU16(val); } while (0)

#define get_le32(p,field)	DISK_TO_CPU32((p)->field)
#define set_le32(p,field,val)   do { (p)->field = DISK_TO_CPU32(val); } while (0)

#define get_le64(p,field)	DISK_TO_CPU64((p)->field)
#define set_le64(p,field,val)   do { (p)->field = DISK_TO_CPU64(val); } while (0)


#define get_jp_journal_size(sb)		get_le32 (sb, s_v1.sb_journal.jp_journal_size)
#define set_jp_journal_size(sb,val)	set_le32 (sb, s_v1.sb_journal.jp_journal_size, val)

/* set/get fields of super block with these defines */
#define get_sb_block_count(sb)		get_le32 (sb, s_v1.sb_block_count)
#define set_sb_block_count(sb,val)	set_le32 (sb, s_v1.sb_block_count, val)

#define get_sb_free_blocks(sb)		get_le32 (sb, s_v1.sb_free_blocks)
#define set_sb_free_blocks(sb,val)	set_le32 (sb, s_v1.sb_free_blocks, val)

#define get_sb_root_block(sb)		get_le32 (sb,s_v1.sb_root_block)
#define set_sb_root_block(sb,val)	set_le32 (sb, s_v1.sb_root_block, val)

#if 0
#define get_sb_mount_id(sb)		get_le32 (sb,s_v1.sb_mountid)
#define set_sb_mount_id(sb,val)		set_le32 (sb, s_v1.sb_mountid, val)

#define get_sb_journal_magic(sb)	get_le32 (sb, s_v1.sb_journal_magic)
#define set_sb_journal_magic(sb,val)	set_le32 (sb, s_v1.sb_journal_magic, val)
#endif

#define get_sb_block_size(sb)		get_le16 (sb, s_v1.sb_blocksize)
#define set_sb_block_size(sb,val)	set_le16 (sb, s_v1.sb_blocksize, val)

#define get_sb_oid_maxsize(sb)		get_le16 (sb, s_v1.sb_oid_maxsize)
#define set_sb_oid_maxsize(sb,val)	set_le16 (sb, s_v1.sb_oid_maxsize, val)

#define get_sb_oid_cursize(sb)		get_le16 (sb, s_v1.sb_oid_cursize)
#define set_sb_oid_cursize(sb,val)	set_le16 (sb, s_v1.sb_oid_cursize, val)

#define get_sb_umount_state(sb)		get_le16 (sb, s_v1.sb_umount_state)
#define set_sb_umount_state(sb,val)	set_le16 (sb, s_v1.sb_umount_state, val)

#define get_sb_fs_state(sb)		get_le16 (sb, s_v1.sb_fs_state)
#define set_sb_fs_state(sb,flag)	set_le16 (sb, s_v1.sb_fs_state, flag)

#define get_sb_hash_code(sb)		get_le32 (sb, s_v1.sb_hash_function_code)
#define set_sb_hash_code(sb,val)	set_le32 (sb, s_v1.sb_hash_function_code, val)

#define get_sb_tree_height(sb)		get_le16 (sb, s_v1.sb_tree_height)
#define set_sb_tree_height(sb,val)	set_le16 (sb, s_v1.sb_tree_height, val)

#define get_sb_bmap_nr(sb)		get_le16 (sb, s_v1.sb_bmap_nr)
#define set_sb_bmap_nr(sb,val)		set_le16 (sb, s_v1.sb_bmap_nr, val)

#define get_sb_version(sb)		get_le16 (sb, s_v1.sb_version)
#define set_sb_version(sb,val)		set_le16 (sb, s_v1.sb_version, val)

#define get_sb_reserved_for_journal(sb)		get_le16 (sb, s_v1.sb_reserved_for_journal)
#define set_sb_reserved_for_journal(sb,val)	set_le16 (sb, s_v1.sb_reserved_for_journal, val)

#define get_sb_v2_inode_generation(sb)		get_le32 (sb, sb_inode_generation)
#define set_sb_v2_inode_generation(sb,val)	set_le32 (sb, sb_inode_generation, val)

//#define get_sb_v2_flag(sb, flag)	test_bit ((flag), &((struct reiserfs_super_block *)sb)->s_flags)	
//#define set_sb_v2_flag(sb, flag)	set_bit  ((flag), &((struct reiserfs_super_block *)sb)->s_flags)
#define get_sb_v2_flag(sb, flag)	(get_le16 (sb, s_flags) && (0xffff && flag))
#define set_sb_v2_flag(sb, flag)	set_le16 (sb, s_flags, get_le16 (sb, s_flags) || (0xffff && flag))
#define clear_sb_v2_flag(sb, flag)	set_le16 (sb, s_flags, get_le16 (sb, s_flags) && ~(0xffff && flag))


struct journal_params {
    u_int32_t jp_journal_1st_block;	/* where does journal start from on its
					   device */
    u_int32_t jp_journal_dev;		/* journal device st_rdev */
    u_int32_t jp_journal_size;		/* size of the journal on FS creation. used to
					   make sure they don't overflow it */
    u_int32_t jp_journal_trans_max;	/* max number of blocks in a transaction.  */
    u_int32_t jp_journal_magic; 	/* random value made on fs creation (this was
					   sb_journal_block_count) */
    u_int32_t jp_journal_max_batch;	/* max number of blocks to batch into a trans */
    u_int32_t jp_journal_max_commit_age;/* in seconds, how old can an async commit be */
    u_int32_t jp_journal_max_trans_age;	/* in seconds, how old can a transaction be */
};


/* this is the super from 3.5.X, where X >= 10 */
/* this is the super from 3.5.X */
struct reiserfs_super_block_v1
{
    u_int32_t sb_block_count; 	/* 0 number of block on data device */
    u_int32_t sb_free_blocks; 	/* 4 free blocks count */
    u_int32_t sb_root_block;    /* 8 root of the tree */

    struct journal_params sb_journal; /* 12 */

    u_int16_t sb_blocksize;     /* 44 */
    u_int16_t sb_oid_maxsize;	/* 46 max size of object id array, see
				   get_objectid() commentary */
    u_int16_t sb_oid_cursize; 	/* 48 current size of object id array */
    u_int16_t sb_umount_state;	/* 50 this is set to 1 when filesystem was
				   umounted, to 2 - when not */
    
    int8_t s_magic[10]; 	/* 52 reiserfs magic string indicates that
				   file system is reiserfs: "ReIsErFs" or
				   "ReIsEr2Fs" or "ReIsEr3Fs" */
    u_int16_t sb_fs_state; 		/* 62 it is set to used by fsck to mark which phase of
				   rebuilding is done (used for fsck debugging) */
    u_int32_t sb_hash_function_code;/* 64 code of fuction which was/is/will be
				   used to sort names in a directory. See
				   codes in above */
    u_int16_t sb_tree_height;	/* 68 height of filesytem tree. Tree
				   consisting of only one root block has 2
				   here */
    u_int16_t sb_bmap_nr;     	/* 70 amount of bitmap blocks needed to
				   address each block of file system */
    u_int16_t sb_version; 	/* 72 this field is only reliable on
				   filesystem with non-standard journal */
    u_int16_t sb_reserved_for_journal;  /* 74 size in blocks of journal area on
				       main device, we need to keep after
				       non-standard journal relocation */
};

#define SB_SIZE_V1 (sizeof(struct reiserfs_super_block_v1))

/* this is the on disk super block */

struct reiserfs_super_block
{
/*  0 */    struct reiserfs_super_block_v1 s_v1;
/* 76 */    u_int32_t sb_inode_generation; 
/* 76 */    u_int32_t s_flags;             /* Right now used only by inode-attributes, if enabled */
/* 84 */    u_int8_t s_uuid[16];           /* filesystem unique identifier */
/*100 */    u_int8_t s_label[16];          /* filesystem volume label */
/*116 */    int8_t s_unused[88] ;          /* zero filled by mkreiserfs and reiserfs_convert_objectid_map_v1()
                                            * so any additions must be updated there as well. */ 
/*204*/
} __attribute__ ((__packed__));;

#define SB_SIZE (sizeof(struct reiserfs_super_block)) /* 204 bytes */


