/*
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: mdregmgr
 * File: md_create.h
 */

#ifndef _MD_CREATE_H_
#define _MD_CREATE_H_ 1

// Functions exported by md_create.c
int md_clone_superblock( md_volume_t *volume,int index);
int md_create_first_superblock( md_volume_t *volume,
				mdp_disk_t first_disk,
				u_int32_t level,
				u_int32_t chunk_size,  // in bytes
				u_int32_t size,
				u_int32_t nr_disks,
				u_int32_t spare_disks,
				u_int32_t state);
u_int32_t get_legacy_dev(md_volume_t * volume, char * name,u_int32_t *major_num, u_int32_t *minor_num);

#endif

