/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libdos.so
 *
 *   File: unixware.h
 */

#ifndef UNIXWARE_HEADER
#define UNIXWARE_HEADER 1

#define UNIXWARE_PART_TABLE_SECTOR_OFFSET 29


// partition fs types
#define UW_TAG_UNUSED       0x0000  // unused slice
#define UW_TAG_BOOT         0x0001  // boot fs
#define UW_TAG_ROOT         0x0002  // root fs
#define UW_TAG_SWAP         0x0003  // swap fs
#define UW_TAG_USER         0x0004  // user fs
#define UW_TAG_ENTIRE_DISK  0x0005  // whole disk
#define UW_TAG_ALT_S        0x0006  // alternate sector space
#define UW_TAG_OTHER        0x0007  // non unix
#define UW_TAG_ALT_T        0x0008  // alternate track space
#define UW_TAG_STAND        0x0009  // stand slice
#define UW_TAG_VAR          0x000a  // var slice
#define UW_TAG_HOME         0x000b  // home slice
#define UW_TAG_DUMP         0x000c  // dump slice
#define UW_TAG_ALT_ST       0x000d  // alternate sector track
#define UW_TAG_VM_PUBLIC    0x000e  // volume mgt public slice
#define UW_TAG_VM_PRIVATE   0x000f  // volume mgt private slice


// partition flags
#define UW_FLAG_UNMOUNTED   0x0001   // slice is unmounted
#define UW_FLAG_RDONLY      0x0010   // slice is read only
#define UW_FLAG_VALID       0x0200   // valid slice



#ifdef NEED_UNIXWARE_NAMES

#define UW_TAG_NAME_COUNT 16
static const char *uw_names[UW_TAG_NAME_COUNT]={
     "UNUSED",
     "BOOT",
     "ROOT",
     "SWAP",
     "USER FS",
     "WHOLE DISK",
     "ALT SECTOR SPACE",
     "NON UNIX",
     "ALT TRACK SPACE",
     "STAND",
     "VAR",
     "HOME",
     "DUMP",
     "ALT SECTOR/TRACK",
     "VOL MGT PUBLIC",
     "VOL MGT PRIVATE"
};

#endif


/*
 * Unixware slices support by Andrzej Krzysztofowicz <ankry@mif.pg.gda.pl>
 * and Krzysztof G. Baranowski <kgb@knm.org.pl>
 */

#define UNIXWARE_DISKMAGIC     (0xCA5E600DUL)   /* The disk magic number */
#define UNIXWARE_DISKMAGIC2    (0x600DDEEEUL)   /* The slice table magic nr */
#define UNIXWARE_NUMSLICE      16
#define UNIXWARE_FS_UNUSED     0        /* Unused slice entry ID */

struct unixware_slice {
    u_int16_t   s_label;    /* label */
    u_int16_t   s_flags;    /* permission flags */
    u_int32_t   start_sect; /* starting sector */
    u_int32_t   nr_sects;   /* number of sectors in slice */
};

struct unixware_disklabel {
    u_int32_t   d_type;                 /* drive type */
    u_int32_t   d_magic;                /* the magic number */
    u_int32_t   d_version;              /* version number */
    int8_t      d_serial[12];           /* serial number of the device */
    u_int32_t   d_ncylinders;           /* # of data cylinders per device */
    u_int32_t   d_ntracks;              /* # of tracks per cylinder */
    u_int32_t   d_nsectors;             /* # of data sectors per track */
    u_int32_t   d_secsize;              /* # of bytes per sector */
    u_int32_t   d_part_start;           /* # of first sector of this partition */
    u_int32_t   d_unknown1[12];         /* ? */
    u_int32_t   d_alt_tbl;              /* byte offset of alternate table */
    u_int32_t   d_alt_len;              /* byte length of alternate table */
    u_int32_t   d_phys_cyl;             /* # of physical cylinders per device */
    u_int32_t   d_phys_trk;             /* # of physical tracks per cylinder */
    u_int32_t   d_phys_sec;             /* # of physical sectors per track */
    u_int32_t   d_phys_bytes;           /* # of physical bytes per sector */
    u_int32_t   d_unknown2;             /* ? */
    u_int32_t   d_unknown3;             /* ? */
    u_int32_t   d_pad[8];               /* pad */

    struct unixware_vtoc {
        u_int32_t   v_magic;        /* the magic number */
        u_int32_t   v_version;      /* version number */
        int8_t      v_name[8];      /* volume name */
        u_int16_t   v_nslices;      /* # of slices */
        u_int16_t   v_unknown1;     /* ? */
        u_int32_t   v_reserved[10];     /* reserved */
        struct unixware_slice
            v_slice[UNIXWARE_NUMSLICE]; /* slice headers */
    } vtoc;

};  /* 408 */



int do_unixware_partition_discover( LOGICALDISK *ld, Partition_Record *part );
int do_unixware_partition_commit( LOGICALDISK *ld, DISKSEG *seg );

#endif

