/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libcsm.so
 *
 *   File: csm_plugin.c
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <uuid/uuid.h>

#include <plugin.h>
#include <csm_funcs.h>

#include "csm_plugin.h"

/*-------------------------------------------------------------------------------------+
+                                                                                      +
+                         PRIVATE DATA AREAS AND SUBROUTINES                           +
+                                                                                      +
+-------------------------------------------------------------------------------------*/

static plugin_record_t          csm_plugin_record;

plugin_record_t                *csm_plugin_record_ptr = &csm_plugin_record;

struct engine_functions_s      *EngFncs=NULL;

ece_nodeid_t                    csm_nodeid;

ece_clusterid_t                 csm_clusterid;

boolean                         csm_has_quorum;

boolean                         csm_admin_mode;

/*-------------------------------------------------------------------------------------+
+                                                                                      +
+                          Plugin Setup and Cleanup Functions                          +
+                                                                                      +
+--------------------------------------------------------------------------------------*/
static int csm_setup( engine_functions_t * engine_functions )
{
	int rc = 0;

	EngFncs = engine_functions;

	LOG_ENTRY();

	memset(&csm_nodeid, 0, sizeof(ece_nodeid_t));
	memset(&csm_clusterid, 0, sizeof(ece_clusterid_t));
	csm_has_quorum = FALSE;

	rc = EngFncs->get_config_bool("csm.admin_mode",&csm_admin_mode);
	if (rc) {
		LOG_DEBUG("bad rc back from get_config_bool\n");
		csm_admin_mode = FALSE;
	}
	else {
		LOG_DEBUG("good rc back from get config_bool\n");
	}

	if (csm_admin_mode == TRUE)
		LOG_DEBUG("running with admin mode ON\n");
	else
		LOG_DEBUG("running with admin mode OFF\n");

	rc = EngFncs->register_name( "csm" );

	LOG_EXIT_INT(rc);
	return rc;
}

static void csm_cleanup(void)
{
	LOG_ENTRY();

	delete_all_csm_segment_private_data();
	delete_all_csm_container_private_data();
	delete_all_csm_disk_private_data();

	LOG_EXIT_VOID();
}

/*-------------------------------------------------------------------------------------+
+                                                                                      +
+                              PLUGIN FUNCTION TABLE                                   +
+                                                                                      +
+--------------------------------------------------------------------------------------*/
static struct plugin_functions_s csm_plugin_functions = {
	setup_evms_plugin:              csm_setup,
	cleanup_evms_plugin:            csm_cleanup,
	can_set_volume:                 csm_can_set_volume,
	can_delete:                     csm_can_delete,
	can_expand:                     csm_can_expand,
	can_expand_by:                  csm_can_expand_by,
	can_shrink:                     csm_can_shrink,
	can_shrink_by:                  csm_can_shrink_by,
	discover:                       csm_discover,
	assign:                         csm_assign,
	can_unassign:                   csm_can_unassign,
	unassign:                       csm_unassign,
	create:                         csm_create,
	discard:                        csm_discard,
	delete:                         csm_destroy,
	expand:                         csm_expand,
	shrink:                         csm_shrink,
	add_sectors_to_kill_list:       csm_add_sectors_to_kill_list,
	commit_changes:                 csm_commit_changes,
	read:                           csm_read,
	write:                          csm_write,
	set_volume:                     csm_set_volume,
	get_option_count:               csm_get_option_count,
	init_task:                      csm_init_task,
	set_option:                     csm_set_option,
	set_objects:                    csm_set_objects,
	get_info:                       csm_get_info,
	get_plugin_info:                csm_get_plugin_info,
	activate:                       csm_activate,
	deactivate:                     csm_deactivate
};

/*-------------------------------------------------------------------------------------+
+                                                                                      +
+                           CONTAINER FUNCTION TABLE                                   +
+                                                                                      +
+--------------------------------------------------------------------------------------*/
static container_functions_t csm_container_functions = {
	can_create_container:           csm_can_create_container,
	can_delete_container:           csm_can_delete_container,
	can_add_object:                 csm_can_add_object,
	can_remove_object:              csm_can_remove_object,
	create_container:               csm_create_container,
	add_object:                     csm_add_object,
	transfer_object:                csm_transfer_object,
	discard_container:              csm_discard_container,
	remove_object:                  csm_remove_object,
	delete_container:               csm_delete_container,
	commit_container_changes:       csm_commit_container_changes,
	get_container_info:             csm_get_container_info,
	set_container_info:             csm_set_container_info,
	get_plugin_functions:           csm_get_plugin_functions,
	plugin_function:                csm_plugin_function
};


/*-------------------------------------------------------------------------------------+
+                                                                                      +
+                       BUILD AND EXPORT AN EVMS PLUGIN RECORD                         +
+                                                                                      +
+--------------------------------------------------------------------------------------*/

static plugin_record_t csm_plugin_record = {

	id:                                 CSM_PLUGIN_ID,

	version:                            {MAJOR_VERSION, MINOR_VERSION, PATCH_LEVEL},

	required_engine_api_version:        {13,0,0},
	required_plugin_api_version:        {plugin: {12,0,0}},
	required_container_api_version:     {9,0,0},

	short_name:                         "CSM",
	long_name:                          "Cluster Segment Manager",
	oem_name:                           "IBM",

	functions:                          {plugin: &csm_plugin_functions},

	container_functions:                &csm_container_functions

};

// Vector of plugin record ptrs that we export for the EVMS Engine.
plugin_record_t *evms_plugin_records[] = {
	&csm_plugin_record,
	NULL
};


