/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: expand.h
 *
 */

/*
 * Global functions exported by expand.c
 */

/* External APIs provided by expand.c */

extern int evms_can_expand(object_handle_t thing);

extern int evms_get_expand_points(object_handle_t           thing,
                                  expand_handle_array_t * * expand_points);

extern int evms_expand(object_handle_t  thing,
                       handle_array_t * objects,
                       option_array_t * options);

/* Internal functions to share with other Engine source modules */

extern int get_object_expand_points(storage_object_t * obj,
                                    u_int64_t        * max_delta_size,
                                    list_anchor_t      expand_points);

extern int get_volume_expand_points(logical_volume_t * volume,
                                    list_anchor_t      expand_points);

extern int engine_can_expand_by(storage_object_t * object,
                                sector_count_t   * delta_size);

