#include <qvbox.h>
#include <qlabel.h>
#include <qsplitter.h>
#include <qtimer.h>
#include <qwidgetstack.h>

#include <kpushbutton.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kaction.h>
#include <kactionclasses.h>
#include <kapplication.h>
#include <kdebug.h>
#include <kparts/part.h>
#include <ktrader.h>
#include <klibloader.h>
#include <kstatusbar.h>

#include <apt-pkg/packagemanager.h>
#include <apt-front/manager.h>
#include <apt-front/init.h>
#include <apt-front/cache/entity/package.h>
#include <apt-front/cache/component/state.h>
#include <apt-front/cache/component/history.h>
#include <apt-front/predicate/factory.h>

#include <libept/acqprogresswidget.h>
#include <libept/progress.h>
#include <libept/utils.h>

#include "app.h"

using namespace aptFront;
using namespace aptFront::cache;
using namespace ept;

App::App( KCmdLineArgs *args ) {
    setMainWidget( this );
    initialize();

    enum { None, Remove, Install } m = None;
    for(int i = 0; i < args->count(); i++) {
        QCString a = args->arg( i );
        if ( m == Install ) {
            kdDebug() << "installing " << a << endl;
            cache().packages().packageByName( std::string( a ) ).markInstall();
        } else if ( m == Remove ) {
            kdDebug() << "removing " << a << endl;
            cache().packages().packageByName( std::string( a ) ).markRemove();
        }

        if ( m == None && a == "install" )
            m = Install;
        if ( m == None && a == "remove" )
            m = Remove;
    }

    if ( m == 0 ) exit( 1 );

    observeComponent< component::State >();

    m_all = new QVBox( this );
    m_stack = new QWidgetStack( m_all );

    m_stack->addWidget( m_progress = new ept::AcqProgressWidget( m_stack ) );
    m_stack->addWidget( m_commitProgress = new CommitProgress( m_stack ) );

    setStandardToolBarMenuEnabled( false );
    createStandardStatusBarAction();
    setupGUI( Keys|StatusBar|Save|Create );
    delete toolBar();

    Application::setStatusBar( statusBar() );

    QTimer::singleShot(
        0, this,
        SLOT( delayed() ) );

    m_stack->raiseWidget( m_progress );
    setCentralWidget( m_all );
}

void App::delayed() {
    statusBar()->clear();

    kdDebug() << "App::delayed starting commit" << endl;

    aptFront::Manager m;
    m.setProgressCallback( m_progress->callback() );
    m.setUpdateInterval( 100000 );
    try {
        m_stack->raiseWidget( m_progress );
        m.download();
        m_stack->raiseWidget( m_commitProgress );
        m.commit();
    } catch ( exception::OperationCancelled ) {
    } catch ( ... ) {
        KMessageBox::sorry(
            this, i18n( "There was an error commiting changes. "
                        "Possibly there was a problem downloading some "
                        "packages or the commit would break packages. " ),
            i18n( "Could not commit changes" ) );
    }
}

#include "app.moc"
