#include <fstream>
#include <kdebug.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qpainter.h>
#include <iostream>
#include <kpopupmenu.h>
#include "sourceseditor.h"

using namespace aptFront;
using namespace ept;

SourcesEditor::SourcesEditor( std::string f, QWidget *p, const char *n )
    : SourcesEditorUi( p, n ), m_filename( f )
{
    m_list->setSorting( -1 );
    m_list->setAcceptDrops( true );
    connect( m_close, SIGNAL( clicked() ),
             this, SIGNAL( close() ) );
    connect( m_apply, SIGNAL( clicked() ),
             this, SLOT( save() ) );
    connect( m_reset, SIGNAL( clicked() ),
             this, SLOT( reset() ) );

    connect( m_list, SIGNAL( contextMenuRequested(
                                 QListViewItem *, const QPoint &, int) ),
             this, SLOT( contextMenu( QListViewItem *, const QPoint & ) ) );

    connect( m_newAdd, SIGNAL( clicked() ),
             this, SLOT( newAdd() ) );

    reset();
}

void SourcesEditor::newAdd()
{
    Sources::Entry e( true, Sources::Entry::Binary );
    std::string s = m_newLine->text();
    std::istringstream i( s );
    i >> e;
    new EntryItem( e, m_list );
    m_newLine->setText( "" );
}

void SourcesEditor::contextMenu( QListViewItem *, const QPoint &pt ) {
    EntryItem *s = dynamic_cast< EntryItem * >( m_list->selectedItem() );
    if (!s) return;
    KPopupMenu *m = new KPopupMenu (this);
    m->insertItem( s->entry().enabled() ? "Disable" : "Enable", 0 );
    m->insertItem( "Clone", 1 );
    m->insertItem( "Remove", 2 );
    connect( m, SIGNAL( activated( int ) ),
             this, SLOT( contextMenuActivated( int ) ) );
    m->exec( pt );
    delete m;
}

void SourcesEditor::contextMenuActivated( int i ) {
    EntryItem *s = dynamic_cast< EntryItem * >( m_list->selectedItem() );
    Sources::Entry e = s->entry();
    if (i == 0) {
        e.setEnabled( !e.enabled() );
        s->setEntry( e );
    }
    if (i == 2)
        delete s;
    if (i == 1)
        new EntryItem( e, m_list, s );
}

void SourcesEditor::reset() {
    std::ifstream in( m_filename.c_str() );
    m_sources.clear();
    in >> m_sources;
    utils::Range< Sources::Entry > r = m_sources.entries();
    EntryItem *last = 0;
    m_list->clear();
    while( r != r.last() ) {
        last = last ? new EntryItem( *r, m_list, last ) :
               new EntryItem( *r, m_list );
        ++ r;
    }
}

void SourcesEditor::save() {
    m_sources.clear();
    EntryItem *i = dynamic_cast< EntryItem * >( m_list->firstChild() );
    while (i) {
        m_sources.add( i->entry() );
        i = dynamic_cast< EntryItem * >( i->nextSibling() );
    }
    std::ofstream out( m_filename.c_str() );
    out << m_sources;
    std::cerr << "--" << m_sources << "--" << std::endl;
    out.close();
    reset(); // re-parse
}

/* void SourcesEditor::toggleSelectionEnabled()
{
    EntryItem *s = dynamic_cast< EntryItem * >( m_list->selectedItem() );
    if (s) {
        Sources::Entry e = s->entry();
        e.setEnabled( !e.enabled() );
        s->setEntry( e );
        updateActions();
    }
    } */

QString EntryItem::text( int c ) const {
    if (entry().type() == Sources::Entry::Comment) {
        if (c == 0)
            if (entry().comment() == "")
                return "(separator)";
            else
                return entry().typeString();
        if (c == 1)
            return entry().comment();
        return "";
    }

    if (c == 0) return entry().typeString();
    if (c == 1) return entry().url();
    if (c == 2) return entry().distribution();
    if (c == 3) return entry().components();
    return "";
}

void EntryItem::setText( int c, const QString &_s )
{
    kdDebug() << "setText on column " << c << endl;
    Sources::Entry e = entry();
    std::string s;
    s = _s.local8Bit();
    if (c == 0) e.setTypeString( s );
    if (c == 1)
        if (entry().type() == Sources::Entry::Comment)
            e.setComment( s );
        else
            e.setUrl( s );
    if (c == 2) e.setDistribution( s );
    if (c == 3) e.setComponents( s );
    setEntry( e );
    KListViewItem::setText( c, _s ); // stop qlistview from looping infinitely
}

void EntryItem::paintCell (QPainter *p, const QColorGroup &cg,
                            int column, int width, int alignment )
{
    QColorGroup _cg( cg );
    QColor c = _cg.text();
    QPixmap pm( width, height() );
    QPainter _p( &pm );
    if (!entry().enabled())
        c = Qt::gray;
    _cg.setColor( QColorGroup::Text, c );
    KListViewItem::paintCell( &_p, _cg, column, width, AlignTop );
    p->drawPixmap( 0, 0, pm );
}

