/** -*- C++ -*-
	@file libept/quickfilter.h
	@author Peter Rockai <me@mornfall.net>
*/

#include <apt-front/cache/entity/entity.h>
#include <apt-front/cache/entity/package.h>
#include <apt-front/predicate/factory.h>
#include <libept/quickfilterui.h>
#include <libept/filterlist.h>
#include <libept/lister.h>
#include <qlayout.h>

#ifndef EPT_QUICKFILTER_H
#define EPT_QUICKFILTER_H

class KLineEdit;

namespace ept {

template< typename T >
struct QuickFilter : predicate::Implementation< T, QuickFilter< T > >,
                     InterfacingPredicate
{
    enum Type { Regex, Substring, Exact };

    QuickFilter()
        : m_type( Substring ), m_match( "" ) {
        setupPredicate();
    }

    void setupPredicate() {
        predicate::ArgumentList l;
        l.push_back( m_match );
        m_op = predicate::map(
            predicate::predicate( predicate::Factory< T >::description( "" )
                                  or predicate::Factory< T >::name( "" )
                                  or predicate::Factory< T >::maintainer( "" ) ), l );
    }

    std::string summary() const {
        return std::string( "Quick filter: \"" )
            + m_match + "\"";
    }

    void parseArguments( const predicate::ArgumentList & ) {}

    bool operator==( const QuickFilter &o ) const {
        return o.m_type == m_type && o.m_match == m_match;
    }

    std::string typeString() const {
        if (m_type == Regex) return "Regular Expression";
        if (m_type == Substring) return "Substring";
        if (m_type == Exact) return "Exact Match";
    }

    bool operator()( const T &p ) {
        return m_op( p );
    }

    std::string match() const {
        return m_match;
    }
    void setMatch( const std::string &s ) {
        m_match = s;
        setupPredicate();
    }
protected:
    Type m_type;
    std::string m_match;
    predicate::Predicate< T > m_op;
};

class QuickFilterWidget : public QuickFilterUi
{
    Q_OBJECT
public:
    QuickFilterWidget( QWidget *parent, const char *name = 0 );
    virtual Predicate predicate();
public slots:
    void predicateChanged();
    void reset();
protected slots:
    void textChanged( const QString & );
protected:
    QTimer timer;
};

}

#endif
