#include <kdebug.h>
#include <libept/extendablelist.h>
#include <qtimer.h>

using namespace ept;

ExtendableList::ExtendableList( QWidget *p, const char *n )
    : KListView( p, n ),
      m_toggleColumn( 0 ), m_inDtor( false )
{
    kdDebug() << "connecting processClick har har" << endl;
    connect( this, SIGNAL( clicked( QListViewItem *,
                                    const QPoint &, int ) ),
             this, SLOT( processClick( QListViewItem *,
                                       const QPoint &, int ) ) );
    connect( this, SIGNAL( moved() ),
             this, SLOT( delayedUpdateExtenders() ) );
}

void ExtendableList::updateExtender( ExtendableItem *i )
{
    setUpdatesEnabled( false );
    addChild( i->extender(), 16, itemPos( i ) );
    i->extender()->show();
    i->extender()->resize( visibleWidth() - 16, i->height() );
    i->setHeight( i->extender()->frameSize().height() );
    setUpdatesEnabled( true );
    QTimer::singleShot( 0, this, SLOT( triggerUpdate() ) );
    // QTimer::singleShot( 0, i->extender(), SLOT( setupColors() ) );
}

void ExtendableList::delayedUpdateExtenders()
{
    kdDebug() << "ExtendableList::delayedUpdateExtenders()" << endl;
    QTimer::singleShot( 0, this, SLOT( updateExtenders() ) ); 
}


void ExtendableList::show()
{
    KListView::show();
    updateExtenders();
}

void ExtendableList::resizeEvent( QResizeEvent *e )
{
    KListView::resizeEvent( e );
    updateExtenders();
}

void ExtendableList::updateExtenders()
{
    std::for_each( m_extenders.begin(), m_extenders.end(),
                   std::bind1st( std::mem_fun( &ExtendableList::updateExtender ),
                                 this ) );
}

void ExtendableList::addExtender( ExtendableItem *item )
{
    m_extenders.insert( m_extenders.begin(), item );
    std::sort( m_extenders.begin(), m_extenders.end(), ExtendableItem::s_less );
    updateExtender( item );
    delayedUpdateExtenders(); 
}

void ExtendableList::removeExtender( ExtendableItem *i )
{
    m_extenders.erase( std::remove( m_extenders.begin(),
                                    m_extenders.end(), i ),
                       m_extenders.end() );
    // the above retains ordering so no need to re-sort
    if (!m_inDtor)
        delayedUpdateExtenders(); 
}

void ExtendableList::processClick( QListViewItem *it,
                                   const QPoint &pt, int c )
{
    // if (! it) return;
    ExtendableItem *item = dynamic_cast< ExtendableItem* >( it );
    if (!item) return;
    kdDebug() << "ExtendableList::processClick (a real item)" << endl;

    if (item->extender()) {
        if (c == m_toggleColumn)
            item->toggleExtender();
    } else
        item->toggleExtender();
}

ExtendableList::~ExtendableList() {
}

ExtendableList *ExtendableItem::list()
{
    return dynamic_cast< ExtendableList * >( listView() );
}

bool ExtendableItem::s_less(
    const ExtendableItem *a, const ExtendableItem *b )
{
    return a->less( b );
}

int ExtendableItem::compare( QListViewItem *i, int c, bool asc ) const
{
    ExtendableItem *o = dynamic_cast< ExtendableItem * >( i );
    return int( o->less( this ) ) - int( less( o ) );
}

void ExtendableItem::toggleExtender()
{
    if (m_extender) {
        setup();
        if( list() ) // this could as well be 0... bah
            list()->removeExtender( this );
        delete m_extender;
        m_extender = 0;
        updateIcon( list()->baseIcon() );
    } else {
        m_extender = createExtender();
        if (m_extender) {
            updateIcon( list()->extendedIcon() );
            m_extender->setItem( this );
            list()->addExtender( this );
        }
    }
}

ExtendableItem::~ExtendableItem()
{
    if( extender() && list() ) // this could as well be 0... bah
       list()->removeExtender( this );
    if (extender())
        delete extender();
}
