/*  This file is part of the CAPTURE library
    Copyright (C) 2004 Peter Rockai (mornfall) <mornfall@mornfall.homeip.net>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef DPKGPM_H
#  define DPKGPM_H

#include <apt-pkg/dpkgpm.h>
#include <vector>

namespace aptFront {
    class DPkgPM : public pkgDPkgPM {
        protected:
            int m_pipe[2];
            unsigned m_version;
        public:
            DPkgPM (pkgDepCache *C);
            virtual bool Go ( int );
            virtual bool setupArgs (char *const **a, std::vector<Item>::iterator &I);
            virtual bool forkDpkg (char *const argv[]);
            virtual bool forkScript (const char *, bool);
            virtual bool runScripts (const char *, bool);
            virtual bool setupChild ();
            virtual void setupScript (const char *, bool);
            virtual void dpkgMonitor (void);
            virtual bool SendV1Pkgs (FILE *);
            virtual bool feedPackages (void);
    };
}


#endif /* ifndef DPKGPM_H */

