/*  -*- C++ -*-
    Copyright (C) 2004, 2005 Peter Rockai <me@mornfall.net>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef EPT_DPKGPM_H
#  define EPT_DPKGPM_H

#include <apt-pkg/debsystem.h>
#include <libept/dpkgpm.h>
#include <libept/kde_terminal_interface.h>
#include <kprocess.h>
#include <kdialogbase.h>

class KListBox;
namespace KParts {
class Part;
}

namespace ept {

class PkgSystem : public debSystem
{
public:
    PkgSystem ();
    virtual pkgPackageManager *CreatePM( pkgDepCache *Cache ) const;
    virtual void setTerminal( KParts::Part *t );
    virtual int Score( Configuration const &Cnf ) {
        return debSystem::Score (Cnf) + 2; };
protected:
    KParts::Part *m_terminalPart;
};

/* class DPkgProgress : public KDialogBase {
   public:
   DPkgProgress (QWidget *parent = 0, const char *name = 0);
   void addMsg (std::string msg);
   protected:
   KListBox *m_l;
   }; */


class DPkgPM : public QObject, public aptFront::DPkgPM
{
    Q_OBJECT
public:
    DPkgPM (pkgDepCache *c, KParts::Part *t);
    virtual bool forkDpkg (char *const argv[]);
    virtual void dpkgMonitor (void);
    virtual bool Go (int);
    virtual bool forkScript (const char *, bool);
    ExtTerminalInterface *terminal();
 
public slots:
    void processExitC(const KProcess *p);
    void processExit(KProcess *p);
    void setupScriptPipe();

protected:
    KParts::Part *m_terminalPart;
    // DPkgProgress *m_prog;
            bool m_processRunning:1;
    const KProcess *m_exitedProcess;
};

}

#endif
