#include <iostream>
#include <kapplication.h>
#include <qstrlist.h>
#include <klistbox.h>
#include <kparts/part.h>
#include <apt-pkg/configuration.h>
#include <apt-pkg/error.h>
#include <libept/dpkgpm-gui.h>

using namespace aptFront;

namespace ept {

PkgSystem::PkgSystem()
{
    std::cerr << "kapture::PkgSystem::PkgSystem()" << std::endl;
    Label = "kaptureDPkgSystem";
}

void PkgSystem::setTerminal( KParts::Part *t )
{
    m_terminalPart = t;
}

pkgPackageManager *PkgSystem::CreatePM( pkgDepCache *c ) const
{
    std::cerr << "kapture::PkgSystem::CreatePM()" << std::endl;
    return new ept::DPkgPM( c, m_terminalPart );
}

DPkgPM::DPkgPM( pkgDepCache *cache, KParts::Part *t )
    : aptFront::DPkgPM (cache), m_terminalPart (t)
{
}

bool DPkgPM::forkDpkg( char *const argv[] )
{
    bool ok = true;
    std::cerr << "ept::DPkgPM::forkDpkg ()" << std::endl;
    QStrList l;
    for (int i = 0; argv[i]; i ++)
        l.append( argv[i] );
    m_processRunning = true;
    connect( m_terminalPart, SIGNAL( processExited( KProcess * ) ),
             this, SLOT( processExit( KProcess * ) ) );
    connect( m_terminalPart, SIGNAL( processExited( const KProcess * ) ),
             this, SLOT( processExitC( const KProcess * ) ) );
    terminal()->startProgram( argv[0], l );
    while (m_processRunning) {
        dpkgMonitor();
        usleep( 50000 );
    }
    if (m_exitedProcess->normalExit()) {
        if (m_exitedProcess->exitStatus() != 0) {
            ok = _error->Error( "Child for %s exited with error %d",
                                argv [0], m_exitedProcess->exitStatus());
        }
    } else {
        ok = _error->Error( "Child for %s was killed by signal %d",
                            argv [0], m_exitedProcess->exitSignal());
    }
    if (ok) // do we run scripts in case dpkg died???
        ok = runScripts ("DPkg::Post-Invoke", false);
    return ok;
}

ExtTerminalInterface *DPkgPM::terminal() {
    return static_cast<ExtTerminalInterface *>(
        m_terminalPart->qt_cast( "ExtTerminalInterface" ) );
}

bool DPkgPM::forkScript (const char *cmd, bool fP)
{
    std::cerr << "ept::DPkgPM::forkScript(\"" << cmd << "\")" << std::endl;
    if (fP) {
        if (pipe(m_pipe) != 0)
            return _error->Errno(
                "pipe","Failed to create IPC pipe to subprocess");
        SetCloseExec (m_pipe[0], true);
        SetCloseExec (m_pipe[1], true);
    }
    QStrList l;
    l.append ("/bin/sh");
    l.append ("-c");
    l.append (cmd);
    if (fP) {
        connect( m_terminalPart, SIGNAL( forkedChild() ),
                 this, SLOT( setupScriptPipe() ) );
    }

    connect( m_terminalPart, SIGNAL( processExited( KProcess * ) ),
             this, SLOT( processExit( KProcess * ) ) );
    connect( m_terminalPart, SIGNAL( processExited( const KProcess * ) ),
             this, SLOT( processExitC( const KProcess * ) ) );

    m_processRunning = true;
    terminal()->startProgram("/bin/sh", l);

    if (fP) {
        if (!feedPackages())
            return _error->Error("Failed feeding packages to script");
    }

    while (m_processRunning) {
        kapp->processEvents();
        usleep(50000);
    }

    std::cerr << "END: ept::DPkgPM::forkScript(\""
              << cmd << "\")" << std::endl;

    if (m_exitedProcess->normalExit()) {
        if (m_exitedProcess->exitStatus() != 0) {
            return _error -> Error("Child for %s exited with error %d",
                                   cmd, m_exitedProcess->exitStatus());
        } else {
            return true;
        }
    } else {
        return _error->Error("Child for %s was killed by signal %d",
                             cmd, m_exitedProcess->exitSignal());
    }
}

void DPkgPM::processExit(KProcess *p) {
    processExitC( p );
}

void DPkgPM::processExitC(const KProcess *p)
{
    std::cerr << "a process exited!" << std::endl;
    m_processRunning = false;
    m_exitedProcess = p;
}

void DPkgPM::setupScriptPipe()
{
    // setupScript();
    // std::cerr << "setupScriptPipe()" << std::endl;
    dup2 (m_pipe[0], STDIN_FILENO);
}

bool DPkgPM::Go( int )
{
    std::cerr << "kapture::DPkgPM::Go ()" << std::endl;
    // m_prog = new DPkgProgress (); // XXX: parent!
    // terminal()->newSession(); // XXX maybe good idea? think!
    // m_se -> widget () -> calcGeometry ();
    // m_prog -> show ();
    bool ret = aptFront::DPkgPM::Go(-1);
    QStrList l;
    l.append("echo");
    l.append("dpkg run finished!");
    terminal()->startProgram("echo", l);
    /* m_prog -> enableButton (KDialogBase::Ok, true);
    m_prog = 0; */
    return ret;
}

void DPkgPM::dpkgMonitor ()
{
    kapp->processEvents();
}

/* DPkgProgress::DPkgProgress (QWidget *parent, const char * name)
        : KDialogBase (parent, name, false, "DPkg progress", Ok|Cancel, Cancel)
{
    m_l = new KListBox (this);
    m_l -> setMinimumSize (QSize (500, 400));
    setMainWidget (m_l);
    enableButton (Cancel, false);
    enableButton (Ok, false);
}
void DPkgProgress::addMsg (std::string m)
{
    if (m != "")
        m_l -> insertItem (m . c_str ());
} */

}

#include "dpkgpm-gui.moc"
