#!/bin/sh

cfgFile=/tmp/$0.$$

cat <<EOT > $cfgFile
enigmail-*-linux*.xpi Linux_x86-gcc3 libenigmime.so
enigmail-*-darwin*.xpi Darwin_ppc-gcc3 libenigmime.dylib
enigmail-*-darwin*.xpi Darwin_x86-gcc3 libenigmime.dylib
enigmail-*-win32*.xpi WINNT_x86-msvc enigmime.dll
EOT


awk '
BEGIN {
  filenr=0
  targetpf=""
}
$1 !~ /^#/ {
  ++ filenr;
  if (filenr == 1) {
    printf("unzip %s\n", $1);
  }
  cDir = sprintf("platform/%s/components", $2);
  printf("mkdir -p %s\n", cDir);
  printf("unzip %s components/%s\n", $1, $3);
  printf("mv components/%s %s/\n", $3, cDir);
  targetpf = sprintf("%s<em:targetPlatform>%s</em:targetPlatform>\n", targetpf, $2);

}
END {
  gsub(/\//, "\\\\/", targetpf);
  printf("sed \x27s/<!-- targetPlatform placeholder -->/%s/\x27 < install.rdf > install.rdf.new\n", targetpf);
  printf("mv install.rdf.new install.rdf\n");
}' $cfgFile

rm $cfgFile