# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.components import input_provider
from elisa.core import input_event
from elisa.core.tests.elisa_test_case import ElisaTestCase

class TestInputEvent(ElisaTestCase):

    def test_attributes(self):
        evt = input_event.InputEvent(input_event.EventSource.MOUSE,
                                     input_event.EventType.MOUSE_UP,
                                     input_event.EventValue.MOUSE_LEFT)

        self.assertEquals(evt.source, input_event.EventSource.MOUSE)
        self.assertEquals(evt.type, input_event.EventType.MOUSE_UP)
        self.assertEquals(evt.value, input_event.EventValue.MOUSE_LEFT)

        # no source type
        self.assertRaises(ValueError, input_event.InputEvent, None,
                          input_event.EventType.MOUSE_UP,
                          input_event.EventValue.MOUSE_LEFT)

        # no event type
        self.assertRaises(ValueError, input_event.InputEvent,
                          input_event.EventSource.MOUSE, None,
                          input_event.EventValue.MOUSE_LEFT)

    def test_cmp(self):
        evt1 = input_event.InputEvent(input_event.EventSource.MOUSE,
                                      input_event.EventType.MOUSE_UP,
                                      input_event.EventValue.MOUSE_RIGHT)

        evt2 = input_event.InputEvent(input_event.EventSource.MOUSE,
                                      input_event.EventType.MOUSE_UP,
                                      input_event.EventValue.MOUSE_LEFT)

        self.assertEqual(evt1, evt1)
        self.assertEqual(evt2, evt2)
        self.assertNotEqual(evt1, evt2)

        evt2.value = input_event.EventValue.MOUSE_RIGHT
        self.assertEqual(evt1, evt2)

        self.assertNotEqual(evt1, None)
        self.assertNotEqual(None, evt2)
