#-*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from twisted.trial.unittest import TestCase
from elisa.core.utils.i18n import install_translation, compile_po_files
from elisa.core.plugin_registry import PluginRegistry
from elisa.core.utils.misc import pkg_resources_copy_dir as copy_dir
from elisa.core.tests.test_plugin_registry import TestPluginRegistryMixin
import os
import sys


class I18nTest(TestCase, TestPluginRegistryMixin):

    plugin_registry = None

    def setUpClass(self):
        TestPluginRegistryMixin.setUpClass(self)

        # create the PluginRegistry instance used by the tests
        self.plugin_registry = PluginRegistry([self.plugins_dir])
        self.plugin_registry.load_plugins()

        dest_dir = os.path.join(self.test_dir, '0.1', 'test_simple', 'i18n')
        announce = lambda s: None

        compile_po_files('elisa-plugin-test_simple', dest_dir, dest_dir, announce)

    def copy_plugins(self):
        TestPluginRegistryMixin.copy_plugins(self)
        dest_dir = os.path.join(self.test_dir, '0.1/test_simple/i18n')
        copy_dir('elisa.core', 'tests/data/i18n',
                 dest_dir)

    def test_translation(self):
        old_lang = os.environ.get('LANG')

        os.environ['LANG'] = 'fr_FR'
        self._ = install_translation('test_simple')
        self.assertEquals(self._("Popular tags"), u"Étiquettes populaires")

        if old_lang:
            os.environ['LANG'] = old_lang

    def test_no_translation(self):
        old_lang = os.environ.get('LANG')

        os.environ['LANG'] = 'de_DE'
        self._ = install_translation('test_simple')
        self.assertEquals(self._("Popular tags"), u"Popular tags")

        if old_lang:
            os.environ['LANG'] = old_lang
