# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.tests.elisa_test_case import ElisaTestCase
from elisa.core import common
from twisted.internet import defer

class ComponentTestCase(ElisaTestCase):
    component_class = None

    def setUp(self):
        ElisaTestCase.setUp(self)
        dfr = None
        if isinstance(self.component_class, basestring):
            plugin_registry = common.application.plugin_registry
            dfr = plugin_registry.create_component(self.component_class)
        else:
            dfr = self.component_class.create()

        def create_done(component):
            self.component = component

            return component

        dfr.addCallback(create_done)
        return dfr

    def tearDown(self): 
        return self.component.clean()
