# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'


from elisa.core import common, plugin_registry
from elisa.core.plugin_registry import PluginNotFound, ComponentNotFound
from elisa.core.media_uri import MediaUri

from elisa.extern.translation import gettexter, N_
T_ = gettexter('elisa-theme-switcher')

from switch_theme_action import SwitchThemeAction


MenuActivityClass = plugin_registry.get_component_class('base:menu_activity')

class ThemeSwitcherActivity(MenuActivityClass):
    """
    Manages a list of themes that the user can switch between.
    """
    config_doc = {'themes': "a list of themes (eg. ['classic:theme',"
                            "'poblenou:tango_theme'])"}
    default_config = {'themes': []}

    menu_name = T_(N_("Themes"))
    media_types = []

    def get_model(self):
        """
        Returns a menu_node_model for the Theme menu
        """
        registry = common.application.plugin_registry
        main_node = MenuActivityClass.get_model(self)
        main_node.theme_icon = "theme_switcher_icon"
        main_node.children = registry.create_component("base:list_model")
        main_node.activity = self

        for theme_path in self.config.get("themes" , []):
            try:
                component = registry.create_component(theme_path)
            except (PluginNotFound, ComponentNotFound), error:
                self.warning(error)
            else:
                self.log("Component %r with menu model %r", component, \
                         component.name)
                label = component.name.split('_')[0].capitalize()
                menu_model = self._create_menu_model(label, 'theme')
                path = component.get_media('theme_icon')
                thumbnail = MediaUri( {'scheme' : 'file', 'path' : path} )
                menu_model.thumbnail_source = thumbnail
                action = SwitchThemeAction()
                action.theme_path = theme_path
                menu_model.activate_action = action
                menu_model.activity = self
                menu_model.file_type = "theme"
                
                if menu_model != None:
                    self.log("menu model: %r", menu_model)
                    main_node.children.append(menu_model)
                else:
                    self.debug("menu_model %r should have got %r appended",
                               main_node, component.name)

        main_node.has_children = len(main_node.children) > 0
        
        return main_node
