#!/bin/bash
#Module diagnostic.tc de l'interface EagleConnect.tcl version 0.8  Copyright (C) 2004 Emmanuel Yves
#Ce programme est libre, vous pouvez le redistribuer et /ou le modifier selon les termes
#de la Licence Publique Gnrale GNU  publie par la Free Software Foundation (version 2 
#ou bien toute autre version ultrieure choisie par vous). 
#Ce programme est distribu car potentiellement utile, mais SANS AUCUNE GARANTIE, 
#ni explicite ni implicite, y compris les garanties de commercialisation ou d'adaptation 
#dans un but spcifique. Reportez-vous  la Licence Publique Gnrale GNU pour plus de dtails.
#Vous devez avoir reu une copie de la Licence Publique Gnrale GNU en mme temps que ce programme ;
#si ce n'est pas le cas, crivez  la Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
#MA 02111-1307, tats-Unis.
#Pour de plus amples informations, consultez la documentation jointe  ce programme.

# La ligne suivante est executee par sh, pas par Tcl \
exec wish "$0" ${1+"$@"}


package require msgcat;
msgcat::mclocale $env(LANG);
#::msgcat::mclocale "en_EN"

msgcat::mcload /etc/eagle-usb/eagleconnect


#ci-dessus, j'appelle le paquetage msgcat qui va me permettre d'afficher les messages
#de l'interface dans la langue du systme de l'utilisateur (dfinie dans $env(LANG)).
#la commande msgcat::mcload [pwd] permet justement de charger les catalogues propres 
#chaque langue (en.msg si LANG = en_EN, fr.msg si LANG = fr_FR etc...)
# avec ::msgcat::mclocale "en_EN" ci-dessus, j'essaie en environnement en_EN 
# pour voir si le catalogue de traduction anglais est correctement appel

set env(PATH) /bin:/sbin:/usr/bin:/usr/sbin:/usr/X11R6/bin:/usr/local/sbin;
# je dfinis les chemins o peuvent se situer les excutables



#wm maxsize . 300 200
wm title . [msgcat::mc "Gestionnaire d'EagleConnect"]
wm geometry . +100+100


frame .frame1
pack .frame1 -fill x;



set env(PATH) /bin:/sbin:/usr/bin:/usr/sbin:/usr/X11R6/bin:/usr/local/sbin;
# je redfinis le path dont j'aurai besoin pour trouver les excutables






#--------------------------------------------------------------------------------------------------------------------
#----------------------------FENETRE CREATION / SUPPRESSION UTILISATEUR--------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------



#je redfinis la hauteur de la fentre principale de faon  voir le rsultat ultrieur

proc paramsystem {} {



destroy .framepref
destroy .boutonprevious
destroy .boutonexit

#Je configure mes deux boutons. Lorsque l'un est actif (ici, bouton 1), les caractres passent en bleu et
# son style de relief passe en incrust. L'autre bouton redevient normal et caractres en noir
#.frame1.bouton1 configure -relief sunken -foreground blue
# .frame1.bouton2 configure -relief groove -foreground black


#---------------Cration de la frame qui va contenir les utilisateurs------------------------------------


frame .frameutilisateurs 
pack .frameutilisateurs -fill both -expand true 

# ci-dessous, on recherche le login du simple utlisateur actif

#global login
#set login1 [exec who -u]
#puts $login1
#set rech2pts [string first " " $login1]
#set login [string range $login1 0 [expr {$rech2pts-1}]]
#puts /home/$login

cd ~/.eagleconnect




frame .frameutilisateurs.contientpresentation 
label .frameutilisateurs.contientpresentation.presentation -text [msgcat::mc ""] -font [list Arial 12] -relief sunken  -height 3 
pack .frameutilisateurs.contientpresentation.presentation -expand false -fill x
pack .frameutilisateurs.contientpresentation -expand false -fill x


#--------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------- LISTBOX DES UTILISATEURS --------------------------------------------------------
#--------------------------------------------------------------------------------------------------------------------------------------

frame .frameutilisateurs.contienttout
listbox .frameutilisateurs.contienttout.selectutilisateur -selectmode single -setgrid true -height 20 -width 20 -bg white -yscrollcommand ".frameutilisateurs.contienttout.defilement set"
foreach utilisateur [lsort [glob -nocomplain *.*]] {

   .frameutilisateurs.contienttout.selectutilisateur insert end $utilisateur
   
 }



scrollbar .frameutilisateurs.contienttout.defilement  -command ".frameutilisateurs.contienttout.selectutilisateur yview"


#------------------------------------------------------------------------------------------------------------------------------
#---------------------------------- DETECTION DU CHAMP QUI A LE FOCUS DANS LA LISTBOX---------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------

bind .frameutilisateurs.contienttout.selectutilisateur <ButtonRelease> {
    global num
    global val
    set num [.frameutilisateurs.contienttout.selectutilisateur curselection]
    set val [.frameutilisateurs.contienttout.selectutilisateur get $num]
    set num [expr $num + 1]
    puts $num
    puts $val
}

bind .frameutilisateurs.contienttout.selectutilisateur <Enter> {
set identifiant [exec whoami]

.frameutilisateurs.contientpresentation.presentation configure -text "Parameters detected automatically by Eagleconnect have been saved into $identifiant.pref file.\n For allowing non root user to use EagleConnect, think to modify the /etc/sudoers file as root by clicking on 'Modify ...' button" 
}

bind .frameutilisateurs.contienttout.selectutilisateur <Leave> {
.frameutilisateurs.contientpresentation.presentation configure -text ""
}






#---------------------------------------------------------------------------------------------------------------------------------
#------------------------------------------- CHAMPS DE DECLARATION DES UTILITAIRES SYSTEME ---------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------



frame .frameutilisateurs.containerframes -borderwidth 3 -relief sunken

frame .frameutilisateurs.containerframes.frame0
label .frameutilisateurs.containerframes.frame0.texte0 -text [msgcat::mc "PATH UTILITIES FOUND BY EAGLECONNECT"] -font [list Arial 12]

frame .frameutilisateurs.containerframes.frame1
label .frameutilisateurs.containerframes.frame1.separation -text [msgcat::mc ""] -font [list Arial 12]

frame .frameutilisateurs.containerframes.frame2
label .frameutilisateurs.containerframes.frame2.texte1 -text "Emplacement de la commande fctStartAdsl :" -font [list Arial 10]
entry .frameutilisateurs.containerframes.frame2.champconnect -background white -justify left -font [list Arial 12] \
 -textvariable connect \
 -width 30; \

frame .frameutilisateurs.containerframes.frame3
label .frameutilisateurs.containerframes.frame3.texte2 -text [msgcat::mc "Example : /usr/local/sbin/fctStartAdsl"] -font [list Arial 10]

frame .frameutilisateurs.containerframes.frame4
label .frameutilisateurs.containerframes.frame4.texte3 -text "Emplacement de la commande fctStopAdsl :" -font [list Arial 10]
entry .frameutilisateurs.containerframes.frame4.champdeconnect -background white -justify left -font [list Arial 12] \
 -textvariable deconnect \
 -width 30; \

frame .frameutilisateurs.containerframes.frame5
label .frameutilisateurs.containerframes.frame5.texte4 -text [msgcat::mc "Example : /usr/local/sbin/fctStopAdsl"] -font [list Arial 10]

frame .frameutilisateurs.containerframes.frame6
label .frameutilisateurs.containerframes.frame6.texte5 -text "Emplacement  de  la  commande  eaglectrl :" -font [list Arial 10]
entry .frameutilisateurs.containerframes.frame6.reinitialise -background white -justify left -font [list Arial 12] \
 -textvariable initial \
 -width 30; \

frame .frameutilisateurs.containerframes.frame7
label .frameutilisateurs.containerframes.frame7.texte6 -text [msgcat::mc "Example : /usr/local/sbin/eaglectrl"] -font [list Arial 10]

frame .frameutilisateurs.containerframes.frame8
label .frameutilisateurs.containerframes.frame8.texte7 -text "Emplacement  de  la  commande  eaglestat :" -font [list Arial 10]
entry .frameutilisateurs.containerframes.frame8.statistiques -background white -justify left -font [list Arial 12] \
 -textvariable stat \
 -width 30; \

frame .frameutilisateurs.containerframes.frame9
label .frameutilisateurs.containerframes.frame9.texte8 -text [msgcat::mc "Example : /usr/local/sbin/eaglestat"] -font [list Arial 10]

frame .frameutilisateurs.containerframes.frame10
label .frameutilisateurs.containerframes.frame10.texte9 -text "Emplacement  de  la  commande eaglediag :" -font [list Arial 10]
entry .frameutilisateurs.containerframes.frame10.diagnostic -background white -justify left -font [list Arial 12] \
 -textvariable diag \
 -width 30; \

frame .frameutilisateurs.containerframes.frame11
label .frameutilisateurs.containerframes.frame11.texte10 -text [msgcat::mc "Example : /usr/local/sbin/eaglediag"] -font [list Arial 10]




#----------------------------------------------------------------------------------------------------------------------------------
#--------------------------------- BOUTONS DE SUPPRESSION FICHIER PREFERENCES UTILISATEUR ---------------------------------------------------
#-----------------------------------------------------------------------------------------------------------------------------------

frame .frameutilisateurs.framedesboutons

 
button .frameutilisateurs.framedesboutons.boutonsup -text [msgcat::mc "Delete user"] -width 20 -command {
toplevel .choix
wm title .choix "Attention"
wm geometry .choix 500x150+200+200
label .choix.message -text [msgcat::mc "Do you really want to delete this user ?"] -font [list Arial 14] -height 2
pack .choix.message -fill x -expand true -pady 12
button .choix.yes -text [msgcat::mc "Yes"]  -width 10 -font [list Arial 14] -command {
file delete $val; 
.contienttout.selectutilisateur delete 0 end;
foreach utilisateur [lsort [glob -nocomplain *.*]] {

   .contienttout.selectutilisateur insert end $utilisateur}
destroy .choix
}
button .choix.no -text [msgcat::mc "No"] -width 10 -font [list Arial 14] -command { destroy .choix}
pack .choix.yes .choix.no -side left -padx 5 -expand true -pady 12
}



#----------------------------------------------------------------------------------------------------------------------------
#-----------------------------BOUTON DESTINE A VISUALISER LE FICHIER DES PREFERENCES UTILISATEUR----------------------------
#----------------------------------------------------------------------------------------------------------------------------

set identifiant [exec whoami]

button .frameutilisateurs.framedesboutons.boutonvoirpref -text "See $identifiant.pref file" -width 20 -command {

set identifiant [exec whoami]
set readfichierpref [open ~/.eagleconnect/$identifiant.pref r]

toplevel .windowvisupref; wm maxsize .windowvisupref 1500 500; wm title .windowvisupref {Contenu du fichier de configuration}; 
wm geometry .windowvisupref 1000x500+200+200; frame .windowvisupref.fenetre; pack .windowvisupref.fenetre;


text .windowvisupref.fenetre.contenufichier -height 500 -width 800  \
-background white -font {Fixed 16} -wrap word -yscrollcommand ".windowvisupref.fenetre.scroll set";

# je cre l'ascenseur  
scrollbar .windowvisupref.fenetre.scroll -command ".windowvisupref.fenetre.contenufichier yview";

# je rends l'ascenseur visible 
pack .windowvisupref.fenetre.scroll -side right -fill y; 

# je rends mon widget text visible
pack .windowvisupref.fenetre.contenufichier -expand yes -fill both

while { ![eof $readfichierpref] } {
gets $readfichierpref readlinespref;
.windowvisupref.fenetre.contenufichier insert end $readlinespref

# J'insre un retour chariot (\n) aprs chaque ligne 
.windowvisupref.fenetre.contenufichier insert end \n;}

close $readfichierpref

}








#----------------------------------------------------------------------------------------------------------------------------
#-----------------------------BOUTON DESTINE A VISUALISER LE FICHIER /ETC/SUDOERS-----------------------------------------------
#----------------------------------------------------------------------------------------------------------------------------


button .frameutilisateurs.framedesboutons.boutonvoirsudoers -text "See /etc/sudoers file" -width 20 -command {
set fichiersudoers [open /etc/sudoers r]

toplevel .windowsudoers; wm maxsize .windowsudoers 1000 500; wm title .windowsudoers {Contenu du fichier /etc/sudoers}; 
wm geometry .windowsudoers 800x500+200+200; frame .windowsudoers.fenetre; pack .windowsudoers.fenetre;


text .windowsudoers.fenetre.contenufichier -height 500 -width 800  \
-background white -font {Fixed 16} -wrap word -yscrollcommand ".windowsudoers.fenetre.scroll set";

# je cre l'ascenseur  
scrollbar .windowsudoers.fenetre.scroll -command ".windowsudoers.fenetre.contenufichier yview";

# je rends l'ascenseur visible 
pack .windowsudoers.fenetre.scroll -side right -fill y; 

# je rends mon widget text visible
pack .windowsudoers.fenetre.contenufichier -expand yes -fill both

while { ![eof $fichiersudoers] } {
gets $fichiersudoers ligneluesudoers;
.windowsudoers.fenetre.contenufichier insert end $ligneluesudoers

# J'insre un retour chariot (\n) aprs chaque ligne 
.windowsudoers.fenetre.contenufichier insert end \n;}

close $fichiersudoers

}



#----------------------------------------------------------------------------------------------------------------
#-------------------MESSAGE QUI S'AFFICHE LORSQUE L'ON POINTE LE CURSEUR DE LA SOURIS SUR LE BOUTON--------------------
#--------------------------------------------------------------------------------------------------------------



bind .frameutilisateurs.framedesboutons.boutonvoirsudoers <Enter> {

.frameutilisateurs.contientpresentation.presentation configure -text "Here, you can see the /etc/sudoers file"
}

bind .frameutilisateurs.framedesboutons.boutonvoirsudoers <Leave> {
.frameutilisateurs.contientpresentation.presentation configure -text ""
}




#------------------------------------------------------------------------------------------------------------------------------
#--------------------------BOUTON DESTINE A MODIFIER AUTOMATIQUEMENT LE FICHIER /ETC/SUDOERS-----------------------------------
#--------------------------------------------------------------------------------------------------------------------------



button .frameutilisateurs.framedesboutons.boutonsudoers -text "Modify /etc/sudoers file" -width 20 -command {

set identifiant [exec whoami]
if {$identifiant == "root"} {

# ci-dessous, on recherche le login du simple utilisateur actif (simple utilisateur non root)

global login
set login1 [exec who -u]
puts $login1
set rech2pts [string first " " $login1]
set login [string range $login1 0 [expr {$rech2pts-1}]]
puts /home/$login


# ci-dessous, on recherche le chemin des excutables


set pathfctStartAdsl [exec whereis fctStartAdsl]
set start [string first "/" $pathfctStartAdsl]
set startadsl [string range $pathfctStartAdsl $start end]

set pathfctStopAdsl [exec whereis fctStopAdsl]
set stop [string first "/" $pathfctStopAdsl]
set stopadsl [string range $pathfctStopAdsl $stop end]

set pathvareaglediag [exec whereis eaglediag]
set diag [string first "/" $pathvareaglediag]
set vareaglediag [string range $pathvareaglediag $diag end]

set patheaglestat [exec whereis eaglestat]
set stat [string first "/" $patheaglestat]
set eaglestat [string range $patheaglestat $stat end]

set pathvareaglectrl [exec whereis eaglectrl]
set ctrl [string first "/" $pathvareaglectrl]
set vareaglectrl [string range $pathvareaglectrl $ctrl end]


# ci-dessous, on modifie - ou non - le fichier /etc/sudoers pour que l'utilisateur puisse
# bnficier des commandes via sudo


set fichiersudoers [open /etc/sudoers a+]
seek $fichiersudoers 0 start 
set lecturesudoers [read $fichiersudoers]

set verifsudoers [string first "fctStartAdsl" $lecturesudoers]
if {$verifsudoers == -1} {
set entree1 "$login ALL=NOPASSWD:$startadsl"
set entree2 "$login ALL=NOPASSWD:$stopadsl -sf"
set entree3 "$login ALL=NOPASSWD:$eaglediag"
set entree4 "$login ALL=NOPASSWD:$eaglestat"
set entree5 "$login ALL=NOPASSWD:$eaglectrl -w"

puts $fichiersudoers $entree1
puts $fichiersudoers $entree2
puts $fichiersudoers $entree3
puts $fichiersudoers $entree4
puts $fichiersudoers $entree5

tk_messageBox -message "Le fichier /etc/sudoers a t modifi avec succs"


} else {

tk_messageBox -message "Nothing to do : etc/sudoers file has already been configured";

}

close $fichiersudoers

} else {tk_messageBox -message "/etc/sudoers file modification not permitted to single user"}


}



#----------------------------------------------------------------------------------------------------------------
#-------------------MESSAGE QUI S'AFFICHE LORSQUE L'ON POINTE LE CURSEUR DE LA SOURIS SUR LE BOUTON--------------------
#--------------------------------------------------------------------------------------------------------------



bind .frameutilisateurs.framedesboutons.boutonsudoers <Enter> {

.frameutilisateurs.contientpresentation.presentation configure -text "With this button, the /etc/sudoers file will be modified so that all eagle-usb driver utilities may be launched by single user.\n You can also modify this file as root by typing in a term : visudo -sf /etc/sudoers. See the EagleConnect manual"
}

bind .frameutilisateurs.framedesboutons.boutonsudoers <Leave> {
.frameutilisateurs.contientpresentation.presentation configure -text ""
}








#-----------------------------------------------------------------------------------------------------------------------------
#-------------------------------------------------PLACEMENT DES ELEMENTS DE L'INTERFACE----------------------------------------
#-----------------------------------------------------------------------------------------------------------------------------


pack .frameutilisateurs.contienttout.selectutilisateur -side left -fill y
pack .frameutilisateurs.contienttout.defilement -side left -fill y
pack .frameutilisateurs.contienttout -side left -fill y
pack .frameutilisateurs.framedesboutons.boutonsup .frameutilisateurs.framedesboutons.boutonvoirpref .frameutilisateurs.framedesboutons.boutonvoirsudoers .frameutilisateurs.framedesboutons.boutonsudoers -pady 5 
pack .frameutilisateurs.framedesboutons -side left -anchor n
pack .frameutilisateurs.containerframes 


#-fill x


pack .frameutilisateurs.containerframes.frame0.texte0
pack .frameutilisateurs.containerframes.frame0
pack .frameutilisateurs.containerframes.frame1.separation
pack .frameutilisateurs.containerframes.frame1
pack .frameutilisateurs.containerframes.frame2.texte1 .frameutilisateurs.containerframes.frame2.champconnect -side left 
pack .frameutilisateurs.containerframes.frame2
pack .frameutilisateurs.containerframes.frame3.texte2 -side left
pack .frameutilisateurs.containerframes.frame3
pack .frameutilisateurs.containerframes.frame4.texte3 .frameutilisateurs.containerframes.frame4.champdeconnect -side left
pack .frameutilisateurs.containerframes.frame4
pack .frameutilisateurs.containerframes.frame5.texte4
pack .frameutilisateurs.containerframes.frame5 
pack .frameutilisateurs.containerframes.frame6.texte5 .frameutilisateurs.containerframes.frame6.reinitialise -side left
pack .frameutilisateurs.containerframes.frame6
pack .frameutilisateurs.containerframes.frame7.texte6 -side left
pack .frameutilisateurs.containerframes.frame7
pack .frameutilisateurs.containerframes.frame8.texte7 .frameutilisateurs.containerframes.frame8.statistiques -side left
pack .frameutilisateurs.containerframes.frame8
pack .frameutilisateurs.containerframes.frame9.texte8 -side left
pack .frameutilisateurs.containerframes.frame9
pack .frameutilisateurs.containerframes.frame10.texte9 .frameutilisateurs.containerframes.frame10.diagnostic -side left
pack .frameutilisateurs.containerframes.frame10
pack .frameutilisateurs.containerframes.frame11.texte10 -side left
pack .frameutilisateurs.containerframes.frame11
button .bouton2 -width 20 -text [msgcat::mc "Next"] -relief groove -command {prefinter}
pack .bouton2 -side bottom



cherchechemin a;



set taillefenetre [winfo reqwidth .]
puts $taillefenetre

}




#----------------------------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------------------
#---------------------------------------FENETRE PREFERENCES INTERFACE ----------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------------------
#----------------------------------------------------------------------------------------------------------------------





proc prefinter {} {
wm geometry . +100+100

destroy .frameutilisateurs
destroy .contienttout
destroy .framedesboutons
destroy .containerframes
destroy .containerframes.frame2.texte1 
destroy .containerframes.frame2.champconnect
destroy .containerframes.frame2
destroy .containerframes.frame3.texte2
destroy .containerframes.frame3
destroy .containerframes.frame4.texte3 
destroy .containerframes.frame4.champdeconnect
destroy .containerframes.frame4
destroy .containerframes.frame5.texte4
destroy .containerframes.frame5 
destroy .containerframes.frame6.texte5 
destroy .containerframes.frame6.reinitialise 
destroy .containerframes.frame6
destroy .containerframes.frame7.texte6 
destroy .containerframes.frame7
destroy .containerframes.frame8.texte7 
destroy .containerframes.frame8.statistiques 
destroy .containerframes.frame8
destroy .containerframes.frame9.texte8 
destroy .containerframes.frame9
destroy .containerframes.frame10.texte9 
destroy .containerframes.frame10.diagnostic 
destroy .containerframes.frame10
destroy .containerframes.frame11.texte10 
destroy .containerframes.frame11
destroy .bouton2



#----Cration de la frame des prfrences utilisateurs

frame .framepref 
pack .framepref -fill both -expand false

frame .framepref.aide 
label .framepref.aide.texteintro -text "EagleConnect" -font [list Arial 12] -relief sunken -height 3

pack .framepref.aide.texteintro -side left -expand true -fill x

pack .framepref.aide -expand false  -fill x


frame .framepref.panneau1
frame .framepref.panneau2
frame .framepref.panneau3
frame .framepref.panneau4




#-- Ci-dessous j'obtiens la liste de toutes les polices prsentes sur le systme (commande font families)
global listFontes1
global listFontes

set listFontes1 [font families]
set listFontes [lsort $listFontes1]

#--Je dfinis une liste de valeurs pour les tailles de polices

global listtailles
set listtailles [list 8 10 12 14 16 18 20 22 24]

# Ci-dessous, je cre deux listbox avec ascenseur qui contiendront, 1 les noms des fontes (-listvariable contient les valeurs de listFontes), 2 les tailles (-listvariable contient les valeurs de listtailles) 

listbox .framepref.panneau1.listedesfontes -selectmode single -setgrid true -height 20 -width 20 -bg white -listvariable listFontes -yscrollcommand ".framepref.panneau1.barre1 set"
listbox .framepref.panneau1.listedestailles -selectmode single -setgrid true -height 20 -width 20 -bg white -listvariable listtailles -yscrollcommand ".framepref.panneau1.barre2 set"
scrollbar .framepref.panneau1.barre1  -command ".framepref.panneau1.listedesfontes yview"
scrollbar .framepref.panneau1.barre2  -command ".framepref.panneau1.listedestailles yview"


# Ci-dessous, je dclenche une action en cliquant sur la listbox des fontes
# Je vrifie si la variable verif existe. Si oui, $verif2 = 1, et j'efface la variable police1
# pour ne pas avoir de message d'eeeur lorsque je vais cliquer sur un autre nom de police (message
# d'erreur : la police existe dj) sinon = 0.
# J'affecte  la variable idx la valeur (l'indice) de la selection courante de la listbox
# Si $idx n'est pas vide, alors j'affecte  la variable police la valeur contenue dans $listfontes renvoye par la commande lindex 
# et je dclare un nouveau de police (police1) rattache  une police existante grce  la commande font create.
# Enfin, j'affecte au bouton tmoin boutonfontes la police (-font [list police1]on met $police1 dans une liste au cas o le nom comporterait des espaces)


bind .framepref.panneau1.listedesfontes <ButtonRelease> {
global police
global listFontes
global policecourante
set verif2 [info exists verif]
if {$verif2 == 1} {puts "oui"; font delete police1} else {puts "non"; set sansobjet 0}
set idx [.framepref.panneau1.listedesfontes curselection]
if {$idx!=""} {
set police [lindex $listFontes $idx]
font create police1 -family $police
.framepref.panneau1.boutonfontes configure -text "A"  -font [list police1]
set verif 1
set policecourante [font actual police1]
}
}


# Idem que ci-dessus, except qu'il s'agit ici des tailles des polices (contenues dans $listtailles, voir plus haut)

bind .framepref.panneau1.listedestailles <ButtonRelease> {
global verif
global police
global police1
global listtailles
global listFontes
global policecourante

set verif 1
set nbr [.framepref.panneau1.listedestailles curselection]
if {$nbr!=""} {
set taille [lindex $listtailles $nbr]
font configure police1 -size $taille

.framepref.panneau1.boutonfontes configure -text "A"  -font [list police1]
set policecourante [font actual police1]
puts $policecourante
}
}


# Ci-dessous, les cases  cocher qui vont me permettre d'appliquer les styles (gras, italique, soulign)  police1 dfinie plus haut

set casesacocher [frame .framepref.panneau1.panneaudescases]
radiobutton $casesacocher.gras -state normal -text Gras -variable preference -value bold -command {global policecourante; font configure police1 -weight bold; .framepref.panneau1.boutonfontes configure -text "A"  -font [list police1]; set policecourante [font actual police1]; puts $policecourante }
radiobutton $casesacocher.italique -state normal -text Italique -variable preference -value italic -command {global policecourante; font configure police1 -slant italic; .framepref.panneau1.boutonfontes configure -text "A"  -font [list police1]; set policecourante [font actual police1] }
radiobutton $casesacocher.souligne -state normal -text Souligne -variable preference -value underline -command {global policecourante; font configure police1 -underline 1; .framepref.panneau1.boutonfontes configure -text "A"  -font [list police1]; set policecourante [font actual police1] }


# ci-dessous, cration d'une tiquette de sparation

label .framepref.panneau1.separateur -width 10

# Cration du bouton tmoin (en fait, un label)
label .framepref.panneau1.boutonfontes -width 10 -bd 1 -text "A"


# Ci-dessous, les cases  cocher qui vont appliquer les variations de polices au reste de l'interface
# onvalue = si la case est coche, renvoie 1, offvalue, case dcoche, renvoie 0 au travers des variables $bouton, $menu, $champs et $etiquettes.
# On appelle la procdure "attributsinterface"   laquelle on passe pour arguments :
# - la variable y (de 0   3) qui permet de distinguer s'il s'agit des polices pour les boutons, menus ou autres.
# - la variable $bouton (ou $menu, $champs etc..) qui contient les valeurs 0 ou 1 selon que la case est coche (onvelue, 1) ou non (offvalue 0).

set attributs [frame .framepref.panneau3.frattributs -relief sunken]
set rien 0

checkbutton $attributs.case0 -height 2 -variable boutons -onvalue 1 -offvalue 0 -text "Appliquer aux boutons" -command {
set y 0; attributsinterface $y $boutons; remplichampsfontes}
checkbutton $attributs.case1 -height 2 -variable menus -onvalue 1 -offvalue 0 -text "Appliquer aux menus" -command {
set y 1; attributsinterface $y $menus; remplichampsfontes}
checkbutton $attributs.case2 -height 2 -variable champs -onvalue 1 -offvalue 0 -text "Appliquer aux champs" -command {
set y 2; attributsinterface $y $champs; remplichampsfontes}
checkbutton $attributs.case3 -height 2 -variable etiquettes -onvalue 1 -offvalue 0 -text "Appliquer aux tiquettes" -command {
set y 3; attributsinterface $y $etiquettes; remplichampsfontes}


# Ci-dessous ma fonction attributsinterface.
# Elle reoit les deux arguments vus plus haut.
# On va dans le rpertoire .eagleconnect.
# On affecte  la variable identifiant le contenu de la commande whoami (identifie l'utilisateur)
# Si le contenu de la variable y = 0, alors on sait que c'est la case des boutons qui l'a appele
# Si le contenu de la variable x = 1, alors on sait que la case est ici coche, et la fonction doit donc effectuer
# les instructions qui suivent.
# On affecte  a le contenu de la variable police1 (voir plus haut, celle qui contient les noms et attributs de la police)
# On ouvre en lecture et criture le fichier $identifiant.pref  (par exemple, emmanuel.pref) et on affecte son contenu  
# la variable lecture0pref.
# Si je n'ai pas atteint la fin du fichier lecture0pref, je me positionne au dbut dudit fichier (seek $lecture0pref 0 start)
# et j'affecte  la variable occur l'emplacement (la position du premier caractre) de la premire occurence "bouton" trouve dans le fichier
# $lecture0 si cette occurence existe. Sinon la commande string first renvoie -1 si occurence non trouve.
# Si l'occurence n'a pas t trouve (occur == -1), alors la fonction crit le contenu de la variable a (police1) dans le fichier $lectureOpref
# avec le terme bouton avant. (noton que nous avons ouvert emmanuel.pref en a+, c'est -- dire lecture criture avec ajout des nouvelles donnes
# et non crasement).
# Si l'occurence a t trouve (occur == position de la 1re occurence "bouton" dans le fichier), alors on se place  l'endroit exact de l'emplacement
# de l'occurence (seek $lecture0pref $occur) et on crit le nouveau contenu de la variable police1 dans le fichier (puts $lecture0pref "bouton'$a'")
# ENFIN, si $x == 0, alors cela signifie que la case est dcoche, et on fait rien d'autre qu'afficher un message : else "puts "rien  faire""




#bind .framepref.panneau1.listedesfontes <Enter> {
#set identifiant [exec whoami]
#
#.framepref.aide.texteintro configure -text "Parameters detected automatically by Eagleconnect have been saved into $identifiant.pref file.\n For allowing non root user to use EagleConnect, think to modify the /etc/sudoers file as root by clicking on 'Modify ...' button" 
#}
#
#bind .framepref.panneau1.listedesfontes <Leave> {
#
#.framepref.aide.texteintro configure -text "" 
#}





proc attributsinterface {y x} {

# ci-dessous, on recherche le login du simple utlisateur actif

#global login
#set login1 [exec who -u]
#puts $login1
#set rech2pts [string first " " $login1]
#set login [string range $login1 0 [expr {$rech2pts-1}]]
#puts /home/$login

cd ~/.eagleconnect

set identifiant [exec whoami]

puts $identifiant
if {$y == 0} {
	if {$x == 1} {
	puts $x
	set a [font actual police1]
        set lecture0pref [open $identifiant.pref a+];
        if { ![eof $lecture0pref] } {
        seek $lecture0pref 0 start
        set lecture0 [read $lecture0pref]
        set occur [string first "bouton" $lecture0]
        puts $occur
           if {$occur == -1} {  
               puts $lecture0pref "bouton $a"} else {  
               seek $lecture0pref $occur
               puts $lecture0pref "bouton $a"}
        }
        close $lecture0pref
	
        } else {puts "rien  faire"}}        
                
               

if {$y == 1} {
        if {$x == 1} {
	puts $x
	set b [font actual police1]
        set lecture1pref [open $identifiant.pref a+];
        if { ![eof $lecture1pref] } {
        seek $lecture1pref 0 start
        set lecture1 [read $lecture1pref]
        set occur1 [string first "menu" $lecture1]
        puts $occur1
           if {$occur1 == -1} {  
               puts $lecture1pref "menu $b"} else {  
               seek $lecture1pref $occur1
               puts $lecture1pref "menu $b"}
        }
        close $lecture1pref
	
        } else {puts "rien  faire"}}


if {$y == 2} {
        if {$x == 1} {
	puts $x
	set c [font actual police1]
        set lecture2pref [open $identifiant.pref a+];
        if { ![eof $lecture2pref] } {
        seek $lecture2pref 0 start
        set lecture2 [read $lecture2pref]
        set occur2 [string first "champ" $lecture2]
        puts $occur2
           if {$occur2 == -1} {  
               puts $lecture2pref "champ $c"} else {  
               seek $lecture2pref $occur2
               puts $lecture2pref "champ $c"}
        }
        close $lecture2pref
	
        } else {puts "rien  faire"}}



if {$y == 3} {
        if {$x == 1} {
	puts $x
	set d [font actual police1]
        set lecture3pref [open $identifiant.pref a+];
        if { ![eof $lecture3pref] } {
        seek $lecture3pref 0 start
        set lecture3 [read $lecture3pref]
        set occur3 [string first "etiq" $lecture3]
        puts $occur3
           if {$occur3 == -1} {  
               puts $lecture3pref "etiq $d"} else {  
               seek $lecture3pref $occur3
               puts $lecture3pref "etiq $d"}
        }
        close $lecture3pref
	
        } else {puts "rien  faire"}}

}



# ------------------------------------------------------------------------------------------------
#-----------------VISUALISATION DU FICHIER DE PREFERENCES----------------------------------------------
#-----------------------------------------------------------------------------------------------------


set framevisupref1 [frame .framepref.panneau3.frvisupref1 -relief sunken]

label $framevisupref1.labfont1 -text "Police des boutons :" -font [list Arial 10] -width 20;
entry $framevisupref1.entfont1 -background white -justify left -font [list Arial 12] \
 -textvariable essai \
 -width 28; \

set framevisupref2 [frame .framepref.panneau3.frvisupref2 -relief sunken]

label $framevisupref2.labfont2 -text "Police des menus :" -font [list Arial 10] -width 20;
entry $framevisupref2.entfont2 -background white -justify left -font [list Arial 12] \
 -textvariable essai1 \
 -width 28; \

set framevisupref3 [frame .framepref.panneau3.frvisupref3 -relief sunken]

label $framevisupref3.labfont3 -text "Police des champs :" -font [list Arial 10] -width 20;
entry $framevisupref3.entfont3 -background white -justify left -font [list Arial 12] \
 -textvariable essai2 \
 -width 28; \

set framevisupref4 [frame .framepref.panneau3.frvisupref4 -relief sunken]

label $framevisupref4.labfont4 -text "Police des tiquettes :" -font [list Arial 10] -width 20;
entry $framevisupref4.entfont4 -background white -justify left -font [list Arial 12] \
 -textvariable essai3 \
 -width 28; \



# Ci-dessous, je place les lements construits plus haut

pack .framepref.panneau1 -side left -fill y
pack .framepref.panneau2 -side left -fill y
pack .framepref.panneau3 -fill x -expand true 
pack .framepref.panneau1.listedesfontes -side left
pack .framepref.panneau1.barre1 -side left -fill y
pack .framepref.panneau1.listedestailles -side left
pack .framepref.panneau1.barre2 -side left -fill y
pack $casesacocher 
pack $casesacocher.gras $casesacocher.italique $casesacocher.souligne -anchor w

pack .framepref.panneau1.separateur
pack .framepref.panneau1.boutonfontes 

pack $attributs.case0 $attributs.case1 $attributs.case2 $attributs.case3 -anchor w

pack $framevisupref1.labfont1 -side left -anchor n
pack $framevisupref1.entfont1 
pack $framevisupref2.labfont2 -side left -anchor n
pack $framevisupref2.entfont2 -side right
pack $framevisupref3.labfont3 -side left -anchor n
pack $framevisupref3.entfont3 -side right
pack $framevisupref4.labfont4 -side left -anchor n
pack $framevisupref4.entfont4 -side right
pack $framevisupref1 $framevisupref2 $framevisupref3 $framevisupref4 

pack $attributs -side top

# procdure qui crit dans les champs les caleurs des polices contenues dans le fichier de prfrences

proc remplichampsfontes {} {

set identifiant [exec whoami]
cd ~/.eagleconnect

set prefread [open ~/.eagleconnect/$identifiant.pref r]; 
		while { ![eof $prefread] } {

		# Je lis ligne contenue dans la variable "journaleaglediagnormal"
		# et je l'affecte  la variable "lignelue"
		gets $prefread lignelue;
		
                # ci-dessous, je recherche la chaine ## dans chaque lignelue. Si prsent, alors linesfound vaut 1, sinon 0
		set chaine1 [regexp {(^bouton)} $lignelue]
		set chaine2 [regexp {(^menu)} $lignelue]
		set chaine3 [regexp {(^champ)} $lignelue]
		set chaine4 [regexp {(^etiq)} $lignelue]
		
		if {$chaine1 == 1} {
                .framepref.panneau3.frvisupref1.entfont1 delete 0 end
		.framepref.panneau3.frvisupref1.entfont1 insert end $lignelue}
		if {$chaine2 == 1} {
                .framepref.panneau3.frvisupref2.entfont2 delete 0 end 
		.framepref.panneau3.frvisupref2.entfont2 insert end $lignelue}
		if {$chaine3 == 1} {
                .framepref.panneau3.frvisupref3.entfont3 delete 0 end
                .framepref.panneau3.frvisupref3.entfont3 insert end $lignelue}
		if {$chaine4 == 1} {
                .framepref.panneau3.frvisupref4.entfont4 delete 0 end
                .framepref.panneau3.frvisupref4.entfont4 insert end $lignelue}}
}

remplichampsfontes;







set taillefenetre2 [winfo reqwidth .]
puts $taillefenetre2

#button .frame1.bouton3 -text "Sauver" -width 22 -command {exit;}
#pack configure .frame1.bouton3 -pady 2 -side left -padx 5

button .boutonprevious -width 20 -relief groove  -text [msgcat::mc "Previous"] -command {paramsystem}


button .boutonexit -width 20 -relief groove  -text [msgcat::mc "Exit"] -command {cd /tmp; foreach fichierstxt [glob -nocomplain -dir /tmp *.txt *.tcl~] {file delete $fichierstxt;}; exit}
pack .boutonexit .boutonprevious -side right -padx 100 -expand true

 
#-pady 0 -side left -padx 2

}









#-------------------------------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------------------
#----------------------------------------------FIN FENETRE PREFERENCES INTERFACE-----------------------------------------
#-------------------------------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------------------







#-----------------------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------------------------------
#------------------- RECHERCHE AUTOMATIQUE DE L'EMPLACEMENT DES EXECUTABLES------------------------------------------------
#-------------------------------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------------



proc recupereligne {recupligne x} {



if {$x == "a"} {
set w [string first "/" $recupligne]
global startadsl
set startadsl [string range $recupligne $w end]
puts $startadsl;
.frameutilisateurs.containerframes.frame2.champconnect delete 0 end
.frameutilisateurs.containerframes.frame2.champconnect insert 0 $startadsl

	set identifiant [exec whoami]
	set verifpresencefichier [file exists ~/.eagleconnect/$identifiant.pref]
	if {$verifpresencefichier > 0} {
		puts "le fichier existe"
		set preferences [open ~/.eagleconnect/$identifiant.pref a+]; 
		seek $preferences 0 start
		set prefread0 [read $preferences]
		set trv0 [string first "fctStartAdsl" $prefread0]
				if {$trv0 != -1} {puts "rien  faire"} else {puts $preferences $startadsl}
	close $preferences} else {
		puts "le fichier n'existe pas; cration du fichier des prfrences utilisateur";
		set preferences [open ~/.eagleconnect/$identifiant.pref w+]; 
		puts $preferences $startadsl
		close $preferences
				}
cherchechemin b;}

if {$x == "b"} {
set w [string first "/" $recupligne]
global stopadsl
set stopadsl [string range $recupligne $w end]
puts $stopadsl;
.frameutilisateurs.containerframes.frame4.champdeconnect delete 0 end
.frameutilisateurs.containerframes.frame4.champdeconnect insert 0 $stopadsl

	set identifiant [exec whoami]
	set verifpresencefichier [file exists ~/.eagleconnect/$identifiant.pref]
	if {$verifpresencefichier > 0} {
		set preferences [open ~/.eagleconnect/$identifiant.pref a+]; 
		seek $preferences 0 start
		set prefread1 [read $preferences]
		set trv1 [string first "fctStopAdsl" $prefread1]
				if {$trv1 != -1} {puts "rien  faire"} else {puts $preferences $stopadsl}
		close $preferences }
cherchechemin c;}

if {$x == "c"} {
set w [string first "/" $recupligne]
global eaglectrl
set eaglectrl [string range $recupligne $w end]
puts $eaglectrl;
.frameutilisateurs.containerframes.frame6.reinitialise delete 0 end
.frameutilisateurs.containerframes.frame6.reinitialise insert 0 $eaglectrl

	set identifiant [exec whoami]
	set verifpresencefichier [file exists ~/.eagleconnect/$identifiant.pref]
	if {$verifpresencefichier > 0} {
		set preferences [open ~/.eagleconnect/$identifiant.pref a+]; 
		seek $preferences 0 start
		set prefread2 [read $preferences]
		set trv2 [string first "eaglectrl" $prefread2]
			if {$trv2 != -1} {puts "rien  faire"} else {puts $preferences $eaglectrl}
	close $preferences}
cherchechemin d;}


if {$x == "d"} {
set w [string first "/" $recupligne]
global eaglestat
set eaglestat [string range $recupligne $w end]
puts $eaglestat;
.frameutilisateurs.containerframes.frame8.statistiques delete 0 end
.frameutilisateurs.containerframes.frame8.statistiques insert 0 $eaglestat

	set identifiant [exec whoami]
	set verifpresencefichier [file exists ~/.eagleconnect/$identifiant.pref]
	if {$verifpresencefichier > 0} {
		set preferences [open ~/.eagleconnect/$identifiant.pref a+]; 
		seek $preferences 0 start
		set prefread3 [read $preferences]
		set trv3 [string first "eaglestat" $prefread3]
			if {$trv3 != -1} {puts "rien  faire"} else {puts $preferences $eaglestat}
	close $preferences}
cherchechemin e;}

if {$x == "e"} {
set w [string first "/" $recupligne]
global eaglediag
set eaglediag [string range $recupligne $w end]
puts $eaglediag;
.frameutilisateurs.containerframes.frame10.diagnostic delete 0 end
.frameutilisateurs.containerframes.frame10.diagnostic insert 0 $eaglediag

	set identifiant [exec whoami]
	set verifpresencefichier [file exists ~/.eagleconnect/$identifiant.pref]
	if {$verifpresencefichier > 0} {
		set preferences [open ~/.eagleconnect/$identifiant.pref a+]; 
		seek $preferences 0 start
		set prefread4 [read $preferences]
		set trv4 [string first "eaglediag" $prefread4]
			if {$trv4 != -1} {puts "rien  faire"} else {puts $preferences $eaglediag; tk_messageBox -message "File created successfully. Please select Fonts for EagleConnect in Preferences Interface"}
	close $preferences}
.frameutilisateurs.contienttout.selectutilisateur delete 0 end; 
foreach utilisateur [lsort [glob -nocomplain *.*]] {
.frameutilisateurs.contienttout.selectutilisateur insert end $utilisateur}
}
}



proc lirechemin {x} {

set contenuchemin [open /tmp/chemin.txt r];
  if { ![eof $contenuchemin] } {
    global lignelue1
    gets $contenuchemin lignelue1;
    global recupligne1;
    set recupligne1 $lignelue1
  }

set chainetrouvee [string first "/" $recupligne1]
puts $chainetrouvee
if {$chainetrouvee == -1} {
toplevel .chainenontrouvee
wm title .chainenontrouvee "Attention !"
wm geometry .chainenontrouvee 600x150+200+200
label .chainenontrouvee.message -text "The command couldn't be find.\n Please install eagleusb driver and its utilities before" -font [list Arial 14] -height 2
button .chainenontrouvee.valider -text "OK" -width 10 -command {exit;}
pack .chainenontrouvee.message -pady 12
pack .chainenontrouvee.valider -pady 12
}
recupereligne $recupligne1 $x

}



proc cherchechemin {y} {

if {$y == "a"} {
file delete /tmp/chemin.txt; exec whereis fctStartAdsl >> /tmp/chemin.txt
lirechemin a
}
if {$y == "b"} {
file delete /tmp/chemin.txt; exec whereis fctStopAdsl >> /tmp/chemin.txt
lirechemin b
}
if {$y == "c"} {
file delete /tmp/chemin.txt; exec whereis eaglectrl >> /tmp/chemin.txt
lirechemin c
}
if {$y == "d"} {
file delete /tmp/chemin.txt; exec whereis eaglestat >> /tmp/chemin.txt
lirechemin d
}
if {$y == "e"} {
file delete /tmp/chemin.txt; exec whereis eaglediag >> /tmp/chemin.txt
lirechemin e
}

}




#--------------------------------Cration d'une tiquette----------------------------------------------------------------

# Je cre ici une tiquette non visible dans frame3 afin de bien sparer les 2 boutons 

#label .frame1.etiquette -width 80
#pack configure .frame1.etiquette -pady 0 -side left -padx 5



#button .frame1.bouton3 -width 20 -relief groove  -text [msgcat::mc "Exit"] -command {exit}
#pack configure .frame1.bouton3 -pady 0 -side right -padx 2






#-------------------------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------------------------------
#-----------------------------------------------------LANCEMENT DE L'INTERFACE--------------------------------------------
#-------------------------------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------------------


paramsystem


#--------------------------------------------------------------------------------------------------------------------------
#-----------------------------------VERIFICATION EXISTENCE FICHIER ROOT.PREF-------------------------------------------------
#-------------------------------------------------------------------------------------------------------------------------

# ci-dessous, on recherche le login du simple utlisateur actif

#global login
#set login1 [exec who -u]
#puts $login1
#set rech2pts [string first " " $login1]
#set login [string range $login1 0 [expr {$rech2pts-1}]]
#puts /home/$login

set identifiant2 [exec whoami]
set verifpresencefichier [file exists ~/.eagleconnect/$identifiant2.pref]

if {$verifpresencefichier > 0} {puts "le fichier existe";

 } else {tk_messageBox -message [msgcat::mc "Eagleconnect configuration file hasn't been created yet"]}

#ci -dessus, je vrifie d'abord la prsence du fichier simpleuser.pref dans le rpertoire .eagleconnect.
#S'il existe , la commande "file exists" renvoie 1, sinon 0. Cette valeur, 1 ou 0
# est rcupre dans la variable $verifpresencefichier. Si $verifpresencefichier > 0, alors, 
#cela signifie que le fichier existe








