.\" dpkg manual page - start-stop-daemon(8)
.\"
.\" Copyright © 1999 Klee Dienes <klee@mit.edu>
.\" Copyright © 1999 Ben Collins <bcollins@debian.org>
.\" Copyright © 2000-2001 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2002-2003 Adam Heath <doogie@debian.org>
.\" Copyright © 2004 Scott James Remnant <keybuk@debian.org>
.\" Copyright © 2008-2016, 2018 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH start\-stop\-daemon 8 %RELEASE_DATE% %VERSION% "suite dpkg"
.nh
.SH NOM
start\-stop\-daemon \- Lance ou arrête des démons système
.
.SH SYNOPSIS
\fBstart\-stop\-daemon\fP [\fIoption\fP...] \fIcommande\fP
.
.SH DESCRIPTION
On se sert de \fBstart\-stop\-daemon\fP pour contrôler la création ou l'arrêt de
processus système. En utilisant les options correspondantes,
\fBstart\-stop\-daemon\fP peut être configuré pour trouver les exemplaires
présents d'un processus en fonctionnement.
.PP
Veuillez noter qu'à moins d'utiliser \fB\-\-pid\fP ou \fB\-\-pidfile\fP, le programme
\fBstart\-stop\-daemon\fP se comporte comme \fBkillall\fP(1). \fBstart\-stop\-daemon\fP
recherche dans le tableau des processus tout processus qui correspond au
nom, pid parent, uid et/ou gid du processus (si indiqué). Toute
correspondance empêchera \fB\-\-start\fP de démarrer le démon. Tous les processus
qui correspondent recevront le signal TERM (ou le signal indiqué par
\fB\-\-signal\fP ou \fB\-\-retry\fP) si \fB\-\-stop\fP est indiqué. Pour les démons avec
des processus enfant qui doivent survivre à un \fB\-\-stop\fP, il est nécessaire
d'indiquer un fichier pid («\ pidfile\ »).
.
.SH COMMANDES
.TP 
\fB\-S\fP, \fB\-\-start\fP [\fB\-\-\fP] \fIparamètres\fP
Vérifier l'existence d'un processus particulier. Quand il existe un tel
processus, \fBstart\-stop\-daemon\fP ne fait rien et se termine avec un code
d'erreur égal à \fB1\fP (\fB0\fP si \fB\-\-oknodo\fP est précisé). Quand un tel
processus n'existe pas, un exemplaire de l'exécutable est lancé, en
utilisant le paramètre de \fB\-\-exec\fP ou celui de \fB\-\-startas\fP si cette option
est précisée. Tout argument donné après \fB\-\-\fP sur la ligne de commande est
passé tel quel au programme qui doit être lancé.
.TP 
\fB\-K\fP, \fB\-\-stop\fP
Vérifier aussi l'existence d'un processus particulier. Quand un tel
processus existe, \fBstart\-stop\-daemon\fP lui envoie le signal précisé avec
\fB\-\-signal\fP et se termine avec un code d'erreur égal à \fB0\fP. Quand un tel
processus n'existe pas, \fBstart\-stop\-daemon\fP se termine avec un code
d'erreur égal à \fB1\fP (\fB0\fP si \fB\-\-oknodo\fP est précisé). Si \fB\-\-retry\fP est
indiquée, \fBstart\-stop\-daemon\fP recherche si le processus ou les processus se
sont bien terminés.
.TP 
\fB\-T\fP, \fB\-\-status\fP
Contrôle l'existence du processus indiqué et sort avec un code de sortie
défini par les actions des scripts d'initialisation de la LSB («\ LSB Init
Script Actions\ » –\ depuis la version\ 1.16.1).
.TP 
\fB\-H\fP, \fB\-\-help\fP
Affiche un message d'aide, puis quitte.
.TP 
\fB\-V\fP, \fB\-\-version\fP
Affiche la version du programme, puis quitte.
.
.SH OPTIONS
.SS "Options de correspondance"
.TP 
[\fB\-\-pid\fP] \fIpid\fP
Vérifie l'existence d'un processus avec le \fIpid\fP spécifié (depuis la
version\ 1.17.6). Le \fIpid\fP doit avoir un numéro supérieur à\ 0.
.TP 
[\fB\-\-ppid\fP] \fIpid parent\fP
Vérifie l'existence d'un processus avec le pid parent \fIpid\-parent\fP spécifié
(depuis la version\ 1.17.7). Le \fIpid\-parent\fP doit avoir un numéro supérieur
à\ 0.
.TP 
\fB\-p\fP, \fB\-\-pidfile\fP \fIfichier\-pid\fP
Cherche les processus dont les identifiants sont précisés dans
\fIfichier\-pid\fP.
.IP
Note\ : l'utilisation de l'option de correspondance seule peut provoquer des
actions sur des processus non prévus, si l'ancien processus s'est terminé
sans savoir retiré le \fIfichier\-pid\fP.
.IP
\fBWarning:\fP using this match option with a world\-writable pidfile or using
it alone with a daemon that writes the pidfile as an unprivileged (non\-root)
user will be refused with an error (since version 1.19.3) as this is a
security risk, because either any user can write to it, or if the daemon
gets compromised, the contents of the pidfile cannot be trusted, and then a
privileged runner (such as an init script executed as root) would end up
acting on any system process.  Using \fI/dev/null\fP is exempt from these
checks.
.TP 
\fB\-x\fP, \fB\-\-exec\fP \fIexécutable\fP
Contrôle l'existence de processus qui soient des exemplaires de cet
\fIexécutable\fP. Le paramètre \fIexécutable\fP doit être un chemin absolu. Note\ :
cela peut ne pas fonctionner avec des scripts interprétés, car l'exécutable
sera alors l'interpréteur. Des processus en exécution au sein d'un
environnement fermé d'exécution («\ chroot\ ») seront également trouvés et il
peut donc être nécessaire d'ajouter d'autres restrictions de correspondance.
.TP 
\fB\-n\fP, \fB\-\-name\fP \fInom\-de\-processus\fP
Contrôle l'existence de processus avec \fInom\-de\-processus\fP comme nom. Le
\fInom\-de\-processus\fP est en général le nom du fichier du processus, mais peut
avoir été modifié par le processus lui\-même. Note\ : sur la plupart des
systèmes, cette information est récupérée par le nom de communication du
noyau, ce qui induit une limite de longueur assez courte (la portabilité
impose de ne pas supposer plus de 15\ caractères).
.TP 
\fB\-u\fP, \fB\-\-user\fP \fIidentifiant\fP|\fIuid\fP
Contrôle l'existence de processus dont le propriétaire est \fIidentifiant\fP ou
\fIuid\fP. Note\ : si cette option est utilisée seule, tous les processus de cet
utilisateur seront concernés par l'action.
.
.SS "Options génériques"
.TP 
\fB\-g\fP, \fB\-\-group\fP \fIgroupe\fP|\fIgid\fP
Modifie le \fIgroupe\fP ou le \fIgid\fP au début du processus.
.TP 
\fB\-s\fP, \fB\-\-signal\fP \fIsignal\fP
L'action \fB\-\-stop\fP définit le signal à envoyer au processus qui doit être
arrêté (par défaut\ : TERM).
.TP 
\fB\-R\fP, \fB\-\-retry\fP \fIdurée\fP|\fIaction\-prévue\fP
Avec l'action \fB\-\-stop\fP, \fBstart\-stop\-daemon\fP doit vérifier que les
processus se sont terminés. Il le fait pour tous les processus
correspondants qui tournent, jusqu'à ce qu'il n'y en ait plus. Quand le
processus ne se termine pas, il prend d'autres mesures déterminées par
l'\fIaction\-prévue\fP.

Si \fIdurée\fP est indiquée plutôt que \fIaction\-prévue\fP, l'action\-prévue
\fIsignal\fP\fB/\fP\fIdurée\fP\fB/KILL/\fP\fIdurée\fP est utilisée, où \fIsignal\fP est le
signal indiqué par \fB\-\-signal\fP.

\fIaction\-prévue\fP est une liste d'au moins deux items séparés par des barres
obliques (\fB/\fP)\ ; chaque item peut être de la forme \fB\-\fP\fInuméro\-signal\fP ou
de la forme [\fB\-\fP]\fInom\-signal\fP, ce qui demande d'envoyer ce signal\ ; ou
bien de la forme \fIdurée,\fP ce qui demande d'attendre tant de secondes avant
de terminer les processus, ou bien de la forme \fBforever\fP, ce qui demande de
répéter constamment le reste de action\-prévue, si nécessaire.

Quand la fin de l'action\-prévue est atteinte et que \fBforever\fP n'a pas été
précisé, \fBstart\-stop\-daemon\fP se termine avec un code d'erreur égal à
\fB2\fP. Quand une action\-prévue est indiquée, tout signal donné par
\fB\-\-signal\fP est ignoré.
.TP 
\fI\-a\fP, \fB\-\-startas\fP \fInom\-de\-chemin\fP
Avec l'action \fB\-\-start\fP, lance le processus spécifié par
\fInom\-de\-chemin\fP. Si rien n'est précisé, c'est par défaut l'argument donné à
\fB\-\-exec\fP.
.TP 
\fB\-t\fP, \fB\-\-test\fP
Affiche les actions qui seraient entreprises et détermine la bonne valeur de
retour, mais ne fait rien.
.TP 
\fB\-o\fP, \fB\-\-oknodo\fP
Retourne un code de sortie égal à \fB0\fP au lieu de \fB1\fP si rien n'est ou ne
sera fait.
.TP 
\fB\-q\fP, \fB\-\-quiet\fP
N'affiche pas de messages d'information\ ; affiche seulement les messages
d'erreur.
.TP 
\fB\-c\fP, \fB\-\-chuid\fP \fIidentifiant\fP|\fIuid\fP[\fB:\fP\fIgroupe\fP|\fIgid\fP]
Change pour cet utilisateur ou «\ uid\ » avant de lancer le processus. On peut
aussi préciser un groupe en ajoutant un \fB:\fP, puis le groupe ou un «\ gid\ »
de la même façon qu'avec la commande \fBchown\fP(1)
(\fIutilisateur\fP\fB:\fP\fIgroupe\fP). Lorsqu'un utilisateur est indiqué mais pas de
groupe alors le groupe primaire de celui\-ci est utilisé. Quand on utilise
cette option, on doit veiller à ce que les groupes primaires ainsi que les
groupes secondaires existent bien, même si l'option \fB\-\-group\fP n'est pas
spécifiée. L'option \fB\-\-group\fP sert seulement pour les groupes dont
l'utilisateur n'est pas membre (c'est comme rendre membre d'un
groupe\-pour\-processus des utilisateurs génériques comme \fBnobody\fP).
.TP 
\fB\-r\fP, \fB\-\-chroot\fP \fIroot\fP
Change de répertoire racine pour \fBroot\fP avant de lancer le
processus. Remarquez que le «\ pidfile\ » est aussi écrit après le changement
de racine.
.TP 
\fB\-d\fP, \fB\-\-chdir\fP \fIchemin\fP
Change de répertoire pour \fIchemin\fP avant de commencer le processus. Cela
est fait après le changement de répertoire racine si l'option
\fB\-r\fP|\fB\-\-chroot\fP est demandée. Si rien n'est demandé, \fBstart\-stop\-daemon\fP
changera de répertoire pour le répertoire racine avant de commencer le
processus.
.TP 
\fB\-b\fP, \fB\-\-background\fP
Utilisé généralement pour les programmes qui ne «\ se détachent\ » pas
d'eux\-mêmes. Cette option oblige \fBstart\-stop\-daemon\fP à se dupliquer (fork)
avant de lancer le processus, et l'oblige à passer en
arrière\-plan. \fBAVERTISSEMENT\ : start\-stop\-daemon\fP ne peut pas vérifier le
code de sortie quand, pour \fBune raison ou une autre\fP, le processus
échoue. C'est un expédient dont on se servira seulement pour des programmes
dont la duplication n'a pas de sens ou bien des programmes dont le code
n'est pas adaptable pour leur ajouter cette fonctionnalité.
.TP 
\fB\-\-notify\-await\fP
Wait for the background process to send a readiness notification before
considering the service started (since version 1.19.3).  This implements
parts of the systemd readiness procotol, as specified in the \fBsd_notify\fP(3)
man page.  The following variables are supported:
.RS
.TP 
\fBREADY=1\fP
The program is ready to give service, so we can exit safely.
.TP 
\fBEXTEND_TIMEOUT_USEC=\fP\fInumber\fP
The program requests to extend the timeout by \fInumber\fP microseconds.  This
will reset the current timeout to the specified value.
.TP 
\fBERRNO=\fP\fInumber\fP
The program is exiting with an error.  Do the same and print the
user\-friendly string for the \fBerrno\fP value.
.RE
.
.TP 
\fB\-\-notify\-timeout\fP\fItimeout\fP
Set a timeout for the \fB\-\-notify\-await\fP option (since version 1.19.3).  When
the timeout is reached, \fBstart\-stop\-daemon\fP will exit with an error code,
and no readiness notification will be awaited.  The default is \fB60\fP
seconds.
.TP 
\fB\-C\fP, \fB\-\-no\-close\fP
Ne fermer aucun descripteur de fichiers en forçant le démon à s'exécuter en
arrière\-plan (depuis la version\ 1.16.5). Utilisé à des fins de débogage afin
de voir ce qu'affiche le processus ou pour rediriger les descripteurs de
fichiers pour journaliser l'affichage du processus. N'est pertinent que lors
de l'utilisation de \fB\-\-background\fP.
.TP 
\fB\-N\fP, \fB\-\-nicelevel\fP \fIint\fP
Cela modifie la priorité du processus avant qu'il ne soit lancé.
.TP 
\fB\-P\fP, \fB\-\-procsched\fP \fIpolitique\fP\fB:\fP\fIpriorité\fP
Modifie la politique du programmateur de processus («\ process scheduler
policy\ ») et la priorité du processus avant de le démarrer (depuis la
version\ 1.15.0). La priorité peut être indiquée de manière facultative avec
\fB:\fP suivi de la valeur souhaitée. La \fIpriorité\fP par défaut est\ 0. Les
valeurs de politiques actuellement gérées sont \fBother\fP, \fBfifo\fP et \fBrr\fP.
.TP 
\fB\-I\fP, \fB\-\-iosched\fP \fIclasse\fP\fB:\fP\fIpriorité\fP
Modifie la classe du programmateur d'entrée/sortie («\ IO scheduler\ ») et la
priorité du processus avant de le démarrer (depuis la version\ 1.15.0). La
priorité peut être indiquée de manière facultative avec \fB:\fP suivi de la
valeur souhaitée. La \fIpriorité\fP par défaut est\ 4, sauf si \fIclasse\fP est
\fBidle\fP, auquel cas \fIpriorité\fP sera toujours égale à\ 7. Les valeurs de
\fIclasse\fP actuellement gérées sont \fBidle\fP, \fBbest\-effort\fP et \fBreal\-time\fP.
.TP 
\fB\-k\fP, \fB\-\-umask\fP \fImasque\fP
Cela modifie le masque utilisateur du processus avant qu'il ne soit lancé
(depuis la version\ 1.13.22).
.TP 
\fB\-m\fP, \fB\-\-make\-pidfile\fP
Utilisé lors du lancement d'un programme qui ne crée pas son propre fichier
identificateur «\ pid\ ». Cette option indique à \fBstart\-stop\-daemon\fP de créer
le fichier référencé par \fB\-\-pidfile\fP et placer le «\ pid\ » dans ce fichier
juste avant d'exécuter le processus. Il faut remarquer que ce fichier ne
sera supprimé quand le programme s'arrête que si \fB\-\-remove\-pidfile\fP est
utilisé. \fBNOTE\ :\fP il se peut que cette caractéristique ne marche pas dans
tous les cas. Notamment quand le programme qui est exécuté se duplique. À
cause de cela, cette option n'est habituellement utile que combinée avec
l'option \fB\-\-background\fP.
.TP 
\fB\-\-remove\-pidfile\fP
Utilisé lors de l'arrêt d'un programme qui ne supprime pas lui\-même son
fichier identificateur «\ pid\ » (depuis la version\ 1.17.19). Cette option
indique à \fBstart\-stop\-daemon\fP de supprimer le fichier référencé par
\fB\-\-pid\-file\fP après l'arrêt du processus.
.TP 
\fB\-v\fP, \fB\-\-verbose\fP
Affiche des messages prolixes en renseignements.
.
.SH "CODE DE SORTIE"
.TP 
\fB0\fP
L'action demandée a été effectuée. Si \fB\-\-oknodo\fP était indiqué, il est
également possible que rien ne se soit passé. Cela peut se produire si
\fB\-\-start\fP était indiqué et qu'un processus correspondant était déjà en
train de s'exécuter ou si \fB\-\-stop\fP était indiqué et qu'aucun processus ne
correspondait.
.TP 
\fB1\fP
Si \fB\-\-oknodo\fP n'était pas indiqué et que rien ne s'est passé.
.TP 
\fB2\fP
Si \fB\-\-stop\fP et \fB\-\-retry\fP étaient indiqués mais que la fin de la
planification a été atteinte et que les processus étaient toujours en cours
d'exécution.
.TP 
\fB3\fP
Toute autre erreur.
.PP
Lorsque la commande \fB\-\-status\fP est utilisée, les codes d'état suivants sont
renvoyés\ :
.TP 
\fB0\fP
Le programme est en cours d'exécution.
.TP 
\fB1\fP
Le programme n'est pas en cours d'exécution et le fichier PID existe.
.TP 
\fB3\fP
Le programme n'est pas en cours d'exécution.
.TP 
\fB4\fP
Impossible de déterminer l'état du programme.
.
.SH EXEMPLE
Démarre le démon \fBfood\fP, à moins qu'il soit déjà en cours d'exécution (un
processus nommé \fBfood\fP, tournant sous le nom d'utilisateur \fBfood\fP, avec un
pid dans food.pid)\ :
.IP
.nf
start\-stop\-daemon \-\-start \-\-oknodo \-\-user food \-\-name food \e
	\-\-pidfile /run/food.pid \-\-startas /usr/sbin/food \e
	\-\-chuid food \-\- \-\-daemon
.fi
.PP
Envoie le signal \fBSIGTERM\fP à \fBfood\fP et attend durant 5\ secondes son
arrêt\ :
.IP
.nf
start\-stop\-daemon \-\-stop \-\-oknodo \-\-user food \-\-name food \e
	\-\-pidfile /run/food.pid \-\-retry 5
.fi
.PP
Démonstration d'un ordonnanceur personnalisé pour l'arrêt de \fBfood\fP\ :
.IP
.nf
start\-stop\-daemon \-\-stop \-\-oknodo \-\-user food \-\-name food \e
	\-\-pidfile /run/food.pid \-\-retry=TERM/30/KILL/5
.fi
.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
