// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

#nullable enable

using System.Collections.Generic;
using FluentAssertions;
using Newtonsoft.Json;
using NuGet.Protocol.Model;
using Xunit;

namespace NuGet.Protocol.Tests.Converters
{
    public class VulnerabilityFileDataConverterTests
    {
        [Fact]
        public void Deserialize_DataWithPackage_ResultIsCaseInsensitive()
        {
            // Arrange
            string json = @"{
  ""packageid"": []
}";

            // Act
            var result = JsonConvert.DeserializeObject<CaseInsensitiveDictionary<IReadOnlyList<PackageVulnerabilityInfo>>>(json);

            // Assert
            result.Should().NotBeNull();
            result!.ContainsKey("packageid").Should().BeTrue();
            result.ContainsKey("PackageID").Should().BeTrue();
        }
    }
}
