/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.Controller;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.tree.AttributeCollection;
import com.nwalsh.saxon.Callout;
import com.nwalsh.saxon.CopyEmitter;
import com.nwalsh.saxon.FormatCallout;
import java.util.Arrays;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;

public class CalloutEmitter
extends CopyEmitter {
    protected Stack elementStack = new Stack();
    protected Stack tempStack = null;
    protected boolean firstElement = true;
    protected static String foURI = "http://www.w3.org/1999/XSL/Format";
    protected static String xhURI = "http://www.w3.org/1999/xhtml";
    protected int defaultColumn = 60;
    protected boolean foStylesheet = false;
    private static int lineNumber = 0;
    private static int colNumber = 0;
    private static Callout[] callout = null;
    private static int calloutCount = 0;
    private static int calloutPos = 0;
    private static FormatCallout fCallout = null;

    public CalloutEmitter(Controller controller, NamePool namePool, int defaultColumn, boolean foStylesheet, FormatCallout fCallout) {
        super(controller, namePool);
        this.defaultColumn = defaultColumn;
        this.foStylesheet = foStylesheet;
        CalloutEmitter.fCallout = fCallout;
    }

    public void setupCallouts(NodeList areaspecNodeList) {
        callout = new Callout[10];
        calloutCount = 0;
        calloutPos = 0;
        lineNumber = 1;
        colNumber = 1;
        boolean pos = false;
        int coNum = 0;
        boolean inAreaSet = false;
        Node areaspec = areaspecNodeList.item(0);
        NodeList children = areaspec.getChildNodes();
        int count = 0;
        while (count < children.getLength()) {
            Node node = children.item(count);
            if (node.getNodeType() == 1) {
                if (node.getNodeName().equalsIgnoreCase("areaset")) {
                    ++coNum;
                    NodeList areas = node.getChildNodes();
                    int acount = 0;
                    while (acount < areas.getLength()) {
                        Node area = areas.item(acount);
                        if (area.getNodeType() == 1) {
                            if (area.getNodeName().equalsIgnoreCase("area")) {
                                this.addCallout(coNum, area, this.defaultColumn);
                            } else {
                                System.out.println("Unexpected element in areaset: " + area.getNodeName());
                            }
                        }
                        ++acount;
                    }
                } else if (node.getNodeName().equalsIgnoreCase("area")) {
                    this.addCallout(++coNum, node, this.defaultColumn);
                } else {
                    System.out.println("Unexpected element in areaspec: " + node.getNodeName());
                }
            }
            ++count;
        }
        Arrays.sort(callout, 0, calloutCount);
    }

    public void characters(char[] chars, int start, int len) throws TransformerException {
        this.firstElement = false;
        if (lineNumber == 0) {
            ++lineNumber;
            colNumber = 1;
        }
        char[] newChars = new char[len];
        int pos = 0;
        int count = start;
        while (count < start + len) {
            if (calloutPos < calloutCount && callout[calloutPos].getLine() == lineNumber && callout[calloutPos].getColumn() == colNumber) {
                if (pos > 0) {
                    this.rtfEmitter.characters(newChars, 0, pos);
                    pos = 0;
                }
                this.closeOpenElements(this.rtfEmitter);
                while (calloutPos < calloutCount && callout[calloutPos].getLine() == lineNumber && callout[calloutPos].getColumn() == colNumber) {
                    fCallout.formatCallout(this.rtfEmitter, callout[calloutPos]);
                    ++calloutPos;
                }
                this.openClosedElements(this.rtfEmitter);
            }
            if (chars[count] == '\n') {
                if (calloutPos < calloutCount && callout[calloutPos].getLine() == lineNumber && callout[calloutPos].getColumn() > colNumber) {
                    if (pos > 0) {
                        this.rtfEmitter.characters(newChars, 0, pos);
                        pos = 0;
                    }
                    this.closeOpenElements(this.rtfEmitter);
                    while (calloutPos < calloutCount && callout[calloutPos].getLine() == lineNumber && callout[calloutPos].getColumn() > colNumber) {
                        this.formatPad(callout[calloutPos].getColumn() - colNumber);
                        colNumber = callout[calloutPos].getColumn();
                        while (calloutPos < calloutCount && callout[calloutPos].getLine() == lineNumber && callout[calloutPos].getColumn() == colNumber) {
                            fCallout.formatCallout(this.rtfEmitter, callout[calloutPos]);
                            ++calloutPos;
                        }
                    }
                    this.openClosedElements(this.rtfEmitter);
                }
                ++lineNumber;
                colNumber = 1;
            } else {
                ++colNumber;
            }
            newChars[pos++] = chars[count];
            ++count;
        }
        if (pos > 0) {
            this.rtfEmitter.characters(newChars, 0, pos);
        }
    }

    protected void formatPad(int numBlanks) {
        char[] chars = new char[numBlanks];
        int count = 0;
        while (count < numBlanks) {
            chars[count] = 32;
            ++count;
        }
        try {
            this.rtfEmitter.characters(chars, 0, numBlanks);
        }
        catch (TransformerException e) {
            System.out.println("Transformer Exception in formatPad");
        }
    }

    protected void addCallout(int coNum, Node node, int defaultColumn) {
        Element area = (Element)node;
        String units = null;
        String coords = null;
        if (area.hasAttribute("units")) {
            units = area.getAttribute("units");
        }
        if (area.hasAttribute("coords")) {
            coords = area.getAttribute("coords");
        }
        if (units != null && !units.equalsIgnoreCase("linecolumn") && !units.equalsIgnoreCase("linerange")) {
            System.out.println("Only linecolumn and linerange units are supported");
            return;
        }
        if (coords == null) {
            System.out.println("Coords must be specified");
            return;
        }
        StringTokenizer st = new StringTokenizer(coords);
        int tokenCount = 0;
        int c1 = 0;
        int c2 = 0;
        while (st.hasMoreTokens()) {
            if (++tokenCount > 2) {
                System.out.println("Unparseable coordinates");
                return;
            }
            try {
                int coord;
                String token = st.nextToken();
                c2 = coord = Integer.parseInt(token);
                if (tokenCount != 1) continue;
                c1 = coord;
            }
            catch (NumberFormatException e) {
                System.out.println("Unparseable coordinate");
                return;
            }
        }
        if (calloutCount == callout.length) {
            Callout[] bigger = new Callout[calloutCount + 10];
            int count = 0;
            while (count < callout.length) {
                bigger[count] = callout[count];
                ++count;
            }
            callout = bigger;
        }
        if (tokenCount == 2) {
            if (units != null && units.equalsIgnoreCase("linerange")) {
                int count = c1;
                while (count <= c2) {
                    CalloutEmitter.callout[CalloutEmitter.calloutCount++] = new Callout(coNum, area, count, defaultColumn);
                    ++count;
                }
            } else {
                CalloutEmitter.callout[CalloutEmitter.calloutCount++] = new Callout(coNum, area, c1, c2);
            }
        } else {
            CalloutEmitter.callout[CalloutEmitter.calloutCount++] = new Callout(coNum, area, c1, defaultColumn);
        }
    }

    public void endElement(int nameCode) throws TransformerException {
        if (!this.elementStack.empty()) {
            this.elementStack.pop();
        }
        this.rtfEmitter.endElement(nameCode);
    }

    public void startElement(int nameCode, Attributes attributes, int[] namespaces, int nscount) throws TransformerException {
        if (!this.skipThisElement(nameCode)) {
            StartElementInfo sei = new StartElementInfo(nameCode, attributes, namespaces, nscount);
            this.elementStack.push(sei);
        }
        this.firstElement = false;
        this.rtfEmitter.startElement(nameCode, attributes, namespaces, nscount);
    }

    protected boolean skipThisElement(int nameCode) {
        if (this.firstElement) {
            int thisFingerprint = this.namePool.getFingerprint(nameCode);
            int foBlockFingerprint = this.namePool.getFingerprint(foURI, "block");
            int htmlPreFingerprint = this.namePool.getFingerprint("", "pre");
            int htmlDivFingerprint = this.namePool.getFingerprint("", "div");
            int xhtmlPreFingerprint = this.namePool.getFingerprint(xhURI, "pre");
            int xhtmlDivFingerprint = this.namePool.getFingerprint(xhURI, "div");
            if (this.foStylesheet && thisFingerprint == foBlockFingerprint || !this.foStylesheet && (thisFingerprint == htmlPreFingerprint || thisFingerprint == htmlDivFingerprint || thisFingerprint == xhtmlPreFingerprint || thisFingerprint == xhtmlDivFingerprint)) {
                return true;
            }
        }
        return false;
    }

    private void closeOpenElements(Emitter rtfEmitter) throws TransformerException {
        this.tempStack = new Stack();
        while (!this.elementStack.empty()) {
            StartElementInfo elem = (StartElementInfo)this.elementStack.pop();
            rtfEmitter.endElement(elem.getNameCode());
            this.tempStack.push(elem);
        }
    }

    private void openClosedElements(Emitter rtfEmitter) throws TransformerException {
        while (!this.tempStack.empty()) {
            StartElementInfo elem = (StartElementInfo)this.tempStack.pop();
            AttributeCollection attr = (AttributeCollection)elem.getAttributes();
            AttributeCollection newAttr = new AttributeCollection(this.namePool);
            int acount = 0;
            while (acount < attr.getLength()) {
                String localName = attr.getLocalName(acount);
                int nameCode = attr.getNameCode(acount);
                String type = attr.getType(acount);
                String value = attr.getValue(acount);
                String uri = attr.getURI(acount);
                String prefix = "";
                if (localName.indexOf(58) > 0) {
                    prefix = localName.substring(0, localName.indexOf(58));
                    localName = localName.substring(localName.indexOf(58) + 1);
                }
                if (!(uri.equals("") && (this.foStylesheet && localName.equals("id") || !this.foStylesheet && (localName.equals("id") || localName.equals("name"))))) {
                    newAttr.addAttribute(prefix, uri, localName, type, value);
                }
                ++acount;
            }
            rtfEmitter.startElement(elem.getNameCode(), (Attributes)newAttr, elem.getNamespaces(), elem.getNSCount());
            this.elementStack.push(elem);
        }
    }

    private class StartElementInfo {
        private int _nameCode;
        Attributes _attributes;
        int[] _namespaces;
        int _nscount;

        public StartElementInfo(int nameCode, Attributes attributes, int[] namespaces, int nscount) {
            this._nameCode = nameCode;
            this._attributes = attributes;
            this._namespaces = namespaces;
            this._nscount = nscount;
        }

        public int getNameCode() {
            return this._nameCode;
        }

        public Attributes getAttributes() {
            return this._attributes;
        }

        public int[] getNamespaces() {
            return this._namespaces;
        }

        public int getNSCount() {
            return this._nscount;
        }
    }
}

