# vim: set fileencoding=utf-8 :

import unittest
import os
from dogtail.procedural import *
import shutil
import subprocess
import filecmp

class GuiTestCase(unittest.TestCase):
    def setUp(self):
        # Switch the language to ensure the correct widget labels
        os.putenv("LANG", "C")
        # Copy the xorg.conf to a temporary file
        shutil.copy("tests/data/lenovo_t60_glatzor_feisty_default.conf",
                    "/tmp/displayconfig-unittest.conf")
        # Start the displayconfig-gtk util
        command = ["./displayconfig-gtk", "--no-instant-apply",
                   "--xconfig", "/tmp/displayconfig-unittest.conf",
                   "--pcitable", "tests/data/lenovo_t60_glatzor.pci",
                   "--data-dir", "./data",
                   "--locations-config", "tests/data/locations.conf"]
        self.pid = subprocess.Popen(command).pid
        sleep(1)

    def tearDown(self):
        """Clean up the test setup"""
        os.remove("/tmp/displayconfig-unittest.conf")
        os.kill(self.pid, 9)

    def testChangeScreenModel(self):
        """Choose a different monitor model"""
        focus.application('displayconfig-gtk')
        focus.frame('Screen and Graphics Preferences')
        click("Plug 'n' Play", roleName='push button')
        focus.window('Choose Screen')
        select('Flat Panel 1024x768', roleName='table cell')
        keyCombo("Return")
        click('OK', roleName='push button')
        #self.assert_(filecmp.cmp(self.tempfile,
        #             "tests/references/gui_change_screen"))

    def testChangeResolution(self):
        """Choose a higher resolution"""
        focus.application('displayconfig-gtk')
        focus.frame('Screen and Graphics Preferences')
        click('1024×768', roleName='combo box', raw=True)
        click('800×600', roleName='menu item')
        click('OK', roleName='push button')
        #self.assert_(filecmp.cmp(self.tempfile,
        #             "tests/references/gui_change_resolution"))

    def testSetupDualHead(self):
        """Setup a dual screen configuration"""
        focus.application('displayconfig-gtk')
        focus.frame('Screen and Graphics Preferences')
        activate('Screen 2', roleName='table cell')
        keyCombo("Return")
        click("Unknown", roleName='push button')
        focus.window('Choose Screen')
        select('Flat Panel 1280x1024', roleName='table cell')
        keyCombo("Return")
        click('640×480', roleName='combo box', raw=True)
        click('1280×1024', roleName='menu item')
        click('Secondary screen', roleName='radio button')
        click('To the Right', roleName='combo box', raw=True)
        click('To the Left', roleName='menu item')
        click('OK', roleName='push button')
        #self.assert_(filecmp.cmp(self.tempfile,
        #             "tests/references/gui_dual_head.conf"))

    def testSwitchLocation(self):
        """Switch location"""
        focus.application('displayconfig-gtk')
        focus.frame('Screen and Graphics Preferences')
        click('locations', roleName='combo box', raw=True)
        click('At home', roleName='menu item')
        click('OK', roleName='push button')
        #self.assert_(filecmp.cmp(self.tempfile,
        #             "tests/references/gui_switch_location.conf"))
