/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2009-05-22
 * Description : a control widget for the AdvancedRename utility
 *
 * Copyright (C) 2009 by Andi Clemens <andi dot clemens at gmx dot net>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef ADVANCEDRENAMEWIDGET_H
#define ADVANCEDRENAMEWIDGET_H

// Qt includes

#include <QtCore/QString>
#include <QtGui/QWidget>

namespace Digikam
{

class AdvancedRenameWidgetPriv;
class ParseSettings;
class Parser;

class AdvancedRenameWidget : public QWidget
{
    Q_OBJECT

public:

    AdvancedRenameWidget(QWidget* parent = 0);
    ~AdvancedRenameWidget();

    enum ControlWidget
    {
        None               = 0x0,
        ToolTipButton      = 0x1,
        TokenButtons       = 0x2,
        ModifierToolButton = 0x4,
        DefaultControls    = TokenButtons | ToolTipButton | ModifierToolButton
    };
    Q_DECLARE_FLAGS(ControlWidgets, ControlWidget)

    QString text() const;
    void    setText(const QString& text);
    void    clearText();

    /*
     * clear the text as well as the history
     */
    void    clear();

    void    setParser(Parser* parser);
    Parser* parser();

    QString parse(ParseSettings& settings) const;

    void setControlWidgets(ControlWidgets mask);

    void setTooltipAlignment(Qt::Alignment alignment);
    void focusLineEdit();

Q_SIGNALS:

    void signalTextChanged(const QString&);
    void signalReturnPressed();

public Q_SLOTS:

    void slotUpdateTrackerPos();
    void slotHideToolTipTracker();

private Q_SLOTS:

    void slotToolTipButtonToggled(bool);
    void slotTokenMarked(bool);

private:

    void createToolTip();
    void registerParserControls();
    void setupWidgets();

    void readSettings();
    void writeSettings();

private:

    AdvancedRenameWidgetPriv* const d;
};

}  // namespace Digikam

Q_DECLARE_OPERATORS_FOR_FLAGS(Digikam::AdvancedRenameWidget::ControlWidgets)

#endif /* ADVANCEDRENAMEWIDGET_H */
