#!/usr/bin/perl
use warnings;
use strict;
use File::Temp qw( tempdir );

my $dir = tempdir( CLEANUP => 1 );

sub fake_log($$)
{
    my ($dir,$ver) = @_;
    my $log = "$dir/changelog";

    open(LOG,">$log") || die "$log: $!\n";
    print LOG "testing ($ver) unstable; urgency=low\n";
    print LOG "\n";
    print LOG "  * Testing\n";
    print LOG "\n";
    print LOG " -- Tester <tester\@example.com>  Thu, 25 Jan 2007 10:38:41 -0800\n";
    close(LOG);

    return $log;
}

sub read_log_ver($)
{
    my ($log) = @_;

    open(LOG,"<$log") || die "$log: $!\n";
    my $line = <LOG>;
    close(LOG);

    if ($line =~ /^\S+ \(([^\)]+)\) \S+; urgency=low/) {
        return $1;
    }
    die "Corrupted changelog $log:\n$line\n";
}


my %versions = (
    '12' => '12ubuntu1',
    '3.4' => '3.4ubuntu1',
    '3.4.5' => '3.4.5ubuntu1',
    '5.6-7' => '5.6-7ubuntu1',
    '5.6-7.1' => '5.6-7.1ubuntu1',
    '5.6-7.1.8' => '5.6-7.1.8ubuntu1',
    '2.13-14build5' => '2.13-14build6',
    '0.45-2ubuntu3' => '0.45-2ubuntu4',
    '0.45-2ubuntu3.1' => '0.45-2ubuntu3.2',
    '0.45-2ubuntu3.1.0' => '0.45-2ubuntu3.1.1',
    '1.2-3ubuntu0.1~prop1' => '1.2-3ubuntu0.1~prop2',
    '1.2-3ubuntu0.1~proposed1' => '1.2-3ubuntu0.1~proposed2',
);

my $fail=0;
my $ran=0;
foreach my $ver (sort keys %versions) {
    $ran++;

    my $log = fake_log($dir,$ver);
    system("../scripts/debchange.pl -c $log -i testing");
    my $check = read_log_ver($log);
    
    if ($check ne $versions{$ver}) {
        $fail++;
        warn "After incrementing $ver got $check (expecting $versions{$ver})\n";
    }
}

print "All version increment tests passed\n" if ($fail==0);
printf("%d/%d version increment tests FAILED!\n",$fail,$ran) if ($fail>0);
 
exit($fail);
