# Copyright 2009-2010 Canonical Ltd.
#
# This file is part of desktopcouch-contacts.
#
#  desktopcouch is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# as published by the Free Software Foundation.
#
# desktopcouch is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with desktopcouch.  If not, see <http://www.gnu.org/licenses/>.
#
# Authors: Eric Casteleijn <eric.casteleijn@canonical.com>
#          Nicola Larosa <nicola.larosa@canonical.com>
#          Mark G. Saye <mark.saye@canonical.com>
#          Vincenzo Di Somma <vincenzo.di.somma@canonical.com>

"""A dictionary based contact record representation."""

from desktopcouch.records import Record, RecordField

CONTACT_RECORD_TYPE = \
    'http://www.freedesktop.org/wiki/Specifications/desktopcouch/contact'


class Contact(Record):
    """Contact records."""

    first_name = RecordField('first_name')
    middle_name = RecordField('middle_name')
    last_name = RecordField('last_name')
    title = RecordField('title')
    suffix = RecordField('suffix')
    birth_date = RecordField('birth_date')
    nick_name = RecordField('nick_name')
    spouse_name = RecordField('spouse_name')
    wedding_date = RecordField('wedding_date')
    company = RecordField('company')
    department = RecordField('department')
    job_title = RecordField('job_title')
    manager_name = RecordField('manager_name')
    assistant_name = RecordField('assistant_name')
    office = RecordField('office')
    addresses = RecordField('addresses')
    phone_numbers = RecordField('phone_numbers')
    email_addresses = RecordField('email_addresses')
    urls = RecordField('urls')
    im_addresses = RecordField('im_addresses')

    def __init__(self, data=None, record_id=None):
        super(Contact, self).__init__(
            record_id=record_id, data=data, record_type=CONTACT_RECORD_TYPE)
