"""Tests for Desktop CouchDB"""

import os, tempfile, atexit, shutil
from desktopcouch.stop_local_couchdb import stop_couchdb

def stop_test_couch():
    from desktopcouch.start_local_couchdb import read_pidfile
    pid = read_pidfile()
    stop_couchdb(pid=pid)
    shutil.rmtree(basedir)

atexit.register(stop_test_couch)

basedir = tempfile.mkdtemp()
if not os.path.exists(basedir):
    os.mkdir(basedir)

xdg_cache = os.path.join(basedir, 'xdg_cache')
if not os.path.exists(xdg_cache):
    os.mkdir(xdg_cache)

xdg_data = os.path.join(basedir, 'xdg_data')
if not os.path.exists(xdg_data):
    os.mkdir(xdg_data)

xdg_config = os.path.join(basedir, 'xdg_config')
if not os.path.exists(xdg_config):
    os.mkdir(xdg_config)

# Add etc folder to config
SOURCE_TREE_ETC_FOLDER = os.path.realpath(
  os.path.join(os.path.split(__file__)[0], "..", "..", "config")
)
if os.path.isdir(SOURCE_TREE_ETC_FOLDER):
    os.environ["XDG_CONFIG_DIRS"] = SOURCE_TREE_ETC_FOLDER

os.environ['XDG_CACHE_HOME'] = xdg_cache
os.environ['XDG_DATA_HOME'] = xdg_data
os.environ['XDG_CONFIG_HOME'] = xdg_config
os.environ['XDG_DATA_DIRS'] = ''

# Force reload packages, so that the correct dekstopcouch will be
# started.
import xdg.BaseDirectory
reload(xdg.BaseDirectory)
from desktopcouch import local_files
reload(local_files)
