/**
 * csoundplayback.cpp
 *
 * CSound playback functions, 
 * runs csound with -g -W flags (creates wav file)
 * for Denemo, a GTK Frontend to GNU Lilypond
 *
 * (c) 2002-2005 Adam Tee 
 */

#include "csoundplayback.h"
#include "exportcsound.h"
#include "prefops.h"
#include "utils.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#ifdef HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif
#ifdef HAVE_WAIT_H
#include <wait.h>
#endif
#include <errno.h>

/**
 * Local function prototypes
 */
void selorcfile (GtkWidget * widget, gpointer data);
void chooseorcfile (GtkWidget * widget, struct cs_callback *data);

/**
 * CSound playback to set the csound argument and 
 * orchestra file to use
 */

void
csoundplayback (GtkAction * action, scoreinfo *si)
{
  pid_t pid;
  static GString *filename;
  static GString *outputfile;
  static GString *passtosystem;
  
  filename = g_string_new (NULL);
  outputfile = g_string_new (NULL);
  passtosystem = g_string_new (NULL);
  
  gboolean playoutput = si->prefs->rtcs; //gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (si->prefs->rtcs));
  printf("\nplayoutput = %i\n", playoutput);  
      
      g_string_assign (filename,locatedotdenemo ());
      g_string_append (filename, "/denemocsoundplayback");
      if (!playoutput)
	      g_string_assign (outputfile, "devaudio");
      else
	{
	  	g_string_assign(outputfile,locatedotdenemo ());
		g_string_append (outputfile, "/denemocsoundplayback.wav");
	} 

 


#ifdef G_OS_WIN32
  pid = -1;
#else
  pid = fork ();
#endif

  if (pid == -1)
    {
      fprintf (stderr, "%s: Failed to fork()\n", strerror (errno));
      return;
    }
  else if (pid == 0)
    {
      int status = 0;
      exportcsound (filename->str, si, si->start, si->end);

      g_string_assign (passtosystem, si->prefs->csoundcommand->str);
      g_string_append (passtosystem, " ");
      g_string_append (passtosystem, " -o ");
      g_string_append (passtosystem, outputfile->str);
      if (playoutput) 
      	g_string_append (passtosystem, " -W");
      
      g_string_append (passtosystem, " ");
      g_string_append (passtosystem, si->prefs->csoundorcfile->str);
      g_string_append (passtosystem, " ");
      g_string_append (passtosystem, filename->str);
      
      status = system (passtosystem->str);
	printf("\npass to system = %s\n", passtosystem->str);	
      if (!status & playoutput)
	{

	  g_string_assign (passtosystem, si->prefs->audioplayer->str);
	  g_string_append (passtosystem, " ");
	  g_string_append (passtosystem, outputfile->str);

	  system (passtosystem->str);
	  printf("\npass to system = %s\n", passtosystem->str);
	}
	
      _exit (0);
    }

}

/**
 * Select the csound orchestra to use during playback
 */
void
chooseorcfile (GtkWidget * widget, struct cs_callback *data)
{
  GtkWidget *fs;
  GtkFileFilter *filter;
  scoreinfo *si = data->si;
  GtkWidget *entry =  data->entry;
  	
  
  fs = gtk_file_chooser_dialog_new (_("Choose CSound Orchestra File"),
						GTK_WINDOW(data->dialog),
						GTK_FILE_CHOOSER_ACTION_OPEN,
						GTK_STOCK_CANCEL,
						GTK_RESPONSE_REJECT,
						GTK_STOCK_OPEN,
						GTK_RESPONSE_ACCEPT, NULL);

  filter = gtk_file_filter_new ();
  gtk_file_filter_set_name (filter,	"CSound Orchestra File");
  gtk_file_filter_add_pattern (filter, "*.orc");
  gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (fs), filter);
  
  gtk_widget_show_all(fs);
  if (gtk_dialog_run (GTK_DIALOG (fs)) == GTK_RESPONSE_ACCEPT)
    {
     	g_string_assign(si->prefs->csoundorcfile,gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (fs)));
			gtk_entry_set_text(GTK_ENTRY(entry), si->prefs->csoundorcfile->str);
      
    }
  gtk_widget_destroy (fs);
}
