/* staffops.cpp
 * functions dealing with whole staffs

 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999, 2000, 2001, 2002 Matthew Hiller */

#include "chordops.h"
#include "contexts.h"
#include <denemo/denemo.h>
#include "dialogs.h"
#include "measureops.h"
#include "moveviewport.h"
#include "objops.h"
#include "processstaffname.h"
#include "staffops.h"
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

objnode *
firstobjnode (measurenode * mnode)
{
  return (objnode *) mnode->data;
}

objnode *
lastobjnode (measurenode * mnode)
{
  return g_list_last ((objnode *) mnode->data);
}

measurenode *
firstmeasurenode (staffnode * thestaff)
{
  return ((staff *) thestaff->data)->measures;
}

measurenode *
nth_measure_node_in_staff (staffnode * thestaff, gint n)
{
  return g_list_nth (((staff *) thestaff->data)->measures, n);
}

objnode *
firstobjnodeinstaff (staffnode * thestaff)
{
  return firstobjnode (firstmeasurenode (thestaff));
}

/* Reset si->currentprimarystaff based on current value of
 * si->currentstaff */

void
setcurrentprimarystaff (struct scoreinfo *si)
{
  for (si->currentprimarystaff = si->currentstaff;
       ((staff *) si->currentprimarystaff->data)->voicenumber != 1;
       si->currentprimarystaff = si->currentprimarystaff->prev)
    ;
}

static void
copy_staff_bits (staff * src, staff * dest)
{
  dest->sclef = src->sclef;
  dest->skey = src->skey;
  dest->skey_isminor = src->skey_isminor;
  memcpy (dest->skeyaccs, src->skeyaccs, SEVENGINTS);
  dest->stime1 = src->stime1;
  dest->stime2 = src->stime2;
  dest->no_of_lines = 5;
  dest->transposition = 0;
  dest->pos_in_half_lines = 0;
  dest->space_above = 0;
  dest->space_below = 0;
}



void
newstaff (struct scoreinfo *si, enum newstaffcallbackaction action)
{
  g_assert(si != NULL);
  /* What gets added */
  staff *thestaffstruct = (staff *) g_malloc (sizeof (staff));
  struct newstaffinfotopass itp;
  measurenode *themeasures = NULL;	/* Initial set of measures in staff */
  gint numstaffs = g_list_length (si->thescore);
  gint i, n, addat = 1;
  if (si->lily_file)
    return;		     /* no code for this yet - just edit textually */
  if (numstaffs == 0)
    {
      action = INITIAL;
      n = 1;

      thestaffstruct->sclef = DENEMO_TREBLE_CLEF;
      thestaffstruct->skey = 0;
      thestaffstruct->skey_isminor = FALSE;
      memset (thestaffstruct->skeyaccs, 0, SEVENGINTS);
      thestaffstruct->stime1 = 4;
      thestaffstruct->stime2 = 4;

      thestaffstruct->no_of_lines = 5;
      thestaffstruct->transposition = 0;
      thestaffstruct->pos_in_half_lines = 0;
      thestaffstruct->space_above = 0;
      thestaffstruct->space_below = 0;
      thestaffstruct->volume = 128; 
      si->measurewidths = g_list_append (si->measurewidths,
					 GINT_TO_POINTER (si->measurewidth));
    }
  else
    {
      n = g_list_length (firstmeasurenode (si->currentstaff));
      copy_staff_bits ((staff *) si->currentstaff->data, thestaffstruct);
    };

  if (action == NEWVOICE)
    {
      thestaffstruct->voicenumber = 2;
    }
  else if (action == LYRICSTAFF)
    {
      thestaffstruct->voicenumber = 3;
    }
  else if (action == FIGURESTAFF)
    {
      thestaffstruct->voicenumber = 3;	/* what does this mean? */
    }
  else
    {
      thestaffstruct->voicenumber = 1;
    };

  for (i = 0; i < n; i++)
    {
      themeasures = g_list_append (themeasures, NULL);
    };

  if (action == INITIAL || action == ADDFROMLOAD)
    {
      si->currentmeasure = themeasures;
    };

  /* Now fix the stuff that shouldn't be directly copied from
   * the current staff, if this staff was non-initial and that
   * was done to begin with */

  thestaffstruct->measures = themeasures;
  thestaffstruct->denemo_name = g_string_new (NULL);
  thestaffstruct->lily_name = g_string_new (NULL);
  if (action == NEWVOICE)
    /* Fix me to something more reasonable and less prone to collision
     * with other staff names */
    g_string_sprintf (thestaffstruct->denemo_name, _("non primary voice"));
  else if (action == LYRICSTAFF)
    g_string_sprintf (thestaffstruct->denemo_name, _("lyrics"));
  else if (action == FIGURESTAFF)
    g_string_sprintf (thestaffstruct->denemo_name, _("figures"));
  else
    g_string_sprintf (thestaffstruct->denemo_name, _("voice %d"),
		      numstaffs + 1);
  set_lily_name (thestaffstruct->denemo_name, thestaffstruct->lily_name);

  thestaffstruct->midi_instrument = g_string_new ("acoustic grand");

  /* In what position should the scrollbar be added?  */
  switch (action)
    {
    case INITIAL:
    case LAST:
    case ADDFROMLOAD:
      addat = numstaffs + 1;
      break;
    case BEFORE:
      addat = si->currentstaffnum;
      si->currentstaffnum++;
      break;
    case AFTER:
    case NEWVOICE:
    case LYRICSTAFF:
    case FIGURESTAFF:
      addat = si->currentstaffnum + 1;
      break;
    case FIRST:
      addat = 1;
      si->currentstaffnum++;
      break;
    }

  si->thescore = g_list_insert (si->thescore, thestaffstruct, addat - 1);
  si->currentstaff = g_list_nth (si->thescore, si->currentstaffnum - 1);
  setcurrentprimarystaff (si);
  find_leftmost_staffcontext (thestaffstruct, si);
  
  itp.si = si;
  itp.addat = addat;
  if (action != INITIAL && action != ADDFROMLOAD)
    {
	if (staff_properties_change (NULL, &itp)) {
	  // FIXME: If staff_properties_change returns false, 
	  // then the staff should probably be removed
	    set_bottom_staff (si);
	    if (action == BEFORE || action == FIRST) {
		move_viewport_down (si);
	    } else {
		update_vscrollbar (si);
	    }
	    gtk_widget_draw (si->scorearea, NULL);
	}
	else
	{
	    removestaff (si, -1, -1);
	}
    }
}

void
removestaff (struct scoreinfo *si, gint pos, gint numstaffs)
{
  /* The second and third parameters are mostly ignored in this version
   * of the function */
  staff *curstaffstruct = (staff *) (si->currentstaff ?
				     si->currentstaff->data : NULL);
  if (curstaffstruct)
    {
      gboolean isprimary = ((int) curstaffstruct->voicenumber == 1) ?
	TRUE : FALSE;
      if (si->lily_file != NULL)    
	/* if a lily file, then the objects are freed
	   with the lily tree */
	g_list_foreach (curstaffstruct->measures, freeobjlist, NULL);
      g_list_free (curstaffstruct->measures);
      g_string_free (curstaffstruct->denemo_name, FALSE);
      g_string_free (curstaffstruct->lily_name, FALSE);
      g_string_free (curstaffstruct->midi_instrument, FALSE);
      if (si->lily_file)
	{
	  curstaffstruct->measures = NULL;	
	  /* don't free the structure as a lily file references it */
	}
      else
	g_free (curstaffstruct);
      si->thescore = g_list_remove_link (si->thescore, si->currentstaff);
      g_list_free_1 (si->currentstaff);
      if (pos == gint (g_list_length (si->thescore)))
	{
	  si->currentstaffnum--;
	};
      si->currentstaff = g_list_nth (si->thescore, si->currentstaffnum - 1);

      if (si->currentstaff)
	{
	  /* O.K.; set si->currentprimarystaff correctly */
	  if (isprimary)
	    {
	      ((staff *) si->currentstaff->data)->voicenumber = 1;
	      si->currentprimarystaff = si->currentstaff;
	    }
	  else
	    {
	      setcurrentprimarystaff (si);
	    };
	}
      else
	{
	  si->currentprimarystaff = NULL;
	}
    }

}

void
beamsandstemdirswholestaff (staff * thestaff)
{
  measurenode *curmeasure;
  gint nclef, time1, time2, stem_directive;

  nclef = thestaff->sclef;
  time1 = thestaff->stime1;
  time2 = thestaff->stime2;
  stem_directive = DENEMO_STEMBOTH;

  for (curmeasure = thestaff->measures; curmeasure;
       curmeasure = curmeasure->next)
    {
      calculatebeamsandstemdirs ((objnode *) curmeasure->data, &nclef, &time1,
				 &time2, &stem_directive);
    }
}

void
showwhichaccidentalswholestaff (staff * thestaff)
{
  gint feed[7];
  gint feednum;
  measurenode *curmeasure;

  memcpy (feed, thestaff->skeyaccs, SEVENGINTS);
  feednum = thestaff->skey;
  for (curmeasure = thestaff->measures; curmeasure;
       curmeasure = curmeasure->next)
    feednum =
      showwhichaccidentals ((objnode *) curmeasure->data, feednum, feed);
}

void
fixnoteheights (staff * thestaff)
{
  gint nclef = thestaff->sclef;
  gint time1 = thestaff->stime1;
  gint time2 = thestaff->stime2;
  gint initialclef;
  measurenode *curmeasure;
  objnode *curobj;
  mudelaobject *theobj;

  for (curmeasure = thestaff->measures; curmeasure;
       curmeasure = curmeasure->next)
    {
      initialclef = nclef;
      for (curobj = (objnode *) curmeasure->data; curobj;
	   curobj = curobj->next)
	{
	  theobj = (mudelaobject *) curobj->data;
	  switch (theobj->type)
	    {
	    case CHORD:
	      newclefify (theobj, nclef);
	      break;
	    case TIMESIG:
	      time1 = ((timesig *) theobj->object)->time1;
	      time2 = ((timesig *) theobj->object)->time2;
	      break;
	    case CLEF:
	      nclef = ((clef *) theobj->object)->type;
	      break;
	    default:
	      break;
	    }
	}			/* End for */
    }				/* End for */
  beamsandstemdirswholestaff (thestaff);
}
void
newstaffinitial(GtkAction *action, struct scoreinfo *si)
{
  newstaff(si, INITIAL);
}

void newstaffbefore(GtkAction *action, struct scoreinfo *si)
{
  newstaff(si, BEFORE);
}

void newstaffafter(GtkAction *action, struct scoreinfo *si)
{
  newstaff(si, AFTER);
}


void
newstafflast(GtkAction *action, struct scoreinfo *si)
{
  newstaff(si, LAST);
}

void newstaffvoice(GtkAction *action, struct scoreinfo *si)
{
  newstaff(si, NEWVOICE);
}

void newstafflyric(GtkAction *action, struct scoreinfo *si)
{
  newstaff(si, LYRICSTAFF);
}

void newstafffigured(GtkAction *action, struct scoreinfo *si)
{
  newstaff(si, FIGURESTAFF);
}
