/* kbd-custom.h
   Header files for customizing keyboard configuration
   
   For Denemo, the GNU graphical music notation package
   (c) 2000, 2001 Olivier Vermersch, Matthew Hiller */

#ifndef KBD_CUSTOM_H
#define KBD_CUSTOM_H

#include <stdio.h>
#include <limits.h>
#include <gdk/gdk.h>
#include <denemo/denemo.h>

#define MASK_FILTER(state) state & (GDK_SHIFT_MASK | GDK_CONTROL_MASK \
				    | GDK_MOD1_MASK)

struct name_and_function
{
  gchar *name;
  GtkFunction function;
};

struct name_action_and_function
{
  gchar *name;
  gint callback_action;
  union func_union func;
};

extern struct name_action_and_function *denemo_commands;

extern gint denemo_commands_size;

extern GtkItemFactoryEntry menu_items[];

extern gint n_menu_items;

void
configure_keyboard (gpointer callback_data, guint callback_action,
		    GtkWidget *widget);

struct keymap *
init_keymap ();

void
clear_keymap (struct keymap *the_keymap);

struct keybinding_info *
lookup_keybinding (struct keymap *the_keymap, gint keyval, gint state);

void
remove_keybinding (struct keymap *the_keymap, gint keyval, gint state);

gint
add_keybinding (struct keymap *the_keymap, gint keyval, gint state,
		gint command_number);

void
load_keymap_dialog (GtkWidget *Widget, struct keymap *the_keymap);

void
load_standard_keymap_file_wrapper (GtkWidget *widget,
				   struct keymap *the_keymap);

void
load_standard_keymap_file (struct keymap *the_keymap);

gboolean
load_keymap_file (gchar *filename, struct keymap *the_keymap);

void
save_keymap_dialog (GtkWidget *widget, struct keymap *the_keymap);

void
save_standard_keymap_file_wrapper (GtkWidget *widget,
				   struct keymap *the_keymap);

void
save_standard_keymap_file (struct keymap *the_keymap);

void
save_keymap_file (gchar *filename, struct keymap *the_keymap);


#endif
