/* dialogs.h
 * header files for callbacks that create dialog boxes prompting the
 * user for further action

 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 2000, 2001 Matthew Hiller */

#ifndef __DIALOGS_H__
#define __DIALOGS_H__

#include <gtk/gtk.h>

enum actiontype
{ CHANGEINITIAL, INSERT };

void clef_change_initial(GtkAction *action, gpointer data);
void clef_change_insert(GtkAction *action, gpointer data);

void key_change_initial(GtkAction *action, gpointer data);
void key_change_insert(GtkAction *action, gpointer data);

void timesig_change_initial(GtkAction *action, gpointer data);
void timesig_change_insert(GtkAction *action, gpointer data);

void
clef_change (struct scoreinfo *si, enum actiontype action);

void
key_change (struct scoreinfo *si, enum actiontype action);

void
timesig_change (struct scoreinfo *si, enum actiontype action);

void
score_mwidth_change (GtkAction *action, gpointer callback_data);

void
score_staffspace_change (GtkAction *action, gpointer callback_data);




gboolean
staff_properties_change (GtkAction *action, gpointer callback_data);

//void
//new_score (gpointer callback_data, guint callback_action, 
//GtkWidget * widget);

void
playback_properties_change (GtkAction *action, gpointer callback_data);

void
playback (GtkAction *action, gpointer callback_data);

void
tomeasurenum (GtkAction *action, gpointer callback_data);

void
preferences_change (GtkAction *action,gpointer callback_data);

void
header_change (GtkAction *action, gpointer callbackdata);
         
#endif /* __DIALOGS_H__ */
