/* Assistant.c generated by valac 0.12.1, the Vala compiler
 * generated from Assistant.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <widgets.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define TYPE_ASSISTANT (assistant_get_type ())
#define ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT, Assistant))
#define ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT, AssistantClass))
#define IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT))
#define IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT))
#define ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT, AssistantClass))

typedef struct _Assistant Assistant;
typedef struct _AssistantClass AssistantClass;
typedef struct _AssistantPrivate AssistantPrivate;

#define ASSISTANT_TYPE_PAGE_INFO (assistant_page_info_get_type ())
#define ASSISTANT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfo))
#define ASSISTANT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))
#define ASSISTANT_IS_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_IS_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))

typedef struct _AssistantPageInfo AssistantPageInfo;
typedef struct _AssistantPageInfoClass AssistantPageInfoClass;

#define ASSISTANT_TYPE_TYPE (assistant_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__assistant_page_info_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__assistant_page_info_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AssistantPageInfoPrivate AssistantPageInfoPrivate;
typedef struct _Block1Data Block1Data;
#define _assistant_page_info_unref0(var) ((var == NULL) ? NULL : (var = (assistant_page_info_unref (var), NULL)))
typedef struct _AssistantParamSpecPageInfo AssistantParamSpecPageInfo;

struct _Assistant {
	GtkWindow parent_instance;
	AssistantPrivate * priv;
	GtkImage* header_icon;
	GtkEventBox* page_box;
	GList* current;
};

struct _AssistantClass {
	GtkWindowClass parent_class;
};

struct _AssistantPrivate {
	gchar* _apply_text;
	gboolean _last_op_was_back;
	GtkLabel* header_title;
	GtkButtonBox* button_box;
	GtkWidget* back_button;
	GtkWidget* forward_button;
	GtkWidget* cancel_button;
	GtkWidget* close_button;
	GtkWidget* resume_button;
	GtkWidget* apply_button;
	gboolean interrupt_can_continue;
	gboolean interrupted_from_hidden;
	GList* interrupted;
	GList* infos;
	GtkRequisition page_box_req;
};

typedef enum  {
	ASSISTANT_TYPE_NORMAL,
	ASSISTANT_TYPE_INTERRUPT,
	ASSISTANT_TYPE_SUMMARY,
	ASSISTANT_TYPE_PROGRESS,
	ASSISTANT_TYPE_FINISH
} AssistantType;

struct _AssistantPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AssistantPageInfoPrivate * priv;
	GtkWidget* page;
	gchar* title;
	AssistantType type;
};

struct _AssistantPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (AssistantPageInfo *self);
};

struct _Block1Data {
	int _ref_count_;
	Assistant * self;
	gint response;
};

struct _AssistantParamSpecPageInfo {
	GParamSpec parent_instance;
};


static gpointer assistant_parent_class = NULL;
static gpointer assistant_page_info_parent_class = NULL;

GType assistant_get_type (void) G_GNUC_CONST;
static gpointer assistant_page_info_ref (gpointer instance);
static void assistant_page_info_unref (gpointer instance);
static GParamSpec* assistant_param_spec_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void assistant_value_set_page_info (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void assistant_value_take_page_info (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer assistant_value_get_page_info (const GValue* value) G_GNUC_UNUSED;
static GType assistant_page_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define ASSISTANT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ASSISTANT, AssistantPrivate))
enum  {
	ASSISTANT_DUMMY_PROPERTY,
	ASSISTANT_APPLY_TEXT,
	ASSISTANT_LAST_OP_WAS_BACK
};
GType assistant_type_get_type (void) G_GNUC_CONST;
static void _assistant_page_info_unref0_ (gpointer var);
static void _g_list_free__assistant_page_info_unref0_ (GList* self);
#define ASSISTANT_APPLY 1
#define ASSISTANT_BACK 2
#define ASSISTANT_FORWARD 3
#define ASSISTANT_CANCEL 4
#define ASSISTANT_CLOSE 5
#define ASSISTANT_RESUME 6
void assistant_allow_forward (Assistant* self, gboolean allow);
void assistant_set_header_icon (Assistant* self, const gchar* name);
static void assistant_handle_response (Assistant* self, gint resp);
void assistant_go_back (Assistant* self);
void assistant_go_forward (Assistant* self);
void assistant_hide_for_now (Assistant* self);
gboolean assistant_is_interrupted (Assistant* self);
void assistant_skip (Assistant* self);
gboolean assistant_get_last_op_was_back (Assistant* self);
static void assistant_set_last_op_was_back (Assistant* self, gboolean value);
static void assistant_page_changed (Assistant* self);
void assistant_go_to_page (Assistant* self, GtkWidget* page);
void assistant_interrupt (Assistant* self, GtkWidget* page, gboolean can_continue);
static void assistant_use_title (Assistant* self, AssistantPageInfo* info);
static void assistant_set_buttons (Assistant* self);
static void assistant_reset_size (Assistant* self, GtkWidget* page);
static GtkButton* assistant_add_button (Assistant* self, const gchar* stock, gint response);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void _lambda0_ (Block1Data* _data1_);
static void __lambda0__gtk_button_clicked (GtkButton* _sender, gpointer self);
const gchar* assistant_get_apply_text (Assistant* self);
static gboolean assistant_set_first_page (Assistant* self);
void assistant_append_page (Assistant* self, GtkWidget* page, AssistantType type);
static AssistantPageInfo* assistant_page_info_new (void);
static AssistantPageInfo* assistant_page_info_construct (GType object_type);
static gboolean _assistant_set_first_page_gsource_func (gpointer self);
void assistant_set_page_title (Assistant* self, GtkWidget* page, const gchar* title);
Assistant* assistant_construct (GType object_type);
void assistant_set_apply_text (Assistant* self, const gchar* value);
static GObject * assistant_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _assistant_handle_response_assistant_response (Assistant* _sender, gint response, gpointer self);
enum  {
	ASSISTANT_PAGE_INFO_DUMMY_PROPERTY
};
static void assistant_page_info_finalize (AssistantPageInfo* obj);
static void assistant_finalize (GObject* obj);
static void _vala_assistant_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_assistant_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType assistant_type_get_type (void) {
	static volatile gsize assistant_type_type_id__volatile = 0;
	if (g_once_init_enter (&assistant_type_type_id__volatile)) {
		static const GEnumValue values[] = {{ASSISTANT_TYPE_NORMAL, "ASSISTANT_TYPE_NORMAL", "normal"}, {ASSISTANT_TYPE_INTERRUPT, "ASSISTANT_TYPE_INTERRUPT", "interrupt"}, {ASSISTANT_TYPE_SUMMARY, "ASSISTANT_TYPE_SUMMARY", "summary"}, {ASSISTANT_TYPE_PROGRESS, "ASSISTANT_TYPE_PROGRESS", "progress"}, {ASSISTANT_TYPE_FINISH, "ASSISTANT_TYPE_FINISH", "finish"}, {0, NULL, NULL}};
		GType assistant_type_type_id;
		assistant_type_type_id = g_enum_register_static ("AssistantType", values);
		g_once_init_leave (&assistant_type_type_id__volatile, assistant_type_type_id);
	}
	return assistant_type_type_id__volatile;
}


static void _assistant_page_info_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (assistant_page_info_unref (var), NULL));
}


static void _g_list_free__assistant_page_info_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _assistant_page_info_unref0_, NULL);
	g_list_free (self);
}


void assistant_allow_forward (Assistant* self, gboolean allow) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->current != NULL) {
		_tmp0_ = self->priv->forward_button != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_widget_set_sensitive (self->priv->forward_button, allow);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void assistant_set_header_icon (Assistant* self, const gchar* name) {
	GdkScreen* _tmp1_ = NULL;
	GtkIconTheme* _tmp2_ = NULL;
	GtkIconTheme* _tmp3_;
	GtkIconTheme* theme;
	GdkPixbuf* _tmp4_ = NULL;
	GdkPixbuf* pixbuf;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (name == NULL) {
		const gchar* _tmp0_ = NULL;
		_tmp0_ = gtk_window_get_icon_name ((GtkWindow*) self);
		name = _tmp0_;
	}
	_tmp1_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp2_ = gtk_icon_theme_get_for_screen (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	theme = _tmp3_;
	_tmp4_ = gtk_icon_theme_load_icon (theme, name, 48, GTK_ICON_LOOKUP_FORCE_SIZE, &_inner_error_);
	pixbuf = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (theme);
		goto __catch0_g_error;
	}
	g_object_set (self->header_icon, "pixbuf", pixbuf, NULL);
	_g_object_unref0 (pixbuf);
	_g_object_unref0 (theme);
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void assistant_handle_response (Assistant* self, gint resp) {
	g_return_if_fail (self != NULL);
	switch (resp) {
		case ASSISTANT_BACK:
		{
			assistant_go_back (self);
			break;
		}
		case ASSISTANT_APPLY:
		case ASSISTANT_FORWARD:
		{
			assistant_go_forward (self);
			break;
		}
		default:
		case ASSISTANT_CANCEL:
		{
			g_signal_emit_by_name (self, "canceled");
			break;
		}
		case ASSISTANT_CLOSE:
		{
			g_signal_emit_by_name (self, "closed");
			break;
		}
		case ASSISTANT_RESUME:
		{
			g_signal_emit_by_name (self, "resumed");
			break;
		}
	}
}


void assistant_hide_for_now (Assistant* self) {
	g_return_if_fail (self != NULL);
	deja_dup_hide_background_window_for_shell ((GtkWindow*) self);
}


gboolean assistant_is_interrupted (Assistant* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->interrupted != NULL;
	return result;
}


void assistant_skip (Assistant* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_last_op_was_back) {
		assistant_go_back (self);
	} else {
		assistant_go_forward (self);
	}
}


void assistant_go_back (Assistant* self) {
	GList* next = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->interrupted != NULL) {
		next = self->priv->interrupted->prev;
	} else {
		next = self->current->prev;
		while (TRUE) {
			gboolean _tmp0_ = FALSE;
			if (next != NULL) {
				_tmp0_ = ((AssistantPageInfo*) next->data)->type == ASSISTANT_TYPE_INTERRUPT;
			} else {
				_tmp0_ = FALSE;
			}
			if (!_tmp0_) {
				break;
			}
			next = next->prev;
		}
	}
	if (next != NULL) {
		assistant_set_last_op_was_back (self, TRUE);
		self->current = next;
		assistant_page_changed (self);
		g_signal_emit_by_name (self, "backward");
	}
}


void assistant_go_forward (Assistant* self) {
	GList* next = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->interrupted != NULL) {
		next = self->priv->interrupted;
		if (self->priv->interrupted_from_hidden) {
			assistant_hide_for_now (self);
		}
	} else {
		GList* _tmp0_ = NULL;
		if (self->current == NULL) {
			_tmp0_ = self->priv->infos;
		} else {
			_tmp0_ = self->current->next;
		}
		next = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			if (next != NULL) {
				_tmp1_ = ((AssistantPageInfo*) next->data)->type == ASSISTANT_TYPE_INTERRUPT;
			} else {
				_tmp1_ = FALSE;
			}
			if (!_tmp1_) {
				break;
			}
			next = next->next;
		}
	}
	if (next != NULL) {
		assistant_set_last_op_was_back (self, FALSE);
		self->current = next;
		assistant_page_changed (self);
		g_signal_emit_by_name (self, "forward");
	}
}


void assistant_go_to_page (Assistant* self, GtkWidget* page) {
	GList* i;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	i = self->priv->infos;
	while (TRUE) {
		if (!(i != NULL)) {
			break;
		}
		if (((AssistantPageInfo*) i->data)->page == page) {
			self->current = i;
			assistant_page_changed (self);
			break;
		}
		i = i->next;
	}
}


void assistant_interrupt (Assistant* self, GtkWidget* page, gboolean can_continue) {
	GList* was;
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	was = self->current;
	self->priv->interrupt_can_continue = can_continue;
	assistant_go_to_page (self, page);
	_tmp0_ = gtk_widget_get_visible ((GtkWidget*) self);
	if (!_tmp0_) {
		self->priv->interrupted_from_hidden = TRUE;
	}
	self->priv->interrupted = was;
}


static void assistant_use_title (Assistant* self, AssistantPageInfo* info) {
	gchar* _tmp0_ = NULL;
	gchar* title;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = g_markup_printf_escaped ("<span size=\"xx-large\" weight=\"ultrabold\">%s</span>", info->title);
	title = _tmp0_;
	gtk_label_set_markup (self->priv->header_title, title);
	_g_free0 (title);
}


static void assistant_page_changed (Assistant* self) {
	AssistantPageInfo* info;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->current != NULL);
	self->priv->interrupted = NULL;
	self->priv->interrupted_from_hidden = FALSE;
	info = (AssistantPageInfo*) self->current->data;
	assistant_set_header_icon (self, NULL);
	g_signal_emit_by_name (self, "prepare", info->page);
	if (((AssistantPageInfo*) self->current->data)->page == info->page) {
		GtkWidget* _tmp0_ = NULL;
		GtkWidget* _tmp1_;
		GtkWidget* child;
		GtkWidget* _tmp2_ = NULL;
		GtkWidget* _tmp3_;
		GtkWidget* w;
		gboolean _tmp4_ = FALSE;
		assistant_use_title (self, info);
		assistant_set_buttons (self);
		_tmp0_ = gtk_bin_get_child ((GtkBin*) self->page_box);
		_tmp1_ = _g_object_ref0 (_tmp0_);
		child = _tmp1_;
		if (child != NULL) {
			gtk_widget_hide (child);
			gtk_container_remove ((GtkContainer*) self->page_box, child);
		}
		gtk_container_add ((GtkContainer*) self->page_box, info->page);
		gtk_widget_show (info->page);
		assistant_reset_size (self, info->page);
		_tmp2_ = gtk_window_get_focus ((GtkWindow*) self);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		w = _tmp3_;
		if (w != NULL) {
			GType _tmp5_;
			_tmp5_ = G_TYPE_FROM_INSTANCE ((GObject*) w);
			_tmp4_ = _tmp5_ == GTK_TYPE_LABEL;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			gtk_label_select_region (GTK_LABEL (w), -1, -1);
		}
		_g_object_unref0 (w);
		_g_object_unref0 (child);
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda0_ (Block1Data* _data1_) {
	Assistant * self;
	self = _data1_->self;
	g_signal_emit_by_name (self, "response", _data1_->response);
}


static void __lambda0__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda0_ (self);
}


static GtkButton* assistant_add_button (Assistant* self, const gchar* stock, gint response) {
	GtkButton* result = NULL;
	Block1Data* _data1_;
	GtkButton* _tmp0_ = NULL;
	GtkButton* btn;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (stock != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->response = response;
	_tmp0_ = (GtkButton*) gtk_button_new_from_stock (stock);
	btn = g_object_ref_sink (_tmp0_);
	gtk_widget_set_can_default ((GtkWidget*) btn, TRUE);
	g_signal_connect_data (btn, "clicked", (GCallback) __lambda0__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	gtk_widget_show ((GtkWidget*) btn);
	gtk_box_pack_end ((GtkBox*) self->priv->button_box, (GtkWidget*) btn, FALSE, TRUE, (guint) 0);
	result = btn;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


static void assistant_set_buttons (Assistant* self) {
	AssistantPageInfo* info;
	gboolean show_cancel;
	gboolean show_back;
	gboolean show_forward;
	gboolean show_apply;
	gboolean show_close;
	gboolean show_resume;
	gchar* _tmp0_;
	gchar* forward_text;
	GtkButtonBox* _tmp3_;
	GtkButtonBox* area;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->current != NULL);
	info = (AssistantPageInfo*) self->current->data;
	show_cancel = FALSE;
	show_back = FALSE;
	show_forward = FALSE;
	show_apply = FALSE;
	show_close = FALSE;
	show_resume = FALSE;
	_tmp0_ = g_strdup (GTK_STOCK_GO_FORWARD);
	forward_text = _tmp0_;
	switch (info->type) {
		default:
		case ASSISTANT_TYPE_NORMAL:
		{
			show_cancel = TRUE;
			show_back = self->current->prev != NULL;
			show_forward = TRUE;
			break;
		}
		case ASSISTANT_TYPE_SUMMARY:
		{
			show_cancel = TRUE;
			show_back = self->current->prev != NULL;
			show_apply = TRUE;
			break;
		}
		case ASSISTANT_TYPE_INTERRUPT:
		{
			show_cancel = TRUE;
			if (self->priv->interrupt_can_continue) {
				const gchar* _tmp1_ = NULL;
				gchar* _tmp2_;
				show_forward = TRUE;
				_tmp1_ = _ ("Co_ntinue");
				_tmp2_ = g_strdup (_tmp1_);
				_g_free0 (forward_text);
				forward_text = _tmp2_;
			}
			break;
		}
		case ASSISTANT_TYPE_PROGRESS:
		{
			show_cancel = TRUE;
			show_resume = TRUE;
			break;
		}
		case ASSISTANT_TYPE_FINISH:
		{
			show_close = TRUE;
			break;
		}
	}
	_tmp3_ = _g_object_ref0 (self->priv->button_box);
	area = _tmp3_;
	if (self->priv->cancel_button != NULL) {
		gtk_container_remove ((GtkContainer*) area, self->priv->cancel_button);
		deja_dup_destroy_widget (self->priv->cancel_button);
		_g_object_unref0 (self->priv->cancel_button);
		self->priv->cancel_button = NULL;
	}
	if (self->priv->close_button != NULL) {
		gtk_container_remove ((GtkContainer*) area, self->priv->close_button);
		deja_dup_destroy_widget (self->priv->close_button);
		_g_object_unref0 (self->priv->close_button);
		self->priv->close_button = NULL;
	}
	if (self->priv->back_button != NULL) {
		gtk_container_remove ((GtkContainer*) area, self->priv->back_button);
		deja_dup_destroy_widget (self->priv->back_button);
		_g_object_unref0 (self->priv->back_button);
		self->priv->back_button = NULL;
	}
	if (self->priv->resume_button != NULL) {
		gtk_container_remove ((GtkContainer*) area, self->priv->resume_button);
		deja_dup_destroy_widget (self->priv->resume_button);
		_g_object_unref0 (self->priv->resume_button);
		self->priv->resume_button = NULL;
	}
	if (self->priv->forward_button != NULL) {
		gtk_container_remove ((GtkContainer*) area, self->priv->forward_button);
		deja_dup_destroy_widget (self->priv->forward_button);
		_g_object_unref0 (self->priv->forward_button);
		self->priv->forward_button = NULL;
	}
	if (self->priv->apply_button != NULL) {
		gtk_container_remove ((GtkContainer*) area, self->priv->apply_button);
		deja_dup_destroy_widget (self->priv->apply_button);
		_g_object_unref0 (self->priv->apply_button);
		self->priv->apply_button = NULL;
	}
	if (show_cancel) {
		GtkButton* _tmp4_ = NULL;
		_tmp4_ = assistant_add_button (self, GTK_STOCK_CANCEL, ASSISTANT_CANCEL);
		_g_object_unref0 (self->priv->cancel_button);
		self->priv->cancel_button = (GtkWidget*) _tmp4_;
	}
	if (show_close) {
		GtkButton* _tmp5_ = NULL;
		_tmp5_ = assistant_add_button (self, GTK_STOCK_CLOSE, ASSISTANT_CLOSE);
		_g_object_unref0 (self->priv->close_button);
		self->priv->close_button = (GtkWidget*) _tmp5_;
		gtk_widget_grab_default (self->priv->close_button);
	}
	if (show_back) {
		GtkButton* _tmp6_ = NULL;
		_tmp6_ = assistant_add_button (self, GTK_STOCK_GO_BACK, ASSISTANT_BACK);
		_g_object_unref0 (self->priv->back_button);
		self->priv->back_button = (GtkWidget*) _tmp6_;
	}
	if (show_resume) {
		const gchar* _tmp7_ = NULL;
		GtkButton* _tmp8_ = NULL;
		_tmp7_ = _ ("_Resume Later");
		_tmp8_ = assistant_add_button (self, _tmp7_, ASSISTANT_RESUME);
		_g_object_unref0 (self->priv->resume_button);
		self->priv->resume_button = (GtkWidget*) _tmp8_;
		gtk_widget_grab_default (self->priv->resume_button);
	}
	if (show_forward) {
		GtkButton* _tmp9_ = NULL;
		_tmp9_ = assistant_add_button (self, forward_text, ASSISTANT_FORWARD);
		_g_object_unref0 (self->priv->forward_button);
		self->priv->forward_button = (GtkWidget*) _tmp9_;
		gtk_widget_grab_default (self->priv->forward_button);
	}
	if (show_apply) {
		GtkButton* _tmp10_ = NULL;
		_tmp10_ = assistant_add_button (self, self->priv->_apply_text, ASSISTANT_APPLY);
		_g_object_unref0 (self->priv->apply_button);
		self->priv->apply_button = (GtkWidget*) _tmp10_;
		gtk_widget_grab_default (self->priv->apply_button);
	}
	_g_object_unref0 (area);
	_g_free0 (forward_text);
}


static gboolean assistant_set_first_page (Assistant* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->current = NULL;
	assistant_go_forward (self);
	result = FALSE;
	return result;
}


static gpointer _assistant_page_info_ref0 (gpointer self) {
	return self ? assistant_page_info_ref (self) : NULL;
}


static gboolean _assistant_set_first_page_gsource_func (gpointer self) {
	gboolean result;
	result = assistant_set_first_page (self);
	return result;
}


void assistant_append_page (Assistant* self, GtkWidget* page, AssistantType type) {
	gboolean was_empty;
	AssistantPageInfo* _tmp0_ = NULL;
	AssistantPageInfo* info;
	GtkWidget* _tmp1_;
	gchar* _tmp2_;
	AssistantPageInfo* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	was_empty = self->priv->infos == NULL;
	_tmp0_ = assistant_page_info_new ();
	info = _tmp0_;
	_tmp1_ = _g_object_ref0 (page);
	_g_object_unref0 (info->page);
	info->page = _tmp1_;
	info->type = type;
	_tmp2_ = g_strdup ("");
	_g_free0 (info->title);
	info->title = _tmp2_;
	_tmp3_ = _assistant_page_info_ref0 (info);
	self->priv->infos = g_list_append (self->priv->infos, _tmp3_);
	gtk_widget_show_all (page);
	if (was_empty) {
		GtkRequisition _tmp4_ = {0};
		gtk_widget_get_preferred_size ((GtkWidget*) self->page_box, NULL, &_tmp4_);
		self->priv->page_box_req = _tmp4_;
	}
	assistant_reset_size (self, page);
	if (was_empty) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _assistant_set_first_page_gsource_func, g_object_ref (self), g_object_unref);
	}
	_assistant_page_info_unref0 (info);
}


static void assistant_reset_size (Assistant* self, GtkWidget* page) {
	GtkRequisition pagereq = {0};
	gint boxw = 0;
	gint boxh = 0;
	gint _tmp0_;
	gint _tmp1_;
	GtkRequisition _tmp2_ = {0};
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	gtk_widget_get_size_request ((GtkWidget*) self->page_box, &_tmp0_, &_tmp1_);
	boxw = _tmp0_;
	boxh = _tmp1_;
	gtk_widget_get_preferred_size (page, NULL, &_tmp2_);
	pagereq = _tmp2_;
	_tmp3_ = MAX (boxw, pagereq.width + self->priv->page_box_req.width);
	_tmp4_ = MAX (boxh, pagereq.height + self->priv->page_box_req.height);
	gtk_widget_set_size_request ((GtkWidget*) self->page_box, _tmp3_, _tmp4_);
}


void assistant_set_page_title (Assistant* self, GtkWidget* page, const gchar* title) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	g_return_if_fail (title != NULL);
	{
		GList* info_collection;
		GList* info_it;
		info_collection = self->priv->infos;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			AssistantPageInfo* _tmp0_;
			AssistantPageInfo* info;
			_tmp0_ = _assistant_page_info_ref0 ((AssistantPageInfo*) info_it->data);
			info = _tmp0_;
			{
				if (info->page == page) {
					gchar* _tmp1_;
					gboolean _tmp2_ = FALSE;
					_tmp1_ = g_strdup (title);
					_g_free0 (info->title);
					info->title = _tmp1_;
					if (self->current != NULL) {
						_tmp2_ = ((AssistantPageInfo*) self->current->data)->page == page;
					} else {
						_tmp2_ = FALSE;
					}
					if (_tmp2_) {
						assistant_use_title (self, info);
					}
					_assistant_page_info_unref0 (info);
					break;
				}
				_assistant_page_info_unref0 (info);
			}
		}
	}
}


Assistant* assistant_construct (GType object_type) {
	Assistant * self = NULL;
	self = (Assistant*) g_object_new (object_type, NULL);
	return self;
}


const gchar* assistant_get_apply_text (Assistant* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_apply_text;
	return result;
}


void assistant_set_apply_text (Assistant* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_apply_text);
	self->priv->_apply_text = _tmp0_;
	g_object_notify ((GObject *) self, "apply-text");
}


gboolean assistant_get_last_op_was_back (Assistant* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_last_op_was_back;
	return result;
}


static void assistant_set_last_op_was_back (Assistant* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_last_op_was_back = value;
	g_object_notify ((GObject *) self, "last-op-was-back");
}


static void _assistant_handle_response_assistant_response (Assistant* _sender, gint response, gpointer self) {
	assistant_handle_response (self, response);
}


static GObject * assistant_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	Assistant * self;
	GtkEventBox* _tmp0_ = NULL;
	GtkEventBox* ebox;
	GtkBox* _tmp1_ = NULL;
	GtkBox* evbox;
	GtkBox* _tmp2_ = NULL;
	GtkBox* ehbox;
	GtkLabel* _tmp3_ = NULL;
	GtkImage* _tmp4_ = NULL;
	GtkEventBox* _tmp5_ = NULL;
	GtkButtonBox* _tmp6_ = NULL;
	GtkBox* _tmp7_ = NULL;
	GtkBox* dlg_vbox;
	GtkStyle* _tmp8_ = NULL;
	GdkColor _tmp9_;
	GtkStyle* _tmp10_ = NULL;
	GdkColor _tmp11_;
	parent_class = G_OBJECT_CLASS (assistant_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ASSISTANT (obj);
	__g_list_free__assistant_page_info_unref0_0 (self->priv->infos);
	self->priv->infos = NULL;
	_tmp0_ = (GtkEventBox*) gtk_event_box_new ();
	ebox = g_object_ref_sink (_tmp0_);
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	evbox = g_object_ref_sink (_tmp1_);
	gtk_container_add ((GtkContainer*) ebox, (GtkWidget*) evbox);
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	ehbox = g_object_ref_sink (_tmp2_);
	_tmp3_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->header_title);
	self->priv->header_title = g_object_ref_sink (_tmp3_);
	g_object_set ((GtkMisc*) self->priv->header_title, "xalign", 0.f, NULL);
	_tmp4_ = (GtkImage*) gtk_image_new ();
	_g_object_unref0 (self->header_icon);
	self->header_icon = g_object_ref_sink (_tmp4_);
	gtk_container_set_border_width ((GtkContainer*) ehbox, (guint) 6);
	gtk_box_pack_start (ehbox, (GtkWidget*) self->priv->header_title, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start (ehbox, (GtkWidget*) self->header_icon, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (evbox, (GtkWidget*) ehbox, FALSE, FALSE, (guint) 0);
	_tmp5_ = (GtkEventBox*) gtk_event_box_new ();
	_g_object_unref0 (self->page_box);
	self->page_box = g_object_ref_sink (_tmp5_);
	gtk_box_pack_start (evbox, (GtkWidget*) self->page_box, TRUE, TRUE, (guint) 0);
	_tmp6_ = (GtkButtonBox*) gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);
	_g_object_unref0 (self->priv->button_box);
	self->priv->button_box = g_object_ref_sink (_tmp6_);
	gtk_button_box_set_layout (self->priv->button_box, GTK_BUTTONBOX_END);
	gtk_container_set_border_width ((GtkContainer*) self->priv->button_box, (guint) 12);
	gtk_box_set_spacing ((GtkBox*) self->priv->button_box, 12);
	_tmp7_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	dlg_vbox = g_object_ref_sink (_tmp7_);
	gtk_box_pack_start (dlg_vbox, (GtkWidget*) ebox, TRUE, TRUE, (guint) 0);
	gtk_box_pack_end (dlg_vbox, (GtkWidget*) self->priv->button_box, FALSE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) dlg_vbox);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) dlg_vbox);
	gtk_widget_ensure_style ((GtkWidget*) ebox);
	_tmp8_ = gtk_widget_get_style ((GtkWidget*) ebox);
	_tmp9_ = _tmp8_->bg[GTK_STATE_SELECTED];
	gtk_widget_modify_bg ((GtkWidget*) ebox, GTK_STATE_NORMAL, &_tmp9_);
	_tmp10_ = gtk_widget_get_style ((GtkWidget*) ebox);
	_tmp11_ = _tmp10_->fg[GTK_STATE_SELECTED];
	gtk_widget_modify_fg ((GtkWidget*) ebox, GTK_STATE_NORMAL, &_tmp11_);
	g_signal_connect_object (self, "response", (GCallback) _assistant_handle_response_assistant_response, self, 0);
	_g_object_unref0 (dlg_vbox);
	_g_object_unref0 (ehbox);
	_g_object_unref0 (evbox);
	_g_object_unref0 (ebox);
	return obj;
}


static AssistantPageInfo* assistant_page_info_construct (GType object_type) {
	AssistantPageInfo* self = NULL;
	self = (AssistantPageInfo*) g_type_create_instance (object_type);
	return self;
}


static AssistantPageInfo* assistant_page_info_new (void) {
	return assistant_page_info_construct (ASSISTANT_TYPE_PAGE_INFO);
}


static void assistant_value_page_info_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void assistant_value_page_info_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		assistant_page_info_unref (value->data[0].v_pointer);
	}
}


static void assistant_value_page_info_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = assistant_page_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer assistant_value_page_info_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* assistant_value_page_info_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		AssistantPageInfo* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = assistant_page_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* assistant_value_page_info_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AssistantPageInfo** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = assistant_page_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* assistant_param_spec_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	AssistantParamSpecPageInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, ASSISTANT_TYPE_PAGE_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer assistant_value_get_page_info (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ASSISTANT_TYPE_PAGE_INFO), NULL);
	return value->data[0].v_pointer;
}


static void assistant_value_set_page_info (GValue* value, gpointer v_object) {
	AssistantPageInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ASSISTANT_TYPE_PAGE_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ASSISTANT_TYPE_PAGE_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		assistant_page_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		assistant_page_info_unref (old);
	}
}


static void assistant_value_take_page_info (GValue* value, gpointer v_object) {
	AssistantPageInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ASSISTANT_TYPE_PAGE_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ASSISTANT_TYPE_PAGE_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		assistant_page_info_unref (old);
	}
}


static void assistant_page_info_class_init (AssistantPageInfoClass * klass) {
	assistant_page_info_parent_class = g_type_class_peek_parent (klass);
	ASSISTANT_PAGE_INFO_CLASS (klass)->finalize = assistant_page_info_finalize;
}


static void assistant_page_info_instance_init (AssistantPageInfo * self) {
	self->ref_count = 1;
}


static void assistant_page_info_finalize (AssistantPageInfo* obj) {
	AssistantPageInfo * self;
	self = ASSISTANT_PAGE_INFO (obj);
	_g_object_unref0 (self->page);
	_g_free0 (self->title);
}


static GType assistant_page_info_get_type (void) {
	static volatile gsize assistant_page_info_type_id__volatile = 0;
	if (g_once_init_enter (&assistant_page_info_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { assistant_value_page_info_init, assistant_value_page_info_free_value, assistant_value_page_info_copy_value, assistant_value_page_info_peek_pointer, "p", assistant_value_page_info_collect_value, "p", assistant_value_page_info_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AssistantPageInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_page_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssistantPageInfo), 0, (GInstanceInitFunc) assistant_page_info_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType assistant_page_info_type_id;
		assistant_page_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AssistantPageInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&assistant_page_info_type_id__volatile, assistant_page_info_type_id);
	}
	return assistant_page_info_type_id__volatile;
}


static gpointer assistant_page_info_ref (gpointer instance) {
	AssistantPageInfo* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void assistant_page_info_unref (gpointer instance) {
	AssistantPageInfo* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ASSISTANT_PAGE_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void assistant_class_init (AssistantClass * klass) {
	assistant_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AssistantPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_assistant_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_assistant_set_property;
	G_OBJECT_CLASS (klass)->constructor = assistant_constructor;
	G_OBJECT_CLASS (klass)->finalize = assistant_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_APPLY_TEXT, g_param_spec_string ("apply-text", "apply-text", "apply-text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_LAST_OP_WAS_BACK, g_param_spec_boolean ("last-op-was-back", "last-op-was-back", "last-op-was-back", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("response", TYPE_ASSISTANT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	g_signal_new ("canceled", TYPE_ASSISTANT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("closed", TYPE_ASSISTANT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("resumed", TYPE_ASSISTANT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("prepare", TYPE_ASSISTANT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GTK_TYPE_WIDGET);
	g_signal_new ("forward", TYPE_ASSISTANT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("backward", TYPE_ASSISTANT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void assistant_instance_init (Assistant * self) {
	gchar* _tmp0_;
	self->priv = ASSISTANT_GET_PRIVATE (self);
	_tmp0_ = g_strdup (GTK_STOCK_APPLY);
	self->priv->_apply_text = _tmp0_;
	self->priv->_last_op_was_back = FALSE;
	self->priv->interrupt_can_continue = TRUE;
	self->priv->interrupted_from_hidden = FALSE;
}


static void assistant_finalize (GObject* obj) {
	Assistant * self;
	self = ASSISTANT (obj);
	_g_free0 (self->priv->_apply_text);
	_g_object_unref0 (self->priv->header_title);
	_g_object_unref0 (self->header_icon);
	_g_object_unref0 (self->priv->button_box);
	_g_object_unref0 (self->priv->back_button);
	_g_object_unref0 (self->priv->forward_button);
	_g_object_unref0 (self->priv->cancel_button);
	_g_object_unref0 (self->priv->close_button);
	_g_object_unref0 (self->priv->resume_button);
	_g_object_unref0 (self->priv->apply_button);
	_g_object_unref0 (self->page_box);
	__g_list_free__assistant_page_info_unref0_0 (self->priv->infos);
	G_OBJECT_CLASS (assistant_parent_class)->finalize (obj);
}


/**
 * Yes, this is a silly reimplementation of Gtk.Assistant.
 * But Gtk.Assistant has some ridiculous map/unmap logic that resets the page
 * history when unmapped and generally doesn't work when unmapped.  Since
 * continuing to work when hidden is important for us, this is a
 * reimplementation of just the bits we use.
 */
GType assistant_get_type (void) {
	static volatile gsize assistant_type_id__volatile = 0;
	if (g_once_init_enter (&assistant_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AssistantClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Assistant), 0, (GInstanceInitFunc) assistant_instance_init, NULL };
		GType assistant_type_id;
		assistant_type_id = g_type_register_static (GTK_TYPE_WINDOW, "Assistant", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&assistant_type_id__volatile, assistant_type_id);
	}
	return assistant_type_id__volatile;
}


static void _vala_assistant_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Assistant * self;
	self = ASSISTANT (object);
	switch (property_id) {
		case ASSISTANT_APPLY_TEXT:
		g_value_set_string (value, assistant_get_apply_text (self));
		break;
		case ASSISTANT_LAST_OP_WAS_BACK:
		g_value_set_boolean (value, assistant_get_last_op_was_back (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_assistant_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Assistant * self;
	self = ASSISTANT (object);
	switch (property_id) {
		case ASSISTANT_APPLY_TEXT:
		assistant_set_apply_text (self, g_value_get_string (value));
		break;
		case ASSISTANT_LAST_OP_WAS_BACK:
		assistant_set_last_op_was_back (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



