#!/usr/bin/perl -w
#
# This is the basis of an application with signal handlers
#
# You can safely edit this file, any changes that you make will be preserved
# and this file will not be overwritten by the next run of Glade::PerlGenerate
#
# Skeleton subs of any missing signal handlers can be copied from
# /home/redstar/Projects/dfontmgr/src/DfontmgrSIGS.pm
#

#==============================================================================
#=== This is the 'fileselection1' class                              
#==============================================================================
package fileselection1;
require 5.000; use strict 'vars', 'refs', 'subs';
# UI class 'fileselection1' (version 0.01)
# 
# Copyright (c) Date 2001ǯ  9 29  23:58:32 JST
# Author Yasuhiro Take,,, <redstar\@laminar>
#
## Unspecified copying policy, please contact the author\n#  Yasuhiro Take,,, <redstar\@laminar>
#
#==============================================================================
# This perl source file was automatically generated by 
# Glade::PerlGenerate version 0.59 - Wed Jun 20 14:48:25 BST 2001
# Copyright (c) Author Dermot Musgrove <dermot.musgrove\@virgin.net>
#
# from Glade file /home/redstar/Projects/dfontmgr/dfontmgr.glade
# 2001ǯ 11 17  18:12:44 JST
#==============================================================================

package fileselection1;
require 5.000; use strict 'vars', 'refs', 'subs';

BEGIN {
    use DfontmgrUI;
}

my $FileSelection;
my $File;

sub app_run {
    my $class = shift;
    
    my $window = $class->new;
    $FileSelection = $window->{FORM};
    $window->TOPLEVEL->show;

    $File = '';

    my $t = Gtk->timeout_add(100, \&idle);
    Gtk->main;
    Gtk->timeout_remove($t);
    
    $window->TOPLEVEL->destroy;
    undef $FileSelection;

    return $File;

}

sub idle {
    if (&dfontmgr::check_configuring()) {
	Gtk->main_quit();
    }

    return 1;
}

sub on_cancel_button1_clicked {
    Gtk->main_quit();
}

sub on_fileselection1_delete_event {
    Gtk->main_quit();
    return 0;
}

sub on_ok_button1_clicked {
    $File = $FileSelection->{fileselection1}->get_filename();
    Gtk->main_quit();
}

#==============================================================================
#=== This is the 'window1' class                              
#==============================================================================
package window1;
require 5.000; use strict 'vars', 'refs', 'subs';
# UI class 'window1' (version 0.01)
# 
# Copyright (c) Date 2001ǯ  9 29  23:58:32 JST
# Author Yasuhiro Take,,, <redstar\@laminar>
#
## Unspecified copying policy, please contact the author\n#  Yasuhiro Take,,, <redstar\@laminar>
#
#==============================================================================
# This perl source file was automatically generated by 
# Glade::PerlGenerate version 0.59 - Wed Jun 20 14:48:25 BST 2001
# Copyright (c) Author Dermot Musgrove <dermot.musgrove\@virgin.net>
#
# from Glade file /home/redstar/Projects/dfontmgr/dfontmgr.glade
# 2001ǯ  9 29  23:58:32 JST
#==============================================================================

BEGIN {
    use DfontmgrUI;
    use OptionMenu;
    use lib "/usr/share/perl5/Debian/DefomaWizard";
    use DefomaWizard;
}

my $Window;
my $window1;
my $Cursor_Clock;
my $ContextId;
my $MessageId;
my @FontCategory;
my $I_FontCategory = '';
my @App;
my $I_App = '';
my @Font;
my $I_Font;
my @IdCache;
my $I_IdCache;
my $Id;
my $I_Id = '';
my $Id_Sort = 0;
my @Id_Index;

my $OpMenu_IdCache;

my %TypeStr = ('Sr' => 'RealName', 'SS' => 'Subst', 'Sa' => 'Alias',
	       'Ua' => 'U-Alias',
	       'SrI' => 'RealName', 'SSI' => 'Subst', 'SaI' => 'Alias',
	       'UaI' => 'U-Alias');
my @StatStr = (' - ', '   ', '(+)', ' * ', ' + ');
my @StatText = ('Not Installed (compulsory)',
		'Not Installed',
		'Not Installed (dependency unmet)',
		'Installed',
		'Installed (compulsory)');
my %Type2Pri = ('RealName' => 2,
		'Alias' => 1,
		'Subst' => 0,
		'U-Alias' => 3);

my $ExDir;
my $EtcDir;
my $DestDir;
my $NotRoot;

sub app_run {
    my ($class) = @_;
    $class->load_translations('Dfontmgr');
    # You can use the line below to load a test .mo file before it is installed in 
    # the normal place (eg /usr/local/share/locale/ja_JP.eucJP/LC_MESSAGES/Dfontmgr.mo)
#    $class->load_translations('Dfontmgr', 'test', undef, '/home/redstar/Projects/dfontmgr/ppo/Dfontmgr.mo');
    Gtk->init;
    $window1 = $class->new;
    $Window = $window1->{FORM};

    $ContextId = $Window->{statusbar1}->get_context_id('dfontmgr');
    Gtk->timeout_add(100, \&idle);
#    idle();

    $Cursor_Clock = new Gtk::Gdk::Cursor(150);

    $Window->{window1}->drag_dest_set([], []);

    $window1->TOPLEVEL->show;

    &defomawizard::set_timeout(\&idle);
    &defomawizard::set_modal(1);

    $ExDir = &dfontmgr::defomatestdir() . "/usr/share/doc/defoma/examples";
    $EtcDir = &dfontmgr::defomatestdir() . "/etc/defoma/hints";
    
    $DestDir = (&dfontmgr::check_root() && ! &dfontmgr::userspace()) ?
	$EtcDir : &dfontmgr::homedir();

    unless (&dfontmgr::check_root()) {
	$NotRoot = "You are not " .
	    (&dfontmgr::userspace() ? &dfontmgr::userlogin() : "root");
    }
    
    Gtk->main;

    $window1->TOPLEVEL->destroy;

    return 0;
}

my $MW;

sub modal_on {
    $MW = new Gtk::Window('popup');
    $MW->set_title(_('window2'));
    $MW->position('center');
#    $MW->set_parent($Window->{window1});
    $MW->set_policy(0, 0, 0);
    $MW->set_modal(1);
    $MW->border_width(10);

    $MW->realize();

    my $label = new Gtk::Label(_("Configuring Now..."));
    $label->set_justify('center' );
    $label->set_line_wrap(0 );

    $MW->add($label);
    
    $label->show;

    $MW->show;
}

sub modal_off {
    mouse_normal();
    
    if ($MW) {
	$MW->destroy();
	undef $MW;
    }
}

sub mouse_normal {
    $Window->{window1}->window()->set_cursor(undef);
}

sub mouse_wait {
    my $dw = &defomawizard::get_window();

    $Window->{window1}->window()->set_cursor($Cursor_Clock);
    $dw->{defomawizard}->window()->set_cursor($Cursor_Clock) if ($dw);
    $MW->window()->set_cursor($Cursor_Clock) if ($MW);
}

my $Configuring = 3;

sub idle {
    my $c = &dfontmgr::check_configuring();
    $c += &dfontmgr::check_configuring_u();

    if ($Configuring && $c == 0) {
	&dfontmgr::userupdate1() if ($Configuring >= 2);
	update() if ($Configuring < 2);
	
	if ($MessageId) {
	    statusbar_check();
	    undef $MessageId;
	}
	mouse_normal();
	modal_off();

	if ($Configuring >= 2) {
	    &dfontmgr::userupdate2();
	    update();
	}

	$Configuring = 0;
    } elsif ($c) {
	unless (defined($MessageId)) {
	    $MessageId = statusbar_msg('Configuring now... Please wait.');
	    modal_on();
	    mouse_wait();
	}
    }

    $Configuring |= $c;

    return 1;
}

my $Update = 0;

sub update {
    my $i;
    my $i_font = $I_Font;
    my $i_idcache = $I_IdCache;
    my $i_id = $I_Id;
    my $i_fontcategory = $I_FontCategory;
    my $i_app = $I_App;

    &dfontmgr::initialize();

    $I_FontCategory = '';
    $I_Font = '';
    $I_App = '';

    $Update = 1;

    $Window->{clist_font_fontinformation}->freeze();
    $Window->{clist_font_fontinformation}->clear();
    $Window->{clist_font_fontinformation}->thaw();

    $Window->{clist_app_idcache}->freeze();
    $Window->{clist_app_idcache}->clear();
    $Window->{clist_app_idcache}->thaw();
    

    clear_app_information();
    clear_font_information();

    $OpMenu_IdCache && $OpMenu_IdCache->clear();
    undef $OpMenu_IdCache;
    
    $Window->{clist_font_category}->freeze();
    $Window->{clist_font_category}->clear();
    $Window->{clist_app_application}->freeze();
    $Window->{clist_app_application}->clear();

    @FontCategory = &dfontmgr::get_font_categories();
    @App = &dfontmgr::get_apps();
    undef @Font;
    undef @IdCache;
    
    foreach $i (@FontCategory) {
	$Window->{clist_font_category}->append($i);
    }
    foreach $i (@App) {
	$Window->{clist_app_application}->append($i);
    }

    $Window->{clist_font_category}->thaw();
    $Window->{clist_app_application}->thaw();

    select_clist_font_category($i_fontcategory);
    select_clist_font_fontinformation($i_font);

    for ($i = 0; $i < @App; $i++) {
	if ($App[$i] eq $i_app) {
	    $Window->{clist_app_application}->select_row($i, 0);
	}
    }

    while (Gtk->events_pending()) {
	Gtk->main_iteration();
    }

    $Update = 0;
}

sub cmp_status {
    my $a = shift;
    my $b = shift;

    return -1 if ($Id->{status}->[$a] >= 3 && $Id->{status}->[$b] < 3);
    return 1 if ($Id->{status}->[$a] < 3 && $Id->{status}->[$b] >= 3);

    return ($Type2Pri{$TypeStr{$Id->{2}->[$b]}} <=>
	    $Type2Pri{$TypeStr{$Id->{2}->[$a]}});
}

sub id_sort0 {
    my $r;

    return $r if ($r = cmp_status($a, $b));
    return $r if ($r = ($Id->{0}->[$a] cmp $Id->{0}->[$b]));
    return $r if ($r = ($Id->{1}->[$a] cmp $Id->{1}->[$b]));
    return 0;
}

sub id_sort1 {
    my $r;

    return $r if ($r = ($Id->{0}->[$a] cmp $Id->{0}->[$b]));
    return $r if ($r = cmp_status($a, $b));
    return $r if ($r = ($Id->{1}->[$a] cmp $Id->{1}->[$b]));
    return 0;
}

sub id_sort2 {
    my $r;

    return $r if ($r = ($Id->{1}->[$a] cmp $Id->{1}->[$b]));
    return $r if ($r = cmp_status($a, $b));
    return $r if ($r = ($Id->{0}->[$a] cmp $Id->{0}->[$b]));
    return 0;
}

my $Ignore;

sub update_clist_app_idcache {
    if ($Id_Sort == 0) {
	@Id_Index = sort id_sort0 (@Id_Index);
    } elsif ($Id_Sort == 1) {
	@Id_Index = sort id_sort1 (@Id_Index);
    } elsif ($Id_Sort == 2) {
	@Id_Index = sort id_sort2 (@Id_Index);
    }
    
    my $clist = $Window->{clist_app_idcache};

    $clist->freeze();
    $clist->clear();

    $Ignore = 1;
    my $i;

    foreach $i (@Id_Index) {
	my $stat = $StatStr[$Id->{status}->[$i]];
	$stat .= $TypeStr{$Id->{2}->[$i]};
	
	$clist->append($stat, $Id->{0}->[$i], $Id->{1}->[$i]);
    }
    $clist->unselect_row(0, -1);
    $clist->thaw();

    $Ignore = 0;

    if ($I_Id && exists($Id->{hash01}->{$I_Id})) {
	my $j = $Id->{hash01}->{$I_Id};

	for ($i = 0; $i < @Id_Index; $i++) {
	    if ($Id_Index[$i] == $j) {
		$clist->select_row($i, -1);
		vadj_clist_app_idcache($i);
	    }
	}
    } else {
	$I_Id = '';
    }
}

sub vadj_clist_app_idcache {
    my $i = shift;
    
    my $k = ($i > 3) ? $i - 3 : 0;

    my $vadj = $Window->{scrolledwindow3}->get_vadjustment();
    
    $vadj->set_value(($k / @Id_Index) * $vadj->upper());
    $vadj->value_changed();
}

sub get_status {
    my $i = shift;
    my $t_stat;

    my $id = $Id->{0}->[$i];
    my $font = $Id->{1}->[$i];

    my $mt = '';
    if (exists($Id->{hash01_mark}->{$id.' '.$font})) {
	my $mi = $Id->{hash01_mark}->{$id.' '.$font};
	$mt = $Id->{2}->[$mi];
    }

    my $t = $Id->{2}->[$i];
    $t =~ /(..)(.?)/;
    my $t1 = $1;
    my $t2 = $2;

    if ($mt eq 'Mu') {
	$t_stat = ($t2 eq 'I') ? 4 : 2;
    } elsif ($mt ne '') {
	# exclude mode
	$t_stat = 0;
    } else {
	$t_stat = ($t2 eq 'I') ? 3 : 1;
    }

    return $t_stat;
}

sub activate_optionmenu_idcache {
    my $obj = shift;
    my $label = shift;

    $I_IdCache = $label;

    $label = '' if ($label eq '#DEFAULT#');

    $Id = dfontmgr::open_id_cache($label, $I_App);

    @Id_Index = (keys(%{$Id->{real}}), keys(%{$Id->{alias}}),
		 keys(%{$Id->{subst}}));
    @Id_Index = sort { $a <=> $b } (@Id_Index);

    $Id->{status} = [];
    foreach my $i (@Id_Index) {
	$Id->{status}->[$i] = get_status($i);
    }

    $Update || undef $I_Id;

    update_clist_app_idcache();
}

### app_information

sub clear_app_information {
    my $text = $Window->{text_app_appinformation};

    $text->freeze();

    $text->set_point(0);
    $text->forward_delete($text->get_length());

    $text->thaw();
}


sub show_app_information0 {
    my $text = $Window->{text_app_appinformation};

    $text->freeze();

    $text->set_point(0);
    $text->forward_delete($text->get_length());

    if ($I_App) {
	$text->insert(undef, undef, undef, "Application: $I_App\n");
	$text->insert(undef, undef, undef, "\n");
    }

    $text->thaw();
}

sub show_app_information {
    my $text = $Window->{text_app_appinformation};

    show_app_information0();

    $text->freeze();

    if ($I_App) {
	my @cs = &dfontmgr::get_app_categories($I_App);
	my $stat = &dfontmgr::get_app_status($I_App);
	
	$text->insert(undef, undef, undef, "Status: $stat\n");
	$text->insert(undef, undef, undef, "Accept Category: @cs\n");
	$text->insert(undef, undef, undef, "Id Cache: @IdCache\n");
	$text->insert(undef, undef, undef, "\n");
    }

    $text->thaw();
}

sub show_app_information_with_id {
    my $text = $Window->{text_app_appinformation};

    show_app_information0();

    $text->freeze();

    if ($Id && $I_Id && exists($Id->{hash01}->{$I_Id})) {
	my $i = $Id->{hash01}->{$I_Id};

	$text->insert(undef, undef, undef, "Id: ".$Id->{0}->[$i]."\n");
	$text->insert(undef, undef, undef, "Font: ".$Id->{1}->[$i]."\n");
	$text->insert(undef, undef, undef, "Category: ".$Id->{4}->[$i]."\n");
	$text->insert(undef, undef, undef, "Priority: ".$Id->{3}->[$i]."\n");
	$text->insert(undef, undef, undef,
		      "Status: ".$StatText[$Id->{status}->[$i]]."\n\n");

	if ($Id->{5}->[$i] ne '.' || $Id->{6}->[$i] ne '.') {
	    $text->insert(undef, undef, undef, "Depends: ");

	    if ($Id->{5}->[$i] ne '.') {
		$text->insert(undef, undef, undef, $Id->{5}->[$i] . " ");
	    }

	    if ($Id->{6}->[$i] ne '.') {
		$text->insert(undef, undef, undef, $Id->{6}->[$i] . " ");
	    }

	    $text->insert(undef, undef, undef, "\n");
	}
    }

    $text->thaw();
}

### font_information

sub clear_font_information {
    my $text = $Window->{text_font_fontinformation};

    $text->freeze();

    $text->set_point(0);
    $text->forward_delete($text->get_length());

    $text->thaw();
}

sub show_font_information {
    my $text = $Window->{text_font_fontinformation};

    $text->freeze();

    $text->set_point(0);
    $text->forward_delete($text->get_length());

    if ($I_Font) {
	$text->insert(undef, undef, undef, "Font: ".$I_Font."\n");

	my %faps = &dfontmgr::get_failed($I_FontCategory, $I_Font);

	my @aps = ();
	foreach my $a (@App) {
	    next if ($faps{$a});
	    
	    my @cs = &dfontmgr::get_app_categories($a);
	    
	    push(@aps, $a) if (grep($I_FontCategory eq $_, @cs));
	}

	$text->insert(undef, undef, undef,
		      "Succeeded: " . join(' ', @aps) . "\n");
	$text->insert(undef, undef, undef, "Failed: \n");

	foreach my $a (keys(%faps)) {
	    $text->insert(undef, undef, undef,
			  "\t" . $a . " (" . $faps{$a} . ")\n");
	}

	my @hints = &dfontmgr::get_hints($I_FontCategory, $I_Font);
	my $lhints = &dfontmgr::convert_hints2hintfile(@hints);
	my $flag = 0;

	$text->insert(undef, undef, undef, "\nHints: ");
	$text->insert(undef, undef, undef, $lhints);
	
	if (0) {
	    foreach my $h (@hints) {
		if ($h =~ /^--(.*)/) {
		    $text->insert(undef, undef, undef, "\n\t$1");
		    $flag = 1;
		} else {
		    $text->insert(undef, undef, undef, " =") if ($flag);
		    $text->insert(undef, undef, undef, " " .$h);
		    $flag = 0;
		}
	    }
	}
    }

    $text->thaw();
}

### clist_font_fontinfo

sub vadj_clist_font_fontinformation {
    my $i = shift;
    
    my $k = ($i > 3) ? $i - 3 : 0;

    my $vadj = $Window->{scrolledwindow9}->get_vadjustment();
    
    $vadj->set_value(($k / @Font) * $vadj->upper());
    $vadj->value_changed();
}

sub select_clist_font_fontinformation {
    my $font = shift;

    for (my $i = 0; $i < @Font; $i++) {
	if ($Font[$i] eq $font) {
	    $Window->{clist_font_fontinformation}->select_row($i, -1);
	    vadj_clist_font_fontinformation($i);
	}
    }
}

sub select_clist_font_category {
    my $category = shift;

    
    for (my $i = 0; $i < @FontCategory; $i++) {
	if ($FontCategory[$i] eq $category) {
	    $Window->{clist_font_category}->select_row($i, -1);
	}
    }
}

### Statusbar

my $SBar = 0;

sub statusbar_msg {
    my $msg = shift;
    $SBar++;
    return $Window->{statusbar1}->push($ContextId, $msg);
}

sub statusbar_check {
    if ($SBar) {
	$Window->{statusbar1}->pop($ContextId);
	$SBar--;
    }
}

### Invoke Defoma

sub invoke_defoma {
    my $com = shift;
    my $msg = shift;
    my $noupdate = shift;

    statusbar_msg($msg) if ($msg);
    mouse_wait();

    while (Gtk->events_pending()) {
	Gtk->main_iteration();
    }

    my $r = &dfontmgr::invoke_defoma($com);
    
    mouse_normal();

    update() unless ($noupdate);

    statusbar_check();

    if ($r == 0) {
	statusbar_msg($msg . "done.") if ($msg);
    } else {
	statusbar_msg("Failed to execute defoma.");
    }
}

### Register Fonts

sub dest_hintfile {
    my $font = shift;
    
    my $destfile = substr($font, 1);
    $destfile =~ s/\//_/g;
    $destfile = "$DestDir/$destfile";

    if (-e $destfile . ".hints") {
	my $cnt = 1;
	while (-e $destfile . ".$cnt.hints") {
	    $cnt++;
	}
	$destfile .= ".$cnt.hints";
    } else {
	$destfile .= ".hints";
    }

    return $destfile;
}

sub wizard_check_abort {
    if (&defomawizard::get_status() == 255) {
	&defomawizard::destroy();
	statusbar_msg("Registration aborted!");
	return 1;
    }
    return 0;
}

sub register_fonts {
    my @fonts = @_;
    my $tt = 'Font Registration Wizard';
    my $r;
    my $t;
    my $c;
    my $notroot = 0;

    # STEP 0: Check if you are root.

      unless (&dfontmgr::check_root()) {
	  $t = <<EOF
$NotRoot you can\'t register a font. Still, Dfontmgr can help create a Hintfile for a font in your home directory if it doesn\'t exist.
Do you want to continue?
EOF
    ;
	  $r = &defomawizard::main(type => 'yesno', title => $tt, text => $t);
	  if (&defomawizard::get_status() || $r ne 'yes') {
	      &defomawizard::destroy();
	      return;
	  }

	  $notroot = 1;
      }
    
  LOOP: foreach my $f (@fonts) {
      # STEP 1: exclude the inappropriate font path.
      
      if ($f =~ /^\/var\/lib\/defoma/) {
	  $t = <<EOF
Registering $f...
This file exists under defoma system directory. 
Skipped.
EOF
    ;
	  &defomawizard::main(type => 'note', title => $tt, text => $t);
	  return if (wizard_check_abort());
	  next;
      } elsif (! -f $f) {
	  $t = <<EOF
Registering $f...
This is not a file but a symlink or a directory or something like that.
Skipped.
EOF
    ;
	  &defomawizard::main(type => 'note', title => $tt, text => $t);
	  return if (wizard_check_abort());
	  next;
      }

      # STEP 2: Check if it is already registered.
      
      if (($c = &dfontmgr::exist_font($f)) ne '') {
	  $Window->{notebook1}->set_page(0);
	  select_clist_font_category($c);
	  select_clist_font_fontinformation($f);
	  
	  if (@fonts == 1) {
	      statusbar_msg("Font already registered. ");
	  } else {
	      $t = <<EOF
Registering $f...
This font is already registered in category $c.
Skipped.
EOF
    ;
	      &defomawizard::main(type => 'note', title => $tt, text => $t);
	      return if (wizard_check_abort());
	  }

	  next;
      }

      # STEP 4: Check if there is already hintfile for the font.

      my $hintfile = seek_hintfile($f, $tt);
      return if (wizard_check_abort());
      next if (&defomawizard::get_status());
      
      unless (defined($hintfile)) {
	  # STEP 5: New font. Decide category.
	  
	  my $c = &dfontmgr::get_file_category($f);

	  if ($c eq 'hintfile') {
	      $t = <<EOF
Registering $f...
You specified a hintfile.
Do you want to register all fonts described in this hintfile?
EOF
    ;

	      $r = &defomawizard::main(type => 'yesno', title => $tt,
				       text => $t);
	      return if (wizard_check_abort());
	      if (&defomawizard::get_status() || $r eq 'no') {
		  $t = <<EOF
Skipped registering $f.
EOF
    ;
		  &defomawizard::main(type => 'note', title => $tt,
				      text => $t);
		  return if (wizard_check_abort());
		  next;
	      }

	      invoke_defoma("font register-all $f",
			    "Registering all fonts in $f... ");
	      next;
	  } elsif ($c eq 'unknown') {
	      $t = <<EOF
Registering $f...
Category unknown. 
Select category when you know it. 
Select SKIP when you want to skip this font. 
Select INPUT when you want to input it manually.
EOF
    ;
	      my @cs = ('SKIP', 'INPUT', 'type1', 'cid', 'truetype', 'type3',
		       'cmap');
	      
	      $r = &defomawizard::main(type => 'singlelist', title => $tt,
				       text => $t, items => \@cs);
	      return if (wizard_check_abort());
	      next if (&defomawizard::get_status() || $r == 0);
	      
	      if ($r == 1) {
		  $t = <<EOF
Registering $f...
Please specify its category.
Combination of small letters and digits is allowed.
If you want to skip this font, just enter.
EOF
    ;
		  while (1) {
		      $r = &defomawizard::main(type => 'entry', title => $tt,
					       text => $t);
		      return if (wizard_check_abort());
		      next LOOP if (&defomawizard::get_status() || $r eq '');
		      next if ($r !~ /^[a-z0-9-]+$/);
		      if (&dfontmgr::check_system_categories($r)) {
			  $t .= "$r is system-defined category.\n";
			  next;
		      }
		      
		      last;
		  }
		  
		  $c = $r;
	      } else {
		  $c = $cs[$r];
	      }
	  }

	  # STEP 6: Run defoma-hints to generate Hints.
	  
	  my @hints = &defomahints::main($c, $f);
	  
	  if (@hints == 0) {
	      return if (wizard_check_abort());
	      $t = <<EOF
Registering $f...
Failed to generate Hints:
EOF
    ;
	      $t .= "\t" . &defomahints::get_status() . "\n";
	      $t .= <<EOF
Do you want to continue registering this font?
If you answer YES, you have to input its Hints manually.
If you want to skip this font, answer NO.
EOF
    ;
	      $r = &defomawizard::main(type => 'yesno', title => $tt,
				       text => $t);
	      return if (wizard_check_abort());
	      next if (! defined($r) || $r ne 'yes');
	      push(@hints, "category $c");
	      push(@hints, "begin $f");
	      push(@hints, "  <remove this line and insert Hints here..>");
	      push(@hints, "end");
	  }
	  
	  $hintfile = dest_hintfile($f);
	  &dfontmgr::write_to_file($hintfile, @hints);
      } elsif ($notroot) {
	  $t = <<EOF
Hintfile for $f is found as:
\t$hintfile
Further process is skipped because $NotRoot.
EOF
    ;
	  &defomawizard::main(type => 'note', title => $tt, text => $t);
	  return if (wizard_check_abort());
	  next;
      }

      # STEP 7: Change Hints.

      change_hintfile($f, $hintfile);
      return if (wizard_check_abort());
      next if (&defomawizard::get_status());

      # STEP 8: Register.

      if ($notroot) {
	  $t = <<EOF
Hintfile for $f is generated as:
\t$hintfile
Further process is skipped because $NotRoot.
EOF
    ;
	  &defomawizard::main(type => 'note', title => $tt, text => $t);
	  return if (wizard_check_abort());
	  next;
      }

      invoke_defoma("font register-one $hintfile $f",
		    "Registering $f... ");
      
      if (($c = &dfontmgr::exist_font($f)) ne '') {
	  $Window->{notebook1}->set_page(0);
	  select_clist_font_category($c);
	  select_clist_font_fontinformation($f);
	  statusbar_msg("$f is successfully registered.");
      } else {
	  &defomawizard::main(type => 'note', title => $tt,
			      text => "Failed to register $f.");
	  return if (wizard_check_abort());
      }
  }

    &defomawizard::destroy();
}

sub seek_hintfile_examples {
    my $font = shift;
    my $title = shift;
    
    $font =~ /^(.*)\/(.+)$/;
    my $fontfile = $2;
    my $exfile = "$fontfile.hints";
    $exfile =~ tr/A-Z/a-z/;

    my @files = &dfontmgr::get_hintfiles($ExDir);
    return undef if (! grep($_ eq $exfile, @files));

    my $t = <<EOF
Sample Hintfile for $fontfile is found in:
\t$ExDir/$exfile
Use this sample as its Hints?
EOF
    ;

    my $r = &defomawizard::main(type => 'yesno', text => $t, title => $title);
    return undef if (&defomawizard::get_status());

    my $srcfile = "$ExDir/$exfile";
    my $destfile = dest_hintfile($font);

    my @lines = &dfontmgr::read_from_file($srcfile);
    foreach my $i (@lines) {
	if ($i =~ /^begin[ \t]+/) {
	    $i = "begin $font";
	}
    }

    &dfontmgr::write_to_file($destfile, @lines);

    return $destfile;
}

sub seek_hintfile_etc {
    my $font = shift;
    my $title = shift;

    my @files = &dfontmgr::get_hintfiles($EtcDir);

    foreach my $f (@files) {
	my @l = &dfontmgr::read_from_file("$EtcDir/$f");
	foreach (@l) {
	    if (/^begin[ \t]+([^ \t]+)[ \t]*/) {
		if ($1 eq $font) {
		    my $t = <<EOF
Hintfile for $font is found in:
\t$EtcDir/$f
Use this hintfile?
EOF
    ;
		    my $r = &defomawizard::main(type => 'yesno', text => $t,
						title => $title);
		    return undef if (&defomawizard::get_status());
		    return "$EtcDir/$f" if ($r eq 'yes');
		}
	    }
	}
    }

    return undef;
}

sub seek_hintfile {
    my $font = shift;
    my $title = shift;

    my $r = seek_hintfile_etc($font, $title);
    return undef if (&defomawizard::get_status());
    return $r if (defined($r));

    return seek_hintfile_examples($font, $title);
}

### Change Hints

sub change_hintfile {
    my $font = shift;
    my $hintfilepath = shift;

    my @hints = &dfontmgr::read_from_file($hintfilepath);
    
    my $t = "Editting hintfile:\n\t$hintfilepath\n";
    $t .= <<EOF
When editting hintfile is finished and you want to reflect the change to defoma, click Next button.
When you want to discard the change, click Cancel button.
EOF
    ;

    my $l = 0;
    my $c = 0;
    for (my $i = 0; $i < @hints; $i++) {
	if ($hints[$i] =~ /^begin[ \t]+([^ \t]+)[ \t]*/) {
	    if ($1 eq $font) {
#		$l = ($i - 1) / scalar(@hints);
		$l = $c;
		last;
	    }
	}
	$c += length($hints[$i]) + 1;
    }

    my $r = &defomawizard::main(type => 'text', title => 'Edit Hintfile',
				text => $t, preposition => $l, 
				pretext => join("\n", @hints, "\n"));
    return 1 if (&defomawizard::get_status());
    
    &dfontmgr::write_to_file($hintfilepath, split(/\n/, $r));
}

#===============================================================================
#=== Below are the default signal handlers for 'window1' class
#===============================================================================
sub about_Form {
    my ($class) = @_;
    my $gtkversion = 
        Gtk->major_version.".".
        Gtk->minor_version.".".
        Gtk->micro_version;
    my $name = $0;
    my $message = 
        __PACKAGE__." ("._("version")." $VERSION - $DATE)\n".
        _("Written by")." $AUTHOR \n\n".
        _("No description")." \n\n".
        "Gtk ".     _("version").": $gtkversion\n".
        "Gtk-Perl "._("version").": $Gtk::VERSION\n".
        _("run from file").": $name";
    __PACKAGE__->message_box($message, _("About")." \u".__PACKAGE__, [_('Dismiss'), _('Quit Program')], 1,
        "$Glade::PerlRun::pixmaps_directory/glade2perl_logo.xpm", 'left' );
} # End of sub about_Form

sub destroy_Form {
    my ($class, $data, $object, $instance) = @_;
    Gtk->main_quit; 
} # End of sub destroy_Form

sub toplevel_hide    { shift->get_toplevel->hide    }
sub toplevel_close   { shift->get_toplevel->close   }
sub toplevel_destroy { shift->get_toplevel->destroy }

#==============================================================================
#=== Below are the signal handlers for 'window1' class 
#==============================================================================

sub on_button_app_idcache_addalias_clicked {
    statusbar_check();
    
    unless ($I_App && $I_IdCache && $I_Id && exists($Id->{hash01}->{$I_Id})) {
	statusbar_msg("Select one id/font pair from the list below.");
	return;
    }

    unless ($Id->{2}->[$Id->{hash01}->{$I_Id}] =~ /^Sr/) {
	statusbar_msg("Select Real id/font pair.");
	return;
    }

    $I_Id =~ /^([^ ]+) ([^ ]+)$/;

    my $text = "Input Alias of $1 ($2).";
    my $alias = &defomawizard::main(type => 'entry', text => $text,
				    title => 'Add User-defined Alias');
    &defomawizard::destroy();

    return unless(defined($alias));
    return if ($alias eq '');

    if ($alias =~ /[ \t]/) {
	statusbar_msg("Space is not allowed.");
	return;
    }

    if (&dfontmgr::check_root()) {
	invoke_defoma("id add-alias $I_App/$I_IdCache $I_Id $alias",
		      "Adding alias... ");
    } else {
	statusbar_msg("$NotRoot.");
	return;
    }
}

sub on_button_app_idcache_deletealias_clicked {
    statusbar_check();
    
    unless ($I_App && $I_IdCache && $I_Id && exists($Id->{hash01}->{$I_Id})) {
	statusbar_msg("Select one id/font pair from the list below.");
	return;
    }

    unless ($Id->{2}->[$Id->{hash01}->{$I_Id}] =~ /^Ua/) {
	statusbar_msg("Select U-Alias id/font pair.");
	return;
    }

    if (&dfontmgr::check_root()) {
	invoke_defoma("id remove-alias $I_App/$I_IdCache $I_Id",
		      "Removing alias... ");
    } else {
	statusbar_msg("$NotRoot.");
	return;
    }
}
    
sub on_button_app_idcache_mark {
    my $com = shift;
    statusbar_check();
    
    unless ($I_App && $I_IdCache && $I_Id) {
	statusbar_msg("Select one id/font pair from the list below.");
	return;
    }

    if (&dfontmgr::check_root()) {
	invoke_defoma("id $com $I_App/$I_IdCache $I_Id",
		      "Accessing Id Cache... ");
    } else {
	statusbar_msg("$NotRoot.");
	return;
    }
}

sub on_button_app_idcache_install_clicked {
    on_button_app_idcache_mark('install');
}

sub on_button_app_idcache_uninstall_clicked {
    on_button_app_idcache_mark('exclude');
}

sub on_button_app_idcache_unset_clicked {
    on_button_app_idcache_mark('unset');
}

sub on_button_font_changehints_clicked {
    statusbar_check();

    my $t;
    my $tt = 'Change Hints';
    my $f = $I_Font;
    my $c = $I_FontCategory;
    my $r;

    unless ($c && $f) {
	statusbar_msg("Select font you want to unregister.");
	return;
    }

    if (&dfontmgr::check_system_categories($c)) {
	statusbar_msg("Not permitted to change Hints of $c font.");
	return;
    }

    if (&dfontmgr::check_root()) {
	my $hintfile = seek_hintfile_etc($f, $tt);
	return if (wizard_check_abort());

	unless (defined($hintfile)) {
	    $hintfile = dest_hintfile($f);
	    my @hints = &dfontmgr::get_hints($c, $f);
	    my $lhints = &dfontmgr::convert_hints2hintfile(@hints);

	    &dfontmgr::write_to_file($hintfile, "category $I_FontCategory",
				     "begin $f" . $lhints, "end");
	}

	change_hintfile($f, $hintfile);
	return if (wizard_check_abort());
	if (&defomawizard::get_status() == 0) {
	    invoke_defoma("font reregister-all $hintfile",
			  "Re-registering $f... ");
	}

	&defomawizard::destroy();
    } else {
	statusbar_msg("$NotRoot.");
    }
}

my $Prefer = 0;

sub on_button_font_registerfont_clicked {
    statusbar_check();

    my $t = <<EOF
You can register font(s) by drag-and-dropping the font files. Click Next if you still prefer selecting the font file using font selecter.
EOF
    ;

    if ($Prefer == 0) {
	&defomawizard::main(type => 'note', text => $t, title => '');
	&defomawizard::destroy();
	return if (&defomawizard::get_status());
    }

    $Prefer = 1;
    
    my $font = fileselection1->app_run();
    register_fonts($font) if ($font ne '');
}

sub on_button_font_unregisterfont_clicked {
    statusbar_check();

    unless ($I_FontCategory && $I_Font) {
	statusbar_msg("Select font you want to unregister.");
	return;
    }

    if (&dfontmgr::check_root()) {
	invoke_defoma("font unregister $I_FontCategory $I_Font",
		      "Unregistering $I_Font... ");
    } else {
	statusbar_msg("$NotRoot.");
    }

    return;
}

sub on_button_app_common {
    my $com = shift;
    my $mode = shift;
    
    statusbar_check();

    unless ($I_App) {
	statusbar_msg("Select application.");
	return;
    }

    if (&dfontmgr::check_root()) {
	invoke_defoma("app $com $I_App",
		      "$mode font configuration of $I_App... ");
    } else {
	statusbar_msg("$NotRoot.");
    }
}

sub on_button_app_update_clicked {
    on_button_app_common("update", "Updating");
}

sub on_button_app_clean_clicked {
    on_button_app_common("clean", "Cleaning up");
}

sub on_button_app_purge_clicked {
    on_button_app_common("purge", "Purging");
}

sub on_button_app_ignore_clicked {
    statusbar_check();

    unless ($I_App) {
	statusbar_msg("Select application.");
	return;
    }
    unless (&dfontmgr::check_root()) {
	statusbar_msg("$NotRoot.");
	return;
    }

    my @items = &dfontmgr::get_app_categories($I_App);
    my @ignore = &dfontmgr::get_app_ignore($I_App);
    my @onoff;
    foreach my $i (@items) {
	push(@onoff, grep($i eq $_, @ignore) ? 1 : 0);
    }

    my $t = <<EOF
Please select/deselect categories you want to set/release 'ignore'.
Highlithed items will be ignored.
EOF
    ;

    my @r = &defomawizard::main(type => 'multilist', text => $t,
				title => "Select Categories",
				items => \@items, onoff => \@onoff);
    &defomawizard::destroy();

    return if (&defomawizard::get_status());

    my (@ics, @rics);

    for (my $i = 0; $i < @items; $i++) {
	push(@ics, $items[$i]) if ($r[$i] && ! $onoff[$i]);
	push(@rics, $items[$i]) if (! $r[$i] && $onoff[$i]);
    }

    invoke_defoma("app ignore $I_App @ics", undef, scalar(@rics)) if (@ics);
    invoke_defoma("app update $I_App @rics") if (@rics);
}

sub on_clist_app_application_select_row {
    my ($class, $data, $object, $instance, $row) = @_;
    my $i;

    statusbar_check();

    $I_App = $App[$row];

    @IdCache = dfontmgr::get_id_caches($App[$row]);

    my $opmenu_idcache = $Window->{'optionmenu_app_idcache'};
    $opmenu_idcache->remove_menu();
    
    $OpMenu_IdCache && $OpMenu_IdCache->clear();
    $OpMenu_IdCache = new OptionMenu(\&activate_optionmenu_idcache);

    $Update || undef $I_IdCache;

    if (@IdCache) {
	foreach $i (@IdCache) {
	    $i = '#DEFAULT#' if ($i eq '');
	    $OpMenu_IdCache->add($i);
	}

	$opmenu_idcache->set_menu($OpMenu_IdCache->{menu});

	my $s = 0;
	if ($I_IdCache && exists($OpMenu_IdCache->{label}->{$I_IdCache})) {
	    $s = $OpMenu_IdCache->{label}->{$I_IdCache};
	}
	
	$OpMenu_IdCache->{menuitem}->[$s]->activate();
    } else {
	$Window->{'clist_app_idcache'}->clear();
	undef $I_IdCache;
	$opmenu_idcache->set_menu($OpMenu_IdCache->{menu});
    }

    show_app_information();
}

sub on_clist_app_idcache_click_column {
    my ($class, $data, $object, $instance, $column) = @_;

    statusbar_check();

    $Id_Sort = $column;
    update_clist_app_idcache();
}

sub on_clist_app_idcache_select_row {
    my ($class, $data, $object, $instance, $row) = @_;

    $Ignore && return;

    statusbar_check();

    my $i = $Id_Index[$row];
    $I_Id = $Id->{0}->[$i] . ' '. $Id->{1}->[$i];

    show_app_information_with_id();
}

sub on_clist_font_category_select_row {
    my ($class, $data, $object, $instance, $row) = @_;

    statusbar_check();

    $I_Font = '';
    $I_FontCategory = $FontCategory[$row];
    @Font = dfontmgr::get_fonts($FontCategory[$row]);
    @Font = sort { $a cmp $b } (@Font);
    
    my $clist_font = $Window->{'clist_font_fontinformation'};

    $clist_font->freeze();
    $clist_font->clear();

    foreach my $i (@Font) {
	$clist_font->append($i);
    }

    clear_font_information();

    $clist_font->thaw();
}

sub on_clist_font_fontinformation_select_row {
    my ($class, $data, $object, $instance, $row) = @_;

    statusbar_check();

    $I_Font = $Font[$row];

    show_font_information();
}

sub on_quit_activate {
    Gtk->main_quit();
}

sub on_window1_delete_event {
    Gtk->main_quit();
    return 0;
}

sub on_window1_drag_drop {
    my ($window, $data, $object, $instance, $context, $x, $y, $time) = @_;
    my $atom = $context->targets();

    if ($atom) {
	$window->drag_get_data($context, $atom, $time);
	return 1;
    }

    statusbar_msg("No Atom found.");
    
    return 0;
}

sub on_window1_drag_motion {
    my ($class, $data, $object, $instance, $context, $x, $y, $time) = @_;

    $context->status($context->suggested_action(), $time);
    return 1;
}

sub on_window1_drag_data_get {
    print "get: ", join(' ', @_), "\n";
} # End of sub on_window1_drag_data_get

sub on_window1_drag_data_received {
    my ($class, $n0, $n1, $n2, $context, $x, $y, $data, $info, $time) = @_;

    if ($data->format() == 8 && $data->length() >= 0) {
	my @items;
	foreach my $f (split(/\r?\n/, $data->data())) {
	    if ($f =~ /^file:\//) {
		push(@items, '/'.$');
	    }
	}

	$context->finish(1, 0, $time);

	register_fonts(@items);
	
	return;
    }

    $context->finish(0, 0, $time);
}

1;

__END__

#===============================================================================
#==== Documentation
#===============================================================================
=pod

=head1 NAME

Dfontmgr - version 0.01 2001ǯ  9 29  23:58:32 JST

No description

=head1 SYNOPSIS

 use Dfontmgr;

 To construct the window object and show it call
 
 Gtk->init;
 my $window = window1->new;
 $window->TOPLEVEL->show;
 Gtk->main;
 
 OR use the shorthand for the above calls
 
 window1->app_run;

=head1 DESCRIPTION

Unfortunately, the author has not yet written any documentation :-(

=head1 AUTHOR

Yasuhiro Take,,, <redstar\@laminar>

=cut
