## -*- perl -*-
## ----------------------------------------------------------------------
## DebianDoc_SGML/Format/SGML: SGML output format generator
## ----------------------------------------------------------------------
## Copyright (C) 2006 Osamu Aoki
## Copyright (C) 1998-2004 Ardo van Rangelrooij
## Copyright (C) 1996 Ian Jackson
##
## This is free software; see the GNU General Public Licence
## version 2 or later for copying conditions.  There is NO warranty.
## ----------------------------------------------------------------------

## ----------------------------------------------------------------------
## package interface definition
package DebianDoc_SGML::Format::SGML;
use strict;
use vars qw( @ISA @EXPORT );
use Exporter;
@ISA = ( 'Exporter' );
@EXPORT = qw ();

## ----------------------------------------------------------------------
## import packages
use File::Basename;
use File::Spec;
use I18N::LangTags qw( locale2language_tag );
use SGMLS::Output;
use Text::Format;
use URI;

## ----------------------------------------------------------------------
my %locale = %DebianDoc_SGML::Format::Driver::locale;
my %cdata = %DebianDoc_SGML::Format::Driver::cdata;
my %sdata = %DebianDoc_SGML::Format::Driver::sdata;

# In SGML, sections are sect,sect1,sect2
use vars qw( @toc_items );
@toc_items = (
		   'sect',
		   'sect1',
		   'sect2'
		   );

## ----------------------------------------------------------------------
## file name definitions
my $content = '';
if ( $DebianDoc_SGML::Format::Driver::opt_c )
{
    my $locale = $DebianDoc_SGML::Format::Driver::locale;
    $locale =~ s/[\.@].*//;
    my $language_tag = lc( locale2language_tag( $DebianDoc_SGML::Format::Driver::opt_l ) );
    $language_tag = 'en' if $language_tag eq undef;
    my $charset = ".$locale{ 'charset' }"
	if length( $locale{ 'charset' } )
	    && $DebianDoc_SGML::Format::Driver::locale =~ m/\./;
    $content = ".$language_tag$charset";
}
if ( $DebianDoc_SGML::Format::Driver::opt_C )
{
    my $language_tag = lc( locale2language_tag( $DebianDoc_SGML::Format::Driver::opt_l ) );
    $language_tag = 'en' if $language_tag eq undef;
    $content = ".$language_tag";
}
my $basename = $DebianDoc_SGML::Format::Driver::opt_b;
my $prefix = '';
if ( $DebianDoc_SGML::Format::Driver::opt_b =~ m,/, )
{
    $basename = dirname( $DebianDoc_SGML::Format::Driver::opt_b );
    $prefix = basename( $DebianDoc_SGML::Format::Driver::opt_b ) . '-';
}
my $topname = length( $DebianDoc_SGML::Format::Driver::opt_t )
    ? $DebianDoc_SGML::Format::Driver::opt_t : 'index';
my $extension = length( $DebianDoc_SGML::Format::Driver::opt_e )
    ? ".$DebianDoc_SGML::Format::Driver::opt_e" : '.sgml';
my $single = $DebianDoc_SGML::Format::Driver::opt_1;

## ----------------------------------------------------------------------
## directory definition and creation
my $directory = "$basename$extension";
-d "$directory" || mkdir( "$directory", 0777 )
    || die "cannot make directory \`$directory': $!\n";

## ----------------------------------------------------------------------
## layout definition
$DebianDoc_SGML::Format::Driver::indent_level = 1;
my $text = new Text::Format;
$text->columns( 79 );
$text->firstIndent( 0 );
$text->extraSpace( 1 );

## ----------------------------------------------------------------------
## global variables
use vars qw( %next %previous );

use vars qw( $titlepag $toc );
use vars qw( $title );
use vars qw( @author @translator );
use vars qw( $version );
use vars qw( $abstract );
use vars qw( $copyright );
use vars qw( @copyrightsummary );

use vars qw( @toc_entry_id %toc_entry_chapter_id );
use vars qw( %toc_entry_name %toc_entry_level %toc_entry_fragment );

use vars qw( $chapter_id @chapter_id );
use vars qw( $chapter_type %chapter_type );
use vars qw( $chapter_num %chapter_num );
use vars qw( $chapter_title %chapter_title );
use vars qw( %chapter );

use vars qw( $section_id @section_id );
use vars qw( $section_num %section_num );
use vars qw( $section_title %section_title );
use vars qw( $section_chapter_id %section_chapter_id );

use vars qw( $subsection_id @subsection_id );
use vars qw( $subsection_num %subsection_num );
use vars qw( $subsection_title %subsection_title );
use vars qw( $subsection_chapter_id %subsection_chapter_id );

use vars qw( $footnote @footnote @footnote_chapter_id );
use vars qw( $comment @comment @comment_editor @comment_chapter_id );


## ----------------------------------------------------------------------
## book output subroutines
## ----------------------------------------------------------------------
sub _output_start_book
{
}
sub _output_end_book
{
    $chapter_id = $topname;
    my $file = "$prefix$chapter_id$content$extension";
    push_output( 'file', File::Spec->catfile( "$directory", "$file" ) );
    _html_head( $extension );
    if ( ! $DebianDoc_SGML::Format::Driver::opt_1 )
    {
        _html_tail();
        pop_output();
    }
    foreach $chapter_id ( @chapter_id )
    {
	my $idx;
	$idx = $chapter_id;
	$idx =~ s/^ch-//;
	$idx =~ s/^ap-//;
	$idx =~ s/_/-/g;
	$idx =~ s/ /-/g;
	if ( ! $DebianDoc_SGML::Format::Driver::opt_1 )
	{
	    my $file = "$prefix$idx$content$extension";
	    push_output( 'file',
			 File::Spec->catfile( "$directory", "$file" ) );
	}
	output( $chapter{ $chapter_id } );
	if ( ! $DebianDoc_SGML::Format::Driver::opt_1 )
	{
	    pop_output();
	}
    }
    if ( $DebianDoc_SGML::Format::Driver::opt_1 )
    {
	$chapter_id = $topname;
	_html_tail();
	pop_output();
    }
}
sub _html_head
{
    output( "<!DOCTYPE debiandoc PUBLIC \"-//DebianDoc//DTD DebianDoc//EN\" [\n" );
#    output( "<!ENTITY % sgml.features \"INCLUDE\">\n" );
#    output( "<!ENTITY % xml.features  \"IGNORE\">\n" );
    if ( ! $DebianDoc_SGML::Format::Driver::opt_1 )
    {
        output( "\n" );
	output( "<!-- subdoc list start -->\n" );
	foreach my $id ( @chapter_id )
	{
	    my $idx = $id;
	    $idx =~ s/^ch-//;
	    $idx =~ s/^ap-//;
	    $idx =~ s/_/-/g;
	    $idx =~ s/ /-/g;
    	    output( "<!ENTITY " . $idx . $_[0] . " SYSTEM \"" . $idx . $_[0] . "\" >\n" );
	}
	output( "<!-- subdoc list end -->\n" );
	output( "\n" );
    }
    output( "]>\n" );
    output( "\n" );

    output( "\n" );
    output( "<debiandoc>\n" );
    output( "\n" );
    output( "<book>\n" );
    output( "<!-- This may be encoded in iso-8859-1 for western languages. -->\n" );
    output( "<!-- This may be encoded in euc-jp for Japanese. -->\n" );
    output( "<!-- Make sure to convert files to UTF-8 encoding after conversion. -->\n" );
    output( "\n" );
    output( "<title>$title</title>\n" );
    output( "\n" );
    if ( $#author >= 0 )
    {
	foreach ( @author )
	{
	    my ($firstname, $surname) = split($_) ;
	    output( "<author>$_</author>\n" );
	}
	output( "\n" );
    }
    if ( $#translator >= 0 )
    {
	foreach ( @translator )
	{
	    output( "<author>$_</author>\n" );
	}
	output( "\n" );
    }
    output( "<version>$version</version>\n" );
    output( "\n" );
#    output( $titlepag ) if length( $titlepag );
    if ( length( $abstract ) )
    {
        output( "\n" );
        output( "<abstract>\n" );
	output( $abstract );
        output( "</abstract>\n" );
    }
    if ( length( $copyright ) )
    {
        output( "\n" );
        output( "<copyright>\n" );
	foreach my $copyline ( @copyrightsummary )
	{
            output( "<copyrightsummary>" );
            output( $copyline );
            output( "</copyrightsummary>\n" );
	}
	output( $copyright );
        output( "</copyright>\n" );
    }
    output( "\n" );
    output( "<toc $toc_items[$DebianDoc_SGML::Format::Driver::toc_detail]>\n" );
    output( "\n" );
    if ( ! $DebianDoc_SGML::Format::Driver::opt_1 )
    {
	output( "<!-- subdoc list start -->\n" );
	foreach my $id ( @chapter_id )
	{
	    my $idx = $id;
	    $idx =~ s/^ch-//;
	    $idx =~ s/^ap-//;
	    $idx =~ s/_/-/g;
	    $idx =~ s/ /-/g;
    	    output( "\&" . $idx . $_[0] . ";\n" );
	}
	output( "<!-- subdoc list end -->\n" );
	output( "\n" );
    }
    output( "\n" );
}

sub _html_tail
{
    output( "\n" );
    output( "</book>\n" );
    output( "\n" );
    output( "</debiandoc>\n" );
    output( "\n" );
}
## ----------------------------------------------------------------------
## title page output subroutines
## ----------------------------------------------------------------------
sub _output_titlepag
{
#    push_output( 'string' );
#    $titlepag = pop_output;
}

## ----------------------------------------------------------------------
## title output subroutines
## ----------------------------------------------------------------------
sub _output_title
{
    $title = $_[0];
}

## ----------------------------------------------------------------------
## author output subroutines
## ----------------------------------------------------------------------
sub _output_author
{
    push( @author, $_[0] );
}
## ----------------------------------------------------------------------
## translator output subroutines
## ----------------------------------------------------------------------
sub _output_translator
{
    push( @translator, $_[0] );
}

## ----------------------------------------------------------------------
## name output subroutines
## ----------------------------------------------------------------------
sub _output_name
{
    output( $_[0] );
}

## ----------------------------------------------------------------------
## version output subroutines
## ----------------------------------------------------------------------
sub _output_version
{
    $version = $_[0];
}

## ----------------------------------------------------------------------
## output_titlepagabstract output subroutines
## ----------------------------------------------------------------------
sub _output_abstract
{
    # Remove <p> tag to work with debiandoc <abstract>
    $_[0] =~ s/^<p>//;
    $_[0] =~ s/<\/p>$//;
    $_[0] =~ s/^\n//;
    $_[0] =~ s/\n$//;
    $abstract = $_[0];
}

## ----------------------------------------------------------------------
## copyright output subroutines
## ----------------------------------------------------------------------
sub _output_copyright
{
    push_output( 'string' );
    output( $_[0] );
    $copyright = pop_output;
}
sub _output_copyrightsummary
{
    push( @copyrightsummary, $_[0] );
}

## ----------------------------------------------------------------------
## table of contents output subroutines
## ----------------------------------------------------------------------
sub _output_toc
{
}
sub _output_tocentry
{
}

## ----------------------------------------------------------------------
## section output subroutines
## ----------------------------------------------------------------------
sub _output_chapter
{
    $chapter{ $chapter_id } = $_[0] . "</chapt>\n\n";
    $chapter_title{ $chapter_id } = $chapter_title;
    $chapter_num{ $chapter_id } = $chapter_num;
    $chapter_type{ $chapter_id } = $chapter_type;
    push( @chapter_id, $chapter_id );
}
sub _output_appendix
{
    $chapter{ $chapter_id } = $_[0] . "</appendix>\n\n";
    $chapter_title{ $chapter_id } = $chapter_title;
    $chapter_num{ $chapter_id } = $chapter_num;
    $chapter_type{ $chapter_id } = $chapter_type;
    push( @chapter_id, $chapter_id );

}
sub _output_sect
{
    output( "</sect>\n\n" );
}
sub _output_sect1
{
    output( "</sect1>\n\n" );
}
sub _output_sect2
{
    output( "</sect2>\n\n" );
}
sub _output_sect3
{
    output( "</sect3>\n\n" );
}
sub _output_sect4
{
    output( "</sect4>\n\n" );
}
sub _output_heading
{
    if ( $_[1] < 0 )
    {
	if ( length( $_[0] ) )
	{
	    $chapter_id = $_[3];
	    $chapter_type = ( $_[2] =~ m/^[A-Z]$/ ? 'appendix' : 'chapter');
	    $chapter_num = $_[2];
	    $chapter_title = $_[0];
	}
	my $idx;
	$idx=$_[3];
	$idx =~ s/^ch-//;
	$idx =~ s/^ap-//;
	$idx =~ s/_/-/g;
	$idx =~ s/ /-/g;
	output( "<chapt id=\"$idx\">" ) if $_[1] == -1;
	output( "<appendix id=\"$idx\">" ) if $_[1] == -2;
#	output( "<footnote id=\"$idx\">" ) if $_[1] == -3;
#	output( "<comment id=\"$idx\">" ) if $_[1] == -4;
	output( "<heading>" );
	output( "$_[0]" );
	output( "</heading>\n" );
    }
    else
    {
	my $idx;
	$idx=$_[3];
	$idx =~ s/^s-//;
	$idx =~ s/_/-/g;
	$idx =~ s/ /-/g;
	output( "<sect$_[1] id=\"$idx\">" ) if $_[1] > 0;
	output( "<sect id=\"$idx\">" ) if $_[1] == 0;
	if ( length( $_[0] ) )
	{
            output( "<heading>" );
	    output( $_[0] );
	    output( "</heading>\n" );
	}
    }
    output( "\n" );
}

## ----------------------------------------------------------------------
## paragraph output subroutines
## ----------------------------------------------------------------------
sub _output_p
{
    if ( length( $_[0] ) )
    {
	output( "<p>\n" );
	output( $text->format( "$_[0]\n" ) );
	output( "</p>\n" );
    }

}

## ----------------------------------------------------------------------
## example output subroutines
## ----------------------------------------------------------------------
sub _output_example
{
    $_[0] =~ s/\s+$/\n/;
    $_[0] =~ s/^\w*//; # remove white space only first line
    output( "<p>" ) if ( $DebianDoc_SGML::Format::Driver::opt_P );
    output( "<example>\n" );
    output( $_[0] );
    output( "</example>" );
    output( "</p>" ) if ( $DebianDoc_SGML::Format::Driver::opt_P );
    output( "\n" );
}

## ----------------------------------------------------------------------
## footnote output subroutines
## ----------------------------------------------------------------------
sub _output_footnotes
{
}
sub _output_footnote
{
    output( "<footnote>" );
    output( $_[0] );
    output( "</footnote>" );
}

## ----------------------------------------------------------------------
## comment output subroutines
## ----------------------------------------------------------------------
sub _output_comments
{
}
sub _output_comment
{
    output( "<comment editor=\"$_[1]\">");
    output( $_[0]);
    output( "</comment>");
}

## ----------------------------------------------------------------------
## list output subroutines
## ----------------------------------------------------------------------
sub _output_list
{
    output( "<p>" ) if ( $DebianDoc_SGML::Format::Driver::opt_P );
    output( "<list>\n" );
    output( $_[0] );
    output( "</list>" );
    output( "</p>" ) if ( $DebianDoc_SGML::Format::Driver::opt_P );
    output( "\n" );
}
sub _output_enumlist
{
    output( "<p>" ) if ( $DebianDoc_SGML::Format::Driver::opt_P );
    output( "<enumlist>\n" );
    output( $_[0] );
    output( "</enumlist>" );
    output( "</p>" ) if ( $DebianDoc_SGML::Format::Driver::opt_P );
    output( "\n" );
}
sub _output_taglist
{
    output( "<p>" ) if ( $DebianDoc_SGML::Format::Driver::opt_P );
    output( "<taglist>\n" );
    output( $_[0] );
    output( "</taglist>" );
    output( "</p>" ) if ( $DebianDoc_SGML::Format::Driver::opt_P );
    output( "\n" );
}
sub _output_list_tag
{
}
sub _output_enumlist_tag
{
}
sub _output_taglist_tag
{
}
sub _output_list_item
{
#    $_[0] =~ s/^\n//;
#    $_[0] =~ s/\n$//;
#    $_[0] =~ s/^<p>//;
#    $_[0] =~ s/<\/p>$//;
    output( "<item>\n" );
    output( $_[0] );
    output( "</item>\n" );
}
sub _output_enumlist_item
{
#    $_[0] =~ s/^\n//;
#    $_[0] =~ s/^<p>\n//;
    output( "<item>\n" );
    output( $_[0] );
    output( "</item>\n" );
}
sub _output_taglist_item
{
#    $_[0] =~ s/^\n//;
#    $_[0] =~ s/^<p>\n//;
    foreach ( @{$_[1]} )
    {
        output( "<tag>" . $_ . "</tag>\n" );
    }
    output( "<item>\n" );
    output( $_[0] );
    output( "</item>\n" );
}

## ----------------------------------------------------------------------
## emph output subroutines
## ----------------------------------------------------------------------
sub _output_em
{
    output( "<em>$_[0]</em>" );
}
sub _output_strong
{
    output( "<strong>$_[0]</strong>" );
}
sub _output_var
{
    output( "<var>$_[0]</var>" );
}
sub _output_package
{
    output( "<package>$_[0]</package>" );
}
sub _output_prgn
{
    output( "<prgn>$_[0]</prgn>" );
}
sub _output_file
{
    output( "<file>$_[0]</file>" );
}
sub _output_tt
{
    output( "<tt>$_[0]</tt>" );
}
sub _output_qref
{
    my $idx = $_[2];
    $idx =~ s/^ch-//;
    $idx =~ s/^ap-//;
    $idx =~ s/^s-//;
    $idx =~ s/_/-/g;
    $idx =~ s/ /-/g;
    output( "<qref id=\"$idx\">\n" );
}

## ----------------------------------------------------------------------
## xref output subroutines
## ----------------------------------------------------------------------
sub _output_ref
{
    my $idx = $_[3];
    $idx =~ s/^ch-//;
    $idx =~ s/^ap-//;
    $idx =~ s/^s-//;
    $idx =~ s/_/-/g;
    $idx =~ s/ /-/g;
    output( "<ref id=\"$idx\">\n" );
}
sub _output_manref
{
    output( "<manref name=\"$_[0]\" section=\"$_[1]\">" );
}
sub _output_email
{
    if (    $DebianDoc_SGML::Format::Driver::in_author
	     || $DebianDoc_SGML::Format::Driver::in_translator )
    {
        output( " <email>" );
        output( $_[0] );
        output( "</email>" );
    }
    else
    {
        output( "<email>" );
        output( $_[0] );
        output( "</email>" );
    }
}
sub _output_ftpsite
{
    my $url = URI->new( $_[0] );
    output( "<ftpsite>$url</ftpsite>" );
}
sub _output_ftppath
{
    _output_url( "ftp://$_[0]$_[1]", $_[1] );
}
sub _output_httpsite
{
    my $url = URI->new( $_[0] );
    output( "<httpsite>$url</httpsite>" );
}
sub _output_httppath
{
    _output_url( "http://$_[0]$_[1]", $_[1] );
}
sub _output_url
{
#    my $url = URI->new( $_[0] );
#    $_[1] = $_[0] if $_[1] eq "";
    output( "<url id=\"" );
    _cdata( $_[1] );
    output( "\" name=\"$_[1]\">" );
}

## ----------------------------------------------------------------------
## data output subroutines
## ----------------------------------------------------------------------
sub _cdata
{
    ( $_ ) = @_;

    # special characters
    # do not replace it
    s/([<>&\"])/$cdata{ $1 }/g;

    # SDATA
    s/\\\|(\[\w+\s*\])\\\|/$sdata{ $1 }/g;

    output( $_ );
}
sub _sdata
{
    output( $sdata{ $_[0] } );
}

## ----------------------------------------------------------------------
## don't forget this
1;

## ----------------------------------------------------------------------
