/* dconf-client.c generated by valac, the Vala compiler
 * generated from dconf-client.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <dconf-engine.h>
#include <dconf.h>


#define DCONF_TYPE_CLIENT (dconf_client_get_type ())
#define DCONF_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DCONF_TYPE_CLIENT, DConfClient))
#define DCONF_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DCONF_TYPE_CLIENT, DConfClientClass))
#define DCONF_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DCONF_TYPE_CLIENT))
#define DCONF_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DCONF_TYPE_CLIENT))
#define DCONF_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DCONF_TYPE_CLIENT, DConfClientClass))

typedef struct _DConfClient DConfClient;
typedef struct _DConfClientClass DConfClientClass;
typedef struct _DConfClientPrivate DConfClientPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _dconf_engine_free0(var) ((var == NULL) ? NULL : (var = (dconf_engine_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
typedef struct _DconfClientCallAsyncData DconfClientCallAsyncData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DconfClientWriteAsyncData DconfClientWriteAsyncData;
typedef struct _DconfClientSetLockedAsyncData DconfClientSetLockedAsyncData;
typedef struct _DconfClientWatchAsyncData DconfClientWatchAsyncData;
typedef struct _DconfClientUnwatchAsyncData DconfClientUnwatchAsyncData;

typedef void (*DConfWatchFunc) (DConfClient* client, const char* path, char** items, int items_length1, const char* tag, void* user_data);
struct _DConfClient {
	GObject parent_instance;
	DConfClientPrivate * priv;
};

struct _DConfClientClass {
	GObjectClass parent_class;
};

struct _DConfClientPrivate {
	GDBusConnection* session;
	GDBusConnection* system;
	DConfWatchFunc watch_func;
	gpointer watch_func_target;
	GDestroyNotify watch_func_target_destroy_notify;
	DConfEngine* engine;
};

struct _DconfClientCallAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DConfClient* self;
	DConfEngineMessage dcem;
	char* tag;
	GCancellable* cancellable;
	GDBusConnection* connection;
	GDBusConnection* _tmp0_;
	GDBusConnection* _tmp1_;
	GDBusConnection* _tmp2_;
	GDBusConnection* _tmp3_;
	GDBusConnection* _tmp4_;
	GDBusConnection* _tmp5_;
	GVariantIter* _message_it;
	GVariant* message;
	GVariant* _tmp6_;
	GVariant* reply;
	GError * _inner_error_;
};

struct _DconfClientWriteAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DConfClient* self;
	char* key;
	GVariant* value;
	char* tag;
	GCancellable* cancellable;
	gboolean result;
	DConfEngineMessage _tmp1_;
	DConfEngineMessage _tmp0_;
	char* _tmp5_;
	char* _tmp4_;
	DConfEngineMessage _tmp3_;
	DConfEngineMessage _tmp2_;
	GError * _inner_error_;
};

struct _DconfClientSetLockedAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DConfClient* self;
	char* key;
	gboolean locked;
	GCancellable* cancellable;
	gboolean result;
	DConfEngineMessage _tmp2_;
	DConfEngineMessage _tmp1_;
	DConfEngineMessage _tmp0_;
	GError * _inner_error_;
};

struct _DconfClientWatchAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DConfClient* self;
	char* name;
	GCancellable* cancellable;
	gboolean result;
	DConfEngineMessage _tmp2_;
	DConfEngineMessage _tmp1_;
	DConfEngineMessage _tmp0_;
	GError * _inner_error_;
};

struct _DconfClientUnwatchAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DConfClient* self;
	char* name;
	GCancellable* cancellable;
	gboolean result;
	DConfEngineMessage _tmp2_;
	DConfEngineMessage _tmp1_;
	DConfEngineMessage _tmp0_;
	GError * _inner_error_;
};


static gpointer dconf_client_parent_class = NULL;

GType dconf_client_get_type (void) G_GNUC_CONST;
#define DCONF_CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DCONF_TYPE_CLIENT, DConfClientPrivate))
enum  {
	DCONF_CLIENT_DUMMY_PROPERTY
};
static void dconf_client_call_sync (DConfClient* self, DConfEngineMessage* dcem, char** tag, GCancellable* cancellable, GError** error);
static void dconf_client_call_async_data_free (gpointer _data);
static void dconf_client_call_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void dconf_client_call_async (DConfClient* self, DConfEngineMessage* dcem, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void dconf_client_call_finish (DConfClient* self, GAsyncResult* _res_, char** tag, GError** error);
static gboolean dconf_client_call_async_co (DconfClientCallAsyncData* data);
gboolean dconf_client_is_writable (DConfClient* self, const char* key);
gboolean dconf_client_write (DConfClient* self, const char* key, GVariant* value, char** tag, GCancellable* cancellable, GError** error);
static void dconf_client_write_async_data_free (gpointer _data);
static void dconf_client_write_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void dconf_client_write_async (DConfClient* self, const char* key, GVariant* value, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean dconf_client_write_finish (DConfClient* self, GAsyncResult* _res_, char** tag, GError** error);
static gboolean dconf_client_write_async_co (DconfClientWriteAsyncData* data);
gboolean dconf_client_write_many (DConfClient* self, const char* dir, char** rels, GVariant** values, int values_length1, char** tag, GCancellable* cancellable, GError** error);
gboolean dconf_client_set_locked (DConfClient* self, const char* path, gboolean locked, GCancellable* cancellable, GError** error);
static void dconf_client_set_locked_async_data_free (gpointer _data);
static void dconf_client_set_locked_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void dconf_client_set_locked_async (DConfClient* self, const char* key, gboolean locked, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean dconf_client_set_locked_finish (DConfClient* self, GAsyncResult* _res_, GError** error);
static gboolean dconf_client_set_locked_async_co (DconfClientSetLockedAsyncData* data);
GVariant* dconf_client_read (DConfClient* self, const char* key);
GVariant* dconf_client_read_default (DConfClient* self, const char* key);
GVariant* dconf_client_read_no_default (DConfClient* self, const char* key);
char** dconf_client_list (DConfClient* self, const char* dir, int* result_length1);
gboolean dconf_client_watch (DConfClient* self, const char* path, GCancellable* cancellable, GError** error);
static void dconf_client_watch_async_data_free (gpointer _data);
static void dconf_client_watch_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void dconf_client_watch_async (DConfClient* self, const char* name, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean dconf_client_watch_finish (DConfClient* self, GAsyncResult* _res_, GError** error);
static gboolean dconf_client_watch_async_co (DconfClientWatchAsyncData* data);
gboolean dconf_client_unwatch (DConfClient* self, const char* name, GCancellable* cancellable, GError** error);
static void dconf_client_unwatch_async_data_free (gpointer _data);
static void dconf_client_unwatch_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void dconf_client_unwatch_async (DConfClient* self, const char* name, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean dconf_client_unwatch_finish (DConfClient* self, GAsyncResult* _res_, GError** error);
static gboolean dconf_client_unwatch_async_co (DconfClientUnwatchAsyncData* data);
static GVariant* dconf_client_service_func (DConfEngineMessage* dcem);
static GVariant* _dconf_client_service_func_dconf_service_func (DConfEngineMessage* dcem);
DConfClient* dconf_client_new (const char* profile, DConfWatchFunc watch_func, void* watch_func_target, GDestroyNotify watch_func_target_destroy_notify);
DConfClient* dconf_client_construct (GType object_type, const char* profile, DConfWatchFunc watch_func, void* watch_func_target, GDestroyNotify watch_func_target_destroy_notify);
static void dconf_client_finalize (GObject* obj);
gboolean dconf_is_path (const char* str, GError** _error_);
gboolean dconf_is_key (const char* str, GError** _error_);
gboolean dconf_is_dir (const char* str, GError** _error_);
gboolean dconf_is_rel_path (const char* str, GError** _error_);
gboolean dconf_is_rel_key (const char* str, GError** _error_);
gboolean dconf_is_rel_dir (const char* str, GError** _error_);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dconf_client_call_sync (DConfClient* self, DConfEngineMessage* dcem, char** tag, GCancellable* cancellable, GError** error) {
	GError * _inner_error_;
	GDBusConnection* connection;
	g_return_if_fail (self != NULL);
	if (tag != NULL) {
		*tag = NULL;
	}
	_inner_error_ = NULL;
	connection = NULL;
	if ((*dcem).bus_type == 'e') {
		GDBusConnection* _tmp2_;
		if (self->priv->session == NULL) {
			GDBusConnection* _tmp0_;
			GDBusConnection* _tmp1_;
			_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, cancellable, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (connection);
				return;
			}
			self->priv->session = (_tmp1_ = _tmp0_, _g_object_unref0 (self->priv->session), _tmp1_);
		}
		connection = (_tmp2_ = _g_object_ref0 (self->priv->session), _g_object_unref0 (connection), _tmp2_);
	} else {
		GDBusConnection* _tmp5_;
		g_assert ((*dcem).bus_type == 'y');
		if (self->priv->system == NULL) {
			GDBusConnection* _tmp3_;
			GDBusConnection* _tmp4_;
			_tmp3_ = g_bus_get_sync (G_BUS_TYPE_SYSTEM, cancellable, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (connection);
				return;
			}
			self->priv->system = (_tmp4_ = _tmp3_, _g_object_unref0 (self->priv->system), _tmp4_);
		}
		connection = (_tmp5_ = _g_object_ref0 (self->priv->system), _g_object_unref0 (connection), _tmp5_);
	}
	{
		GVariantIter* _message_it;
		GVariant* message;
		_message_it = g_variant_iter_new ((*dcem).body);
		message = NULL;
		while (TRUE) {
			GVariant* _tmp6_;
			GVariant* reply;
			if (!((message = (_tmp6_ = g_variant_iter_next_value (_message_it), _g_variant_unref0 (message), _tmp6_)) != NULL)) {
				break;
			}
			reply = g_dbus_connection_call_sync (connection, (*dcem).destination, (*dcem).object_path, (*dcem).interface, (*dcem).method, message, (*dcem).reply_type, G_DBUS_CALL_FLAGS_NONE, -1, cancellable, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_variant_unref0 (message);
				_g_variant_iter_free0 (_message_it);
				_g_object_unref0 (connection);
				return;
			}
			if ((*dcem).tagged) {
				g_variant_get (reply, "(s)", tag, NULL);
			}
			_g_variant_unref0 (reply);
		}
		_g_variant_unref0 (message);
		_g_variant_iter_free0 (_message_it);
	}
	_g_object_unref0 (connection);
}


static void dconf_client_call_async_data_free (gpointer _data) {
	DconfClientCallAsyncData* data;
	data = _data;
	dconf_engine_message_destroy (&data->dcem);
	_g_object_unref0 (data->cancellable);
	g_object_unref (data->self);
	g_slice_free (DconfClientCallAsyncData, data);
}


static void dconf_client_call_async (DConfClient* self, DConfEngineMessage* dcem, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DconfClientCallAsyncData* _data_;
	DConfEngineMessage _tmp0_ = {0};
	_data_ = g_slice_new0 (DconfClientCallAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, dconf_client_call_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, dconf_client_call_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->dcem = (dconf_engine_message_copy (dcem, &_tmp0_), _tmp0_);
	_data_->cancellable = _g_object_ref0 (cancellable);
	dconf_client_call_async_co (_data_);
}


static void dconf_client_call_finish (DConfClient* self, GAsyncResult* _res_, char** tag, GError** error) {
	DconfClientCallAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*tag = _data_->tag;
	_data_->tag = NULL;
}


static void dconf_client_call_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DconfClientCallAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	dconf_client_call_async_co (data);
}


static gboolean dconf_client_call_async_co (DconfClientCallAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		if (data->dcem.bus_type == 'e') {
			if (data->self->priv->session == NULL) {
				data->_state_ = 1;
				g_bus_get (G_BUS_TYPE_SESSION, data->cancellable, dconf_client_call_async_ready, data);
				return FALSE;
				_state_1:
				data->_tmp0_ = g_bus_get_finish (data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->connection);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
				data->self->priv->session = (data->_tmp1_ = data->_tmp0_, _g_object_unref0 (data->self->priv->session), data->_tmp1_);
			}
			data->connection = (data->_tmp2_ = _g_object_ref0 (data->self->priv->session), _g_object_unref0 (data->connection), data->_tmp2_);
		} else {
			g_assert (data->dcem.bus_type == 'y');
			if (data->self->priv->system == NULL) {
				data->_state_ = 2;
				g_bus_get (G_BUS_TYPE_SYSTEM, data->cancellable, dconf_client_call_async_ready, data);
				return FALSE;
				_state_2:
				data->_tmp3_ = g_bus_get_finish (data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->connection);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
				data->self->priv->system = (data->_tmp4_ = data->_tmp3_, _g_object_unref0 (data->self->priv->system), data->_tmp4_);
			}
			data->connection = (data->_tmp5_ = _g_object_ref0 (data->self->priv->system), _g_object_unref0 (data->connection), data->_tmp5_);
		}
		{
			data->_message_it = g_variant_iter_new (data->dcem.body);
			while (TRUE) {
				if (!((data->message = (data->_tmp6_ = g_variant_iter_next_value (data->_message_it), _g_variant_unref0 (data->message), data->_tmp6_)) != NULL)) {
					break;
				}
				data->_state_ = 3;
				g_dbus_connection_call (data->connection, data->dcem.destination, data->dcem.object_path, data->dcem.interface, data->dcem.method, data->message, data->dcem.reply_type, G_DBUS_CALL_FLAGS_NONE, -1, data->cancellable, dconf_client_call_async_ready, data);
				return FALSE;
				_state_3:
				data->reply = g_dbus_connection_call_finish (data->connection, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_variant_unref0 (data->message);
					_g_variant_iter_free0 (data->_message_it);
					_g_object_unref0 (data->connection);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
				if (data->dcem.tagged) {
					g_variant_get (data->reply, "(s)", &data->tag, NULL);
				}
				_g_variant_unref0 (data->reply);
			}
			_g_variant_unref0 (data->message);
			_g_variant_iter_free0 (data->_message_it);
		}
		_g_object_unref0 (data->connection);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


/**
 * dconf_client_is_writable:
 * @client: a #DConfClient
 * @key: a dconf key
 * Returns: %TRUE is @key is writable
 *
 * Checks if @key is writable (ie: the key has no mandatory setting).
 *
 * This call does not verify that writing to the key will actually be successful.  It only checks for
 * the existence of mandatory keys/locks that might affect writing to @key.  Other issues (such as a
 * full disk or an inability to connect to the bus and start the service) may cause the write to fail.
 **/
gboolean dconf_client_is_writable (DConfClient* self, const char* key) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	result = dconf_engine_is_writable (self->priv->engine, key);
	return result;
}


/**
 * dconf_client_write:
 * @client: a #DConfClient
 * @key: a dconf key
 * @value: (allow-none): a #GVariant, or %NULL
 * @tag: (out) (allow-none): the tag from this write
 * @cancellable: a #GCancellable, or %NULL
 * @error: a pointer to a #GError, or %NULL
 * Returns: %TRUE if the write is successful
 *
 * Write a value to the given @key, or reset @key to its default value.
 *
 * If @value is %NULL then @key is reset to its default value (which may
 * be completely unset), otherwise @value becomes the new value.
 *
 * If @tag is non-%NULL then it is set to the unique tag associated with this write.  This is the same
 * tag that appears in change notifications.
 **/
gboolean dconf_client_write (DConfClient* self, const char* key, GVariant* value, char** tag, GCancellable* cancellable, GError** error) {
	gboolean result = FALSE;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	if (tag != NULL) {
		*tag = NULL;
	}
	_inner_error_ = NULL;
	if ((tag) == NULL) {
		char* junk;
		DConfEngineMessage _tmp0_ = {0};
		DConfEngineMessage _tmp1_;
		char* _tmp5_;
		char* _tmp4_ = NULL;
		DConfEngineMessage _tmp3_;
		DConfEngineMessage _tmp2_;
		junk = NULL;
		_tmp1_ = (dconf_engine_write (self->priv->engine, key, value, &_tmp0_, &_inner_error_), _tmp0_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (junk);
			return FALSE;
		}
		dconf_client_call_sync (self, (_tmp3_ = _tmp2_ = _tmp1_, &_tmp3_), &_tmp4_, cancellable, &_inner_error_);
		junk = (_tmp5_ = _tmp4_, _g_free0 (junk), _tmp5_);
		dconf_engine_message_destroy (&_tmp2_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (junk);
			return FALSE;
		}
		_g_free0 (junk);
	} else {
		DConfEngineMessage _tmp6_ = {0};
		DConfEngineMessage _tmp7_;
		char* _tmp11_;
		char* _tmp10_ = NULL;
		DConfEngineMessage _tmp9_;
		DConfEngineMessage _tmp8_;
		_tmp7_ = (dconf_engine_write (self->priv->engine, key, value, &_tmp6_, &_inner_error_), _tmp6_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
		dconf_client_call_sync (self, (_tmp9_ = _tmp8_ = _tmp7_, &_tmp9_), &_tmp10_, cancellable, &_inner_error_);
		*tag = (_tmp11_ = _tmp10_, _g_free0 (*tag), _tmp11_);
		dconf_engine_message_destroy (&_tmp8_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	return result;
}


static void dconf_client_write_async_data_free (gpointer _data) {
	DconfClientWriteAsyncData* data;
	data = _data;
	_g_free0 (data->key);
	_g_variant_unref0 (data->value);
	_g_object_unref0 (data->cancellable);
	g_object_unref (data->self);
	g_slice_free (DconfClientWriteAsyncData, data);
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


void dconf_client_write_async (DConfClient* self, const char* key, GVariant* value, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DconfClientWriteAsyncData* _data_;
	_data_ = g_slice_new0 (DconfClientWriteAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, dconf_client_write_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, dconf_client_write_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->key = g_strdup (key);
	_data_->value = _g_variant_ref0 (value);
	_data_->cancellable = _g_object_ref0 (cancellable);
	dconf_client_write_async_co (_data_);
}


gboolean dconf_client_write_finish (DConfClient* self, GAsyncResult* _res_, char** tag, GError** error) {
	gboolean result;
	DconfClientWriteAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*tag = _data_->tag;
	_data_->tag = NULL;
	result = _data_->result;
	return result;
}


static void dconf_client_write_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DconfClientWriteAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	dconf_client_write_async_co (data);
}


/**
 * dconf_client_write_async:
 * @client: a #DConfClient
 * @key: a dconf key
 * @value: (allow-none): a #GVariant, or %NULL
 * @cancellable: a #GCancellable, or %NULL
 * @callback: the function to call when complete
 * @user_data: the user data for @callback
 *
 * Write a value to the given @key, or reset @key to its default value.
 *
 * This is the asynchronous version of dconf_client_write().  You should call
 * dconf_client_write_finish() from @callback to collect the result.
 **/
static gboolean dconf_client_write_async_co (DconfClientWriteAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		memset (&data->_tmp0_, 0, sizeof (DConfEngineMessage));
		data->_tmp1_ = (dconf_engine_write (data->self->priv->engine, data->key, data->value, &data->_tmp0_, &data->_inner_error_), data->_tmp0_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->_tmp4_ = NULL;
		data->_state_ = 4;
		dconf_client_call_async (data->self, (data->_tmp3_ = data->_tmp2_ = data->_tmp1_, &data->_tmp3_), data->cancellable, dconf_client_write_async_ready, data);
		return FALSE;
		_state_4:
		dconf_client_call_finish (data->self, data->_res_, &data->_tmp4_, &data->_inner_error_);
		data->tag = (data->_tmp5_ = data->_tmp4_, _g_free0 (data->tag), data->_tmp5_);
		dconf_engine_message_destroy (&data->_tmp2_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->result = TRUE;
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


/**
 * dconf_client_write_many:
 * @client: a #DConfClient
 * @dir: the dconf directory under which to make the writes
 * @rels: a %NULL-terminated array of relative keys
 * @values: an array of possibly-%NULL #GVariant pointers
 * @n_values: the length of @values, which must be equal to the length of @rels
 * @tag: (out) (allow-none): the tag from this write
 * @cancellable: a #GCancellable, or %NULL
 * @error: a pointer to a #GError, or %NULL
 * Returns: %TRUE if the write is successful
 *
 * Write multiple values at once.
 *
 * For each pair of items from @rels and @values, the value is written to the result of concatenating
 * @dir with the relative path.  As with dconf_client_write(), if a given value is %NULL then the effect
 * is that the specified key is reset.
 *
 * If @tag is non-%NULL then it is set to the unique tag associated with this write.  This is the same
 * tag that appears in change notifications.
 **/
gboolean dconf_client_write_many (DConfClient* self, const char* dir, char** rels, GVariant** values, int values_length1, char** tag, GCancellable* cancellable, GError** error) {
	gboolean result = FALSE;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dir != NULL, FALSE);
	if (tag != NULL) {
		*tag = NULL;
	}
	_inner_error_ = NULL;
	if ((tag) == NULL) {
		char* junk;
		DConfEngineMessage _tmp0_ = {0};
		DConfEngineMessage _tmp1_;
		char* _tmp5_;
		char* _tmp4_ = NULL;
		DConfEngineMessage _tmp3_;
		DConfEngineMessage _tmp2_;
		junk = NULL;
		_tmp1_ = (dconf_engine_write_many (self->priv->engine, dir, (const gchar * const *) rels, values, &_tmp0_, &_inner_error_), _tmp0_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (junk);
			return FALSE;
		}
		dconf_client_call_sync (self, (_tmp3_ = _tmp2_ = _tmp1_, &_tmp3_), &_tmp4_, cancellable, &_inner_error_);
		junk = (_tmp5_ = _tmp4_, _g_free0 (junk), _tmp5_);
		dconf_engine_message_destroy (&_tmp2_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (junk);
			return FALSE;
		}
		_g_free0 (junk);
	} else {
		DConfEngineMessage _tmp6_ = {0};
		DConfEngineMessage _tmp7_;
		char* _tmp11_;
		char* _tmp10_ = NULL;
		DConfEngineMessage _tmp9_;
		DConfEngineMessage _tmp8_;
		_tmp7_ = (dconf_engine_write_many (self->priv->engine, dir, (const gchar * const *) rels, values, &_tmp6_, &_inner_error_), _tmp6_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
		dconf_client_call_sync (self, (_tmp9_ = _tmp8_ = _tmp7_, &_tmp9_), &_tmp10_, cancellable, &_inner_error_);
		*tag = (_tmp11_ = _tmp10_, _g_free0 (*tag), _tmp11_);
		dconf_engine_message_destroy (&_tmp8_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	return result;
}


/**
 * dconf_client_set_locked:
 * @client: a #DConfClient
 * @path: a dconf path
 * @locked: %TRUE to lock, %FALSE to unlock
 * @cancellable: a #GCancellable, or %NULL
 * @error: a pointer to a #GError, or %NULL
 * Returns: %TRUE if setting the lock was successful
 *
 * Marks a dconf path as being locked.
 *
 * Locks do not affect writes to this #DConfClient.  You can still write to a key that is marked as
 * being locked without problems.
 *
 * Locks are only effective when they are set on a database that is being used as the source of
 * default/mandatory values.  In that case, the lock will prevent writes from occuring to the database
 * that has this database as its defaults.
 **/
gboolean dconf_client_set_locked (DConfClient* self, const char* path, gboolean locked, GCancellable* cancellable, GError** error) {
	gboolean result = FALSE;
	GError * _inner_error_;
	DConfEngineMessage _tmp2_;
	DConfEngineMessage _tmp1_;
	DConfEngineMessage _tmp0_ = {0};
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_inner_error_ = NULL;
	dconf_client_call_sync (self, (_tmp2_ = _tmp1_ = (dconf_engine_set_locked (self->priv->engine, path, locked, &_tmp0_), _tmp0_), &_tmp2_), NULL, cancellable, &_inner_error_);
	dconf_engine_message_destroy (&_tmp1_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static void dconf_client_set_locked_async_data_free (gpointer _data) {
	DconfClientSetLockedAsyncData* data;
	data = _data;
	_g_free0 (data->key);
	_g_object_unref0 (data->cancellable);
	g_object_unref (data->self);
	g_slice_free (DconfClientSetLockedAsyncData, data);
}


void dconf_client_set_locked_async (DConfClient* self, const char* key, gboolean locked, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DconfClientSetLockedAsyncData* _data_;
	_data_ = g_slice_new0 (DconfClientSetLockedAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, dconf_client_set_locked_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, dconf_client_set_locked_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->key = g_strdup (key);
	_data_->locked = locked;
	_data_->cancellable = _g_object_ref0 (cancellable);
	dconf_client_set_locked_async_co (_data_);
}


gboolean dconf_client_set_locked_finish (DConfClient* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	DconfClientSetLockedAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void dconf_client_set_locked_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DconfClientSetLockedAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	dconf_client_set_locked_async_co (data);
}


/**
 * dconf_client_set_locked_async:
 * @client: a #DConfClient
 * @path: a dconf path
 * @locked: %TRUE to lock, %FALSE to unlock
 * @cancellable: a #GCancellable, or %NULL
 * @callback: the function to call when complete
 * @user_data: the user data for @callback
 *
 * Marks a dconf path as being locked.
 *
 * This is the asynchronous version of dconf_client_set_locked().  You should call
 * dconf_client_set_locked_finish() from @callback to collect the result.
 **/
static gboolean dconf_client_set_locked_async_co (DconfClientSetLockedAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		memset (&data->_tmp0_, 0, sizeof (DConfEngineMessage));
		data->_state_ = 5;
		dconf_client_call_async (data->self, (data->_tmp2_ = data->_tmp1_ = (dconf_engine_set_locked (data->self->priv->engine, data->key, data->locked, &data->_tmp0_), data->_tmp0_), &data->_tmp2_), data->cancellable, dconf_client_set_locked_async_ready, data);
		return FALSE;
		_state_5:
		dconf_client_call_finish (data->self, data->_res_, NULL, &data->_inner_error_);
		dconf_engine_message_destroy (&data->_tmp1_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->result = TRUE;
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


/**
 * dconf_client_read:
 * @client: a #DConfClient
 * @key: a valid dconf key
 * Returns: the value corresponding to @key, or %NULL if there is none
 *
 * Reads the value named by @key from dconf.  If no such value exists, %NULL is returned.
 **/
GVariant* dconf_client_read (DConfClient* self, const char* key) {
	GVariant* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	result = dconf_engine_read (self->priv->engine, key);
	return result;
}


/**
 * dconf_client_read_default:
 * @client: a #DConfClient
 * @key: a valid dconf key
 * Returns: the default value corresponding to @key, or %NULL if there is none
 *
 * Reads the value named by @key from any existing default/mandatory databases but ignoring any value
 * set by the user.  The result is as if the named key had just been reset.
 **/
GVariant* dconf_client_read_default (DConfClient* self, const char* key) {
	GVariant* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	result = dconf_engine_read_default (self->priv->engine, key);
	return result;
}


/**
 * dconf_client_read_no_default:
 * @client: a #DConfClient
 * @key: a valid dconf key
 * Returns: the user value corresponding to @key, or %NULL if there is none
 *
 * Reads the value named by @key as set by the user, ignoring any default/mandatory databases.  Normal
 * applications will never want to do this, but it may be useful for administrative or configuration
 * tweaking utilities to have access to this information.
 *
 * Note that in the case of mandatory keys, the result of dconf_client_read_no_default() with a fallback
 * to dconf_client_read_default() is not necessarily the same as the result of a dconf_client_read().
 * This is because the user may have set a value before the key became marked as mandatory, in which
 * case this call will see the user's (otherwise inaccessible) key.
 **/
GVariant* dconf_client_read_no_default (DConfClient* self, const char* key) {
	GVariant* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	result = dconf_engine_read_no_default (self->priv->engine, key);
	return result;
}


/**
 * dconf_client_list:
 * @client: a #DConfClient
 * @dir: a dconf dir
 * @length: the number of items that were returned
 * Returns: (array length=length): the paths located directly below @dir
 *
 * Lists the keys and dirs located directly below @dir.
 *
 * You should free the return result with g_strfreev() when it is no longer needed.
 **/
char** dconf_client_list (DConfClient* self, const char* dir, int* result_length1) {
	char** result = NULL;
	gint _tmp0_;
	char** _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (dir != NULL, NULL);
	result = (_tmp1_ = dconf_engine_list (self->priv->engine, dir, NULL, &_tmp0_), *result_length1 = _tmp0_, _tmp1_);
	return result;
}


/**
 * dconf_client_watch:
 * @client: a #DConfClient
 * @path: a dconf path
 * @cancellable: a #GCancellable, or %NULL
 * @error: a pointer to a %NULL #GError, or %NULL
 * Returns: %TRUE on success, else %FALSE with @error set
 *
 * Requests monitoring of a portion of the dconf database.
 *
 * If @path is a key (ie: doesn't end with a slash) then a single key is monitored for changes.  If
 * @path is a dir (ie: sending with a slash) then all keys that have @path as a prefix are monitored.
 *
 * This function blocks until the watch has definitely been established with the bus daemon.  If you
 * would like a non-blocking version of this call, see dconf_client_watch_async().
 **/
gboolean dconf_client_watch (DConfClient* self, const char* path, GCancellable* cancellable, GError** error) {
	gboolean result = FALSE;
	GError * _inner_error_;
	DConfEngineMessage _tmp2_;
	DConfEngineMessage _tmp1_;
	DConfEngineMessage _tmp0_ = {0};
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_inner_error_ = NULL;
	dconf_client_call_sync (self, (_tmp2_ = _tmp1_ = (dconf_engine_watch (self->priv->engine, path, &_tmp0_), _tmp0_), &_tmp2_), NULL, cancellable, &_inner_error_);
	dconf_engine_message_destroy (&_tmp1_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static void dconf_client_watch_async_data_free (gpointer _data) {
	DconfClientWatchAsyncData* data;
	data = _data;
	_g_free0 (data->name);
	_g_object_unref0 (data->cancellable);
	g_object_unref (data->self);
	g_slice_free (DconfClientWatchAsyncData, data);
}


void dconf_client_watch_async (DConfClient* self, const char* name, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DconfClientWatchAsyncData* _data_;
	_data_ = g_slice_new0 (DconfClientWatchAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, dconf_client_watch_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, dconf_client_watch_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->name = g_strdup (name);
	_data_->cancellable = _g_object_ref0 (cancellable);
	dconf_client_watch_async_co (_data_);
}


gboolean dconf_client_watch_finish (DConfClient* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	DconfClientWatchAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void dconf_client_watch_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DconfClientWatchAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	dconf_client_watch_async_co (data);
}


/**
 * dconf_client_watch_async:
 * @client: a #DConfClient
 * @path: a dconf path
 * @cancellable: a #GCancellable, or %NULL
 * @callback: a #GAsyncReadyCallback to call when finished
 * @user_data: a pointer to pass as the last argument to @callback
 *
 * Requests monitoring of a portion of the dconf database.
 *
 * This is the asynchronous version of dconf_client_watch().  You should call
 * dconf_client_watch_finish() from @callback to collect the result.
 **/
static gboolean dconf_client_watch_async_co (DconfClientWatchAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 6:
		goto _state_6;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		memset (&data->_tmp0_, 0, sizeof (DConfEngineMessage));
		data->_state_ = 6;
		dconf_client_call_async (data->self, (data->_tmp2_ = data->_tmp1_ = (dconf_engine_watch (data->self->priv->engine, data->name, &data->_tmp0_), data->_tmp0_), &data->_tmp2_), data->cancellable, dconf_client_watch_async_ready, data);
		return FALSE;
		_state_6:
		dconf_client_call_finish (data->self, data->_res_, NULL, &data->_inner_error_);
		dconf_engine_message_destroy (&data->_tmp1_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->result = TRUE;
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


/**
 * dconf_client_unwatch:
 * @client: a #DConfClient
 * @path: a dconf path
 * @cancellable: a #GCancellable, or %NULL
 * @error: a pointer to a %NULL #GError, or %NULL
 * Returns: %TRUE on success, else %FALSE with @error set
 *
 * Cancels the effect of a previous call to dconf_client_watch().
 *
 * If the same path has been watched multiple times then only one of the watches is cancelled and the
 * net effect is that the path is still watched.
 *
 * This function blocks until the watch has definitely been removed from the bus daemon.  It is possible
 * that notifications in transit will arrive after this call returns.  For an asynchronous version of
 * this call, see dconf_client_unwatch_async().
 **/
gboolean dconf_client_unwatch (DConfClient* self, const char* name, GCancellable* cancellable, GError** error) {
	gboolean result = FALSE;
	GError * _inner_error_;
	DConfEngineMessage _tmp2_;
	DConfEngineMessage _tmp1_;
	DConfEngineMessage _tmp0_ = {0};
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_inner_error_ = NULL;
	dconf_client_call_sync (self, (_tmp2_ = _tmp1_ = (dconf_engine_unwatch (self->priv->engine, name, &_tmp0_), _tmp0_), &_tmp2_), NULL, cancellable, &_inner_error_);
	dconf_engine_message_destroy (&_tmp1_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static void dconf_client_unwatch_async_data_free (gpointer _data) {
	DconfClientUnwatchAsyncData* data;
	data = _data;
	_g_free0 (data->name);
	_g_object_unref0 (data->cancellable);
	g_object_unref (data->self);
	g_slice_free (DconfClientUnwatchAsyncData, data);
}


void dconf_client_unwatch_async (DConfClient* self, const char* name, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DconfClientUnwatchAsyncData* _data_;
	_data_ = g_slice_new0 (DconfClientUnwatchAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, dconf_client_unwatch_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, dconf_client_unwatch_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->name = g_strdup (name);
	_data_->cancellable = _g_object_ref0 (cancellable);
	dconf_client_unwatch_async_co (_data_);
}


gboolean dconf_client_unwatch_finish (DConfClient* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	DconfClientUnwatchAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void dconf_client_unwatch_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DconfClientUnwatchAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	dconf_client_unwatch_async_co (data);
}


/**
 * dconf_client_unwatch_async:
 * @client: a #DConfClient
 * @path: a dconf path
 * @cancellable: a #GCancellable, or %NULL
 * @callback: a #GAsyncReadyCallback to call when finished
 * @user_data: a pointer to pass as the last argument to @callback
 *
 * Cancels the effect of a previous call to dconf_client_watch().
 *
 * This is the asynchronous version of dconf_client_unwatch().  You should call
 * dconf_client_unwatch_finish() from @callback to collect the result.  No additional notifications will
 * be delivered for this watch after @callback is called.
 **/
static gboolean dconf_client_unwatch_async_co (DconfClientUnwatchAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 7:
		goto _state_7;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		memset (&data->_tmp0_, 0, sizeof (DConfEngineMessage));
		data->_state_ = 7;
		dconf_client_call_async (data->self, (data->_tmp2_ = data->_tmp1_ = (dconf_engine_unwatch (data->self->priv->engine, data->name, &data->_tmp0_), data->_tmp0_), &data->_tmp2_), data->cancellable, dconf_client_unwatch_async_ready, data);
		return FALSE;
		_state_7:
		dconf_client_call_finish (data->self, data->_res_, NULL, &data->_inner_error_);
		dconf_engine_message_destroy (&data->_tmp1_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->result = TRUE;
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static GVariant* dconf_client_service_func (DConfEngineMessage* dcem) {
	GVariant* result = NULL;
	GError * _inner_error_;
	_inner_error_ = NULL;
	{
		GDBusConnection* connection;
		GVariant* _tmp0_;
		g_assert ((*dcem).bus_type == 'e');
		connection = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp0_ = g_dbus_connection_call_sync (connection, (*dcem).destination, (*dcem).object_path, (*dcem).interface, (*dcem).method, (*dcem).body, (*dcem).reply_type, G_DBUS_CALL_FLAGS_NONE, -1, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (connection);
			goto __catch0_g_error;
		}
		result = _tmp0_;
		_g_object_unref0 (connection);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		{
			result = NULL;
			return result;
		}
	}
	__finally0:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static GVariant* _dconf_client_service_func_dconf_service_func (DConfEngineMessage* dcem) {
	GVariant* result;
	result = dconf_client_service_func (dcem);
	return result;
}


/**
 * dconf_client_new:
 * @profile: the dconf profile to use, or %NULL
 * @watch_func: the function to call when changes occur
 * @user_data: the user_data to pass to @watch_func
 * @notify: the function to free @user_data when no longer needed
 * Returns: a new #DConfClient
 *
 * Creates a new #DConfClient for the given context.
 *
 * If @profile is non-%NULL then it specifies the name of the profile to use.  If @profile is %NULL then
 * the DCONF_PROFILE environment variable is consulted.  If that is unset then the default profile of
 * "user" is used.  If a profile named "user" is not installed then the dconf client is setup to access
 * ~/.config/dconf/user.
 **/
DConfClient* dconf_client_construct (GType object_type, const char* profile, DConfWatchFunc watch_func, void* watch_func_target, GDestroyNotify watch_func_target_destroy_notify) {
	DConfClient * self;
	DConfEngine* _tmp0_;
	DConfWatchFunc _tmp1_;
	self = (DConfClient*) g_object_new (object_type, NULL);
	dconf_engine_set_service_func (_dconf_client_service_func_dconf_service_func);
	self->priv->engine = (_tmp0_ = dconf_engine_new (profile), _dconf_engine_free0 (self->priv->engine), _tmp0_);
	self->priv->watch_func = (_tmp1_ = watch_func, ((self->priv->watch_func_target_destroy_notify == NULL) ? NULL : (self->priv->watch_func_target_destroy_notify (self->priv->watch_func_target), NULL), self->priv->watch_func = NULL, self->priv->watch_func_target = NULL, self->priv->watch_func_target_destroy_notify = NULL), self->priv->watch_func_target = watch_func_target, self->priv->watch_func_target_destroy_notify = NULL, _tmp1_);
	(watch_func_target_destroy_notify == NULL) ? NULL : (watch_func_target_destroy_notify (watch_func_target), NULL);
	watch_func = NULL;
	watch_func_target = NULL;
	watch_func_target_destroy_notify = NULL;
	return self;
}


DConfClient* dconf_client_new (const char* profile, DConfWatchFunc watch_func, void* watch_func_target, GDestroyNotify watch_func_target_destroy_notify) {
	return dconf_client_construct (DCONF_TYPE_CLIENT, profile, watch_func, watch_func_target, watch_func_target_destroy_notify);
}


static void dconf_client_class_init (DConfClientClass * klass) {
	dconf_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DConfClientPrivate));
	G_OBJECT_CLASS (klass)->finalize = dconf_client_finalize;
}


static void dconf_client_instance_init (DConfClient * self) {
	self->priv = DCONF_CLIENT_GET_PRIVATE (self);
}


static void dconf_client_finalize (GObject* obj) {
	DConfClient * self;
	self = DCONF_CLIENT (obj);
	_g_object_unref0 (self->priv->session);
	_g_object_unref0 (self->priv->system);
	(self->priv->watch_func_target_destroy_notify == NULL) ? NULL : (self->priv->watch_func_target_destroy_notify (self->priv->watch_func_target), NULL);
	self->priv->watch_func = NULL;
	self->priv->watch_func_target = NULL;
	self->priv->watch_func_target_destroy_notify = NULL;
	_dconf_engine_free0 (self->priv->engine);
	G_OBJECT_CLASS (dconf_client_parent_class)->finalize (obj);
}


GType dconf_client_get_type (void) {
	static volatile gsize dconf_client_type_id__volatile = 0;
	if (g_once_init_enter (&dconf_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DConfClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dconf_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DConfClient), 0, (GInstanceInitFunc) dconf_client_instance_init, NULL };
		GType dconf_client_type_id;
		dconf_client_type_id = g_type_register_static (G_TYPE_OBJECT, "DConfClient", &g_define_type_info, 0);
		g_once_init_leave (&dconf_client_type_id__volatile, dconf_client_type_id);
	}
	return dconf_client_type_id__volatile;
}




