.\"
.\" "$Id: lppasswd.man 6649 2007-07-11 21:46:42Z mike $"
.\"
.\"   lpadmin man page for the Common UNIX Printing System (CUPS).
.\"
.\"   Copyright 2007 by Apple Inc.
.\"   Copyright 1997-2006 by Easy Software Products.
.\"
.\"   These coded instructions, statements, and computer programs are the
.\"   property of Apple Inc. and are protected by Federal copyright
.\"   law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\"   which should have been included with this file.  If this file is
.\"   file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH lppasswd 1 "Common UNIX Printing System" "20 March 2006" "Apple Inc."
.SH NAME
lppasswd \- add, change, or delete digest passwords.
.SH SYNOPSIS
.B lppasswd
[
.I username
]
.br
.B lppasswd
-a [ -g
.I groupname
]
.I username
.br
.B lppasswd
-x
.I username
.SH DESCRIPTION
\fIlppasswd\fR adds, changes, or deletes passwords in the CUPS
digest password file, \fIpasswd.md5\fR. When run by a normal
user, \fIlppasswd\fR will prompt for the old and new passwords.
When run by the super-user, \fIlppasswd\fR can add new accounts
(\fI-a username\fR), change existing accounts (\fIusername\fR),
or delete accounts (\fI-x username\fR) in the digest password
file. Digest usernames do not have to match local UNIX usernames.
.SH OPTIONS
\fIlppasswd\fR supports the following options:
.TP 5
-g groupname
.br
Specifies a group other than the default system group.
.SH SECURITY ISSUES
The \fIlppasswd\fR command is installed setuid to root. While
every attempt has been made to make it secure against exploits
that could grant super-user privileges to unprivileged users,
paranoid system administrators may wish to disable or change the
ownership of the program to an unprivileged account.
.SH SEE ALSO
\fIlp(1)\fR, \fIlpr(1)\fR,
.br
http://localhost:631/help
.SH COPYRIGHT
Copyright 2007 by Apple Inc.
.\"
.\" End of "$Id: lppasswd.man 6649 2007-07-11 21:46:42Z mike $".
.\"
