# Copyright (C) 2008-2011 Dejan Muhamedagic <dmuhamedagic@suse.de>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This software is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#

import time
from singletonmixin import Singleton


class WCache(Singleton):
    "Cache stuff. A naive implementation."

    def __init__(self):
        self.max_cache_age = 600  # seconds
        self._clear()

    def is_cached(self, name):
        if time.time() - self.stamp > self.max_cache_age:
            self._clear()
        return name in self.lists

    def store(self, name, lst):
        self.lists[name] = lst
        return lst

    def retrieve(self, name):
        if self.is_cached(name):
            return self.lists[name]
        return None

    def _clear(self):
        self.stamp = time.time()
        self.lists = {}

# vim:ts=4:sw=4:et:
