.. -*- rst -*-

Messages (messages)
===================

Lists all, shows, and deletes messages. These are error messages generated by
failed operations as a way to find out what happened when an asynchronous
operation failed.


Delete message
~~~~~~~~~~~~~~

.. rest_method::  DELETE /v3/{project_id}/messages/{message_id}

Deletes a message.

Response codes
--------------

.. rest_status_code:: success ../status.yaml

   - 204

.. rest_status_code:: error ../status.yaml

   - 400
   - 404


Request
-------

.. rest_parameters:: parameters.yaml

   - project_id: project_id_path
   - message_id: message_id


Show message details
~~~~~~~~~~~~~~~~~~~~

.. rest_method::  GET /v3/{project_id}/messages/{message_id}

Shows details for a message.


Response codes
--------------

.. rest_status_code:: success ../status.yaml

   - 200

.. rest_status_code:: error ../status.yaml

   - 400
   - 404


Request
-------

.. rest_parameters:: parameters.yaml

   - project_id: project_id_path
   - message_id: message_id


Response Parameters
-------------------

.. rest_parameters:: parameters.yaml

   - message: user_message
   - request_id: request_id
   - links: links_message
   - message_level: message_level
   - event_id: event_id
   - created_at: created_at
   - guaranteed_until: guaranteed_until
   - resource_uuid: resource_uuid
   - id: id_message
   - resource_type: resource_type
   - user_message: user_message

Response Example
----------------

.. literalinclude:: ./samples/messages-show-response.json
   :language: javascript


List messages
~~~~~~~~~~~~~

.. rest_method::  GET /v3/{project_id}/messages

Lists all messages, since v3.31 if non-admin users
specify invalid filters in the url, API will return bad request.


Response codes
--------------

.. rest_status_code:: success ../status.yaml

   - 200

.. rest_status_code:: error ../status.yaml

   - 400


Request
-------

.. rest_parameters:: parameters.yaml

   - project_id: project_id_path
   - sort: sort
   - limit: limit
   - offset: offset
   - marker: marker

Response Parameters
-------------------

.. rest_parameters:: parameters.yaml

   - messages: user_messages
   - request_id: request_id
   - links: links_message
   - message_level: message_level
   - event_id: event_id
   - created_at: created_at
   - guaranteed_until: guaranteed_until
   - resource_uuid: resource_uuid
   - id: id_message
   - resource_type: resource_type
   - user_message: user_message

Response Example
----------------

.. literalinclude:: ./samples/messages-list-response.json
   :language: javascript
