# Copyright (C) 2005 Aaron Bentley
# <aaron.bentley@utoronto.ca>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
import sys
from subprocess import Popen, PIPE

from bzrlib.workingtree import WorkingTree
import bzrlib.add

from bzrlib.plugins.bzrtools.bzrtools import open_from_url

def patch(tree, location, strip, quiet=False):
    """Apply a patch to a branch, using patch(1).  URLs may be used."""
    my_file = None
    if location is None:
        my_file = sys.stdin
    else:
        my_file = open_from_url(location)
    cmd = ['patch', '--directory', tree.basedir, '--strip', str(strip)]
    if quiet:
        cmd.append('--quiet')
    r = 0
    child_proc = Popen(cmd, stdin=PIPE)
    for line in my_file:
        child_proc.stdin.write(line)
    child_proc.stdin.close()
    r = child_proc.wait()
    return r
