/* 0.9.7.2 on Thu Sep 10 16:57:28 2009 */

#define PY_SSIZE_T_CLEAN
#include "Python.h"
#include "structmember.h"
#ifndef PY_LONG_LONG
  #define PY_LONG_LONG LONG_LONG
#endif
#if PY_VERSION_HEX < 0x02050000
  typedef int Py_ssize_t;
  #define PY_SSIZE_T_MAX INT_MAX
  #define PY_SSIZE_T_MIN INT_MIN
  #define PyInt_FromSsize_t(z) PyInt_FromLong(z)
  #define PyInt_AsSsize_t(o)	PyInt_AsLong(o)
#endif
#ifndef WIN32
  #ifndef __stdcall
    #define __stdcall
  #endif
  #ifndef __cdecl
    #define __cdecl
  #endif
#endif
#ifdef __cplusplus
#define __PYX_EXTERN_C extern "C"
#else
#define __PYX_EXTERN_C extern
#endif
#include <math.h>
#include "python-compat.h"
#include "_dirstate_helpers_pyx.h"
#include "stdlib.h"
#include "sys/stat.h"
#include "string.h"


typedef struct {PyObject **p; char *s;} __Pyx_InternTabEntry; /*proto*/
typedef struct {PyObject **p; char *s; long n;} __Pyx_StringTabEntry; /*proto*/

static PyObject *__pyx_m;
static PyObject *__pyx_b;
static int __pyx_lineno;
static char *__pyx_filename;
static char **__pyx_f;

static char __pyx_mdoc[] = "Helper functions for DirState.\n\nThis is the python implementation for DirState functions.\n";

static PyObject *__Pyx_Import(PyObject *name, PyObject *from_list); /*proto*/

static PyObject *__Pyx_GetName(PyObject *dict, PyObject *name); /*proto*/

static PyObject *__Pyx_GetItemInt(PyObject *o, Py_ssize_t i); /*proto*/

static void __Pyx_Raise(PyObject *type, PyObject *value, PyObject *tb); /*proto*/

static int __Pyx_SetItemInt(PyObject *o, Py_ssize_t i, PyObject *v); /*proto*/

static PyObject *__Pyx_UnpackItem(PyObject *); /*proto*/
static int __Pyx_EndUnpack(PyObject *); /*proto*/

static int __Pyx_GetException(PyObject **type, PyObject **value, PyObject **tb); /*proto*/

static void __Pyx_WriteUnraisable(char *name); /*proto*/

static int __Pyx_InternStrings(__Pyx_InternTabEntry *t); /*proto*/

static int __Pyx_InitStrings(__Pyx_StringTabEntry *t); /*proto*/

static int __Pyx_SetVtable(PyObject *dict, void *vtable); /*proto*/

static void __Pyx_AddTraceback(char *funcname); /*proto*/

/* Declarations from _dirstate_helpers_pyx */

struct __pyx_obj_21_dirstate_helpers_pyx_Reader {
  PyObject_HEAD
  struct __pyx_vtabstruct_21_dirstate_helpers_pyx_Reader *__pyx_vtab;
  PyObject *state;
  PyObject *text;
  char *text_cstr;
  int text_size;
  char *end_cstr;
  char *cur_cstr;
  char *next;
};

struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC {
  PyObject_HEAD
  struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *__pyx_vtab;
  int doing_consistency_expansion;
  PyObject *old_dirname_to_file_id;
  PyObject *new_dirname_to_file_id;
  PyObject *last_source_parent;
  PyObject *last_target_parent;
  int include_unchanged;
  int partial;
  PyObject *use_filesystem_for_exec;
  PyObject *utf8_decode;
  PyObject *searched_specific_files;
  PyObject *searched_exact_paths;
  PyObject *search_specific_files;
  PyObject *search_specific_file_parents;
  PyObject *state;
  PyObject *current_root;
  PyObject *current_root_unicode;
  PyObject *root_entries;
  int root_entries_pos;
  int root_entries_len;
  PyObject *root_abspath;
  int source_index;
  int target_index;
  int want_unversioned;
  PyObject *tree;
  PyObject *dir_iterator;
  int block_index;
  PyObject *current_block;
  int current_block_pos;
  PyObject *current_block_list;
  PyObject *current_dir_info;
  PyObject *current_dir_list;
  PyObject *_pending_consistent_entries;
  int path_index;
  PyObject *root_dir_info;
  PyObject *bisect_left;
  PyObject *pathjoin;
  PyObject *fstat;
  PyObject *seen_ids;
  PyObject *sha_file;
};


struct __pyx_vtabstruct_21_dirstate_helpers_pyx_Reader {
  char *(*get_next)(struct __pyx_obj_21_dirstate_helpers_pyx_Reader *,int *);
  PyObject *(*get_next_str)(struct __pyx_obj_21_dirstate_helpers_pyx_Reader *);
  int (*_init)(struct __pyx_obj_21_dirstate_helpers_pyx_Reader *);
  PyObject *(*_get_entry)(struct __pyx_obj_21_dirstate_helpers_pyx_Reader *,int,void **,int *);
};
static struct __pyx_vtabstruct_21_dirstate_helpers_pyx_Reader *__pyx_vtabptr_21_dirstate_helpers_pyx_Reader;


struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC {
  PyObject *(*_process_entry)(struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *,PyObject *,PyObject *);
  void (*_gather_result_for_consistency)(struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *,PyObject *);
  void (*_update_current_block)(struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *);
  PyObject *(*_iter_next)(struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *);
  PyObject *(*_maybe_tree_ref)(struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *,PyObject *);
  PyObject *(*_loop_one_block)(struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *);
  PyObject *(*_next_consistent_entries)(struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *);
  PyObject *(*_path_info)(struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *,PyObject *,PyObject *);
};
static struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *__pyx_vtabptr_21_dirstate_helpers_pyx_ProcessEntryC;

static PyTypeObject *__pyx_ptype_21_dirstate_helpers_pyx_Reader = 0;
static PyTypeObject *__pyx_ptype_21_dirstate_helpers_pyx_ProcessEntryC = 0;
static int __pyx_v_21_dirstate_helpers_pyx_ERROR_PATH_NOT_FOUND;
static int __pyx_v_21_dirstate_helpers_pyx_ERROR_DIRECTORY;
static PyObject *__pyx_v_21_dirstate_helpers_pyx__kind_absent;
static PyObject *__pyx_v_21_dirstate_helpers_pyx__kind_file;
static PyObject *__pyx_v_21_dirstate_helpers_pyx__kind_directory;
static PyObject *__pyx_v_21_dirstate_helpers_pyx__kind_symlink;
static PyObject *__pyx_v_21_dirstate_helpers_pyx__kind_relocated;
static PyObject *__pyx_v_21_dirstate_helpers_pyx__kind_tree_reference;
static PyObject *__pyx_k17;
static PyObject *__pyx_k18;
static PyObject *__pyx_k19;
static void *__pyx_f_21_dirstate_helpers_pyx__my_memrchr(void *,int,size_t); /*proto*/
static PyObject *__pyx_f_21_dirstate_helpers_pyx_safe_string_from_size(char *,Py_ssize_t); /*proto*/
static int __pyx_f_21_dirstate_helpers_pyx__is_aligned(void *); /*proto*/
static int __pyx_f_21_dirstate_helpers_pyx__cmp_by_dirs(char *,int,char *,int); /*proto*/
static int __pyx_f_21_dirstate_helpers_pyx__cmp_path_by_dirblock_intern(char *,int,char *,int); /*proto*/
static int __pyx_f_21_dirstate_helpers_pyx_minikind_from_mode(int); /*proto*/
static PyObject *__pyx_f_21_dirstate_helpers_pyx__pack_stat(PyObject *); /*proto*/
static PyObject *__pyx_f_21_dirstate_helpers_pyx__update_entry(PyObject *,PyObject *,PyObject *,PyObject *); /*proto*/
static char __pyx_f_21_dirstate_helpers_pyx__minikind_from_string(PyObject *); /*proto*/
static PyObject *__pyx_f_21_dirstate_helpers_pyx__minikind_to_kind(char); /*proto*/
static int __pyx_f_21_dirstate_helpers_pyx__versioned_minikind(char); /*proto*/


/* Implementation of _dirstate_helpers_pyx */

static char __pyx_k11[] = "bzrlib.dirstate";
static char __pyx_k13[] = "bzrlib.osutils";
static char __pyx_k27[] = "tree-reference";

static PyObject *__pyx_n_binascii;
static PyObject *__pyx_n_bisect;
static PyObject *__pyx_n_errno;
static PyObject *__pyx_n_os;
static PyObject *__pyx_n_stat;
static PyObject *__pyx_n_sys;
static PyObject *__pyx_n_bzrlib;
static PyObject *__pyx_n_cache_utf8;
static PyObject *__pyx_n_errors;
static PyObject *__pyx_n_osutils;
static PyObject *__pyx_n_DirState;
static PyObject *__pyx_n_parent_directories;
static PyObject *__pyx_n_pathjoin;
static PyObject *__pyx_n_splitpath;
static PyObject *__pyx_n_b2a_base64;
static PyObject *__pyx_n__encode;
static PyObject *__pyx_n_struct;
static PyObject *__pyx_n_pack;
static PyObject *__pyx_n_absent;
static PyObject *__pyx_n_file;
static PyObject *__pyx_n_directory;
static PyObject *__pyx_n_symlink;
static PyObject *__pyx_n_relocated;

static PyObject *__pyx_k11p;
static PyObject *__pyx_k13p;
static PyObject *__pyx_k27p;

static void *__pyx_f_21_dirstate_helpers_pyx__my_memrchr(void *__pyx_v_s,int __pyx_v_c,size_t __pyx_v_n) {
  char *__pyx_v_pos;
  char *__pyx_v_start;
  void *__pyx_r;
  int __pyx_1;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":127 */
  __pyx_v_start = ((char *)__pyx_v_s);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":128 */
  __pyx_v_pos = ((__pyx_v_start + __pyx_v_n) - 1);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":129 */
  while (1) {
    __pyx_1 = (__pyx_v_pos >= __pyx_v_start);
    if (!__pyx_1) break;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":130 */
    __pyx_1 = ((__pyx_v_pos[0]) == __pyx_v_c);
    if (__pyx_1) {
      __pyx_r = ((void *)__pyx_v_pos);
      goto __pyx_L0;
      goto __pyx_L4;
    }
    __pyx_L4:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":132 */
    __pyx_v_pos = (__pyx_v_pos - 1);
  }

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":133 */
  __pyx_r = NULL;
  goto __pyx_L0;

  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

static PyObject *__pyx_k28p;

static char __pyx_k28[] = "Must be a single character string, not %s";

static PyObject *__pyx_f_21_dirstate_helpers_pyx__py_memrchr(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_21_dirstate_helpers_pyx__py_memrchr[] = "Just to expose _my_memrchr for testing.\n\n    :param s: The Python string to search\n    :param c: The character to search for\n    :return: The offset to the last instance of \'c\' in s\n    ";
static PyObject *__pyx_f_21_dirstate_helpers_pyx__py_memrchr(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_s = 0;
  PyObject *__pyx_v_c = 0;
  void *__pyx_v__s;
  void *__pyx_v_found;
  int __pyx_v_length;
  char *__pyx_v__c;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  int __pyx_3;
  static char *__pyx_argnames[] = {"s","c",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_s, &__pyx_v_c)) return 0;
  Py_INCREF(__pyx_v_s);
  Py_INCREF(__pyx_v_c);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":148 */
  __pyx_v__s = PyString_AsString(__pyx_v_s);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":149 */
  __pyx_v_length = PyString_Size(__pyx_v_s);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":151 */
  __pyx_v__c = PyString_AsString(__pyx_v_c);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":152 */
  #ifndef PYREX_WITHOUT_ASSERTIONS
  if (!(PyString_Size(__pyx_v_c) == 1)) {
    __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 153; goto __pyx_L1;}
    Py_INCREF(__pyx_v_c);
    PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_c);
    __pyx_2 = PyNumber_Remainder(__pyx_k28p, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 153; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    PyErr_SetObject(PyExc_AssertionError, __pyx_2);
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 152; goto __pyx_L1;}
  }
  #endif

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":154 */
  __pyx_v_found = __pyx_f_21_dirstate_helpers_pyx__my_memrchr(__pyx_v__s,(__pyx_v__c[0]),__pyx_v_length);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":155 */
  __pyx_3 = (__pyx_v_found == NULL);
  if (__pyx_3) {
    Py_INCREF(Py_None);
    __pyx_r = Py_None;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":157 */
  __pyx_1 = PyInt_FromLong((((char *)__pyx_v_found) - ((char *)__pyx_v__s))); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 157; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("_dirstate_helpers_pyx._py_memrchr");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_s);
  Py_DECREF(__pyx_v_c);
  return __pyx_r;
}

static PyObject *__pyx_k29p;

static char __pyx_k29[] = "tried to create a string with an invalid size: %d @0x%x";

static PyObject *__pyx_f_21_dirstate_helpers_pyx_safe_string_from_size(char *__pyx_v_s,Py_ssize_t __pyx_v_size) {
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":160 */
  __pyx_1 = (__pyx_v_size < 0);
  if (__pyx_1) {
    __pyx_2 = PyInt_FromSsize_t(__pyx_v_size); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 164; goto __pyx_L1;}
    __pyx_3 = PyInt_FromLong(((int)__pyx_v_s)); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 164; goto __pyx_L1;}
    __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 164; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_2);
    PyTuple_SET_ITEM(__pyx_4, 1, __pyx_3);
    __pyx_2 = 0;
    __pyx_3 = 0;
    __pyx_2 = PyNumber_Remainder(__pyx_k29p, __pyx_4); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 164; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 162; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_2);
    __pyx_2 = 0;
    __pyx_4 = PyObject_CallObject(PyExc_AssertionError, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 162; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __Pyx_Raise(__pyx_4, 0, 0);
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 162; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":165 */
  __pyx_2 = PyString_FromStringAndSize(__pyx_v_s,__pyx_v_size); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 165; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("_dirstate_helpers_pyx.safe_string_from_size");
  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

static int __pyx_f_21_dirstate_helpers_pyx__is_aligned(void *__pyx_v_ptr) {
  int __pyx_r;
  __pyx_r = ((((intptr_t)__pyx_v_ptr) & ((sizeof(int)) - 1)) == 0);
  goto __pyx_L0;

  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

static int __pyx_f_21_dirstate_helpers_pyx__cmp_by_dirs(char *__pyx_v_path1,int __pyx_v_size1,char *__pyx_v_path2,int __pyx_v_size2) {
  unsigned char *__pyx_v_cur1;
  unsigned char *__pyx_v_cur2;
  unsigned char *__pyx_v_end1;
  unsigned char *__pyx_v_end2;
  int *__pyx_v_cur_int1;
  int *__pyx_v_cur_int2;
  int *__pyx_v_end_int1;
  int *__pyx_v_end_int2;
  int __pyx_r;
  int __pyx_1;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":186 */
  __pyx_1 = (__pyx_v_path1 == __pyx_v_path2);
  if (__pyx_1) {
    __pyx_1 = (__pyx_v_size1 == __pyx_v_size2);
  }
  if (__pyx_1) {
    __pyx_r = 0;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":189 */
  __pyx_v_end1 = (((unsigned char *)__pyx_v_path1) + __pyx_v_size1);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":190 */
  __pyx_v_end2 = (((unsigned char *)__pyx_v_path2) + __pyx_v_size2);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":197 */
  __pyx_1 = __pyx_f_21_dirstate_helpers_pyx__is_aligned(__pyx_v_path1);
  if (__pyx_1) {
    __pyx_1 = __pyx_f_21_dirstate_helpers_pyx__is_aligned(__pyx_v_path2);
  }
  if (__pyx_1) {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":198 */
    __pyx_v_cur_int1 = ((int *)__pyx_v_path1);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":199 */
    __pyx_v_cur_int2 = ((int *)__pyx_v_path2);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":200 */
    __pyx_v_end_int1 = ((int *)((__pyx_v_path1 + __pyx_v_size1) - (__pyx_v_size1 % (sizeof(int)))));

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":201 */
    __pyx_v_end_int2 = ((int *)((__pyx_v_path2 + __pyx_v_size2) - (__pyx_v_size2 % (sizeof(int)))));

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":203 */
    while (1) {
      __pyx_1 = (__pyx_v_cur_int1 < __pyx_v_end_int1);
      if (__pyx_1) {
        __pyx_1 = (__pyx_v_cur_int2 < __pyx_v_end_int2);
      }
      if (!__pyx_1) break;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":204 */
      __pyx_1 = ((__pyx_v_cur_int1[0]) != (__pyx_v_cur_int2[0]));
      if (__pyx_1) {
        goto __pyx_L5;
        goto __pyx_L6;
      }
      __pyx_L6:;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":206 */
      __pyx_v_cur_int1 = (__pyx_v_cur_int1 + 1);

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":207 */
      __pyx_v_cur_int2 = (__pyx_v_cur_int2 + 1);
    }
    __pyx_L5:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":209 */
    __pyx_v_cur1 = ((unsigned char *)__pyx_v_cur_int1);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":210 */
    __pyx_v_cur2 = ((unsigned char *)__pyx_v_cur_int2);
    goto __pyx_L3;
  }
  /*else*/ {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":212 */
    __pyx_v_cur1 = ((unsigned char *)__pyx_v_path1);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":213 */
    __pyx_v_cur2 = ((unsigned char *)__pyx_v_path2);
  }
  __pyx_L3:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":215 */
  while (1) {
    __pyx_1 = (__pyx_v_cur1 < __pyx_v_end1);
    if (__pyx_1) {
      __pyx_1 = (__pyx_v_cur2 < __pyx_v_end2);
    }
    if (!__pyx_1) break;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":216 */
    __pyx_1 = ((__pyx_v_cur1[0]) == (__pyx_v_cur2[0]));
    if (__pyx_1) {

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":218 */
      __pyx_v_cur1 = (__pyx_v_cur1 + 1);

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":219 */
      __pyx_v_cur2 = (__pyx_v_cur2 + 1);

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":220 */
      goto __pyx_L7;
      goto __pyx_L9;
    }
    __pyx_L9:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":222 */
    __pyx_1 = ((__pyx_v_cur1[0]) == '/');
    if (__pyx_1) {
      __pyx_r = (-1);
      goto __pyx_L0;
      goto __pyx_L10;
    }
    __pyx_1 = ((__pyx_v_cur2[0]) == '/');
    if (__pyx_1) {
      __pyx_r = 1;
      goto __pyx_L0;
      goto __pyx_L10;
    }
    __pyx_1 = ((__pyx_v_cur1[0]) < (__pyx_v_cur2[0]));
    if (__pyx_1) {
      __pyx_r = (-1);
      goto __pyx_L0;
      goto __pyx_L10;
    }
    /*else*/ {
      __pyx_r = 1;
      goto __pyx_L0;
    }
    __pyx_L10:;
    __pyx_L7:;
  }

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":232 */
  __pyx_1 = (__pyx_v_cur1 < __pyx_v_end1);
  if (__pyx_1) {
    __pyx_r = 1;
    goto __pyx_L0;
    goto __pyx_L11;
  }
  __pyx_L11:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":234 */
  __pyx_1 = (__pyx_v_cur2 < __pyx_v_end2);
  if (__pyx_1) {
    __pyx_r = (-1);
    goto __pyx_L0;
    goto __pyx_L12;
  }
  __pyx_L12:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":237 */
  __pyx_r = 0;
  goto __pyx_L0;

  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

static PyObject *__pyx_k30p;
static PyObject *__pyx_k31p;

static char __pyx_k30[] = "'path1' must be a plain string, not %s: %r";
static char __pyx_k31[] = "'path2' must be a plain string, not %s: %r";

static PyObject *__pyx_f_21_dirstate_helpers_pyx_cmp_by_dirs(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_21_dirstate_helpers_pyx_cmp_by_dirs[] = "Compare two paths directory by directory.\n\n    This is equivalent to doing::\n\n       cmp(path1.split(\'/\'), path2.split(\'/\'))\n\n    The idea is that you should compare path components separately. This\n    differs from plain ``cmp(path1, path2)`` for paths like ``\'a-b\'`` and\n    ``a/b``. \"a-b\" comes after \"a\" but would come before \"a/b\" lexically.\n\n    :param path1: first path\n    :param path2: second path\n    :return: negative number if ``path1`` comes first,\n        0 if paths are equal,\n        and positive number if ``path2`` sorts first\n    ";
static PyObject *__pyx_f_21_dirstate_helpers_pyx_cmp_by_dirs(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_path1 = 0;
  PyObject *__pyx_v_path2 = 0;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"path1","path2",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_path1, &__pyx_v_path2)) return 0;
  Py_INCREF(__pyx_v_path1);
  Py_INCREF(__pyx_v_path2);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":257 */
  __pyx_1 = (!PyString_CheckExact(__pyx_v_path1));
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 259; goto __pyx_L1;}
    Py_INCREF(__pyx_v_path1);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_path1);
    __pyx_3 = PyObject_CallObject(((PyObject *)(&PyType_Type)), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 259; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 259; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    Py_INCREF(__pyx_v_path1);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_path1);
    __pyx_3 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k30p, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 259; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 258; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_TypeError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 258; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 258; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":260 */
  __pyx_1 = (!PyString_CheckExact(__pyx_v_path2));
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 262; goto __pyx_L1;}
    Py_INCREF(__pyx_v_path2);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_path2);
    __pyx_3 = PyObject_CallObject(((PyObject *)(&PyType_Type)), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 262; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 262; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    Py_INCREF(__pyx_v_path2);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_path2);
    __pyx_3 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k31p, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 262; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 261; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_TypeError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 261; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 261; goto __pyx_L1;}
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":263 */
  __pyx_2 = PyInt_FromLong(__pyx_f_21_dirstate_helpers_pyx__cmp_by_dirs(PyString_AsString(__pyx_v_path1),PyString_Size(__pyx_v_path1),PyString_AsString(__pyx_v_path2),PyString_Size(__pyx_v_path2))); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 263; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("_dirstate_helpers_pyx.cmp_by_dirs");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_path1);
  Py_DECREF(__pyx_v_path2);
  return __pyx_r;
}

static PyObject *__pyx_k32p;
static PyObject *__pyx_k33p;

static char __pyx_k32[] = "'path1' must be a plain string, not %s: %r";
static char __pyx_k33[] = "'path2' must be a plain string, not %s: %r";

static PyObject *__pyx_f_21_dirstate_helpers_pyx__cmp_path_by_dirblock(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_21_dirstate_helpers_pyx__cmp_path_by_dirblock[] = "Compare two paths based on what directory they are in.\n\n    This generates a sort order, such that all children of a directory are\n    sorted together, and grandchildren are in the same order as the\n    children appear. But all grandchildren come after all children.\n\n    In other words, all entries in a directory are sorted together, and\n    directorys are sorted in cmp_by_dirs order.\n\n    :param path1: first path\n    :param path2: the second path\n    :return: negative number if ``path1`` comes first,\n        0 if paths are equal\n        and a positive number if ``path2`` sorts first\n    ";
static PyObject *__pyx_f_21_dirstate_helpers_pyx__cmp_path_by_dirblock(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_path1 = 0;
  PyObject *__pyx_v_path2 = 0;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"path1","path2",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_path1, &__pyx_v_path2)) return 0;
  Py_INCREF(__pyx_v_path1);
  Py_INCREF(__pyx_v_path2);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":285 */
  __pyx_1 = (!PyString_CheckExact(__pyx_v_path1));
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 287; goto __pyx_L1;}
    Py_INCREF(__pyx_v_path1);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_path1);
    __pyx_3 = PyObject_CallObject(((PyObject *)(&PyType_Type)), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 287; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 287; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    Py_INCREF(__pyx_v_path1);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_path1);
    __pyx_3 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k32p, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 287; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 286; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_TypeError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 286; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 286; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":288 */
  __pyx_1 = (!PyString_CheckExact(__pyx_v_path2));
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 290; goto __pyx_L1;}
    Py_INCREF(__pyx_v_path2);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_path2);
    __pyx_3 = PyObject_CallObject(((PyObject *)(&PyType_Type)), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 290; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 290; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    Py_INCREF(__pyx_v_path2);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_path2);
    __pyx_3 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k33p, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 290; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 289; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_TypeError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 289; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 289; goto __pyx_L1;}
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":291 */
  __pyx_2 = PyInt_FromLong(__pyx_f_21_dirstate_helpers_pyx__cmp_path_by_dirblock_intern(PyString_AsString(__pyx_v_path1),PyString_Size(__pyx_v_path1),PyString_AsString(__pyx_v_path2),PyString_Size(__pyx_v_path2))); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 291; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("_dirstate_helpers_pyx._cmp_path_by_dirblock");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_path1);
  Py_DECREF(__pyx_v_path2);
  return __pyx_r;
}

static char __pyx_k34[] = "";
static char __pyx_k35[] = "";

static int __pyx_f_21_dirstate_helpers_pyx__cmp_path_by_dirblock_intern(char *__pyx_v_path1,int __pyx_v_path1_len,char *__pyx_v_path2,int __pyx_v_path2_len) {
  char *__pyx_v_dirname1;
  int __pyx_v_dirname1_len;
  char *__pyx_v_dirname2;
  int __pyx_v_dirname2_len;
  char *__pyx_v_basename1;
  int __pyx_v_basename1_len;
  char *__pyx_v_basename2;
  int __pyx_v_basename2_len;
  int __pyx_v_cur_len;
  int __pyx_v_cmp_val;
  int __pyx_r;
  int __pyx_1;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":314 */
  __pyx_1 = (__pyx_v_path1_len == 0);
  if (__pyx_1) {
    __pyx_1 = (__pyx_v_path2_len == 0);
  }
  if (__pyx_1) {
    __pyx_r = 0;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":317 */
  __pyx_1 = (__pyx_v_path1 == __pyx_v_path2);
  if (__pyx_1) {
    __pyx_1 = (__pyx_v_path1_len == __pyx_v_path2_len);
  }
  if (__pyx_1) {
    __pyx_r = 0;
    goto __pyx_L0;
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":320 */
  __pyx_1 = (__pyx_v_path1_len == 0);
  if (__pyx_1) {
    __pyx_r = (-1);
    goto __pyx_L0;
    goto __pyx_L4;
  }
  __pyx_L4:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":323 */
  __pyx_1 = (__pyx_v_path2_len == 0);
  if (__pyx_1) {
    __pyx_r = 1;
    goto __pyx_L0;
    goto __pyx_L5;
  }
  __pyx_L5:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":326 */
  __pyx_v_basename1 = ((char *)__pyx_f_21_dirstate_helpers_pyx__my_memrchr(__pyx_v_path1,'/',__pyx_v_path1_len));

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":328 */
  __pyx_1 = (__pyx_v_basename1 == NULL);
  if (__pyx_1) {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":329 */
    __pyx_v_basename1 = __pyx_v_path1;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":330 */
    __pyx_v_basename1_len = __pyx_v_path1_len;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":331 */
    __pyx_v_dirname1 = __pyx_k34;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":332 */
    __pyx_v_dirname1_len = 0;
    goto __pyx_L6;
  }
  /*else*/ {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":334 */
    __pyx_v_dirname1 = __pyx_v_path1;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":335 */
    __pyx_v_dirname1_len = (__pyx_v_basename1 - __pyx_v_path1);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":336 */
    __pyx_v_basename1 = (__pyx_v_basename1 + 1);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":337 */
    __pyx_v_basename1_len = ((__pyx_v_path1_len - __pyx_v_dirname1_len) - 1);
  }
  __pyx_L6:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":339 */
  __pyx_v_basename2 = ((char *)__pyx_f_21_dirstate_helpers_pyx__my_memrchr(__pyx_v_path2,'/',__pyx_v_path2_len));

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":341 */
  __pyx_1 = (__pyx_v_basename2 == NULL);
  if (__pyx_1) {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":342 */
    __pyx_v_basename2 = __pyx_v_path2;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":343 */
    __pyx_v_basename2_len = __pyx_v_path2_len;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":344 */
    __pyx_v_dirname2 = __pyx_k35;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":345 */
    __pyx_v_dirname2_len = 0;
    goto __pyx_L7;
  }
  /*else*/ {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":347 */
    __pyx_v_dirname2 = __pyx_v_path2;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":348 */
    __pyx_v_dirname2_len = (__pyx_v_basename2 - __pyx_v_path2);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":349 */
    __pyx_v_basename2 = (__pyx_v_basename2 + 1);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":350 */
    __pyx_v_basename2_len = ((__pyx_v_path2_len - __pyx_v_dirname2_len) - 1);
  }
  __pyx_L7:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":352 */
  __pyx_v_cmp_val = __pyx_f_21_dirstate_helpers_pyx__cmp_by_dirs(__pyx_v_dirname1,__pyx_v_dirname1_len,__pyx_v_dirname2,__pyx_v_dirname2_len);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":354 */
  __pyx_1 = (__pyx_v_cmp_val != 0);
  if (__pyx_1) {
    __pyx_r = __pyx_v_cmp_val;
    goto __pyx_L0;
    goto __pyx_L8;
  }
  __pyx_L8:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":357 */
  __pyx_v_cur_len = __pyx_v_basename1_len;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":358 */
  __pyx_1 = (__pyx_v_basename2_len < __pyx_v_basename1_len);
  if (__pyx_1) {
    __pyx_v_cur_len = __pyx_v_basename2_len;
    goto __pyx_L9;
  }
  __pyx_L9:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":361 */
  __pyx_v_cmp_val = memcmp(__pyx_v_basename1,__pyx_v_basename2,__pyx_v_cur_len);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":362 */
  __pyx_1 = (__pyx_v_cmp_val != 0);
  if (__pyx_1) {
    __pyx_r = __pyx_v_cmp_val;
    goto __pyx_L0;
    goto __pyx_L10;
  }
  __pyx_L10:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":364 */
  __pyx_1 = (__pyx_v_basename1_len == __pyx_v_basename2_len);
  if (__pyx_1) {
    __pyx_r = 0;
    goto __pyx_L0;
    goto __pyx_L11;
  }
  __pyx_L11:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":366 */
  __pyx_1 = (__pyx_v_basename1_len < __pyx_v_basename2_len);
  if (__pyx_1) {
    __pyx_r = (-1);
    goto __pyx_L0;
    goto __pyx_L12;
  }
  __pyx_L12:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":368 */
  __pyx_r = 1;
  goto __pyx_L0;

  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

static PyObject *__pyx_k36p;
static PyObject *__pyx_k37p;

static char __pyx_k36[] = "you must pass a python list for 'paths' not: %s %r";
static char __pyx_k37[] = "you must pass a string for 'path' not: %s %r";

static PyObject *__pyx_f_21_dirstate_helpers_pyx__bisect_path_left(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_21_dirstate_helpers_pyx__bisect_path_left[] = "Return the index where to insert path into paths.\n\n    This uses a path-wise comparison so we get::\n        a\n        a-b\n        a=b\n        a/b\n    Rather than::\n        a\n        a-b\n        a/b\n        a=b\n    :param paths: A list of paths to search through\n    :param path: A single path to insert\n    :return: An offset where \'path\' can be inserted.\n    :seealso: bisect.bisect_left\n    ";
static PyObject *__pyx_f_21_dirstate_helpers_pyx__bisect_path_left(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_paths = 0;
  PyObject *__pyx_v_path = 0;
  int __pyx_v__lo;
  int __pyx_v__hi;
  int __pyx_v__mid;
  char *__pyx_v_path_cstr;
  int __pyx_v_path_size;
  char *__pyx_v_cur_cstr;
  int __pyx_v_cur_size;
  void *__pyx_v_cur;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_ssize_t __pyx_4;
  static char *__pyx_argnames[] = {"paths","path",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_paths, &__pyx_v_path)) return 0;
  Py_INCREF(__pyx_v_paths);
  Py_INCREF(__pyx_v_path);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":398 */
  __pyx_1 = (!PyList_CheckExact(__pyx_v_paths));
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 400; goto __pyx_L1;}
    Py_INCREF(__pyx_v_paths);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_paths);
    __pyx_3 = PyObject_CallObject(((PyObject *)(&PyType_Type)), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 400; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 400; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    Py_INCREF(__pyx_v_paths);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_paths);
    __pyx_3 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k36p, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 400; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 399; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_TypeError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 399; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 399; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":401 */
  __pyx_1 = (!PyString_CheckExact(__pyx_v_path));
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 403; goto __pyx_L1;}
    Py_INCREF(__pyx_v_path);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_path);
    __pyx_3 = PyObject_CallObject(((PyObject *)(&PyType_Type)), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 403; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 403; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    Py_INCREF(__pyx_v_path);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_path);
    __pyx_3 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k37p, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 403; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 402; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_TypeError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 402; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 402; goto __pyx_L1;}
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":405 */
  __pyx_4 = PyObject_Length(__pyx_v_paths); if (__pyx_4 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 405; goto __pyx_L1;}
  __pyx_v__hi = __pyx_4;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":406 */
  __pyx_v__lo = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":408 */
  __pyx_v_path_cstr = PyString_AsString(__pyx_v_path);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":409 */
  __pyx_v_path_size = PyString_Size(__pyx_v_path);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":411 */
  while (1) {
    __pyx_1 = (__pyx_v__lo < __pyx_v__hi);
    if (!__pyx_1) break;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":412 */
    __pyx_v__mid = ((__pyx_v__lo + __pyx_v__hi) / 2);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":413 */
    __pyx_v_cur = PyList_GET_ITEM(__pyx_v_paths,__pyx_v__mid);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":414 */
    __pyx_v_cur_cstr = PyString_AS_STRING(__pyx_v_cur);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":415 */
    __pyx_v_cur_size = PyString_GET_SIZE(__pyx_v_cur);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":416 */
    __pyx_1 = (__pyx_f_21_dirstate_helpers_pyx__cmp_path_by_dirblock_intern(__pyx_v_cur_cstr,__pyx_v_cur_size,__pyx_v_path_cstr,__pyx_v_path_size) < 0);
    if (__pyx_1) {
      __pyx_v__lo = (__pyx_v__mid + 1);
      goto __pyx_L6;
    }
    /*else*/ {
      __pyx_v__hi = __pyx_v__mid;
    }
    __pyx_L6:;
  }

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":421 */
  __pyx_2 = PyInt_FromLong(__pyx_v__lo); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 421; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("_dirstate_helpers_pyx._bisect_path_left");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_paths);
  Py_DECREF(__pyx_v_path);
  return __pyx_r;
}

static PyObject *__pyx_k38p;
static PyObject *__pyx_k39p;

static char __pyx_k38[] = "you must pass a python list for 'paths' not: %s %r";
static char __pyx_k39[] = "you must pass a string for 'path' not: %s %r";

static PyObject *__pyx_f_21_dirstate_helpers_pyx__bisect_path_right(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_21_dirstate_helpers_pyx__bisect_path_right[] = "Return the index where to insert path into paths.\n\n    This uses a path-wise comparison so we get::\n        a\n        a-b\n        a=b\n        a/b\n    Rather than::\n        a\n        a-b\n        a/b\n        a=b\n    :param paths: A list of paths to search through\n    :param path: A single path to insert\n    :return: An offset where \'path\' can be inserted.\n    :seealso: bisect.bisect_right\n    ";
static PyObject *__pyx_f_21_dirstate_helpers_pyx__bisect_path_right(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_paths = 0;
  PyObject *__pyx_v_path = 0;
  int __pyx_v__lo;
  int __pyx_v__hi;
  int __pyx_v__mid;
  char *__pyx_v_path_cstr;
  int __pyx_v_path_size;
  char *__pyx_v_cur_cstr;
  int __pyx_v_cur_size;
  void *__pyx_v_cur;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_ssize_t __pyx_4;
  static char *__pyx_argnames[] = {"paths","path",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_paths, &__pyx_v_path)) return 0;
  Py_INCREF(__pyx_v_paths);
  Py_INCREF(__pyx_v_path);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":451 */
  __pyx_1 = (!PyList_CheckExact(__pyx_v_paths));
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 453; goto __pyx_L1;}
    Py_INCREF(__pyx_v_paths);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_paths);
    __pyx_3 = PyObject_CallObject(((PyObject *)(&PyType_Type)), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 453; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 453; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    Py_INCREF(__pyx_v_paths);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_paths);
    __pyx_3 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k38p, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 453; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 452; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_TypeError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 452; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 452; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":454 */
  __pyx_1 = (!PyString_CheckExact(__pyx_v_path));
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 456; goto __pyx_L1;}
    Py_INCREF(__pyx_v_path);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_path);
    __pyx_3 = PyObject_CallObject(((PyObject *)(&PyType_Type)), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 456; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 456; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    Py_INCREF(__pyx_v_path);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_path);
    __pyx_3 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k39p, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 456; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 455; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_TypeError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 455; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 455; goto __pyx_L1;}
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":458 */
  __pyx_4 = PyObject_Length(__pyx_v_paths); if (__pyx_4 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 458; goto __pyx_L1;}
  __pyx_v__hi = __pyx_4;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":459 */
  __pyx_v__lo = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":461 */
  __pyx_v_path_cstr = PyString_AsString(__pyx_v_path);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":462 */
  __pyx_v_path_size = PyString_Size(__pyx_v_path);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":464 */
  while (1) {
    __pyx_1 = (__pyx_v__lo < __pyx_v__hi);
    if (!__pyx_1) break;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":465 */
    __pyx_v__mid = ((__pyx_v__lo + __pyx_v__hi) / 2);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":466 */
    __pyx_v_cur = PyList_GET_ITEM(__pyx_v_paths,__pyx_v__mid);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":467 */
    __pyx_v_cur_cstr = PyString_AS_STRING(__pyx_v_cur);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":468 */
    __pyx_v_cur_size = PyString_GET_SIZE(__pyx_v_cur);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":469 */
    __pyx_1 = (__pyx_f_21_dirstate_helpers_pyx__cmp_path_by_dirblock_intern(__pyx_v_path_cstr,__pyx_v_path_size,__pyx_v_cur_cstr,__pyx_v_cur_size) < 0);
    if (__pyx_1) {
      __pyx_v__hi = __pyx_v__mid;
      goto __pyx_L6;
    }
    /*else*/ {
      __pyx_v__lo = (__pyx_v__mid + 1);
    }
    __pyx_L6:;
  }

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":474 */
  __pyx_2 = PyInt_FromLong(__pyx_v__lo); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 474; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("_dirstate_helpers_pyx._bisect_path_right");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_paths);
  Py_DECREF(__pyx_v_path);
  return __pyx_r;
}

static PyObject *__pyx_k40p;
static PyObject *__pyx_k41p;

static char __pyx_k40[] = "you must pass a python list for 'dirblocks' not: %s %r";
static char __pyx_k41[] = "you must pass a string for dirname not: %s %r";

static PyObject *__pyx_f_21_dirstate_helpers_pyx_bisect_dirblock(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_21_dirstate_helpers_pyx_bisect_dirblock[] = "Return the index where to insert dirname into the dirblocks.\n\n    The return value idx is such that all directories blocks in dirblock[:idx]\n    have names < dirname, and all blocks in dirblock[idx:] have names >=\n    dirname.\n\n    Optional args lo (default 0) and hi (default len(dirblocks)) bound the\n    slice of a to be searched.\n    ";
static PyObject *__pyx_f_21_dirstate_helpers_pyx_bisect_dirblock(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_dirblocks = 0;
  PyObject *__pyx_v_dirname = 0;
  PyObject *__pyx_v_lo = 0;
  PyObject *__pyx_v_hi = 0;
  PyObject *__pyx_v_cache = 0;
  int __pyx_v__lo;
  int __pyx_v__hi;
  int __pyx_v__mid;
  char *__pyx_v_dirname_cstr;
  int __pyx_v_dirname_size;
  char *__pyx_v_cur_cstr;
  int __pyx_v_cur_size;
  void *__pyx_v_cur;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_ssize_t __pyx_4;
  static char *__pyx_argnames[] = {"dirblocks","dirname","lo","hi","cache",0};
  __pyx_v_lo = __pyx_k17;
  __pyx_v_hi = __pyx_k18;
  __pyx_v_cache = __pyx_k19;
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO|OOO", __pyx_argnames, &__pyx_v_dirblocks, &__pyx_v_dirname, &__pyx_v_lo, &__pyx_v_hi, &__pyx_v_cache)) return 0;
  Py_INCREF(__pyx_v_dirblocks);
  Py_INCREF(__pyx_v_dirname);
  Py_INCREF(__pyx_v_lo);
  Py_INCREF(__pyx_v_hi);
  Py_INCREF(__pyx_v_cache);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":496 */
  __pyx_1 = (!PyList_CheckExact(__pyx_v_dirblocks));
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 498; goto __pyx_L1;}
    Py_INCREF(__pyx_v_dirblocks);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_dirblocks);
    __pyx_3 = PyObject_CallObject(((PyObject *)(&PyType_Type)), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 498; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 498; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    Py_INCREF(__pyx_v_dirblocks);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_dirblocks);
    __pyx_3 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k40p, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 498; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 497; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_TypeError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 497; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 497; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":499 */
  __pyx_1 = (!PyString_CheckExact(__pyx_v_dirname));
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 501; goto __pyx_L1;}
    Py_INCREF(__pyx_v_dirname);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_dirname);
    __pyx_3 = PyObject_CallObject(((PyObject *)(&PyType_Type)), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 501; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 501; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    Py_INCREF(__pyx_v_dirname);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_dirname);
    __pyx_3 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k41p, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 501; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 500; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_TypeError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 500; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 500; goto __pyx_L1;}
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":502 */
  __pyx_1 = __pyx_v_hi == Py_None;
  if (__pyx_1) {
    __pyx_4 = PyObject_Length(__pyx_v_dirblocks); if (__pyx_4 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 503; goto __pyx_L1;}
    __pyx_v__hi = __pyx_4;
    goto __pyx_L4;
  }
  /*else*/ {
    __pyx_1 = PyInt_AsLong(__pyx_v_hi); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 505; goto __pyx_L1;}
    __pyx_v__hi = __pyx_1;
  }
  __pyx_L4:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":507 */
  __pyx_1 = PyInt_AsLong(__pyx_v_lo); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 507; goto __pyx_L1;}
  __pyx_v__lo = __pyx_1;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":508 */
  __pyx_v_dirname_cstr = PyString_AsString(__pyx_v_dirname);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":509 */
  __pyx_v_dirname_size = PyString_Size(__pyx_v_dirname);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":511 */
  while (1) {
    __pyx_1 = (__pyx_v__lo < __pyx_v__hi);
    if (!__pyx_1) break;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":512 */
    __pyx_v__mid = ((__pyx_v__lo + __pyx_v__hi) / 2);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":515 */
    __pyx_v_cur = PyTuple_GET_ITEM(PyList_GET_ITEM(__pyx_v_dirblocks,__pyx_v__mid),0);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":517 */
    __pyx_v_cur_cstr = PyString_AS_STRING(__pyx_v_cur);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":518 */
    __pyx_v_cur_size = PyString_GET_SIZE(__pyx_v_cur);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":519 */
    __pyx_1 = (__pyx_f_21_dirstate_helpers_pyx__cmp_by_dirs(__pyx_v_cur_cstr,__pyx_v_cur_size,__pyx_v_dirname_cstr,__pyx_v_dirname_size) < 0);
    if (__pyx_1) {
      __pyx_v__lo = (__pyx_v__mid + 1);
      goto __pyx_L7;
    }
    /*else*/ {
      __pyx_v__hi = __pyx_v__mid;
    }
    __pyx_L7:;
  }

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":523 */
  __pyx_2 = PyInt_FromLong(__pyx_v__lo); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 523; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("_dirstate_helpers_pyx.bisect_dirblock");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_dirblocks);
  Py_DECREF(__pyx_v_dirname);
  Py_DECREF(__pyx_v_lo);
  Py_DECREF(__pyx_v_hi);
  Py_DECREF(__pyx_v_cache);
  return __pyx_r;
}

static int __pyx_f_21_dirstate_helpers_pyx_6Reader___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_21_dirstate_helpers_pyx_6Reader___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_text = 0;
  PyObject *__pyx_v_state = 0;
  int __pyx_r;
  static char *__pyx_argnames[] = {"text","state",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_text, &__pyx_v_state)) return -1;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_text);
  Py_INCREF(__pyx_v_state);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":539 */
  Py_INCREF(__pyx_v_state);
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)__pyx_v_self)->state);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)__pyx_v_self)->state = __pyx_v_state;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":540 */
  Py_INCREF(__pyx_v_text);
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)__pyx_v_self)->text);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)__pyx_v_self)->text = __pyx_v_text;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":541 */
  ((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)__pyx_v_self)->text_cstr = PyString_AsString(__pyx_v_text);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":542 */
  ((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)__pyx_v_self)->text_size = PyString_Size(__pyx_v_text);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":543 */
  ((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)__pyx_v_self)->end_cstr = (((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)__pyx_v_self)->text_cstr + ((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)__pyx_v_self)->text_size);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":544 */
  ((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)__pyx_v_self)->cur_cstr = ((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)__pyx_v_self)->text_cstr;

  __pyx_r = 0;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_text);
  Py_DECREF(__pyx_v_state);
  return __pyx_r;
}

static PyObject *__pyx_n_DirstateCorrupt;

static PyObject *__pyx_k42p;
static PyObject *__pyx_k43p;
static PyObject *__pyx_k44p;

static char __pyx_k42[] = "get_next() called when cur_str is NULL";
static char __pyx_k43[] = "get_next() called when there are no chars left";
static char __pyx_k44[] = "failed to find trailing NULL (\\0). Trailing garbage: %r";

static char *__pyx_f_21_dirstate_helpers_pyx_6Reader_get_next(struct __pyx_obj_21_dirstate_helpers_pyx_Reader *__pyx_v_self,int *__pyx_v_size) {
  char *__pyx_v_next;
  Py_ssize_t __pyx_v_extra_len;
  char *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  Py_INCREF(__pyx_v_self);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":551 */
  __pyx_1 = (__pyx_v_self->cur_cstr == NULL);
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 552; goto __pyx_L1;}
    Py_INCREF(__pyx_k42p);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_k42p);
    __pyx_3 = PyObject_CallObject(PyExc_AssertionError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 552; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 552; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_1 = (__pyx_v_self->cur_cstr >= __pyx_v_self->end_cstr);
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 554; goto __pyx_L1;}
    Py_INCREF(__pyx_k43p);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_k43p);
    __pyx_3 = PyObject_CallObject(PyExc_AssertionError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 554; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 554; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":556 */
  __pyx_v_next = __pyx_v_self->cur_cstr;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":557 */
  __pyx_v_self->cur_cstr = ((char *)memchr(__pyx_v_next,'\0',(__pyx_v_self->end_cstr - __pyx_v_next)));

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":558 */
  __pyx_1 = (__pyx_v_self->cur_cstr == NULL);
  if (__pyx_1) {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":559 */
    __pyx_v_extra_len = (__pyx_v_self->end_cstr - __pyx_v_next);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":560 */
    __pyx_2 = __Pyx_GetName(__pyx_m, __pyx_n_errors); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 560; goto __pyx_L1;}
    __pyx_3 = PyObject_GetAttr(__pyx_2, __pyx_n_DirstateCorrupt); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 560; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = __pyx_f_21_dirstate_helpers_pyx_safe_string_from_size(__pyx_v_next,__pyx_v_extra_len); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 563; goto __pyx_L1;}
    __pyx_4 = PyNumber_Remainder(__pyx_k44p, __pyx_2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 563; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 560; goto __pyx_L1;}
    Py_INCREF(__pyx_v_self->state);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self->state);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_4);
    __pyx_4 = 0;
    __pyx_4 = PyObject_CallObject(__pyx_3, __pyx_2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 560; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_4, 0, 0);
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 560; goto __pyx_L1;}
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":564 */
  (__pyx_v_size[0]) = (__pyx_v_self->cur_cstr - __pyx_v_next);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":565 */
  __pyx_v_self->cur_cstr = (__pyx_v_self->cur_cstr + 1);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":566 */
  __pyx_r = __pyx_v_next;
  goto __pyx_L0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("_dirstate_helpers_pyx.Reader.get_next");
  __pyx_r = NULL;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_f_21_dirstate_helpers_pyx_6Reader_get_next_str(struct __pyx_obj_21_dirstate_helpers_pyx_Reader *__pyx_v_self) {
  int __pyx_v_size;
  char *__pyx_v_next;
  PyObject *__pyx_r;
  char *__pyx_1;
  PyObject *__pyx_2 = 0;
  Py_INCREF(__pyx_v_self);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":572 */
  __pyx_1 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_Reader *)__pyx_v_self->__pyx_vtab)->get_next(__pyx_v_self,(&__pyx_v_size)); if (__pyx_1 == NULL) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 572; goto __pyx_L1;}
  __pyx_v_next = __pyx_1;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":573 */
  __pyx_2 = __pyx_f_21_dirstate_helpers_pyx_safe_string_from_size(__pyx_v_next,__pyx_v_size); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 573; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("_dirstate_helpers_pyx.Reader.get_next_str");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_k45p;

static char __pyx_k45[] = "First character should be null not: %s";

static int __pyx_f_21_dirstate_helpers_pyx_6Reader__init(struct __pyx_obj_21_dirstate_helpers_pyx_Reader *__pyx_v_self) {
  char *__pyx_v_first;
  int __pyx_v_size;
  int __pyx_r;
  char *__pyx_1;
  int __pyx_2;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  Py_INCREF(__pyx_v_self);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":586 */
  __pyx_1 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_Reader *)__pyx_v_self->__pyx_vtab)->get_next(__pyx_v_self,(&__pyx_v_size)); if (__pyx_1 == NULL) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 586; goto __pyx_L1;}
  __pyx_v_first = __pyx_1;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":587 */
  __pyx_2 = ((__pyx_v_first[0]) != '\0');
  if (__pyx_2) {
    __pyx_2 = (__pyx_v_size == 0);
  }
  if (__pyx_2) {
    __pyx_3 = PyString_FromString(__pyx_v_first); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 589; goto __pyx_L1;}
    __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 589; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k45p, __pyx_4); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 589; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 588; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_AssertionError, __pyx_4); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 588; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 588; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":590 */
  __pyx_r = 0;
  goto __pyx_L0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("_dirstate_helpers_pyx.Reader._init");
  __pyx_r = (-1);
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_k46p;

static char __pyx_k46[] = "Bad parse, we expected to end on \\n, not: %d %s: %s";

static PyObject *__pyx_f_21_dirstate_helpers_pyx_6Reader__get_entry(struct __pyx_obj_21_dirstate_helpers_pyx_Reader *__pyx_v_self,int __pyx_v_num_trees,void **__pyx_v_p_current_dirname,int *__pyx_v_new_block) {
  PyObject *__pyx_v_path_name_file_id_key;
  char *__pyx_v_entry_size_cstr;
  unsigned long __pyx_v_entry_size;
  char *__pyx_v_executable_cstr;
  int __pyx_v_is_executable;
  char *__pyx_v_dirname_cstr;
  char *__pyx_v_trailing;
  int __pyx_v_cur_size;
  int __pyx_v_i;
  PyObject *__pyx_v_minikind;
  PyObject *__pyx_v_fingerprint;
  PyObject *__pyx_v_info;
  PyObject *__pyx_v_dirname;
  PyObject *__pyx_v_trees;
  PyObject *__pyx_v_ret;
  PyObject *__pyx_r;
  char *__pyx_1;
  int __pyx_2;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  PyObject *__pyx_5 = 0;
  PyObject *__pyx_6 = 0;
  Py_INCREF(__pyx_v_self);
  __pyx_v_path_name_file_id_key = Py_None; Py_INCREF(Py_None);
  __pyx_v_minikind = Py_None; Py_INCREF(Py_None);
  __pyx_v_fingerprint = Py_None; Py_INCREF(Py_None);
  __pyx_v_info = Py_None; Py_INCREF(Py_None);
  __pyx_v_dirname = Py_None; Py_INCREF(Py_None);
  __pyx_v_trees = Py_None; Py_INCREF(Py_None);
  __pyx_v_ret = Py_None; Py_INCREF(Py_None);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":627 */
  __pyx_1 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_Reader *)__pyx_v_self->__pyx_vtab)->get_next(__pyx_v_self,(&__pyx_v_cur_size)); if (__pyx_1 == NULL) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 627; goto __pyx_L1;}
  __pyx_v_dirname_cstr = __pyx_1;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":635 */
  __pyx_2 = (__pyx_v_cur_size != PyString_GET_SIZE((__pyx_v_p_current_dirname[0])));
  if (!__pyx_2) {
    __pyx_2 = (strncmp(__pyx_v_dirname_cstr,PyString_AS_STRING((__pyx_v_p_current_dirname[0])),(__pyx_v_cur_size + 1)) != 0);
  }
  if (__pyx_2) {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":644 */
    __pyx_3 = __pyx_f_21_dirstate_helpers_pyx_safe_string_from_size(__pyx_v_dirname_cstr,__pyx_v_cur_size); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 644; goto __pyx_L1;}
    Py_DECREF(__pyx_v_dirname);
    __pyx_v_dirname = __pyx_3;
    __pyx_3 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":645 */
    (__pyx_v_p_current_dirname[0]) = ((void *)__pyx_v_dirname);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":646 */
    (__pyx_v_new_block[0]) = 1;
    goto __pyx_L2;
  }
  /*else*/ {
    (__pyx_v_new_block[0]) = 0;
  }
  __pyx_L2:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":653 */
  __pyx_3 = (PyObject *)(__pyx_v_p_current_dirname[0]);
  Py_INCREF(__pyx_3);
  __pyx_4 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_Reader *)__pyx_v_self->__pyx_vtab)->get_next_str(__pyx_v_self); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 654; goto __pyx_L1;}
  __pyx_5 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_Reader *)__pyx_v_self->__pyx_vtab)->get_next_str(__pyx_v_self); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 655; goto __pyx_L1;}
  __pyx_6 = PyTuple_New(3); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 653; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_6, 0, __pyx_3);
  PyTuple_SET_ITEM(__pyx_6, 1, __pyx_4);
  PyTuple_SET_ITEM(__pyx_6, 2, __pyx_5);
  __pyx_3 = 0;
  __pyx_4 = 0;
  __pyx_5 = 0;
  Py_DECREF(__pyx_v_path_name_file_id_key);
  __pyx_v_path_name_file_id_key = __pyx_6;
  __pyx_6 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":671 */
  __pyx_3 = PyList_New(0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 671; goto __pyx_L1;}
  Py_DECREF(__pyx_v_trees);
  __pyx_v_trees = __pyx_3;
  __pyx_3 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":672 */
  for (__pyx_v_i = 0; __pyx_v_i < __pyx_v_num_trees; ++__pyx_v_i) {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":673 */
    __pyx_4 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_Reader *)__pyx_v_self->__pyx_vtab)->get_next_str(__pyx_v_self); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 673; goto __pyx_L1;}
    Py_DECREF(__pyx_v_minikind);
    __pyx_v_minikind = __pyx_4;
    __pyx_4 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":674 */
    __pyx_5 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_Reader *)__pyx_v_self->__pyx_vtab)->get_next_str(__pyx_v_self); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 674; goto __pyx_L1;}
    Py_DECREF(__pyx_v_fingerprint);
    __pyx_v_fingerprint = __pyx_5;
    __pyx_5 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":675 */
    __pyx_1 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_Reader *)__pyx_v_self->__pyx_vtab)->get_next(__pyx_v_self,(&__pyx_v_cur_size)); if (__pyx_1 == NULL) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 675; goto __pyx_L1;}
    __pyx_v_entry_size_cstr = __pyx_1;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":676 */
    __pyx_v_entry_size = strtoul(__pyx_v_entry_size_cstr,NULL,10);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":677 */
    __pyx_1 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_Reader *)__pyx_v_self->__pyx_vtab)->get_next(__pyx_v_self,(&__pyx_v_cur_size)); if (__pyx_1 == NULL) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 677; goto __pyx_L1;}
    __pyx_v_executable_cstr = __pyx_1;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":678 */
    __pyx_v_is_executable = ((__pyx_v_executable_cstr[0]) == 'y');

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":679 */
    __pyx_6 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_Reader *)__pyx_v_self->__pyx_vtab)->get_next_str(__pyx_v_self); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 679; goto __pyx_L1;}
    Py_DECREF(__pyx_v_info);
    __pyx_v_info = __pyx_6;
    __pyx_6 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":680 */
    __pyx_3 = PyLong_FromUnsignedLong(__pyx_v_entry_size); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 683; goto __pyx_L1;}
    __pyx_4 = PyInt_FromLong(__pyx_v_is_executable); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 684; goto __pyx_L1;}
    __pyx_5 = PyTuple_New(5); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 681; goto __pyx_L1;}
    Py_INCREF(__pyx_v_minikind);
    PyTuple_SET_ITEM(__pyx_5, 0, __pyx_v_minikind);
    Py_INCREF(__pyx_v_fingerprint);
    PyTuple_SET_ITEM(__pyx_5, 1, __pyx_v_fingerprint);
    PyTuple_SET_ITEM(__pyx_5, 2, __pyx_3);
    PyTuple_SET_ITEM(__pyx_5, 3, __pyx_4);
    Py_INCREF(__pyx_v_info);
    PyTuple_SET_ITEM(__pyx_5, 4, __pyx_v_info);
    __pyx_3 = 0;
    __pyx_4 = 0;
    __pyx_2 = PyList_Append(__pyx_v_trees,__pyx_5); if (__pyx_2 == (-1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 680; goto __pyx_L1;}
    Py_DECREF(__pyx_5); __pyx_5 = 0;
  }

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":689 */
  __pyx_6 = PyTuple_New(2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 689; goto __pyx_L1;}
  Py_INCREF(__pyx_v_path_name_file_id_key);
  PyTuple_SET_ITEM(__pyx_6, 0, __pyx_v_path_name_file_id_key);
  Py_INCREF(__pyx_v_trees);
  PyTuple_SET_ITEM(__pyx_6, 1, __pyx_v_trees);
  Py_DECREF(__pyx_v_ret);
  __pyx_v_ret = __pyx_6;
  __pyx_6 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":693 */
  __pyx_1 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_Reader *)__pyx_v_self->__pyx_vtab)->get_next(__pyx_v_self,(&__pyx_v_cur_size)); if (__pyx_1 == NULL) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 693; goto __pyx_L1;}
  __pyx_v_trailing = __pyx_1;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":694 */
  __pyx_2 = (__pyx_v_cur_size != 1);
  if (!__pyx_2) {
    __pyx_2 = ((__pyx_v_trailing[0]) != '\n');
  }
  if (__pyx_2) {
    __pyx_3 = __Pyx_GetName(__pyx_m, __pyx_n_errors); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 695; goto __pyx_L1;}
    __pyx_4 = PyObject_GetAttr(__pyx_3, __pyx_n_DirstateCorrupt); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 695; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_5 = PyInt_FromLong(__pyx_v_cur_size); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 697; goto __pyx_L1;}
    __pyx_6 = __pyx_f_21_dirstate_helpers_pyx_safe_string_from_size(__pyx_v_trailing,__pyx_v_cur_size); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 697; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(3); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 697; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_5);
    PyTuple_SET_ITEM(__pyx_3, 1, __pyx_6);
    Py_INCREF(__pyx_v_ret);
    PyTuple_SET_ITEM(__pyx_3, 2, __pyx_v_ret);
    __pyx_5 = 0;
    __pyx_6 = 0;
    __pyx_5 = PyNumber_Remainder(__pyx_k46p, __pyx_3); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 697; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_6 = PyTuple_New(2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 695; goto __pyx_L1;}
    Py_INCREF(__pyx_v_self->state);
    PyTuple_SET_ITEM(__pyx_6, 0, __pyx_v_self->state);
    PyTuple_SET_ITEM(__pyx_6, 1, __pyx_5);
    __pyx_5 = 0;
    __pyx_3 = PyObject_CallObject(__pyx_4, __pyx_6); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 695; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 695; goto __pyx_L1;}
    goto __pyx_L5;
  }
  __pyx_L5:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":699 */
  Py_INCREF(__pyx_v_ret);
  __pyx_r = __pyx_v_ret;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_5);
  Py_XDECREF(__pyx_6);
  __Pyx_AddTraceback("_dirstate_helpers_pyx.Reader._get_entry");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_path_name_file_id_key);
  Py_DECREF(__pyx_v_minikind);
  Py_DECREF(__pyx_v_fingerprint);
  Py_DECREF(__pyx_v_info);
  Py_DECREF(__pyx_v_dirname);
  Py_DECREF(__pyx_v_trees);
  Py_DECREF(__pyx_v_ret);
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_n__num_present_parents;
static PyObject *__pyx_n__num_entries;
static PyObject *__pyx_n__dirblocks;
static PyObject *__pyx_n__split_root_dirblock_into_contents;

static PyObject *__pyx_k47p;
static PyObject *__pyx_k48p;
static PyObject *__pyx_k49p;
static PyObject *__pyx_k50p;

static char __pyx_k47[] = "";
static char __pyx_k48[] = "";
static char __pyx_k49[] = "";
static char __pyx_k50[] = "We read the wrong number of entries. We expected to read %s, but read %s";

static PyObject *__pyx_f_21_dirstate_helpers_pyx_6Reader__parse_dirblocks(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_21_dirstate_helpers_pyx_6Reader__parse_dirblocks[] = "Parse all dirblocks in the state file.";
static PyObject *__pyx_f_21_dirstate_helpers_pyx_6Reader__parse_dirblocks(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  int __pyx_v_num_trees;
  PyObject *__pyx_v_current_block;
  PyObject *__pyx_v_entry;
  void *__pyx_v_current_dirname;
  int __pyx_v_new_block;
  int __pyx_v_expected_entry_count;
  int __pyx_v_entry_count;
  PyObject *__pyx_v_dirblocks;
  PyObject *__pyx_v_obj;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  int __pyx_4;
  PyObject *__pyx_5 = 0;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return 0;
  Py_INCREF(__pyx_v_self);
  __pyx_v_current_block = Py_None; Py_INCREF(Py_None);
  __pyx_v_entry = Py_None; Py_INCREF(Py_None);
  __pyx_v_dirblocks = Py_None; Py_INCREF(Py_None);
  __pyx_v_obj = Py_None; Py_INCREF(Py_None);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":711 */
  __pyx_1 = PyObject_GetAttr(((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)__pyx_v_self)->state, __pyx_n__num_present_parents); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 711; goto __pyx_L1;}
  __pyx_2 = PyObject_CallObject(__pyx_1, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 711; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyInt_FromLong(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 711; goto __pyx_L1;}
  __pyx_3 = PyNumber_Add(__pyx_2, __pyx_1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 711; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_4 = PyInt_AsLong(__pyx_3); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 711; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_v_num_trees = __pyx_4;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":712 */
  __pyx_2 = PyObject_GetAttr(((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)__pyx_v_self)->state, __pyx_n__num_entries); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 712; goto __pyx_L1;}
  __pyx_4 = PyInt_AsLong(__pyx_2); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 712; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_v_expected_entry_count = __pyx_4;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":715 */
  __pyx_4 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_Reader *)((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)__pyx_v_self)->__pyx_vtab)->_init(((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)__pyx_v_self)); if (__pyx_4 == (-1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 715; goto __pyx_L1;}

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":717 */
  __pyx_1 = PyList_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 717; goto __pyx_L1;}
  Py_DECREF(__pyx_v_current_block);
  __pyx_v_current_block = __pyx_1;
  __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":718 */
  __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 718; goto __pyx_L1;}
  Py_INCREF(__pyx_k47p);
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_k47p);
  Py_INCREF(__pyx_v_current_block);
  PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_current_block);
  __pyx_2 = PyList_New(0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 718; goto __pyx_L1;}
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 718; goto __pyx_L1;}
  Py_INCREF(__pyx_k48p);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_k48p);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_2);
  __pyx_2 = 0;
  __pyx_2 = PyList_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 718; goto __pyx_L1;}
  PyList_SET_ITEM(__pyx_2, 0, __pyx_3);
  PyList_SET_ITEM(__pyx_2, 1, __pyx_1);
  __pyx_3 = 0;
  __pyx_1 = 0;
  Py_DECREF(__pyx_v_dirblocks);
  __pyx_v_dirblocks = __pyx_2;
  __pyx_2 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":719 */
  if (PyObject_SetAttr(((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)__pyx_v_self)->state, __pyx_n__dirblocks, __pyx_v_dirblocks) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 719; goto __pyx_L1;}

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":720 */
  Py_INCREF(__pyx_k49p);
  Py_DECREF(__pyx_v_obj);
  __pyx_v_obj = __pyx_k49p;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":721 */
  __pyx_v_current_dirname = ((void *)__pyx_v_obj);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":722 */
  __pyx_v_new_block = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":723 */
  __pyx_v_entry_count = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":732 */
  while (1) {
    __pyx_4 = (((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)__pyx_v_self)->cur_cstr < ((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)__pyx_v_self)->end_cstr);
    if (!__pyx_4) break;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":733 */
    __pyx_3 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_Reader *)((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)__pyx_v_self)->__pyx_vtab)->_get_entry(((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)__pyx_v_self),__pyx_v_num_trees,(&__pyx_v_current_dirname),(&__pyx_v_new_block)); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 733; goto __pyx_L1;}
    Py_DECREF(__pyx_v_entry);
    __pyx_v_entry = __pyx_3;
    __pyx_3 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":734 */
    __pyx_4 = __pyx_v_new_block;
    if (__pyx_4) {

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":736 */
      __pyx_1 = PyList_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 736; goto __pyx_L1;}
      Py_DECREF(__pyx_v_current_block);
      __pyx_v_current_block = __pyx_1;
      __pyx_1 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":737 */
      __pyx_2 = (PyObject *)__pyx_v_current_dirname;
      Py_INCREF(__pyx_2);
      __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 738; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_2);
      Py_INCREF(__pyx_v_current_block);
      PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_current_block);
      __pyx_2 = 0;
      __pyx_4 = PyList_Append(__pyx_v_dirblocks,__pyx_3); if (__pyx_4 == (-1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 737; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      goto __pyx_L4;
    }
    __pyx_L4:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":739 */
    __pyx_4 = PyList_Append(__pyx_v_current_block,__pyx_v_entry); if (__pyx_4 == (-1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 739; goto __pyx_L1;}

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":740 */
    __pyx_v_entry_count = (__pyx_v_entry_count + 1);
  }

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":741 */
  __pyx_4 = (__pyx_v_entry_count != __pyx_v_expected_entry_count);
  if (__pyx_4) {
    __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_errors); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 742; goto __pyx_L1;}
    __pyx_2 = PyObject_GetAttr(__pyx_1, __pyx_n_DirstateCorrupt); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 742; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_3 = PyInt_FromLong(__pyx_v_expected_entry_count); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 745; goto __pyx_L1;}
    __pyx_1 = PyInt_FromLong(__pyx_v_entry_count); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 745; goto __pyx_L1;}
    __pyx_5 = PyTuple_New(2); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 745; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_5, 0, __pyx_3);
    PyTuple_SET_ITEM(__pyx_5, 1, __pyx_1);
    __pyx_3 = 0;
    __pyx_1 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k50p, __pyx_5); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 745; goto __pyx_L1;}
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 742; goto __pyx_L1;}
    Py_INCREF(((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)__pyx_v_self)->state);
    PyTuple_SET_ITEM(__pyx_1, 0, ((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)__pyx_v_self)->state);
    PyTuple_SET_ITEM(__pyx_1, 1, __pyx_3);
    __pyx_3 = 0;
    __pyx_5 = PyObject_CallObject(__pyx_2, __pyx_1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 742; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __Pyx_Raise(__pyx_5, 0, 0);
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 742; goto __pyx_L1;}
    goto __pyx_L5;
  }
  __pyx_L5:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":746 */
  __pyx_3 = PyObject_GetAttr(((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)__pyx_v_self)->state, __pyx_n__split_root_dirblock_into_contents); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 746; goto __pyx_L1;}
  __pyx_2 = PyObject_CallObject(__pyx_3, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 746; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_5);
  __Pyx_AddTraceback("_dirstate_helpers_pyx.Reader._parse_dirblocks");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_current_block);
  Py_DECREF(__pyx_v_entry);
  Py_DECREF(__pyx_v_dirblocks);
  Py_DECREF(__pyx_v_obj);
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_n__state_file;
static PyObject *__pyx_n_seek;
static PyObject *__pyx_n__end_of_header;
static PyObject *__pyx_n_read;
static PyObject *__pyx_n__parse_dirblocks;
static PyObject *__pyx_n_IN_MEMORY_UNMODIFIED;
static PyObject *__pyx_n__dirblock_state;

static PyObject *__pyx_f_21_dirstate_helpers_pyx__read_dirblocks(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_21_dirstate_helpers_pyx__read_dirblocks[] = "Read in the dirblocks for the given DirState object.\n\n    This is tightly bound to the DirState internal representation. It should be\n    thought of as a member function, which is only separated out so that we can\n    re-write it in pyrex.\n\n    :param state: A DirState object.\n    :return: None\n    :postcondition: The dirblocks will be loaded into the appropriate fields in\n        the DirState object.\n    ";
static PyObject *__pyx_f_21_dirstate_helpers_pyx__read_dirblocks(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_state = 0;
  PyObject *__pyx_v_text;
  PyObject *__pyx_v_reader;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"state",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_state)) return 0;
  Py_INCREF(__pyx_v_state);
  __pyx_v_text = Py_None; Py_INCREF(Py_None);
  __pyx_v_reader = Py_None; Py_INCREF(Py_None);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":761 */
  __pyx_1 = PyObject_GetAttr(__pyx_v_state, __pyx_n__state_file); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 761; goto __pyx_L1;}
  __pyx_2 = PyObject_GetAttr(__pyx_1, __pyx_n_seek); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 761; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyObject_GetAttr(__pyx_v_state, __pyx_n__end_of_header); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 761; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 761; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_1);
  __pyx_1 = 0;
  __pyx_1 = PyObject_CallObject(__pyx_2, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 761; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":762 */
  __pyx_2 = PyObject_GetAttr(__pyx_v_state, __pyx_n__state_file); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 762; goto __pyx_L1;}
  __pyx_3 = PyObject_GetAttr(__pyx_2, __pyx_n_read); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 762; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_1 = PyObject_CallObject(__pyx_3, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 762; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_v_text);
  __pyx_v_text = __pyx_1;
  __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":765 */
  __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 765; goto __pyx_L1;}
  Py_INCREF(__pyx_v_text);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_text);
  Py_INCREF(__pyx_v_state);
  PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_state);
  __pyx_3 = PyObject_CallObject(((PyObject *)__pyx_ptype_21_dirstate_helpers_pyx_Reader), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 765; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_v_reader);
  __pyx_v_reader = __pyx_3;
  __pyx_3 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":767 */
  __pyx_1 = PyObject_GetAttr(__pyx_v_reader, __pyx_n__parse_dirblocks); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 767; goto __pyx_L1;}
  __pyx_2 = PyObject_CallObject(__pyx_1, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 767; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":768 */
  __pyx_3 = __Pyx_GetName(__pyx_m, __pyx_n_DirState); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 768; goto __pyx_L1;}
  __pyx_1 = PyObject_GetAttr(__pyx_3, __pyx_n_IN_MEMORY_UNMODIFIED); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 768; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  if (PyObject_SetAttr(__pyx_v_state, __pyx_n__dirblock_state, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 768; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("_dirstate_helpers_pyx._read_dirblocks");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_text);
  Py_DECREF(__pyx_v_reader);
  Py_DECREF(__pyx_v_state);
  return __pyx_r;
}

static int __pyx_f_21_dirstate_helpers_pyx_minikind_from_mode(int __pyx_v_mode) {
  int __pyx_r;
  int __pyx_1;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":773 */
  __pyx_1 = S_ISREG(__pyx_v_mode);
  if (__pyx_1) {
    __pyx_r = 'f';
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":775 */
  __pyx_1 = S_ISDIR(__pyx_v_mode);
  if (__pyx_1) {
    __pyx_r = 'd';
    goto __pyx_L0;
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":777 */
  __pyx_1 = S_ISLNK(__pyx_v_mode);
  if (__pyx_1) {
    __pyx_r = 'l';
    goto __pyx_L0;
    goto __pyx_L4;
  }
  __pyx_L4:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":779 */
  __pyx_r = 0;
  goto __pyx_L0;

  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

static PyObject *__pyx_n_st_size;
static PyObject *__pyx_n_st_mtime;
static PyObject *__pyx_n_st_ctime;
static PyObject *__pyx_n_st_dev;
static PyObject *__pyx_n_st_ino;
static PyObject *__pyx_n_st_mode;

static PyObject *__pyx_f_21_dirstate_helpers_pyx__pack_stat(PyObject *__pyx_v_stat_value) {
  char __pyx_v_result[(6 * 4)];
  int *__pyx_v_aliased;
  PyObject *__pyx_v_packed;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  unsigned long __pyx_2;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  Py_INCREF(__pyx_v_stat_value);
  __pyx_v_packed = Py_None; Py_INCREF(Py_None);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":794 */
  __pyx_v_aliased = ((int *)__pyx_v_result);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":795 */
  __pyx_1 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_size); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 795; goto __pyx_L1;}
  __pyx_2 = PyInt_AsUnsignedLongMask(__pyx_1); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 795; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  (__pyx_v_aliased[0]) = htonl(__pyx_2);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":796 */
  __pyx_1 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_mtime); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 796; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 796; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_1);
  __pyx_1 = 0;
  __pyx_1 = PyObject_CallObject(((PyObject *)(&PyInt_Type)), __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 796; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_2 = PyInt_AsUnsignedLongMask(__pyx_1); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 796; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  (__pyx_v_aliased[1]) = htonl(__pyx_2);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":797 */
  __pyx_3 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_ctime); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 797; goto __pyx_L1;}
  __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 797; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_3);
  __pyx_3 = 0;
  __pyx_3 = PyObject_CallObject(((PyObject *)(&PyInt_Type)), __pyx_1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 797; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_2 = PyInt_AsUnsignedLongMask(__pyx_3); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 797; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  (__pyx_v_aliased[2]) = htonl(__pyx_2);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":798 */
  __pyx_1 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_dev); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 798; goto __pyx_L1;}
  __pyx_2 = PyInt_AsUnsignedLongMask(__pyx_1); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 798; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  (__pyx_v_aliased[3]) = htonl(__pyx_2);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":799 */
  __pyx_3 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_ino); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 799; goto __pyx_L1;}
  __pyx_1 = PyInt_FromLong(0xFFFFFFFF); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 799; goto __pyx_L1;}
  __pyx_4 = PyNumber_And(__pyx_3, __pyx_1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 799; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_2 = PyInt_AsUnsignedLongMask(__pyx_4); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 799; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  (__pyx_v_aliased[4]) = htonl(__pyx_2);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":800 */
  __pyx_3 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_mode); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 800; goto __pyx_L1;}
  __pyx_2 = PyInt_AsUnsignedLongMask(__pyx_3); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 800; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  (__pyx_v_aliased[5]) = htonl(__pyx_2);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":801 */
  __pyx_1 = PyString_FromStringAndSize(__pyx_v_result,(6 * 4)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 801; goto __pyx_L1;}
  Py_DECREF(__pyx_v_packed);
  __pyx_v_packed = __pyx_1;
  __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":802 */
  __pyx_4 = __Pyx_GetName(__pyx_m, __pyx_n__encode); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 802; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 802; goto __pyx_L1;}
  Py_INCREF(__pyx_v_packed);
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_packed);
  __pyx_1 = PyObject_CallObject(__pyx_4, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 802; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_4 = PySequence_GetSlice(__pyx_1, 0, (-1)); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 802; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_r = __pyx_4;
  __pyx_4 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("_dirstate_helpers_pyx._pack_stat");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_packed);
  Py_DECREF(__pyx_v_stat_value);
  return __pyx_r;
}

static PyObject *__pyx_f_21_dirstate_helpers_pyx_update_entry(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_21_dirstate_helpers_pyx_update_entry[] = "Update the entry based on what is actually on disk.\n\n    This function only calculates the sha if it needs to - if the entry is\n    uncachable, or clearly different to the first parent\'s entry, no sha\n    is calculated, and None is returned.\n\n    :param entry: This is the dirblock entry for the file in question.\n    :param abspath: The path on disk for this file.\n    :param stat_value: (optional) if we already have done a stat on the\n        file, re-use it.\n    :return: None, or The sha1 hexdigest of the file (40 bytes) or link\n        target of a symlink.\n    ";
static PyObject *__pyx_f_21_dirstate_helpers_pyx_update_entry(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_self = 0;
  PyObject *__pyx_v_entry = 0;
  PyObject *__pyx_v_abspath = 0;
  PyObject *__pyx_v_stat_value = 0;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  static char *__pyx_argnames[] = {"self","entry","abspath","stat_value",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OOOO", __pyx_argnames, &__pyx_v_self, &__pyx_v_entry, &__pyx_v_abspath, &__pyx_v_stat_value)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_entry);
  Py_INCREF(__pyx_v_abspath);
  Py_INCREF(__pyx_v_stat_value);
  __pyx_1 = __pyx_f_21_dirstate_helpers_pyx__update_entry(__pyx_v_self,__pyx_v_entry,__pyx_v_abspath,__pyx_v_stat_value); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 819; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("_dirstate_helpers_pyx.update_entry");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_entry);
  Py_DECREF(__pyx_v_abspath);
  Py_DECREF(__pyx_v_stat_value);
  return __pyx_r;
}

static PyObject *__pyx_n__is_executable;
static PyObject *__pyx_n__cutoff_time;
static PyObject *__pyx_n__sha_cutoff_time;
static PyObject *__pyx_n_a;
static PyObject *__pyx_n__sha1_file;
static PyObject *__pyx_n_f;
static PyObject *__pyx_n_NULLSTAT;
static PyObject *__pyx_n_d;
static PyObject *__pyx_n__get_block_entry_index;
static PyObject *__pyx_n__ensure_block;
static PyObject *__pyx_n__read_link;
static PyObject *__pyx_n_l;
static PyObject *__pyx_n_IN_MEMORY_MODIFIED;

static PyObject *__pyx_k54p;
static PyObject *__pyx_k56p;
static PyObject *__pyx_k59p;

static char __pyx_k54[] = "";
static char __pyx_k56[] = "";
static char __pyx_k59[] = "";

static PyObject *__pyx_f_21_dirstate_helpers_pyx__update_entry(PyObject *__pyx_v_self,PyObject *__pyx_v_entry,PyObject *__pyx_v_abspath,PyObject *__pyx_v_stat_value) {
  int __pyx_v_minikind;
  int __pyx_v_saved_minikind;
  void *__pyx_v_details;
  PyObject *__pyx_v_packed_stat;
  PyObject *__pyx_v_saved_link_or_sha1;
  PyObject *__pyx_v_saved_file_size;
  PyObject *__pyx_v_saved_executable;
  PyObject *__pyx_v_saved_packed_stat;
  PyObject *__pyx_v_link_or_sha1;
  PyObject *__pyx_v_executable;
  PyObject *__pyx_v_block_index;
  PyObject *__pyx_v_entry_index;
  PyObject *__pyx_v_dir_present;
  PyObject *__pyx_v_file_present;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  int __pyx_2;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  Py_ssize_t __pyx_5;
  PyObject *__pyx_6 = 0;
  PyObject *__pyx_7 = 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_entry);
  Py_INCREF(__pyx_v_abspath);
  Py_INCREF(__pyx_v_stat_value);
  __pyx_v_packed_stat = Py_None; Py_INCREF(Py_None);
  __pyx_v_saved_link_or_sha1 = Py_None; Py_INCREF(Py_None);
  __pyx_v_saved_file_size = Py_None; Py_INCREF(Py_None);
  __pyx_v_saved_executable = Py_None; Py_INCREF(Py_None);
  __pyx_v_saved_packed_stat = Py_None; Py_INCREF(Py_None);
  __pyx_v_link_or_sha1 = Py_None; Py_INCREF(Py_None);
  __pyx_v_executable = Py_None; Py_INCREF(Py_None);
  __pyx_v_block_index = Py_None; Py_INCREF(Py_None);
  __pyx_v_entry_index = Py_None; Py_INCREF(Py_None);
  __pyx_v_dir_present = Py_None; Py_INCREF(Py_None);
  __pyx_v_file_present = Py_None; Py_INCREF(Py_None);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":840 */
  __pyx_1 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_mode); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 840; goto __pyx_L1;}
  __pyx_2 = PyInt_AsLong(__pyx_1); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 840; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_v_minikind = __pyx_f_21_dirstate_helpers_pyx_minikind_from_mode(__pyx_2);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":841 */
  __pyx_2 = (0 == __pyx_v_minikind);
  if (__pyx_2) {
    Py_INCREF(Py_None);
    __pyx_r = Py_None;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":843 */
  __pyx_1 = __pyx_f_21_dirstate_helpers_pyx__pack_stat(__pyx_v_stat_value); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 843; goto __pyx_L1;}
  Py_DECREF(__pyx_v_packed_stat);
  __pyx_v_packed_stat = __pyx_1;
  __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":844 */
  __pyx_v_details = PyList_GET_ITEM(PyTuple_GET_ITEM(((void *)__pyx_v_entry),1),0);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":845 */
  __pyx_v_saved_minikind = (PyString_AsString(((PyObject *)PyTuple_GET_ITEM(__pyx_v_details,0)))[0]);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":846 */
  __pyx_2 = (__pyx_v_minikind == 'd');
  if (__pyx_2) {
    __pyx_2 = (__pyx_v_saved_minikind == 't');
  }
  if (__pyx_2) {
    __pyx_v_minikind = 't';
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":848 */
  __pyx_1 = PyTuple_GET_ITEM(__pyx_v_details,1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 848; goto __pyx_L1;}
  Py_DECREF(__pyx_v_saved_link_or_sha1);
  __pyx_v_saved_link_or_sha1 = __pyx_1;
  __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":849 */
  __pyx_1 = PyTuple_GET_ITEM(__pyx_v_details,2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 849; goto __pyx_L1;}
  Py_DECREF(__pyx_v_saved_file_size);
  __pyx_v_saved_file_size = __pyx_1;
  __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":850 */
  __pyx_1 = PyTuple_GET_ITEM(__pyx_v_details,3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 850; goto __pyx_L1;}
  Py_DECREF(__pyx_v_saved_executable);
  __pyx_v_saved_executable = __pyx_1;
  __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":851 */
  __pyx_1 = PyTuple_GET_ITEM(__pyx_v_details,4); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 851; goto __pyx_L1;}
  Py_DECREF(__pyx_v_saved_packed_stat);
  __pyx_v_saved_packed_stat = __pyx_1;
  __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":853 */
  Py_INCREF(__pyx_v_saved_link_or_sha1);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":854 */
  Py_INCREF(__pyx_v_saved_file_size);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":855 */
  Py_INCREF(__pyx_v_saved_executable);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":856 */
  Py_INCREF(__pyx_v_saved_packed_stat);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":860 */
  __pyx_2 = (__pyx_v_minikind == __pyx_v_saved_minikind);
  if (__pyx_2) {
    if (PyObject_Cmp(__pyx_v_packed_stat, __pyx_v_saved_packed_stat, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 861; goto __pyx_L1;}
    __pyx_2 = __pyx_2 == 0;
  }
  if (__pyx_2) {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":864 */
    __pyx_2 = (__pyx_v_minikind == 'd');
    if (__pyx_2) {
      Py_INCREF(Py_None);
      __pyx_r = Py_None;
      goto __pyx_L0;
      goto __pyx_L5;
    }
    __pyx_L5:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":868 */
    __pyx_1 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_size); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 868; goto __pyx_L1;}
    if (PyObject_Cmp(__pyx_v_saved_file_size, __pyx_1, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 868; goto __pyx_L1;}
    __pyx_2 = __pyx_2 == 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    if (__pyx_2) {
      Py_INCREF(__pyx_v_saved_link_or_sha1);
      __pyx_r = __pyx_v_saved_link_or_sha1;
      goto __pyx_L0;
      goto __pyx_L6;
    }
    __pyx_L6:;
    goto __pyx_L4;
  }
  __pyx_L4:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":873 */
  Py_INCREF(Py_None);
  Py_DECREF(__pyx_v_link_or_sha1);
  __pyx_v_link_or_sha1 = Py_None;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":874 */
  __pyx_2 = (__pyx_v_minikind == 'f');
  if (__pyx_2) {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":875 */
    __pyx_1 = PyObject_GetAttr(__pyx_v_self, __pyx_n__is_executable); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 875; goto __pyx_L1;}
    __pyx_3 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_mode); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 875; goto __pyx_L1;}
    __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 875; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_3);
    Py_INCREF(__pyx_v_saved_executable);
    PyTuple_SET_ITEM(__pyx_4, 1, __pyx_v_saved_executable);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_4); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 875; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_v_executable);
    __pyx_v_executable = __pyx_3;
    __pyx_3 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":877 */
    __pyx_1 = PyObject_GetAttr(__pyx_v_self, __pyx_n__cutoff_time); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 877; goto __pyx_L1;}
    __pyx_2 = __pyx_1 == Py_None;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    if (__pyx_2) {
      __pyx_4 = PyObject_GetAttr(__pyx_v_self, __pyx_n__sha_cutoff_time); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 878; goto __pyx_L1;}
      __pyx_3 = PyObject_CallObject(__pyx_4, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 878; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      goto __pyx_L8;
    }
    __pyx_L8:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":879 */
    __pyx_1 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_mtime); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 879; goto __pyx_L1;}
    __pyx_4 = PyObject_GetAttr(__pyx_v_self, __pyx_n__cutoff_time); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 879; goto __pyx_L1;}
    if (PyObject_Cmp(__pyx_1, __pyx_4, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 879; goto __pyx_L1;}
    __pyx_2 = __pyx_2 < 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    if (__pyx_2) {
      __pyx_3 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_ctime); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 880; goto __pyx_L1;}
      __pyx_1 = PyObject_GetAttr(__pyx_v_self, __pyx_n__cutoff_time); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 880; goto __pyx_L1;}
      if (PyObject_Cmp(__pyx_3, __pyx_1, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 880; goto __pyx_L1;}
      __pyx_2 = __pyx_2 < 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      if (__pyx_2) {
        __pyx_4 = __Pyx_GetItemInt(__pyx_v_entry, 1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 881; goto __pyx_L1;}
        __pyx_5 = PyObject_Length(__pyx_4); if (__pyx_5 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 881; goto __pyx_L1;}
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        __pyx_2 = (__pyx_5 > 1);
        if (__pyx_2) {
          __pyx_3 = __Pyx_GetItemInt(__pyx_v_entry, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 882; goto __pyx_L1;}
          __pyx_1 = __Pyx_GetItemInt(__pyx_3, 1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 882; goto __pyx_L1;}
          Py_DECREF(__pyx_3); __pyx_3 = 0;
          __pyx_4 = __Pyx_GetItemInt(__pyx_1, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 882; goto __pyx_L1;}
          Py_DECREF(__pyx_1); __pyx_1 = 0;
          if (PyObject_Cmp(__pyx_4, __pyx_n_a, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 882; goto __pyx_L1;}
          __pyx_2 = __pyx_2 != 0;
          Py_DECREF(__pyx_4); __pyx_4 = 0;
        }
      }
    }
    if (__pyx_2) {

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":886 */
      __pyx_3 = PyObject_GetAttr(__pyx_v_self, __pyx_n__sha1_file); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 886; goto __pyx_L1;}
      __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 886; goto __pyx_L1;}
      Py_INCREF(__pyx_v_abspath);
      PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_abspath);
      __pyx_4 = PyObject_CallObject(__pyx_3, __pyx_1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 886; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(__pyx_v_link_or_sha1);
      __pyx_v_link_or_sha1 = __pyx_4;
      __pyx_4 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":887 */
      __pyx_3 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_size); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 887; goto __pyx_L1;}
      __pyx_1 = PyTuple_New(5); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 887; goto __pyx_L1;}
      Py_INCREF(__pyx_n_f);
      PyTuple_SET_ITEM(__pyx_1, 0, __pyx_n_f);
      Py_INCREF(__pyx_v_link_or_sha1);
      PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_link_or_sha1);
      PyTuple_SET_ITEM(__pyx_1, 2, __pyx_3);
      Py_INCREF(__pyx_v_executable);
      PyTuple_SET_ITEM(__pyx_1, 3, __pyx_v_executable);
      Py_INCREF(__pyx_v_packed_stat);
      PyTuple_SET_ITEM(__pyx_1, 4, __pyx_v_packed_stat);
      __pyx_3 = 0;
      __pyx_4 = __Pyx_GetItemInt(__pyx_v_entry, 1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 887; goto __pyx_L1;}
      if (__Pyx_SetItemInt(__pyx_4, 0, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 887; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      goto __pyx_L9;
    }
    /*else*/ {
      __pyx_3 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_size); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 890; goto __pyx_L1;}
      __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_DirState); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 891; goto __pyx_L1;}
      __pyx_4 = PyObject_GetAttr(__pyx_1, __pyx_n_NULLSTAT); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 891; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      __pyx_1 = PyTuple_New(5); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 890; goto __pyx_L1;}
      Py_INCREF(__pyx_n_f);
      PyTuple_SET_ITEM(__pyx_1, 0, __pyx_n_f);
      Py_INCREF(__pyx_k54p);
      PyTuple_SET_ITEM(__pyx_1, 1, __pyx_k54p);
      PyTuple_SET_ITEM(__pyx_1, 2, __pyx_3);
      Py_INCREF(__pyx_v_executable);
      PyTuple_SET_ITEM(__pyx_1, 3, __pyx_v_executable);
      PyTuple_SET_ITEM(__pyx_1, 4, __pyx_4);
      __pyx_3 = 0;
      __pyx_4 = 0;
      __pyx_3 = __Pyx_GetItemInt(__pyx_v_entry, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 890; goto __pyx_L1;}
      if (__Pyx_SetItemInt(__pyx_3, 0, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 890; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_1); __pyx_1 = 0;
    }
    __pyx_L9:;
    goto __pyx_L7;
  }
  __pyx_2 = (__pyx_v_minikind == 'd');
  if (__pyx_2) {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":893 */
    Py_INCREF(Py_None);
    Py_DECREF(__pyx_v_link_or_sha1);
    __pyx_v_link_or_sha1 = Py_None;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":894 */
    __pyx_4 = PyInt_FromLong(0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 894; goto __pyx_L1;}
    __pyx_1 = PyTuple_New(5); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 894; goto __pyx_L1;}
    Py_INCREF(__pyx_n_d);
    PyTuple_SET_ITEM(__pyx_1, 0, __pyx_n_d);
    Py_INCREF(__pyx_k56p);
    PyTuple_SET_ITEM(__pyx_1, 1, __pyx_k56p);
    PyTuple_SET_ITEM(__pyx_1, 2, __pyx_4);
    Py_INCREF(Py_False);
    PyTuple_SET_ITEM(__pyx_1, 3, Py_False);
    Py_INCREF(__pyx_v_packed_stat);
    PyTuple_SET_ITEM(__pyx_1, 4, __pyx_v_packed_stat);
    __pyx_4 = 0;
    __pyx_3 = __Pyx_GetItemInt(__pyx_v_entry, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 894; goto __pyx_L1;}
    if (__Pyx_SetItemInt(__pyx_3, 0, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 894; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":895 */
    __pyx_2 = (__pyx_v_saved_minikind != 'd');
    if (__pyx_2) {

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":900 */
      __pyx_4 = PyObject_GetAttr(__pyx_v_self, __pyx_n__get_block_entry_index); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 900; goto __pyx_L1;}
      __pyx_1 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 900; goto __pyx_L1;}
      __pyx_3 = __Pyx_GetItemInt(__pyx_1, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 900; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      __pyx_1 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 900; goto __pyx_L1;}
      __pyx_6 = __Pyx_GetItemInt(__pyx_1, 1); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 900; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      __pyx_1 = PyInt_FromLong(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 900; goto __pyx_L1;}
      __pyx_7 = PyTuple_New(3); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 900; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_7, 0, __pyx_3);
      PyTuple_SET_ITEM(__pyx_7, 1, __pyx_6);
      PyTuple_SET_ITEM(__pyx_7, 2, __pyx_1);
      __pyx_3 = 0;
      __pyx_6 = 0;
      __pyx_1 = 0;
      __pyx_3 = PyObject_CallObject(__pyx_4, __pyx_7); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 900; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      __pyx_6 = PyObject_GetIter(__pyx_3); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 899; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_1 = __Pyx_UnpackItem(__pyx_6); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 899; goto __pyx_L1;}
      Py_DECREF(__pyx_v_block_index);
      __pyx_v_block_index = __pyx_1;
      __pyx_1 = 0;
      __pyx_4 = __Pyx_UnpackItem(__pyx_6); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 899; goto __pyx_L1;}
      Py_DECREF(__pyx_v_entry_index);
      __pyx_v_entry_index = __pyx_4;
      __pyx_4 = 0;
      __pyx_7 = __Pyx_UnpackItem(__pyx_6); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 899; goto __pyx_L1;}
      Py_DECREF(__pyx_v_dir_present);
      __pyx_v_dir_present = __pyx_7;
      __pyx_7 = 0;
      __pyx_3 = __Pyx_UnpackItem(__pyx_6); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 899; goto __pyx_L1;}
      Py_DECREF(__pyx_v_file_present);
      __pyx_v_file_present = __pyx_3;
      __pyx_3 = 0;
      if (__Pyx_EndUnpack(__pyx_6) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 899; goto __pyx_L1;}
      Py_DECREF(__pyx_6); __pyx_6 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":901 */
      __pyx_1 = PyObject_GetAttr(__pyx_v_self, __pyx_n__ensure_block); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 901; goto __pyx_L1;}
      __pyx_4 = __Pyx_GetName(__pyx_m, __pyx_n_pathjoin); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 902; goto __pyx_L1;}
      __pyx_7 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 902; goto __pyx_L1;}
      __pyx_3 = __Pyx_GetItemInt(__pyx_7, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 902; goto __pyx_L1;}
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      __pyx_6 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 902; goto __pyx_L1;}
      __pyx_7 = __Pyx_GetItemInt(__pyx_6, 1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 902; goto __pyx_L1;}
      Py_DECREF(__pyx_6); __pyx_6 = 0;
      __pyx_6 = PyTuple_New(2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 902; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_6, 0, __pyx_3);
      PyTuple_SET_ITEM(__pyx_6, 1, __pyx_7);
      __pyx_3 = 0;
      __pyx_7 = 0;
      __pyx_3 = PyObject_CallObject(__pyx_4, __pyx_6); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 902; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_6); __pyx_6 = 0;
      __pyx_7 = PyTuple_New(3); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 901; goto __pyx_L1;}
      Py_INCREF(__pyx_v_block_index);
      PyTuple_SET_ITEM(__pyx_7, 0, __pyx_v_block_index);
      Py_INCREF(__pyx_v_entry_index);
      PyTuple_SET_ITEM(__pyx_7, 1, __pyx_v_entry_index);
      PyTuple_SET_ITEM(__pyx_7, 2, __pyx_3);
      __pyx_3 = 0;
      __pyx_4 = PyObject_CallObject(__pyx_1, __pyx_7); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 901; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      goto __pyx_L10;
    }
    __pyx_L10:;
    goto __pyx_L7;
  }
  __pyx_2 = (__pyx_v_minikind == 'l');
  if (__pyx_2) {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":904 */
    __pyx_6 = PyObject_GetAttr(__pyx_v_self, __pyx_n__read_link); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 904; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 904; goto __pyx_L1;}
    Py_INCREF(__pyx_v_abspath);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_abspath);
    Py_INCREF(__pyx_v_saved_link_or_sha1);
    PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_saved_link_or_sha1);
    __pyx_1 = PyObject_CallObject(__pyx_6, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 904; goto __pyx_L1;}
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_v_link_or_sha1);
    __pyx_v_link_or_sha1 = __pyx_1;
    __pyx_1 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":905 */
    __pyx_7 = PyObject_GetAttr(__pyx_v_self, __pyx_n__cutoff_time); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 905; goto __pyx_L1;}
    __pyx_2 = __pyx_7 == Py_None;
    Py_DECREF(__pyx_7); __pyx_7 = 0;
    if (__pyx_2) {
      __pyx_4 = PyObject_GetAttr(__pyx_v_self, __pyx_n__sha_cutoff_time); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 906; goto __pyx_L1;}
      __pyx_6 = PyObject_CallObject(__pyx_4, 0); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 906; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_6); __pyx_6 = 0;
      goto __pyx_L11;
    }
    __pyx_L11:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":907 */
    __pyx_3 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_mtime); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 907; goto __pyx_L1;}
    __pyx_1 = PyObject_GetAttr(__pyx_v_self, __pyx_n__cutoff_time); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 907; goto __pyx_L1;}
    if (PyObject_Cmp(__pyx_3, __pyx_1, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 907; goto __pyx_L1;}
    __pyx_2 = __pyx_2 < 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    if (__pyx_2) {
      __pyx_7 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_ctime); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 908; goto __pyx_L1;}
      __pyx_4 = PyObject_GetAttr(__pyx_v_self, __pyx_n__cutoff_time); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 908; goto __pyx_L1;}
      if (PyObject_Cmp(__pyx_7, __pyx_4, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 908; goto __pyx_L1;}
      __pyx_2 = __pyx_2 < 0;
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      Py_DECREF(__pyx_4); __pyx_4 = 0;
    }
    if (__pyx_2) {
      __pyx_6 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_size); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 909; goto __pyx_L1;}
      __pyx_3 = PyTuple_New(5); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 909; goto __pyx_L1;}
      Py_INCREF(__pyx_n_l);
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_n_l);
      Py_INCREF(__pyx_v_link_or_sha1);
      PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_link_or_sha1);
      PyTuple_SET_ITEM(__pyx_3, 2, __pyx_6);
      Py_INCREF(Py_False);
      PyTuple_SET_ITEM(__pyx_3, 3, Py_False);
      Py_INCREF(__pyx_v_packed_stat);
      PyTuple_SET_ITEM(__pyx_3, 4, __pyx_v_packed_stat);
      __pyx_6 = 0;
      __pyx_1 = __Pyx_GetItemInt(__pyx_v_entry, 1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 909; goto __pyx_L1;}
      if (__Pyx_SetItemInt(__pyx_1, 0, __pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 909; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      goto __pyx_L12;
    }
    /*else*/ {
      __pyx_7 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_size); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 912; goto __pyx_L1;}
      __pyx_4 = __Pyx_GetName(__pyx_m, __pyx_n_DirState); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 913; goto __pyx_L1;}
      __pyx_6 = PyObject_GetAttr(__pyx_4, __pyx_n_NULLSTAT); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 913; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      __pyx_3 = PyTuple_New(5); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 912; goto __pyx_L1;}
      Py_INCREF(__pyx_n_l);
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_n_l);
      Py_INCREF(__pyx_k59p);
      PyTuple_SET_ITEM(__pyx_3, 1, __pyx_k59p);
      PyTuple_SET_ITEM(__pyx_3, 2, __pyx_7);
      Py_INCREF(Py_False);
      PyTuple_SET_ITEM(__pyx_3, 3, Py_False);
      PyTuple_SET_ITEM(__pyx_3, 4, __pyx_6);
      __pyx_7 = 0;
      __pyx_6 = 0;
      __pyx_1 = __Pyx_GetItemInt(__pyx_v_entry, 1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 912; goto __pyx_L1;}
      if (__Pyx_SetItemInt(__pyx_1, 0, __pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 912; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
    }
    __pyx_L12:;
    goto __pyx_L7;
  }
  __pyx_L7:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":914 */
  __pyx_4 = __Pyx_GetName(__pyx_m, __pyx_n_DirState); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 914; goto __pyx_L1;}
  __pyx_7 = PyObject_GetAttr(__pyx_4, __pyx_n_IN_MEMORY_MODIFIED); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 914; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  if (PyObject_SetAttr(__pyx_v_self, __pyx_n__dirblock_state, __pyx_7) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 914; goto __pyx_L1;}
  Py_DECREF(__pyx_7); __pyx_7 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":915 */
  Py_INCREF(__pyx_v_link_or_sha1);
  __pyx_r = __pyx_v_link_or_sha1;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_6);
  Py_XDECREF(__pyx_7);
  __Pyx_AddTraceback("_dirstate_helpers_pyx._update_entry");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_packed_stat);
  Py_DECREF(__pyx_v_saved_link_or_sha1);
  Py_DECREF(__pyx_v_saved_file_size);
  Py_DECREF(__pyx_v_saved_executable);
  Py_DECREF(__pyx_v_saved_packed_stat);
  Py_DECREF(__pyx_v_link_or_sha1);
  Py_DECREF(__pyx_v_executable);
  Py_DECREF(__pyx_v_block_index);
  Py_DECREF(__pyx_v_entry_index);
  Py_DECREF(__pyx_v_dir_present);
  Py_DECREF(__pyx_v_file_present);
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_entry);
  Py_DECREF(__pyx_v_abspath);
  Py_DECREF(__pyx_v_stat_value);
  return __pyx_r;
}

static char __pyx_f_21_dirstate_helpers_pyx__minikind_from_string(PyObject *__pyx_v_string) {
  char __pyx_r;
  Py_INCREF(__pyx_v_string);
  __pyx_r = (PyString_AsString(__pyx_v_string)[0]);
  goto __pyx_L0;

  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_string);
  return __pyx_r;
}

static PyObject *__pyx_f_21_dirstate_helpers_pyx__minikind_to_kind(char __pyx_v_minikind) {
  char __pyx_v__minikind[1];
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":940 */
  __pyx_1 = (__pyx_v_minikind == 'f');
  if (__pyx_1) {
    Py_INCREF(__pyx_v_21_dirstate_helpers_pyx__kind_file);
    __pyx_r = __pyx_v_21_dirstate_helpers_pyx__kind_file;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_1 = (__pyx_v_minikind == 'd');
  if (__pyx_1) {
    Py_INCREF(__pyx_v_21_dirstate_helpers_pyx__kind_directory);
    __pyx_r = __pyx_v_21_dirstate_helpers_pyx__kind_directory;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_1 = (__pyx_v_minikind == 'a');
  if (__pyx_1) {
    Py_INCREF(__pyx_v_21_dirstate_helpers_pyx__kind_absent);
    __pyx_r = __pyx_v_21_dirstate_helpers_pyx__kind_absent;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_1 = (__pyx_v_minikind == 'r');
  if (__pyx_1) {
    Py_INCREF(__pyx_v_21_dirstate_helpers_pyx__kind_relocated);
    __pyx_r = __pyx_v_21_dirstate_helpers_pyx__kind_relocated;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_1 = (__pyx_v_minikind == 'l');
  if (__pyx_1) {
    Py_INCREF(__pyx_v_21_dirstate_helpers_pyx__kind_symlink);
    __pyx_r = __pyx_v_21_dirstate_helpers_pyx__kind_symlink;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_1 = (__pyx_v_minikind == 't');
  if (__pyx_1) {
    Py_INCREF(__pyx_v_21_dirstate_helpers_pyx__kind_tree_reference);
    __pyx_r = __pyx_v_21_dirstate_helpers_pyx__kind_tree_reference;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":952 */
  (__pyx_v__minikind[0]) = __pyx_v_minikind;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":953 */
  __pyx_2 = PyString_FromStringAndSize(__pyx_v__minikind,1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 953; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 953; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_2);
  __pyx_2 = 0;
  __pyx_2 = PyObject_CallObject(PyExc_KeyError, __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 953; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __Pyx_Raise(__pyx_2, 0, 0);
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  {__pyx_filename = __pyx_f[0]; __pyx_lineno = 953; goto __pyx_L1;}

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("_dirstate_helpers_pyx._minikind_to_kind");
  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

static int __pyx_f_21_dirstate_helpers_pyx__versioned_minikind(char __pyx_v_minikind) {
  int __pyx_r;
  int __pyx_1;
  __pyx_1 = (__pyx_v_minikind == 'f');
  if (!__pyx_1) {
    __pyx_1 = (__pyx_v_minikind == 'd');
    if (!__pyx_1) {
      __pyx_1 = (__pyx_v_minikind == 'l');
      if (!__pyx_1) {
        __pyx_1 = (__pyx_v_minikind == 't');
      }
    }
  }
  __pyx_r = __pyx_1;
  goto __pyx_L0;

  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

static PyObject *__pyx_n_set;
static PyObject *__pyx_n___ne__;
static PyObject *__pyx_n__utf8_decode;
static PyObject *__pyx_n_bisect_left;
static PyObject *__pyx_n_fstat;
static PyObject *__pyx_n_sha_file;
static PyObject *__pyx_n_BzrError;

static PyObject *__pyx_k60p;
static PyObject *__pyx_k61p;

static char __pyx_k60[] = "";
static char __pyx_k61[] = "unsupported target index";

static int __pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_include_unchanged = 0;
  PyObject *__pyx_v_use_filesystem_for_exec = 0;
  PyObject *__pyx_v_search_specific_files = 0;
  PyObject *__pyx_v_state = 0;
  PyObject *__pyx_v_source_index = 0;
  PyObject *__pyx_v_target_index = 0;
  PyObject *__pyx_v_want_unversioned = 0;
  PyObject *__pyx_v_tree = 0;
  int __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  int __pyx_4;
  static char *__pyx_argnames[] = {"include_unchanged","use_filesystem_for_exec","search_specific_files","state","source_index","target_index","want_unversioned","tree",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OOOOOOOO", __pyx_argnames, &__pyx_v_include_unchanged, &__pyx_v_use_filesystem_for_exec, &__pyx_v_search_specific_files, &__pyx_v_state, &__pyx_v_source_index, &__pyx_v_target_index, &__pyx_v_want_unversioned, &__pyx_v_tree)) return -1;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_include_unchanged);
  Py_INCREF(__pyx_v_use_filesystem_for_exec);
  Py_INCREF(__pyx_v_search_specific_files);
  Py_INCREF(__pyx_v_state);
  Py_INCREF(__pyx_v_source_index);
  Py_INCREF(__pyx_v_target_index);
  Py_INCREF(__pyx_v_want_unversioned);
  Py_INCREF(__pyx_v_tree);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1011 */
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->doing_consistency_expansion = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1012 */
  __pyx_1 = PyDict_New(); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1012; goto __pyx_L1;}
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->old_dirname_to_file_id);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->old_dirname_to_file_id = __pyx_1;
  __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1013 */
  __pyx_1 = PyDict_New(); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1013; goto __pyx_L1;}
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->new_dirname_to_file_id);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->new_dirname_to_file_id = __pyx_1;
  __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1015 */
  __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_set); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1015; goto __pyx_L1;}
  __pyx_2 = PyList_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1015; goto __pyx_L1;}
  Py_INCREF(__pyx_k60p);
  PyList_SET_ITEM(__pyx_2, 0, __pyx_k60p);
  __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1015; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_2);
  __pyx_2 = 0;
  __pyx_2 = PyObject_CallObject(__pyx_1, __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1015; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_1 = PyObject_GetAttr(__pyx_2, __pyx_n___ne__); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1015; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1015; goto __pyx_L1;}
  Py_INCREF(__pyx_v_search_specific_files);
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_search_specific_files);
  __pyx_2 = PyObject_CallObject(__pyx_1, __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1015; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_4 = PyInt_AsLong(__pyx_2); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1015; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->partial = __pyx_4;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1018 */
  __pyx_1 = PyList_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1018; goto __pyx_L1;}
  Py_INCREF(Py_None);
  PyList_SET_ITEM(__pyx_1, 0, Py_None);
  Py_INCREF(Py_None);
  PyList_SET_ITEM(__pyx_1, 1, Py_None);
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->last_source_parent);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->last_source_parent = __pyx_1;
  __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1019 */
  __pyx_3 = PyList_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1019; goto __pyx_L1;}
  Py_INCREF(Py_None);
  PyList_SET_ITEM(__pyx_3, 0, Py_None);
  Py_INCREF(Py_None);
  PyList_SET_ITEM(__pyx_3, 1, Py_None);
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->last_target_parent);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->last_target_parent = __pyx_3;
  __pyx_3 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1020 */
  __pyx_4 = __pyx_v_include_unchanged == Py_None;
  if (__pyx_4) {
    __pyx_4 = PyInt_AsLong(Py_False); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1021; goto __pyx_L1;}
    ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->include_unchanged = __pyx_4;
    goto __pyx_L2;
  }
  /*else*/ {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1023; goto __pyx_L1;}
    Py_INCREF(__pyx_v_include_unchanged);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_include_unchanged);
    __pyx_1 = PyObject_CallObject(((PyObject *)(&PyInt_Type)), __pyx_2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1023; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_4 = PyInt_AsLong(__pyx_1); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1023; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->include_unchanged = __pyx_4;
  }
  __pyx_L2:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1024 */
  Py_INCREF(__pyx_v_use_filesystem_for_exec);
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->use_filesystem_for_exec);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->use_filesystem_for_exec = __pyx_v_use_filesystem_for_exec;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1025 */
  __pyx_3 = __Pyx_GetName(__pyx_m, __pyx_n_cache_utf8); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1025; goto __pyx_L1;}
  __pyx_2 = PyObject_GetAttr(__pyx_3, __pyx_n__utf8_decode); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1025; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->utf8_decode);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->utf8_decode = __pyx_2;
  __pyx_2 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1030 */
  __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_set); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1030; goto __pyx_L1;}
  __pyx_3 = PyObject_CallObject(__pyx_1, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1030; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->searched_specific_files);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->searched_specific_files = __pyx_3;
  __pyx_3 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1033 */
  __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_set); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1033; goto __pyx_L1;}
  __pyx_1 = PyObject_CallObject(__pyx_2, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1033; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->searched_exact_paths);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->searched_exact_paths = __pyx_1;
  __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1034 */
  Py_INCREF(__pyx_v_search_specific_files);
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->search_specific_files);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->search_specific_files = __pyx_v_search_specific_files;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1037 */
  __pyx_3 = __Pyx_GetName(__pyx_b, __pyx_n_set); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1037; goto __pyx_L1;}
  __pyx_2 = PyObject_CallObject(__pyx_3, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1037; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->search_specific_file_parents);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->search_specific_file_parents = __pyx_2;
  __pyx_2 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1039 */
  __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_set); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1039; goto __pyx_L1;}
  __pyx_3 = PyObject_CallObject(__pyx_1, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1039; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->seen_ids);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->seen_ids = __pyx_3;
  __pyx_3 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1040 */
  Py_INCREF(__pyx_v_state);
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->state);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->state = __pyx_v_state;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1041 */
  Py_INCREF(Py_None);
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->current_root);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->current_root = Py_None;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1042 */
  Py_INCREF(Py_None);
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->current_root_unicode);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->current_root_unicode = Py_None;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1043 */
  Py_INCREF(Py_None);
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->root_entries);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->root_entries = Py_None;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1044 */
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->root_entries_pos = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1045 */
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->root_entries_len = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1046 */
  Py_INCREF(Py_None);
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->root_abspath);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->root_abspath = Py_None;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1047 */
  __pyx_4 = __pyx_v_source_index == Py_None;
  if (__pyx_4) {
    ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->source_index = (-1);
    goto __pyx_L3;
  }
  /*else*/ {
    __pyx_4 = PyInt_AsLong(__pyx_v_source_index); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1050; goto __pyx_L1;}
    ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->source_index = __pyx_4;
  }
  __pyx_L3:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1051 */
  __pyx_4 = PyInt_AsLong(__pyx_v_target_index); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1051; goto __pyx_L1;}
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->target_index = __pyx_4;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1052 */
  __pyx_4 = PyInt_AsLong(__pyx_v_want_unversioned); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1052; goto __pyx_L1;}
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->want_unversioned = __pyx_4;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1053 */
  Py_INCREF(__pyx_v_tree);
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->tree);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->tree = __pyx_v_tree;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1054 */
  Py_INCREF(Py_None);
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->dir_iterator);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->dir_iterator = Py_None;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1055 */
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->block_index = (-1);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1056 */
  Py_INCREF(Py_None);
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->current_block);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->current_block = Py_None;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1057 */
  Py_INCREF(Py_None);
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->current_block_list);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->current_block_list = Py_None;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1058 */
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->current_block_pos = (-1);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1059 */
  Py_INCREF(Py_None);
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->current_dir_info);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->current_dir_info = Py_None;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1060 */
  Py_INCREF(Py_None);
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->current_dir_list);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->current_dir_list = Py_None;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1061 */
  __pyx_2 = PyList_New(0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1061; goto __pyx_L1;}
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->_pending_consistent_entries);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->_pending_consistent_entries = __pyx_2;
  __pyx_2 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1062 */
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->path_index = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1063 */
  Py_INCREF(Py_None);
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->root_dir_info);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->root_dir_info = Py_None;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1064 */
  __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_bisect); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1064; goto __pyx_L1;}
  __pyx_3 = PyObject_GetAttr(__pyx_1, __pyx_n_bisect_left); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1064; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->bisect_left);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->bisect_left = __pyx_3;
  __pyx_3 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1065 */
  __pyx_2 = __Pyx_GetName(__pyx_m, __pyx_n_osutils); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1065; goto __pyx_L1;}
  __pyx_1 = PyObject_GetAttr(__pyx_2, __pyx_n_pathjoin); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1065; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->pathjoin);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->pathjoin = __pyx_1;
  __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1066 */
  __pyx_3 = __Pyx_GetName(__pyx_m, __pyx_n_os); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1066; goto __pyx_L1;}
  __pyx_2 = PyObject_GetAttr(__pyx_3, __pyx_n_fstat); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1066; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->fstat);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->fstat = __pyx_2;
  __pyx_2 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1067 */
  __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_osutils); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1067; goto __pyx_L1;}
  __pyx_3 = PyObject_GetAttr(__pyx_1, __pyx_n_sha_file); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1067; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->sha_file);
  ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->sha_file = __pyx_3;
  __pyx_3 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1068 */
  __pyx_2 = PyInt_FromLong(0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1068; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_v_target_index, __pyx_2, &__pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1068; goto __pyx_L1;}
  __pyx_4 = __pyx_4 != 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_4) {
    __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_errors); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1070; goto __pyx_L1;}
    __pyx_3 = PyObject_GetAttr(__pyx_1, __pyx_n_BzrError); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1070; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1070; goto __pyx_L1;}
    Py_INCREF(__pyx_k61p);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_k61p);
    __pyx_1 = PyObject_CallObject(__pyx_3, __pyx_2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1070; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_1, 0, 0);
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1070; goto __pyx_L1;}
    goto __pyx_L4;
  }
  __pyx_L4:;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("_dirstate_helpers_pyx.ProcessEntryC.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_include_unchanged);
  Py_DECREF(__pyx_v_use_filesystem_for_exec);
  Py_DECREF(__pyx_v_search_specific_files);
  Py_DECREF(__pyx_v_state);
  Py_DECREF(__pyx_v_source_index);
  Py_DECREF(__pyx_v_target_index);
  Py_DECREF(__pyx_v_want_unversioned);
  Py_DECREF(__pyx_v_tree);
  return __pyx_r;
}

static PyObject *__pyx_n_NULL_PARENT_DETAILS;
static PyObject *__pyx_n_is_inside_any;
static PyObject *__pyx_n_add;
static PyObject *__pyx_n_path;
static PyObject *__pyx_n_split;
static PyObject *__pyx_n__get_entry;
static PyObject *__pyx_n_path_utf8;
static PyObject *__pyx_n_CorruptDirstate;
static PyObject *__pyx_n__filename;
static PyObject *__pyx_n__sha1_provider;
static PyObject *__pyx_n_stat_and_sha1;
static PyObject *__pyx_n__observed_sha1;

static PyObject *__pyx_k62p;
static PyObject *__pyx_k64p;
static PyObject *__pyx_k68p;
static PyObject *__pyx_k69p;
static PyObject *__pyx_k72p;
static PyObject *__pyx_k74p;
static PyObject *__pyx_k76p;

static char __pyx_k62[] = "Unsupported target index %d";
static char __pyx_k64[] = "entry '%s/%s' is considered renamed from %r but source does not exist\nentry: %s";
static char __pyx_k68[] = "tree-reference";
static char __pyx_k69[] = "unknown kind %s";
static char __pyx_k72[] = "Could not find target parent in wt: %s\nparent of: %s";
static char __pyx_k74[] = "We could not find the parent entry in index %d for the entry: %s";
static char __pyx_k76[] = "don't know how to compare source_minikind=%r, target_minikind=%r";

static PyObject *__pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC__process_entry(struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *__pyx_v_self,PyObject *__pyx_v_entry,PyObject *__pyx_v_path_info) {
  char __pyx_v_target_minikind;
  char __pyx_v_source_minikind;
  PyObject *__pyx_v_file_id;
  int __pyx_v_content_change;
  PyObject *__pyx_v_details_list;
  PyObject *__pyx_v_source_details;
  PyObject *__pyx_v_target_details;
  PyObject *__pyx_v_link_or_sha1;
  PyObject *__pyx_v_old_dirname;
  PyObject *__pyx_v_old_basename;
  PyObject *__pyx_v_old_path;
  PyObject *__pyx_v_path;
  PyObject *__pyx_v_old_entry;
  PyObject *__pyx_v_target_kind;
  PyObject *__pyx_v_target_exec;
  PyObject *__pyx_v_statvalue;
  PyObject *__pyx_v_source_parent_id;
  PyObject *__pyx_v_source_parent_entry;
  PyObject *__pyx_v_new_dirname;
  PyObject *__pyx_v_target_parent_id;
  PyObject *__pyx_v_target_parent_entry;
  PyObject *__pyx_v_source_exec;
  PyObject *__pyx_v_changed;
  PyObject *__pyx_v_old_path_u;
  PyObject *__pyx_v_path_u;
  PyObject *__pyx_v_source_kind;
  PyObject *__pyx_v_parent_entry;
  PyObject *__pyx_v_parent_id;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  int __pyx_2;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  int __pyx_5;
  PyObject *__pyx_6 = 0;
  PyObject *__pyx_7 = 0;
  PyObject *__pyx_8 = 0;
  PyObject *__pyx_9 = 0;
  PyObject *__pyx_10 = 0;
  PyObject *__pyx_11 = 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_entry);
  Py_INCREF(__pyx_v_path_info);
  __pyx_v_file_id = Py_None; Py_INCREF(Py_None);
  __pyx_v_details_list = Py_None; Py_INCREF(Py_None);
  __pyx_v_source_details = Py_None; Py_INCREF(Py_None);
  __pyx_v_target_details = Py_None; Py_INCREF(Py_None);
  __pyx_v_link_or_sha1 = Py_None; Py_INCREF(Py_None);
  __pyx_v_old_dirname = Py_None; Py_INCREF(Py_None);
  __pyx_v_old_basename = Py_None; Py_INCREF(Py_None);
  __pyx_v_old_path = Py_None; Py_INCREF(Py_None);
  __pyx_v_path = Py_None; Py_INCREF(Py_None);
  __pyx_v_old_entry = Py_None; Py_INCREF(Py_None);
  __pyx_v_target_kind = Py_None; Py_INCREF(Py_None);
  __pyx_v_target_exec = Py_None; Py_INCREF(Py_None);
  __pyx_v_statvalue = Py_None; Py_INCREF(Py_None);
  __pyx_v_source_parent_id = Py_None; Py_INCREF(Py_None);
  __pyx_v_source_parent_entry = Py_None; Py_INCREF(Py_None);
  __pyx_v_new_dirname = Py_None; Py_INCREF(Py_None);
  __pyx_v_target_parent_id = Py_None; Py_INCREF(Py_None);
  __pyx_v_target_parent_entry = Py_None; Py_INCREF(Py_None);
  __pyx_v_source_exec = Py_None; Py_INCREF(Py_None);
  __pyx_v_changed = Py_None; Py_INCREF(Py_None);
  __pyx_v_old_path_u = Py_None; Py_INCREF(Py_None);
  __pyx_v_path_u = Py_None; Py_INCREF(Py_None);
  __pyx_v_source_kind = Py_None; Py_INCREF(Py_None);
  __pyx_v_parent_entry = Py_None; Py_INCREF(Py_None);
  __pyx_v_parent_id = Py_None; Py_INCREF(Py_None);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1094 */
  Py_INCREF(Py_None);
  Py_DECREF(__pyx_v_file_id);
  __pyx_v_file_id = Py_None;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1095 */
  __pyx_1 = __Pyx_GetItemInt(__pyx_v_entry, 1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1095; goto __pyx_L1;}
  Py_DECREF(__pyx_v_details_list);
  __pyx_v_details_list = __pyx_1;
  __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1096 */
  __pyx_2 = ((-1) == __pyx_v_self->source_index);
  if (__pyx_2) {
    __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_DirState); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1097; goto __pyx_L1;}
    __pyx_3 = PyObject_GetAttr(__pyx_1, __pyx_n_NULL_PARENT_DETAILS); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1097; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_v_source_details);
    __pyx_v_source_details = __pyx_3;
    __pyx_3 = 0;
    goto __pyx_L2;
  }
  /*else*/ {
    __pyx_1 = __Pyx_GetItemInt(__pyx_v_details_list, __pyx_v_self->source_index); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1099; goto __pyx_L1;}
    Py_DECREF(__pyx_v_source_details);
    __pyx_v_source_details = __pyx_1;
    __pyx_1 = 0;
  }
  __pyx_L2:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1100 */
  __pyx_3 = __Pyx_GetItemInt(__pyx_v_details_list, __pyx_v_self->target_index); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1100; goto __pyx_L1;}
  Py_DECREF(__pyx_v_target_details);
  __pyx_v_target_details = __pyx_3;
  __pyx_3 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1101 */
  __pyx_1 = __Pyx_GetItemInt(__pyx_v_target_details, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1101; goto __pyx_L1;}
  __pyx_v_target_minikind = __pyx_f_21_dirstate_helpers_pyx__minikind_from_string(__pyx_1);
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1102 */
  __pyx_2 = __pyx_v_path_info != Py_None;
  if (__pyx_2) {
    __pyx_2 = __pyx_f_21_dirstate_helpers_pyx__versioned_minikind(__pyx_v_target_minikind);
  }
  if (__pyx_2) {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1103 */
    __pyx_2 = (__pyx_v_self->target_index != 0);
    if (__pyx_2) {
      __pyx_3 = PyInt_FromLong(__pyx_v_self->target_index); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1105; goto __pyx_L1;}
      __pyx_1 = PyNumber_Remainder(__pyx_k62p, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1104; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1104; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_1);
      __pyx_1 = 0;
      __pyx_1 = PyObject_CallObject(PyExc_AssertionError, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1104; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __Pyx_Raise(__pyx_1, 0, 0);
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1104; goto __pyx_L1;}
      goto __pyx_L4;
    }
    __pyx_L4:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1106 */
    __pyx_3 = __Pyx_GetItemInt(__pyx_v_path_info, 4); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1106; goto __pyx_L1;}
    __pyx_1 = __Pyx_GetItemInt(__pyx_v_path_info, 3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1106; goto __pyx_L1;}
    __pyx_4 = __pyx_f_21_dirstate_helpers_pyx__update_entry(__pyx_v_self->state,__pyx_v_entry,__pyx_3,__pyx_1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1106; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_v_link_or_sha1);
    __pyx_v_link_or_sha1 = __pyx_4;
    __pyx_4 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1108 */
    __pyx_3 = __Pyx_GetItemInt(__pyx_v_details_list, __pyx_v_self->target_index); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1108; goto __pyx_L1;}
    Py_DECREF(__pyx_v_target_details);
    __pyx_v_target_details = __pyx_3;
    __pyx_3 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1109 */
    __pyx_1 = __Pyx_GetItemInt(__pyx_v_target_details, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1109; goto __pyx_L1;}
    __pyx_v_target_minikind = __pyx_f_21_dirstate_helpers_pyx__minikind_from_string(__pyx_1);
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    goto __pyx_L3;
  }
  /*else*/ {
    Py_INCREF(Py_None);
    Py_DECREF(__pyx_v_link_or_sha1);
    __pyx_v_link_or_sha1 = Py_None;
  }
  __pyx_L3:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1114 */
  __pyx_4 = __Pyx_GetItemInt(__pyx_v_source_details, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1114; goto __pyx_L1;}
  __pyx_v_source_minikind = __pyx_f_21_dirstate_helpers_pyx__minikind_from_string(__pyx_4);
  Py_DECREF(__pyx_4); __pyx_4 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1115 */
  __pyx_2 = __pyx_f_21_dirstate_helpers_pyx__versioned_minikind(__pyx_v_source_minikind);
  if (!__pyx_2) {
    __pyx_2 = (__pyx_v_source_minikind == 'r');
  }
  if (__pyx_2) {
    __pyx_2 = __pyx_f_21_dirstate_helpers_pyx__versioned_minikind(__pyx_v_target_minikind);
  }
  if (__pyx_2) {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1122 */
    __pyx_2 = (__pyx_v_source_minikind != 'r');
    if (__pyx_2) {

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1123 */
      __pyx_3 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1123; goto __pyx_L1;}
      __pyx_1 = __Pyx_GetItemInt(__pyx_3, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1123; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_v_old_dirname);
      __pyx_v_old_dirname = __pyx_1;
      __pyx_1 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1124 */
      __pyx_4 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1124; goto __pyx_L1;}
      __pyx_3 = __Pyx_GetItemInt(__pyx_4, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1124; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_v_old_basename);
      __pyx_v_old_basename = __pyx_3;
      __pyx_3 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1125 */
      Py_INCREF(Py_None);
      Py_DECREF(__pyx_v_old_path);
      __pyx_v_old_path = Py_None;
      Py_INCREF(Py_None);
      Py_DECREF(__pyx_v_path);
      __pyx_v_path = Py_None;
      goto __pyx_L6;
    }
    /*else*/ {

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1129 */
      __pyx_2 = (!__pyx_v_self->doing_consistency_expansion);
      if (__pyx_2) {
        __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_osutils); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1130; goto __pyx_L1;}
        __pyx_4 = PyObject_GetAttr(__pyx_1, __pyx_n_is_inside_any); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1130; goto __pyx_L1;}
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        __pyx_3 = __Pyx_GetItemInt(__pyx_v_source_details, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1131; goto __pyx_L1;}
        __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1130; goto __pyx_L1;}
        Py_INCREF(__pyx_v_self->searched_specific_files);
        PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self->searched_specific_files);
        PyTuple_SET_ITEM(__pyx_1, 1, __pyx_3);
        __pyx_3 = 0;
        __pyx_3 = PyObject_CallObject(__pyx_4, __pyx_1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1130; goto __pyx_L1;}
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        __pyx_5 = PyObject_IsTrue(__pyx_3); if (__pyx_5 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1130; goto __pyx_L1;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        __pyx_2 = (!__pyx_5);
      }
      if (__pyx_2) {
        __pyx_4 = PyObject_GetAttr(__pyx_v_self->search_specific_files, __pyx_n_add); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1132; goto __pyx_L1;}
        __pyx_1 = __Pyx_GetItemInt(__pyx_v_source_details, 1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1132; goto __pyx_L1;}
        __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1132; goto __pyx_L1;}
        PyTuple_SET_ITEM(__pyx_3, 0, __pyx_1);
        __pyx_1 = 0;
        __pyx_1 = PyObject_CallObject(__pyx_4, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1132; goto __pyx_L1;}
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        goto __pyx_L7;
      }
      __pyx_L7:;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1137 */
      __pyx_4 = __Pyx_GetItemInt(__pyx_v_source_details, 1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1137; goto __pyx_L1;}
      Py_DECREF(__pyx_v_old_path);
      __pyx_v_old_path = __pyx_4;
      __pyx_4 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1138 */
      __pyx_3 = __Pyx_GetName(__pyx_m, __pyx_n_os); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1138; goto __pyx_L1;}
      __pyx_1 = PyObject_GetAttr(__pyx_3, __pyx_n_path); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1138; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_4 = PyObject_GetAttr(__pyx_1, __pyx_n_split); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1138; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1138; goto __pyx_L1;}
      Py_INCREF(__pyx_v_old_path);
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_old_path);
      __pyx_1 = PyObject_CallObject(__pyx_4, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1138; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_4 = PyObject_GetIter(__pyx_1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1138; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      __pyx_3 = __Pyx_UnpackItem(__pyx_4); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1138; goto __pyx_L1;}
      Py_DECREF(__pyx_v_old_dirname);
      __pyx_v_old_dirname = __pyx_3;
      __pyx_3 = 0;
      __pyx_1 = __Pyx_UnpackItem(__pyx_4); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1138; goto __pyx_L1;}
      Py_DECREF(__pyx_v_old_basename);
      __pyx_v_old_basename = __pyx_1;
      __pyx_1 = 0;
      if (__Pyx_EndUnpack(__pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1138; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1139 */
      __pyx_3 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1139; goto __pyx_L1;}
      __pyx_1 = __Pyx_GetItemInt(__pyx_3, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1139; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_4 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1139; goto __pyx_L1;}
      __pyx_3 = __Pyx_GetItemInt(__pyx_4, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1139; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1139; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_4, 0, __pyx_1);
      PyTuple_SET_ITEM(__pyx_4, 1, __pyx_3);
      __pyx_1 = 0;
      __pyx_3 = 0;
      __pyx_1 = PyObject_CallObject(__pyx_v_self->pathjoin, __pyx_4); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1139; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_v_path);
      __pyx_v_path = __pyx_1;
      __pyx_1 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1140 */
      __pyx_3 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__get_entry); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1140; goto __pyx_L1;}
      __pyx_4 = PyInt_FromLong(__pyx_v_self->source_index); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1140; goto __pyx_L1;}
      __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1140; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_1, 0, __pyx_4);
      __pyx_4 = 0;
      __pyx_4 = PyDict_New(); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1140; goto __pyx_L1;}
      if (PyDict_SetItem(__pyx_4, __pyx_n_path_utf8, __pyx_v_old_path) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1140; goto __pyx_L1;}
      __pyx_6 = PyEval_CallObjectWithKeywords(__pyx_3, __pyx_1, __pyx_4); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1140; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_v_old_entry);
      __pyx_v_old_entry = __pyx_6;
      __pyx_6 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1144 */
      __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1144; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_3, 0, Py_None);
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_3, 1, Py_None);
      if (PyObject_Cmp(__pyx_v_old_entry, __pyx_3, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1144; goto __pyx_L1;}
      __pyx_5 = __pyx_5 == 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      if (__pyx_5) {
        __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_errors); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1145; goto __pyx_L1;}
        __pyx_4 = PyObject_GetAttr(__pyx_1, __pyx_n_CorruptDirstate); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1145; goto __pyx_L1;}
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        __pyx_6 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__filename); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1145; goto __pyx_L1;}
        __pyx_3 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1148; goto __pyx_L1;}
        __pyx_1 = __Pyx_GetItemInt(__pyx_3, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1148; goto __pyx_L1;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        __pyx_3 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1148; goto __pyx_L1;}
        __pyx_7 = __Pyx_GetItemInt(__pyx_3, 1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1148; goto __pyx_L1;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        __pyx_3 = PyTuple_New(4); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1148; goto __pyx_L1;}
        PyTuple_SET_ITEM(__pyx_3, 0, __pyx_1);
        PyTuple_SET_ITEM(__pyx_3, 1, __pyx_7);
        Py_INCREF(__pyx_v_old_path);
        PyTuple_SET_ITEM(__pyx_3, 2, __pyx_v_old_path);
        Py_INCREF(__pyx_v_entry);
        PyTuple_SET_ITEM(__pyx_3, 3, __pyx_v_entry);
        __pyx_1 = 0;
        __pyx_7 = 0;
        __pyx_1 = PyNumber_Remainder(__pyx_k64p, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1148; goto __pyx_L1;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        __pyx_7 = PyTuple_New(2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1145; goto __pyx_L1;}
        PyTuple_SET_ITEM(__pyx_7, 0, __pyx_6);
        PyTuple_SET_ITEM(__pyx_7, 1, __pyx_1);
        __pyx_6 = 0;
        __pyx_1 = 0;
        __pyx_3 = PyObject_CallObject(__pyx_4, __pyx_7); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1145; goto __pyx_L1;}
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        Py_DECREF(__pyx_7); __pyx_7 = 0;
        __Pyx_Raise(__pyx_3, 0, 0);
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1145; goto __pyx_L1;}
        goto __pyx_L8;
      }
      __pyx_L8:;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1149 */
      __pyx_6 = __Pyx_GetItemInt(__pyx_v_old_entry, 1); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1149; goto __pyx_L1;}
      __pyx_1 = __Pyx_GetItemInt(__pyx_6, __pyx_v_self->source_index); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1149; goto __pyx_L1;}
      Py_DECREF(__pyx_6); __pyx_6 = 0;
      Py_DECREF(__pyx_v_source_details);
      __pyx_v_source_details = __pyx_1;
      __pyx_1 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1150 */
      __pyx_4 = __Pyx_GetItemInt(__pyx_v_source_details, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1150; goto __pyx_L1;}
      __pyx_v_source_minikind = __pyx_f_21_dirstate_helpers_pyx__minikind_from_string(__pyx_4);
      Py_DECREF(__pyx_4); __pyx_4 = 0;
    }
    __pyx_L6:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1151 */
    __pyx_2 = __pyx_v_path_info == Py_None;
    if (__pyx_2) {

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1153 */
      __pyx_v_content_change = 1;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1154 */
      Py_INCREF(Py_None);
      Py_DECREF(__pyx_v_target_kind);
      __pyx_v_target_kind = Py_None;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1155 */
      Py_INCREF(Py_False);
      Py_DECREF(__pyx_v_target_exec);
      __pyx_v_target_exec = Py_False;
      goto __pyx_L9;
    }
    /*else*/ {

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1158 */
      __pyx_7 = __Pyx_GetItemInt(__pyx_v_path_info, 2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1158; goto __pyx_L1;}
      Py_DECREF(__pyx_v_target_kind);
      __pyx_v_target_kind = __pyx_7;
      __pyx_7 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1159 */
      if (PyObject_Cmp(__pyx_v_target_kind, __pyx_n_directory, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1159; goto __pyx_L1;}
      __pyx_5 = __pyx_5 == 0;
      if (__pyx_5) {

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1160 */
        __pyx_2 = __pyx_v_path == Py_None;
        if (__pyx_2) {
          __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1161; goto __pyx_L1;}
          Py_INCREF(__pyx_v_old_dirname);
          PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_old_dirname);
          Py_INCREF(__pyx_v_old_basename);
          PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_old_basename);
          __pyx_6 = PyObject_CallObject(__pyx_v_self->pathjoin, __pyx_3); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1161; goto __pyx_L1;}
          Py_DECREF(__pyx_3); __pyx_3 = 0;
          Py_INCREF(__pyx_6);
          Py_DECREF(__pyx_v_old_path);
          __pyx_v_old_path = __pyx_6;
          Py_INCREF(__pyx_6);
          Py_DECREF(__pyx_v_path);
          __pyx_v_path = __pyx_6;
          Py_DECREF(__pyx_6); __pyx_6 = 0;
          goto __pyx_L11;
        }
        __pyx_L11:;

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1162 */
        __pyx_1 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1162; goto __pyx_L1;}
        __pyx_4 = __Pyx_GetItemInt(__pyx_1, 2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1162; goto __pyx_L1;}
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        Py_DECREF(__pyx_v_file_id);
        __pyx_v_file_id = __pyx_4;
        __pyx_4 = 0;

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1163 */
        if (PyObject_SetItem(__pyx_v_self->new_dirname_to_file_id, __pyx_v_path, __pyx_v_file_id) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1163; goto __pyx_L1;}

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1164 */
        __pyx_5 = (__pyx_v_source_minikind != 'd');
        if (__pyx_5) {
          __pyx_v_content_change = 1;
          goto __pyx_L12;
        }
        /*else*/ {
          __pyx_v_content_change = 0;
        }
        __pyx_L12:;

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1169 */
        Py_INCREF(Py_False);
        Py_DECREF(__pyx_v_target_exec);
        __pyx_v_target_exec = Py_False;
        goto __pyx_L10;
      }
      if (PyObject_Cmp(__pyx_v_target_kind, __pyx_n_file, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1170; goto __pyx_L1;}
      __pyx_2 = __pyx_2 == 0;
      if (__pyx_2) {

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1171 */
        __pyx_5 = (__pyx_v_source_minikind != 'f');
        if (__pyx_5) {
          __pyx_v_content_change = 1;
          goto __pyx_L13;
        }
        /*else*/ {

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1177 */
          __pyx_2 = __pyx_v_link_or_sha1 == Py_None;
          if (__pyx_2) {

            /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1180 */
            __pyx_7 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__sha1_provider); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1180; goto __pyx_L1;}
            __pyx_3 = PyObject_GetAttr(__pyx_7, __pyx_n_stat_and_sha1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1180; goto __pyx_L1;}
            Py_DECREF(__pyx_7); __pyx_7 = 0;
            __pyx_6 = __Pyx_GetItemInt(__pyx_v_path_info, 4); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1181; goto __pyx_L1;}
            __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1180; goto __pyx_L1;}
            PyTuple_SET_ITEM(__pyx_1, 0, __pyx_6);
            __pyx_6 = 0;
            __pyx_4 = PyObject_CallObject(__pyx_3, __pyx_1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1180; goto __pyx_L1;}
            Py_DECREF(__pyx_3); __pyx_3 = 0;
            Py_DECREF(__pyx_1); __pyx_1 = 0;
            __pyx_7 = PyObject_GetIter(__pyx_4); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1179; goto __pyx_L1;}
            Py_DECREF(__pyx_4); __pyx_4 = 0;
            __pyx_6 = __Pyx_UnpackItem(__pyx_7); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1179; goto __pyx_L1;}
            Py_DECREF(__pyx_v_statvalue);
            __pyx_v_statvalue = __pyx_6;
            __pyx_6 = 0;
            __pyx_3 = __Pyx_UnpackItem(__pyx_7); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1179; goto __pyx_L1;}
            Py_DECREF(__pyx_v_link_or_sha1);
            __pyx_v_link_or_sha1 = __pyx_3;
            __pyx_3 = 0;
            if (__Pyx_EndUnpack(__pyx_7) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1179; goto __pyx_L1;}
            Py_DECREF(__pyx_7); __pyx_7 = 0;

            /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1182 */
            __pyx_1 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__observed_sha1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1182; goto __pyx_L1;}
            __pyx_4 = PyTuple_New(3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1182; goto __pyx_L1;}
            Py_INCREF(__pyx_v_entry);
            PyTuple_SET_ITEM(__pyx_4, 0, __pyx_v_entry);
            Py_INCREF(__pyx_v_link_or_sha1);
            PyTuple_SET_ITEM(__pyx_4, 1, __pyx_v_link_or_sha1);
            Py_INCREF(__pyx_v_statvalue);
            PyTuple_SET_ITEM(__pyx_4, 2, __pyx_v_statvalue);
            __pyx_6 = PyObject_CallObject(__pyx_1, __pyx_4); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1182; goto __pyx_L1;}
            Py_DECREF(__pyx_1); __pyx_1 = 0;
            Py_DECREF(__pyx_4); __pyx_4 = 0;
            Py_DECREF(__pyx_6); __pyx_6 = 0;
            goto __pyx_L14;
          }
          __pyx_L14:;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1184 */
          __pyx_3 = __Pyx_GetItemInt(__pyx_v_source_details, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1184; goto __pyx_L1;}
          if (PyObject_Cmp(__pyx_v_link_or_sha1, __pyx_3, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1184; goto __pyx_L1;}
          __pyx_5 = __pyx_5 != 0;
          Py_DECREF(__pyx_3); __pyx_3 = 0;
          __pyx_v_content_change = __pyx_5;
        }
        __pyx_L13:;

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1186 */
        __pyx_2 = PyObject_IsTrue(__pyx_v_self->use_filesystem_for_exec); if (__pyx_2 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1186; goto __pyx_L1;}
        if (__pyx_2) {
          __pyx_7 = PyInt_FromLong(S_IXUSR); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1189; goto __pyx_L1;}
          __pyx_1 = __Pyx_GetItemInt(__pyx_v_path_info, 3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1189; goto __pyx_L1;}
          __pyx_4 = PyObject_GetAttr(__pyx_1, __pyx_n_st_mode); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1189; goto __pyx_L1;}
          Py_DECREF(__pyx_1); __pyx_1 = 0;
          __pyx_6 = PyNumber_And(__pyx_7, __pyx_4); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1189; goto __pyx_L1;}
          Py_DECREF(__pyx_7); __pyx_7 = 0;
          Py_DECREF(__pyx_4); __pyx_4 = 0;
          __pyx_5 = PyObject_IsTrue(__pyx_6); if (__pyx_5 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1189; goto __pyx_L1;}
          Py_DECREF(__pyx_6); __pyx_6 = 0;
          __pyx_3 = PyInt_FromLong(__pyx_5); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1189; goto __pyx_L1;}
          Py_DECREF(__pyx_v_target_exec);
          __pyx_v_target_exec = __pyx_3;
          __pyx_3 = 0;
          goto __pyx_L15;
        }
        /*else*/ {
          __pyx_1 = __Pyx_GetItemInt(__pyx_v_target_details, 3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1191; goto __pyx_L1;}
          Py_DECREF(__pyx_v_target_exec);
          __pyx_v_target_exec = __pyx_1;
          __pyx_1 = 0;
        }
        __pyx_L15:;
        goto __pyx_L10;
      }
      if (PyObject_Cmp(__pyx_v_target_kind, __pyx_n_symlink, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1192; goto __pyx_L1;}
      __pyx_2 = __pyx_2 == 0;
      if (__pyx_2) {

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1193 */
        __pyx_5 = (__pyx_v_source_minikind != 'l');
        if (__pyx_5) {
          __pyx_v_content_change = 1;
          goto __pyx_L16;
        }
        /*else*/ {
          __pyx_7 = __Pyx_GetItemInt(__pyx_v_source_details, 1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1196; goto __pyx_L1;}
          if (PyObject_Cmp(__pyx_v_link_or_sha1, __pyx_7, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1196; goto __pyx_L1;}
          __pyx_2 = __pyx_2 != 0;
          Py_DECREF(__pyx_7); __pyx_7 = 0;
          __pyx_v_content_change = __pyx_2;
        }
        __pyx_L16:;

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1197 */
        Py_INCREF(Py_False);
        Py_DECREF(__pyx_v_target_exec);
        __pyx_v_target_exec = Py_False;
        goto __pyx_L10;
      }
      if (PyObject_Cmp(__pyx_v_target_kind, __pyx_k68p, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1198; goto __pyx_L1;}
      __pyx_5 = __pyx_5 == 0;
      if (__pyx_5) {

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1199 */
        __pyx_2 = (__pyx_v_source_minikind != 't');
        if (__pyx_2) {
          __pyx_v_content_change = 1;
          goto __pyx_L17;
        }
        /*else*/ {
          __pyx_v_content_change = 0;
        }
        __pyx_L17:;

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1203 */
        Py_INCREF(Py_False);
        Py_DECREF(__pyx_v_target_exec);
        __pyx_v_target_exec = Py_False;
        goto __pyx_L10;
      }
      /*else*/ {
        __pyx_4 = __Pyx_GetItemInt(__pyx_v_path_info, 2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1205; goto __pyx_L1;}
        __pyx_6 = PyNumber_Remainder(__pyx_k69p, __pyx_4); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1205; goto __pyx_L1;}
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        __Pyx_Raise(PyExc_Exception, __pyx_6, 0);
        Py_DECREF(__pyx_6); __pyx_6 = 0;
        {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1205; goto __pyx_L1;}
      }
      __pyx_L10:;
    }
    __pyx_L9:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1206 */
    __pyx_5 = (__pyx_v_source_minikind == 'd');
    if (__pyx_5) {

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1207 */
      __pyx_2 = __pyx_v_path == Py_None;
      if (__pyx_2) {
        __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1208; goto __pyx_L1;}
        Py_INCREF(__pyx_v_old_dirname);
        PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_old_dirname);
        Py_INCREF(__pyx_v_old_basename);
        PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_old_basename);
        __pyx_1 = PyObject_CallObject(__pyx_v_self->pathjoin, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1208; goto __pyx_L1;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        Py_INCREF(__pyx_1);
        Py_DECREF(__pyx_v_old_path);
        __pyx_v_old_path = __pyx_1;
        Py_INCREF(__pyx_1);
        Py_DECREF(__pyx_v_path);
        __pyx_v_path = __pyx_1;
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        goto __pyx_L19;
      }
      __pyx_L19:;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1209 */
      __pyx_5 = __pyx_v_file_id == Py_None;
      if (__pyx_5) {
        __pyx_7 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1210; goto __pyx_L1;}
        __pyx_4 = __Pyx_GetItemInt(__pyx_7, 2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1210; goto __pyx_L1;}
        Py_DECREF(__pyx_7); __pyx_7 = 0;
        Py_DECREF(__pyx_v_file_id);
        __pyx_v_file_id = __pyx_4;
        __pyx_4 = 0;
        goto __pyx_L20;
      }
      __pyx_L20:;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1211 */
      if (PyObject_SetItem(__pyx_v_self->old_dirname_to_file_id, __pyx_v_old_path, __pyx_v_file_id) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1211; goto __pyx_L1;}
      goto __pyx_L18;
    }
    __pyx_L18:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1213 */
    __pyx_6 = __pyx_v_old_basename;
    Py_INCREF(__pyx_6);
    __pyx_2 = PyObject_IsTrue(__pyx_6); if (__pyx_2 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1213; goto __pyx_L1;}
    if (__pyx_2) {
      Py_DECREF(__pyx_6); __pyx_6 = 0;
      __pyx_3 = __Pyx_GetItemInt(__pyx_v_self->last_source_parent, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1213; goto __pyx_L1;}
      if (PyObject_Cmp(__pyx_v_old_dirname, __pyx_3, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1213; goto __pyx_L1;}
      __pyx_5 = __pyx_5 == 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_6 = PyInt_FromLong(__pyx_5); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1213; goto __pyx_L1;}
    }
    __pyx_2 = PyObject_IsTrue(__pyx_6); if (__pyx_2 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1213; goto __pyx_L1;}
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    if (__pyx_2) {
      __pyx_1 = __Pyx_GetItemInt(__pyx_v_self->last_source_parent, 1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1215; goto __pyx_L1;}
      Py_DECREF(__pyx_v_source_parent_id);
      __pyx_v_source_parent_id = __pyx_1;
      __pyx_1 = 0;
      goto __pyx_L21;
    }
    /*else*/ {

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1217 */
      /*try:*/ {
        __pyx_7 = PyObject_GetItem(__pyx_v_self->old_dirname_to_file_id, __pyx_v_old_dirname); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1218; goto __pyx_L22;}
        Py_DECREF(__pyx_v_source_parent_id);
        __pyx_v_source_parent_id = __pyx_7;
        __pyx_7 = 0;
      }
      goto __pyx_L23;
      __pyx_L22:;
      Py_XDECREF(__pyx_4); __pyx_4 = 0;
      Py_XDECREF(__pyx_3); __pyx_3 = 0;
      Py_XDECREF(__pyx_6); __pyx_6 = 0;
      Py_XDECREF(__pyx_1); __pyx_1 = 0;
      Py_XDECREF(__pyx_7); __pyx_7 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1219 */
      __pyx_5 = PyErr_ExceptionMatches(PyExc_KeyError);
      if (__pyx_5) {
        __Pyx_AddTraceback("_dirstate_helpers_pyx._process_entry");
        if (__Pyx_GetException(&__pyx_4, &__pyx_3, &__pyx_6) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1219; goto __pyx_L1;}

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1220 */
        __pyx_1 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__get_entry); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1220; goto __pyx_L1;}
        __pyx_7 = PyInt_FromLong(__pyx_v_self->source_index); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1220; goto __pyx_L1;}
        __pyx_8 = PyTuple_New(1); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1220; goto __pyx_L1;}
        PyTuple_SET_ITEM(__pyx_8, 0, __pyx_7);
        __pyx_7 = 0;
        __pyx_7 = PyDict_New(); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1220; goto __pyx_L1;}
        if (PyDict_SetItem(__pyx_7, __pyx_n_path_utf8, __pyx_v_old_dirname) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1220; goto __pyx_L1;}
        __pyx_9 = PyEval_CallObjectWithKeywords(__pyx_1, __pyx_8, __pyx_7); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1220; goto __pyx_L1;}
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        Py_DECREF(__pyx_8); __pyx_8 = 0;
        Py_DECREF(__pyx_7); __pyx_7 = 0;
        Py_DECREF(__pyx_v_source_parent_entry);
        __pyx_v_source_parent_entry = __pyx_9;
        __pyx_9 = 0;

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1222 */
        __pyx_1 = __Pyx_GetItemInt(__pyx_v_source_parent_entry, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1222; goto __pyx_L1;}
        __pyx_8 = __Pyx_GetItemInt(__pyx_1, 2); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1222; goto __pyx_L1;}
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        Py_DECREF(__pyx_v_source_parent_id);
        __pyx_v_source_parent_id = __pyx_8;
        __pyx_8 = 0;
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        Py_DECREF(__pyx_6); __pyx_6 = 0;
        goto __pyx_L23;
      }
      goto __pyx_L1;
      __pyx_L23:;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1223 */
      __pyx_7 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1223; goto __pyx_L1;}
      __pyx_9 = __Pyx_GetItemInt(__pyx_7, 2); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1223; goto __pyx_L1;}
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      if (PyObject_Cmp(__pyx_v_source_parent_id, __pyx_9, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1223; goto __pyx_L1;}
      __pyx_2 = __pyx_2 == 0;
      Py_DECREF(__pyx_9); __pyx_9 = 0;
      if (__pyx_2) {
        Py_INCREF(Py_None);
        Py_DECREF(__pyx_v_source_parent_id);
        __pyx_v_source_parent_id = Py_None;
        goto __pyx_L24;
      }
      /*else*/ {

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1227 */
        if (__Pyx_SetItemInt(__pyx_v_self->last_source_parent, 0, __pyx_v_old_dirname) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1227; goto __pyx_L1;}

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1228 */
        if (__Pyx_SetItemInt(__pyx_v_self->last_source_parent, 1, __pyx_v_source_parent_id) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1228; goto __pyx_L1;}
      }
      __pyx_L24:;
    }
    __pyx_L21:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1229 */
    __pyx_1 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1229; goto __pyx_L1;}
    __pyx_8 = __Pyx_GetItemInt(__pyx_1, 0); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1229; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_v_new_dirname);
    __pyx_v_new_dirname = __pyx_8;
    __pyx_8 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1230 */
    __pyx_3 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1230; goto __pyx_L1;}
    __pyx_4 = __Pyx_GetItemInt(__pyx_3, 1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1230; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_5 = PyObject_IsTrue(__pyx_4); if (__pyx_5 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1230; goto __pyx_L1;}
    if (__pyx_5) {
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      __pyx_6 = __Pyx_GetItemInt(__pyx_v_self->last_target_parent, 0); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1230; goto __pyx_L1;}
      if (PyObject_Cmp(__pyx_v_new_dirname, __pyx_6, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1230; goto __pyx_L1;}
      __pyx_2 = __pyx_2 == 0;
      Py_DECREF(__pyx_6); __pyx_6 = 0;
      __pyx_4 = PyInt_FromLong(__pyx_2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1230; goto __pyx_L1;}
    }
    __pyx_5 = PyObject_IsTrue(__pyx_4); if (__pyx_5 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1230; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    if (__pyx_5) {
      __pyx_7 = __Pyx_GetItemInt(__pyx_v_self->last_target_parent, 1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1232; goto __pyx_L1;}
      Py_DECREF(__pyx_v_target_parent_id);
      __pyx_v_target_parent_id = __pyx_7;
      __pyx_7 = 0;
      goto __pyx_L25;
    }
    /*else*/ {

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1234 */
      /*try:*/ {
        __pyx_9 = PyObject_GetItem(__pyx_v_self->new_dirname_to_file_id, __pyx_v_new_dirname); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1235; goto __pyx_L26;}
        Py_DECREF(__pyx_v_target_parent_id);
        __pyx_v_target_parent_id = __pyx_9;
        __pyx_9 = 0;
      }
      goto __pyx_L27;
      __pyx_L26:;
      Py_XDECREF(__pyx_1); __pyx_1 = 0;
      Py_XDECREF(__pyx_8); __pyx_8 = 0;
      Py_XDECREF(__pyx_3); __pyx_3 = 0;
      Py_XDECREF(__pyx_6); __pyx_6 = 0;
      Py_XDECREF(__pyx_4); __pyx_4 = 0;
      Py_XDECREF(__pyx_7); __pyx_7 = 0;
      Py_XDECREF(__pyx_9); __pyx_9 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1236 */
      __pyx_2 = PyErr_ExceptionMatches(PyExc_KeyError);
      if (__pyx_2) {
        __Pyx_AddTraceback("_dirstate_helpers_pyx._process_entry");
        if (__Pyx_GetException(&__pyx_1, &__pyx_8, &__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1236; goto __pyx_L1;}

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1239 */
        __pyx_6 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__get_entry); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1239; goto __pyx_L1;}
        __pyx_4 = PyInt_FromLong(__pyx_v_self->target_index); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1239; goto __pyx_L1;}
        __pyx_7 = PyTuple_New(1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1239; goto __pyx_L1;}
        PyTuple_SET_ITEM(__pyx_7, 0, __pyx_4);
        __pyx_4 = 0;
        __pyx_9 = PyDict_New(); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1239; goto __pyx_L1;}
        if (PyDict_SetItem(__pyx_9, __pyx_n_path_utf8, __pyx_v_new_dirname) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1239; goto __pyx_L1;}
        __pyx_4 = PyEval_CallObjectWithKeywords(__pyx_6, __pyx_7, __pyx_9); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1239; goto __pyx_L1;}
        Py_DECREF(__pyx_6); __pyx_6 = 0;
        Py_DECREF(__pyx_7); __pyx_7 = 0;
        Py_DECREF(__pyx_9); __pyx_9 = 0;
        Py_DECREF(__pyx_v_target_parent_entry);
        __pyx_v_target_parent_entry = __pyx_4;
        __pyx_4 = 0;

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1241 */
        __pyx_6 = PyTuple_New(2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1241; goto __pyx_L1;}
        Py_INCREF(Py_None);
        PyTuple_SET_ITEM(__pyx_6, 0, Py_None);
        Py_INCREF(Py_None);
        PyTuple_SET_ITEM(__pyx_6, 1, Py_None);
        if (PyObject_Cmp(__pyx_v_target_parent_entry, __pyx_6, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1241; goto __pyx_L1;}
        __pyx_5 = __pyx_5 == 0;
        Py_DECREF(__pyx_6); __pyx_6 = 0;
        if (__pyx_5) {
          __pyx_7 = PyTuple_New(2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1244; goto __pyx_L1;}
          Py_INCREF(__pyx_v_new_dirname);
          PyTuple_SET_ITEM(__pyx_7, 0, __pyx_v_new_dirname);
          Py_INCREF(__pyx_v_entry);
          PyTuple_SET_ITEM(__pyx_7, 1, __pyx_v_entry);
          __pyx_9 = PyNumber_Remainder(__pyx_k72p, __pyx_7); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1244; goto __pyx_L1;}
          Py_DECREF(__pyx_7); __pyx_7 = 0;
          __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1242; goto __pyx_L1;}
          PyTuple_SET_ITEM(__pyx_4, 0, __pyx_9);
          __pyx_9 = 0;
          __pyx_6 = PyObject_CallObject(PyExc_AssertionError, __pyx_4); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1242; goto __pyx_L1;}
          Py_DECREF(__pyx_4); __pyx_4 = 0;
          __Pyx_Raise(__pyx_6, 0, 0);
          Py_DECREF(__pyx_6); __pyx_6 = 0;
          {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1242; goto __pyx_L1;}
          goto __pyx_L28;
        }
        __pyx_L28:;

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1245 */
        __pyx_7 = __Pyx_GetItemInt(__pyx_v_target_parent_entry, 0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1245; goto __pyx_L1;}
        __pyx_9 = __Pyx_GetItemInt(__pyx_7, 2); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1245; goto __pyx_L1;}
        Py_DECREF(__pyx_7); __pyx_7 = 0;
        Py_DECREF(__pyx_v_target_parent_id);
        __pyx_v_target_parent_id = __pyx_9;
        __pyx_9 = 0;
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        Py_DECREF(__pyx_8); __pyx_8 = 0;
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        goto __pyx_L27;
      }
      goto __pyx_L1;
      __pyx_L27:;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1246 */
      __pyx_4 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1246; goto __pyx_L1;}
      __pyx_6 = __Pyx_GetItemInt(__pyx_4, 2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1246; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      if (PyObject_Cmp(__pyx_v_target_parent_id, __pyx_6, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1246; goto __pyx_L1;}
      __pyx_2 = __pyx_2 == 0;
      Py_DECREF(__pyx_6); __pyx_6 = 0;
      if (__pyx_2) {
        Py_INCREF(Py_None);
        Py_DECREF(__pyx_v_target_parent_id);
        __pyx_v_target_parent_id = Py_None;
        goto __pyx_L29;
      }
      /*else*/ {

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1250 */
        if (__Pyx_SetItemInt(__pyx_v_self->last_target_parent, 0, __pyx_v_new_dirname) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1250; goto __pyx_L1;}

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1251 */
        if (__Pyx_SetItemInt(__pyx_v_self->last_target_parent, 1, __pyx_v_target_parent_id) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1251; goto __pyx_L1;}
      }
      __pyx_L29:;
    }
    __pyx_L25:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1253 */
    __pyx_7 = __Pyx_GetItemInt(__pyx_v_source_details, 3); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1253; goto __pyx_L1;}
    Py_DECREF(__pyx_v_source_exec);
    __pyx_v_source_exec = __pyx_7;
    __pyx_7 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1255 */
    __pyx_5 = __pyx_v_content_change;
    if (!__pyx_5) {
      if (PyObject_Cmp(__pyx_v_source_parent_id, __pyx_v_target_parent_id, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1255; goto __pyx_L1;}
      __pyx_5 = __pyx_5 != 0;
      if (!__pyx_5) {
        __pyx_9 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1256; goto __pyx_L1;}
        __pyx_1 = __Pyx_GetItemInt(__pyx_9, 1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1256; goto __pyx_L1;}
        Py_DECREF(__pyx_9); __pyx_9 = 0;
        if (PyObject_Cmp(__pyx_v_old_basename, __pyx_1, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1256; goto __pyx_L1;}
        __pyx_5 = __pyx_5 != 0;
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        if (!__pyx_5) {
          if (PyObject_Cmp(__pyx_v_source_exec, __pyx_v_target_exec, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1257; goto __pyx_L1;}
          __pyx_5 = __pyx_5 != 0;
        }
      }
    }
    __pyx_8 = PyInt_FromLong(__pyx_5); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1255; goto __pyx_L1;}
    Py_DECREF(__pyx_v_changed);
    __pyx_v_changed = __pyx_8;
    __pyx_8 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1259 */
    __pyx_5 = PyObject_IsTrue(__pyx_v_changed); if (__pyx_5 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1259; goto __pyx_L1;}
    __pyx_2 = (!__pyx_5);
    if (__pyx_2) {
      __pyx_2 = (!__pyx_v_self->include_unchanged);
    }
    if (__pyx_2) {
      __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1260; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_3, 0, Py_None);
      Py_INCREF(Py_False);
      PyTuple_SET_ITEM(__pyx_3, 1, Py_False);
      __pyx_r = __pyx_3;
      __pyx_3 = 0;
      goto __pyx_L0;
      goto __pyx_L30;
    }
    /*else*/ {

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1262 */
      __pyx_5 = __pyx_v_old_path == Py_None;
      if (__pyx_5) {

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1263 */
        __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1263; goto __pyx_L1;}
        Py_INCREF(__pyx_v_old_dirname);
        PyTuple_SET_ITEM(__pyx_4, 0, __pyx_v_old_dirname);
        Py_INCREF(__pyx_v_old_basename);
        PyTuple_SET_ITEM(__pyx_4, 1, __pyx_v_old_basename);
        __pyx_6 = PyObject_CallObject(__pyx_v_self->pathjoin, __pyx_4); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1263; goto __pyx_L1;}
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        Py_DECREF(__pyx_v_path);
        __pyx_v_path = __pyx_6;
        __pyx_6 = 0;

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1264 */
        Py_INCREF(__pyx_v_path);
        Py_DECREF(__pyx_v_old_path);
        __pyx_v_old_path = __pyx_v_path;

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1265 */
        __pyx_7 = PyTuple_New(1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1265; goto __pyx_L1;}
        Py_INCREF(__pyx_v_old_path);
        PyTuple_SET_ITEM(__pyx_7, 0, __pyx_v_old_path);
        __pyx_9 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_7); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1265; goto __pyx_L1;}
        Py_DECREF(__pyx_7); __pyx_7 = 0;
        __pyx_1 = __Pyx_GetItemInt(__pyx_9, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1265; goto __pyx_L1;}
        Py_DECREF(__pyx_9); __pyx_9 = 0;
        Py_DECREF(__pyx_v_old_path_u);
        __pyx_v_old_path_u = __pyx_1;
        __pyx_1 = 0;

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1266 */
        Py_INCREF(__pyx_v_old_path_u);
        Py_DECREF(__pyx_v_path_u);
        __pyx_v_path_u = __pyx_v_old_path_u;
        goto __pyx_L31;
      }
      /*else*/ {

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1268 */
        __pyx_8 = PyTuple_New(1); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1268; goto __pyx_L1;}
        Py_INCREF(__pyx_v_old_path);
        PyTuple_SET_ITEM(__pyx_8, 0, __pyx_v_old_path);
        __pyx_3 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_8); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1268; goto __pyx_L1;}
        Py_DECREF(__pyx_8); __pyx_8 = 0;
        __pyx_4 = __Pyx_GetItemInt(__pyx_3, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1268; goto __pyx_L1;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        Py_DECREF(__pyx_v_old_path_u);
        __pyx_v_old_path_u = __pyx_4;
        __pyx_4 = 0;

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1269 */
        if (PyObject_Cmp(__pyx_v_old_path, __pyx_v_path, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1269; goto __pyx_L1;}
        __pyx_2 = __pyx_2 == 0;
        if (__pyx_2) {
          Py_INCREF(__pyx_v_old_path_u);
          Py_DECREF(__pyx_v_path_u);
          __pyx_v_path_u = __pyx_v_old_path_u;
          goto __pyx_L32;
        }
        /*else*/ {
          __pyx_6 = PyTuple_New(1); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1272; goto __pyx_L1;}
          Py_INCREF(__pyx_v_path);
          PyTuple_SET_ITEM(__pyx_6, 0, __pyx_v_path);
          __pyx_7 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_6); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1272; goto __pyx_L1;}
          Py_DECREF(__pyx_6); __pyx_6 = 0;
          __pyx_9 = __Pyx_GetItemInt(__pyx_7, 0); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1272; goto __pyx_L1;}
          Py_DECREF(__pyx_7); __pyx_7 = 0;
          Py_DECREF(__pyx_v_path_u);
          __pyx_v_path_u = __pyx_9;
          __pyx_9 = 0;
        }
        __pyx_L32:;
      }
      __pyx_L31:;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1273 */
      __pyx_1 = __pyx_f_21_dirstate_helpers_pyx__minikind_to_kind(__pyx_v_source_minikind); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1273; goto __pyx_L1;}
      Py_DECREF(__pyx_v_source_kind);
      __pyx_v_source_kind = __pyx_1;
      __pyx_1 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1274 */
      __pyx_8 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1274; goto __pyx_L1;}
      __pyx_3 = __Pyx_GetItemInt(__pyx_8, 2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1274; goto __pyx_L1;}
      Py_DECREF(__pyx_8); __pyx_8 = 0;
      __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1275; goto __pyx_L1;}
      Py_INCREF(__pyx_v_old_path_u);
      PyTuple_SET_ITEM(__pyx_4, 0, __pyx_v_old_path_u);
      Py_INCREF(__pyx_v_path_u);
      PyTuple_SET_ITEM(__pyx_4, 1, __pyx_v_path_u);
      __pyx_6 = PyInt_FromLong(__pyx_v_content_change); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1276; goto __pyx_L1;}
      __pyx_7 = PyTuple_New(2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1277; goto __pyx_L1;}
      Py_INCREF(Py_True);
      PyTuple_SET_ITEM(__pyx_7, 0, Py_True);
      Py_INCREF(Py_True);
      PyTuple_SET_ITEM(__pyx_7, 1, Py_True);
      __pyx_9 = PyTuple_New(2); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1278; goto __pyx_L1;}
      Py_INCREF(__pyx_v_source_parent_id);
      PyTuple_SET_ITEM(__pyx_9, 0, __pyx_v_source_parent_id);
      Py_INCREF(__pyx_v_target_parent_id);
      PyTuple_SET_ITEM(__pyx_9, 1, __pyx_v_target_parent_id);
      __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1279; goto __pyx_L1;}
      Py_INCREF(__pyx_v_old_basename);
      PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_old_basename);
      __pyx_8 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_1); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1279; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      __pyx_1 = __Pyx_GetItemInt(__pyx_8, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1279; goto __pyx_L1;}
      Py_DECREF(__pyx_8); __pyx_8 = 0;
      __pyx_8 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1279; goto __pyx_L1;}
      __pyx_10 = __Pyx_GetItemInt(__pyx_8, 1); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1279; goto __pyx_L1;}
      Py_DECREF(__pyx_8); __pyx_8 = 0;
      __pyx_8 = PyTuple_New(1); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1279; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_8, 0, __pyx_10);
      __pyx_10 = 0;
      __pyx_10 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_8); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1279; goto __pyx_L1;}
      Py_DECREF(__pyx_8); __pyx_8 = 0;
      __pyx_8 = __Pyx_GetItemInt(__pyx_10, 0); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1279; goto __pyx_L1;}
      Py_DECREF(__pyx_10); __pyx_10 = 0;
      __pyx_10 = PyTuple_New(2); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1279; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_10, 0, __pyx_1);
      PyTuple_SET_ITEM(__pyx_10, 1, __pyx_8);
      __pyx_1 = 0;
      __pyx_8 = 0;
      __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1280; goto __pyx_L1;}
      Py_INCREF(__pyx_v_source_kind);
      PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_source_kind);
      Py_INCREF(__pyx_v_target_kind);
      PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_target_kind);
      __pyx_8 = PyTuple_New(2); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1281; goto __pyx_L1;}
      Py_INCREF(__pyx_v_source_exec);
      PyTuple_SET_ITEM(__pyx_8, 0, __pyx_v_source_exec);
      Py_INCREF(__pyx_v_target_exec);
      PyTuple_SET_ITEM(__pyx_8, 1, __pyx_v_target_exec);
      __pyx_11 = PyTuple_New(8); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1274; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_11, 0, __pyx_3);
      PyTuple_SET_ITEM(__pyx_11, 1, __pyx_4);
      PyTuple_SET_ITEM(__pyx_11, 2, __pyx_6);
      PyTuple_SET_ITEM(__pyx_11, 3, __pyx_7);
      PyTuple_SET_ITEM(__pyx_11, 4, __pyx_9);
      PyTuple_SET_ITEM(__pyx_11, 5, __pyx_10);
      PyTuple_SET_ITEM(__pyx_11, 6, __pyx_1);
      PyTuple_SET_ITEM(__pyx_11, 7, __pyx_8);
      __pyx_3 = 0;
      __pyx_4 = 0;
      __pyx_6 = 0;
      __pyx_7 = 0;
      __pyx_9 = 0;
      __pyx_10 = 0;
      __pyx_1 = 0;
      __pyx_8 = 0;
      __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1274; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_11);
      Py_INCREF(__pyx_v_changed);
      PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_changed);
      __pyx_11 = 0;
      __pyx_r = __pyx_3;
      __pyx_3 = 0;
      goto __pyx_L0;
    }
    __pyx_L30:;
    goto __pyx_L5;
  }
  __pyx_5 = (__pyx_v_source_minikind == 'a');
  if (__pyx_5) {
    __pyx_5 = __pyx_f_21_dirstate_helpers_pyx__versioned_minikind(__pyx_v_target_minikind);
  }
  if (__pyx_5) {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1284 */
    __pyx_4 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1284; goto __pyx_L1;}
    __pyx_6 = __Pyx_GetItemInt(__pyx_4, 0); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1284; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_7 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1284; goto __pyx_L1;}
    __pyx_9 = __Pyx_GetItemInt(__pyx_7, 1); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1284; goto __pyx_L1;}
    Py_DECREF(__pyx_7); __pyx_7 = 0;
    __pyx_10 = PyTuple_New(2); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1284; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_10, 0, __pyx_6);
    PyTuple_SET_ITEM(__pyx_10, 1, __pyx_9);
    __pyx_6 = 0;
    __pyx_9 = 0;
    __pyx_1 = PyObject_CallObject(__pyx_v_self->pathjoin, __pyx_10); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1284; goto __pyx_L1;}
    Py_DECREF(__pyx_10); __pyx_10 = 0;
    Py_DECREF(__pyx_v_path);
    __pyx_v_path = __pyx_1;
    __pyx_1 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1287 */
    __pyx_8 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__get_entry); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1287; goto __pyx_L1;}
    __pyx_11 = PyInt_FromLong(__pyx_v_self->target_index); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1287; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1287; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_11);
    __pyx_11 = 0;
    __pyx_4 = PyDict_New(); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1287; goto __pyx_L1;}
    __pyx_7 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1288; goto __pyx_L1;}
    __pyx_6 = __Pyx_GetItemInt(__pyx_7, 0); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1288; goto __pyx_L1;}
    Py_DECREF(__pyx_7); __pyx_7 = 0;
    if (PyDict_SetItem(__pyx_4, __pyx_n_path_utf8, __pyx_6) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1287; goto __pyx_L1;}
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    __pyx_9 = PyEval_CallObjectWithKeywords(__pyx_8, __pyx_3, __pyx_4); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1287; goto __pyx_L1;}
    Py_DECREF(__pyx_8); __pyx_8 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_v_parent_entry);
    __pyx_v_parent_entry = __pyx_9;
    __pyx_9 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1289 */
    __pyx_2 = __pyx_v_parent_entry == Py_None;
    if (__pyx_2) {
      __pyx_10 = __Pyx_GetName(__pyx_m, __pyx_n_errors); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1290; goto __pyx_L1;}
      __pyx_1 = PyObject_GetAttr(__pyx_10, __pyx_n_DirstateCorrupt); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1290; goto __pyx_L1;}
      Py_DECREF(__pyx_10); __pyx_10 = 0;
      __pyx_11 = PyInt_FromLong(__pyx_v_self->target_index); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1293; goto __pyx_L1;}
      __pyx_7 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1293; goto __pyx_L1;}
      __pyx_6 = PyTuple_New(2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1293; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_6, 0, __pyx_11);
      PyTuple_SET_ITEM(__pyx_6, 1, __pyx_7);
      __pyx_11 = 0;
      __pyx_7 = 0;
      __pyx_8 = PyNumber_Remainder(__pyx_k74p, __pyx_6); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1293; goto __pyx_L1;}
      Py_DECREF(__pyx_6); __pyx_6 = 0;
      __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1290; goto __pyx_L1;}
      Py_INCREF(__pyx_v_self->state);
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_self->state);
      PyTuple_SET_ITEM(__pyx_3, 1, __pyx_8);
      __pyx_8 = 0;
      __pyx_4 = PyObject_CallObject(__pyx_1, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1290; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __Pyx_Raise(__pyx_4, 0, 0);
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1290; goto __pyx_L1;}
      goto __pyx_L33;
    }
    __pyx_L33:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1294 */
    __pyx_9 = __Pyx_GetItemInt(__pyx_v_parent_entry, 0); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1294; goto __pyx_L1;}
    __pyx_10 = __Pyx_GetItemInt(__pyx_9, 2); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1294; goto __pyx_L1;}
    Py_DECREF(__pyx_9); __pyx_9 = 0;
    Py_DECREF(__pyx_v_parent_id);
    __pyx_v_parent_id = __pyx_10;
    __pyx_10 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1295 */
    __pyx_11 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1295; goto __pyx_L1;}
    __pyx_7 = __Pyx_GetItemInt(__pyx_11, 2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1295; goto __pyx_L1;}
    Py_DECREF(__pyx_11); __pyx_11 = 0;
    if (PyObject_Cmp(__pyx_v_parent_id, __pyx_7, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1295; goto __pyx_L1;}
    __pyx_5 = __pyx_5 == 0;
    Py_DECREF(__pyx_7); __pyx_7 = 0;
    if (__pyx_5) {
      Py_INCREF(Py_None);
      Py_DECREF(__pyx_v_parent_id);
      __pyx_v_parent_id = Py_None;
      goto __pyx_L34;
    }
    __pyx_L34:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1297 */
    __pyx_2 = __pyx_v_path_info != Py_None;
    if (__pyx_2) {

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1299 */
      __pyx_5 = PyObject_IsTrue(__pyx_v_self->use_filesystem_for_exec); if (__pyx_5 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1299; goto __pyx_L1;}
      if (__pyx_5) {
        __pyx_8 = __Pyx_GetItemInt(__pyx_v_path_info, 3); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1303; goto __pyx_L1;}
        __pyx_1 = PyObject_GetAttr(__pyx_8, __pyx_n_st_mode); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1303; goto __pyx_L1;}
        Py_DECREF(__pyx_8); __pyx_8 = 0;
        __pyx_2 = PyInt_AsLong(__pyx_1); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1303; goto __pyx_L1;}
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        __pyx_6 = PyInt_FromLong(S_ISREG(__pyx_2)); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1303; goto __pyx_L1;}
        __pyx_5 = PyObject_IsTrue(__pyx_6); if (__pyx_5 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1304; goto __pyx_L1;}
        if (__pyx_5) {
          Py_DECREF(__pyx_6); __pyx_6 = 0;
          __pyx_3 = PyInt_FromLong(S_IXUSR); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1304; goto __pyx_L1;}
          __pyx_4 = __Pyx_GetItemInt(__pyx_v_path_info, 3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1304; goto __pyx_L1;}
          __pyx_9 = PyObject_GetAttr(__pyx_4, __pyx_n_st_mode); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1304; goto __pyx_L1;}
          Py_DECREF(__pyx_4); __pyx_4 = 0;
          __pyx_6 = PyNumber_And(__pyx_3, __pyx_9); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1304; goto __pyx_L1;}
          Py_DECREF(__pyx_3); __pyx_3 = 0;
          Py_DECREF(__pyx_9); __pyx_9 = 0;
        }
        __pyx_2 = PyObject_IsTrue(__pyx_6); if (__pyx_2 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1302; goto __pyx_L1;}
        Py_DECREF(__pyx_6); __pyx_6 = 0;
        __pyx_10 = PyInt_FromLong(__pyx_2); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1302; goto __pyx_L1;}
        Py_DECREF(__pyx_v_target_exec);
        __pyx_v_target_exec = __pyx_10;
        __pyx_10 = 0;
        goto __pyx_L36;
      }
      /*else*/ {
        __pyx_11 = __Pyx_GetItemInt(__pyx_v_target_details, 3); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1306; goto __pyx_L1;}
        Py_DECREF(__pyx_v_target_exec);
        __pyx_v_target_exec = __pyx_11;
        __pyx_11 = 0;
      }
      __pyx_L36:;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1307 */
      __pyx_7 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1307; goto __pyx_L1;}
      __pyx_8 = __Pyx_GetItemInt(__pyx_7, 2); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1307; goto __pyx_L1;}
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1308; goto __pyx_L1;}
      Py_INCREF(__pyx_v_path);
      PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_path);
      __pyx_4 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1308; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      __pyx_3 = __Pyx_GetItemInt(__pyx_4, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1308; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      __pyx_9 = PyTuple_New(2); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1308; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_9, 0, Py_None);
      PyTuple_SET_ITEM(__pyx_9, 1, __pyx_3);
      __pyx_3 = 0;
      __pyx_6 = PyTuple_New(2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1310; goto __pyx_L1;}
      Py_INCREF(Py_False);
      PyTuple_SET_ITEM(__pyx_6, 0, Py_False);
      Py_INCREF(Py_True);
      PyTuple_SET_ITEM(__pyx_6, 1, Py_True);
      __pyx_10 = PyTuple_New(2); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1311; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_10, 0, Py_None);
      Py_INCREF(__pyx_v_parent_id);
      PyTuple_SET_ITEM(__pyx_10, 1, __pyx_v_parent_id);
      __pyx_11 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1312; goto __pyx_L1;}
      __pyx_7 = __Pyx_GetItemInt(__pyx_11, 1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1312; goto __pyx_L1;}
      Py_DECREF(__pyx_11); __pyx_11 = 0;
      __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1312; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_1, 0, __pyx_7);
      __pyx_7 = 0;
      __pyx_4 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1312; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      __pyx_3 = __Pyx_GetItemInt(__pyx_4, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1312; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      __pyx_11 = PyTuple_New(2); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1312; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_11, 0, Py_None);
      PyTuple_SET_ITEM(__pyx_11, 1, __pyx_3);
      __pyx_3 = 0;
      __pyx_7 = __Pyx_GetItemInt(__pyx_v_path_info, 2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1313; goto __pyx_L1;}
      __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1313; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_1, 0, Py_None);
      PyTuple_SET_ITEM(__pyx_1, 1, __pyx_7);
      __pyx_7 = 0;
      __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1314; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_4, 0, Py_None);
      Py_INCREF(__pyx_v_target_exec);
      PyTuple_SET_ITEM(__pyx_4, 1, __pyx_v_target_exec);
      __pyx_3 = PyTuple_New(8); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1307; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_8);
      PyTuple_SET_ITEM(__pyx_3, 1, __pyx_9);
      Py_INCREF(Py_True);
      PyTuple_SET_ITEM(__pyx_3, 2, Py_True);
      PyTuple_SET_ITEM(__pyx_3, 3, __pyx_6);
      PyTuple_SET_ITEM(__pyx_3, 4, __pyx_10);
      PyTuple_SET_ITEM(__pyx_3, 5, __pyx_11);
      PyTuple_SET_ITEM(__pyx_3, 6, __pyx_1);
      PyTuple_SET_ITEM(__pyx_3, 7, __pyx_4);
      __pyx_8 = 0;
      __pyx_9 = 0;
      __pyx_6 = 0;
      __pyx_10 = 0;
      __pyx_11 = 0;
      __pyx_1 = 0;
      __pyx_4 = 0;
      __pyx_7 = PyTuple_New(2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1307; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_7, 0, __pyx_3);
      Py_INCREF(Py_True);
      PyTuple_SET_ITEM(__pyx_7, 1, Py_True);
      __pyx_3 = 0;
      __pyx_r = __pyx_7;
      __pyx_7 = 0;
      goto __pyx_L0;
      goto __pyx_L35;
    }
    /*else*/ {
      __pyx_8 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1317; goto __pyx_L1;}
      __pyx_9 = __Pyx_GetItemInt(__pyx_8, 2); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1317; goto __pyx_L1;}
      Py_DECREF(__pyx_8); __pyx_8 = 0;
      __pyx_6 = PyTuple_New(1); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1318; goto __pyx_L1;}
      Py_INCREF(__pyx_v_path);
      PyTuple_SET_ITEM(__pyx_6, 0, __pyx_v_path);
      __pyx_10 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_6); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1318; goto __pyx_L1;}
      Py_DECREF(__pyx_6); __pyx_6 = 0;
      __pyx_11 = __Pyx_GetItemInt(__pyx_10, 0); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1318; goto __pyx_L1;}
      Py_DECREF(__pyx_10); __pyx_10 = 0;
      __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1318; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_1, 0, Py_None);
      PyTuple_SET_ITEM(__pyx_1, 1, __pyx_11);
      __pyx_11 = 0;
      __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1320; goto __pyx_L1;}
      Py_INCREF(Py_False);
      PyTuple_SET_ITEM(__pyx_4, 0, Py_False);
      Py_INCREF(Py_True);
      PyTuple_SET_ITEM(__pyx_4, 1, Py_True);
      __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1321; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_3, 0, Py_None);
      Py_INCREF(__pyx_v_parent_id);
      PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_parent_id);
      __pyx_7 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1322; goto __pyx_L1;}
      __pyx_8 = __Pyx_GetItemInt(__pyx_7, 1); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1322; goto __pyx_L1;}
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      __pyx_6 = PyTuple_New(1); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1322; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_6, 0, __pyx_8);
      __pyx_8 = 0;
      __pyx_10 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_6); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1322; goto __pyx_L1;}
      Py_DECREF(__pyx_6); __pyx_6 = 0;
      __pyx_11 = __Pyx_GetItemInt(__pyx_10, 0); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1322; goto __pyx_L1;}
      Py_DECREF(__pyx_10); __pyx_10 = 0;
      __pyx_7 = PyTuple_New(2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1322; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_7, 0, Py_None);
      PyTuple_SET_ITEM(__pyx_7, 1, __pyx_11);
      __pyx_11 = 0;
      __pyx_8 = PyTuple_New(2); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1323; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_8, 0, Py_None);
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_8, 1, Py_None);
      __pyx_6 = PyTuple_New(2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1324; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_6, 0, Py_None);
      Py_INCREF(Py_False);
      PyTuple_SET_ITEM(__pyx_6, 1, Py_False);
      __pyx_10 = PyTuple_New(8); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1317; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_10, 0, __pyx_9);
      PyTuple_SET_ITEM(__pyx_10, 1, __pyx_1);
      Py_INCREF(Py_False);
      PyTuple_SET_ITEM(__pyx_10, 2, Py_False);
      PyTuple_SET_ITEM(__pyx_10, 3, __pyx_4);
      PyTuple_SET_ITEM(__pyx_10, 4, __pyx_3);
      PyTuple_SET_ITEM(__pyx_10, 5, __pyx_7);
      PyTuple_SET_ITEM(__pyx_10, 6, __pyx_8);
      PyTuple_SET_ITEM(__pyx_10, 7, __pyx_6);
      __pyx_9 = 0;
      __pyx_1 = 0;
      __pyx_4 = 0;
      __pyx_3 = 0;
      __pyx_7 = 0;
      __pyx_8 = 0;
      __pyx_6 = 0;
      __pyx_11 = PyTuple_New(2); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1317; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_11, 0, __pyx_10);
      Py_INCREF(Py_True);
      PyTuple_SET_ITEM(__pyx_11, 1, Py_True);
      __pyx_10 = 0;
      __pyx_r = __pyx_11;
      __pyx_11 = 0;
      goto __pyx_L0;
    }
    __pyx_L35:;
    goto __pyx_L5;
  }
  __pyx_5 = __pyx_f_21_dirstate_helpers_pyx__versioned_minikind(__pyx_v_source_minikind);
  if (__pyx_5) {
    __pyx_5 = (__pyx_v_target_minikind == 'a');
  }
  if (__pyx_5) {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1330 */
    __pyx_9 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1330; goto __pyx_L1;}
    __pyx_1 = __Pyx_GetItemInt(__pyx_9, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1330; goto __pyx_L1;}
    Py_DECREF(__pyx_9); __pyx_9 = 0;
    __pyx_4 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1330; goto __pyx_L1;}
    __pyx_3 = __Pyx_GetItemInt(__pyx_4, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1330; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_7 = PyTuple_New(2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1330; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_7, 0, __pyx_1);
    PyTuple_SET_ITEM(__pyx_7, 1, __pyx_3);
    __pyx_1 = 0;
    __pyx_3 = 0;
    __pyx_8 = PyObject_CallObject(__pyx_v_self->pathjoin, __pyx_7); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1330; goto __pyx_L1;}
    Py_DECREF(__pyx_7); __pyx_7 = 0;
    Py_DECREF(__pyx_v_old_path);
    __pyx_v_old_path = __pyx_8;
    __pyx_8 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1332 */
    __pyx_6 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__get_entry); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1332; goto __pyx_L1;}
    __pyx_10 = PyInt_FromLong(__pyx_v_self->source_index); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1332; goto __pyx_L1;}
    __pyx_11 = PyTuple_New(1); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1332; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_11, 0, __pyx_10);
    __pyx_10 = 0;
    __pyx_9 = PyDict_New(); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1332; goto __pyx_L1;}
    __pyx_4 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1332; goto __pyx_L1;}
    __pyx_1 = __Pyx_GetItemInt(__pyx_4, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1332; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    if (PyDict_SetItem(__pyx_9, __pyx_n_path_utf8, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1332; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_3 = PyEval_CallObjectWithKeywords(__pyx_6, __pyx_11, __pyx_9); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1332; goto __pyx_L1;}
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    Py_DECREF(__pyx_11); __pyx_11 = 0;
    Py_DECREF(__pyx_9); __pyx_9 = 0;
    __pyx_7 = __Pyx_GetItemInt(__pyx_3, 0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1332; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_8 = __Pyx_GetItemInt(__pyx_7, 2); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1332; goto __pyx_L1;}
    Py_DECREF(__pyx_7); __pyx_7 = 0;
    Py_DECREF(__pyx_v_parent_id);
    __pyx_v_parent_id = __pyx_8;
    __pyx_8 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1333 */
    __pyx_10 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1333; goto __pyx_L1;}
    __pyx_4 = __Pyx_GetItemInt(__pyx_10, 2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1333; goto __pyx_L1;}
    Py_DECREF(__pyx_10); __pyx_10 = 0;
    if (PyObject_Cmp(__pyx_v_parent_id, __pyx_4, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1333; goto __pyx_L1;}
    __pyx_2 = __pyx_2 == 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    if (__pyx_2) {
      Py_INCREF(Py_None);
      Py_DECREF(__pyx_v_parent_id);
      __pyx_v_parent_id = Py_None;
      goto __pyx_L37;
    }
    __pyx_L37:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1335 */
    __pyx_1 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1335; goto __pyx_L1;}
    __pyx_6 = __Pyx_GetItemInt(__pyx_1, 2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1335; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_11 = PyTuple_New(1); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1336; goto __pyx_L1;}
    Py_INCREF(__pyx_v_old_path);
    PyTuple_SET_ITEM(__pyx_11, 0, __pyx_v_old_path);
    __pyx_9 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_11); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1336; goto __pyx_L1;}
    Py_DECREF(__pyx_11); __pyx_11 = 0;
    __pyx_3 = __Pyx_GetItemInt(__pyx_9, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1336; goto __pyx_L1;}
    Py_DECREF(__pyx_9); __pyx_9 = 0;
    __pyx_7 = PyTuple_New(2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1336; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_7, 0, __pyx_3);
    Py_INCREF(Py_None);
    PyTuple_SET_ITEM(__pyx_7, 1, Py_None);
    __pyx_3 = 0;
    __pyx_8 = PyTuple_New(2); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1338; goto __pyx_L1;}
    Py_INCREF(Py_True);
    PyTuple_SET_ITEM(__pyx_8, 0, Py_True);
    Py_INCREF(Py_False);
    PyTuple_SET_ITEM(__pyx_8, 1, Py_False);
    __pyx_10 = PyTuple_New(2); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1339; goto __pyx_L1;}
    Py_INCREF(__pyx_v_parent_id);
    PyTuple_SET_ITEM(__pyx_10, 0, __pyx_v_parent_id);
    Py_INCREF(Py_None);
    PyTuple_SET_ITEM(__pyx_10, 1, Py_None);
    __pyx_4 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1340; goto __pyx_L1;}
    __pyx_1 = __Pyx_GetItemInt(__pyx_4, 1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1340; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_11 = PyTuple_New(1); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1340; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_11, 0, __pyx_1);
    __pyx_1 = 0;
    __pyx_9 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_11); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1340; goto __pyx_L1;}
    Py_DECREF(__pyx_11); __pyx_11 = 0;
    __pyx_3 = __Pyx_GetItemInt(__pyx_9, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1340; goto __pyx_L1;}
    Py_DECREF(__pyx_9); __pyx_9 = 0;
    __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1340; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_3);
    Py_INCREF(Py_None);
    PyTuple_SET_ITEM(__pyx_4, 1, Py_None);
    __pyx_3 = 0;
    __pyx_1 = __pyx_f_21_dirstate_helpers_pyx__minikind_to_kind(__pyx_v_source_minikind); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1341; goto __pyx_L1;}
    __pyx_11 = PyTuple_New(2); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1341; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_11, 0, __pyx_1);
    Py_INCREF(Py_None);
    PyTuple_SET_ITEM(__pyx_11, 1, Py_None);
    __pyx_1 = 0;
    __pyx_9 = __Pyx_GetItemInt(__pyx_v_source_details, 3); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1342; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1342; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_9);
    Py_INCREF(Py_None);
    PyTuple_SET_ITEM(__pyx_3, 1, Py_None);
    __pyx_9 = 0;
    __pyx_1 = PyTuple_New(8); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1335; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_1, 0, __pyx_6);
    PyTuple_SET_ITEM(__pyx_1, 1, __pyx_7);
    Py_INCREF(Py_True);
    PyTuple_SET_ITEM(__pyx_1, 2, Py_True);
    PyTuple_SET_ITEM(__pyx_1, 3, __pyx_8);
    PyTuple_SET_ITEM(__pyx_1, 4, __pyx_10);
    PyTuple_SET_ITEM(__pyx_1, 5, __pyx_4);
    PyTuple_SET_ITEM(__pyx_1, 6, __pyx_11);
    PyTuple_SET_ITEM(__pyx_1, 7, __pyx_3);
    __pyx_6 = 0;
    __pyx_7 = 0;
    __pyx_8 = 0;
    __pyx_10 = 0;
    __pyx_4 = 0;
    __pyx_11 = 0;
    __pyx_3 = 0;
    __pyx_9 = PyTuple_New(2); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1335; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_9, 0, __pyx_1);
    Py_INCREF(Py_True);
    PyTuple_SET_ITEM(__pyx_9, 1, Py_True);
    __pyx_1 = 0;
    __pyx_r = __pyx_9;
    __pyx_9 = 0;
    goto __pyx_L0;
    goto __pyx_L5;
  }
  __pyx_5 = __pyx_f_21_dirstate_helpers_pyx__versioned_minikind(__pyx_v_source_minikind);
  if (__pyx_5) {
    __pyx_5 = (__pyx_v_target_minikind == 'r');
  }
  if (__pyx_5) {
    __pyx_2 = (!__pyx_v_self->doing_consistency_expansion);
    if (__pyx_2) {
      __pyx_6 = __Pyx_GetName(__pyx_m, __pyx_n_osutils); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1349; goto __pyx_L1;}
      __pyx_7 = PyObject_GetAttr(__pyx_6, __pyx_n_is_inside_any); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1349; goto __pyx_L1;}
      Py_DECREF(__pyx_6); __pyx_6 = 0;
      __pyx_8 = __Pyx_GetItemInt(__pyx_v_target_details, 1); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1350; goto __pyx_L1;}
      __pyx_10 = PyTuple_New(2); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1349; goto __pyx_L1;}
      Py_INCREF(__pyx_v_self->searched_specific_files);
      PyTuple_SET_ITEM(__pyx_10, 0, __pyx_v_self->searched_specific_files);
      PyTuple_SET_ITEM(__pyx_10, 1, __pyx_8);
      __pyx_8 = 0;
      __pyx_4 = PyObject_CallObject(__pyx_7, __pyx_10); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1349; goto __pyx_L1;}
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      Py_DECREF(__pyx_10); __pyx_10 = 0;
      __pyx_5 = PyObject_IsTrue(__pyx_4); if (__pyx_5 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1349; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      __pyx_2 = (!__pyx_5);
    }
    if (__pyx_2) {
      __pyx_11 = PyObject_GetAttr(__pyx_v_self->search_specific_files, __pyx_n_add); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1351; goto __pyx_L1;}
      __pyx_3 = __Pyx_GetItemInt(__pyx_v_target_details, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1351; goto __pyx_L1;}
      __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1351; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_1, 0, __pyx_3);
      __pyx_3 = 0;
      __pyx_9 = PyObject_CallObject(__pyx_11, __pyx_1); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1351; goto __pyx_L1;}
      Py_DECREF(__pyx_11); __pyx_11 = 0;
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(__pyx_9); __pyx_9 = 0;
      goto __pyx_L38;
    }
    __pyx_L38:;
    goto __pyx_L5;
  }
  __pyx_5 = (__pyx_v_source_minikind == 'r');
  if (!__pyx_5) {
    __pyx_5 = (__pyx_v_source_minikind == 'a');
  }
  if (__pyx_5) {
    __pyx_5 = (__pyx_v_target_minikind == 'r');
    if (!__pyx_5) {
      __pyx_5 = (__pyx_v_target_minikind == 'a');
    }
  }
  if (__pyx_5) {
    goto __pyx_L5;
  }
  /*else*/ {
    __pyx_6 = PyInt_FromLong(__pyx_v_source_minikind); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1364; goto __pyx_L1;}
    __pyx_8 = PyInt_FromLong(__pyx_v_target_minikind); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1364; goto __pyx_L1;}
    __pyx_7 = PyTuple_New(2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1364; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_7, 0, __pyx_6);
    PyTuple_SET_ITEM(__pyx_7, 1, __pyx_8);
    __pyx_6 = 0;
    __pyx_8 = 0;
    __pyx_10 = PyNumber_Remainder(__pyx_k76p, __pyx_7); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1364; goto __pyx_L1;}
    Py_DECREF(__pyx_7); __pyx_7 = 0;
    __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1362; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_10);
    __pyx_10 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_AssertionError, __pyx_4); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1362; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1362; goto __pyx_L1;}
  }
  __pyx_L5:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1366 */
  __pyx_11 = PyTuple_New(2); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1366; goto __pyx_L1;}
  Py_INCREF(Py_None);
  PyTuple_SET_ITEM(__pyx_11, 0, Py_None);
  Py_INCREF(Py_None);
  PyTuple_SET_ITEM(__pyx_11, 1, Py_None);
  __pyx_r = __pyx_11;
  __pyx_11 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_6);
  Py_XDECREF(__pyx_7);
  Py_XDECREF(__pyx_8);
  Py_XDECREF(__pyx_9);
  Py_XDECREF(__pyx_10);
  Py_XDECREF(__pyx_11);
  __Pyx_AddTraceback("_dirstate_helpers_pyx.ProcessEntryC._process_entry");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_file_id);
  Py_DECREF(__pyx_v_details_list);
  Py_DECREF(__pyx_v_source_details);
  Py_DECREF(__pyx_v_target_details);
  Py_DECREF(__pyx_v_link_or_sha1);
  Py_DECREF(__pyx_v_old_dirname);
  Py_DECREF(__pyx_v_old_basename);
  Py_DECREF(__pyx_v_old_path);
  Py_DECREF(__pyx_v_path);
  Py_DECREF(__pyx_v_old_entry);
  Py_DECREF(__pyx_v_target_kind);
  Py_DECREF(__pyx_v_target_exec);
  Py_DECREF(__pyx_v_statvalue);
  Py_DECREF(__pyx_v_source_parent_id);
  Py_DECREF(__pyx_v_source_parent_entry);
  Py_DECREF(__pyx_v_new_dirname);
  Py_DECREF(__pyx_v_target_parent_id);
  Py_DECREF(__pyx_v_target_parent_entry);
  Py_DECREF(__pyx_v_source_exec);
  Py_DECREF(__pyx_v_changed);
  Py_DECREF(__pyx_v_old_path_u);
  Py_DECREF(__pyx_v_path_u);
  Py_DECREF(__pyx_v_source_kind);
  Py_DECREF(__pyx_v_parent_entry);
  Py_DECREF(__pyx_v_parent_id);
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_entry);
  Py_DECREF(__pyx_v_path_info);
  return __pyx_r;
}

static PyObject *__pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC___iter__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC___iter__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_self);
  __pyx_r = __pyx_v_self;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC_iter_changes(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static PyObject *__pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC_iter_changes(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_r;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_self);
  __pyx_r = __pyx_v_self;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_n_update;
static PyObject *__pyx_n_encode;
static PyObject *__pyx_n_utf8;

static PyObject *__pyx_k78p;

static char __pyx_k78[] = "";

static void __pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC__gather_result_for_consistency(struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *__pyx_v_self,PyObject *__pyx_v_result) {
  PyObject *__pyx_v_new_path;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  int __pyx_3;
  PyObject *__pyx_4 = 0;
  PyObject *__pyx_5 = 0;
  PyObject *__pyx_6 = 0;
  PyObject *__pyx_7 = 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_result);
  __pyx_v_new_path = Py_None; Py_INCREF(Py_None);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1381 */
  __pyx_1 = (!__pyx_v_self->partial);
  if (!__pyx_1) {
    __pyx_2 = __Pyx_GetItemInt(__pyx_v_result, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1381; goto __pyx_L1;}
    __pyx_3 = PyObject_IsTrue(__pyx_2); if (__pyx_3 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1381; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_1 = (!__pyx_3);
  }
  if (__pyx_1) {
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1383 */
  __pyx_2 = PyObject_GetAttr(__pyx_v_self->seen_ids, __pyx_n_add); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1383; goto __pyx_L1;}
  __pyx_4 = __Pyx_GetItemInt(__pyx_v_result, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1383; goto __pyx_L1;}
  __pyx_5 = PyTuple_New(1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1383; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_5, 0, __pyx_4);
  __pyx_4 = 0;
  __pyx_4 = PyObject_CallObject(__pyx_2, __pyx_5); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1383; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_5); __pyx_5 = 0;
  Py_DECREF(__pyx_4); __pyx_4 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1384 */
  __pyx_2 = __Pyx_GetItemInt(__pyx_v_result, 1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1384; goto __pyx_L1;}
  __pyx_5 = __Pyx_GetItemInt(__pyx_2, 1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1384; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_v_new_path);
  __pyx_v_new_path = __pyx_5;
  __pyx_5 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1385 */
  __pyx_3 = PyObject_IsTrue(__pyx_v_new_path); if (__pyx_3 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1385; goto __pyx_L1;}
  if (__pyx_3) {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1387 */
    __pyx_4 = PyObject_GetAttr(__pyx_v_self->search_specific_file_parents, __pyx_n_update); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1387; goto __pyx_L1;}
    __pyx_2 = __Pyx_GetName(__pyx_m, __pyx_n_osutils); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1388; goto __pyx_L1;}
    __pyx_5 = PyObject_GetAttr(__pyx_2, __pyx_n_parent_directories); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1388; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyObject_GetAttr(__pyx_v_new_path, __pyx_n_encode); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1388; goto __pyx_L1;}
    __pyx_6 = PyTuple_New(1); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1388; goto __pyx_L1;}
    Py_INCREF(__pyx_n_utf8);
    PyTuple_SET_ITEM(__pyx_6, 0, __pyx_n_utf8);
    __pyx_7 = PyObject_CallObject(__pyx_2, __pyx_6); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1388; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1388; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_7);
    __pyx_7 = 0;
    __pyx_6 = PyObject_CallObject(__pyx_5, __pyx_2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1388; goto __pyx_L1;}
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_7 = PyTuple_New(1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1387; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_7, 0, __pyx_6);
    __pyx_6 = 0;
    __pyx_5 = PyObject_CallObject(__pyx_4, __pyx_7); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1387; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_7); __pyx_7 = 0;
    Py_DECREF(__pyx_5); __pyx_5 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1391 */
    __pyx_2 = PyObject_GetAttr(__pyx_v_self->search_specific_file_parents, __pyx_n_add); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1391; goto __pyx_L1;}
    __pyx_6 = PyTuple_New(1); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1391; goto __pyx_L1;}
    Py_INCREF(__pyx_k78p);
    PyTuple_SET_ITEM(__pyx_6, 0, __pyx_k78p);
    __pyx_4 = PyObject_CallObject(__pyx_2, __pyx_6); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1391; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    goto __pyx_L3;
  }
  __pyx_L3:;

  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_5);
  Py_XDECREF(__pyx_6);
  Py_XDECREF(__pyx_7);
  __Pyx_WriteUnraisable("_dirstate_helpers_pyx.ProcessEntryC._gather_result_for_consistency");
  __pyx_L0:;
  Py_DECREF(__pyx_v_new_path);
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_result);
}

static PyObject *__pyx_n_is_inside;

static void __pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC__update_current_block(struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *__pyx_v_self) {
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  Py_ssize_t __pyx_3;
  int __pyx_4;
  PyObject *__pyx_5 = 0;
  PyObject *__pyx_6 = 0;
  Py_INCREF(__pyx_v_self);
  __pyx_2 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__dirblocks); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1394; goto __pyx_L1;}
  __pyx_3 = PyObject_Length(__pyx_2); if (__pyx_3 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1394; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_1 = PyInt_FromLong((__pyx_v_self->block_index < __pyx_3)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1394; goto __pyx_L1;}
  __pyx_4 = PyObject_IsTrue(__pyx_1); if (__pyx_4 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1394; goto __pyx_L1;}
  if (__pyx_4) {
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_2 = __Pyx_GetName(__pyx_m, __pyx_n_osutils); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1395; goto __pyx_L1;}
    __pyx_5 = PyObject_GetAttr(__pyx_2, __pyx_n_is_inside); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1395; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__dirblocks); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1395; goto __pyx_L1;}
    __pyx_6 = __Pyx_GetItemInt(__pyx_2, __pyx_v_self->block_index); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1395; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = __Pyx_GetItemInt(__pyx_6, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1395; goto __pyx_L1;}
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    __pyx_6 = PyTuple_New(2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1395; goto __pyx_L1;}
    Py_INCREF(__pyx_v_self->current_root);
    PyTuple_SET_ITEM(__pyx_6, 0, __pyx_v_self->current_root);
    PyTuple_SET_ITEM(__pyx_6, 1, __pyx_2);
    __pyx_2 = 0;
    __pyx_1 = PyObject_CallObject(__pyx_5, __pyx_6); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1395; goto __pyx_L1;}
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    Py_DECREF(__pyx_6); __pyx_6 = 0;
  }
  __pyx_4 = PyObject_IsTrue(__pyx_1); if (__pyx_4 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1394; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  if (__pyx_4) {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1396 */
    __pyx_2 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__dirblocks); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1396; goto __pyx_L1;}
    __pyx_5 = __Pyx_GetItemInt(__pyx_2, __pyx_v_self->block_index); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1396; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_v_self->current_block);
    __pyx_v_self->current_block = __pyx_5;
    __pyx_5 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1397 */
    __pyx_6 = __Pyx_GetItemInt(__pyx_v_self->current_block, 1); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1397; goto __pyx_L1;}
    Py_DECREF(__pyx_v_self->current_block_list);
    __pyx_v_self->current_block_list = __pyx_6;
    __pyx_6 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1398 */
    __pyx_v_self->current_block_pos = 0;
    goto __pyx_L2;
  }
  /*else*/ {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1400 */
    Py_INCREF(Py_None);
    Py_DECREF(__pyx_v_self->current_block);
    __pyx_v_self->current_block = Py_None;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1401 */
    Py_INCREF(Py_None);
    Py_DECREF(__pyx_v_self->current_block_list);
    __pyx_v_self->current_block_list = Py_None;
  }
  __pyx_L2:;

  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_5);
  Py_XDECREF(__pyx_6);
  __Pyx_WriteUnraisable("_dirstate_helpers_pyx.ProcessEntryC._update_current_block");
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
}

static PyObject *__pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC___next__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC___next__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  Py_INCREF(__pyx_v_self);
  __pyx_1 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *)((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)->__pyx_vtab)->_iter_next(((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1405; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("_dirstate_helpers_pyx.ProcessEntryC.__next__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_n_pop;
static PyObject *__pyx_n__entries_for_path;
static PyObject *__pyx_n_decode;
static PyObject *__pyx_n_abspath;
static PyObject *__pyx_n_lstat;
static PyObject *__pyx_n_ENOENT;
static PyObject *__pyx_n_file_kind_from_stat_mode;
static PyObject *__pyx_n__directory_is_tree_reference;
static PyObject *__pyx_n_S_ISREG;
static PyObject *__pyx_n_S_IEXEC;
static PyObject *__pyx_n__walkdirs_utf8;
static PyObject *__pyx_n_prefix;
static PyObject *__pyx_n_next;
static PyObject *__pyx_n_ENOTDIR;
static PyObject *__pyx_n_EINVAL;
static PyObject *__pyx_n_platform;
static PyObject *__pyx_n_win32;
static PyObject *__pyx_n_winerror;
static PyObject *__pyx_n_AttributeError;
static PyObject *__pyx_n__find_block_index_from_key;

static PyObject *__pyx_k80p;
static PyObject *__pyx_k82p;
static PyObject *__pyx_k83p;
static PyObject *__pyx_k86p;
static PyObject *__pyx_k87p;
static PyObject *__pyx_k88p;
static PyObject *__pyx_k89p;
static PyObject *__pyx_k90p;
static PyObject *__pyx_k92p;
static PyObject *__pyx_k94p;

static char __pyx_k80[] = "";
static char __pyx_k82[] = "tree-reference";
static char __pyx_k83[] = "tree-reference";
static char __pyx_k86[] = "";
static char __pyx_k87[] = ".bzr";
static char __pyx_k88[] = ".bzr";
static char __pyx_k89[] = "";
static char __pyx_k90[] = "";
static char __pyx_k92[] = "tree-reference";
static char __pyx_k94[] = "tree-reference";

static PyObject *__pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC__iter_next(struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *__pyx_v_self) {
  PyObject *__pyx_v_current_dirname;
  PyObject *__pyx_v_current_blockname;
  char *__pyx_v_current_dirname_c;
  char *__pyx_v_current_blockname_c;
  int __pyx_v_path_handled;
  PyObject *__pyx_v_searched_specific_files;
  PyObject *__pyx_v_entry;
  PyObject *__pyx_v_result;
  PyObject *__pyx_v_changed;
  PyObject *__pyx_v_root_stat;
  PyObject *__pyx_v_e;
  PyObject *__pyx_v_new_executable;
  PyObject *__pyx_v_e_winerror;
  PyObject *__pyx_v_win_errors;
  PyObject *__pyx_v_bzr_index;
  PyObject *__pyx_v_initial_key;
  PyObject *__pyx_v__;
  PyObject *__pyx_v_current_path_info;
  PyObject *__pyx_v_current_entry;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  PyObject *__pyx_5 = 0;
  Py_ssize_t __pyx_6;
  PyObject *__pyx_7 = 0;
  PyObject *__pyx_8 = 0;
  int __pyx_9;
  PyObject *__pyx_10 = 0;
  PyObject *__pyx_11 = 0;
  Py_INCREF(__pyx_v_self);
  __pyx_v_current_dirname = Py_None; Py_INCREF(Py_None);
  __pyx_v_current_blockname = Py_None; Py_INCREF(Py_None);
  __pyx_v_searched_specific_files = Py_None; Py_INCREF(Py_None);
  __pyx_v_entry = Py_None; Py_INCREF(Py_None);
  __pyx_v_result = Py_None; Py_INCREF(Py_None);
  __pyx_v_changed = Py_None; Py_INCREF(Py_None);
  __pyx_v_root_stat = Py_None; Py_INCREF(Py_None);
  __pyx_v_e = Py_None; Py_INCREF(Py_None);
  __pyx_v_new_executable = Py_None; Py_INCREF(Py_None);
  __pyx_v_e_winerror = Py_None; Py_INCREF(Py_None);
  __pyx_v_win_errors = Py_None; Py_INCREF(Py_None);
  __pyx_v_bzr_index = Py_None; Py_INCREF(Py_None);
  __pyx_v_initial_key = Py_None; Py_INCREF(Py_None);
  __pyx_v__ = Py_None; Py_INCREF(Py_None);
  __pyx_v_current_path_info = Py_None; Py_INCREF(Py_None);
  __pyx_v_current_entry = Py_None; Py_INCREF(Py_None);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1459 */
  Py_INCREF(__pyx_v_self->searched_specific_files);
  Py_DECREF(__pyx_v_searched_specific_files);
  __pyx_v_searched_specific_files = __pyx_v_self->searched_specific_files;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1461 */
  while (1) {
    __pyx_1 = (__pyx_v_self->root_entries_pos < __pyx_v_self->root_entries_len);
    if (!__pyx_1) break;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1462 */
    __pyx_2 = __Pyx_GetItemInt(__pyx_v_self->root_entries, __pyx_v_self->root_entries_pos); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1462; goto __pyx_L1;}
    Py_DECREF(__pyx_v_entry);
    __pyx_v_entry = __pyx_2;
    __pyx_2 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1463 */
    __pyx_v_self->root_entries_pos = (__pyx_v_self->root_entries_pos + 1);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1464 */
    __pyx_2 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_process_entry(__pyx_v_self,__pyx_v_entry,__pyx_v_self->root_dir_info); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1464; goto __pyx_L1;}
    __pyx_3 = PyObject_GetIter(__pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1464; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = __Pyx_UnpackItem(__pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1464; goto __pyx_L1;}
    Py_DECREF(__pyx_v_result);
    __pyx_v_result = __pyx_2;
    __pyx_2 = 0;
    __pyx_2 = __Pyx_UnpackItem(__pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1464; goto __pyx_L1;}
    Py_DECREF(__pyx_v_changed);
    __pyx_v_changed = __pyx_2;
    __pyx_2 = 0;
    if (__Pyx_EndUnpack(__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1464; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1465 */
    __pyx_1 = __pyx_v_changed != Py_None;
    if (__pyx_1) {

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1466 */
      __pyx_1 = PyObject_IsTrue(__pyx_v_changed); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1466; goto __pyx_L1;}
      if (__pyx_1) {
        ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_gather_result_for_consistency(__pyx_v_self,__pyx_v_result);
        goto __pyx_L5;
      }
      __pyx_L5:;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1468 */
      __pyx_2 = __pyx_v_changed;
      Py_INCREF(__pyx_2);
      __pyx_1 = PyObject_IsTrue(__pyx_2); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1468; goto __pyx_L1;}
      if (!__pyx_1) {
        Py_DECREF(__pyx_2); __pyx_2 = 0;
        __pyx_2 = PyInt_FromLong(__pyx_v_self->include_unchanged); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1468; goto __pyx_L1;}
      }
      __pyx_1 = PyObject_IsTrue(__pyx_2); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1468; goto __pyx_L1;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      if (__pyx_1) {
        Py_INCREF(__pyx_v_result);
        __pyx_r = __pyx_v_result;
        goto __pyx_L0;
        goto __pyx_L6;
      }
      __pyx_L6:;
      goto __pyx_L4;
    }
    __pyx_L4:;
  }

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1471 */
  __pyx_1 = __pyx_v_self->current_root == Py_None;
  if (__pyx_1) {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1474 */
    /*try:*/ {
      __pyx_3 = PyObject_GetAttr(__pyx_v_self->search_specific_files, __pyx_n_pop); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1475; goto __pyx_L8;}
      __pyx_2 = PyObject_CallObject(__pyx_3, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1475; goto __pyx_L8;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_v_self->current_root);
      __pyx_v_self->current_root = __pyx_2;
      __pyx_2 = 0;
    }
    goto __pyx_L9;
    __pyx_L8:;
    Py_XDECREF(__pyx_3); __pyx_3 = 0;
    Py_XDECREF(__pyx_2); __pyx_2 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1476 */
    __pyx_1 = PyErr_ExceptionMatches(PyExc_KeyError);
    if (__pyx_1) {
      __Pyx_AddTraceback("_dirstate_helpers_pyx._iter_next");
      if (__Pyx_GetException(&__pyx_3, &__pyx_2, &__pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1476; goto __pyx_L1;}
      __pyx_5 = PyObject_CallObject(PyExc_StopIteration, 0); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1477; goto __pyx_L1;}
      __Pyx_Raise(__pyx_5, 0, 0);
      Py_DECREF(__pyx_5); __pyx_5 = 0;
      {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1477; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      goto __pyx_L9;
    }
    goto __pyx_L1;
    __pyx_L9:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1478 */
    __pyx_5 = PyObject_GetAttr(__pyx_v_self->searched_specific_files, __pyx_n_add); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1478; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1478; goto __pyx_L1;}
    Py_INCREF(__pyx_v_self->current_root);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_self->current_root);
    __pyx_2 = PyObject_CallObject(__pyx_5, __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1478; goto __pyx_L1;}
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1481 */
    __pyx_4 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__entries_for_path); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1481; goto __pyx_L1;}
    __pyx_5 = PyTuple_New(1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1481; goto __pyx_L1;}
    Py_INCREF(__pyx_v_self->current_root);
    PyTuple_SET_ITEM(__pyx_5, 0, __pyx_v_self->current_root);
    __pyx_3 = PyObject_CallObject(__pyx_4, __pyx_5); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1481; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    Py_DECREF(__pyx_v_self->root_entries);
    __pyx_v_self->root_entries = __pyx_3;
    __pyx_3 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1482 */
    __pyx_6 = PyObject_Length(__pyx_v_self->root_entries); if (__pyx_6 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1482; goto __pyx_L1;}
    __pyx_v_self->root_entries_len = __pyx_6;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1483 */
    __pyx_2 = PyObject_GetAttr(__pyx_v_self->current_root, __pyx_n_decode); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1483; goto __pyx_L1;}
    __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1483; goto __pyx_L1;}
    Py_INCREF(__pyx_n_utf8);
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_n_utf8);
    __pyx_5 = PyObject_CallObject(__pyx_2, __pyx_4); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1483; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_v_self->current_root_unicode);
    __pyx_v_self->current_root_unicode = __pyx_5;
    __pyx_5 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1484 */
    __pyx_3 = PyObject_GetAttr(__pyx_v_self->tree, __pyx_n_abspath); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1484; goto __pyx_L1;}
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1484; goto __pyx_L1;}
    Py_INCREF(__pyx_v_self->current_root_unicode);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self->current_root_unicode);
    __pyx_4 = PyObject_CallObject(__pyx_3, __pyx_2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1484; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_v_self->root_abspath);
    __pyx_v_self->root_abspath = __pyx_4;
    __pyx_4 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1485 */
    /*try:*/ {
      __pyx_5 = __Pyx_GetName(__pyx_m, __pyx_n_os); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1486; goto __pyx_L10;}
      __pyx_3 = PyObject_GetAttr(__pyx_5, __pyx_n_lstat); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1486; goto __pyx_L10;}
      Py_DECREF(__pyx_5); __pyx_5 = 0;
      __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1486; goto __pyx_L10;}
      Py_INCREF(__pyx_v_self->root_abspath);
      PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self->root_abspath);
      __pyx_4 = PyObject_CallObject(__pyx_3, __pyx_2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1486; goto __pyx_L10;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      Py_DECREF(__pyx_v_root_stat);
      __pyx_v_root_stat = __pyx_4;
      __pyx_4 = 0;
    }
    /*else:*/ {

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1495 */
      __pyx_7 = __Pyx_GetName(__pyx_m, __pyx_n_osutils); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1496; goto __pyx_L1;}
      __pyx_4 = PyObject_GetAttr(__pyx_7, __pyx_n_file_kind_from_stat_mode); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1496; goto __pyx_L1;}
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      __pyx_8 = PyObject_GetAttr(__pyx_v_root_stat, __pyx_n_st_mode); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1496; goto __pyx_L1;}
      __pyx_5 = PyTuple_New(1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1496; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_5, 0, __pyx_8);
      __pyx_8 = 0;
      __pyx_3 = PyObject_CallObject(__pyx_4, __pyx_5); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1496; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_5); __pyx_5 = 0;
      __pyx_2 = PyTuple_New(5); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1495; goto __pyx_L1;}
      Py_INCREF(__pyx_k80p);
      PyTuple_SET_ITEM(__pyx_2, 0, __pyx_k80p);
      Py_INCREF(__pyx_v_self->current_root);
      PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_self->current_root);
      PyTuple_SET_ITEM(__pyx_2, 2, __pyx_3);
      Py_INCREF(__pyx_v_root_stat);
      PyTuple_SET_ITEM(__pyx_2, 3, __pyx_v_root_stat);
      Py_INCREF(__pyx_v_self->root_abspath);
      PyTuple_SET_ITEM(__pyx_2, 4, __pyx_v_self->root_abspath);
      __pyx_3 = 0;
      Py_DECREF(__pyx_v_self->root_dir_info);
      __pyx_v_self->root_dir_info = __pyx_2;
      __pyx_2 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1498 */
      __pyx_7 = __Pyx_GetItemInt(__pyx_v_self->root_dir_info, 2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1498; goto __pyx_L1;}
      if (PyObject_Cmp(__pyx_7, __pyx_n_directory, &__pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1498; goto __pyx_L1;}
      __pyx_1 = __pyx_1 == 0;
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      if (__pyx_1) {
        __pyx_8 = PyObject_GetAttr(__pyx_v_self->tree, __pyx_n__directory_is_tree_reference); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1499; goto __pyx_L1;}
        __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1499; goto __pyx_L1;}
        Py_INCREF(__pyx_v_self->current_root_unicode);
        PyTuple_SET_ITEM(__pyx_4, 0, __pyx_v_self->current_root_unicode);
        __pyx_5 = PyObject_CallObject(__pyx_8, __pyx_4); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1499; goto __pyx_L1;}
        Py_DECREF(__pyx_8); __pyx_8 = 0;
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        __pyx_1 = PyObject_IsTrue(__pyx_5); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1499; goto __pyx_L1;}
        Py_DECREF(__pyx_5); __pyx_5 = 0;
        if (__pyx_1) {
          __pyx_3 = PySequence_GetSlice(__pyx_v_self->root_dir_info, 0, 2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1501; goto __pyx_L1;}
          __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1502; goto __pyx_L1;}
          Py_INCREF(__pyx_k82p);
          PyTuple_SET_ITEM(__pyx_2, 0, __pyx_k82p);
          __pyx_7 = PyNumber_Add(__pyx_3, __pyx_2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1501; goto __pyx_L1;}
          Py_DECREF(__pyx_3); __pyx_3 = 0;
          Py_DECREF(__pyx_2); __pyx_2 = 0;
          __pyx_8 = PySequence_GetSlice(__pyx_v_self->root_dir_info, 3, PY_SSIZE_T_MAX); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1502; goto __pyx_L1;}
          __pyx_4 = PyNumber_Add(__pyx_7, __pyx_8); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1502; goto __pyx_L1;}
          Py_DECREF(__pyx_7); __pyx_7 = 0;
          Py_DECREF(__pyx_8); __pyx_8 = 0;
          Py_DECREF(__pyx_v_self->root_dir_info);
          __pyx_v_self->root_dir_info = __pyx_4;
          __pyx_4 = 0;
          goto __pyx_L13;
        }
        __pyx_L13:;
        goto __pyx_L12;
      }
      __pyx_L12:;
    }
    goto __pyx_L11;
    __pyx_L10:;
    Py_XDECREF(__pyx_5); __pyx_5 = 0;
    Py_XDECREF(__pyx_3); __pyx_3 = 0;
    Py_XDECREF(__pyx_2); __pyx_2 = 0;
    Py_XDECREF(__pyx_4); __pyx_4 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1487 */
    __pyx_1 = PyErr_ExceptionMatches(PyExc_OSError);
    if (__pyx_1) {
      __Pyx_AddTraceback("_dirstate_helpers_pyx._iter_next");
      if (__Pyx_GetException(&__pyx_5, &__pyx_3, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1487; goto __pyx_L1;}
      Py_INCREF(__pyx_3);
      Py_DECREF(__pyx_v_e);
      __pyx_v_e = __pyx_3;
      __pyx_4 = PyObject_GetAttr(__pyx_v_e, __pyx_n_errno); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1488; goto __pyx_L1;}
      __pyx_7 = __Pyx_GetName(__pyx_m, __pyx_n_errno); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1488; goto __pyx_L1;}
      __pyx_8 = PyObject_GetAttr(__pyx_7, __pyx_n_ENOENT); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1488; goto __pyx_L1;}
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      if (PyObject_Cmp(__pyx_4, __pyx_8, &__pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1488; goto __pyx_L1;}
      __pyx_1 = __pyx_1 == 0;
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_8); __pyx_8 = 0;
      if (__pyx_1) {
        Py_INCREF(Py_None);
        Py_DECREF(__pyx_v_self->root_dir_info);
        __pyx_v_self->root_dir_info = Py_None;
        goto __pyx_L14;
      }
      /*else*/ {
        __Pyx_Raise(__pyx_5, __pyx_3, __pyx_2);
        {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1493; goto __pyx_L1;}
      }
      __pyx_L14:;
      Py_DECREF(__pyx_5); __pyx_5 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      goto __pyx_L11;
    }
    goto __pyx_L1;
    __pyx_L11:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1503 */
    __pyx_9 = PyObject_IsTrue(__pyx_v_self->root_entries); if (__pyx_9 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1503; goto __pyx_L1;}
    __pyx_1 = (!__pyx_9);
    if (__pyx_1) {
      __pyx_9 = PyObject_IsTrue(__pyx_v_self->root_dir_info); if (__pyx_9 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1503; goto __pyx_L1;}
      __pyx_1 = (!__pyx_9);
    }
    if (__pyx_1) {
      __pyx_5 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_iter_next(__pyx_v_self); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1507; goto __pyx_L1;}
      __pyx_r = __pyx_5;
      __pyx_5 = 0;
      goto __pyx_L0;
      goto __pyx_L15;
    }
    __pyx_L15:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1508 */
    __pyx_v_path_handled = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1509 */
    __pyx_v_self->root_entries_pos = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1514 */
    while (1) {
      __pyx_9 = (__pyx_v_self->root_entries_pos < __pyx_v_self->root_entries_len);
      if (!__pyx_9) break;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1515 */
      __pyx_3 = __Pyx_GetItemInt(__pyx_v_self->root_entries, __pyx_v_self->root_entries_pos); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1515; goto __pyx_L1;}
      Py_DECREF(__pyx_v_entry);
      __pyx_v_entry = __pyx_3;
      __pyx_3 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1516 */
      __pyx_v_self->root_entries_pos = (__pyx_v_self->root_entries_pos + 1);

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1517 */
      __pyx_2 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_process_entry(__pyx_v_self,__pyx_v_entry,__pyx_v_self->root_dir_info); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1517; goto __pyx_L1;}
      __pyx_7 = PyObject_GetIter(__pyx_2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1517; goto __pyx_L1;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      __pyx_8 = __Pyx_UnpackItem(__pyx_7); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1517; goto __pyx_L1;}
      Py_DECREF(__pyx_v_result);
      __pyx_v_result = __pyx_8;
      __pyx_8 = 0;
      __pyx_4 = __Pyx_UnpackItem(__pyx_7); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1517; goto __pyx_L1;}
      Py_DECREF(__pyx_v_changed);
      __pyx_v_changed = __pyx_4;
      __pyx_4 = 0;
      if (__Pyx_EndUnpack(__pyx_7) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1517; goto __pyx_L1;}
      Py_DECREF(__pyx_7); __pyx_7 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1518 */
      __pyx_1 = __pyx_v_changed != Py_None;
      if (__pyx_1) {

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1519 */
        __pyx_v_path_handled = (-1);

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1520 */
        __pyx_9 = PyObject_IsTrue(__pyx_v_changed); if (__pyx_9 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1520; goto __pyx_L1;}
        if (__pyx_9) {
          ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_gather_result_for_consistency(__pyx_v_self,__pyx_v_result);
          goto __pyx_L19;
        }
        __pyx_L19:;

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1522 */
        __pyx_5 = __pyx_v_changed;
        Py_INCREF(__pyx_5);
        __pyx_1 = PyObject_IsTrue(__pyx_5); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1522; goto __pyx_L1;}
        if (!__pyx_1) {
          Py_DECREF(__pyx_5); __pyx_5 = 0;
          __pyx_5 = PyInt_FromLong(__pyx_v_self->include_unchanged); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1522; goto __pyx_L1;}
        }
        __pyx_9 = PyObject_IsTrue(__pyx_5); if (__pyx_9 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1522; goto __pyx_L1;}
        Py_DECREF(__pyx_5); __pyx_5 = 0;
        if (__pyx_9) {
          Py_INCREF(__pyx_v_result);
          __pyx_r = __pyx_v_result;
          goto __pyx_L0;
          goto __pyx_L20;
        }
        __pyx_L20:;
        goto __pyx_L18;
      }
      __pyx_L18:;
    }

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1525 */
    __pyx_3 = PyInt_FromLong(__pyx_v_self->want_unversioned); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1525; goto __pyx_L1;}
    __pyx_1 = PyObject_IsTrue(__pyx_3); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1525; goto __pyx_L1;}
    if (__pyx_1) {
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_3 = PyInt_FromLong((!__pyx_v_path_handled)); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1525; goto __pyx_L1;}
      __pyx_9 = PyObject_IsTrue(__pyx_3); if (__pyx_9 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1525; goto __pyx_L1;}
      if (__pyx_9) {
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        __pyx_3 = __pyx_v_self->root_dir_info;
        Py_INCREF(__pyx_3);
      }
    }
    __pyx_1 = PyObject_IsTrue(__pyx_3); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1525; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    if (__pyx_1) {

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1526 */
      __pyx_8 = __Pyx_GetName(__pyx_m, __pyx_n_stat); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1527; goto __pyx_L1;}
      __pyx_4 = PyObject_GetAttr(__pyx_8, __pyx_n_S_ISREG); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1527; goto __pyx_L1;}
      Py_DECREF(__pyx_8); __pyx_8 = 0;
      __pyx_7 = __Pyx_GetItemInt(__pyx_v_self->root_dir_info, 3); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1527; goto __pyx_L1;}
      __pyx_5 = PyObject_GetAttr(__pyx_7, __pyx_n_st_mode); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1527; goto __pyx_L1;}
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1527; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_5);
      __pyx_5 = 0;
      __pyx_2 = PyObject_CallObject(__pyx_4, __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1527; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_9 = PyObject_IsTrue(__pyx_2); if (__pyx_9 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1528; goto __pyx_L1;}
      if (__pyx_9) {
        Py_DECREF(__pyx_2); __pyx_2 = 0;
        __pyx_8 = __Pyx_GetName(__pyx_m, __pyx_n_stat); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1528; goto __pyx_L1;}
        __pyx_7 = PyObject_GetAttr(__pyx_8, __pyx_n_S_IEXEC); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1528; goto __pyx_L1;}
        Py_DECREF(__pyx_8); __pyx_8 = 0;
        __pyx_5 = __Pyx_GetItemInt(__pyx_v_self->root_dir_info, 3); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1528; goto __pyx_L1;}
        __pyx_4 = PyObject_GetAttr(__pyx_5, __pyx_n_st_mode); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1528; goto __pyx_L1;}
        Py_DECREF(__pyx_5); __pyx_5 = 0;
        __pyx_2 = PyNumber_And(__pyx_7, __pyx_4); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1528; goto __pyx_L1;}
        Py_DECREF(__pyx_7); __pyx_7 = 0;
        Py_DECREF(__pyx_4); __pyx_4 = 0;
      }
      __pyx_1 = PyObject_IsTrue(__pyx_2); if (__pyx_1 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1526; goto __pyx_L1;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      __pyx_3 = PyInt_FromLong(__pyx_1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1526; goto __pyx_L1;}
      Py_DECREF(__pyx_v_new_executable);
      __pyx_v_new_executable = __pyx_3;
      __pyx_3 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1529 */
      __pyx_8 = PyTuple_New(2); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1530; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_8, 0, Py_None);
      Py_INCREF(__pyx_v_self->current_root_unicode);
      PyTuple_SET_ITEM(__pyx_8, 1, __pyx_v_self->current_root_unicode);
      __pyx_5 = PyTuple_New(2); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1532; goto __pyx_L1;}
      Py_INCREF(Py_False);
      PyTuple_SET_ITEM(__pyx_5, 0, Py_False);
      Py_INCREF(Py_False);
      PyTuple_SET_ITEM(__pyx_5, 1, Py_False);
      __pyx_7 = PyTuple_New(2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1533; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_7, 0, Py_None);
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_7, 1, Py_None);
      __pyx_4 = __Pyx_GetName(__pyx_m, __pyx_n_splitpath); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1534; goto __pyx_L1;}
      __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1534; goto __pyx_L1;}
      Py_INCREF(__pyx_v_self->current_root_unicode);
      PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self->current_root_unicode);
      __pyx_3 = PyObject_CallObject(__pyx_4, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1534; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      __pyx_4 = __Pyx_GetItemInt(__pyx_3, (-1)); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1534; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1534; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_2, 0, Py_None);
      PyTuple_SET_ITEM(__pyx_2, 1, __pyx_4);
      __pyx_4 = 0;
      __pyx_3 = __Pyx_GetItemInt(__pyx_v_self->root_dir_info, 2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1535; goto __pyx_L1;}
      __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1535; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_4, 0, Py_None);
      PyTuple_SET_ITEM(__pyx_4, 1, __pyx_3);
      __pyx_3 = 0;
      __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1536; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_3, 0, Py_None);
      Py_INCREF(__pyx_v_new_executable);
      PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_new_executable);
      __pyx_10 = PyTuple_New(8); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1529; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_10, 0, Py_None);
      PyTuple_SET_ITEM(__pyx_10, 1, __pyx_8);
      Py_INCREF(Py_True);
      PyTuple_SET_ITEM(__pyx_10, 2, Py_True);
      PyTuple_SET_ITEM(__pyx_10, 3, __pyx_5);
      PyTuple_SET_ITEM(__pyx_10, 4, __pyx_7);
      PyTuple_SET_ITEM(__pyx_10, 5, __pyx_2);
      PyTuple_SET_ITEM(__pyx_10, 6, __pyx_4);
      PyTuple_SET_ITEM(__pyx_10, 7, __pyx_3);
      __pyx_8 = 0;
      __pyx_5 = 0;
      __pyx_7 = 0;
      __pyx_2 = 0;
      __pyx_4 = 0;
      __pyx_3 = 0;
      __pyx_r = __pyx_10;
      __pyx_10 = 0;
      goto __pyx_L0;
      goto __pyx_L21;
    }
    __pyx_L21:;
    goto __pyx_L7;
  }
  __pyx_L7:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1540 */
  __pyx_9 = __pyx_v_self->current_dir_info == Py_None;
  if (__pyx_9) {
    __pyx_9 = __pyx_v_self->current_block == Py_None;
    if (__pyx_9) {
      __pyx_9 = (!__pyx_v_self->doing_consistency_expansion);
    }
  }
  if (__pyx_9) {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1543 */
    Py_INCREF(Py_None);
    Py_DECREF(__pyx_v_self->current_dir_list);
    __pyx_v_self->current_dir_list = Py_None;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1544 */
    __pyx_8 = __pyx_v_self->root_dir_info;
    Py_INCREF(__pyx_8);
    __pyx_1 = PyObject_IsTrue(__pyx_8); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1544; goto __pyx_L1;}
    if (__pyx_1) {
      Py_DECREF(__pyx_8); __pyx_8 = 0;
      __pyx_5 = __Pyx_GetItemInt(__pyx_v_self->root_dir_info, 2); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1544; goto __pyx_L1;}
      if (PyObject_Cmp(__pyx_5, __pyx_k83p, &__pyx_9) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1544; goto __pyx_L1;}
      __pyx_9 = __pyx_9 == 0;
      Py_DECREF(__pyx_5); __pyx_5 = 0;
      __pyx_8 = PyInt_FromLong(__pyx_9); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1544; goto __pyx_L1;}
    }
    __pyx_1 = PyObject_IsTrue(__pyx_8); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1544; goto __pyx_L1;}
    Py_DECREF(__pyx_8); __pyx_8 = 0;
    if (__pyx_1) {
      Py_INCREF(Py_None);
      Py_DECREF(__pyx_v_self->current_dir_info);
      __pyx_v_self->current_dir_info = Py_None;
      goto __pyx_L23;
    }
    /*else*/ {

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1547 */
      __pyx_7 = __Pyx_GetName(__pyx_m, __pyx_n_osutils); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1547; goto __pyx_L1;}
      __pyx_2 = PyObject_GetAttr(__pyx_7, __pyx_n__walkdirs_utf8); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1547; goto __pyx_L1;}
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1547; goto __pyx_L1;}
      Py_INCREF(__pyx_v_self->root_abspath);
      PyTuple_SET_ITEM(__pyx_4, 0, __pyx_v_self->root_abspath);
      __pyx_3 = PyDict_New(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1547; goto __pyx_L1;}
      if (PyDict_SetItem(__pyx_3, __pyx_n_prefix, __pyx_v_self->current_root) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1547; goto __pyx_L1;}
      __pyx_10 = PyEval_CallObjectWithKeywords(__pyx_2, __pyx_4, __pyx_3); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1547; goto __pyx_L1;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_v_self->dir_iterator);
      __pyx_v_self->dir_iterator = __pyx_10;
      __pyx_10 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1549 */
      __pyx_v_self->path_index = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1550 */
      /*try:*/ {

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1551 */
        __pyx_5 = PyObject_GetAttr(__pyx_v_self->dir_iterator, __pyx_n_next); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1551; goto __pyx_L24;}
        __pyx_8 = PyObject_CallObject(__pyx_5, 0); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1551; goto __pyx_L24;}
        Py_DECREF(__pyx_5); __pyx_5 = 0;
        Py_DECREF(__pyx_v_self->current_dir_info);
        __pyx_v_self->current_dir_info = __pyx_8;
        __pyx_8 = 0;

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1552 */
        __pyx_7 = __Pyx_GetItemInt(__pyx_v_self->current_dir_info, 1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1552; goto __pyx_L24;}
        Py_DECREF(__pyx_v_self->current_dir_list);
        __pyx_v_self->current_dir_list = __pyx_7;
        __pyx_7 = 0;
      }
      /*else:*/ {
        __pyx_5 = __Pyx_GetItemInt(__pyx_v_self->current_dir_info, 0); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1576; goto __pyx_L1;}
        __pyx_11 = __Pyx_GetItemInt(__pyx_5, 0); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1576; goto __pyx_L1;}
        Py_DECREF(__pyx_5); __pyx_5 = 0;
        if (PyObject_Cmp(__pyx_11, __pyx_k86p, &__pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1576; goto __pyx_L1;}
        __pyx_1 = __pyx_1 == 0;
        Py_DECREF(__pyx_11); __pyx_11 = 0;
        if (__pyx_1) {

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1578 */
          __pyx_10 = PyTuple_New(1); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1578; goto __pyx_L1;}
          Py_INCREF(__pyx_k87p);
          PyTuple_SET_ITEM(__pyx_10, 0, __pyx_k87p);
          __pyx_7 = PyTuple_New(2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1578; goto __pyx_L1;}
          Py_INCREF(__pyx_v_self->current_dir_list);
          PyTuple_SET_ITEM(__pyx_7, 0, __pyx_v_self->current_dir_list);
          PyTuple_SET_ITEM(__pyx_7, 1, __pyx_10);
          __pyx_10 = 0;
          __pyx_8 = PyObject_CallObject(__pyx_v_self->bisect_left, __pyx_7); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1578; goto __pyx_L1;}
          Py_DECREF(__pyx_7); __pyx_7 = 0;
          Py_DECREF(__pyx_v_bzr_index);
          __pyx_v_bzr_index = __pyx_8;
          __pyx_8 = 0;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1579 */
          __pyx_2 = PyObject_GetItem(__pyx_v_self->current_dir_list, __pyx_v_bzr_index); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1579; goto __pyx_L1;}
          __pyx_4 = __Pyx_GetItemInt(__pyx_2, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1579; goto __pyx_L1;}
          Py_DECREF(__pyx_2); __pyx_2 = 0;
          if (PyObject_Cmp(__pyx_4, __pyx_k88p, &__pyx_9) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1579; goto __pyx_L1;}
          __pyx_9 = __pyx_9 != 0;
          Py_DECREF(__pyx_4); __pyx_4 = 0;
          if (__pyx_9) {
            __pyx_3 = PyObject_CallObject(PyExc_AssertionError, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1580; goto __pyx_L1;}
            __Pyx_Raise(__pyx_3, 0, 0);
            Py_DECREF(__pyx_3); __pyx_3 = 0;
            {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1580; goto __pyx_L1;}
            goto __pyx_L27;
          }
          __pyx_L27:;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1581 */
          if (PyObject_DelItem(__pyx_v_self->current_dir_list, __pyx_v_bzr_index) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1581; goto __pyx_L1;}
          goto __pyx_L26;
        }
        __pyx_L26:;
      }
      goto __pyx_L25;
      __pyx_L24:;
      Py_XDECREF(__pyx_2); __pyx_2 = 0;
      Py_XDECREF(__pyx_4); __pyx_4 = 0;
      Py_XDECREF(__pyx_3); __pyx_3 = 0;
      Py_XDECREF(__pyx_10); __pyx_10 = 0;
      Py_XDECREF(__pyx_5); __pyx_5 = 0;
      Py_XDECREF(__pyx_8); __pyx_8 = 0;
      Py_XDECREF(__pyx_7); __pyx_7 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1553 */
      __pyx_9 = PyErr_ExceptionMatches(PyExc_OSError);
      if (__pyx_9) {
        __Pyx_AddTraceback("_dirstate_helpers_pyx._iter_next");
        if (__Pyx_GetException(&__pyx_2, &__pyx_4, &__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1553; goto __pyx_L1;}
        Py_INCREF(__pyx_4);
        Py_DECREF(__pyx_v_e);
        __pyx_v_e = __pyx_4;
        __pyx_10 = PyObject_GetAttr(__pyx_v_e, __pyx_n_errno); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1557; goto __pyx_L1;}
        __pyx_5 = __Pyx_GetName(__pyx_m, __pyx_n_errno); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1557; goto __pyx_L1;}
        __pyx_8 = PyObject_GetAttr(__pyx_5, __pyx_n_ENOENT); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1557; goto __pyx_L1;}
        Py_DECREF(__pyx_5); __pyx_5 = 0;
        __pyx_7 = __Pyx_GetName(__pyx_m, __pyx_n_errno); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1557; goto __pyx_L1;}
        __pyx_5 = PyObject_GetAttr(__pyx_7, __pyx_n_ENOTDIR); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1557; goto __pyx_L1;}
        Py_DECREF(__pyx_7); __pyx_7 = 0;
        __pyx_7 = __Pyx_GetName(__pyx_m, __pyx_n_errno); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1557; goto __pyx_L1;}
        __pyx_11 = PyObject_GetAttr(__pyx_7, __pyx_n_EINVAL); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1557; goto __pyx_L1;}
        Py_DECREF(__pyx_7); __pyx_7 = 0;
        __pyx_7 = PyTuple_New(3); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1557; goto __pyx_L1;}
        PyTuple_SET_ITEM(__pyx_7, 0, __pyx_8);
        PyTuple_SET_ITEM(__pyx_7, 1, __pyx_5);
        PyTuple_SET_ITEM(__pyx_7, 2, __pyx_11);
        __pyx_8 = 0;
        __pyx_5 = 0;
        __pyx_11 = 0;
        __pyx_1 = PySequence_Contains(__pyx_7, __pyx_10); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1557; goto __pyx_L1;}
        Py_DECREF(__pyx_10); __pyx_10 = 0;
        Py_DECREF(__pyx_7); __pyx_7 = 0;
        if (__pyx_1) {
          Py_INCREF(Py_None);
          Py_DECREF(__pyx_v_self->current_dir_info);
          __pyx_v_self->current_dir_info = Py_None;
          goto __pyx_L28;
        }
        __pyx_8 = __Pyx_GetName(__pyx_m, __pyx_n_sys); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1559; goto __pyx_L1;}
        __pyx_5 = PyObject_GetAttr(__pyx_8, __pyx_n_platform); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1559; goto __pyx_L1;}
        Py_DECREF(__pyx_8); __pyx_8 = 0;
        if (PyObject_Cmp(__pyx_5, __pyx_n_win32, &__pyx_9) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1559; goto __pyx_L1;}
        __pyx_9 = __pyx_9 == 0;
        Py_DECREF(__pyx_5); __pyx_5 = 0;
        if (__pyx_9) {

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1563 */
          /*try:*/ {
            __pyx_11 = PyObject_GetAttr(__pyx_v_e, __pyx_n_winerror); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1564; goto __pyx_L29;}
            Py_DECREF(__pyx_v_e_winerror);
            __pyx_v_e_winerror = __pyx_11;
            __pyx_11 = 0;
          }
          goto __pyx_L30;
          __pyx_L29:;
          Py_XDECREF(__pyx_10); __pyx_10 = 0;
          Py_XDECREF(__pyx_7); __pyx_7 = 0;
          Py_XDECREF(__pyx_8); __pyx_8 = 0;
          Py_XDECREF(__pyx_5); __pyx_5 = 0;
          Py_XDECREF(__pyx_11); __pyx_11 = 0;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1565 */
          __pyx_10 = __Pyx_GetName(__pyx_b, __pyx_n_AttributeError); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1565; goto __pyx_L1;}
          __pyx_1 = PyErr_ExceptionMatches(__pyx_10);
          Py_DECREF(__pyx_10); __pyx_10 = 0;
          if (__pyx_1) {
            __Pyx_AddTraceback("_dirstate_helpers_pyx._iter_next");
            if (__Pyx_GetException(&__pyx_7, &__pyx_8, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1565; goto __pyx_L1;}
            Py_INCREF(Py_None);
            Py_DECREF(__pyx_v_e_winerror);
            __pyx_v_e_winerror = Py_None;
            Py_DECREF(__pyx_7); __pyx_7 = 0;
            Py_DECREF(__pyx_8); __pyx_8 = 0;
            Py_DECREF(__pyx_5); __pyx_5 = 0;
            goto __pyx_L30;
          }
          goto __pyx_L1;
          __pyx_L30:;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1567 */
          __pyx_11 = PyInt_FromLong(__pyx_v_21_dirstate_helpers_pyx_ERROR_DIRECTORY); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1567; goto __pyx_L1;}
          __pyx_10 = PyInt_FromLong(__pyx_v_21_dirstate_helpers_pyx_ERROR_PATH_NOT_FOUND); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1567; goto __pyx_L1;}
          __pyx_7 = PyTuple_New(2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1567; goto __pyx_L1;}
          PyTuple_SET_ITEM(__pyx_7, 0, __pyx_11);
          PyTuple_SET_ITEM(__pyx_7, 1, __pyx_10);
          __pyx_11 = 0;
          __pyx_10 = 0;
          Py_DECREF(__pyx_v_win_errors);
          __pyx_v_win_errors = __pyx_7;
          __pyx_7 = 0;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1568 */
          __pyx_8 = PyObject_GetAttr(__pyx_v_e, __pyx_n_errno); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1568; goto __pyx_L1;}
          __pyx_9 = PySequence_Contains(__pyx_v_win_errors, __pyx_8); if (__pyx_9 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1568; goto __pyx_L1;}
          Py_DECREF(__pyx_8); __pyx_8 = 0;
          if (!__pyx_9) {
            __pyx_9 = PySequence_Contains(__pyx_v_win_errors, __pyx_v_e_winerror); if (__pyx_9 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1568; goto __pyx_L1;}
          }
          if (__pyx_9) {
            Py_INCREF(Py_None);
            Py_DECREF(__pyx_v_self->current_dir_info);
            __pyx_v_self->current_dir_info = Py_None;
            goto __pyx_L31;
          }
          /*else*/ {
            __Pyx_Raise(__pyx_2, __pyx_4, __pyx_3);
            {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1572; goto __pyx_L1;}
          }
          __pyx_L31:;
          goto __pyx_L28;
        }
        /*else*/ {
          __Pyx_Raise(__pyx_2, __pyx_4, __pyx_3);
          {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1574; goto __pyx_L1;}
        }
        __pyx_L28:;
        Py_DECREF(__pyx_2); __pyx_2 = 0;
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        goto __pyx_L25;
      }
      goto __pyx_L1;
      __pyx_L25:;
    }
    __pyx_L23:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1582 */
    __pyx_5 = PyTuple_New(3); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1582; goto __pyx_L1;}
    Py_INCREF(__pyx_v_self->current_root);
    PyTuple_SET_ITEM(__pyx_5, 0, __pyx_v_self->current_root);
    Py_INCREF(__pyx_k89p);
    PyTuple_SET_ITEM(__pyx_5, 1, __pyx_k89p);
    Py_INCREF(__pyx_k90p);
    PyTuple_SET_ITEM(__pyx_5, 2, __pyx_k90p);
    Py_DECREF(__pyx_v_initial_key);
    __pyx_v_initial_key = __pyx_5;
    __pyx_5 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1583 */
    __pyx_11 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__find_block_index_from_key); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1583; goto __pyx_L1;}
    __pyx_10 = PyTuple_New(1); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1583; goto __pyx_L1;}
    Py_INCREF(__pyx_v_initial_key);
    PyTuple_SET_ITEM(__pyx_10, 0, __pyx_v_initial_key);
    __pyx_7 = PyObject_CallObject(__pyx_11, __pyx_10); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1583; goto __pyx_L1;}
    Py_DECREF(__pyx_11); __pyx_11 = 0;
    Py_DECREF(__pyx_10); __pyx_10 = 0;
    __pyx_8 = PyObject_GetIter(__pyx_7); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1583; goto __pyx_L1;}
    Py_DECREF(__pyx_7); __pyx_7 = 0;
    __pyx_2 = __Pyx_UnpackItem(__pyx_8); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1583; goto __pyx_L1;}
    __pyx_1 = PyInt_AsLong(__pyx_2); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1583; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_v_self->block_index = __pyx_1;
    __pyx_4 = __Pyx_UnpackItem(__pyx_8); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1583; goto __pyx_L1;}
    Py_DECREF(__pyx_v__);
    __pyx_v__ = __pyx_4;
    __pyx_4 = 0;
    if (__Pyx_EndUnpack(__pyx_8) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1583; goto __pyx_L1;}
    Py_DECREF(__pyx_8); __pyx_8 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1584 */
    __pyx_9 = (__pyx_v_self->block_index == 0);
    if (__pyx_9) {
      __pyx_v_self->block_index = (__pyx_v_self->block_index + 1);
      goto __pyx_L32;
    }
    __pyx_L32:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1588 */
    ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_update_current_block(__pyx_v_self);
    goto __pyx_L22;
  }
  __pyx_L22:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1591 */
  while (1) {
    __pyx_1 = __pyx_v_self->current_dir_info != Py_None;
    if (!__pyx_1) {
      __pyx_1 = __pyx_v_self->current_block != Py_None;
    }
    if (!__pyx_1) break;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1594 */
    __pyx_3 = __pyx_v_self->current_dir_info;
    Py_INCREF(__pyx_3);
    __pyx_9 = PyObject_IsTrue(__pyx_3); if (__pyx_9 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1594; goto __pyx_L1;}
    if (__pyx_9) {
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_3 = __pyx_v_self->current_block;
      Py_INCREF(__pyx_3);
      __pyx_1 = PyObject_IsTrue(__pyx_3); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1595; goto __pyx_L1;}
      if (__pyx_1) {
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        __pyx_5 = __Pyx_GetItemInt(__pyx_v_self->current_dir_info, 0); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1595; goto __pyx_L1;}
        __pyx_11 = __Pyx_GetItemInt(__pyx_5, 0); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1595; goto __pyx_L1;}
        Py_DECREF(__pyx_5); __pyx_5 = 0;
        __pyx_10 = __Pyx_GetItemInt(__pyx_v_self->current_block, 0); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1595; goto __pyx_L1;}
        if (PyObject_Cmp(__pyx_11, __pyx_10, &__pyx_9) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1595; goto __pyx_L1;}
        __pyx_9 = __pyx_9 != 0;
        Py_DECREF(__pyx_11); __pyx_11 = 0;
        Py_DECREF(__pyx_10); __pyx_10 = 0;
        __pyx_3 = PyInt_FromLong(__pyx_9); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1595; goto __pyx_L1;}
      }
    }
    __pyx_1 = PyObject_IsTrue(__pyx_3); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1594; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    if (__pyx_1) {

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1598 */
      __pyx_7 = __Pyx_GetItemInt(__pyx_v_self->current_dir_info, 0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1598; goto __pyx_L1;}
      __pyx_2 = __Pyx_GetItemInt(__pyx_7, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1598; goto __pyx_L1;}
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      Py_DECREF(__pyx_v_current_dirname);
      __pyx_v_current_dirname = __pyx_2;
      __pyx_2 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1599 */
      __pyx_v_current_dirname_c = PyString_AS_STRING(((void *)__pyx_v_current_dirname));

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1601 */
      __pyx_4 = __Pyx_GetItemInt(__pyx_v_self->current_block, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1601; goto __pyx_L1;}
      Py_DECREF(__pyx_v_current_blockname);
      __pyx_v_current_blockname = __pyx_4;
      __pyx_4 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1602 */
      __pyx_v_current_blockname_c = PyString_AS_STRING(((void *)__pyx_v_current_blockname));

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1608 */
      __pyx_9 = (__pyx_f_21_dirstate_helpers_pyx__cmp_by_dirs(__pyx_v_current_dirname_c,PyString_Size(__pyx_v_current_dirname),__pyx_v_current_blockname_c,PyString_Size(__pyx_v_current_blockname)) < 0);
      if (__pyx_9) {

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1622 */
        while (1) {
          __pyx_6 = PyObject_Length(__pyx_v_self->current_dir_list); if (__pyx_6 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1622; goto __pyx_L1;}
          __pyx_1 = (__pyx_v_self->path_index < __pyx_6);
          if (!__pyx_1) break;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1623 */
          __pyx_8 = __Pyx_GetItemInt(__pyx_v_self->current_dir_list, __pyx_v_self->path_index); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1623; goto __pyx_L1;}
          Py_DECREF(__pyx_v_current_path_info);
          __pyx_v_current_path_info = __pyx_8;
          __pyx_8 = 0;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1626 */
          __pyx_5 = __Pyx_GetItemInt(__pyx_v_current_path_info, 2); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1626; goto __pyx_L1;}
          __pyx_11 = PyTuple_New(2); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1626; goto __pyx_L1;}
          Py_INCREF(__pyx_n_directory);
          PyTuple_SET_ITEM(__pyx_11, 0, __pyx_n_directory);
          Py_INCREF(__pyx_k92p);
          PyTuple_SET_ITEM(__pyx_11, 1, __pyx_k92p);
          __pyx_9 = PySequence_Contains(__pyx_11, __pyx_5); if (__pyx_9 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1626; goto __pyx_L1;}
          Py_DECREF(__pyx_5); __pyx_5 = 0;
          Py_DECREF(__pyx_11); __pyx_11 = 0;
          if (__pyx_9) {

            /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1628 */
            if (PySequence_DelItem(__pyx_v_self->current_dir_list, __pyx_v_self->path_index) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1628; goto __pyx_L1;}

            /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1629 */
            __pyx_v_self->path_index = (__pyx_v_self->path_index - 1);
            goto __pyx_L39;
          }
          __pyx_L39:;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1630 */
          __pyx_v_self->path_index = (__pyx_v_self->path_index + 1);

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1631 */
          __pyx_1 = __pyx_v_self->want_unversioned;
          if (__pyx_1) {

            /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1632 */
            __pyx_10 = __Pyx_GetItemInt(__pyx_v_current_path_info, 2); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1632; goto __pyx_L1;}
            if (PyObject_Cmp(__pyx_10, __pyx_n_directory, &__pyx_9) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1632; goto __pyx_L1;}
            __pyx_9 = __pyx_9 == 0;
            Py_DECREF(__pyx_10); __pyx_10 = 0;
            if (__pyx_9) {
              __pyx_3 = PyObject_GetAttr(__pyx_v_self->tree, __pyx_n__directory_is_tree_reference); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1633; goto __pyx_L1;}
              __pyx_7 = __Pyx_GetItemInt(__pyx_v_current_path_info, 0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1634; goto __pyx_L1;}
              __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1634; goto __pyx_L1;}
              PyTuple_SET_ITEM(__pyx_2, 0, __pyx_7);
              __pyx_7 = 0;
              __pyx_4 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1634; goto __pyx_L1;}
              Py_DECREF(__pyx_2); __pyx_2 = 0;
              __pyx_8 = __Pyx_GetItemInt(__pyx_4, 0); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1634; goto __pyx_L1;}
              Py_DECREF(__pyx_4); __pyx_4 = 0;
              __pyx_5 = PyTuple_New(1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1633; goto __pyx_L1;}
              PyTuple_SET_ITEM(__pyx_5, 0, __pyx_8);
              __pyx_8 = 0;
              __pyx_11 = PyObject_CallObject(__pyx_3, __pyx_5); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1633; goto __pyx_L1;}
              Py_DECREF(__pyx_3); __pyx_3 = 0;
              Py_DECREF(__pyx_5); __pyx_5 = 0;
              __pyx_1 = PyObject_IsTrue(__pyx_11); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1633; goto __pyx_L1;}
              Py_DECREF(__pyx_11); __pyx_11 = 0;
              if (__pyx_1) {
                __pyx_10 = PySequence_GetSlice(__pyx_v_current_path_info, 0, 2); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1635; goto __pyx_L1;}
                __pyx_7 = PyTuple_New(1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1636; goto __pyx_L1;}
                Py_INCREF(__pyx_k94p);
                PyTuple_SET_ITEM(__pyx_7, 0, __pyx_k94p);
                __pyx_2 = PyNumber_Add(__pyx_10, __pyx_7); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1635; goto __pyx_L1;}
                Py_DECREF(__pyx_10); __pyx_10 = 0;
                Py_DECREF(__pyx_7); __pyx_7 = 0;
                __pyx_4 = PySequence_GetSlice(__pyx_v_current_path_info, 3, PY_SSIZE_T_MAX); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1636; goto __pyx_L1;}
                __pyx_8 = PyNumber_Add(__pyx_2, __pyx_4); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1636; goto __pyx_L1;}
                Py_DECREF(__pyx_2); __pyx_2 = 0;
                Py_DECREF(__pyx_4); __pyx_4 = 0;
                Py_DECREF(__pyx_v_current_path_info);
                __pyx_v_current_path_info = __pyx_8;
                __pyx_8 = 0;
                goto __pyx_L42;
              }
              __pyx_L42:;
              goto __pyx_L41;
            }
            __pyx_L41:;

            /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1637 */
            __pyx_5 = __Pyx_GetName(__pyx_m, __pyx_n_stat); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1638; goto __pyx_L1;}
            __pyx_11 = PyObject_GetAttr(__pyx_5, __pyx_n_S_ISREG); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1638; goto __pyx_L1;}
            Py_DECREF(__pyx_5); __pyx_5 = 0;
            __pyx_10 = __Pyx_GetItemInt(__pyx_v_current_path_info, 3); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1638; goto __pyx_L1;}
            __pyx_7 = PyObject_GetAttr(__pyx_10, __pyx_n_st_mode); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1638; goto __pyx_L1;}
            Py_DECREF(__pyx_10); __pyx_10 = 0;
            __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1638; goto __pyx_L1;}
            PyTuple_SET_ITEM(__pyx_2, 0, __pyx_7);
            __pyx_7 = 0;
            __pyx_3 = PyObject_CallObject(__pyx_11, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1638; goto __pyx_L1;}
            Py_DECREF(__pyx_11); __pyx_11 = 0;
            Py_DECREF(__pyx_2); __pyx_2 = 0;
            __pyx_9 = PyObject_IsTrue(__pyx_3); if (__pyx_9 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1639; goto __pyx_L1;}
            if (__pyx_9) {
              Py_DECREF(__pyx_3); __pyx_3 = 0;
              __pyx_4 = __Pyx_GetName(__pyx_m, __pyx_n_stat); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1639; goto __pyx_L1;}
              __pyx_8 = PyObject_GetAttr(__pyx_4, __pyx_n_S_IEXEC); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1639; goto __pyx_L1;}
              Py_DECREF(__pyx_4); __pyx_4 = 0;
              __pyx_5 = __Pyx_GetItemInt(__pyx_v_current_path_info, 3); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1639; goto __pyx_L1;}
              __pyx_10 = PyObject_GetAttr(__pyx_5, __pyx_n_st_mode); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1639; goto __pyx_L1;}
              Py_DECREF(__pyx_5); __pyx_5 = 0;
              __pyx_3 = PyNumber_And(__pyx_8, __pyx_10); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1639; goto __pyx_L1;}
              Py_DECREF(__pyx_8); __pyx_8 = 0;
              Py_DECREF(__pyx_10); __pyx_10 = 0;
            }
            __pyx_1 = PyObject_IsTrue(__pyx_3); if (__pyx_1 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1637; goto __pyx_L1;}
            Py_DECREF(__pyx_3); __pyx_3 = 0;
            __pyx_7 = PyInt_FromLong(__pyx_1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1637; goto __pyx_L1;}
            Py_DECREF(__pyx_v_new_executable);
            __pyx_v_new_executable = __pyx_7;
            __pyx_7 = 0;

            /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1640 */
            __pyx_11 = __Pyx_GetItemInt(__pyx_v_current_path_info, 0); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1641; goto __pyx_L1;}
            __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1641; goto __pyx_L1;}
            PyTuple_SET_ITEM(__pyx_2, 0, __pyx_11);
            __pyx_11 = 0;
            __pyx_4 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1641; goto __pyx_L1;}
            Py_DECREF(__pyx_2); __pyx_2 = 0;
            __pyx_5 = __Pyx_GetItemInt(__pyx_4, 0); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1641; goto __pyx_L1;}
            Py_DECREF(__pyx_4); __pyx_4 = 0;
            __pyx_8 = PyTuple_New(2); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1641; goto __pyx_L1;}
            Py_INCREF(Py_None);
            PyTuple_SET_ITEM(__pyx_8, 0, Py_None);
            PyTuple_SET_ITEM(__pyx_8, 1, __pyx_5);
            __pyx_5 = 0;
            __pyx_10 = PyTuple_New(2); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1643; goto __pyx_L1;}
            Py_INCREF(Py_False);
            PyTuple_SET_ITEM(__pyx_10, 0, Py_False);
            Py_INCREF(Py_False);
            PyTuple_SET_ITEM(__pyx_10, 1, Py_False);
            __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1644; goto __pyx_L1;}
            Py_INCREF(Py_None);
            PyTuple_SET_ITEM(__pyx_3, 0, Py_None);
            Py_INCREF(Py_None);
            PyTuple_SET_ITEM(__pyx_3, 1, Py_None);
            __pyx_7 = __Pyx_GetItemInt(__pyx_v_current_path_info, 1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1645; goto __pyx_L1;}
            __pyx_11 = PyTuple_New(1); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1645; goto __pyx_L1;}
            PyTuple_SET_ITEM(__pyx_11, 0, __pyx_7);
            __pyx_7 = 0;
            __pyx_2 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_11); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1645; goto __pyx_L1;}
            Py_DECREF(__pyx_11); __pyx_11 = 0;
            __pyx_4 = __Pyx_GetItemInt(__pyx_2, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1645; goto __pyx_L1;}
            Py_DECREF(__pyx_2); __pyx_2 = 0;
            __pyx_5 = PyTuple_New(2); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1645; goto __pyx_L1;}
            Py_INCREF(Py_None);
            PyTuple_SET_ITEM(__pyx_5, 0, Py_None);
            PyTuple_SET_ITEM(__pyx_5, 1, __pyx_4);
            __pyx_4 = 0;
            __pyx_7 = __Pyx_GetItemInt(__pyx_v_current_path_info, 2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1646; goto __pyx_L1;}
            __pyx_11 = PyTuple_New(2); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1646; goto __pyx_L1;}
            Py_INCREF(Py_None);
            PyTuple_SET_ITEM(__pyx_11, 0, Py_None);
            PyTuple_SET_ITEM(__pyx_11, 1, __pyx_7);
            __pyx_7 = 0;
            __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1647; goto __pyx_L1;}
            Py_INCREF(Py_None);
            PyTuple_SET_ITEM(__pyx_2, 0, Py_None);
            Py_INCREF(__pyx_v_new_executable);
            PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_new_executable);
            __pyx_4 = PyTuple_New(8); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1640; goto __pyx_L1;}
            Py_INCREF(Py_None);
            PyTuple_SET_ITEM(__pyx_4, 0, Py_None);
            PyTuple_SET_ITEM(__pyx_4, 1, __pyx_8);
            Py_INCREF(Py_True);
            PyTuple_SET_ITEM(__pyx_4, 2, Py_True);
            PyTuple_SET_ITEM(__pyx_4, 3, __pyx_10);
            PyTuple_SET_ITEM(__pyx_4, 4, __pyx_3);
            PyTuple_SET_ITEM(__pyx_4, 5, __pyx_5);
            PyTuple_SET_ITEM(__pyx_4, 6, __pyx_11);
            PyTuple_SET_ITEM(__pyx_4, 7, __pyx_2);
            __pyx_8 = 0;
            __pyx_10 = 0;
            __pyx_3 = 0;
            __pyx_5 = 0;
            __pyx_11 = 0;
            __pyx_2 = 0;
            __pyx_r = __pyx_4;
            __pyx_4 = 0;
            goto __pyx_L0;
            goto __pyx_L40;
          }
          __pyx_L40:;
        }

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1649 */
        __pyx_v_self->path_index = 0;

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1650 */
        Py_INCREF(Py_None);
        Py_DECREF(__pyx_v_self->current_dir_list);
        __pyx_v_self->current_dir_list = Py_None;

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1651 */
        /*try:*/ {

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1652 */
          __pyx_7 = PyObject_GetAttr(__pyx_v_self->dir_iterator, __pyx_n_next); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1652; goto __pyx_L43;}
          __pyx_8 = PyObject_CallObject(__pyx_7, 0); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1652; goto __pyx_L43;}
          Py_DECREF(__pyx_7); __pyx_7 = 0;
          Py_DECREF(__pyx_v_self->current_dir_info);
          __pyx_v_self->current_dir_info = __pyx_8;
          __pyx_8 = 0;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1653 */
          __pyx_10 = __Pyx_GetItemInt(__pyx_v_self->current_dir_info, 1); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1653; goto __pyx_L43;}
          Py_DECREF(__pyx_v_self->current_dir_list);
          __pyx_v_self->current_dir_list = __pyx_10;
          __pyx_10 = 0;
        }
        goto __pyx_L44;
        __pyx_L43:;
        Py_XDECREF(__pyx_3); __pyx_3 = 0;
        Py_XDECREF(__pyx_5); __pyx_5 = 0;
        Py_XDECREF(__pyx_11); __pyx_11 = 0;
        Py_XDECREF(__pyx_2); __pyx_2 = 0;
        Py_XDECREF(__pyx_4); __pyx_4 = 0;
        Py_XDECREF(__pyx_7); __pyx_7 = 0;
        Py_XDECREF(__pyx_8); __pyx_8 = 0;
        Py_XDECREF(__pyx_10); __pyx_10 = 0;

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1654 */
        __pyx_9 = PyErr_ExceptionMatches(PyExc_StopIteration);
        if (__pyx_9) {
          __Pyx_AddTraceback("_dirstate_helpers_pyx._iter_next");
          if (__Pyx_GetException(&__pyx_3, &__pyx_5, &__pyx_11) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1654; goto __pyx_L1;}
          Py_INCREF(Py_None);
          Py_DECREF(__pyx_v_self->current_dir_info);
          __pyx_v_self->current_dir_info = Py_None;
          Py_DECREF(__pyx_3); __pyx_3 = 0;
          Py_DECREF(__pyx_5); __pyx_5 = 0;
          Py_DECREF(__pyx_11); __pyx_11 = 0;
          goto __pyx_L44;
        }
        goto __pyx_L1;
        __pyx_L44:;
        goto __pyx_L36;
      }
      /*else*/ {

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1664 */
        while (1) {
          __pyx_6 = PyObject_Length(__pyx_v_self->current_block_list); if (__pyx_6 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1664; goto __pyx_L1;}
          __pyx_1 = (__pyx_v_self->current_block_pos < __pyx_6);
          if (!__pyx_1) break;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1665 */
          __pyx_2 = __Pyx_GetItemInt(__pyx_v_self->current_block_list, __pyx_v_self->current_block_pos); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1665; goto __pyx_L1;}
          Py_DECREF(__pyx_v_current_entry);
          __pyx_v_current_entry = __pyx_2;
          __pyx_2 = 0;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1666 */
          __pyx_v_self->current_block_pos = (__pyx_v_self->current_block_pos + 1);

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1669 */
          __pyx_4 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_process_entry(__pyx_v_self,__pyx_v_current_entry,Py_None); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1669; goto __pyx_L1;}
          __pyx_7 = PyObject_GetIter(__pyx_4); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1669; goto __pyx_L1;}
          Py_DECREF(__pyx_4); __pyx_4 = 0;
          __pyx_8 = __Pyx_UnpackItem(__pyx_7); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1669; goto __pyx_L1;}
          Py_DECREF(__pyx_v_result);
          __pyx_v_result = __pyx_8;
          __pyx_8 = 0;
          __pyx_10 = __Pyx_UnpackItem(__pyx_7); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1669; goto __pyx_L1;}
          Py_DECREF(__pyx_v_changed);
          __pyx_v_changed = __pyx_10;
          __pyx_10 = 0;
          if (__Pyx_EndUnpack(__pyx_7) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1669; goto __pyx_L1;}
          Py_DECREF(__pyx_7); __pyx_7 = 0;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1670 */
          __pyx_9 = __pyx_v_changed != Py_None;
          if (__pyx_9) {

            /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1671 */
            __pyx_1 = PyObject_IsTrue(__pyx_v_changed); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1671; goto __pyx_L1;}
            if (__pyx_1) {
              ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_gather_result_for_consistency(__pyx_v_self,__pyx_v_result);
              goto __pyx_L48;
            }
            __pyx_L48:;

            /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1673 */
            __pyx_3 = __pyx_v_changed;
            Py_INCREF(__pyx_3);
            __pyx_9 = PyObject_IsTrue(__pyx_3); if (__pyx_9 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1673; goto __pyx_L1;}
            if (!__pyx_9) {
              Py_DECREF(__pyx_3); __pyx_3 = 0;
              __pyx_3 = PyInt_FromLong(__pyx_v_self->include_unchanged); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1673; goto __pyx_L1;}
            }
            __pyx_1 = PyObject_IsTrue(__pyx_3); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1673; goto __pyx_L1;}
            Py_DECREF(__pyx_3); __pyx_3 = 0;
            if (__pyx_1) {
              Py_INCREF(__pyx_v_result);
              __pyx_r = __pyx_v_result;
              goto __pyx_L0;
              goto __pyx_L49;
            }
            __pyx_L49:;
            goto __pyx_L47;
          }
          __pyx_L47:;
        }

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1675 */
        __pyx_v_self->block_index = (__pyx_v_self->block_index + 1);

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1676 */
        ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_update_current_block(__pyx_v_self);
      }
      __pyx_L36:;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1677 */
      goto __pyx_L33;
      goto __pyx_L35;
    }
    __pyx_L35:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1678 */
    __pyx_5 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_loop_one_block(__pyx_v_self); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1678; goto __pyx_L1;}
    Py_DECREF(__pyx_v_result);
    __pyx_v_result = __pyx_5;
    __pyx_5 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1679 */
    __pyx_9 = __pyx_v_result != Py_None;
    if (__pyx_9) {
      Py_INCREF(__pyx_v_result);
      __pyx_r = __pyx_v_result;
      goto __pyx_L0;
      goto __pyx_L50;
    }
    __pyx_L50:;
    __pyx_L33:;
  }

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1681 */
  __pyx_6 = PyObject_Length(__pyx_v_self->search_specific_files); if (__pyx_6 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1681; goto __pyx_L1;}
  if (__pyx_6) {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1683 */
    Py_INCREF(Py_None);
    Py_DECREF(__pyx_v_self->current_root);
    __pyx_v_self->current_root = Py_None;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1684 */
    __pyx_11 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_iter_next(__pyx_v_self); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1684; goto __pyx_L1;}
    __pyx_r = __pyx_11;
    __pyx_11 = 0;
    goto __pyx_L0;
    goto __pyx_L51;
  }
  __pyx_L51:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1687 */
  __pyx_v_self->doing_consistency_expansion = 1;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1688 */
  __pyx_1 = PyObject_IsTrue(__pyx_v_self->_pending_consistent_entries); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1688; goto __pyx_L1;}
  __pyx_9 = (!__pyx_1);
  if (__pyx_9) {
    __pyx_2 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_next_consistent_entries(__pyx_v_self); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1689; goto __pyx_L1;}
    Py_DECREF(__pyx_v_self->_pending_consistent_entries);
    __pyx_v_self->_pending_consistent_entries = __pyx_2;
    __pyx_2 = 0;
    goto __pyx_L52;
  }
  __pyx_L52:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1690 */
  while (1) {
    __pyx_1 = PyObject_IsTrue(__pyx_v_self->_pending_consistent_entries); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1690; goto __pyx_L1;}
    if (!__pyx_1) break;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1691 */
    __pyx_4 = PyObject_GetAttr(__pyx_v_self->_pending_consistent_entries, __pyx_n_pop); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1691; goto __pyx_L1;}
    __pyx_8 = PyObject_CallObject(__pyx_4, 0); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1691; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_10 = PyObject_GetIter(__pyx_8); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1691; goto __pyx_L1;}
    Py_DECREF(__pyx_8); __pyx_8 = 0;
    __pyx_7 = __Pyx_UnpackItem(__pyx_10); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1691; goto __pyx_L1;}
    Py_DECREF(__pyx_v_result);
    __pyx_v_result = __pyx_7;
    __pyx_7 = 0;
    __pyx_3 = __Pyx_UnpackItem(__pyx_10); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1691; goto __pyx_L1;}
    Py_DECREF(__pyx_v_changed);
    __pyx_v_changed = __pyx_3;
    __pyx_3 = 0;
    if (__Pyx_EndUnpack(__pyx_10) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1691; goto __pyx_L1;}
    Py_DECREF(__pyx_10); __pyx_10 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1692 */
    __pyx_9 = __pyx_v_changed != Py_None;
    if (__pyx_9) {
      Py_INCREF(__pyx_v_result);
      __pyx_r = __pyx_v_result;
      goto __pyx_L0;
      goto __pyx_L55;
    }
    __pyx_L55:;
  }

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1694 */
  __pyx_5 = PyObject_CallObject(PyExc_StopIteration, 0); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1694; goto __pyx_L1;}
  __Pyx_Raise(__pyx_5, 0, 0);
  Py_DECREF(__pyx_5); __pyx_5 = 0;
  {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1694; goto __pyx_L1;}

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_5);
  Py_XDECREF(__pyx_7);
  Py_XDECREF(__pyx_8);
  Py_XDECREF(__pyx_10);
  Py_XDECREF(__pyx_11);
  __Pyx_AddTraceback("_dirstate_helpers_pyx.ProcessEntryC._iter_next");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_current_dirname);
  Py_DECREF(__pyx_v_current_blockname);
  Py_DECREF(__pyx_v_searched_specific_files);
  Py_DECREF(__pyx_v_entry);
  Py_DECREF(__pyx_v_result);
  Py_DECREF(__pyx_v_changed);
  Py_DECREF(__pyx_v_root_stat);
  Py_DECREF(__pyx_v_e);
  Py_DECREF(__pyx_v_new_executable);
  Py_DECREF(__pyx_v_e_winerror);
  Py_DECREF(__pyx_v_win_errors);
  Py_DECREF(__pyx_v_bzr_index);
  Py_DECREF(__pyx_v_initial_key);
  Py_DECREF(__pyx_v__);
  Py_DECREF(__pyx_v_current_path_info);
  Py_DECREF(__pyx_v_current_entry);
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_k95p;

static char __pyx_k95[] = "tree-reference";

static PyObject *__pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC__maybe_tree_ref(struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *__pyx_v_self,PyObject *__pyx_v_current_path_info) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  int __pyx_4;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_current_path_info);
  __pyx_1 = PyObject_GetAttr(__pyx_v_self->tree, __pyx_n__directory_is_tree_reference); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1697; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetItemInt(__pyx_v_current_path_info, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1698; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1698; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_2);
  __pyx_2 = 0;
  __pyx_2 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1698; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_3 = __Pyx_GetItemInt(__pyx_2, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1698; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1697; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
  __pyx_3 = 0;
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1697; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_4 = PyObject_IsTrue(__pyx_3); if (__pyx_4 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1697; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  if (__pyx_4) {
    __pyx_1 = PySequence_GetSlice(__pyx_v_current_path_info, 0, 2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1699; goto __pyx_L1;}
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1700; goto __pyx_L1;}
    Py_INCREF(__pyx_k95p);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_k95p);
    __pyx_3 = PyNumber_Add(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1699; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_1 = PySequence_GetSlice(__pyx_v_current_path_info, 3, PY_SSIZE_T_MAX); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1700; goto __pyx_L1;}
    __pyx_2 = PyNumber_Add(__pyx_3, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1700; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_r = __pyx_2;
    __pyx_2 = 0;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  /*else*/ {
    Py_INCREF(__pyx_v_current_path_info);
    __pyx_r = __pyx_v_current_path_info;
    goto __pyx_L0;
  }
  __pyx_L2:;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("_dirstate_helpers_pyx.ProcessEntryC._maybe_tree_ref");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_current_path_info);
  return __pyx_r;
}

static PyObject *__pyx_n_cmp;
static PyObject *__pyx_n_BadFilenameEncoding;
static PyObject *__pyx_n__fs_enc;

static PyObject *__pyx_k97p;
static PyObject *__pyx_k99p;

static char __pyx_k97[] = "result is not None: %r";
static char __pyx_k99[] = "tree-reference";

static PyObject *__pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC__loop_one_block(struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *__pyx_v_self) {
  PyObject *__pyx_v_current_entry;
  PyObject *__pyx_v_current_path_info;
  int __pyx_v_path_handled;
  char __pyx_v_minikind;
  int __pyx_v_cmp_result;
  PyObject *__pyx_v_disk_kind;
  PyObject *__pyx_v_advance_entry;
  PyObject *__pyx_v_advance_path;
  PyObject *__pyx_v_result;
  PyObject *__pyx_v_changed;
  PyObject *__pyx_v_new_executable;
  PyObject *__pyx_v_relpath_unicode;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  PyObject *__pyx_5 = 0;
  int __pyx_6;
  PyObject *__pyx_7 = 0;
  PyObject *__pyx_8 = 0;
  PyObject *__pyx_9 = 0;
  Py_ssize_t __pyx_10;
  Py_INCREF(__pyx_v_self);
  __pyx_v_current_entry = Py_None; Py_INCREF(Py_None);
  __pyx_v_current_path_info = Py_None; Py_INCREF(Py_None);
  __pyx_v_disk_kind = Py_None; Py_INCREF(Py_None);
  __pyx_v_advance_entry = Py_None; Py_INCREF(Py_None);
  __pyx_v_advance_path = Py_None; Py_INCREF(Py_None);
  __pyx_v_result = Py_None; Py_INCREF(Py_None);
  __pyx_v_changed = Py_None; Py_INCREF(Py_None);
  __pyx_v_new_executable = Py_None; Py_INCREF(Py_None);
  __pyx_v_relpath_unicode = Py_None; Py_INCREF(Py_None);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1717 */
  __pyx_1 = __pyx_v_self->current_block != Py_None;
  if (__pyx_1) {
    __pyx_1 = (__pyx_v_self->current_block_pos < PyList_GET_SIZE(__pyx_v_self->current_block_list));
  }
  if (__pyx_1) {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1719 */
    __pyx_2 = PyList_GET_ITEM(__pyx_v_self->current_block_list,__pyx_v_self->current_block_pos); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1719; goto __pyx_L1;}
    Py_DECREF(__pyx_v_current_entry);
    __pyx_v_current_entry = __pyx_2;
    __pyx_2 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1722 */
    Py_INCREF(__pyx_v_current_entry);
    goto __pyx_L2;
  }
  /*else*/ {
    Py_INCREF(Py_None);
    Py_DECREF(__pyx_v_current_entry);
    __pyx_v_current_entry = Py_None;
  }
  __pyx_L2:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1725 */
  __pyx_1 = __pyx_v_self->current_dir_info != Py_None;
  if (__pyx_1) {
    __pyx_1 = (__pyx_v_self->path_index < PyList_GET_SIZE(__pyx_v_self->current_dir_list));
  }
  if (__pyx_1) {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1727 */
    __pyx_2 = PyList_GET_ITEM(__pyx_v_self->current_dir_list,__pyx_v_self->path_index); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1727; goto __pyx_L1;}
    Py_DECREF(__pyx_v_current_path_info);
    __pyx_v_current_path_info = __pyx_2;
    __pyx_2 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1730 */
    Py_INCREF(__pyx_v_current_path_info);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1731 */
    __pyx_2 = PyTuple_GET_ITEM(__pyx_v_current_path_info,2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1731; goto __pyx_L1;}
    Py_DECREF(__pyx_v_disk_kind);
    __pyx_v_disk_kind = __pyx_2;
    __pyx_2 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1733 */
    Py_INCREF(__pyx_v_disk_kind);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1734 */
    if (PyObject_Cmp(__pyx_v_disk_kind, __pyx_n_directory, &__pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1734; goto __pyx_L1;}
    __pyx_1 = __pyx_1 == 0;
    if (__pyx_1) {
      __pyx_2 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_maybe_tree_ref(__pyx_v_self,__pyx_v_current_path_info); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1735; goto __pyx_L1;}
      Py_DECREF(__pyx_v_current_path_info);
      __pyx_v_current_path_info = __pyx_2;
      __pyx_2 = 0;
      goto __pyx_L4;
    }
    __pyx_L4:;
    goto __pyx_L3;
  }
  /*else*/ {
    Py_INCREF(Py_None);
    Py_DECREF(__pyx_v_current_path_info);
    __pyx_v_current_path_info = Py_None;
  }
  __pyx_L3:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1738 */
  while (1) {
    __pyx_1 = __pyx_v_current_entry != Py_None;
    if (!__pyx_1) {
      __pyx_1 = __pyx_v_current_path_info != Py_None;
    }
    if (!__pyx_1) break;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1739 */
    __pyx_2 = PyInt_FromLong((-1)); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1739; goto __pyx_L1;}
    Py_DECREF(__pyx_v_advance_entry);
    __pyx_v_advance_entry = __pyx_2;
    __pyx_2 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1740 */
    __pyx_2 = PyInt_FromLong((-1)); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1740; goto __pyx_L1;}
    Py_DECREF(__pyx_v_advance_path);
    __pyx_v_advance_path = __pyx_2;
    __pyx_2 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1741 */
    Py_INCREF(Py_None);
    Py_DECREF(__pyx_v_result);
    __pyx_v_result = Py_None;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1742 */
    __pyx_v_path_handled = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1743 */
    __pyx_1 = __pyx_v_current_entry == Py_None;
    if (__pyx_1) {
      goto __pyx_L7;
    }
    __pyx_1 = __pyx_v_current_path_info == Py_None;
    if (__pyx_1) {
      __pyx_2 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_process_entry(__pyx_v_self,__pyx_v_current_entry,__pyx_v_current_path_info); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1749; goto __pyx_L1;}
      __pyx_3 = PyObject_GetIter(__pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1749; goto __pyx_L1;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      __pyx_2 = __Pyx_UnpackItem(__pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1749; goto __pyx_L1;}
      Py_DECREF(__pyx_v_result);
      __pyx_v_result = __pyx_2;
      __pyx_2 = 0;
      __pyx_2 = __Pyx_UnpackItem(__pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1749; goto __pyx_L1;}
      Py_DECREF(__pyx_v_changed);
      __pyx_v_changed = __pyx_2;
      __pyx_2 = 0;
      if (__Pyx_EndUnpack(__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1749; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      goto __pyx_L7;
    }
    /*else*/ {

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1752 */
      __pyx_2 = __Pyx_GetItemInt(__pyx_v_current_entry, 1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1753; goto __pyx_L1;}
      __pyx_3 = __Pyx_GetItemInt(__pyx_2, __pyx_v_self->target_index); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1753; goto __pyx_L1;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      __pyx_2 = __Pyx_GetItemInt(__pyx_3, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1753; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_v_minikind = __pyx_f_21_dirstate_helpers_pyx__minikind_from_string(__pyx_2);
      Py_DECREF(__pyx_2); __pyx_2 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1754 */
      __pyx_3 = __Pyx_GetName(__pyx_b, __pyx_n_cmp); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1754; goto __pyx_L1;}
      __pyx_2 = __Pyx_GetItemInt(__pyx_v_current_path_info, 1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1754; goto __pyx_L1;}
      __pyx_4 = __Pyx_GetItemInt(__pyx_v_current_entry, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1754; goto __pyx_L1;}
      __pyx_5 = __Pyx_GetItemInt(__pyx_4, 1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1754; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1754; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_4, 0, __pyx_2);
      PyTuple_SET_ITEM(__pyx_4, 1, __pyx_5);
      __pyx_2 = 0;
      __pyx_5 = 0;
      __pyx_2 = PyObject_CallObject(__pyx_3, __pyx_4); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1754; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      __pyx_1 = PyInt_AsLong(__pyx_2); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1754; goto __pyx_L1;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      __pyx_v_cmp_result = __pyx_1;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1755 */
      __pyx_1 = __pyx_v_cmp_result;
      if (!__pyx_1) {
        __pyx_1 = (__pyx_v_minikind == 'a');
        if (!__pyx_1) {
          __pyx_1 = (__pyx_v_minikind == 'r');
        }
      }
      if (__pyx_1) {
        __pyx_1 = (__pyx_v_cmp_result < 0);
        if (__pyx_1) {
          __pyx_5 = PyInt_FromLong(0); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1767; goto __pyx_L1;}
          Py_DECREF(__pyx_v_advance_entry);
          __pyx_v_advance_entry = __pyx_5;
          __pyx_5 = 0;
          goto __pyx_L9;
        }
        /*else*/ {

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1771 */
          __pyx_3 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_process_entry(__pyx_v_self,__pyx_v_current_entry,Py_None); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1771; goto __pyx_L1;}
          __pyx_4 = PyObject_GetIter(__pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1771; goto __pyx_L1;}
          Py_DECREF(__pyx_3); __pyx_3 = 0;
          __pyx_2 = __Pyx_UnpackItem(__pyx_4); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1771; goto __pyx_L1;}
          Py_DECREF(__pyx_v_result);
          __pyx_v_result = __pyx_2;
          __pyx_2 = 0;
          __pyx_5 = __Pyx_UnpackItem(__pyx_4); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1771; goto __pyx_L1;}
          Py_DECREF(__pyx_v_changed);
          __pyx_v_changed = __pyx_5;
          __pyx_5 = 0;
          if (__Pyx_EndUnpack(__pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1771; goto __pyx_L1;}
          Py_DECREF(__pyx_4); __pyx_4 = 0;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1773 */
          __pyx_3 = PyInt_FromLong(0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1773; goto __pyx_L1;}
          Py_DECREF(__pyx_v_advance_path);
          __pyx_v_advance_path = __pyx_3;
          __pyx_3 = 0;
        }
        __pyx_L9:;
        goto __pyx_L8;
      }
      /*else*/ {

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1777 */
        __pyx_2 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_process_entry(__pyx_v_self,__pyx_v_current_entry,__pyx_v_current_path_info); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1777; goto __pyx_L1;}
        __pyx_5 = PyObject_GetIter(__pyx_2); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1777; goto __pyx_L1;}
        Py_DECREF(__pyx_2); __pyx_2 = 0;
        __pyx_4 = __Pyx_UnpackItem(__pyx_5); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1777; goto __pyx_L1;}
        Py_DECREF(__pyx_v_result);
        __pyx_v_result = __pyx_4;
        __pyx_4 = 0;
        __pyx_3 = __Pyx_UnpackItem(__pyx_5); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1777; goto __pyx_L1;}
        Py_DECREF(__pyx_v_changed);
        __pyx_v_changed = __pyx_3;
        __pyx_3 = 0;
        if (__Pyx_EndUnpack(__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1777; goto __pyx_L1;}
        Py_DECREF(__pyx_5); __pyx_5 = 0;

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1779 */
        __pyx_1 = __pyx_v_changed != Py_None;
        if (__pyx_1) {

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1780 */
          __pyx_v_path_handled = (-1);

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1781 */
          __pyx_6 = PyObject_IsTrue(__pyx_v_changed); if (__pyx_6 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1781; goto __pyx_L1;}
          __pyx_1 = (!__pyx_6);
          if (__pyx_1) {
            __pyx_1 = (!__pyx_v_self->include_unchanged);
          }
          if (__pyx_1) {
            Py_INCREF(Py_None);
            Py_DECREF(__pyx_v_changed);
            __pyx_v_changed = Py_None;
            goto __pyx_L11;
          }
          __pyx_L11:;
          goto __pyx_L10;
        }
        __pyx_L10:;
      }
      __pyx_L8:;
    }
    __pyx_L7:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1785 */
    __pyx_2 = __pyx_v_advance_entry;
    Py_INCREF(__pyx_2);
    __pyx_6 = PyObject_IsTrue(__pyx_2); if (__pyx_6 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1785; goto __pyx_L1;}
    if (__pyx_6) {
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      __pyx_1 = __pyx_v_current_entry != Py_None;
      __pyx_2 = PyInt_FromLong(__pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1785; goto __pyx_L1;}
    }
    __pyx_6 = PyObject_IsTrue(__pyx_2); if (__pyx_6 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1785; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    if (__pyx_6) {

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1786 */
      __pyx_v_self->current_block_pos = (__pyx_v_self->current_block_pos + 1);

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1787 */
      __pyx_1 = (__pyx_v_self->current_block_pos < PyList_GET_SIZE(__pyx_v_self->current_block_list));
      if (__pyx_1) {
        __pyx_4 = __Pyx_GetItemInt(__pyx_v_self->current_block_list, __pyx_v_self->current_block_pos); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1788; goto __pyx_L1;}
        Py_DECREF(__pyx_v_current_entry);
        __pyx_v_current_entry = __pyx_4;
        __pyx_4 = 0;
        goto __pyx_L13;
      }
      /*else*/ {
        Py_INCREF(Py_None);
        Py_DECREF(__pyx_v_current_entry);
        __pyx_v_current_entry = Py_None;
      }
      __pyx_L13:;
      goto __pyx_L12;
    }
    __pyx_L12:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1792 */
    __pyx_3 = __pyx_v_advance_path;
    Py_INCREF(__pyx_3);
    __pyx_6 = PyObject_IsTrue(__pyx_3); if (__pyx_6 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1792; goto __pyx_L1;}
    if (__pyx_6) {
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_1 = __pyx_v_current_path_info != Py_None;
      __pyx_3 = PyInt_FromLong(__pyx_1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1792; goto __pyx_L1;}
    }
    __pyx_6 = PyObject_IsTrue(__pyx_3); if (__pyx_6 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1792; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    if (__pyx_6) {

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1793 */
      __pyx_1 = (!__pyx_v_path_handled);
      if (__pyx_1) {

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1795 */
        __pyx_6 = __pyx_v_self->want_unversioned;
        if (__pyx_6) {

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1796 */
          __pyx_2 = __Pyx_GetName(__pyx_m, __pyx_n_stat); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1797; goto __pyx_L1;}
          __pyx_4 = PyObject_GetAttr(__pyx_2, __pyx_n_S_ISREG); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1797; goto __pyx_L1;}
          Py_DECREF(__pyx_2); __pyx_2 = 0;
          __pyx_3 = __Pyx_GetItemInt(__pyx_v_current_path_info, 3); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1797; goto __pyx_L1;}
          __pyx_2 = PyObject_GetAttr(__pyx_3, __pyx_n_st_mode); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1797; goto __pyx_L1;}
          Py_DECREF(__pyx_3); __pyx_3 = 0;
          __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1797; goto __pyx_L1;}
          PyTuple_SET_ITEM(__pyx_3, 0, __pyx_2);
          __pyx_2 = 0;
          __pyx_5 = PyObject_CallObject(__pyx_4, __pyx_3); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1797; goto __pyx_L1;}
          Py_DECREF(__pyx_4); __pyx_4 = 0;
          Py_DECREF(__pyx_3); __pyx_3 = 0;
          __pyx_1 = PyObject_IsTrue(__pyx_5); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1798; goto __pyx_L1;}
          if (__pyx_1) {
            Py_DECREF(__pyx_5); __pyx_5 = 0;
            __pyx_2 = __Pyx_GetName(__pyx_m, __pyx_n_stat); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1798; goto __pyx_L1;}
            __pyx_4 = PyObject_GetAttr(__pyx_2, __pyx_n_S_IEXEC); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1798; goto __pyx_L1;}
            Py_DECREF(__pyx_2); __pyx_2 = 0;
            __pyx_3 = __Pyx_GetItemInt(__pyx_v_current_path_info, 3); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1798; goto __pyx_L1;}
            __pyx_2 = PyObject_GetAttr(__pyx_3, __pyx_n_st_mode); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1798; goto __pyx_L1;}
            Py_DECREF(__pyx_3); __pyx_3 = 0;
            __pyx_5 = PyNumber_And(__pyx_4, __pyx_2); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1798; goto __pyx_L1;}
            Py_DECREF(__pyx_4); __pyx_4 = 0;
            Py_DECREF(__pyx_2); __pyx_2 = 0;
          }
          __pyx_6 = PyObject_IsTrue(__pyx_5); if (__pyx_6 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1796; goto __pyx_L1;}
          Py_DECREF(__pyx_5); __pyx_5 = 0;
          __pyx_3 = PyInt_FromLong(__pyx_6); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1796; goto __pyx_L1;}
          Py_DECREF(__pyx_v_new_executable);
          __pyx_v_new_executable = __pyx_3;
          __pyx_3 = 0;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1799 */
          /*try:*/ {
            __pyx_4 = __Pyx_GetItemInt(__pyx_v_current_path_info, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1800; goto __pyx_L17;}
            __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1800; goto __pyx_L17;}
            PyTuple_SET_ITEM(__pyx_2, 0, __pyx_4);
            __pyx_4 = 0;
            __pyx_5 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_2); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1800; goto __pyx_L17;}
            Py_DECREF(__pyx_2); __pyx_2 = 0;
            __pyx_3 = __Pyx_GetItemInt(__pyx_5, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1800; goto __pyx_L17;}
            Py_DECREF(__pyx_5); __pyx_5 = 0;
            Py_DECREF(__pyx_v_relpath_unicode);
            __pyx_v_relpath_unicode = __pyx_3;
            __pyx_3 = 0;
          }
          goto __pyx_L18;
          __pyx_L17:;
          Py_XDECREF(__pyx_4); __pyx_4 = 0;
          Py_XDECREF(__pyx_2); __pyx_2 = 0;
          Py_XDECREF(__pyx_5); __pyx_5 = 0;
          Py_XDECREF(__pyx_3); __pyx_3 = 0;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1801 */
          __pyx_1 = PyErr_ExceptionMatches(PyExc_UnicodeDecodeError);
          if (__pyx_1) {
            __Pyx_AddTraceback("_dirstate_helpers_pyx._loop_one_block");
            if (__Pyx_GetException(&__pyx_4, &__pyx_2, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1801; goto __pyx_L1;}
            __pyx_3 = __Pyx_GetName(__pyx_m, __pyx_n_errors); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1802; goto __pyx_L1;}
            __pyx_7 = PyObject_GetAttr(__pyx_3, __pyx_n_BadFilenameEncoding); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1802; goto __pyx_L1;}
            Py_DECREF(__pyx_3); __pyx_3 = 0;
            __pyx_3 = __Pyx_GetItemInt(__pyx_v_current_path_info, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1803; goto __pyx_L1;}
            __pyx_8 = __Pyx_GetName(__pyx_m, __pyx_n_osutils); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1803; goto __pyx_L1;}
            __pyx_9 = PyObject_GetAttr(__pyx_8, __pyx_n__fs_enc); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1803; goto __pyx_L1;}
            Py_DECREF(__pyx_8); __pyx_8 = 0;
            __pyx_8 = PyTuple_New(2); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1802; goto __pyx_L1;}
            PyTuple_SET_ITEM(__pyx_8, 0, __pyx_3);
            PyTuple_SET_ITEM(__pyx_8, 1, __pyx_9);
            __pyx_3 = 0;
            __pyx_9 = 0;
            __pyx_3 = PyObject_CallObject(__pyx_7, __pyx_8); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1802; goto __pyx_L1;}
            Py_DECREF(__pyx_7); __pyx_7 = 0;
            Py_DECREF(__pyx_8); __pyx_8 = 0;
            __Pyx_Raise(__pyx_3, 0, 0);
            Py_DECREF(__pyx_3); __pyx_3 = 0;
            {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1802; goto __pyx_L1;}
            Py_DECREF(__pyx_4); __pyx_4 = 0;
            Py_DECREF(__pyx_2); __pyx_2 = 0;
            Py_DECREF(__pyx_5); __pyx_5 = 0;
            goto __pyx_L18;
          }
          goto __pyx_L1;
          __pyx_L18:;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1804 */
          __pyx_6 = __pyx_v_changed != Py_None;
          if (__pyx_6) {
            __pyx_9 = PyNumber_Remainder(__pyx_k97p, __pyx_v_result); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1806; goto __pyx_L1;}
            __pyx_7 = PyTuple_New(1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1805; goto __pyx_L1;}
            PyTuple_SET_ITEM(__pyx_7, 0, __pyx_9);
            __pyx_9 = 0;
            __pyx_8 = PyObject_CallObject(PyExc_AssertionError, __pyx_7); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1805; goto __pyx_L1;}
            Py_DECREF(__pyx_7); __pyx_7 = 0;
            __Pyx_Raise(__pyx_8, 0, 0);
            Py_DECREF(__pyx_8); __pyx_8 = 0;
            {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1805; goto __pyx_L1;}
            goto __pyx_L19;
          }
          __pyx_L19:;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1807 */
          __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1808; goto __pyx_L1;}
          Py_INCREF(Py_None);
          PyTuple_SET_ITEM(__pyx_3, 0, Py_None);
          Py_INCREF(__pyx_v_relpath_unicode);
          PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_relpath_unicode);
          __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1810; goto __pyx_L1;}
          Py_INCREF(Py_False);
          PyTuple_SET_ITEM(__pyx_4, 0, Py_False);
          Py_INCREF(Py_False);
          PyTuple_SET_ITEM(__pyx_4, 1, Py_False);
          __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1811; goto __pyx_L1;}
          Py_INCREF(Py_None);
          PyTuple_SET_ITEM(__pyx_2, 0, Py_None);
          Py_INCREF(Py_None);
          PyTuple_SET_ITEM(__pyx_2, 1, Py_None);
          __pyx_5 = __Pyx_GetItemInt(__pyx_v_current_path_info, 1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1812; goto __pyx_L1;}
          __pyx_9 = PyTuple_New(1); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1812; goto __pyx_L1;}
          PyTuple_SET_ITEM(__pyx_9, 0, __pyx_5);
          __pyx_5 = 0;
          __pyx_7 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_9); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1812; goto __pyx_L1;}
          Py_DECREF(__pyx_9); __pyx_9 = 0;
          __pyx_8 = __Pyx_GetItemInt(__pyx_7, 0); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1812; goto __pyx_L1;}
          Py_DECREF(__pyx_7); __pyx_7 = 0;
          __pyx_5 = PyTuple_New(2); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1812; goto __pyx_L1;}
          Py_INCREF(Py_None);
          PyTuple_SET_ITEM(__pyx_5, 0, Py_None);
          PyTuple_SET_ITEM(__pyx_5, 1, __pyx_8);
          __pyx_8 = 0;
          __pyx_9 = __Pyx_GetItemInt(__pyx_v_current_path_info, 2); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1813; goto __pyx_L1;}
          __pyx_7 = PyTuple_New(2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1813; goto __pyx_L1;}
          Py_INCREF(Py_None);
          PyTuple_SET_ITEM(__pyx_7, 0, Py_None);
          PyTuple_SET_ITEM(__pyx_7, 1, __pyx_9);
          __pyx_9 = 0;
          __pyx_8 = PyTuple_New(2); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1814; goto __pyx_L1;}
          Py_INCREF(Py_None);
          PyTuple_SET_ITEM(__pyx_8, 0, Py_None);
          Py_INCREF(__pyx_v_new_executable);
          PyTuple_SET_ITEM(__pyx_8, 1, __pyx_v_new_executable);
          __pyx_9 = PyTuple_New(8); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1807; goto __pyx_L1;}
          Py_INCREF(Py_None);
          PyTuple_SET_ITEM(__pyx_9, 0, Py_None);
          PyTuple_SET_ITEM(__pyx_9, 1, __pyx_3);
          Py_INCREF(Py_True);
          PyTuple_SET_ITEM(__pyx_9, 2, Py_True);
          PyTuple_SET_ITEM(__pyx_9, 3, __pyx_4);
          PyTuple_SET_ITEM(__pyx_9, 4, __pyx_2);
          PyTuple_SET_ITEM(__pyx_9, 5, __pyx_5);
          PyTuple_SET_ITEM(__pyx_9, 6, __pyx_7);
          PyTuple_SET_ITEM(__pyx_9, 7, __pyx_8);
          __pyx_3 = 0;
          __pyx_4 = 0;
          __pyx_2 = 0;
          __pyx_5 = 0;
          __pyx_7 = 0;
          __pyx_8 = 0;
          Py_DECREF(__pyx_v_result);
          __pyx_v_result = __pyx_9;
          __pyx_9 = 0;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1815 */
          Py_INCREF(Py_True);
          Py_DECREF(__pyx_v_changed);
          __pyx_v_changed = Py_True;
          goto __pyx_L16;
        }
        __pyx_L16:;

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1818 */
        __pyx_3 = __Pyx_GetItemInt(__pyx_v_current_path_info, 2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1818; goto __pyx_L1;}
        __pyx_1 = PySequence_Contains(__pyx_n_directory, __pyx_3); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1818; goto __pyx_L1;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        if (__pyx_1) {

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1819 */
          if (PySequence_DelItem(__pyx_v_self->current_dir_list, __pyx_v_self->path_index) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1819; goto __pyx_L1;}

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1820 */
          __pyx_v_self->path_index = (__pyx_v_self->path_index - 1);
          goto __pyx_L20;
        }
        __pyx_L20:;
        goto __pyx_L15;
      }
      __pyx_L15:;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1823 */
      __pyx_4 = __Pyx_GetItemInt(__pyx_v_current_path_info, 2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1823; goto __pyx_L1;}
      if (PyObject_Cmp(__pyx_4, __pyx_k99p, &__pyx_6) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1823; goto __pyx_L1;}
      __pyx_6 = __pyx_6 == 0;
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      if (__pyx_6) {

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1824 */
        if (PySequence_DelItem(__pyx_v_self->current_dir_list, __pyx_v_self->path_index) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1824; goto __pyx_L1;}

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1825 */
        __pyx_v_self->path_index = (__pyx_v_self->path_index - 1);
        goto __pyx_L21;
      }
      __pyx_L21:;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1826 */
      __pyx_v_self->path_index = (__pyx_v_self->path_index + 1);

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1827 */
      __pyx_10 = PyObject_Length(__pyx_v_self->current_dir_list); if (__pyx_10 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1827; goto __pyx_L1;}
      __pyx_1 = (__pyx_v_self->path_index < __pyx_10);
      if (__pyx_1) {

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1828 */
        __pyx_2 = __Pyx_GetItemInt(__pyx_v_self->current_dir_list, __pyx_v_self->path_index); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1828; goto __pyx_L1;}
        Py_DECREF(__pyx_v_current_path_info);
        __pyx_v_current_path_info = __pyx_2;
        __pyx_2 = 0;

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1829 */
        __pyx_5 = __Pyx_GetItemInt(__pyx_v_current_path_info, 2); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1829; goto __pyx_L1;}
        if (PyObject_Cmp(__pyx_5, __pyx_n_directory, &__pyx_6) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1829; goto __pyx_L1;}
        __pyx_6 = __pyx_6 == 0;
        Py_DECREF(__pyx_5); __pyx_5 = 0;
        if (__pyx_6) {
          __pyx_7 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_maybe_tree_ref(__pyx_v_self,__pyx_v_current_path_info); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1830; goto __pyx_L1;}
          Py_DECREF(__pyx_v_current_path_info);
          __pyx_v_current_path_info = __pyx_7;
          __pyx_7 = 0;
          goto __pyx_L23;
        }
        __pyx_L23:;
        goto __pyx_L22;
      }
      /*else*/ {
        Py_INCREF(Py_None);
        Py_DECREF(__pyx_v_current_path_info);
        __pyx_v_current_path_info = Py_None;
      }
      __pyx_L22:;
      goto __pyx_L14;
    }
    __pyx_L14:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1834 */
    __pyx_1 = __pyx_v_changed != Py_None;
    if (__pyx_1) {

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1836 */
      __pyx_6 = PyObject_IsTrue(__pyx_v_changed); if (__pyx_6 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1836; goto __pyx_L1;}
      if (__pyx_6) {
        ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_gather_result_for_consistency(__pyx_v_self,__pyx_v_result);
        goto __pyx_L25;
      }
      __pyx_L25:;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1838 */
      __pyx_8 = __pyx_v_changed;
      Py_INCREF(__pyx_8);
      __pyx_1 = PyObject_IsTrue(__pyx_8); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1838; goto __pyx_L1;}
      if (!__pyx_1) {
        Py_DECREF(__pyx_8); __pyx_8 = 0;
        __pyx_8 = PyInt_FromLong(__pyx_v_self->include_unchanged); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1838; goto __pyx_L1;}
      }
      __pyx_6 = PyObject_IsTrue(__pyx_8); if (__pyx_6 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1838; goto __pyx_L1;}
      Py_DECREF(__pyx_8); __pyx_8 = 0;
      if (__pyx_6) {
        Py_INCREF(__pyx_v_result);
        __pyx_r = __pyx_v_result;
        goto __pyx_L0;
        goto __pyx_L26;
      }
      __pyx_L26:;
      goto __pyx_L24;
    }
    __pyx_L24:;
  }

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1840 */
  __pyx_1 = __pyx_v_self->current_block != Py_None;
  if (__pyx_1) {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1841 */
    __pyx_v_self->block_index = (__pyx_v_self->block_index + 1);

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1842 */
    ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_update_current_block(__pyx_v_self);
    goto __pyx_L27;
  }
  __pyx_L27:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1843 */
  __pyx_6 = __pyx_v_self->current_dir_info != Py_None;
  if (__pyx_6) {

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1844 */
    __pyx_v_self->path_index = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1845 */
    Py_INCREF(Py_None);
    Py_DECREF(__pyx_v_self->current_dir_list);
    __pyx_v_self->current_dir_list = Py_None;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1846 */
    /*try:*/ {

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1847 */
      __pyx_9 = PyObject_GetAttr(__pyx_v_self->dir_iterator, __pyx_n_next); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1847; goto __pyx_L29;}
      __pyx_3 = PyObject_CallObject(__pyx_9, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1847; goto __pyx_L29;}
      Py_DECREF(__pyx_9); __pyx_9 = 0;
      Py_DECREF(__pyx_v_self->current_dir_info);
      __pyx_v_self->current_dir_info = __pyx_3;
      __pyx_3 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1848 */
      __pyx_4 = __Pyx_GetItemInt(__pyx_v_self->current_dir_info, 1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1848; goto __pyx_L29;}
      Py_DECREF(__pyx_v_self->current_dir_list);
      __pyx_v_self->current_dir_list = __pyx_4;
      __pyx_4 = 0;
    }
    goto __pyx_L30;
    __pyx_L29:;
    Py_XDECREF(__pyx_2); __pyx_2 = 0;
    Py_XDECREF(__pyx_5); __pyx_5 = 0;
    Py_XDECREF(__pyx_7); __pyx_7 = 0;
    Py_XDECREF(__pyx_8); __pyx_8 = 0;
    Py_XDECREF(__pyx_9); __pyx_9 = 0;
    Py_XDECREF(__pyx_3); __pyx_3 = 0;
    Py_XDECREF(__pyx_4); __pyx_4 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1849 */
    __pyx_1 = PyErr_ExceptionMatches(PyExc_StopIteration);
    if (__pyx_1) {
      __Pyx_AddTraceback("_dirstate_helpers_pyx._loop_one_block");
      if (__Pyx_GetException(&__pyx_2, &__pyx_5, &__pyx_7) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1849; goto __pyx_L1;}
      Py_INCREF(Py_None);
      Py_DECREF(__pyx_v_self->current_dir_info);
      __pyx_v_self->current_dir_info = Py_None;
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      Py_DECREF(__pyx_5); __pyx_5 = 0;
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      goto __pyx_L30;
    }
    goto __pyx_L1;
    __pyx_L30:;
    goto __pyx_L28;
  }
  __pyx_L28:;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_5);
  Py_XDECREF(__pyx_7);
  Py_XDECREF(__pyx_8);
  Py_XDECREF(__pyx_9);
  __Pyx_AddTraceback("_dirstate_helpers_pyx.ProcessEntryC._loop_one_block");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_current_entry);
  Py_DECREF(__pyx_v_current_path_info);
  Py_DECREF(__pyx_v_disk_kind);
  Py_DECREF(__pyx_v_advance_entry);
  Py_DECREF(__pyx_v_advance_path);
  Py_DECREF(__pyx_v_result);
  Py_DECREF(__pyx_v_changed);
  Py_DECREF(__pyx_v_new_executable);
  Py_DECREF(__pyx_v_relpath_unicode);
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_n_ar;
static PyObject *__pyx_n_append;
static PyObject *__pyx_n_r;

static PyObject *__pyx_k104p;
static PyObject *__pyx_k106p;
static PyObject *__pyx_k110p;
static PyObject *__pyx_k111p;

static char __pyx_k104[] = "Missing entry for specific path parent %r, %r";
static char __pyx_k106[] = "Got entry<->path mismatch for specific path %r entry %r path_info %r ";
static char __pyx_k110[] = "";
static char __pyx_k111[] = "";

static PyObject *__pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC__next_consistent_entries(struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *__pyx_v_self) {
  PyObject *__pyx_v_results;
  PyObject *__pyx_v_path_utf8;
  PyObject *__pyx_v_path_entries;
  PyObject *__pyx_v_selected_entries;
  PyObject *__pyx_v_found_item;
  PyObject *__pyx_v_candidate_entry;
  PyObject *__pyx_v_path_info;
  PyObject *__pyx_v_entry;
  PyObject *__pyx_v_result;
  PyObject *__pyx_v_changed;
  PyObject *__pyx_v_entry_path_utf8;
  PyObject *__pyx_v_initial_key;
  PyObject *__pyx_v_block_index;
  PyObject *__pyx_v__;
  PyObject *__pyx_v_current_block;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  int __pyx_2;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  PyObject *__pyx_5 = 0;
  int __pyx_6;
  Py_ssize_t __pyx_7;
  PyObject *__pyx_8 = 0;
  Py_INCREF(__pyx_v_self);
  __pyx_v_results = Py_None; Py_INCREF(Py_None);
  __pyx_v_path_utf8 = Py_None; Py_INCREF(Py_None);
  __pyx_v_path_entries = Py_None; Py_INCREF(Py_None);
  __pyx_v_selected_entries = Py_None; Py_INCREF(Py_None);
  __pyx_v_found_item = Py_None; Py_INCREF(Py_None);
  __pyx_v_candidate_entry = Py_None; Py_INCREF(Py_None);
  __pyx_v_path_info = Py_None; Py_INCREF(Py_None);
  __pyx_v_entry = Py_None; Py_INCREF(Py_None);
  __pyx_v_result = Py_None; Py_INCREF(Py_None);
  __pyx_v_changed = Py_None; Py_INCREF(Py_None);
  __pyx_v_entry_path_utf8 = Py_None; Py_INCREF(Py_None);
  __pyx_v_initial_key = Py_None; Py_INCREF(Py_None);
  __pyx_v_block_index = Py_None; Py_INCREF(Py_None);
  __pyx_v__ = Py_None; Py_INCREF(Py_None);
  __pyx_v_current_block = Py_None; Py_INCREF(Py_None);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1857 */
  __pyx_1 = PyList_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1857; goto __pyx_L1;}
  Py_DECREF(__pyx_v_results);
  __pyx_v_results = __pyx_1;
  __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1858 */
  while (1) {
    __pyx_2 = PyObject_IsTrue(__pyx_v_self->search_specific_file_parents); if (__pyx_2 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1858; goto __pyx_L1;}
    if (!__pyx_2) break;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1862 */
    __pyx_1 = PyObject_GetAttr(__pyx_v_self->search_specific_file_parents, __pyx_n_pop); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1862; goto __pyx_L1;}
    __pyx_3 = PyObject_CallObject(__pyx_1, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1862; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_v_path_utf8);
    __pyx_v_path_utf8 = __pyx_3;
    __pyx_3 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1863 */
    __pyx_2 = PySequence_Contains(__pyx_v_self->searched_exact_paths, __pyx_v_path_utf8); if (__pyx_2 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1863; goto __pyx_L1;}
    if (__pyx_2) {
      goto __pyx_L2;
      goto __pyx_L4;
    }
    __pyx_L4:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1866 */
    __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_osutils); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1866; goto __pyx_L1;}
    __pyx_3 = PyObject_GetAttr(__pyx_1, __pyx_n_is_inside_any); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1866; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1866; goto __pyx_L1;}
    Py_INCREF(__pyx_v_self->searched_specific_files);
    PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self->searched_specific_files);
    Py_INCREF(__pyx_v_path_utf8);
    PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_path_utf8);
    __pyx_4 = PyObject_CallObject(__pyx_3, __pyx_1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1866; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_2 = PyObject_IsTrue(__pyx_4); if (__pyx_2 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1866; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    if (__pyx_2) {
      goto __pyx_L2;
      goto __pyx_L5;
    }
    __pyx_L5:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1869 */
    __pyx_3 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__entries_for_path); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1869; goto __pyx_L1;}
    __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1869; goto __pyx_L1;}
    Py_INCREF(__pyx_v_path_utf8);
    PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_path_utf8);
    __pyx_4 = PyObject_CallObject(__pyx_3, __pyx_1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1869; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_v_path_entries);
    __pyx_v_path_entries = __pyx_4;
    __pyx_4 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1874 */
    __pyx_3 = PyList_New(0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1874; goto __pyx_L1;}
    Py_DECREF(__pyx_v_selected_entries);
    __pyx_v_selected_entries = __pyx_3;
    __pyx_3 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1875 */
    Py_INCREF(Py_False);
    Py_DECREF(__pyx_v_found_item);
    __pyx_v_found_item = Py_False;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1876 */
    __pyx_1 = PyObject_GetIter(__pyx_v_path_entries); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1876; goto __pyx_L1;}
    for (;;) {
      __pyx_4 = PyIter_Next(__pyx_1);
      if (!__pyx_4) {
        if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1876; goto __pyx_L1;}
        break;
      }
      Py_DECREF(__pyx_v_candidate_entry);
      __pyx_v_candidate_entry = __pyx_4;
      __pyx_4 = 0;
      __pyx_3 = __Pyx_GetItemInt(__pyx_v_candidate_entry, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1878; goto __pyx_L1;}
      __pyx_4 = __Pyx_GetItemInt(__pyx_3, __pyx_v_self->target_index); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1878; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_3 = __Pyx_GetItemInt(__pyx_4, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1878; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      __pyx_2 = PySequence_Contains(__pyx_n_ar, __pyx_3); if (__pyx_2 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1878; goto __pyx_L1;}
      __pyx_2 = !__pyx_2;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      if (__pyx_2) {

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1879 */
        Py_INCREF(Py_True);
        Py_DECREF(__pyx_v_found_item);
        __pyx_v_found_item = Py_True;

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1880 */
        __pyx_4 = PyObject_GetAttr(__pyx_v_selected_entries, __pyx_n_append); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1880; goto __pyx_L1;}
        __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1880; goto __pyx_L1;}
        Py_INCREF(__pyx_v_candidate_entry);
        PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_candidate_entry);
        __pyx_5 = PyObject_CallObject(__pyx_4, __pyx_3); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1880; goto __pyx_L1;}
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        Py_DECREF(__pyx_5); __pyx_5 = 0;
        goto __pyx_L8;
      }
      __pyx_4 = PyInt_FromLong(__pyx_v_self->source_index); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1882; goto __pyx_L1;}
      __pyx_2 = __pyx_4 != Py_None;
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      if (__pyx_2) {
        __pyx_3 = __Pyx_GetItemInt(__pyx_v_candidate_entry, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1883; goto __pyx_L1;}
        __pyx_5 = __Pyx_GetItemInt(__pyx_3, __pyx_v_self->source_index); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1883; goto __pyx_L1;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        __pyx_4 = __Pyx_GetItemInt(__pyx_5, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1883; goto __pyx_L1;}
        Py_DECREF(__pyx_5); __pyx_5 = 0;
        __pyx_2 = PySequence_Contains(__pyx_n_ar, __pyx_4); if (__pyx_2 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1883; goto __pyx_L1;}
        __pyx_2 = !__pyx_2;
        Py_DECREF(__pyx_4); __pyx_4 = 0;
      }
      if (__pyx_2) {

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1884 */
        Py_INCREF(Py_True);
        Py_DECREF(__pyx_v_found_item);
        __pyx_v_found_item = Py_True;

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1885 */
        __pyx_3 = __Pyx_GetItemInt(__pyx_v_candidate_entry, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1885; goto __pyx_L1;}
        __pyx_5 = __Pyx_GetItemInt(__pyx_3, __pyx_v_self->target_index); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1885; goto __pyx_L1;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        __pyx_4 = __Pyx_GetItemInt(__pyx_5, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1885; goto __pyx_L1;}
        Py_DECREF(__pyx_5); __pyx_5 = 0;
        if (PyObject_Cmp(__pyx_4, __pyx_n_a, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1885; goto __pyx_L1;}
        __pyx_2 = __pyx_2 == 0;
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        if (__pyx_2) {
          __pyx_3 = PyObject_GetAttr(__pyx_v_selected_entries, __pyx_n_append); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1887; goto __pyx_L1;}
          __pyx_5 = PyTuple_New(1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1887; goto __pyx_L1;}
          Py_INCREF(__pyx_v_candidate_entry);
          PyTuple_SET_ITEM(__pyx_5, 0, __pyx_v_candidate_entry);
          __pyx_4 = PyObject_CallObject(__pyx_3, __pyx_5); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1887; goto __pyx_L1;}
          Py_DECREF(__pyx_3); __pyx_3 = 0;
          Py_DECREF(__pyx_5); __pyx_5 = 0;
          Py_DECREF(__pyx_4); __pyx_4 = 0;
          goto __pyx_L9;
        }
        /*else*/ {
          __pyx_3 = PyObject_GetAttr(__pyx_v_self->search_specific_file_parents, __pyx_n_add); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1891; goto __pyx_L1;}
          __pyx_5 = __Pyx_GetItemInt(__pyx_v_candidate_entry, 1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1892; goto __pyx_L1;}
          __pyx_4 = __Pyx_GetItemInt(__pyx_5, __pyx_v_self->target_index); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1892; goto __pyx_L1;}
          Py_DECREF(__pyx_5); __pyx_5 = 0;
          __pyx_5 = __Pyx_GetItemInt(__pyx_4, 1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1892; goto __pyx_L1;}
          Py_DECREF(__pyx_4); __pyx_4 = 0;
          __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1891; goto __pyx_L1;}
          PyTuple_SET_ITEM(__pyx_4, 0, __pyx_5);
          __pyx_5 = 0;
          __pyx_5 = PyObject_CallObject(__pyx_3, __pyx_4); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1891; goto __pyx_L1;}
          Py_DECREF(__pyx_3); __pyx_3 = 0;
          Py_DECREF(__pyx_4); __pyx_4 = 0;
          Py_DECREF(__pyx_5); __pyx_5 = 0;
        }
        __pyx_L9:;
        goto __pyx_L8;
      }
      __pyx_L8:;
    }
    Py_DECREF(__pyx_1); __pyx_1 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1893 */
    __pyx_2 = PyObject_IsTrue(__pyx_v_found_item); if (__pyx_2 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1893; goto __pyx_L1;}
    __pyx_6 = (!__pyx_2);
    if (__pyx_6) {
      __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1896; goto __pyx_L1;}
      Py_INCREF(__pyx_v_path_utf8);
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_path_utf8);
      Py_INCREF(__pyx_v_path_entries);
      PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_path_entries);
      __pyx_4 = PyNumber_Remainder(__pyx_k104p, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1895; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_5 = PyTuple_New(1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1894; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_5, 0, __pyx_4);
      __pyx_4 = 0;
      __pyx_1 = PyObject_CallObject(PyExc_AssertionError, __pyx_5); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1894; goto __pyx_L1;}
      Py_DECREF(__pyx_5); __pyx_5 = 0;
      __Pyx_Raise(__pyx_1, 0, 0);
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1894; goto __pyx_L1;}
      goto __pyx_L10;
    }
    __pyx_L10:;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1897 */
    __pyx_3 = PyObject_GetAttr(__pyx_v_path_utf8, __pyx_n_decode); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1897; goto __pyx_L1;}
    __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1897; goto __pyx_L1;}
    Py_INCREF(__pyx_n_utf8);
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_n_utf8);
    __pyx_5 = PyObject_CallObject(__pyx_3, __pyx_4); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1897; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_1 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_path_info(__pyx_v_self,__pyx_v_path_utf8,__pyx_5); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1897; goto __pyx_L1;}
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    Py_DECREF(__pyx_v_path_info);
    __pyx_v_path_info = __pyx_1;
    __pyx_1 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1898 */
    __pyx_3 = PyObject_GetIter(__pyx_v_selected_entries); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1898; goto __pyx_L1;}
    for (;;) {
      __pyx_4 = PyIter_Next(__pyx_3);
      if (!__pyx_4) {
        if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1898; goto __pyx_L1;}
        break;
      }
      Py_DECREF(__pyx_v_entry);
      __pyx_v_entry = __pyx_4;
      __pyx_4 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1899 */
      __pyx_5 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1899; goto __pyx_L1;}
      __pyx_1 = __Pyx_GetItemInt(__pyx_5, 2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1899; goto __pyx_L1;}
      Py_DECREF(__pyx_5); __pyx_5 = 0;
      __pyx_2 = PySequence_Contains(__pyx_v_self->seen_ids, __pyx_1); if (__pyx_2 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1899; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      if (__pyx_2) {
        goto __pyx_L11;
        goto __pyx_L13;
      }
      __pyx_L13:;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1901 */
      __pyx_4 = ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_process_entry(__pyx_v_self,__pyx_v_entry,__pyx_v_path_info); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1901; goto __pyx_L1;}
      __pyx_5 = PyObject_GetIter(__pyx_4); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1901; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      __pyx_1 = __Pyx_UnpackItem(__pyx_5); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1901; goto __pyx_L1;}
      Py_DECREF(__pyx_v_result);
      __pyx_v_result = __pyx_1;
      __pyx_1 = 0;
      __pyx_4 = __Pyx_UnpackItem(__pyx_5); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1901; goto __pyx_L1;}
      Py_DECREF(__pyx_v_changed);
      __pyx_v_changed = __pyx_4;
      __pyx_4 = 0;
      if (__Pyx_EndUnpack(__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1901; goto __pyx_L1;}
      Py_DECREF(__pyx_5); __pyx_5 = 0;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1902 */
      __pyx_6 = __pyx_v_changed == Py_None;
      if (__pyx_6) {
        __pyx_1 = PyTuple_New(3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1906; goto __pyx_L1;}
        Py_INCREF(__pyx_v_path_utf8);
        PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_path_utf8);
        Py_INCREF(__pyx_v_entry);
        PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_entry);
        Py_INCREF(__pyx_v_path_info);
        PyTuple_SET_ITEM(__pyx_1, 2, __pyx_v_path_info);
        __pyx_4 = PyNumber_Remainder(__pyx_k106p, __pyx_1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1905; goto __pyx_L1;}
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        __pyx_5 = PyTuple_New(1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1903; goto __pyx_L1;}
        PyTuple_SET_ITEM(__pyx_5, 0, __pyx_4);
        __pyx_4 = 0;
        __pyx_1 = PyObject_CallObject(PyExc_AssertionError, __pyx_5); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1903; goto __pyx_L1;}
        Py_DECREF(__pyx_5); __pyx_5 = 0;
        __Pyx_Raise(__pyx_1, 0, 0);
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1903; goto __pyx_L1;}
        goto __pyx_L14;
      }
      __pyx_L14:;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1909 */
      __pyx_2 = PyObject_IsTrue(__pyx_v_changed); if (__pyx_2 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1909; goto __pyx_L1;}
      if (__pyx_2) {

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1910 */
        ((struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_gather_result_for_consistency(__pyx_v_self,__pyx_v_result);

        /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1911 */
        __pyx_4 = __Pyx_GetItemInt(__pyx_v_result, 6); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1911; goto __pyx_L1;}
        __pyx_5 = __Pyx_GetItemInt(__pyx_4, 0); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1911; goto __pyx_L1;}
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        if (PyObject_Cmp(__pyx_5, __pyx_n_directory, &__pyx_6) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1911; goto __pyx_L1;}
        __pyx_6 = __pyx_6 == 0;
        Py_DECREF(__pyx_5); __pyx_5 = 0;
        if (__pyx_6) {
          __pyx_1 = __Pyx_GetItemInt(__pyx_v_result, 6); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1912; goto __pyx_L1;}
          __pyx_4 = __Pyx_GetItemInt(__pyx_1, 1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1912; goto __pyx_L1;}
          Py_DECREF(__pyx_1); __pyx_1 = 0;
          if (PyObject_Cmp(__pyx_4, __pyx_n_directory, &__pyx_6) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1912; goto __pyx_L1;}
          __pyx_6 = __pyx_6 != 0;
          Py_DECREF(__pyx_4); __pyx_4 = 0;
        }
        if (__pyx_6) {

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1915 */
          __pyx_5 = __Pyx_GetItemInt(__pyx_v_entry, 1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1915; goto __pyx_L1;}
          __pyx_1 = __Pyx_GetItemInt(__pyx_5, __pyx_v_self->source_index); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1915; goto __pyx_L1;}
          Py_DECREF(__pyx_5); __pyx_5 = 0;
          __pyx_4 = __Pyx_GetItemInt(__pyx_1, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1915; goto __pyx_L1;}
          Py_DECREF(__pyx_1); __pyx_1 = 0;
          if (PyObject_Cmp(__pyx_4, __pyx_n_r, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1915; goto __pyx_L1;}
          __pyx_2 = __pyx_2 == 0;
          Py_DECREF(__pyx_4); __pyx_4 = 0;
          if (__pyx_2) {
            __pyx_5 = __Pyx_GetItemInt(__pyx_v_entry, 1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1917; goto __pyx_L1;}
            __pyx_1 = __Pyx_GetItemInt(__pyx_5, __pyx_v_self->source_index); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1917; goto __pyx_L1;}
            Py_DECREF(__pyx_5); __pyx_5 = 0;
            __pyx_4 = __Pyx_GetItemInt(__pyx_1, 1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1917; goto __pyx_L1;}
            Py_DECREF(__pyx_1); __pyx_1 = 0;
            Py_DECREF(__pyx_v_entry_path_utf8);
            __pyx_v_entry_path_utf8 = __pyx_4;
            __pyx_4 = 0;
            goto __pyx_L17;
          }
          /*else*/ {
            Py_INCREF(__pyx_v_path_utf8);
            Py_DECREF(__pyx_v_entry_path_utf8);
            __pyx_v_entry_path_utf8 = __pyx_v_path_utf8;
          }
          __pyx_L17:;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1920 */
          __pyx_5 = PyTuple_New(3); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1920; goto __pyx_L1;}
          Py_INCREF(__pyx_v_entry_path_utf8);
          PyTuple_SET_ITEM(__pyx_5, 0, __pyx_v_entry_path_utf8);
          Py_INCREF(__pyx_k110p);
          PyTuple_SET_ITEM(__pyx_5, 1, __pyx_k110p);
          Py_INCREF(__pyx_k111p);
          PyTuple_SET_ITEM(__pyx_5, 2, __pyx_k111p);
          Py_DECREF(__pyx_v_initial_key);
          __pyx_v_initial_key = __pyx_5;
          __pyx_5 = 0;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1921 */
          __pyx_1 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__find_block_index_from_key); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1921; goto __pyx_L1;}
          __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1921; goto __pyx_L1;}
          Py_INCREF(__pyx_v_initial_key);
          PyTuple_SET_ITEM(__pyx_4, 0, __pyx_v_initial_key);
          __pyx_5 = PyObject_CallObject(__pyx_1, __pyx_4); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1921; goto __pyx_L1;}
          Py_DECREF(__pyx_1); __pyx_1 = 0;
          Py_DECREF(__pyx_4); __pyx_4 = 0;
          __pyx_1 = PyObject_GetIter(__pyx_5); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1921; goto __pyx_L1;}
          Py_DECREF(__pyx_5); __pyx_5 = 0;
          __pyx_4 = __Pyx_UnpackItem(__pyx_1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1921; goto __pyx_L1;}
          Py_DECREF(__pyx_v_block_index);
          __pyx_v_block_index = __pyx_4;
          __pyx_4 = 0;
          __pyx_5 = __Pyx_UnpackItem(__pyx_1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1921; goto __pyx_L1;}
          Py_DECREF(__pyx_v__);
          __pyx_v__ = __pyx_5;
          __pyx_5 = 0;
          if (__Pyx_EndUnpack(__pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1921; goto __pyx_L1;}
          Py_DECREF(__pyx_1); __pyx_1 = 0;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1923 */
          __pyx_4 = PyInt_FromLong(0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1923; goto __pyx_L1;}
          if (PyObject_Cmp(__pyx_v_block_index, __pyx_4, &__pyx_6) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1923; goto __pyx_L1;}
          __pyx_6 = __pyx_6 == 0;
          Py_DECREF(__pyx_4); __pyx_4 = 0;
          if (__pyx_6) {
            __pyx_5 = PyInt_FromLong(1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1925; goto __pyx_L1;}
            __pyx_1 = PyNumber_Add(__pyx_v_block_index, __pyx_5); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1925; goto __pyx_L1;}
            Py_DECREF(__pyx_5); __pyx_5 = 0;
            Py_DECREF(__pyx_v_block_index);
            __pyx_v_block_index = __pyx_1;
            __pyx_1 = 0;
            goto __pyx_L18;
          }
          __pyx_L18:;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1926 */
          Py_INCREF(Py_None);
          Py_DECREF(__pyx_v_current_block);
          __pyx_v_current_block = Py_None;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1927 */
          __pyx_4 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__dirblocks); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1927; goto __pyx_L1;}
          __pyx_7 = PyObject_Length(__pyx_4); if (__pyx_7 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1927; goto __pyx_L1;}
          Py_DECREF(__pyx_4); __pyx_4 = 0;
          __pyx_5 = PyInt_FromSsize_t(__pyx_7); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1927; goto __pyx_L1;}
          if (PyObject_Cmp(__pyx_v_block_index, __pyx_5, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1927; goto __pyx_L1;}
          __pyx_2 = __pyx_2 < 0;
          Py_DECREF(__pyx_5); __pyx_5 = 0;
          if (__pyx_2) {

            /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1928 */
            __pyx_1 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__dirblocks); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1928; goto __pyx_L1;}
            __pyx_4 = PyObject_GetItem(__pyx_1, __pyx_v_block_index); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1928; goto __pyx_L1;}
            Py_DECREF(__pyx_1); __pyx_1 = 0;
            Py_DECREF(__pyx_v_current_block);
            __pyx_v_current_block = __pyx_4;
            __pyx_4 = 0;

            /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1929 */
            __pyx_5 = __Pyx_GetName(__pyx_m, __pyx_n_osutils); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1929; goto __pyx_L1;}
            __pyx_1 = PyObject_GetAttr(__pyx_5, __pyx_n_is_inside); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1929; goto __pyx_L1;}
            Py_DECREF(__pyx_5); __pyx_5 = 0;
            __pyx_4 = __Pyx_GetItemInt(__pyx_v_current_block, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1930; goto __pyx_L1;}
            __pyx_5 = PyTuple_New(2); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1929; goto __pyx_L1;}
            Py_INCREF(__pyx_v_entry_path_utf8);
            PyTuple_SET_ITEM(__pyx_5, 0, __pyx_v_entry_path_utf8);
            PyTuple_SET_ITEM(__pyx_5, 1, __pyx_4);
            __pyx_4 = 0;
            __pyx_4 = PyObject_CallObject(__pyx_1, __pyx_5); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1929; goto __pyx_L1;}
            Py_DECREF(__pyx_1); __pyx_1 = 0;
            Py_DECREF(__pyx_5); __pyx_5 = 0;
            __pyx_6 = PyObject_IsTrue(__pyx_4); if (__pyx_6 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1929; goto __pyx_L1;}
            Py_DECREF(__pyx_4); __pyx_4 = 0;
            __pyx_2 = (!__pyx_6);
            if (__pyx_2) {
              Py_INCREF(Py_None);
              Py_DECREF(__pyx_v_current_block);
              __pyx_v_current_block = Py_None;
              goto __pyx_L20;
            }
            __pyx_L20:;
            goto __pyx_L19;
          }
          __pyx_L19:;

          /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1933 */
          __pyx_6 = __pyx_v_current_block != Py_None;
          if (__pyx_6) {
            __pyx_1 = __Pyx_GetItemInt(__pyx_v_current_block, 1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1934; goto __pyx_L1;}
            __pyx_5 = PyObject_GetIter(__pyx_1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1934; goto __pyx_L1;}
            Py_DECREF(__pyx_1); __pyx_1 = 0;
            for (;;) {
              __pyx_4 = PyIter_Next(__pyx_5);
              if (!__pyx_4) {
                if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1934; goto __pyx_L1;}
                break;
              }
              Py_DECREF(__pyx_v_entry);
              __pyx_v_entry = __pyx_4;
              __pyx_4 = 0;

              /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1935 */
              __pyx_1 = __Pyx_GetItemInt(__pyx_v_entry, 1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1935; goto __pyx_L1;}
              __pyx_4 = __Pyx_GetItemInt(__pyx_1, __pyx_v_self->source_index); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1935; goto __pyx_L1;}
              Py_DECREF(__pyx_1); __pyx_1 = 0;
              __pyx_1 = __Pyx_GetItemInt(__pyx_4, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1935; goto __pyx_L1;}
              Py_DECREF(__pyx_4); __pyx_4 = 0;
              __pyx_2 = PySequence_Contains(__pyx_n_ar, __pyx_1); if (__pyx_2 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1935; goto __pyx_L1;}
              Py_DECREF(__pyx_1); __pyx_1 = 0;
              if (__pyx_2) {
                goto __pyx_L22;
                goto __pyx_L24;
              }
              __pyx_L24:;

              /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1940 */
              __pyx_4 = PyObject_GetAttr(__pyx_v_self->search_specific_file_parents, __pyx_n_add); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1940; goto __pyx_L1;}
              __pyx_1 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1941; goto __pyx_L1;}
              __pyx_8 = PySequence_GetSlice(__pyx_1, 0, 2); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1941; goto __pyx_L1;}
              Py_DECREF(__pyx_1); __pyx_1 = 0;
              __pyx_1 = PySequence_Tuple(__pyx_8); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1941; goto __pyx_L1;}
              Py_DECREF(__pyx_8); __pyx_8 = 0;
              __pyx_8 = PyObject_CallObject(__pyx_v_self->pathjoin, __pyx_1); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1941; goto __pyx_L1;}
              Py_DECREF(__pyx_1); __pyx_1 = 0;
              __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1940; goto __pyx_L1;}
              PyTuple_SET_ITEM(__pyx_1, 0, __pyx_8);
              __pyx_8 = 0;
              __pyx_8 = PyObject_CallObject(__pyx_4, __pyx_1); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1940; goto __pyx_L1;}
              Py_DECREF(__pyx_4); __pyx_4 = 0;
              Py_DECREF(__pyx_1); __pyx_1 = 0;
              Py_DECREF(__pyx_8); __pyx_8 = 0;
              __pyx_L22:;
            }
            Py_DECREF(__pyx_5); __pyx_5 = 0;
            goto __pyx_L21;
          }
          __pyx_L21:;
          goto __pyx_L16;
        }
        __pyx_L16:;
        goto __pyx_L15;
      }
      __pyx_L15:;

      /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1942 */
      __pyx_4 = __pyx_v_changed;
      Py_INCREF(__pyx_4);
      __pyx_6 = PyObject_IsTrue(__pyx_4); if (__pyx_6 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1942; goto __pyx_L1;}
      if (!__pyx_6) {
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        __pyx_4 = PyInt_FromLong(__pyx_v_self->include_unchanged); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1942; goto __pyx_L1;}
      }
      __pyx_2 = PyObject_IsTrue(__pyx_4); if (__pyx_2 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1942; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      if (__pyx_2) {
        __pyx_1 = PyObject_GetAttr(__pyx_v_results, __pyx_n_append); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1943; goto __pyx_L1;}
        __pyx_8 = PyTuple_New(2); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1943; goto __pyx_L1;}
        Py_INCREF(__pyx_v_result);
        PyTuple_SET_ITEM(__pyx_8, 0, __pyx_v_result);
        Py_INCREF(__pyx_v_changed);
        PyTuple_SET_ITEM(__pyx_8, 1, __pyx_v_changed);
        __pyx_5 = PyTuple_New(1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1943; goto __pyx_L1;}
        PyTuple_SET_ITEM(__pyx_5, 0, __pyx_8);
        __pyx_8 = 0;
        __pyx_4 = PyObject_CallObject(__pyx_1, __pyx_5); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1943; goto __pyx_L1;}
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        Py_DECREF(__pyx_5); __pyx_5 = 0;
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        goto __pyx_L25;
      }
      __pyx_L25:;
      __pyx_L11:;
    }
    Py_DECREF(__pyx_3); __pyx_3 = 0;

    /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1944 */
    __pyx_8 = PyObject_GetAttr(__pyx_v_self->searched_exact_paths, __pyx_n_add); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1944; goto __pyx_L1;}
    __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1944; goto __pyx_L1;}
    Py_INCREF(__pyx_v_path_utf8);
    PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_path_utf8);
    __pyx_5 = PyObject_CallObject(__pyx_8, __pyx_1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1944; goto __pyx_L1;}
    Py_DECREF(__pyx_8); __pyx_8 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    __pyx_L2:;
  }

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1945 */
  Py_INCREF(__pyx_v_results);
  __pyx_r = __pyx_v_results;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_5);
  Py_XDECREF(__pyx_8);
  __Pyx_AddTraceback("_dirstate_helpers_pyx.ProcessEntryC._next_consistent_entries");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_results);
  Py_DECREF(__pyx_v_path_utf8);
  Py_DECREF(__pyx_v_path_entries);
  Py_DECREF(__pyx_v_selected_entries);
  Py_DECREF(__pyx_v_found_item);
  Py_DECREF(__pyx_v_candidate_entry);
  Py_DECREF(__pyx_v_path_info);
  Py_DECREF(__pyx_v_entry);
  Py_DECREF(__pyx_v_result);
  Py_DECREF(__pyx_v_changed);
  Py_DECREF(__pyx_v_entry_path_utf8);
  Py_DECREF(__pyx_v_initial_key);
  Py_DECREF(__pyx_v_block_index);
  Py_DECREF(__pyx_v__);
  Py_DECREF(__pyx_v_current_block);
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_n_rsplit;

static PyObject *__pyx_k113p;
static PyObject *__pyx_k115p;

static char __pyx_k113[] = "/";
static char __pyx_k115[] = "tree-reference";

static PyObject *__pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC__path_info(struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *__pyx_v_self,PyObject *__pyx_v_utf8_path,PyObject *__pyx_v_unicode_path) {
  PyObject *__pyx_v_abspath;
  PyObject *__pyx_v_stat;
  PyObject *__pyx_v_e;
  PyObject *__pyx_v_utf8_basename;
  PyObject *__pyx_v_dir_info;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  int __pyx_4;
  PyObject *__pyx_5 = 0;
  PyObject *__pyx_6 = 0;
  PyObject *__pyx_7 = 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_utf8_path);
  Py_INCREF(__pyx_v_unicode_path);
  __pyx_v_abspath = Py_None; Py_INCREF(Py_None);
  __pyx_v_stat = Py_None; Py_INCREF(Py_None);
  __pyx_v_e = Py_None; Py_INCREF(Py_None);
  __pyx_v_utf8_basename = Py_None; Py_INCREF(Py_None);
  __pyx_v_dir_info = Py_None; Py_INCREF(Py_None);

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1952 */
  __pyx_1 = PyObject_GetAttr(__pyx_v_self->tree, __pyx_n_abspath); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1952; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1952; goto __pyx_L1;}
  Py_INCREF(__pyx_v_unicode_path);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_unicode_path);
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1952; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_v_abspath);
  __pyx_v_abspath = __pyx_3;
  __pyx_3 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1953 */
  /*try:*/ {
    __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_os); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1954; goto __pyx_L2;}
    __pyx_2 = PyObject_GetAttr(__pyx_1, __pyx_n_lstat); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1954; goto __pyx_L2;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1954; goto __pyx_L2;}
    Py_INCREF(__pyx_v_abspath);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_abspath);
    __pyx_1 = PyObject_CallObject(__pyx_2, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1954; goto __pyx_L2;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_v_stat);
    __pyx_v_stat = __pyx_1;
    __pyx_1 = 0;
  }
  goto __pyx_L3;
  __pyx_L2:;
  Py_XDECREF(__pyx_2); __pyx_2 = 0;
  Py_XDECREF(__pyx_3); __pyx_3 = 0;
  Py_XDECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1955 */
  __pyx_4 = PyErr_ExceptionMatches(PyExc_OSError);
  if (__pyx_4) {
    __Pyx_AddTraceback("_dirstate_helpers_pyx._path_info");
    if (__Pyx_GetException(&__pyx_2, &__pyx_3, &__pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1955; goto __pyx_L1;}
    Py_INCREF(__pyx_3);
    Py_DECREF(__pyx_v_e);
    __pyx_v_e = __pyx_3;
    __pyx_5 = PyObject_GetAttr(__pyx_v_e, __pyx_n_errno); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1956; goto __pyx_L1;}
    __pyx_6 = __Pyx_GetName(__pyx_m, __pyx_n_errno); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1956; goto __pyx_L1;}
    __pyx_7 = PyObject_GetAttr(__pyx_6, __pyx_n_ENOENT); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1956; goto __pyx_L1;}
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    if (PyObject_Cmp(__pyx_5, __pyx_7, &__pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1956; goto __pyx_L1;}
    __pyx_4 = __pyx_4 == 0;
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    Py_DECREF(__pyx_7); __pyx_7 = 0;
    if (__pyx_4) {
      Py_INCREF(Py_None);
      __pyx_r = Py_None;
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      goto __pyx_L0;
      goto __pyx_L4;
    }
    /*else*/ {
      __Pyx_Raise(__pyx_2, __pyx_3, __pyx_1);
      {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1960; goto __pyx_L1;}
    }
    __pyx_L4:;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    goto __pyx_L3;
  }
  goto __pyx_L1;
  __pyx_L3:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1961 */
  __pyx_6 = PyObject_GetAttr(__pyx_v_utf8_path, __pyx_n_rsplit); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1961; goto __pyx_L1;}
  __pyx_5 = PyInt_FromLong(1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1961; goto __pyx_L1;}
  __pyx_7 = PyTuple_New(2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1961; goto __pyx_L1;}
  Py_INCREF(__pyx_k113p);
  PyTuple_SET_ITEM(__pyx_7, 0, __pyx_k113p);
  PyTuple_SET_ITEM(__pyx_7, 1, __pyx_5);
  __pyx_5 = 0;
  __pyx_2 = PyObject_CallObject(__pyx_6, __pyx_7); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1961; goto __pyx_L1;}
  Py_DECREF(__pyx_6); __pyx_6 = 0;
  Py_DECREF(__pyx_7); __pyx_7 = 0;
  __pyx_3 = __Pyx_GetItemInt(__pyx_2, (-1)); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1961; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_v_utf8_basename);
  __pyx_v_utf8_basename = __pyx_3;
  __pyx_3 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1962 */
  __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_osutils); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1963; goto __pyx_L1;}
  __pyx_5 = PyObject_GetAttr(__pyx_1, __pyx_n_file_kind_from_stat_mode); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1963; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_6 = PyObject_GetAttr(__pyx_v_stat, __pyx_n_st_mode); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1963; goto __pyx_L1;}
  __pyx_7 = PyTuple_New(1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1963; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_7, 0, __pyx_6);
  __pyx_6 = 0;
  __pyx_2 = PyObject_CallObject(__pyx_5, __pyx_7); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1963; goto __pyx_L1;}
  Py_DECREF(__pyx_5); __pyx_5 = 0;
  Py_DECREF(__pyx_7); __pyx_7 = 0;
  __pyx_3 = PyTuple_New(5); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1962; goto __pyx_L1;}
  Py_INCREF(__pyx_v_utf8_path);
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_utf8_path);
  Py_INCREF(__pyx_v_utf8_basename);
  PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_utf8_basename);
  PyTuple_SET_ITEM(__pyx_3, 2, __pyx_2);
  Py_INCREF(__pyx_v_stat);
  PyTuple_SET_ITEM(__pyx_3, 3, __pyx_v_stat);
  Py_INCREF(__pyx_v_abspath);
  PyTuple_SET_ITEM(__pyx_3, 4, __pyx_v_abspath);
  __pyx_2 = 0;
  Py_DECREF(__pyx_v_dir_info);
  __pyx_v_dir_info = __pyx_3;
  __pyx_3 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1965 */
  __pyx_1 = __Pyx_GetItemInt(__pyx_v_dir_info, 2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1965; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_1, __pyx_n_directory, &__pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1965; goto __pyx_L1;}
  __pyx_4 = __pyx_4 == 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  if (__pyx_4) {
    __pyx_6 = PyObject_GetAttr(__pyx_v_self->tree, __pyx_n__directory_is_tree_reference); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1966; goto __pyx_L1;}
    __pyx_5 = PyTuple_New(1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1966; goto __pyx_L1;}
    Py_INCREF(__pyx_v_unicode_path);
    PyTuple_SET_ITEM(__pyx_5, 0, __pyx_v_unicode_path);
    __pyx_7 = PyObject_CallObject(__pyx_6, __pyx_5); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1966; goto __pyx_L1;}
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    __pyx_4 = PyObject_IsTrue(__pyx_7); if (__pyx_4 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1966; goto __pyx_L1;}
    Py_DECREF(__pyx_7); __pyx_7 = 0;
    if (__pyx_4) {
      __pyx_2 = PySequence_GetSlice(__pyx_v_self->root_dir_info, 0, 2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1968; goto __pyx_L1;}
      __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1969; goto __pyx_L1;}
      Py_INCREF(__pyx_k115p);
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_k115p);
      __pyx_1 = PyNumber_Add(__pyx_2, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1968; goto __pyx_L1;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_6 = PySequence_GetSlice(__pyx_v_self->root_dir_info, 3, PY_SSIZE_T_MAX); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1969; goto __pyx_L1;}
      __pyx_5 = PyNumber_Add(__pyx_1, __pyx_6); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1969; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(__pyx_6); __pyx_6 = 0;
      Py_DECREF(__pyx_v_self->root_dir_info);
      __pyx_v_self->root_dir_info = __pyx_5;
      __pyx_5 = 0;
      goto __pyx_L6;
    }
    __pyx_L6:;
    goto __pyx_L5;
  }
  __pyx_L5:;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1970 */
  Py_INCREF(__pyx_v_dir_info);
  __pyx_r = __pyx_v_dir_info;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_5);
  Py_XDECREF(__pyx_6);
  Py_XDECREF(__pyx_7);
  __Pyx_AddTraceback("_dirstate_helpers_pyx.ProcessEntryC._path_info");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_abspath);
  Py_DECREF(__pyx_v_stat);
  Py_DECREF(__pyx_v_e);
  Py_DECREF(__pyx_v_utf8_basename);
  Py_DECREF(__pyx_v_dir_info);
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_utf8_path);
  Py_DECREF(__pyx_v_unicode_path);
  return __pyx_r;
}

static __Pyx_InternTabEntry __pyx_intern_tab[] = {
  {&__pyx_n_AttributeError, "AttributeError"},
  {&__pyx_n_BadFilenameEncoding, "BadFilenameEncoding"},
  {&__pyx_n_BzrError, "BzrError"},
  {&__pyx_n_CorruptDirstate, "CorruptDirstate"},
  {&__pyx_n_DirState, "DirState"},
  {&__pyx_n_DirstateCorrupt, "DirstateCorrupt"},
  {&__pyx_n_EINVAL, "EINVAL"},
  {&__pyx_n_ENOENT, "ENOENT"},
  {&__pyx_n_ENOTDIR, "ENOTDIR"},
  {&__pyx_n_IN_MEMORY_MODIFIED, "IN_MEMORY_MODIFIED"},
  {&__pyx_n_IN_MEMORY_UNMODIFIED, "IN_MEMORY_UNMODIFIED"},
  {&__pyx_n_NULLSTAT, "NULLSTAT"},
  {&__pyx_n_NULL_PARENT_DETAILS, "NULL_PARENT_DETAILS"},
  {&__pyx_n_S_IEXEC, "S_IEXEC"},
  {&__pyx_n_S_ISREG, "S_ISREG"},
  {&__pyx_n___ne__, "__ne__"},
  {&__pyx_n__cutoff_time, "_cutoff_time"},
  {&__pyx_n__dirblock_state, "_dirblock_state"},
  {&__pyx_n__dirblocks, "_dirblocks"},
  {&__pyx_n__directory_is_tree_reference, "_directory_is_tree_reference"},
  {&__pyx_n__encode, "_encode"},
  {&__pyx_n__end_of_header, "_end_of_header"},
  {&__pyx_n__ensure_block, "_ensure_block"},
  {&__pyx_n__entries_for_path, "_entries_for_path"},
  {&__pyx_n__filename, "_filename"},
  {&__pyx_n__find_block_index_from_key, "_find_block_index_from_key"},
  {&__pyx_n__fs_enc, "_fs_enc"},
  {&__pyx_n__get_block_entry_index, "_get_block_entry_index"},
  {&__pyx_n__get_entry, "_get_entry"},
  {&__pyx_n__is_executable, "_is_executable"},
  {&__pyx_n__num_entries, "_num_entries"},
  {&__pyx_n__num_present_parents, "_num_present_parents"},
  {&__pyx_n__observed_sha1, "_observed_sha1"},
  {&__pyx_n__parse_dirblocks, "_parse_dirblocks"},
  {&__pyx_n__read_link, "_read_link"},
  {&__pyx_n__sha1_file, "_sha1_file"},
  {&__pyx_n__sha1_provider, "_sha1_provider"},
  {&__pyx_n__sha_cutoff_time, "_sha_cutoff_time"},
  {&__pyx_n__split_root_dirblock_into_contents, "_split_root_dirblock_into_contents"},
  {&__pyx_n__state_file, "_state_file"},
  {&__pyx_n__utf8_decode, "_utf8_decode"},
  {&__pyx_n__walkdirs_utf8, "_walkdirs_utf8"},
  {&__pyx_n_a, "a"},
  {&__pyx_n_absent, "absent"},
  {&__pyx_n_abspath, "abspath"},
  {&__pyx_n_add, "add"},
  {&__pyx_n_append, "append"},
  {&__pyx_n_ar, "ar"},
  {&__pyx_n_b2a_base64, "b2a_base64"},
  {&__pyx_n_binascii, "binascii"},
  {&__pyx_n_bisect, "bisect"},
  {&__pyx_n_bisect_left, "bisect_left"},
  {&__pyx_n_bzrlib, "bzrlib"},
  {&__pyx_n_cache_utf8, "cache_utf8"},
  {&__pyx_n_cmp, "cmp"},
  {&__pyx_n_d, "d"},
  {&__pyx_n_decode, "decode"},
  {&__pyx_n_directory, "directory"},
  {&__pyx_n_encode, "encode"},
  {&__pyx_n_errno, "errno"},
  {&__pyx_n_errors, "errors"},
  {&__pyx_n_f, "f"},
  {&__pyx_n_file, "file"},
  {&__pyx_n_file_kind_from_stat_mode, "file_kind_from_stat_mode"},
  {&__pyx_n_fstat, "fstat"},
  {&__pyx_n_is_inside, "is_inside"},
  {&__pyx_n_is_inside_any, "is_inside_any"},
  {&__pyx_n_l, "l"},
  {&__pyx_n_lstat, "lstat"},
  {&__pyx_n_next, "next"},
  {&__pyx_n_os, "os"},
  {&__pyx_n_osutils, "osutils"},
  {&__pyx_n_pack, "pack"},
  {&__pyx_n_parent_directories, "parent_directories"},
  {&__pyx_n_path, "path"},
  {&__pyx_n_path_utf8, "path_utf8"},
  {&__pyx_n_pathjoin, "pathjoin"},
  {&__pyx_n_platform, "platform"},
  {&__pyx_n_pop, "pop"},
  {&__pyx_n_prefix, "prefix"},
  {&__pyx_n_r, "r"},
  {&__pyx_n_read, "read"},
  {&__pyx_n_relocated, "relocated"},
  {&__pyx_n_rsplit, "rsplit"},
  {&__pyx_n_seek, "seek"},
  {&__pyx_n_set, "set"},
  {&__pyx_n_sha_file, "sha_file"},
  {&__pyx_n_split, "split"},
  {&__pyx_n_splitpath, "splitpath"},
  {&__pyx_n_st_ctime, "st_ctime"},
  {&__pyx_n_st_dev, "st_dev"},
  {&__pyx_n_st_ino, "st_ino"},
  {&__pyx_n_st_mode, "st_mode"},
  {&__pyx_n_st_mtime, "st_mtime"},
  {&__pyx_n_st_size, "st_size"},
  {&__pyx_n_stat, "stat"},
  {&__pyx_n_stat_and_sha1, "stat_and_sha1"},
  {&__pyx_n_struct, "struct"},
  {&__pyx_n_symlink, "symlink"},
  {&__pyx_n_sys, "sys"},
  {&__pyx_n_update, "update"},
  {&__pyx_n_utf8, "utf8"},
  {&__pyx_n_win32, "win32"},
  {&__pyx_n_winerror, "winerror"},
  {0, 0}
};

static __Pyx_StringTabEntry __pyx_string_tab[] = {
  {&__pyx_k11p, __pyx_k11, sizeof(__pyx_k11)},
  {&__pyx_k13p, __pyx_k13, sizeof(__pyx_k13)},
  {&__pyx_k27p, __pyx_k27, sizeof(__pyx_k27)},
  {&__pyx_k28p, __pyx_k28, sizeof(__pyx_k28)},
  {&__pyx_k29p, __pyx_k29, sizeof(__pyx_k29)},
  {&__pyx_k30p, __pyx_k30, sizeof(__pyx_k30)},
  {&__pyx_k31p, __pyx_k31, sizeof(__pyx_k31)},
  {&__pyx_k32p, __pyx_k32, sizeof(__pyx_k32)},
  {&__pyx_k33p, __pyx_k33, sizeof(__pyx_k33)},
  {&__pyx_k36p, __pyx_k36, sizeof(__pyx_k36)},
  {&__pyx_k37p, __pyx_k37, sizeof(__pyx_k37)},
  {&__pyx_k38p, __pyx_k38, sizeof(__pyx_k38)},
  {&__pyx_k39p, __pyx_k39, sizeof(__pyx_k39)},
  {&__pyx_k40p, __pyx_k40, sizeof(__pyx_k40)},
  {&__pyx_k41p, __pyx_k41, sizeof(__pyx_k41)},
  {&__pyx_k42p, __pyx_k42, sizeof(__pyx_k42)},
  {&__pyx_k43p, __pyx_k43, sizeof(__pyx_k43)},
  {&__pyx_k44p, __pyx_k44, sizeof(__pyx_k44)},
  {&__pyx_k45p, __pyx_k45, sizeof(__pyx_k45)},
  {&__pyx_k46p, __pyx_k46, sizeof(__pyx_k46)},
  {&__pyx_k47p, __pyx_k47, sizeof(__pyx_k47)},
  {&__pyx_k48p, __pyx_k48, sizeof(__pyx_k48)},
  {&__pyx_k49p, __pyx_k49, sizeof(__pyx_k49)},
  {&__pyx_k50p, __pyx_k50, sizeof(__pyx_k50)},
  {&__pyx_k54p, __pyx_k54, sizeof(__pyx_k54)},
  {&__pyx_k56p, __pyx_k56, sizeof(__pyx_k56)},
  {&__pyx_k59p, __pyx_k59, sizeof(__pyx_k59)},
  {&__pyx_k60p, __pyx_k60, sizeof(__pyx_k60)},
  {&__pyx_k61p, __pyx_k61, sizeof(__pyx_k61)},
  {&__pyx_k62p, __pyx_k62, sizeof(__pyx_k62)},
  {&__pyx_k64p, __pyx_k64, sizeof(__pyx_k64)},
  {&__pyx_k68p, __pyx_k68, sizeof(__pyx_k68)},
  {&__pyx_k69p, __pyx_k69, sizeof(__pyx_k69)},
  {&__pyx_k72p, __pyx_k72, sizeof(__pyx_k72)},
  {&__pyx_k74p, __pyx_k74, sizeof(__pyx_k74)},
  {&__pyx_k76p, __pyx_k76, sizeof(__pyx_k76)},
  {&__pyx_k78p, __pyx_k78, sizeof(__pyx_k78)},
  {&__pyx_k80p, __pyx_k80, sizeof(__pyx_k80)},
  {&__pyx_k82p, __pyx_k82, sizeof(__pyx_k82)},
  {&__pyx_k83p, __pyx_k83, sizeof(__pyx_k83)},
  {&__pyx_k86p, __pyx_k86, sizeof(__pyx_k86)},
  {&__pyx_k87p, __pyx_k87, sizeof(__pyx_k87)},
  {&__pyx_k88p, __pyx_k88, sizeof(__pyx_k88)},
  {&__pyx_k89p, __pyx_k89, sizeof(__pyx_k89)},
  {&__pyx_k90p, __pyx_k90, sizeof(__pyx_k90)},
  {&__pyx_k92p, __pyx_k92, sizeof(__pyx_k92)},
  {&__pyx_k94p, __pyx_k94, sizeof(__pyx_k94)},
  {&__pyx_k95p, __pyx_k95, sizeof(__pyx_k95)},
  {&__pyx_k97p, __pyx_k97, sizeof(__pyx_k97)},
  {&__pyx_k99p, __pyx_k99, sizeof(__pyx_k99)},
  {&__pyx_k104p, __pyx_k104, sizeof(__pyx_k104)},
  {&__pyx_k106p, __pyx_k106, sizeof(__pyx_k106)},
  {&__pyx_k110p, __pyx_k110, sizeof(__pyx_k110)},
  {&__pyx_k111p, __pyx_k111, sizeof(__pyx_k111)},
  {&__pyx_k113p, __pyx_k113, sizeof(__pyx_k113)},
  {&__pyx_k115p, __pyx_k115, sizeof(__pyx_k115)},
  {0, 0, 0}
};
static struct __pyx_vtabstruct_21_dirstate_helpers_pyx_Reader __pyx_vtable_21_dirstate_helpers_pyx_Reader;

static PyObject *__pyx_tp_new_21_dirstate_helpers_pyx_Reader(PyTypeObject *t, PyObject *a, PyObject *k) {
  struct __pyx_obj_21_dirstate_helpers_pyx_Reader *p;
  PyObject *o = (*t->tp_alloc)(t, 0);
  if (!o) return 0;
  p = ((struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)o);
  *(struct __pyx_vtabstruct_21_dirstate_helpers_pyx_Reader **)&p->__pyx_vtab = __pyx_vtabptr_21_dirstate_helpers_pyx_Reader;
  p->state = Py_None; Py_INCREF(Py_None);
  p->text = Py_None; Py_INCREF(Py_None);
  return o;
}

static void __pyx_tp_dealloc_21_dirstate_helpers_pyx_Reader(PyObject *o) {
  struct __pyx_obj_21_dirstate_helpers_pyx_Reader *p = (struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)o;
  Py_XDECREF(p->state);
  Py_XDECREF(p->text);
  (*o->ob_type->tp_free)(o);
}

static int __pyx_tp_traverse_21_dirstate_helpers_pyx_Reader(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_21_dirstate_helpers_pyx_Reader *p = (struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)o;
  if (p->state) {
    e = (*v)(p->state, a); if (e) return e;
  }
  if (p->text) {
    e = (*v)(p->text, a); if (e) return e;
  }
  return 0;
}

static int __pyx_tp_clear_21_dirstate_helpers_pyx_Reader(PyObject *o) {
  struct __pyx_obj_21_dirstate_helpers_pyx_Reader *p = (struct __pyx_obj_21_dirstate_helpers_pyx_Reader *)o;
  PyObject *t;
  t = p->state; 
  p->state = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->text; 
  p->text = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  return 0;
}

static struct PyMethodDef __pyx_methods_21_dirstate_helpers_pyx_Reader[] = {
  {"_parse_dirblocks", (PyCFunction)__pyx_f_21_dirstate_helpers_pyx_6Reader__parse_dirblocks, METH_VARARGS|METH_KEYWORDS, __pyx_doc_21_dirstate_helpers_pyx_6Reader__parse_dirblocks},
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_Reader = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
  #if Py_TPFLAGS_DEFAULT & Py_TPFLAGS_HAVE_INDEX
  0, /*nb_index*/
  #endif
};

static PySequenceMethods __pyx_tp_as_sequence_Reader = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_Reader = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_Reader = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

PyTypeObject __pyx_type_21_dirstate_helpers_pyx_Reader = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "_dirstate_helpers_pyx.Reader", /*tp_name*/
  sizeof(struct __pyx_obj_21_dirstate_helpers_pyx_Reader), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_21_dirstate_helpers_pyx_Reader, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_Reader, /*tp_as_number*/
  &__pyx_tp_as_sequence_Reader, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_Reader, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_Reader, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC, /*tp_flags*/
  "Maintain the current location, and return fields as you parse them.", /*tp_doc*/
  __pyx_tp_traverse_21_dirstate_helpers_pyx_Reader, /*tp_traverse*/
  __pyx_tp_clear_21_dirstate_helpers_pyx_Reader, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  0, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_21_dirstate_helpers_pyx_Reader, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_21_dirstate_helpers_pyx_6Reader___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_21_dirstate_helpers_pyx_Reader, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};
static struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC __pyx_vtable_21_dirstate_helpers_pyx_ProcessEntryC;

static PyObject *__pyx_tp_new_21_dirstate_helpers_pyx_ProcessEntryC(PyTypeObject *t, PyObject *a, PyObject *k) {
  struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *p;
  PyObject *o = (*t->tp_alloc)(t, 0);
  if (!o) return 0;
  p = ((struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)o);
  *(struct __pyx_vtabstruct_21_dirstate_helpers_pyx_ProcessEntryC **)&p->__pyx_vtab = __pyx_vtabptr_21_dirstate_helpers_pyx_ProcessEntryC;
  p->old_dirname_to_file_id = Py_None; Py_INCREF(Py_None);
  p->new_dirname_to_file_id = Py_None; Py_INCREF(Py_None);
  p->last_source_parent = Py_None; Py_INCREF(Py_None);
  p->last_target_parent = Py_None; Py_INCREF(Py_None);
  p->use_filesystem_for_exec = Py_None; Py_INCREF(Py_None);
  p->utf8_decode = Py_None; Py_INCREF(Py_None);
  p->searched_specific_files = Py_None; Py_INCREF(Py_None);
  p->searched_exact_paths = Py_None; Py_INCREF(Py_None);
  p->search_specific_files = Py_None; Py_INCREF(Py_None);
  p->search_specific_file_parents = Py_None; Py_INCREF(Py_None);
  p->state = Py_None; Py_INCREF(Py_None);
  p->current_root = Py_None; Py_INCREF(Py_None);
  p->current_root_unicode = Py_None; Py_INCREF(Py_None);
  p->root_entries = Py_None; Py_INCREF(Py_None);
  p->root_abspath = Py_None; Py_INCREF(Py_None);
  p->tree = Py_None; Py_INCREF(Py_None);
  p->dir_iterator = Py_None; Py_INCREF(Py_None);
  p->current_block = Py_None; Py_INCREF(Py_None);
  p->current_block_list = Py_None; Py_INCREF(Py_None);
  p->current_dir_info = Py_None; Py_INCREF(Py_None);
  p->current_dir_list = Py_None; Py_INCREF(Py_None);
  p->_pending_consistent_entries = Py_None; Py_INCREF(Py_None);
  p->root_dir_info = Py_None; Py_INCREF(Py_None);
  p->bisect_left = Py_None; Py_INCREF(Py_None);
  p->pathjoin = Py_None; Py_INCREF(Py_None);
  p->fstat = Py_None; Py_INCREF(Py_None);
  p->seen_ids = Py_None; Py_INCREF(Py_None);
  p->sha_file = Py_None; Py_INCREF(Py_None);
  return o;
}

static void __pyx_tp_dealloc_21_dirstate_helpers_pyx_ProcessEntryC(PyObject *o) {
  struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *p = (struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)o;
  Py_XDECREF(p->old_dirname_to_file_id);
  Py_XDECREF(p->new_dirname_to_file_id);
  Py_XDECREF(p->last_source_parent);
  Py_XDECREF(p->last_target_parent);
  Py_XDECREF(p->use_filesystem_for_exec);
  Py_XDECREF(p->utf8_decode);
  Py_XDECREF(p->searched_specific_files);
  Py_XDECREF(p->searched_exact_paths);
  Py_XDECREF(p->search_specific_files);
  Py_XDECREF(p->search_specific_file_parents);
  Py_XDECREF(p->state);
  Py_XDECREF(p->current_root);
  Py_XDECREF(p->current_root_unicode);
  Py_XDECREF(p->root_entries);
  Py_XDECREF(p->root_abspath);
  Py_XDECREF(p->tree);
  Py_XDECREF(p->dir_iterator);
  Py_XDECREF(p->current_block);
  Py_XDECREF(p->current_block_list);
  Py_XDECREF(p->current_dir_info);
  Py_XDECREF(p->current_dir_list);
  Py_XDECREF(p->_pending_consistent_entries);
  Py_XDECREF(p->root_dir_info);
  Py_XDECREF(p->bisect_left);
  Py_XDECREF(p->pathjoin);
  Py_XDECREF(p->fstat);
  Py_XDECREF(p->seen_ids);
  Py_XDECREF(p->sha_file);
  (*o->ob_type->tp_free)(o);
}

static int __pyx_tp_traverse_21_dirstate_helpers_pyx_ProcessEntryC(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *p = (struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)o;
  if (p->old_dirname_to_file_id) {
    e = (*v)(p->old_dirname_to_file_id, a); if (e) return e;
  }
  if (p->new_dirname_to_file_id) {
    e = (*v)(p->new_dirname_to_file_id, a); if (e) return e;
  }
  if (p->last_source_parent) {
    e = (*v)(p->last_source_parent, a); if (e) return e;
  }
  if (p->last_target_parent) {
    e = (*v)(p->last_target_parent, a); if (e) return e;
  }
  if (p->use_filesystem_for_exec) {
    e = (*v)(p->use_filesystem_for_exec, a); if (e) return e;
  }
  if (p->utf8_decode) {
    e = (*v)(p->utf8_decode, a); if (e) return e;
  }
  if (p->searched_specific_files) {
    e = (*v)(p->searched_specific_files, a); if (e) return e;
  }
  if (p->searched_exact_paths) {
    e = (*v)(p->searched_exact_paths, a); if (e) return e;
  }
  if (p->search_specific_files) {
    e = (*v)(p->search_specific_files, a); if (e) return e;
  }
  if (p->search_specific_file_parents) {
    e = (*v)(p->search_specific_file_parents, a); if (e) return e;
  }
  if (p->state) {
    e = (*v)(p->state, a); if (e) return e;
  }
  if (p->current_root) {
    e = (*v)(p->current_root, a); if (e) return e;
  }
  if (p->current_root_unicode) {
    e = (*v)(p->current_root_unicode, a); if (e) return e;
  }
  if (p->root_entries) {
    e = (*v)(p->root_entries, a); if (e) return e;
  }
  if (p->root_abspath) {
    e = (*v)(p->root_abspath, a); if (e) return e;
  }
  if (p->tree) {
    e = (*v)(p->tree, a); if (e) return e;
  }
  if (p->dir_iterator) {
    e = (*v)(p->dir_iterator, a); if (e) return e;
  }
  if (p->current_block) {
    e = (*v)(p->current_block, a); if (e) return e;
  }
  if (p->current_block_list) {
    e = (*v)(p->current_block_list, a); if (e) return e;
  }
  if (p->current_dir_info) {
    e = (*v)(p->current_dir_info, a); if (e) return e;
  }
  if (p->current_dir_list) {
    e = (*v)(p->current_dir_list, a); if (e) return e;
  }
  if (p->_pending_consistent_entries) {
    e = (*v)(p->_pending_consistent_entries, a); if (e) return e;
  }
  if (p->root_dir_info) {
    e = (*v)(p->root_dir_info, a); if (e) return e;
  }
  if (p->bisect_left) {
    e = (*v)(p->bisect_left, a); if (e) return e;
  }
  if (p->pathjoin) {
    e = (*v)(p->pathjoin, a); if (e) return e;
  }
  if (p->fstat) {
    e = (*v)(p->fstat, a); if (e) return e;
  }
  if (p->seen_ids) {
    e = (*v)(p->seen_ids, a); if (e) return e;
  }
  if (p->sha_file) {
    e = (*v)(p->sha_file, a); if (e) return e;
  }
  return 0;
}

static int __pyx_tp_clear_21_dirstate_helpers_pyx_ProcessEntryC(PyObject *o) {
  struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *p = (struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC *)o;
  PyObject *t;
  t = p->old_dirname_to_file_id; 
  p->old_dirname_to_file_id = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->new_dirname_to_file_id; 
  p->new_dirname_to_file_id = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->last_source_parent; 
  p->last_source_parent = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->last_target_parent; 
  p->last_target_parent = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->use_filesystem_for_exec; 
  p->use_filesystem_for_exec = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->utf8_decode; 
  p->utf8_decode = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->searched_specific_files; 
  p->searched_specific_files = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->searched_exact_paths; 
  p->searched_exact_paths = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->search_specific_files; 
  p->search_specific_files = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->search_specific_file_parents; 
  p->search_specific_file_parents = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->state; 
  p->state = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->current_root; 
  p->current_root = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->current_root_unicode; 
  p->current_root_unicode = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->root_entries; 
  p->root_entries = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->root_abspath; 
  p->root_abspath = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->tree; 
  p->tree = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->dir_iterator; 
  p->dir_iterator = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->current_block; 
  p->current_block = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->current_block_list; 
  p->current_block_list = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->current_dir_info; 
  p->current_dir_info = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->current_dir_list; 
  p->current_dir_list = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->_pending_consistent_entries; 
  p->_pending_consistent_entries = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->root_dir_info; 
  p->root_dir_info = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->bisect_left; 
  p->bisect_left = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->pathjoin; 
  p->pathjoin = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->fstat; 
  p->fstat = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->seen_ids; 
  p->seen_ids = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->sha_file; 
  p->sha_file = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  return 0;
}

static struct PyMethodDef __pyx_methods_21_dirstate_helpers_pyx_ProcessEntryC[] = {
  {"iter_changes", (PyCFunction)__pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC_iter_changes, METH_VARARGS|METH_KEYWORDS, 0},
  {0, 0, 0, 0}
};

static struct PyMemberDef __pyx_members_21_dirstate_helpers_pyx_ProcessEntryC[] = {
  {"searched_specific_files", T_OBJECT, offsetof(struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC, searched_specific_files), READONLY, 0},
  {"searched_exact_paths", T_OBJECT, offsetof(struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC, searched_exact_paths), READONLY, 0},
  {0, 0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_ProcessEntryC = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
  #if Py_TPFLAGS_DEFAULT & Py_TPFLAGS_HAVE_INDEX
  0, /*nb_index*/
  #endif
};

static PySequenceMethods __pyx_tp_as_sequence_ProcessEntryC = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_ProcessEntryC = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_ProcessEntryC = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

PyTypeObject __pyx_type_21_dirstate_helpers_pyx_ProcessEntryC = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "_dirstate_helpers_pyx.ProcessEntryC", /*tp_name*/
  sizeof(struct __pyx_obj_21_dirstate_helpers_pyx_ProcessEntryC), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_21_dirstate_helpers_pyx_ProcessEntryC, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_ProcessEntryC, /*tp_as_number*/
  &__pyx_tp_as_sequence_ProcessEntryC, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_ProcessEntryC, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_ProcessEntryC, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC, /*tp_flags*/
  0, /*tp_doc*/
  __pyx_tp_traverse_21_dirstate_helpers_pyx_ProcessEntryC, /*tp_traverse*/
  __pyx_tp_clear_21_dirstate_helpers_pyx_ProcessEntryC, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  __pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC___iter__, /*tp_iter*/
  __pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC___next__, /*tp_iternext*/
  __pyx_methods_21_dirstate_helpers_pyx_ProcessEntryC, /*tp_methods*/
  __pyx_members_21_dirstate_helpers_pyx_ProcessEntryC, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_21_dirstate_helpers_pyx_ProcessEntryC, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static struct PyMethodDef __pyx_methods[] = {
  {"_py_memrchr", (PyCFunction)__pyx_f_21_dirstate_helpers_pyx__py_memrchr, METH_VARARGS|METH_KEYWORDS, __pyx_doc_21_dirstate_helpers_pyx__py_memrchr},
  {"cmp_by_dirs", (PyCFunction)__pyx_f_21_dirstate_helpers_pyx_cmp_by_dirs, METH_VARARGS|METH_KEYWORDS, __pyx_doc_21_dirstate_helpers_pyx_cmp_by_dirs},
  {"_cmp_path_by_dirblock", (PyCFunction)__pyx_f_21_dirstate_helpers_pyx__cmp_path_by_dirblock, METH_VARARGS|METH_KEYWORDS, __pyx_doc_21_dirstate_helpers_pyx__cmp_path_by_dirblock},
  {"_bisect_path_left", (PyCFunction)__pyx_f_21_dirstate_helpers_pyx__bisect_path_left, METH_VARARGS|METH_KEYWORDS, __pyx_doc_21_dirstate_helpers_pyx__bisect_path_left},
  {"_bisect_path_right", (PyCFunction)__pyx_f_21_dirstate_helpers_pyx__bisect_path_right, METH_VARARGS|METH_KEYWORDS, __pyx_doc_21_dirstate_helpers_pyx__bisect_path_right},
  {"bisect_dirblock", (PyCFunction)__pyx_f_21_dirstate_helpers_pyx_bisect_dirblock, METH_VARARGS|METH_KEYWORDS, __pyx_doc_21_dirstate_helpers_pyx_bisect_dirblock},
  {"_read_dirblocks", (PyCFunction)__pyx_f_21_dirstate_helpers_pyx__read_dirblocks, METH_VARARGS|METH_KEYWORDS, __pyx_doc_21_dirstate_helpers_pyx__read_dirblocks},
  {"update_entry", (PyCFunction)__pyx_f_21_dirstate_helpers_pyx_update_entry, METH_VARARGS|METH_KEYWORDS, __pyx_doc_21_dirstate_helpers_pyx_update_entry},
  {0, 0, 0, 0}
};

static void __pyx_init_filenames(void); /*proto*/

PyMODINIT_FUNC init_dirstate_helpers_pyx(void); /*proto*/
PyMODINIT_FUNC init_dirstate_helpers_pyx(void) {
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  __pyx_init_filenames();
  __pyx_m = Py_InitModule4("_dirstate_helpers_pyx", __pyx_methods, __pyx_mdoc, 0, PYTHON_API_VERSION);
  if (!__pyx_m) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 17; goto __pyx_L1;};
  Py_INCREF(__pyx_m);
  __pyx_b = PyImport_AddModule("__builtin__");
  if (!__pyx_b) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 17; goto __pyx_L1;};
  if (PyObject_SetAttrString(__pyx_m, "__builtins__", __pyx_b) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 17; goto __pyx_L1;};
  if (__Pyx_InternStrings(__pyx_intern_tab) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 17; goto __pyx_L1;};
  if (__Pyx_InitStrings(__pyx_string_tab) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 17; goto __pyx_L1;};
  __pyx_v_21_dirstate_helpers_pyx__kind_absent = Py_None; Py_INCREF(Py_None);
  __pyx_v_21_dirstate_helpers_pyx__kind_file = Py_None; Py_INCREF(Py_None);
  __pyx_v_21_dirstate_helpers_pyx__kind_directory = Py_None; Py_INCREF(Py_None);
  __pyx_v_21_dirstate_helpers_pyx__kind_symlink = Py_None; Py_INCREF(Py_None);
  __pyx_v_21_dirstate_helpers_pyx__kind_relocated = Py_None; Py_INCREF(Py_None);
  __pyx_v_21_dirstate_helpers_pyx__kind_tree_reference = Py_None; Py_INCREF(Py_None);
  __pyx_vtabptr_21_dirstate_helpers_pyx_Reader = &__pyx_vtable_21_dirstate_helpers_pyx_Reader;
  *(void(**)(void))&__pyx_vtable_21_dirstate_helpers_pyx_Reader.get_next = (void(*)(void))__pyx_f_21_dirstate_helpers_pyx_6Reader_get_next;
  *(void(**)(void))&__pyx_vtable_21_dirstate_helpers_pyx_Reader.get_next_str = (void(*)(void))__pyx_f_21_dirstate_helpers_pyx_6Reader_get_next_str;
  *(void(**)(void))&__pyx_vtable_21_dirstate_helpers_pyx_Reader._init = (void(*)(void))__pyx_f_21_dirstate_helpers_pyx_6Reader__init;
  *(void(**)(void))&__pyx_vtable_21_dirstate_helpers_pyx_Reader._get_entry = (void(*)(void))__pyx_f_21_dirstate_helpers_pyx_6Reader__get_entry;
  __pyx_type_21_dirstate_helpers_pyx_Reader.tp_free = _PyObject_GC_Del;
  if (PyType_Ready(&__pyx_type_21_dirstate_helpers_pyx_Reader) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 526; goto __pyx_L1;}
  if (__Pyx_SetVtable(__pyx_type_21_dirstate_helpers_pyx_Reader.tp_dict, __pyx_vtabptr_21_dirstate_helpers_pyx_Reader) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 526; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "Reader", (PyObject *)&__pyx_type_21_dirstate_helpers_pyx_Reader) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 526; goto __pyx_L1;}
  __pyx_ptype_21_dirstate_helpers_pyx_Reader = &__pyx_type_21_dirstate_helpers_pyx_Reader;
  __pyx_vtabptr_21_dirstate_helpers_pyx_ProcessEntryC = &__pyx_vtable_21_dirstate_helpers_pyx_ProcessEntryC;
  *(void(**)(void))&__pyx_vtable_21_dirstate_helpers_pyx_ProcessEntryC._process_entry = (void(*)(void))__pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC__process_entry;
  *(void(**)(void))&__pyx_vtable_21_dirstate_helpers_pyx_ProcessEntryC._gather_result_for_consistency = (void(*)(void))__pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC__gather_result_for_consistency;
  *(void(**)(void))&__pyx_vtable_21_dirstate_helpers_pyx_ProcessEntryC._update_current_block = (void(*)(void))__pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC__update_current_block;
  *(void(**)(void))&__pyx_vtable_21_dirstate_helpers_pyx_ProcessEntryC._iter_next = (void(*)(void))__pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC__iter_next;
  *(void(**)(void))&__pyx_vtable_21_dirstate_helpers_pyx_ProcessEntryC._maybe_tree_ref = (void(*)(void))__pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC__maybe_tree_ref;
  *(void(**)(void))&__pyx_vtable_21_dirstate_helpers_pyx_ProcessEntryC._loop_one_block = (void(*)(void))__pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC__loop_one_block;
  *(void(**)(void))&__pyx_vtable_21_dirstate_helpers_pyx_ProcessEntryC._next_consistent_entries = (void(*)(void))__pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC__next_consistent_entries;
  *(void(**)(void))&__pyx_vtable_21_dirstate_helpers_pyx_ProcessEntryC._path_info = (void(*)(void))__pyx_f_21_dirstate_helpers_pyx_13ProcessEntryC__path_info;
  __pyx_type_21_dirstate_helpers_pyx_ProcessEntryC.tp_free = _PyObject_GC_Del;
  if (PyType_Ready(&__pyx_type_21_dirstate_helpers_pyx_ProcessEntryC) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 964; goto __pyx_L1;}
  if (__Pyx_SetVtable(__pyx_type_21_dirstate_helpers_pyx_ProcessEntryC.tp_dict, __pyx_vtabptr_21_dirstate_helpers_pyx_ProcessEntryC) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 964; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ProcessEntryC", (PyObject *)&__pyx_type_21_dirstate_helpers_pyx_ProcessEntryC) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 964; goto __pyx_L1;}
  __pyx_ptype_21_dirstate_helpers_pyx_ProcessEntryC = &__pyx_type_21_dirstate_helpers_pyx_ProcessEntryC;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":22 */
  __pyx_1 = __Pyx_Import(__pyx_n_binascii, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 22; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_binascii, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 22; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":23 */
  __pyx_1 = __Pyx_Import(__pyx_n_bisect, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 23; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_bisect, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 23; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":24 */
  __pyx_1 = __Pyx_Import(__pyx_n_errno, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 24; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_errno, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 24; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":25 */
  __pyx_1 = __Pyx_Import(__pyx_n_os, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 25; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_os, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 25; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":26 */
  __pyx_1 = __Pyx_Import(__pyx_n_stat, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 26; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_stat, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 26; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":27 */
  __pyx_1 = __Pyx_Import(__pyx_n_sys, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 27; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_sys, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 27; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":29 */
  __pyx_1 = PyList_New(3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 29; goto __pyx_L1;}
  Py_INCREF(__pyx_n_cache_utf8);
  PyList_SET_ITEM(__pyx_1, 0, __pyx_n_cache_utf8);
  Py_INCREF(__pyx_n_errors);
  PyList_SET_ITEM(__pyx_1, 1, __pyx_n_errors);
  Py_INCREF(__pyx_n_osutils);
  PyList_SET_ITEM(__pyx_1, 2, __pyx_n_osutils);
  __pyx_2 = __Pyx_Import(__pyx_n_bzrlib, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 29; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyObject_GetAttr(__pyx_2, __pyx_n_cache_utf8); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 29; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_cache_utf8, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 29; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyObject_GetAttr(__pyx_2, __pyx_n_errors); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 29; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_errors, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 29; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyObject_GetAttr(__pyx_2, __pyx_n_osutils); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 29; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_osutils, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 29; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":30 */
  __pyx_2 = PyList_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 30; goto __pyx_L1;}
  Py_INCREF(__pyx_n_DirState);
  PyList_SET_ITEM(__pyx_2, 0, __pyx_n_DirState);
  __pyx_1 = __Pyx_Import(__pyx_k11p, __pyx_2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 30; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_2 = PyObject_GetAttr(__pyx_1, __pyx_n_DirState); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 30; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_DirState, __pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 30; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":31 */
  __pyx_1 = PyList_New(3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 31; goto __pyx_L1;}
  Py_INCREF(__pyx_n_parent_directories);
  PyList_SET_ITEM(__pyx_1, 0, __pyx_n_parent_directories);
  Py_INCREF(__pyx_n_pathjoin);
  PyList_SET_ITEM(__pyx_1, 1, __pyx_n_pathjoin);
  Py_INCREF(__pyx_n_splitpath);
  PyList_SET_ITEM(__pyx_1, 2, __pyx_n_splitpath);
  __pyx_2 = __Pyx_Import(__pyx_k13p, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 31; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyObject_GetAttr(__pyx_2, __pyx_n_parent_directories); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 31; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_parent_directories, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 31; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyObject_GetAttr(__pyx_2, __pyx_n_pathjoin); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 31; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_pathjoin, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 31; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyObject_GetAttr(__pyx_2, __pyx_n_splitpath); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 31; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_splitpath, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 31; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":39 */
  __pyx_v_21_dirstate_helpers_pyx_ERROR_PATH_NOT_FOUND = 3;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":41 */
  __pyx_v_21_dirstate_helpers_pyx_ERROR_DIRECTORY = 267;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":477 */
  __pyx_2 = PyInt_FromLong(0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 477; goto __pyx_L1;}
  __pyx_k17 = __pyx_2;
  __pyx_2 = 0;
  Py_INCREF(Py_None);
  __pyx_k18 = Py_None;
  Py_INCREF(Py_None);
  __pyx_k19 = Py_None;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":782 */
  __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_binascii); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 782; goto __pyx_L1;}
  __pyx_3 = PyObject_GetAttr(__pyx_1, __pyx_n_b2a_base64); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 782; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  if (PyObject_SetAttr(__pyx_m, __pyx_n__encode, __pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 782; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":785 */
  __pyx_1 = PyList_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 785; goto __pyx_L1;}
  Py_INCREF(__pyx_n_pack);
  PyList_SET_ITEM(__pyx_1, 0, __pyx_n_pack);
  __pyx_3 = __Pyx_Import(__pyx_n_struct, __pyx_1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 785; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyObject_GetAttr(__pyx_3, __pyx_n_pack); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 785; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_pack, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 785; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":929 */
  Py_INCREF(__pyx_n_absent);
  Py_DECREF(__pyx_v_21_dirstate_helpers_pyx__kind_absent);
  __pyx_v_21_dirstate_helpers_pyx__kind_absent = __pyx_n_absent;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":930 */
  Py_INCREF(__pyx_n_file);
  Py_DECREF(__pyx_v_21_dirstate_helpers_pyx__kind_file);
  __pyx_v_21_dirstate_helpers_pyx__kind_file = __pyx_n_file;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":931 */
  Py_INCREF(__pyx_n_directory);
  Py_DECREF(__pyx_v_21_dirstate_helpers_pyx__kind_directory);
  __pyx_v_21_dirstate_helpers_pyx__kind_directory = __pyx_n_directory;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":932 */
  Py_INCREF(__pyx_n_symlink);
  Py_DECREF(__pyx_v_21_dirstate_helpers_pyx__kind_symlink);
  __pyx_v_21_dirstate_helpers_pyx__kind_symlink = __pyx_n_symlink;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":933 */
  Py_INCREF(__pyx_n_relocated);
  Py_DECREF(__pyx_v_21_dirstate_helpers_pyx__kind_relocated);
  __pyx_v_21_dirstate_helpers_pyx__kind_relocated = __pyx_n_relocated;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":934 */
  Py_INCREF(__pyx_k27p);
  Py_DECREF(__pyx_v_21_dirstate_helpers_pyx__kind_tree_reference);
  __pyx_v_21_dirstate_helpers_pyx__kind_tree_reference = __pyx_k27p;

  /* "/home/mbp/bzr/prepare-2.0.0/bzrlib/_dirstate_helpers_pyx.pyx":1947 */
  return;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("_dirstate_helpers_pyx");
}

static char *__pyx_filenames[] = {
  "_dirstate_helpers_pyx.pyx",
};

/* Runtime support code */

static void __pyx_init_filenames(void) {
  __pyx_f = __pyx_filenames;
}

static PyObject *__Pyx_Import(PyObject *name, PyObject *from_list) {
    PyObject *__import__ = 0;
    PyObject *empty_list = 0;
    PyObject *module = 0;
    PyObject *global_dict = 0;
    PyObject *empty_dict = 0;
    PyObject *list;
    __import__ = PyObject_GetAttrString(__pyx_b, "__import__");
    if (!__import__)
        goto bad;
    if (from_list)
        list = from_list;
    else {
        empty_list = PyList_New(0);
        if (!empty_list)
            goto bad;
        list = empty_list;
    }
    global_dict = PyModule_GetDict(__pyx_m);
    if (!global_dict)
        goto bad;
    empty_dict = PyDict_New();
    if (!empty_dict)
        goto bad;
    module = PyObject_CallFunction(__import__, "OOOO",
        name, global_dict, empty_dict, list);
bad:
    Py_XDECREF(empty_list);
    Py_XDECREF(__import__);
    Py_XDECREF(empty_dict);
    return module;
}

static PyObject *__Pyx_GetName(PyObject *dict, PyObject *name) {
    PyObject *result;
    result = PyObject_GetAttr(dict, name);
    if (!result)
        PyErr_SetObject(PyExc_NameError, name);
    return result;
}

static PyObject *__Pyx_GetItemInt(PyObject *o, Py_ssize_t i) {
    PyTypeObject *t = o->ob_type;
    PyObject *r;
    if (t->tp_as_sequence && t->tp_as_sequence->sq_item)
        r = PySequence_GetItem(o, i);
    else {
        PyObject *j = PyInt_FromLong(i);
        if (!j)
            return 0;
        r = PyObject_GetItem(o, j);
        Py_DECREF(j);
    }
    return r;
}

static void __Pyx_Raise(PyObject *type, PyObject *value, PyObject *tb) {
    Py_XINCREF(type);
    Py_XINCREF(value);
    Py_XINCREF(tb);
    /* First, check the traceback argument, replacing None with NULL. */
    if (tb == Py_None) {
        Py_DECREF(tb);
        tb = 0;
    }
    else if (tb != NULL && !PyTraceBack_Check(tb)) {
        PyErr_SetString(PyExc_TypeError,
            "raise: arg 3 must be a traceback or None");
        goto raise_error;
    }
    /* Next, replace a missing value with None */
    if (value == NULL) {
        value = Py_None;
        Py_INCREF(value);
    }
    #if PY_VERSION_HEX < 0x02050000
    if (!PyClass_Check(type))
    #else
    if (!PyType_Check(type))
    #endif
    {
        /* Raising an instance.  The value should be a dummy. */
        if (value != Py_None) {
            PyErr_SetString(PyExc_TypeError,
                "instance exception may not have a separate value");
            goto raise_error;
        }
        /* Normalize to raise <class>, <instance> */
        Py_DECREF(value);
        value = type;
        #if PY_VERSION_HEX < 0x02050000
            if (PyInstance_Check(type)) {
                type = (PyObject*) ((PyInstanceObject*)type)->in_class;
                Py_INCREF(type);
            }
            else {
                PyErr_SetString(PyExc_TypeError,
                    "raise: exception must be an old-style class or instance");
                goto raise_error;
            }
        #else
            type = (PyObject*) type->ob_type;
            Py_INCREF(type);
            if (!PyType_IsSubtype((PyTypeObject *)type, (PyTypeObject *)PyExc_BaseException)) {
                PyErr_SetString(PyExc_TypeError,
                    "raise: exception class must be a subclass of BaseException");
                goto raise_error;
            }
        #endif
    }
    PyErr_Restore(type, value, tb);
    return;
raise_error:
    Py_XDECREF(value);
    Py_XDECREF(type);
    Py_XDECREF(tb);
    return;
}

static int __Pyx_SetItemInt(PyObject *o, Py_ssize_t i, PyObject *v) {
    PyTypeObject *t = o->ob_type;
    int r;
    if (t->tp_as_sequence && t->tp_as_sequence->sq_item)
        r = PySequence_SetItem(o, i, v);
    else {
        PyObject *j = PyInt_FromLong(i);
        if (!j)
            return -1;
        r = PyObject_SetItem(o, j, v);
        Py_DECREF(j);
    }
    return r;
}

static void __Pyx_UnpackError(void) {
    PyErr_SetString(PyExc_ValueError, "unpack sequence of wrong size");
}

static PyObject *__Pyx_UnpackItem(PyObject *iter) {
    PyObject *item;
    if (!(item = PyIter_Next(iter))) {
        if (!PyErr_Occurred())
            __Pyx_UnpackError();
    }
    return item;
}

static int __Pyx_EndUnpack(PyObject *iter) {
    PyObject *item;
    if ((item = PyIter_Next(iter))) {
        Py_DECREF(item);
        __Pyx_UnpackError();
        return -1;
    }
    else if (!PyErr_Occurred())
        return 0;
    else
        return -1;
}

static int __Pyx_GetException(PyObject **type, PyObject **value, PyObject **tb) {
    PyThreadState *tstate = PyThreadState_Get();
    PyErr_Fetch(type, value, tb);
    PyErr_NormalizeException(type, value, tb);
    if (PyErr_Occurred())
        goto bad;
    Py_INCREF(*type);
    Py_INCREF(*value);
    Py_INCREF(*tb);
    Py_XDECREF(tstate->exc_type);
    Py_XDECREF(tstate->exc_value);
    Py_XDECREF(tstate->exc_traceback);
    tstate->exc_type = *type;
    tstate->exc_value = *value;
    tstate->exc_traceback = *tb;
    return 0;
bad:
    Py_XDECREF(*type);
    Py_XDECREF(*value);
    Py_XDECREF(*tb);
    return -1;
}

static void __Pyx_WriteUnraisable(char *name) {
    PyObject *old_exc, *old_val, *old_tb;
    PyObject *ctx;
    PyErr_Fetch(&old_exc, &old_val, &old_tb);
    ctx = PyString_FromString(name);
    PyErr_Restore(old_exc, old_val, old_tb);
    if (!ctx)
        ctx = Py_None;
    PyErr_WriteUnraisable(ctx);
}

static int __Pyx_InternStrings(__Pyx_InternTabEntry *t) {
    while (t->p) {
        *t->p = PyString_InternFromString(t->s);
        if (!*t->p)
            return -1;
        ++t;
    }
    return 0;
}

static int __Pyx_InitStrings(__Pyx_StringTabEntry *t) {
    while (t->p) {
        *t->p = PyString_FromStringAndSize(t->s, t->n - 1);
        if (!*t->p)
            return -1;
        ++t;
    }
    return 0;
}

static int __Pyx_SetVtable(PyObject *dict, void *vtable) {
    PyObject *pycobj = 0;
    int result;
    
    pycobj = PyCObject_FromVoidPtr(vtable, 0);
    if (!pycobj)
        goto bad;
    if (PyDict_SetItemString(dict, "__pyx_vtable__", pycobj) < 0)
        goto bad;
    result = 0;
    goto done;

bad:
    result = -1;
done:
    Py_XDECREF(pycobj);
    return result;
}

#include "compile.h"
#include "frameobject.h"
#include "traceback.h"

static void __Pyx_AddTraceback(char *funcname) {
    PyObject *py_srcfile = 0;
    PyObject *py_funcname = 0;
    PyObject *py_globals = 0;
    PyObject *empty_tuple = 0;
    PyObject *empty_string = 0;
    PyCodeObject *py_code = 0;
    PyFrameObject *py_frame = 0;
    
    py_srcfile = PyString_FromString(__pyx_filename);
    if (!py_srcfile) goto bad;
    py_funcname = PyString_FromString(funcname);
    if (!py_funcname) goto bad;
    py_globals = PyModule_GetDict(__pyx_m);
    if (!py_globals) goto bad;
    empty_tuple = PyTuple_New(0);
    if (!empty_tuple) goto bad;
    empty_string = PyString_FromString("");
    if (!empty_string) goto bad;
    py_code = PyCode_New(
        0,            /*int argcount,*/
        0,            /*int nlocals,*/
        0,            /*int stacksize,*/
        0,            /*int flags,*/
        empty_string, /*PyObject *code,*/
        empty_tuple,  /*PyObject *consts,*/
        empty_tuple,  /*PyObject *names,*/
        empty_tuple,  /*PyObject *varnames,*/
        empty_tuple,  /*PyObject *freevars,*/
        empty_tuple,  /*PyObject *cellvars,*/
        py_srcfile,   /*PyObject *filename,*/
        py_funcname,  /*PyObject *name,*/
        __pyx_lineno,   /*int firstlineno,*/
        empty_string  /*PyObject *lnotab*/
    );
    if (!py_code) goto bad;
    py_frame = PyFrame_New(
        PyThreadState_Get(), /*PyThreadState *tstate,*/
        py_code,             /*PyCodeObject *code,*/
        py_globals,          /*PyObject *globals,*/
        0                    /*PyObject *locals*/
    );
    if (!py_frame) goto bad;
    py_frame->f_lineno = __pyx_lineno;
    PyTraceBack_Here(py_frame);
bad:
    Py_XDECREF(py_srcfile);
    Py_XDECREF(py_funcname);
    Py_XDECREF(empty_tuple);
    Py_XDECREF(empty_string);
    Py_XDECREF(py_code);
    Py_XDECREF(py_frame);
}
