# Written by Henrik Nilsen Omma
# (C) Canonical, Ltd. Licensed under the GPL

import re

def print_html_bug(bug, displayclues):
    text = ""
    if displayclues:
        text += "<ul>"
        for key in displayclues.keys():
            text += "<li>%s</li>" % key
            attachments_string = ""
            if displayclues[key]:
                attachments_string += "<ul>%s</ul>" % \
                        "".join(["<li><a href='%s'>%s</a></li>" % \
                                (a, a) for a in displayclues[key]])
            if attachments_string:
                text += attachments_string
        text += "</ul>"
    display = """Bug %s - %s
%s""" % (bug.bugnumber, bug.info, text)
    return re.sub(r'[Bb]ug #?([0-9]+)', r'<a href="http://launchpad.net/bugs/\1">Bug #\1</a>', display)

def print_wiki_bug(bug, displayclues):
    text = ""
    if displayclues:
        for key in displayclues.keys():
            text += """  * %s
""" % key
            if displayclues[key]:
                for a in displayclues[key]:
                    text += """   * %s
""" % a
    return """ * [http://launchpad.net/bugs/%s bug #%s] %s:
%s""" % (bug.bugnumber, bug.bugnumber, bug.info, text)

def print_plain_bug(bug, displayclues):
    text = ""
    for key in displayclues.keys():
        text += "%s\n" % key
        if displayclues[key]:
            text += "".join(["  - %s\n" % a for a in displayclues[key]])
    return "http://launchpad.net/bugs/%s %s - %s" % (bug.bugnumber, bug.info, 
                                                     text)

def print_bug(format, bug, displayclues):
    if format=="html":
        return print_html_bug(bug, displayclues)
                
    if format=="wiki":
        return print_wiki_bug(bug, displayclues)
                
    return print_plain_bug(bug, displayclues)

