# Written by Henrik Nilsen Omma
# (C) Canonical, Ltd. Licensed under the GPL

import os
import urllib

import XMLOperations
from infoFilesDefinitions import clueCondition as clueCondition
from infoFilesDefinitions import bugClue as bugClue

class InfoFiles(object):
    def __init__(self, packages_dirs):
        self.files = dict()
        self.packages_dirs = packages_dirs
        
    def add_simple_clue(self, srcpkg, condition, info):
        if not self.files.has_key(srcpkg):
            self.files[srcpkg] = InfoFile(srcpkg, self, [])
        a = set()
        a.add(clueCondition(None, None, condition, False))
        self.files[srcpkg].clues.add(bugClue(info, a))

    def get_info_file(self, srcpkg, verbosity=0):
        if not self.files.has_key(srcpkg):
            self.files[srcpkg] = InfoFile(srcpkg, self, self.packages_dirs)
            inherited_clues = self.get_inherited_clues(srcpkg, verbosity)
            self.files[srcpkg].set_inherited_clues(inherited_clues)
        return self.files[srcpkg]

    def get_inherited_clues(self, srcpkg, verbosity):
        #FIXME: Thanks Matthias Klose: fix endless recursion!
        inheritlist = set()
        srcpkginfo = self.get_info_file(srcpkg, verbosity)
        if verbosity > 0:
            verbosity -= 1
            if srcpkginfo.inherits:
                for inherit in srcpkginfo.inherits:
                    inheritobj = self.get_info_file(inherit, verbosity)
                    if inheritobj:
                        inheritlist.update(inheritobj.clues)
                        inheritlist.update(self.get_inherited_clues(inheritobj.srcpkg, \
                                                                    verbosity))
            else:
                inheritlist.update(set(self.get_info_file(srcpkg, 
                                                          verbosity).clues))
        return inheritlist
        
    def get_available_clue_files(self):
        files = set()
        for directory in self.packages_dirs:
	    if directory:
                isFile = lambda a: os.path.isfile(os.path.join(directory, a))
	        files.update(filter(isFile, os.listdir(directory)))
        getPackageName = lambda a: os.path.splitext(a)[0]
        return map(getPackageName, files)

class InfoFile(object):
    def __init__(self, srcpkg, filelist=None, packages_dirs=None):
        self.filelist = filelist
        self.srcpkg = srcpkg
        self.clues = set()
        self.inherits = set()
        self.dontlist = set()
        self.inherited_clues = set()
        filenames = [os.path.join("%s/%s.info" % (p_dir, srcpkg)) \
                            for p_dir in \
                                filter(lambda p: p!=None, packages_dirs)]
        (self.inherits, 
         self.dontlist, 
         self.clues) = XMLOperations.read_clue_files(filenames)

    def set_inherited_clues(self, inherited_clues):
        self.inherited_clues = inherited_clues
        

    def clue_matches(self, clue, text, case_sensitive=False):
        for condition in clue.conditions:
            return self.condition_matches(condition, text, case_sensitive)

    def condition_matches(self, cond, text, case_sensitive=False):
        if cond.simple_cond:
            if case_sensitive:
                res = text.count(urllib.unquote(cond.simple_cond))>0
            else:
                low_text = text.lower()
                low_cond = urllib.unquote(cond.simple_cond).lower()
                res = low_text.count(low_cond)>0
            return cond.not_cond != res
        
        if cond.and_cond:
            res = len(cond.and_cond) == \
                [self.condition_matches(n, text, case_sensitive) \
                    for n in cond.and_cond].count(True)
            return cond.not_cond != res
            
        if cond.or_cond:
            res = [self.condition_matches(n, text, case_sensitive) \
                for n in cond.or_cond].count(True) != 0
            return cond.not_cond != res

        return False

