# Written by Henrik Nilsen Omma
# (C) Canonical, Ltd. Licensed under the GPL

from optparse import OptionParser

try:
    import launchpadBugs.utils as utils
except:
    import utils as utils

class commandLine:
    def __init__(self):
        parser = OptionParser(version=utils.find_version_number())
        if parser.get_prog_name() == "bughelper":
            parser.set_defaults(attachments=False, sourcepackage=None, 
                                url=None, minbug=None, verbose=0,
                                case_sensitive=False)
            parser.set_usage(usage="""%prog --version
       %prog -p <source package> 
       %prog -l <Launchpad-URL>
Options:
    [-A]                                search in attachments too
    [-m <minimum bug number>]           only search in bugs with bug numbers 
                                        higher than <number>
    [-f <filter bugs listed>]           filter out certain bugs (also 
                                        comma-separated lists)
    [--status <status>]                 filter on given status
    [--importance <importance>]         filter on given importance
    [-v <number>]                       display inherited clues
    [-t <package> <condition> <info>]   try to find the <condition> and 
                                        display <info> when found (in addition 
                                        to stored clues)
    [-T <package> <condition> <info>]   try to find the <condition> and display 
                                        <info> when found (disregarding stored
                                        clues)
    [--format=<plain|html|wiki>]        format the output, default is plain
    [-c]                                case sensitive (off by default)
    [-U]                                also consider upstream bugs (only in 
                                        combination with -p <package>
    [-H]                                use all clue files, if a bug has no
                                        source package assigned or no clue file
                                        for that package exists""")
            parser.add_option("-p", "--package", type="string", 
                                    dest="sourcepackage", 
                                    metavar="package name", 
                                    help="Package")
            parser.add_option("-l", "--url", type="string", dest="url", 
                                    metavar="url", help="bug list URL")
            parser.add_option("-A", "--attachments", action="store_true", 
                                    dest="attachments", metavar="Attachments", 
                                    help="search attachments")
            parser.add_option("-m", "--minbug", type="int", dest="minbug",
                                    help="minimum bug number to search")
            parser.add_option("-f", "--filterbug", type="string", 
                                    dest="filterbug",
                                    help="doesn't print the bug numbers listed")
            parser.add_option("-v", "--verbose", type="int", dest="verbose",
                                    help="display inherited clues")
            parser.add_option("-t", "--try", type="string", nargs=3, 
                                    dest="try_clue", help="try clue")
            parser.add_option("-T", "--try-only", type="string", nargs=3,
                                    dest="try_only_clue", help="try only clue")
            parser.add_option("--format", type="string", dest="format", 
                                    default="plain", 
                                    help="format output type (plain|wiki|html)")
            parser.add_option("-c", "--case-sensitive", action="store_true", 
                                    dest="case_sensitive",
                                    metavar="Case Sensitive",
                                    help="case sensitive")
            parser.add_option("-U", "--upstream", action="store_true", 
                                    dest="upstream", metavar="upstream", 
                                    help="also consider upstream bugs")
            parser.add_option("-H", "--heuristic", action="store_true", 
                                    dest="heuristic", metavar="heuristic", 
                                    help="use all clue files, if no source \
package specified or no clue file exists")
            parser.add_option("--gen-config", action="store_true", 
                              dest="gen_config",
                              help="generate default config file")
            parser.add_option("--status", type="string", dest="status",
                              default="", help="status")
            parser.add_option("--importance", type="string", dest="importance",
                              default="", help="bug importance")

        if parser.get_prog_name() == "bugnumbers":
            parser.set_defaults(package=None, url=None, minbug=None)
            parser.set_usage(usage="""%prog --version
       %prog -p <package>
       %prog -l <Launchpad-URL>
Options:
    [-m <minimum bug number>]   only search in bugs with bug numbers higher 
                                than <number>
    [-f <filter bugs listed>]   filter out certain bugs (also comma-separated 
                                lists)
    [-U]                        also consider upstream bugs (only in 
                                combination with -p <package>
    [--count]                   count the number of comments
    [--stats]                   list statistical information
    [--status <status>]         filter on given status
    [--importance <importance>] filter on given importance""")
            parser.add_option("-p", "--package", type="string", 
                                    dest="sourcepackage", 
                                    metavar="package name", help="Package")
            parser.add_option("-l", "--url", type="string", dest="url", 
                                    metavar="URL", help="bug list URL")
            parser.add_option("--stats", action="store_true",
                                    dest="stats", 
                                    help="lists statistical information")
            parser.add_option("-m", "--minbug", type="int", dest="minbug",
                                    help="minimum bug number to search")
            parser.add_option("-f", "--filterbug", type="string", 
                                    dest="filterbug",
                                    help="doesn't print the bug numbers listed")
            parser.add_option("-U", "--upstream", action="store_true", 
                                    dest="upstream", metavar="upstream", 
                                    help="also consider upstream bugs")
            parser.add_option("--count", action="store_true",
                                    dest="count", 
                                    help="counts the number of comments") 
            parser.add_option("--status", type="string", dest="status",
                              default="", help="status")
            parser.add_option("--importance", type="string", dest="importance",
                              default="", help="bug importance")


        if parser.get_prog_name() == "bugxml":
            parser.set_defaults(text='', clue='', package='')
            parser.set_usage(usage="""%prog --version
       %prog -e <text>
       %prog -v <clue file>
       %prog -a <package> <condition> <clue>
Options:
 to -a <package> <condition> <clue>:
    [-d <list of bugs>]         dont list listed bugs (comma separated list or
                                simple value""")
            parser.add_option("-e", type="string", dest="text", metavar="text", 
                                    help="text")
            parser.add_option("-v", type="string", dest="cluefile", 
                                    metavar="clue", help="clue file")
            parser.add_option("-a", "--simple-add", type="string", nargs=3, 
                                     dest="add", metavar="package name", 
                                     help="Package")
            parser.add_option("-d", "--dont-list", type="string", 
                                    dest="dontlist", metavar="dontlist", 
                                    help="add a dontlist tag to XML")

        # options with arguments
        self.parser = parser
        (self.options, self.args) = parser.parse_args()

