package org.bouncycastle.cms;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;


class CounterSignatureDigestCalculator
    implements DigestCalculator
{
    private final String alg;
    private final Provider provider;
    private final byte[] data;

    CounterSignatureDigestCalculator(String alg, Provider provider, byte[] data)
    {
        this.alg = alg;
        this.provider = provider;
        this.data = data;
    }

    public byte[] getDigest()
        throws NoSuchAlgorithmException
    {
        try
        {
        MessageDigest digest = CMSSignedHelper.INSTANCE.getDigestInstance(alg, provider);

        return digest.digest(data);
        }
        catch (NoSuchProviderException e)
        {
            throw new NoSuchAlgorithmException("cannot find provider: " + e);
        }
    }
}
